/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core.autorizzazione;

import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziServizioNotFound;
import org.openspcoop2.pdd.core.AbstractCore;
import org.openspcoop2.pdd.core.autenticazione.Credenziali;
import org.openspcoop2.pdd.core.autorizzazione.EsitoAutorizzazioneCooperazione;
import org.openspcoop2.pdd.core.autorizzazione.IAutorizzazioneBuste;
import org.openspcoop2.pdd.core.connettori.InfoConnettoreIngresso;
import org.openspcoop2.protocol.registry.EsitoAutorizzazioneRegistro;
import org.openspcoop2.protocol.registry.RegistroServiziManager;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.protocol.sdk.constants.ErroriCooperazione;
import org.openspcoop2.protocol.sdk.state.IState;

public class AutorizzazioneBusteRegistro
extends AbstractCore
implements IAutorizzazioneBuste {
    @Override
    public EsitoAutorizzazioneCooperazione process(InfoConnettoreIngresso infoConnettoreIngresso, Credenziali credenzialiPdDMittente, String identitaServizioApplicativoFruitore, String subjectServizioApplicativoFruitoreFromMessageSecurityHeader, IDSoggetto soggetto, IDServizio servizio, IState state) {
        EsitoAutorizzazioneCooperazione esito = new EsitoAutorizzazioneCooperazione();
        try {
            EsitoAutorizzazioneRegistro esitoAutorizzazione;
            RegistroServiziManager reg = RegistroServiziManager.getInstance((IState[])new IState[]{state});
            String pdd = null;
            if (credenzialiPdDMittente != null && credenzialiPdDMittente.getSubject() != null) {
                pdd = credenzialiPdDMittente.getSubject();
            }
            if (!(esitoAutorizzazione = reg.isFruitoreServizioAutorizzato(pdd, identitaServizioApplicativoFruitore, soggetto, servizio)).isServizioAutorizzato()) {
                String errore = "Il soggetto " + soggetto.getTipo() + "/" + soggetto.getNome() + " non e' autorizzato ad invocare il servizio " + servizio.getTipoServizio() + "/" + servizio.getServizio() + " erogato da " + servizio.getSoggettoErogatore().getTipo() + "/" + servizio.getSoggettoErogatore().getNome();
                if (esitoAutorizzazione.getDetails() != null) {
                    errore = errore + " (" + esitoAutorizzazione.getDetails() + ")";
                }
                esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA_AUTORIZZAZIONE_FALLITA));
                esito.setServizioAutorizzato(false);
            } else {
                esito.setServizioAutorizzato(true);
                if (esitoAutorizzazione.getDetails() != null) {
                    esito.setDetails(esitoAutorizzazione.getDetails());
                }
            }
        }
        catch (DriverRegistroServiziServizioNotFound e) {
            esito.setErroreCooperazione(ErroriCooperazione.SERVIZIO_SCONOSCIUTO.getErroreCooperazione("Errore durante il processo di autorizzazione (ServizioNotFound): " + e.getMessage()));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento((Exception)((Object)e));
        }
        catch (Exception e) {
            String errore = "Errore durante il processo di autorizzazione: " + e.getMessage();
            esito.setErroreCooperazione(ErroriCooperazione.AUTORIZZAZIONE_FALLITA.getErroreAutorizzazione(errore, CodiceErroreCooperazione.SICUREZZA));
            esito.setServizioAutorizzato(false);
            esito.setEccezioneProcessamento(e);
        }
        return esito;
    }
}

