/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public class PdDContext
implements Serializable {
    private static final long serialVersionUID = -2577197242840238762L;
    private Hashtable<String, Object> ctx = new Hashtable();

    public void addObject(String key, Object o) {
        if (key != null && o != null) {
            this.ctx.put(key, o);
        }
    }

    public Object getObject(String key) {
        if (key != null) {
            return this.ctx.get(key);
        }
        return null;
    }

    public Object removeObject(String key) {
        if (key != null) {
            return this.ctx.remove(key);
        }
        return null;
    }

    public Enumeration<String> keys() {
        return this.ctx.keys();
    }

    public boolean containsKey(String key) {
        return this.ctx.containsKey(key);
    }

    public void addAll(PdDContext pddContext, boolean overwriteIfExists) {
        Enumeration<String> keys = pddContext.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.containsKey(key)) {
                if (!overwriteIfExists) continue;
                this.removeObject(key);
                this.addObject(key, pddContext.getObject(key));
                continue;
            }
            this.addObject(key, pddContext.getObject(key));
        }
    }

    public static String getValue(String key, PdDContext pddContext) {
        Object o;
        String value = null;
        if (pddContext != null && (o = pddContext.getObject(key)) != null && o instanceof String) {
            value = (String)o;
        }
        return value;
    }
}

