/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.pdd.config.MTOMProcessorConfig;
import org.openspcoop2.pdd.config.MessageSecurityConfig;
import org.openspcoop2.protocol.sdk.constants.TipoTraccia;

public class MTOMProcessor {
    private MTOMProcessorConfig config;
    private MessageSecurityConfig secConfig;
    private TipoPdD tipoPdD;

    public MTOMProcessor(MTOMProcessorConfig config, MessageSecurityConfig secConfig, TipoPdD tipoPdD) {
        this.config = config;
        this.secConfig = secConfig;
        this.tipoPdD = tipoPdD;
    }

    public MTOMProcessorType getMTOMProcessorType() {
        if (this.config != null) {
            return this.config.getMtomProcessorType();
        }
        return null;
    }

    public void mtomBeforeSecurity(OpenSPCoop2Message msg, TipoTraccia tipo) throws Exception {
        if (this.isEngineEnabled() && this.isMTOMBeforeSecurity(tipo)) {
            this.mtomApply(msg);
        }
    }

    public void mtomAfterSecurity(OpenSPCoop2Message msg, TipoTraccia tipo) throws Exception {
        if (this.isEngineEnabled() && !this.isMTOMBeforeSecurity(tipo)) {
            this.mtomApply(msg);
        }
    }

    private void mtomApply(OpenSPCoop2Message msg) throws Exception {
        switch (this.config.getMtomProcessorType()) {
            case PACKAGING: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomPackaging(this.config.getInfo());
                break;
            }
            case UNPACKAGING: {
                msg.mtomUnpackaging();
                break;
            }
            case VERIFY: {
                if (this.config.getInfo() == null || this.config.getInfo().size() <= 0) break;
                msg.mtomVerify(this.config.getInfo());
                break;
            }
        }
    }

    private boolean isMTOMBeforeSecurity(TipoTraccia tipoTraccia) throws Exception {
        MTOMProcessorType processorType = null;
        processorType = this.config != null && this.config.getMtomProcessorType() != null ? this.config.getMtomProcessorType() : MTOMProcessorType.DISABLE;
        Boolean applyToMtom = null;
        if (this.secConfig != null && this.secConfig.getApplyToMtom() != null) {
            applyToMtom = this.secConfig.getApplyToMtom();
        }
        switch (this.tipoPdD) {
            case DELEGATA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Delegata.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.richiesta.[" + processorType + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Delegata.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Delegata.risposta.[" + processorType + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + tipoTraccia + "] in Delegata.risposta");
            }
            case APPLICATIVA: {
                switch (tipoTraccia) {
                    case RICHIESTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Applicativa.richiesta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return true;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.richiesta.[" + processorType + "]");
                    }
                    case RISPOSTA: {
                        switch (processorType) {
                            case DISABLE: {
                                throw new Exception("Caso non previsto [" + processorType + "] Applicativa.risposta.disabile");
                            }
                            case PACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom != false;
                            }
                            case UNPACKAGING: {
                                if (applyToMtom == null) {
                                    return false;
                                }
                                return applyToMtom == false;
                            }
                            case VERIFY: {
                                return true;
                            }
                        }
                        throw new Exception("Caso non previsto Applicativa.risposta.[" + processorType + "]");
                    }
                }
                throw new Exception("Tipo non gestito [" + tipoTraccia + "] in Applicativa.risposta");
            }
        }
        throw new Exception("RuoloPdD[" + this.tipoPdD + "] non gestito");
    }

    private boolean isEngineEnabled() {
        if (!TipoPdD.DELEGATA.equals(this.tipoPdD) && !TipoPdD.APPLICATIVA.equals(this.tipoPdD)) {
            return false;
        }
        return this.config != null && this.config.getMtomProcessorType() != null && !MTOMProcessorType.DISABLE.equals(this.config.getMtomProcessorType());
    }
}

