/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.Serializable;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import org.apache.log4j.Logger;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.JMSObject;
import org.openspcoop2.pdd.config.QueueManager;
import org.openspcoop2.pdd.config.Resource;

public class JMSReceiver {
    private QueueManager qmanager;
    private String idModulo = null;
    private IDSoggetto codicePorta = null;
    private Object received;
    private Hashtable<String, Serializable> propertiesReceived;
    private String errore;
    private String idHeaderJMS;
    private boolean singleConnection;
    private Logger log;
    private String idTransazione;

    public JMSReceiver(IDSoggetto aCodicePorta, String aIDModulo, boolean singleConnection, Logger log, String idTransazione) throws Exception {
        this.codicePorta = aCodicePorta;
        this.idModulo = "JMSReceiver." + aIDModulo;
        this.singleConnection = singleConnection;
        this.qmanager = QueueManager.getInstance();
        this.log = log;
        this.idTransazione = idTransazione;
    }

    public boolean clean(String destinatario, String msgSelector) {
        return this.receive(destinatario, msgSelector, 1L, 1L);
    }

    public boolean receive(String destinatario, long timeout, long checkInterval) {
        return this.receive(destinatario, null, timeout, checkInterval);
    }

    public boolean receive(String destinatario, String msgSelector, long timeout, long checkInterval) {
        Resource resource = null;
        MessageConsumer receiver = null;
        try {
            JMSObject jmsObject = null;
            try {
                resource = this.qmanager.getResource(this.codicePorta, this.idModulo, this.idTransazione);
                if (resource == null) {
                    throw new JMSException("Resource is null");
                }
                if (resource.getResource() == null) {
                    throw new JMSException("JMSObject is null");
                }
                jmsObject = (JMSObject)resource.getResource();
                if (jmsObject.getConnection() == null) {
                    throw new Exception("Connessione is null");
                }
                if (jmsObject.getSession() == null) {
                    throw new Exception("Sessione is null");
                }
            }
            catch (Exception e) {
                this.log.error((Object)("JMSObject non ottenibile dal Pool: " + e.getMessage()), (Throwable)e);
                this.errore = "JMSObject non ottenibile dal Pool: " + e.getMessage();
                return false;
            }
            if (destinatario == null) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                return false;
            }
            Queue queue = this.qmanager.getQueue(destinatario);
            if (queue == null) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.errore = "La coda [" + destinatario + "] non e' tra quelle registrate per OpenSPCoop";
                return false;
            }
            try {
                jmsObject.getConnection().start();
            }
            catch (JMSException e) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.errore = "Riscontrato errore durante lo start della connessione [" + destinatario + "] :" + e.getMessage();
                return false;
            }
            try {
                receiver = msgSelector != null ? jmsObject.getSession().createConsumer((Destination)queue, msgSelector) : jmsObject.getSession().createConsumer((Destination)queue);
            }
            catch (JMSException e) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.log.error((Object)("Riscontrato errore durante la creazione del receiver [" + destinatario + "] :" + e.getMessage()), (Throwable)e);
                this.errore = "Riscontrato errore durante la creazione del receiver [" + destinatario + "] :" + e.getMessage();
                return false;
            }
            ObjectMessage receivedMsg = null;
            for (long attesa = 0L; attesa < timeout; attesa += checkInterval) {
                receivedMsg = (ObjectMessage)receiver.receive(checkInterval);
                attesa += checkInterval;
                if (receivedMsg != null) break;
                if (!this.singleConnection) {
                    receiver.close();
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                }
                try {
                    Thread.sleep(checkInterval);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (this.singleConnection) continue;
                try {
                    resource = this.qmanager.getResource(this.codicePorta, this.idModulo, this.idTransazione);
                    if (resource == null) {
                        throw new JMSException("Resource is null");
                    }
                    if (resource.getResource() == null) {
                        throw new JMSException("JMSObject is null");
                    }
                    jmsObject = (JMSObject)resource.getResource();
                }
                catch (Exception e) {
                    this.log.error((Object)("JMSObject non ottenibile dal Pool: " + e.getMessage()), (Throwable)e);
                    this.errore = "JMSObject non ottenibile dal Pool: " + e.getMessage();
                    return false;
                }
                try {
                    jmsObject.getConnection().start();
                }
                catch (JMSException e) {
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                    this.log.error((Object)("Riscontrato errore durante lo start della connessione [" + destinatario + "] :" + e.getMessage()), (Throwable)e);
                    this.errore = "Riscontrato errore durante lo start della connessione [" + destinatario + "] :" + e.getMessage();
                    return false;
                }
                try {
                    if (msgSelector != null) {
                        receiver = jmsObject.getSession().createConsumer((Destination)queue, msgSelector);
                        continue;
                    }
                    receiver = jmsObject.getSession().createConsumer((Destination)queue);
                    continue;
                }
                catch (JMSException e) {
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                    this.log.error((Object)("Riscontrato errore durante la creazione del receiver [" + destinatario + "] :" + e.getMessage()), (Throwable)e);
                    this.errore = "Riscontrato errore durante la creazione del receiver [" + destinatario + "] :" + e.getMessage();
                    return false;
                }
            }
            if (receivedMsg == null) {
                this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                this.errore = "Riscontrato errore durante ricezione del messaggio: Messaggio non ricevuto";
                receiver.close();
                return false;
            }
            this.received = receivedMsg.getObject();
            this.idHeaderJMS = receivedMsg.getJMSMessageID();
            this.propertiesReceived = new Hashtable();
            try {
                String idMessaggio = receivedMsg.getStringProperty("ID");
                this.propertiesReceived.put("ID", (Serializable)((Object)idMessaggio));
            }
            catch (JMSException e) {
                // empty catch block
            }
            try {
                boolean contenutoRisposta = receivedMsg.getBooleanProperty("ContenutoRispostaPresente");
                this.propertiesReceived.put("ContenutoRispostaPresente", new Boolean(contenutoRisposta));
            }
            catch (JMSException e) {
                // empty catch block
            }
            receiver.close();
            this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
            return true;
        }
        catch (Exception e) {
            try {
                if (receiver != null) {
                    receiver.close();
                }
            }
            catch (Exception eClose) {
                // empty catch block
            }
            if (resource != null) {
                try {
                    this.qmanager.releaseResource(this.codicePorta, this.idModulo, resource);
                }
                catch (Exception eClose) {
                    // empty catch block
                }
            }
            this.log.error((Object)("Riscontrato errore durante la ricezione da una coda :" + e.getMessage()), (Throwable)e);
            this.errore = "Riscontrato errore durante la ricezione da una coda :" + e.getMessage();
            return false;
        }
    }

    public String getErrore() {
        return this.errore;
    }

    public Object getObjectReceived() {
        return this.received;
    }

    public Hashtable<String, Serializable> getPropertiesReceived() {
        return this.propertiesReceived;
    }

    public String getIdHeaderJMS() {
        return this.idHeaderJMS;
    }
}

