/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import org.apache.log4j.Logger;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigurazionePdDManager;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.config.RichiestaDelegata;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.state.IState;

public class IdentificazionePortaDelegata {
    private String location;
    private String urlCompleta;
    private String nomePDIndivituata;
    private boolean nomePortaDelegataURLBased = true;
    private PortaDelegata pd = null;
    private ErroreIntegrazione erroreIntegrazione;
    private IDSoggetto soggetto;
    private String tipoAutenticazione;
    private String tipoAutorizzazione;
    private String tipoAutorizzazioneContenuto;
    private IProtocolFactory protocolFactory = null;
    private Logger log;

    public IdentificazionePortaDelegata(URLProtocolContext urlProtocolContext, IProtocolFactory protocolFactory) {
        this.location = urlProtocolContext.getFunctionParameters();
        this.urlCompleta = urlProtocolContext.getUrlInvocazione_formBased();
        this.log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
        this.nomePortaDelegataURLBased = "IntegrationManager".equals(urlProtocolContext.getFunction()) ? OpenSPCoop2Properties.getInstance().integrationManager_isNomePortaDelegataUrlBased() : true;
        this.protocolFactory = protocolFactory;
    }

    public boolean process(IState state) {
        try {
            if (this.location == null || "".equals(this.location)) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("nella url di invocazione alla Porta di Dominio non e' stata fornita il nome di una PD");
                return false;
            }
            ConfigurazionePdDManager configurazionePdDReader = ConfigurazionePdDManager.getInstance(state);
            if (this.nomePortaDelegataURLBased) {
                String portaDelegata = new String(this.location);
                if (portaDelegata.endsWith("/")) {
                    portaDelegata = portaDelegata.substring(0, portaDelegata.length() - 1);
                }
                while (portaDelegata.contains("/")) {
                    try {
                        this.soggetto = configurazionePdDReader.getIDSoggetto(portaDelegata, this.protocolFactory);
                    }
                    catch (DriverConfigurazioneNotFound dNotFound) {
                        // empty catch block
                    }
                    if (this.soggetto != null) {
                        this.nomePDIndivituata = portaDelegata;
                        break;
                    }
                    int indexCut = -1;
                    for (int i = portaDelegata.length() - 1; i >= 0; --i) {
                        if (portaDelegata.charAt(i) != '/') continue;
                        indexCut = i;
                        break;
                    }
                    portaDelegata = portaDelegata.substring(0, indexCut);
                }
                try {
                    this.soggetto = configurazionePdDReader.getIDSoggetto(portaDelegata, this.protocolFactory);
                }
                catch (DriverConfigurazioneNotFound dNotFound) {
                    // empty catch block
                }
                if (this.soggetto != null) {
                    this.nomePDIndivituata = portaDelegata;
                }
            }
            if (this.nomePDIndivituata == null) {
                try {
                    this.soggetto = configurazionePdDReader.getIDSoggetto(this.location, this.protocolFactory);
                }
                catch (DriverConfigurazioneNotFound dNotFound) {
                    this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("verificare i parametri di accesso utilizzati", this.location, this.urlCompleta);
                    this.log.error((Object)(this.erroreIntegrazione.getDescrizione(this.protocolFactory) + ": " + dNotFound.getMessage()));
                    return false;
                }
                if (this.soggetto != null) {
                    this.nomePDIndivituata = this.location;
                }
            }
            if (this.soggetto == null) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("verificare i parametri di accesso utilizzati", this.location, this.urlCompleta);
                return false;
            }
            RichiestaDelegata richiestaDelegata = new RichiestaDelegata(this.soggetto, this.nomePDIndivituata);
            try {
                this.pd = configurazionePdDReader.getPortaDelegata(richiestaDelegata.getIdPortaDelegata());
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente(notFound.getMessage(), this.nomePDIndivituata, this.urlCompleta);
                return false;
            }
            try {
                this.tipoAutenticazione = configurazionePdDReader.getAutenticazione(this.pd);
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("[lettura tipo autenticazione] " + notFound.getMessage(), this.nomePDIndivituata, this.urlCompleta);
                return false;
            }
            try {
                this.tipoAutorizzazione = configurazionePdDReader.getAutorizzazione(this.pd);
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("[lettura tipo autorizzazione] " + notFound.getMessage(), this.nomePDIndivituata, this.urlCompleta);
                return false;
            }
            try {
                this.tipoAutorizzazioneContenuto = configurazionePdDReader.getAutorizzazioneContenuto(this.pd);
            }
            catch (DriverConfigurazioneNotFound notFound) {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_401_PD_INESISTENTE.getErrore401_PortaDelegataInesistente("[lettura tipo autorizzazione contenuto] " + notFound.getMessage(), this.nomePDIndivituata, this.urlCompleta);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)("Identificazione porta delegata non riuscita location[" + this.location + "] urlInvocazione[" + this.urlCompleta + "]"), (Throwable)e);
            try {
                this.erroreIntegrazione = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_502_IDENTIFICAZIONE_PD);
            }
            catch (Exception eError) {
                throw new RuntimeException(eError.getMessage(), eError);
            }
            return false;
        }
    }

    public IDSoggetto getSoggetto() {
        return this.soggetto;
    }

    public ErroreIntegrazione getErroreIntegrazione() {
        return this.erroreIntegrazione;
    }

    public String getTipoAutenticazione() {
        return this.tipoAutenticazione;
    }

    public String getTipoAutorizzazione() {
        return this.tipoAutorizzazione;
    }

    public String getTipoAutorizzazioneContenuto() {
        return this.tipoAutorizzazioneContenuto;
    }

    public String getNomePDIndivituata() {
        return this.nomePDIndivituata;
    }

    public PortaDelegata getPd() {
        return this.pd;
    }
}

