/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.soap.encoding.soapenc.Base64;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.SOAPVersion;
import org.openspcoop2.pdd.config.ClassNameProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.IPdDContextSerializer;
import org.openspcoop2.pdd.core.JMSReceiver;
import org.openspcoop2.pdd.core.MessaggioServizioApplicativo;
import org.openspcoop2.pdd.core.PdDContext;
import org.openspcoop2.pdd.core.SoapMessage;
import org.openspcoop2.pdd.core.state.IOpenSPCoopState;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateful;
import org.openspcoop2.pdd.core.state.OpenSPCoopStateless;
import org.openspcoop2.pdd.logger.MsgDiagnostico;
import org.openspcoop2.pdd.logger.OpenSPCoop2Logger;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.driver.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.engine.driver.RepositoryBuste;
import org.openspcoop2.protocol.engine.driver.Riscontri;
import org.openspcoop2.protocol.engine.driver.RollbackRepositoryBuste;
import org.openspcoop2.protocol.engine.driver.repository.IGestoreRepository;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.protocol.sdk.state.StatefulMessage;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.resources.Loader;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class GestoreMessaggi {
    private Logger log = null;
    private IOpenSPCoopState openspcoopstate = null;
    private boolean isRichiesta = false;
    private boolean readyForDrop = false;
    private boolean portaDiTipoStateless = false;
    private boolean routingStateless;
    private boolean oneWayVersione11 = false;
    public static final String MESSAGGI = "MESSAGGI";
    public static final String MESSAGGI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String MESSAGGI_COLUMN_TIPO_MESSAGGIO = "TIPO";
    public static final String MESSAGGI_COLUMN_RIFERIMENTO_MSG = "RIFERIMENTO_MSG";
    public static final String MESSAGGI_COLUMN_ORA_REGISTRAZIONE = "ORA_REGISTRAZIONE";
    public static final String MESSAGGI_COLUMN_PROPRIETARIO = "PROPRIETARIO";
    public static final String MESSAGGI_COLUMN_PROTOCOLLO = "PROTOCOLLO";
    public static final String MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RICHIESTA = "CORRELAZIONE_APPLICATIVA";
    public static final String MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RISPOSTA = "CORRELAZIONE_RISPOSTA";
    public static final String MSG_SERVIZI_APPLICATIVI = "MSG_SERVIZI_APPLICATIVI";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO = "SERVIZIO_APPLICATIVO";
    public static final String DEFINIZIONE_MESSAGGI = "DEFINIZIONE_MESSAGGI";
    public static final String DEFINIZIONE_MESSAGGI_COLUMN_ID_MESSAGGIO = "ID_MESSAGGIO";
    public static final String DEFINIZIONE_MESSAGGI_COLUMN_TIPO_MESSAGGIO = "TIPO";
    public static final String CONSEGNA_TRAMITE_CONNETTORE = "Connettore";
    public static final String CONSEGNA_TRAMITE_CONNECTION_REPLY = "ConnectionReply";
    public static final String CONSEGNA_TRAMITE_INTEGRATION_MANAGER = "IntegrationManager";
    private MsgDiagnostico msgDiag;
    private String idBusta;
    private String workDir;
    private String tipo;
    private OpenSPCoop2Properties propertiesReader;
    private static final String GESTORE_MESSAGGI_CACHE_NAME = "gestoreMessaggi";
    private static Cache cacheMappingGestoreMessaggi = null;
    private static String cluster_id = null;
    private PdDContext pddContext = null;
    private IProtocolFactory protocolFactory = null;
    private Hashtable<String, String> tableProprietariMessaggiGestiti;
    private Hashtable<String, Boolean> tableMessaggiGestiti;
    private static IJDBCAdapter adapter = null;
    private static boolean adapterInitialized = false;
    private static IPdDContextSerializer pddContextSerializer = null;
    private static boolean pddContextSerializerInitialized = false;
    private boolean deleted = false;
    public static final String NUMERO_RISPEDIZIONE = "[spedizione n.";
    private static StringBuffer LOCK = new StringBuffer();
    private static String LOCK_MODULO = null;
    private static final int LOCK_NUMBER_OF_PERMITS = 1;
    private static final boolean LOCK_FAIR_FIFO = true;
    private static Semaphore LOCK_SEMAPHORE = new Semaphore(1, true);

    public IOpenSPCoopState getOpenspcoopstate() {
        return this.openspcoopstate;
    }

    public PdDContext getPddContext() {
        return this.pddContext;
    }

    public IProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public static void resetCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                cacheMappingGestoreMessaggi.clear();
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
    }

    public static String printStatsCache(String separator) throws GestoreMessaggiException {
        try {
            if (cacheMappingGestoreMessaggi != null) {
                return cacheMappingGestoreMessaggi.printStats(separator);
            }
            throw new Exception("Cache non abilitata");
        }
        catch (Exception e) {
            throw new GestoreMessaggiException("Visualizzazione Statistiche riguardante la cache dei messaggi gestiti dalla Porta di Dominio non riuscita: " + e.getMessage(), e);
        }
    }

    public static void abilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        try {
            cacheMappingGestoreMessaggi = new Cache(GESTORE_MESSAGGI_CACHE_NAME);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static void abilitaCache(long dimensioneCache, boolean algoritmoCacheLRU, long itemIdleTime, long itemLifeSecond) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            throw new GestoreMessaggiException("Cache gia' abilitata");
        }
        try {
            String algoritmoCache = null;
            algoritmoCache = algoritmoCacheLRU ? CostantiConfigurazione.CACHE_LRU.toString() : CostantiConfigurazione.CACHE_MRU.toString();
            GestoreMessaggi.initCacheGestoreMessaggi((int)dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, null, null);
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static void disabilitaCache() throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi == null) {
            throw new GestoreMessaggiException("Cache gia' disabilitata");
        }
        try {
            cacheMappingGestoreMessaggi.clear();
            cacheMappingGestoreMessaggi = null;
        }
        catch (Exception e) {
            throw new GestoreMessaggiException(e.getMessage(), e);
        }
    }

    public static boolean isCacheAbilitata() {
        return cacheMappingGestoreMessaggi != null;
    }

    public static String listKeysCache(String separator) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                return cacheMappingGestoreMessaggi.printKeys(separator);
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
        throw new GestoreMessaggiException("Cache non abilitata");
    }

    public static String getObjectCache(String key) throws GestoreMessaggiException {
        if (cacheMappingGestoreMessaggi != null) {
            try {
                Object o = cacheMappingGestoreMessaggi.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
        }
        throw new GestoreMessaggiException("Cache non abilitata");
    }

    public static void initialize() throws Exception {
        OpenSPCoop2Properties properties = OpenSPCoop2Properties.getInstance();
        if (properties.isAbilitataCacheGestoreMessaggi()) {
            Logger log = OpenSPCoop2Logger.getLoggerOpenSPCoopCore();
            Logger logConsole = OpenSPCoop2Logger.getLoggerOpenSPCoopConsole();
            int dimensioneCache = properties.getDimensioneCacheGestoreMessaggi();
            String algoritmoCache = properties.getAlgoritmoCacheGestoreMessaggi();
            long itemIdleTime = properties.getItemIdleTimeCacheGestoreMessaggi();
            long itemLifeSecond = properties.getItemLifeSecondCacheGestoreMessaggi();
            GestoreMessaggi.initCacheGestoreMessaggi(dimensioneCache, algoritmoCache, itemIdleTime, itemLifeSecond, log, logConsole);
        }
    }

    public static void initCacheGestoreMessaggi(int dimensioneCache, String algoritmoCache, long itemIdleTime, long itemLifeSecond, Logger log, Logger logConsole) throws Exception {
        if (log != null) {
            log.info((Object)"Inizializzazione cache gestoreMessaggi");
        }
        if (logConsole != null) {
            logConsole.info((Object)"Inizializzazione cache gestoreMessaggi");
        }
        cacheMappingGestoreMessaggi = new Cache(GESTORE_MESSAGGI_CACHE_NAME);
        String msg = null;
        if (dimensioneCache > 0 || algoritmoCache != null) {
            if (dimensioneCache > 0) {
                try {
                    msg = "Dimensione della cache (Gestore Messaggi) impostata al valore: " + dimensioneCache;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    cacheMappingGestoreMessaggi.setCacheSize(dimensioneCache);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per la dimensione della cache (Gestore Messaggi): " + error.getMessage());
                }
            }
            if (algoritmoCache != null) {
                msg = "Algoritmo di cache (Gestore Messaggi) impostato al valore: " + algoritmoCache;
                if (log != null) {
                    log.info((Object)msg);
                }
                if (logConsole != null) {
                    logConsole.info((Object)msg);
                }
                if (CostantiConfigurazione.CACHE_MRU.toString().equalsIgnoreCase(algoritmoCache)) {
                    cacheMappingGestoreMessaggi.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    cacheMappingGestoreMessaggi.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (itemIdleTime > 0L || itemLifeSecond > 0L) {
            if (itemIdleTime > 0L) {
                try {
                    msg = "Attributo 'IdleTime' (Gestore Messaggi) impostato al valore: " + itemIdleTime;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    cacheMappingGestoreMessaggi.setItemIdleTime(itemIdleTime);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'IdleTime' (Gestore Messaggi): " + error.getMessage());
                }
            }
            if (itemLifeSecond > 0L) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (Gestore Messaggi) impostato al valore: " + itemLifeSecond;
                    if (log != null) {
                        log.info((Object)msg);
                    }
                    if (logConsole != null) {
                        logConsole.info((Object)msg);
                    }
                    cacheMappingGestoreMessaggi.setItemLifeTime(itemLifeSecond);
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (Gestore Messaggi): " + error.getMessage());
                }
            }
        }
    }

    public static String cacheToString() throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            StringBuffer bf = new StringBuffer();
            bf.append("Cache GestoreMessaggi: " + cacheMappingGestoreMessaggi.printStats(" "));
            return bf.toString();
        }
        return "Cache non abilitata";
    }

    public static void addIntoCache_MappingRifMsgToId(MsgDiagnostico msgDiag, String tipoMessaggio, String riferimentoMessaggio, String idBusta) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            cacheMappingGestoreMessaggi.put(key, (Serializable)((Object)idBusta));
        }
    }

    public static String getFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get("mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio);
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_idFromRifMsgMapping(String tipoMessaggio, String riferimentoMessaggio) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "mappingRifMsgToId_" + tipoMessaggio + "_" + riferimentoMessaggio;
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_Proprietario(MsgDiagnostico msgDiag, String tipoMessaggio, String idBusta, String proprietario) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = proprietario;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBuste")) {
                prop = "RicezioneBuste";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idBusta + ")";
            cacheMappingGestoreMessaggi.put(key, (Serializable)((Object)proprietario));
        }
    }

    public static String getFromCache_Proprietario(String idModulo, String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String prop = idModulo;
            if (prop.startsWith("RicezioneContenutiApplicativi")) {
                prop = "RicezioneContenutiApplicativi";
            } else if (prop.startsWith("RicezioneBuste")) {
                prop = "RicezioneBuste";
            }
            String key = "proprietario_to" + prop + "_(" + tipoMessaggio + "_" + idBusta + ")";
            Object obj = cacheMappingGestoreMessaggi.get(key);
            if (obj != null) {
                return (String)obj;
            }
            return null;
        }
        return null;
    }

    public static void deleteFromCache_Proprietario(String modulo, String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "proprietario_to" + modulo + "_(" + tipoMessaggio + "_" + idBusta + ")";
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public static void addIntoCache_existsMessage(MsgDiagnostico msgDiag, String tipoMessaggio, String idBusta) throws UtilsException {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idBusta;
            cacheMappingGestoreMessaggi.put(key, (Serializable)Boolean.valueOf(true));
        }
    }

    public static boolean getFromCache_existsMessage(String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            Object obj = cacheMappingGestoreMessaggi.get("existsMessage_" + tipoMessaggio + "_" + idBusta);
            if (obj != null) {
                return (Boolean)obj;
            }
            return false;
        }
        return false;
    }

    public static void deleteFromCache_existsMessage(String tipoMessaggio, String idBusta) {
        if (cacheMappingGestoreMessaggi != null) {
            String key = "existsMessage_" + tipoMessaggio + "_" + idBusta;
            try {
                cacheMappingGestoreMessaggi.remove(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addProprietarioIntoTable(String tipo, String idBusta, String proprietario) {
        this.tableProprietariMessaggiGestiti.put(tipo + "@" + idBusta, proprietario);
    }

    public void addProprietariMsgGestitiFromTable(Hashtable<String, String> t) throws UtilsException {
        this.tableProprietariMessaggiGestiti.putAll(t);
    }

    public Hashtable<String, String> getTableProprietariMessaggiGestiti() {
        return this.tableProprietariMessaggiGestiti;
    }

    public void addProprietariIntoCache_readFromTable(String modulo, String descrizione, String idBustaRichiestaCorrelata, boolean router) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        Enumeration<String> keys = this.tableProprietariMessaggiGestiti.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] idTipo = key.split("@");
            String value = this.tableProprietariMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_Proprietario(this.msgDiag, idTipo[0], idTipo[1], value);
                this.msgDiag.highDebug("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
                if ("GestoreMessaggi".equals(value)) {
                    this.puliziaCache(modulo, this.idBusta, this.tipo, idBustaRichiestaCorrelata, router);
                    continue;
                }
                this.puliziaCacheAltriProprietari(modulo, this.idBusta, this.tipo);
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_Proprietario(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value + "");
                this.log.error((Object)("Aggiornamento proprietario [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita"), (Throwable)e);
            }
        }
    }

    public void puliziaCacheAltriProprietari(String moduloVecchio, String idBusta, String tipo) {
        if (moduloVecchio.indexOf("RicezioneContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idBusta);
        } else if (moduloVecchio.indexOf("Imbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idBusta);
        } else if (moduloVecchio.indexOf("InoltroBuste") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
        } else if (moduloVecchio.indexOf("SbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idBusta);
        } else if (moduloVecchio.indexOf("RicezioneBuste") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
        } else if (moduloVecchio.indexOf("Sbustamento") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idBusta);
        } else if (moduloVecchio.indexOf("ConsegnaContenutiApplicativi") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idBusta);
        } else if (moduloVecchio.indexOf("InoltroRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposte", tipo, idBusta);
        } else if (moduloVecchio.indexOf("ImbustamentoRisposte") >= 0) {
            GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idBusta);
        }
    }

    public void puliziaCache(String modulo, String idBusta, String tipo, String idBustaRichiesta, boolean router) {
        try {
            GestoreMessaggi.deleteFromCache_existsMessage(tipo, idBusta);
            if (idBustaRichiesta != null) {
                GestoreMessaggi.deleteFromCache_idFromRifMsgMapping(tipo, idBustaRichiesta);
            }
            if (router) {
                if (idBustaRichiesta == null) {
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
                }
            } else if (idBustaRichiesta == null) {
                if ("OUTBOX".equals(tipo)) {
                    GestoreMessaggi.deleteFromCache_Proprietario("Imbustamento", tipo, idBusta);
                    GestoreMessaggi.deleteFromCache_Proprietario("InoltroBuste", tipo, idBusta);
                } else {
                    GestoreMessaggi.deleteFromCache_Proprietario("Sbustamento", tipo, idBusta);
                    GestoreMessaggi.deleteFromCache_Proprietario("ConsegnaContenutiApplicativi", tipo, idBusta);
                }
            } else if ("INBOX".equals(tipo)) {
                GestoreMessaggi.deleteFromCache_Proprietario("SbustamentoRisposte", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneContenutiApplicativi", tipo, idBusta);
            } else {
                GestoreMessaggi.deleteFromCache_Proprietario("ImbustamentoRisposte", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("RicezioneBuste", tipo, idBusta);
                GestoreMessaggi.deleteFromCache_Proprietario("InoltroRisposte", tipo, idBusta);
            }
        }
        catch (Exception e) {
            this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.puliziaCache(Modulo:" + modulo + ",Per:" + idBusta + "/" + tipo + ",Router:" + router + "");
            this.log.error((Object)("Pulizia della cache non riuscita (Modulo:" + modulo + ") per [" + idBusta + "/" + tipo + "] router[" + router + "]"), (Throwable)e);
        }
    }

    private void addMessaggioIntoTable(String tipo, String idBusta) {
        this.tableMessaggiGestiti.put(tipo + "@" + idBusta, true);
    }

    public void addMsgGestitiFromTable(Hashtable<String, Boolean> t) throws UtilsException {
        this.tableMessaggiGestiti.putAll(t);
    }

    public Hashtable<String, Boolean> getTableMessaggiGestiti() {
        return this.tableMessaggiGestiti;
    }

    public void addMessaggiIntoCache_readFromTable(String modulo, String descrizione) {
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return;
        }
        Enumeration<String> keys = this.tableMessaggiGestiti.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String[] idTipo = key.split("@");
            Boolean value = this.tableMessaggiGestiti.get(key);
            try {
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] ...");
                GestoreMessaggi.addIntoCache_existsMessage(this.msgDiag, idTipo[0], idTipo[1]);
                this.msgDiag.highDebug("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] effettuata");
            }
            catch (Exception e) {
                this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_existsMessage(Descr:" + descrizione + ",Modulo:" + modulo + ",Per:" + idTipo[0] + "/" + idTipo[1] + ",Value:" + value + "");
                this.log.error((Object)("Aggiornamento existsMessage [" + descrizione + "] (Modulo:" + modulo + ") per [" + idTipo[0] + "/" + idTipo[1] + "] a [" + value + "] non riuscita"), (Throwable)e);
            }
        }
    }

    private static synchronized void initAdapter(Logger log, OpenSPCoop2Properties propertiesReader) {
        if (!adapterInitialized) {
            if (!propertiesReader.isRepositoryOnFS()) {
                try {
                    String jdbcAdapter = propertiesReader.getRepositoryJDBCAdapter();
                    if (propertiesReader.getDatabaseType() != null && TipiDatabase.DEFAULT.equals(jdbcAdapter)) {
                        adapter = JDBCAdapterFactory.createJDBCAdapter((String)propertiesReader.getDatabaseType());
                    } else {
                        ClassNameProperties classNameProperties = ClassNameProperties.getInstance();
                        String adapterClass = classNameProperties.getJDBCAdapter(jdbcAdapter);
                        if (adapterClass == null) {
                            log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non registrata [" + propertiesReader.getRepositoryJDBCAdapter() + "]"));
                        }
                        Loader loader = Loader.getInstance();
                        adapter = (IJDBCAdapter)loader.newInstance(adapterClass);
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Inizializzione GestoreMessaggi non riuscita: AdapterClass non trovata [" + propertiesReader.getRepositoryJDBCAdapter() + "]:" + e.getMessage()), (Throwable)e);
                }
            }
            adapterInitialized = true;
        }
    }

    private static synchronized void initPddContextSerializer(Logger log, OpenSPCoop2Properties propertiesReader) {
        if (!pddContextSerializerInitialized) {
            String pddContextSerializerClass = propertiesReader.getPddContextSerializer();
            if (pddContextSerializerClass != null && !"none".equals(pddContextSerializerClass)) {
                try {
                    Loader loader = Loader.getInstance();
                    pddContextSerializer = (IPdDContextSerializer)loader.newInstance(pddContextSerializerClass);
                }
                catch (Exception e) {
                    log.error((Object)("Inizializzione GestoreMessaggi non riuscita: IPdDContextSerializer non trovata [" + pddContextSerializerClass + "]:" + e.getMessage()), (Throwable)e);
                }
            }
            pddContextSerializerInitialized = true;
        }
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, null, null, OpenSPCoop2Logger.getLoggerOpenSPCoopCore(), msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, Logger alog, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, null, null, alog, msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idBusta, String tipo, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this(openspcoopstate, isRichiesta, idBusta, tipo, Configurazione.getLibraryLog(), msgDiag, pddContext);
    }

    public GestoreMessaggi(IOpenSPCoopState openspcoopstate, boolean isRichiesta, String idBusta, String tipo, Logger alog, MsgDiagnostico msgDiag, PdDContext pddContext) {
        this.openspcoopstate = openspcoopstate;
        this.isRichiesta = isRichiesta;
        this.tableProprietariMessaggiGestiti = new Hashtable();
        this.tableMessaggiGestiti = new Hashtable();
        this.idBusta = idBusta;
        this.tipo = tipo;
        this.propertiesReader = OpenSPCoop2Properties.getInstance();
        this.msgDiag = msgDiag;
        this.log = alog != null ? alog : Logger.getLogger(GestoreMessaggi.class);
        if (!this.propertiesReader.isRepositoryOnFS()) {
            if (!adapterInitialized) {
                GestoreMessaggi.initAdapter(this.log, this.propertiesReader);
            }
        } else {
            this.workDir = this.propertiesReader.getRepositoryDirectory();
        }
        if (!pddContextSerializerInitialized) {
            GestoreMessaggi.initPddContextSerializer(this.log, this.propertiesReader);
        }
        cluster_id = this.propertiesReader.getClusterId();
        this.pddContext = pddContext;
        try {
            if (this.pddContext != null) {
                this.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName((String)this.pddContext.getObject(MESSAGGI_COLUMN_PROTOCOLLO));
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Inizializzione GestoreMessaggi non riuscita [ProtocoFactoryManager.getInstance]:" + e.getMessage()), (Throwable)e);
        }
    }

    public void updateOpenSPCoopState(IOpenSPCoopState openspcoopstate) {
        this.openspcoopstate = openspcoopstate;
    }

    private String getColonnaSQL(String idNodo) throws SQLException {
        if (idNodo.startsWith("RicezioneContenutiApplicativi")) {
            return "MOD_RICEZ_CONT_APPLICATIVI";
        }
        if ("ConsegnaContenutiApplicativi".equals(idNodo)) {
            return "MOD_CONSEGNA_CONT_APPLICATIVI";
        }
        if (idNodo.startsWith("RicezioneBuste")) {
            return "MOD_RICEZ_BUSTE";
        }
        if ("InoltroBuste".equals(idNodo)) {
            return "MOD_INOLTRO_BUSTE";
        }
        if ("InoltroRisposte".equals(idNodo)) {
            return "MOD_INOLTRO_RISPOSTE";
        }
        if ("Imbustamento".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO";
        }
        if ("ImbustamentoRisposte".equals(idNodo)) {
            return "MOD_IMBUSTAMENTO_RISPOSTE";
        }
        if ("Sbustamento".equals(idNodo)) {
            return "MOD_SBUSTAMENTO";
        }
        if ("SbustamentoRisposte".equals(idNodo)) {
            return "MOD_SBUSTAMENTO_RISPOSTE";
        }
        throw new SQLException("Traduzione IDModulo->ColonnaSQL per modulo [" + idNodo + "] non possibile");
    }

    public void registraMessaggio(OpenSPCoop2Message message, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, null, false, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        this.registraMessaggio(message, null, false, correlazioneApplicativaRichiesta, correlazioneApplicativaRisposta);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Timestamp oraRegistrazione, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, false, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Timestamp oraRegistrazione, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, false, correlazioneApplicativaRichiesta, correlazioneApplicativaRisposta);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Timestamp oraRegistrazione, boolean salvaNelloStateless, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraMessaggio(message, oraRegistrazione, salvaNelloStateless, correlazioneApplicativaRichiesta, null);
    }

    public void registraMessaggio(OpenSPCoop2Message message, Timestamp oraRegistrazione, boolean salvaNelloStateless, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        StateMessage stato;
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : oraRegistrazione;
        boolean gestisciInfoGenericheDB = true;
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgIngresso(oraRegistrazioneT);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().setRicezioneMsgRisposta(oraRegistrazioneT);
            }
            ((OpenSPCoopStateless)this.openspcoopstate).setIDCorrelazioneApplicativa(correlazioneApplicativaRichiesta);
            ((OpenSPCoopStateless)this.openspcoopstate).setIDCorrelazioneApplicativaRisposta(correlazioneApplicativaRisposta);
            ((OpenSPCoopStateless)this.openspcoopstate).setPddContext(this.pddContext);
            if (!this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setRispostaMsg(message);
                return;
            }
            if (!this.oneWayVersione11 || this.routingStateless) {
                gestisciInfoGenericheDB = false;
            }
        }
        StateMessage stateMessage = stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        if (gestisciInfoGenericheDB) {
            Connection connectionDB = stato.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer fieldNamesPdDContext = new StringBuffer();
                StringBuffer fieldValuesPdDContext = new StringBuffer();
                Hashtable<String, String> contextSerializerParameters = null;
                Vector<Object> objectSerializer = new Vector<Object>();
                if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    Enumeration<String> keywordContext = contextSerializerParameters.keys();
                    while (keywordContext.hasMoreElements()) {
                        String keyword = keywordContext.nextElement();
                        Object o = this.pddContext.getObject(keyword);
                        if (o == null) continue;
                        fieldNamesPdDContext.append(" , ");
                        fieldValuesPdDContext.append(" , ");
                        fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                        fieldValuesPdDContext.append("?");
                        if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                            throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                        }
                        objectSerializer.add(o);
                    }
                }
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append(MESSAGGI);
                query.append("(ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, CORRELAZIONE_APPLICATIVA, CORRELAZIONE_RISPOSTA, PROTOCOLLO" + fieldNamesPdDContext.toString() + ") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ?" + fieldValuesPdDContext.toString() + ")");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                pstmt.setTimestamp(3, oraRegistrazioneT);
                pstmt.setTimestamp(4, oraRegistrazioneT);
                pstmt.setTimestamp(5, oraRegistrazioneT);
                pstmt.setString(6, cluster_id);
                pstmt.setString(7, correlazioneApplicativaRichiesta);
                pstmt.setString(8, correlazioneApplicativaRisposta);
                pstmt.setString(9, this.protocolFactory.getProtocol());
                int index = 10;
                for (int i = 0; i < objectSerializer.size(); ++i) {
                    Object o = objectSerializer.get(i);
                    if (o instanceof String) {
                        pstmt.setString(index++, o.toString());
                        continue;
                    }
                    if (o instanceof Long) {
                        pstmt.setLong(index++, (Long)o);
                        continue;
                    }
                    if (!(o instanceof Timestamp)) continue;
                    pstmt.setTimestamp(index++, (Timestamp)o);
                }
                stato.getPreparedStatement().put("INSERT (MSG_OP_STEP1) registraMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
                this.addMessaggioIntoTable(this.tipo, this.idBusta);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (message != null) {
            SoapMessage msgSoap = null;
            try {
                msgSoap = new SoapMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgSoap.save(message, this.isRichiesta, salvaNelloStateless);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraInformazioniMessaggio_statelessEngine(Timestamp oraRegistrazione, String proprietarioMessaggio, String correlazioneApplicativaRichiesta) throws GestoreMessaggiException {
        this.registraInformazioniMessaggio_statelessEngine(oraRegistrazione, proprietarioMessaggio, null, correlazioneApplicativaRichiesta, null);
    }

    public void registraInformazioniMessaggio_statelessEngine(Timestamp oraRegistrazione, String proprietarioMessaggio, String riferimentoMessaggio, String correlazioneApplicativaRichiesta, String correlazioneApplicativaRisposta) throws GestoreMessaggiException {
        Timestamp oraRegistrazioneT = null;
        oraRegistrazioneT = oraRegistrazione == null ? DateManager.getTimestamp() : oraRegistrazione;
        StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stato.getConnectionDB();
        Statement pstmt = null;
        try {
            StringBuffer fieldNamesPdDContext = new StringBuffer();
            StringBuffer fieldValuesPdDContext = new StringBuffer();
            Hashtable<String, String> contextSerializerParameters = null;
            Vector<Object> objectSerializer = new Vector<Object>();
            if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                Enumeration<String> keywordContext = contextSerializerParameters.keys();
                while (keywordContext.hasMoreElements()) {
                    String keyword = keywordContext.nextElement();
                    Object o = this.pddContext.getObject(keyword);
                    if (o == null) continue;
                    fieldNamesPdDContext.append(" , ");
                    fieldValuesPdDContext.append(" , ");
                    fieldNamesPdDContext.append(contextSerializerParameters.get(keyword));
                    fieldValuesPdDContext.append("?");
                    if (!(o instanceof String || o instanceof Long || o instanceof Timestamp)) {
                        throw new Exception("Oggetto con chiave [" + keyword + "] e' di tipo [" + o.getClass().getName() + "], e' possibile serializzare solo i tipi java.lang.String/java.lang.Long/java.sql.Timestamp");
                    }
                    objectSerializer.add(o);
                }
            }
            StringBuffer query = new StringBuffer();
            query.append("INSERT INTO ");
            query.append(MESSAGGI);
            query.append("(ID_MESSAGGIO,TIPO,ORA_REGISTRAZIONE,RISPEDIZIONE, REDELIVERY_DELAY, CLUSTER_ID, PROPRIETARIO, CORRELAZIONE_APPLICATIVA, CORRELAZIONE_RISPOSTA, PROTOCOLLO ");
            if (riferimentoMessaggio != null) {
                query.append(", RIFERIMENTO_MSG");
            }
            query.append(fieldNamesPdDContext.toString());
            query.append(") VALUES ( ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ");
            if (riferimentoMessaggio != null) {
                query.append(", ?");
            }
            query.append(fieldValuesPdDContext);
            query.append(" )");
            pstmt = connectionDB.prepareStatement(query.toString());
            pstmt.setString(1, this.idBusta);
            pstmt.setString(2, this.tipo);
            pstmt.setTimestamp(3, oraRegistrazioneT);
            pstmt.setTimestamp(4, oraRegistrazioneT);
            pstmt.setTimestamp(5, oraRegistrazioneT);
            pstmt.setString(6, cluster_id);
            pstmt.setString(7, proprietarioMessaggio);
            pstmt.setString(8, correlazioneApplicativaRichiesta);
            pstmt.setString(9, correlazioneApplicativaRisposta);
            pstmt.setString(10, this.protocolFactory.getProtocol());
            int index = 11;
            if (riferimentoMessaggio != null) {
                pstmt.setString(index++, riferimentoMessaggio);
            }
            for (int i = 0; i < objectSerializer.size(); ++i) {
                Object o = objectSerializer.get(i);
                if (o instanceof String) {
                    pstmt.setString(index++, o.toString());
                    continue;
                }
                if (o instanceof Long) {
                    pstmt.setLong(index++, (Long)o);
                    continue;
                }
                if (!(o instanceof Timestamp)) continue;
                pstmt.setTimestamp(index++, (Timestamp)o);
            }
            stato.getPreparedStatement().put("INSERT (MSG_OP_STEP1) registraMessaggioOpenSPCoop(stateless engine) " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
            this.addMessaggioIntoTable(this.tipo, this.idBusta);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (stateless engine) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void registraMessaggio_statelessEngine(OpenSPCoop2Message message) throws GestoreMessaggiException {
        if (message != null) {
            StateMessage stato = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            SoapMessage msgSoap = null;
            try {
                msgSoap = new SoapMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgSoap.save(message, this.isRichiesta, false);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione (SoapMessage) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                if (msgSoap != null) {
                    stato.closePreparedStatement();
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
    }

    public void registraDestinatarioMessaggio(String serv, boolean sbustamentoSOAP, boolean sbustamentoInfoProtocol, boolean integrationManager, String tipoConsegna, Timestamp oraRegistrazioneMessaggio, String nomePorta) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("INSERT INTO ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append("(ID_MESSAGGIO,SERVIZIO_APPLICATIVO,SBUSTAMENTO_SOAP,SBUSTAMENTO_INFO_PROTOCOL,INTEGRATION_MANAGER,TIPO_CONSEGNA,RISPEDIZIONE,NOME_PORTA) VALUES ( ? , ? , ? , ? , ? , ? , ? , ?)");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, serv);
                if (sbustamentoSOAP) {
                    pstmt.setInt(3, 1);
                } else {
                    pstmt.setInt(3, 0);
                }
                if (sbustamentoInfoProtocol) {
                    pstmt.setInt(4, 1);
                } else {
                    pstmt.setInt(4, 0);
                }
                if (integrationManager) {
                    pstmt.setInt(5, 1);
                } else {
                    pstmt.setInt(5, 0);
                }
                pstmt.setString(6, tipoConsegna);
                pstmt.setTimestamp(7, oraRegistrazioneMessaggio);
                pstmt.setString(8, nomePorta);
                stateMSG.getPreparedStatement().put("INSERT (MSG_OP_STEP2) registraDestinatarioMessaggioOpenSPCoop[" + serv + "][" + this.idBusta + "]", pstmt);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di registrazione destinatario Messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con IState non valido");
        }
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, false, false);
    }

    public void aggiornaProprietarioMessaggio(String nodoOpenSPCoop, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine(nodoOpenSPCoop, searchForRiferimentoMsg, false);
    }

    private void aggiornaProprietarioMessaggio_engine(String nodoOpenSPCoop, boolean searchForRiferimentoMsg, boolean executePreparedStatement) throws GestoreMessaggiException {
        if (this.deleted) {
            return;
        }
        boolean stateful = this.openspcoopstate instanceof OpenSPCoopStateful;
        if (!stateful) {
            if (this.isRichiesta) {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioRequestMsgLib(nodoOpenSPCoop);
            } else {
                ((OpenSPCoopStateless)this.openspcoopstate).setDestinatarioResponseMsgLib(nodoOpenSPCoop);
            }
        }
        if (stateful || this.readyForDrop || this.oneWayVersione11) {
            StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMsg.getConnectionDB();
            Statement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET PROPRIETARIO=? WHERE ");
                String tipoMessaggio = null;
                if (searchForRiferimentoMsg) {
                    tipoMessaggio = "OUTBOX".equals(this.tipo) ? "INBOX" : "OUTBOX";
                    query.append(" RIFERIMENTO_MSG=? AND TIPO=? ");
                } else {
                    tipoMessaggio = this.tipo;
                    query.append(" ID_MESSAGGIO=? AND TIPO=? ");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, nodoOpenSPCoop);
                pstmt.setString(2, this.idBusta);
                pstmt.setString(3, tipoMessaggio);
                if (executePreparedStatement) {
                    pstmt.executeUpdate();
                    pstmt.close();
                } else {
                    stateMsg.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmt);
                }
                this.addProprietarioIntoTable(this.tipo, this.idBusta, nodoOpenSPCoop);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento proprietario Messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if ("GestoreMessaggi".equals(nodoOpenSPCoop)) {
            this.deleted = true;
        }
    }

    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio) throws GestoreMessaggiException {
        this.aggiornaRiferimentoMessaggio(riferimentoMessaggio, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggiornaRiferimentoMessaggio(String riferimentoMessaggio, boolean saveIntoDB) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || saveIntoDB) {
            StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = state.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                query.append(MESSAGGI);
                query.append(" SET RIFERIMENTO_MSG=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, riferimentoMessaggio);
                pstmt.setString(2, this.idBusta);
                pstmt.setString(3, this.tipo);
                state.getPreparedStatement().put("UPDATE aggiornaRiferimentoMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, pstmt);
                if (cacheMappingGestoreMessaggi == null) return;
                try {
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idBusta + "] ...");
                    GestoreMessaggi.addIntoCache_MappingRifMsgToId(this.msgDiag, this.tipo, riferimentoMessaggio, this.idBusta);
                    this.msgDiag.highDebug("Aggiornamento riferimentoMessaggio per [" + this.tipo + "/" + riferimentoMessaggio + "] a [" + this.idBusta + "] effettuata.");
                    return;
                }
                catch (Exception e) {
                    this.msgDiag.logErroreGenerico(e, "GestoreMessaggi.addIntoCache_MappingRifMsgToId(Per:" + this.tipo + "/" + riferimentoMessaggio + ",Value:" + this.idBusta + "");
                }
                return;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento riferimento messaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) return;
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void aggiornaErroreProcessamentoMessaggio(String motivoErrore, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            String motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            String prefix = "";
            if (motivoErroreGiaRegistrato != null && motivoErroreGiaRegistrato.startsWith(NUMERO_RISPEDIZIONE)) {
                int index = motivoErroreGiaRegistrato.indexOf("]");
                prefix = motivoErroreGiaRegistrato.substring(0, index + 2);
                motivoErroreGiaRegistrato = motivoErroreGiaRegistrato.substring(index + 2);
            }
            if (motivoErroreGiaRegistrato == null || !motivoErroreGiaRegistrato.equals(motivoErrore)) {
                PreparedStatement pstmt = null;
                try {
                    StringBuffer query = new StringBuffer();
                    query.append("UPDATE ");
                    if (servizioApplicativo == null) {
                        query.append(MESSAGGI);
                    } else {
                        query.append(MSG_SERVIZI_APPLICATIVI);
                    }
                    query.append(" SET ERRORE_PROCESSAMENTO=? WHERE ID_MESSAGGIO = ?");
                    if (servizioApplicativo != null) {
                        query.append(" AND SERVIZIO_APPLICATIVO=?");
                    } else {
                        query.append(" AND TIPO=?");
                    }
                    pstmt = connectionDB.prepareStatement(query.toString());
                    pstmt.setString(1, prefix + motivoErrore);
                    pstmt.setString(2, this.idBusta);
                    if (servizioApplicativo != null) {
                        pstmt.setString(3, servizioApplicativo);
                    } else {
                        pstmt.setString(3, this.tipo);
                    }
                    pstmt.execute();
                    pstmt.close();
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void aggiungiMessaggioSerializzato(IJDBCAdapter adapter, byte[] msgByte) throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        PreparedStatement pstmt = null;
        try {
            StringBuffer query = new StringBuffer();
            query.append("UPDATE ");
            query.append(MESSAGGI);
            query.append(" SET msg_bytes=? WHERE id_messaggio= ? and tipo= ?");
            pstmt = connectionDB.prepareStatement(query.toString());
            adapter.setBinaryData(pstmt, 1, msgByte);
            pstmt.setString(2, this.idBusta);
            pstmt.setString(3, this.tipo);
            stateMsg.getPreparedStatement().put("UPDATE aggiungiMessaggioSerializzatoInMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, pstmt);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void ripristinaMessaggio() throws GestoreMessaggiException {
        StateMessage stateMsg = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMsg.getConnectionDB();
        PreparedStatement pstmt = null;
        String sql = "UPDATE MESSAGGI SET scheduling=0 where id_messaggio=? AND tipo=?";
        try {
            pstmt = connectionDB.prepareStatement(sql);
            pstmt.setString(1, this.idBusta);
            pstmt.setString(2, this.tipo);
            pstmt.execute();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento errore processamento messaggio " + this.tipo + "/" + this.idBusta + " " + e.getMessage();
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void aggiornaDataRispedizione(Timestamp dataRispedizione, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            String motivoErroreGiaRegistrato = this.getErroreProcessamentoMessaggio(servizioApplicativo);
            Statement pstmt = null;
            try {
                int numeroSpedizione = 0;
                if (motivoErroreGiaRegistrato == null) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] ";
                    numeroSpedizione = 1;
                } else if (!motivoErroreGiaRegistrato.startsWith(NUMERO_RISPEDIZIONE)) {
                    motivoErroreGiaRegistrato = "[spedizione n.1] " + motivoErroreGiaRegistrato;
                    numeroSpedizione = 1;
                } else {
                    int indexNumber = motivoErroreGiaRegistrato.indexOf("]");
                    if (indexNumber == -1) {
                        throw new GestoreMessaggiException("Errore processamento corrotto (] non presente)");
                    }
                    try {
                        StringBuffer bf = new StringBuffer();
                        int j = indexNumber - 1;
                        while (motivoErroreGiaRegistrato.charAt(j) != '.') {
                            bf.append(motivoErroreGiaRegistrato.charAt(j));
                            --j;
                        }
                        bf.reverse();
                        numeroSpedizione = Integer.parseInt(bf.toString());
                        String oldMotivo = motivoErroreGiaRegistrato.substring(indexNumber + 2);
                        motivoErroreGiaRegistrato = NUMERO_RISPEDIZIONE + ++numeroSpedizione + "] " + oldMotivo;
                    }
                    catch (Exception e) {
                        throw new GestoreMessaggiException("Aggiornamento numero spedizione non riuscito: " + e.getMessage(), e);
                    }
                }
                long spedizione = dataRispedizione.getTime();
                if (this.propertiesReader.isRitardoConsegnaAbilitato() && numeroSpedizione > 1) {
                    long limite;
                    long ritardoEsponenziale = this.propertiesReader.getRitardoConsegnaEsponenziale();
                    long ritardo = 1L;
                    boolean moltiplicazione = this.propertiesReader.isRitardoConsegnaEsponenzialeConMoltiplicazione();
                    if (!moltiplicazione) {
                        ritardo = 0L;
                    }
                    if ((limite = (long)(numeroSpedizione - 1)) > this.propertiesReader.getRitardoConsegnaEsponenzialeLimite()) {
                        limite = this.propertiesReader.getRitardoConsegnaEsponenzialeLimite();
                    }
                    int i = 0;
                    while ((long)i < limite) {
                        ritardo = moltiplicazione ? (ritardo *= ritardoEsponenziale) : (ritardo += ritardoEsponenziale);
                        ++i;
                    }
                    spedizione += ritardo * 1000L;
                }
                StringBuffer query = new StringBuffer();
                query.append("UPDATE ");
                if (servizioApplicativo != null) {
                    query.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    query.append(MESSAGGI);
                }
                query.append(" SET RISPEDIZIONE=?, ERRORE_PROCESSAMENTO=? WHERE  ID_MESSAGGIO = ?");
                if (servizioApplicativo != null) {
                    query.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    query.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(query.toString());
                Timestamp t = new Timestamp(spedizione);
                pstmt.setTimestamp(1, t);
                pstmt.setString(2, motivoErroreGiaRegistrato);
                pstmt.setString(3, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmt.setString(4, servizioApplicativo);
                } else {
                    pstmt.setString(4, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento data rispedizione Messaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS) throws GestoreMessaggiException {
        this.aggiornaIDHeaderJMS(nodoOpenSPCoop, idHeaderJMS, null);
    }

    public void aggiornaIDHeaderJMS(String nodoOpenSPCoop, String idHeaderJMS, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "UPDATE MSG_SERVIZI_APPLICATIVI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_MESSAGGIO = ? AND SERVIZIO_APPLICATIVO=?" : "UPDATE MESSAGGI SET " + this.getColonnaSQL(nodoOpenSPCoop) + "=? WHERE  ID_MESSAGGIO = ? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idHeaderJMS);
                pstmt.setString(2, this.idBusta);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(3, servizioApplicativo);
                } else {
                    pstmt.setString(3, this.tipo);
                }
                pstmt.execute();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore di aggiornamento IDHeaderJMS " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, false);
    }

    public String getProprietario_SerializableRead(String idModulo, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, true, attesaAttiva, checkInterval, onlyCache);
    }

    public String getProprietario(String idModulo) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, false);
    }

    public String getProprietario(String idModulo, boolean onlyCache) throws GestoreMessaggiException {
        return this.getProprietario(idModulo, false, -1L, -1, onlyCache);
    }

    private String getProprietario(String idModulo, boolean serializable, long attesaAttiva, int checkInterval, boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && !this.oneWayVersione11) {
            return this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioRequestMsgLib() : ((OpenSPCoopStateless)this.openspcoopstate).getDestinatarioResponseMsgLib();
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("getProprietario, read from cache...");
                    String proprietario = GestoreMessaggi.getFromCache_Proprietario(idModulo, this.tipo, this.idBusta);
                    if (proprietario != null) {
                        return proprietario;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error getProprietario (Cache) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("getProprietario, read from DB...");
            if (!serializable) {
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                String value = null;
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString(MESSAGGI_COLUMN_PROPRIETARIO);
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                return value;
            }
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(setIsolation) " + this.tipo + "/" + this.idBusta + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            boolean getProprietarioOK = false;
            String value = null;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!getProprietarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                try {
                    String query = "SELECT PROPRIETARIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    pstmt.setString(2, this.tipo);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        value = rs.getString(MESSAGGI_COLUMN_PROPRIETARIO);
                    }
                    rs.close();
                    pstmt.close();
                    connectionDB.commit();
                    getProprietarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (getProprietarioOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateMSG.updateConnection(connectionDB);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getProprietario Messaggio(ripristinoIsolation) " + this.tipo + "/" + this.idBusta + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            return value;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop) throws GestoreMessaggiException {
        return this.getIDJMSRicevuto(nodoOpenSPCoop, null);
    }

    public String getIDJMSRicevuto(String nodoOpenSPCoop, String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = "ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop) ? "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM " + MSG_SERVIZI_APPLICATIVI + " WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?" : "SELECT " + this.getColonnaSQL(nodoOpenSPCoop) + " FROM " + MESSAGGI + " WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                if ("ConsegnaContenutiApplicativi".equals(nodoOpenSPCoop)) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString(this.getColonnaSQL(nodoOpenSPCoop));
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get IDHeaderJMS " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessage_onlyCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, true, false);
    }

    public boolean existsMessage_onlyCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, true, false);
    }

    public boolean existsMessage_noCache(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, true);
    }

    public boolean existsMessage_noCache() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, true);
    }

    public boolean existsMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        return this.existsMessage_engine(searchForRiferimentoMsg, false, false);
    }

    public boolean existsMessage() throws GestoreMessaggiException {
        return this.existsMessage_engine(false, false, false);
    }

    private boolean existsMessage_engine(boolean searchForRiferimentoMsg, boolean onlyCache, boolean noCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateless && (!this.oneWayVersione11 || this.routingStateless)) {
            return false;
        }
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Connection connectionDB = stateMSG.getConnectionDB();
        String idBustaSearch = this.idBusta;
        if (searchForRiferimentoMsg) {
            try {
                idBustaSearch = this.mapRiferimentoIntoIDBusta();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (idBustaSearch == null) {
                return false;
            }
        }
        if (cacheMappingGestoreMessaggi != null && !noCache) {
            try {
                this.msgDiag.highDebug("existsMessage, read from cache ID[" + idBustaSearch + "]...");
                Boolean value = GestoreMessaggi.getFromCache_existsMessage(this.tipo, idBustaSearch);
                if (value != null && value.booleanValue()) {
                    return true;
                }
                if (onlyCache) {
                    return false;
                }
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage (Cache) " + this.tipo + "/" + idBustaSearch + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                return false;
            }
        }
        this.msgDiag.highDebug("existsMessage, read from DB ID[" + idBustaSearch + "]...");
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String query = "SELECT ID_MESSAGGIO FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
            pstmt = connectionDB.prepareStatement(query);
            pstmt.setString(1, idBustaSearch);
            pstmt.setString(2, this.tipo);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                rs.close();
                pstmt.close();
                return true;
            }
            rs.close();
            pstmt.close();
            return false;
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, Errore existsMessage " + this.tipo + "/" + idBustaSearch + ": " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg, (Throwable)e);
            return false;
        }
    }

    public OpenSPCoop2Message getMessage() throws GestoreMessaggiException {
        return this.getMessage(false);
    }

    public OpenSPCoop2Message getMessage(boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        OpenSPCoop2Message msg = null;
        String idBustaSearch = this.idBusta;
        if (searchForRiferimentoMsg) {
            idBustaSearch = this.mapRiferimentoIntoIDBusta();
        }
        SoapMessage soapMsg = null;
        try {
            soapMsg = new SoapMessage(idBustaSearch, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            msg = soapMsg.read(this.isRichiesta, this.portaDiTipoStateless || this.routingStateless);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, getMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        return msg;
    }

    public String mapRiferimentoIntoIDBusta() throws GestoreMessaggiException {
        return this.mapRiferimentoIntoIDBusta(false);
    }

    public String mapRiferimentoIntoIDBusta(boolean onlyCache) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            if (cacheMappingGestoreMessaggi != null) {
                try {
                    this.msgDiag.highDebug("mapRiferimentoIntoIDBusta, read from cache ...");
                    String id = GestoreMessaggi.getFromCache_idFromRifMsgMapping(this.tipo, this.idBusta);
                    if (id != null) {
                        return id;
                    }
                    if (onlyCache) {
                        return null;
                    }
                }
                catch (Exception e) {
                    String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDBusta (Cache) " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
            }
            this.msgDiag.highDebug("mapRiferimentoIntoIDBusta, read from DB ...");
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ID_MESSAGGIO FROM MESSAGGI WHERE RIFERIMENTO_MSG=? AND TIPO=? AND PROPRIETARIO IS NOT NULL AND PROPRIETARIO != ? ORDER BY ORA_REGISTRAZIONE DESC";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString("ID_MESSAGGIO");
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error mapRiferimentoIntoIDBusta " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getErroreProcessamentoMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            String motivoErroreGiaRegistrato = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT ERRORE_PROCESSAMENTO FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?" : "SELECT ERRORE_PROCESSAMENTO FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO = ? AND SERVIZIO_APPLICATIVO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    motivoErroreGiaRegistrato = rs.getString("ERRORE_PROCESSAMENTO");
                }
                rs.close();
                pstmtRead.close();
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getErroreProcessamentoMessaggio " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return motivoErroreGiaRegistrato;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getOraRegistrazioneMessaggio() throws GestoreMessaggiException {
        Timestamp t = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    t = rs.getTimestamp(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora registrazione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getOraRegistrazioneMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            t = this.isRichiesta ? ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgIngresso() : ((OpenSPCoopStateless)this.openspcoopstate).getTempiAttraversamentoPDD().getRicezioneMsgRisposta();
            if (t == null) {
                throw new GestoreMessaggiException("Ora registrazione non registrata");
            }
            return t;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Timestamp getDataRispedizioneMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RISPEDIZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                Timestamp t = null;
                if (rs.next()) {
                    t = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (t == null) {
                    throw new Exception("Ora rispedizione non registrata");
                }
                return t;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getDataRispedizioneMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isPrimaConsegna(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = null;
                query = servizioApplicativo == null ? "SELECT MESSAGGI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?" : "SELECT MSG_SERVIZI_APPLICATIVI.RISPEDIZIONE,MESSAGGI.ORA_REGISTRAZIONE FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO AND MESSAGGI.ID_MESSAGGIO= ? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MESSAGGI.TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmtRead.setString(2, servizioApplicativo);
                    pstmtRead.setString(3, "INBOX");
                } else {
                    pstmtRead.setString(2, this.tipo);
                }
                rs = pstmtRead.executeQuery();
                Timestamp oraRegistrazione = null;
                Timestamp rispedizione = null;
                if (rs.next()) {
                    oraRegistrazione = rs.getTimestamp(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    rispedizione = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmtRead.close();
                if (oraRegistrazione == null) {
                    this.log.error((Object)"OraRegistrazione is null");
                }
                if (rispedizione == null) {
                    this.log.error((Object)"Rispedizione is null");
                }
                return oraRegistrazione != null && rispedizione != null && oraRegistrazione.compareTo(rispedizione) == 0;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isPrimaConsegna " + this.tipo + "/" + this.idBusta + " sa[" + servizioApplicativo + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean isRiconsegnaMessaggio(String servizioApplicativo) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            if (this.isPrimaConsegna(servizioApplicativo)) {
                return true;
            }
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT RISPEDIZIONE FROM ");
                if (servizioApplicativo != null) {
                    bf.append(MSG_SERVIZI_APPLICATIVI);
                } else {
                    bf.append(MESSAGGI);
                }
                bf.append(" WHERE ID_MESSAGGIO=?");
                if (servizioApplicativo != null) {
                    bf.append(" AND SERVIZIO_APPLICATIVO=?");
                } else {
                    bf.append(" AND TIPO=?");
                }
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idBusta);
                if (servizioApplicativo != null) {
                    pstmt.setString(2, servizioApplicativo);
                } else {
                    pstmt.setString(2, this.tipo);
                }
                rs = pstmt.executeQuery();
                Timestamp riconsegna = null;
                if (rs.next()) {
                    riconsegna = rs.getTimestamp("RISPEDIZIONE");
                }
                rs.close();
                pstmt.close();
                Timestamp now = DateManager.getTimestamp();
                if (riconsegna == null) {
                    this.log.error((Object)("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idBusta + "], riconsegna is null? query[" + bf.toString() + "] sa[" + servizioApplicativo + "]"));
                    throw new Exception("Calcolo riconsegna non riuscito [" + this.tipo + "/" + this.idBusta + "]");
                }
                if (riconsegna.before(now)) {
                    return true;
                }
                this.log.debug((Object)("Riconsegna messaggio prematura [" + this.tipo + "/" + this.idBusta + "] RICONSEGNA[" + riconsegna.toString() + "] < NOW[" + now.toString() + "] == false"));
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore isRiconsegnaMessaggio " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return true;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getRiferimentoMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT RIFERIMENTO_MSG FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                rs = pstmt.executeQuery();
                String value = null;
                if (rs.next()) {
                    value = rs.getString(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                }
                rs.close();
                pstmt.close();
                return value;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore get RIFERIMENTO_MSG " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDCorrelazioneApplicativa() throws GestoreMessaggiException {
        String id = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT CORRELAZIONE_APPLICATIVA FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    id = rs.getString(MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RICHIESTA);
                }
                rs.close();
                pstmtRead.close();
                if (id == null) {
                    throw new Exception("ID di CorrelazioneApplicativa non registrata");
                }
                return id;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getIDCorrelazioneApplicativa " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (!e.getMessage().equals("ID di CorrelazioneApplicativa non registrata")) {
                    this.log.error((Object)errorMsg, (Throwable)e);
                } else {
                    this.log.debug((Object)errorMsg);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativa();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public String getIDCorrelazioneApplicativaRisposta() throws GestoreMessaggiException {
        String id = null;
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtRead = null;
            ResultSet rs = null;
            try {
                String query = "SELECT CORRELAZIONE_RISPOSTA FROM MESSAGGI WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    id = rs.getString(MESSAGGI_COLUMN_CORRELAZIONE_APPLICATIVA_RISPOSTA);
                }
                rs.close();
                pstmtRead.close();
                if (id == null) {
                    throw new Exception("ID di CorrelazioneApplicativaRisposta non registrata");
                }
                return id;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getIDCorrelazioneApplicativaRisposta " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (!e.getMessage().equals("ID di CorrelazioneApplicativaRisposta non registrata")) {
                    this.log.error((Object)errorMsg, (Throwable)e);
                    throw new GestoreMessaggiException(errorMsg, e);
                }
                this.log.debug((Object)errorMsg);
                return null;
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getIDCorrelazioneApplicativaRisposta();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public PdDContext getPdDContext() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmtRead = null;
            ResultSet rs = null;
            try {
                Hashtable<String, String> contextSerializerParameters;
                StringBuffer fieldNamesPdDContext_db = new StringBuffer();
                Hashtable<String, String> mapping = new Hashtable<String, String>();
                if (pddContextSerializer != null && (contextSerializerParameters = pddContextSerializer.getGestoreMessaggiKeywords()) != null && contextSerializerParameters.size() > 0) {
                    Enumeration<String> keywordContext = contextSerializerParameters.keys();
                    while (keywordContext.hasMoreElements()) {
                        String keyword = keywordContext.nextElement();
                        if (fieldNamesPdDContext_db.length() > 0) {
                            fieldNamesPdDContext_db.append(" , ");
                        }
                        String nomeDB = contextSerializerParameters.get(keyword);
                        fieldNamesPdDContext_db.append(nomeDB);
                        mapping.put(nomeDB, keyword);
                    }
                }
                if (fieldNamesPdDContext_db.length() != 0) {
                    fieldNamesPdDContext_db.append(" , ");
                }
                fieldNamesPdDContext_db.append(MESSAGGI_COLUMN_PROTOCOLLO);
                mapping.put(MESSAGGI_COLUMN_PROTOCOLLO, MESSAGGI_COLUMN_PROTOCOLLO);
                PdDContext pddContext = new PdDContext();
                if (mapping.size() <= 0) {
                    return pddContext;
                }
                String query = "SELECT " + fieldNamesPdDContext_db.toString() + " FROM " + MESSAGGI + " WHERE ID_MESSAGGIO = ? AND TIPO=?";
                pstmtRead = connectionDB.prepareStatement(query);
                pstmtRead.setString(1, this.idBusta);
                pstmtRead.setString(2, this.tipo);
                rs = pstmtRead.executeQuery();
                if (rs.next()) {
                    Enumeration keysDB = mapping.keys();
                    while (keysDB.hasMoreElements()) {
                        String keyDB = (String)keysDB.nextElement();
                        Object object = rs.getObject(keyDB);
                        pddContext.addObject((String)mapping.get(keyDB), object);
                    }
                } else {
                    throw new Exception("Messaggio non trovato");
                }
                rs.close();
                pstmtRead.close();
                return pddContext;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore getPdDContext " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtRead != null) {
                        pstmtRead.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                if (!e.getMessage().equals("Messaggio non trovato")) {
                    this.log.error((Object)errorMsg, (Throwable)e);
                } else {
                    this.log.debug((Object)errorMsg, (Throwable)e);
                }
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (this.openspcoopstate instanceof OpenSPCoopStateless) {
            return ((OpenSPCoopStateless)this.openspcoopstate).getPddContext();
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageForSIL(String servizioApplicativo) throws GestoreMessaggiException {
        return this.existsMessageForSIL(servizioApplicativo, false);
    }

    public boolean existsMessageForSIL(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT * FROM MSG_SERVIZI_APPLICATIVI,MESSAGGI WHERE MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=? AND MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=? AND MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO AND MESSAGGI.PROPRIETARIO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                pstmt.setString(3, "ConsegnaContenutiApplicativi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean checkAutorizzazione(String servizioApplicativo) throws GestoreMessaggiException {
        return this.checkAutorizzazione(servizioApplicativo, false);
    }

    public boolean checkAutorizzazione(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT INTEGRATION_MANAGER FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean auth = false;
                if (rs.next() && rs.getInt("INTEGRATION_MANAGER") == 1) {
                    auth = true;
                }
                rs.close();
                pstmt.close();
                return auth;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error existsMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean sbustamentoSOAP(String servizioApplicativo) throws GestoreMessaggiException {
        return this.sbustamentoSOAP(servizioApplicativo, false);
    }

    public boolean sbustamentoSOAP(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT SBUSTAMENTO_SOAP FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean sbustamento = false;
                if (rs.next() && rs.getInt("SBUSTAMENTO_SOAP") == 1) {
                    sbustamento = true;
                }
                rs.close();
                pstmt.close();
                return sbustamento;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error getSbustamentoSoap " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean sbustamentoInformazioniProtocollo(String servizioApplicativo) throws GestoreMessaggiException {
        return this.sbustamentoInformazioniProtocollo(servizioApplicativo, false);
    }

    public boolean sbustamentoInformazioniProtocollo(String servizioApplicativo, boolean searchForRiferimentoMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String idBustaSearch = this.idBusta;
                if (searchForRiferimentoMsg) {
                    idBustaSearch = this.mapRiferimentoIntoIDBusta();
                }
                String query = "SELECT SBUSTAMENTO_INFO_PROTOCOL FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, idBustaSearch);
                pstmt.setString(2, servizioApplicativo);
                rs = pstmt.executeQuery();
                boolean sbustamento = false;
                if (rs.next() && rs.getInt("SBUSTAMENTO_INFO_PROTOCOL") == 1) {
                    sbustamento = true;
                }
                rs.close();
                pstmt.close();
                return sbustamento;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error getSbustamentoSoap " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsMessageInProcessamento() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(false);
    }

    public boolean existsMessageInProcessamentoByReference() throws GestoreMessaggiException {
        return this.existsMessageInProcessamento(true);
    }

    private boolean existsMessageInProcessamento(boolean rifMsg) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            try {
                StringBuffer bf = new StringBuffer();
                bf.append("SELECT ID_MESSAGGIO FROM ");
                bf.append(MESSAGGI);
                bf.append(" WHERE ");
                if (!rifMsg) {
                    bf.append("ID_MESSAGGIO=?");
                } else {
                    bf.append("RIFERIMENTO_MSG=?");
                }
                bf.append(" AND TIPO=? AND PROPRIETARIO<>?");
                pstmt = connectionDB.prepareStatement(bf.toString());
                pstmt.setString(1, this.idBusta);
                pstmt.setString(2, this.tipo);
                pstmt.setString(3, "GestoreMessaggi");
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    rs.close();
                    pstmt.close();
                    return true;
                }
                rs.close();
                pstmt.close();
                return false;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore existsMessageInProcessamento " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                return false;
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, null, null, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, null);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, -1, -1, tipoServizio, servizio, azione);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, -1, tipoServizio, servizio, azione);
    }

    public Vector<String> getIDMessaggi_ServizioApplicativo(String servizioApplicativo, String tipoServizio, String servizio, String azione, int counter, int offset) throws GestoreMessaggiException {
        return this.getIDMessaggi_ServizioApplicativo_engine(servizioApplicativo, counter, offset, tipoServizio, servizio, azione);
    }

    private Vector<String> getIDMessaggi_ServizioApplicativo_engine(String servizioApplicativo, int counter, int offset, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            Vector<String> ids = new Vector<String>();
            String queryString = null;
            try {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    if (offset >= 0) {
                        throw new GestoreMessaggiException("La funzione di ricerca tramite offset e limit non e' utilizzabile se nella configurazione della PdD non viene specificato il tipo di database");
                    }
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_MESSAGGIO as IdMsgServizioApplicativo FROM ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(",");
                    query.append(MESSAGGI);
                    if (tipoServizio != null || servizio != null || azione != null) {
                        query.append(",");
                        query.append("REPOSITORY_BUSTE");
                    }
                    query.append(" WHERE ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_MESSAGGIO=");
                    query.append(MESSAGGI);
                    query.append(".ID_MESSAGGIO AND ");
                    if (tipoServizio != null || servizio != null || azione != null) {
                        query.append("REPOSITORY_BUSTE");
                        query.append(".ID_MESSAGGIO=");
                        query.append(MESSAGGI);
                        query.append(".ID_MESSAGGIO AND ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(".TIPO=");
                        query.append(MESSAGGI);
                        query.append(".TIPO AND ");
                    }
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".SERVIZIO_APPLICATIVO=? AND ");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".INTEGRATION_MANAGER=1 AND ");
                    query.append(MESSAGGI);
                    query.append(".TIPO=? AND ");
                    query.append(MESSAGGI);
                    query.append(".PROPRIETARIO=? ");
                    if (tipoServizio != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(".TIPO_SERVIZIO=? ");
                    }
                    if (servizio != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(".SERVIZIO=? ");
                    }
                    if (azione != null) {
                        query.append("AND ");
                        query.append("REPOSITORY_BUSTE");
                        query.append(".AZIONE=? ");
                    }
                    query.append("ORDER BY ");
                    query.append(MESSAGGI);
                    query.append(".ORA_REGISTRAZIONE,");
                    query.append(MESSAGGI);
                    query.append(".ID_MESSAGGIO");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
                    sqlQueryObject.addFromTable(MESSAGGI);
                    if (tipoServizio != null || servizio != null || azione != null) {
                        sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    }
                    sqlQueryObject.addSelectAliasField(MSG_SERVIZI_APPLICATIVI, "ID_MESSAGGIO", "IdMsgServizioApplicativo");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_MESSAGGIO", "IdBustaMessaggio");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "TIPO", "TipoMessaggio");
                    sqlQueryObject.addSelectAliasField(MESSAGGI, MESSAGGI_COLUMN_ORA_REGISTRAZIONE, "OraMessaggio");
                    sqlQueryObject.addSelectField(MESSAGGI, MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO);
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI, "INTEGRATION_MANAGER");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO");
                    if (tipoServizio != null || servizio != null || azione != null) {
                        sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", "ID_MESSAGGIO", "IdBustaRepositoryBuste");
                        sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", "TIPO", "TipoBustaRepositoryBuste");
                        sqlQueryObject.addSelectAliasField("REPOSITORY_BUSTE", MESSAGGI_COLUMN_ORA_REGISTRAZIONE, "OraRepositoryBuste");
                        sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.ID_MESSAGGIO=MESSAGGI.ID_MESSAGGIO");
                        sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO=MESSAGGI.TIPO");
                    }
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO=?");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=1");
                    sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
                    sqlQueryObject.addWhereCondition("MESSAGGI.PROPRIETARIO=?");
                    if (tipoServizio != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "TIPO_SERVIZIO");
                        sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.TIPO_SERVIZIO=?");
                    }
                    if (servizio != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "SERVIZIO");
                        sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.SERVIZIO=?");
                    }
                    if (azione != null) {
                        sqlQueryObject.addSelectField("REPOSITORY_BUSTE", "AZIONE");
                        sqlQueryObject.addWhereCondition("REPOSITORY_BUSTE.AZIONE=?");
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQueryObject.addOrderBy("OraMessaggio");
                    sqlQueryObject.addOrderBy("IdBustaMessaggio");
                    sqlQueryObject.setSortType(true);
                    if (counter >= 0) {
                        sqlQueryObject.setLimit(counter);
                    }
                    if (offset >= 0) {
                        sqlQueryObject.setOffset(offset);
                    }
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, servizioApplicativo);
                pstmt.setString(2, "INBOX");
                pstmt.setString(3, "ConsegnaContenutiApplicativi");
                int indexPstmt = 4;
                if (tipoServizio != null) {
                    pstmt.setString(indexPstmt, tipoServizio);
                    ++indexPstmt;
                }
                if (servizio != null) {
                    pstmt.setString(indexPstmt, servizio);
                    ++indexPstmt;
                }
                if (azione != null) {
                    pstmt.setString(indexPstmt, azione);
                    ++indexPstmt;
                }
                rs = pstmt.executeQuery();
                int countLimit = 0;
                while (rs.next()) {
                    ids.add(rs.getString("IdMsgServizioApplicativo"));
                    if (counter < 0 || Configurazione.getSqlQueryObjectType() != null || ++countLimit != counter) continue;
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.getIDMessaggi_ServizioApplicativo_engine] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
            return ids;
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        this.eliminaDestinatarioMessaggio_serializable(servizioApplicativo, riferimentoMessaggio, 60000L, 100);
    }

    @Deprecated
    public void eliminaDestinatarioMessaggio_serializable(String servizioApplicativo, String riferimentoMessaggio, long attesaAttiva, int checkInterval) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            int oldTransactionIsolation = -1;
            try {
                oldTransactionIsolation = connectionDB.getTransactionIsolation();
                connectionDB.setAutoCommit(false);
                connectionDB.setTransactionIsolation(8);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (setIsolation)" + this.idBusta + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
            boolean deleteDestinatarioOK = false;
            long scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteDestinatarioOK && DateManager.getTimeMillis() < scadenzaWhile) {
                PreparedStatement pstmtDeleteSIL = null;
                try {
                    String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                    pstmtDeleteSIL = connectionDB.prepareStatement(query);
                    pstmtDeleteSIL.setString(1, this.idBusta);
                    pstmtDeleteSIL.setString(2, servizioApplicativo);
                    pstmtDeleteSIL.executeUpdate();
                    pstmtDeleteSIL.close();
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteDestinatarioOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtDeleteSIL != null) {
                            pstmtDeleteSIL.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (deleteDestinatarioOK) continue;
                try {
                    Thread.sleep(new Random().nextInt(checkInterval));
                }
                catch (Exception eRandom) {}
            }
            boolean deleteRiferimentoMsgOK = false;
            boolean eliminazioneRifCompleta = false;
            scadenzaWhile = DateManager.getTimeMillis() + attesaAttiva;
            while (!deleteRiferimentoMsgOK && DateManager.getTimeMillis() < scadenzaWhile) {
                Statement pstmtUpdateMsg = null;
                PreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    String query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? FOR UPDATE";
                    pstmt = connectionDB.prepareStatement(query);
                    pstmt.setString(1, this.idBusta);
                    rs = pstmt.executeQuery();
                    eliminazioneRifCompleta = !rs.next();
                    rs.close();
                    pstmt.close();
                    if (eliminazioneRifCompleta) {
                        StringBuffer queryUpdate = new StringBuffer();
                        queryUpdate.append("UPDATE ");
                        queryUpdate.append(MESSAGGI);
                        queryUpdate.append(" SET PROPRIETARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                        pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                        pstmtUpdateMsg.setString(1, "GestoreMessaggi");
                        pstmtUpdateMsg.setString(2, this.idBusta);
                        pstmtUpdateMsg.setString(3, "INBOX");
                        pstmtUpdateMsg.execute();
                        pstmtUpdateMsg.close();
                        this.addProprietarioIntoTable("INBOX", this.idBusta, "GestoreMessaggi");
                    }
                    connectionDB.commit();
                    stateful.updateConnection(connectionDB);
                    if (this.isRichiesta) {
                        this.openspcoopstate.setStatoRichiesta((IState)stateful);
                    } else {
                        this.openspcoopstate.setStatoRisposta((IState)stateful);
                    }
                    deleteRiferimentoMsgOK = true;
                }
                catch (Exception e) {
                    try {
                        if (pstmtUpdateMsg != null) {
                            pstmtUpdateMsg.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        if (pstmt != null) {
                            pstmt.close();
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                    try {
                        connectionDB.rollback();
                        stateful.updateConnection(connectionDB);
                        if (this.isRichiesta) {
                            this.openspcoopstate.setStatoRichiesta((IState)stateful);
                        } else {
                            this.openspcoopstate.setStatoRisposta((IState)stateful);
                        }
                    }
                    catch (Exception er) {
                        // empty catch block
                    }
                }
                if (!deleteRiferimentoMsgOK) {
                    try {
                        Thread.sleep(new Random().nextInt(checkInterval));
                    }
                    catch (Exception eRandom) {
                        // empty catch block
                    }
                }
                if (!eliminazioneRifCompleta) continue;
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio_serializable", riferimentoMessaggio, false);
            }
            try {
                connectionDB.setTransactionIsolation(oldTransactionIsolation);
                connectionDB.setAutoCommit(true);
                stateful.updateConnection(connectionDB);
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateful);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateful);
            }
            catch (Exception er) {
                String errorMsg = "GESTORE_MESSAGGI, error  eliminaDestinatarioMessaggio (ripristinoIsolation)" + this.idBusta + "/" + servizioApplicativo + ": " + er.getMessage();
                this.log.error((Object)errorMsg, (Throwable)er);
                throw new GestoreMessaggiException(errorMsg, er);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void eliminaDestinatarioMessaggio(String servizioApplicativo, String riferimentoMessaggio) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            Statement pstmtDeleteSIL = null;
            try {
                this.log.debug((Object)("DELETE MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO='" + this.idBusta + "' AND SERVIZIO_APPLICATIVO='" + servizioApplicativo + "'"));
                String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=? AND SERVIZIO_APPLICATIVO=?";
                pstmtDeleteSIL = connectionDB.prepareStatement(query);
                pstmtDeleteSIL.setString(1, this.idBusta);
                pstmtDeleteSIL.setString(2, servizioApplicativo);
                pstmtDeleteSIL.executeUpdate();
                pstmtDeleteSIL.close();
            }
            catch (Exception e) {
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO: " + e.getMessage();
                this.log.error((Object)msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
            Statement pstmtUpdateMsg = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                String query = "SELECT  * FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=?";
                pstmt = connectionDB.prepareStatement(query);
                pstmt.setString(1, this.idBusta);
                rs = pstmt.executeQuery();
                boolean eliminazioneRifCompleta = !rs.next();
                rs.close();
                pstmt.close();
                if (eliminazioneRifCompleta) {
                    RepositoryBuste repositoryBuste = new RepositoryBuste((IState)stateMSG, this.isRichiesta, this.protocolFactory);
                    repositoryBuste.eliminaUtilizzoPdDFromInBox(this.idBusta);
                    if (this.oneWayVersione11) {
                        repositoryBuste.eliminaBustaStatelessFromInBox(this.idBusta);
                    }
                    StringBuffer queryUpdate = new StringBuffer();
                    queryUpdate.append("UPDATE ");
                    queryUpdate.append(MESSAGGI);
                    queryUpdate.append(" SET PROPRIETARIO=? WHERE  ID_MESSAGGIO = ? AND TIPO=?");
                    pstmtUpdateMsg = connectionDB.prepareStatement(queryUpdate.toString());
                    pstmtUpdateMsg.setString(1, "GestoreMessaggi");
                    pstmtUpdateMsg.setString(2, this.idBusta);
                    pstmtUpdateMsg.setString(3, "INBOX");
                    stateMSG.getPreparedStatement().put("UPDATE aggiornaProprietarioMessaggioOpenSPCoop " + this.tipo + "/" + this.idBusta, (PreparedStatement)pstmtUpdateMsg);
                    this.addProprietarioIntoTable("INBOX", this.idBusta, "GestoreMessaggi");
                    boolean oldValue = false;
                    if (this.oneWayVersione11) {
                        oldValue = ((OpenSPCoopStateless)this.openspcoopstate).isUseConnection();
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(true);
                    }
                    this.openspcoopstate.commit();
                    if (this.oneWayVersione11) {
                        ((OpenSPCoopStateless)this.openspcoopstate).setUseConnection(oldValue);
                    }
                }
                if (eliminazioneRifCompleta) {
                    this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "eliminaDestinatarioMessaggio", riferimentoMessaggio, false);
                }
                if (this.isRichiesta) {
                    this.openspcoopstate.setStatoRichiesta((IState)stateMSG);
                }
                this.openspcoopstate.setStatoRisposta((IState)stateMSG);
            }
            catch (Exception e) {
                try {
                    if (pstmtUpdateMsg != null) {
                        pstmtUpdateMsg.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                String msgError = "ERROR ELIMINAZIONE DESTINATARIO MESSAGGIO, STEP 2: " + e.getMessage();
                this.log.error((Object)msgError, (Throwable)e);
                throw new GestoreMessaggiException(msgError, e);
            }
        } else if (!(this.openspcoopstate instanceof OpenSPCoopStateless) || this.oneWayVersione11) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public Vector<MessaggioServizioApplicativo> readMessaggiDaRiconsegnareIntoBox(int limit, boolean logQuery, boolean orderBy, Date riconsegna) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<MessaggioServizioApplicativo> idMsg = new Vector<MessaggioServizioApplicativo>();
            Statement pstmtMsgEliminati = null;
            ResultSet rs = null;
            String queryString = null;
            String tipo = null;
            try {
                tipo = "INBOX";
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT MESSAGGI.ID_MESSAGGIO as idmess, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO as sa, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_SOAP as sbSoap, ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.SBUSTAMENTO_INFO_PROTOCOL as sbProtocol ");
                    query.append(" MSG_SERVIZI_APPLICATIVI.NOME_PORTA as nomePorta ");
                    query.append(" FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ");
                    query.append(" ");
                    query.append(MESSAGGI);
                    query.append(".ID_MESSAGGIO=");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(".ID_MESSAGGIO AND ");
                    query.append(" ").append(MESSAGGI).append(".TIPO=? AND ").append(MESSAGGI).append(".PROPRIETARIO=? ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".TIPO_CONSEGNA=? ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".ERRORE_PROCESSAMENTO is not null ");
                    query.append(" AND ").append(MSG_SERVIZI_APPLICATIVI).append(".RISPEDIZIONE<=? ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI, "m");
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI, "sa");
                    sqlQueryObject.addSelectAliasField("m", "ID_MESSAGGIO", "idmess");
                    sqlQueryObject.addSelectAliasField("sa", MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO, "sa");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_SOAP", "sbSoap");
                    sqlQueryObject.addSelectAliasField("sa", "SBUSTAMENTO_INFO_PROTOCOL", "sbProtocol");
                    sqlQueryObject.addSelectAliasField("sa", "NOME_PORTA", "nomePorta");
                    sqlQueryObject.addSelectField("m", MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addSelectField("m", MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("m", "TIPO");
                    sqlQueryObject.addWhereCondition("m.ID_MESSAGGIO=sa.ID_MESSAGGIO");
                    sqlQueryObject.addWhereCondition("m.TIPO=?");
                    sqlQueryObject.addWhereCondition("m.PROPRIETARIO=?");
                    sqlQueryObject.addWhereCondition("sa.TIPO_CONSEGNA=?");
                    sqlQueryObject.addWhereCondition("sa.ERRORE_PROCESSAMENTO is not null");
                    sqlQueryObject.addWhereCondition("sa.RISPEDIZIONE<=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("m.ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgEliminati = connectionDB.prepareStatement(queryString);
                pstmtMsgEliminati.setString(1, tipo);
                pstmtMsgEliminati.setString(2, "ConsegnaContenutiApplicativi");
                pstmtMsgEliminati.setString(3, CONSEGNA_TRAMITE_CONNETTORE);
                pstmtMsgEliminati.setTimestamp(4, new Timestamp(riconsegna.getTime()));
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + "ConsegnaContenutiApplicativi" + "] 3[" + CONSEGNA_TRAMITE_CONNETTORE + "] 4[" + riconsegna.toString() + "]..."));
                }
                rs = pstmtMsgEliminati.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + "ConsegnaContenutiApplicativi" + "] 3[" + CONSEGNA_TRAMITE_CONNETTORE + "] 4[" + riconsegna.toString() + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    MessaggioServizioApplicativo msg = new MessaggioServizioApplicativo();
                    msg.setIdMessaggio(rs.getString("idmess"));
                    msg.setServizioApplicativo(rs.getString("sa"));
                    int sbSoap = rs.getInt("sbSoap");
                    msg.setSbustamentoSoap(sbSoap == 1);
                    int sbInfoProt = rs.getInt("sbProtocol");
                    msg.setSbustamentoInformazioniProtocollo(sbInfoProt == 1);
                    msg.setNomePorta(rs.getString("nomePorta"));
                    idMsg.add(msg);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                pstmtMsgEliminati.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiInutiliIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgEliminati != null) {
                        pstmtMsgEliminati.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMessaggiInutiliIntoInbox(String idModuloCleaner, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(true, idModuloCleaner, limit, logQuery, orderBy);
    }

    public Vector<String> readMessaggiInutiliIntoOutbox(String idModuloCleaner, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        return this.readMessaggiInutiliIntoBox(false, idModuloCleaner, limit, logQuery, orderBy);
    }

    private Vector<String> readMessaggiInutiliIntoBox(boolean searchIntoInbox, String idModuloCleaner, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgEliminati = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE TIPO=? AND PROPRIETARIO=? ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereCondition("PROPRIETARIO=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgEliminati = connectionDB.prepareStatement(queryString);
                pstmtMsgEliminati.setString(1, tipo);
                pstmtMsgEliminati.setString(2, idModuloCleaner);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + idModuloCleaner + "] ..."));
                }
                rs = pstmtMsgEliminati.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.eliminatiLogicamente) [" + queryString + "] 1[" + tipo + "] 2[" + idModuloCleaner + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgEliminati.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiInutiliIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgEliminati != null) {
                        pstmtMsgEliminati.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMessaggiScadutiIntoInbox(long scadenzaMsg, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(true, scadenzaMsg, limit, logQuery, orderBy);
    }

    public Vector<String> readMessaggiScadutiIntoOutbox(long scadenzaMsg, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        return this.readMessaggiScadutiIntoBox(false, scadenzaMsg, limit, logQuery, orderBy);
    }

    private Vector<String> readMessaggiScadutiIntoBox(boolean searchIntoInbox, long scadenzaMsg, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipo = null;
                tipo = searchIntoInbox ? "INBOX" : "OUTBOX";
                long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ORA_REGISTRAZIONE AND TIPO=?");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, tipo);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + scandenzaT + "] 2[" + tipo + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scaduti) [" + queryString + "] 1[" + scandenzaT + "] 2[" + tipo + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMessaggiScadutiIntoBox] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public boolean existsServiziApplicativiDestinatariMessaggio() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            PreparedStatement pstmtExistsAnotherServiziApplicativi = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                StringBuffer query = new StringBuffer();
                query.append("SELECT SERVIZIO_APPLICATIVO FROM ");
                query.append(MSG_SERVIZI_APPLICATIVI);
                query.append(" WHERE ID_MESSAGGIO=?");
                queryString = query.toString();
                pstmtExistsAnotherServiziApplicativi = connectionDB.prepareStatement(queryString);
                pstmtExistsAnotherServiziApplicativi.setString(1, this.idBusta);
                rs = pstmtExistsAnotherServiziApplicativi.executeQuery();
                boolean risultato = rs.next();
                rs.close();
                pstmtExistsAnotherServiziApplicativi.close();
                return risultato;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.existsServiziApplicativiDestinatariMessaggio] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtExistsAnotherServiziApplicativi != null) {
                        pstmtExistsAnotherServiziApplicativi.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMsgForRicezioneContenutiApplicativiNonGestiti(long timeout, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT MESSAGGI.ID_MESSAGGIO as identificativoBusta,MSG_SERVIZI_APPLICATIVI.SERVIZIO_APPLICATIVO FROM ");
                    query.append(MESSAGGI);
                    query.append(",");
                    query.append(MSG_SERVIZI_APPLICATIVI);
                    query.append(" WHERE ? > MESSAGGI.ORA_REGISTRAZIONE AND MESSAGGI.RIFERIMENTO_MSG IS NOT NULL AND MESSAGGI.TIPO=? AND MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=? AND MESSAGGI.PROPRIETARIO LIKE 'RicezioneContenutiApplicativi%' AND MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=? AND MESSAGGI.ID_MESSAGGIO=MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO ");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addFromTable(MSG_SERVIZI_APPLICATIVI);
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "ID_MESSAGGIO", "identificativoBusta");
                    sqlQueryObject.addSelectField(MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO);
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                    sqlQueryObject.addSelectAliasField(MESSAGGI, "TIPO", "TipoMessaggio");
                    sqlQueryObject.addSelectField("TIPO_CONSEGNA");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField("INTEGRATION_MANAGER");
                    sqlQueryObject.addWhereCondition("? > MESSAGGI.ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("MESSAGGI.RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("MESSAGGI.TIPO=?");
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.TIPO_CONSEGNA=?");
                    sqlQueryObject.addWhereLikeCondition("MESSAGGI.PROPRIETARIO", "RicezioneContenutiApplicativi", true, true);
                    sqlQueryObject.addWhereCondition("MSG_SERVIZI_APPLICATIVI.INTEGRATION_MANAGER=?");
                    sqlQueryObject.addWhereCondition("MESSAGGI.ID_MESSAGGIO=MSG_SERVIZI_APPLICATIVI.ID_MESSAGGIO");
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy("MESSAGGI.ORA_REGISTRAZIONE");
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "INBOX");
                pstmtMsgScaduti.setString(3, CONSEGNA_TRAMITE_CONNECTION_REPLY);
                pstmtMsgScaduti.setLong(4, 0L);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "INBOX" + "] 3[" + CONSEGNA_TRAMITE_CONNECTION_REPLY + "] 4[" + 0 + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] Messaggi.scadutiPerRicezioneContenutiApplicativi) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "INBOX" + "] 3[" + CONSEGNA_TRAMITE_CONNECTION_REPLY + "] 4[" + 0 + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("identificativoBusta") + "@" + rs.getString(MSG_SERVIZI_APPLICATIVI_COLUMN_SERVIZIO_APPLICATIVO));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneContenutiApplicativiNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readMsgForRicezioneBusteNonGestiti(long timeout, int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Vector<String> idMsg = new Vector<String>();
            Statement pstmtMsgScaduti = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                long scadenza = DateManager.getTimeMillis() - timeout;
                Timestamp scandenzaT = new Timestamp(scadenza);
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ID_MESSAGGIO FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ? > ORA_REGISTRAZIONE AND RIFERIMENTO_MSG IS NOT NULL AND TIPO=? AND PROPRIETARIO LIKE 'RicezioneBuste%'");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_RIFERIMENTO_MSG);
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_PROPRIETARIO);
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addFromTable(MESSAGGI);
                    sqlQueryObject.addWhereCondition("? > ORA_REGISTRAZIONE");
                    sqlQueryObject.addWhereCondition("RIFERIMENTO_MSG IS NOT NULL");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    sqlQueryObject.addWhereLikeCondition(MESSAGGI_COLUMN_PROPRIETARIO, "RicezioneBuste", true, true);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
                pstmtMsgScaduti.setTimestamp(1, scandenzaT);
                pstmtMsgScaduti.setString(2, "OUTBOX");
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.scadutiPerRicezioneBuste) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "OUTBOX" + "]..."));
                }
                rs = pstmtMsgScaduti.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] Messaggi.scadutiPerRicezioneBuste) [" + queryString + "] 1[" + scandenzaT + "] 2[" + "OUTBOX" + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    idMsg.add(rs.getString("ID_MESSAGGIO"));
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                }
                rs.close();
                pstmtMsgScaduti.close();
                return idMsg;
            }
            catch (Exception e) {
                String errorMsg = "[GestoreMessaggi.readMsgForRicezioneBusteNonGestiti] errore, queryString[" + queryString + "]: " + e.getMessage();
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtMsgScaduti != null) {
                        pstmtMsgScaduti.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public Vector<String> readBusteNonRiferiteDaMessaggiFromInBox(int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        return this.readBusteNonRiferiteDaMessaggi("INBOX", limit, logQuery, forceIndex, orderBy);
    }

    public Vector<String> readBusteNonRiferiteDaMessaggiFromOutBox(int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        return this.readBusteNonRiferiteDaMessaggi("OUTBOX", limit, logQuery, forceIndex, orderBy);
    }

    private Vector<String> readBusteNonRiferiteDaMessaggi(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean orderBy) throws ProtocolException, GestoreMessaggiException {
        Vector<String> idBuste = new Vector<String>();
        int pdd = 0;
        int profilo = 0;
        int pddProfilo = 0;
        this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, true, false, idBuste);
        pdd = idBuste.size();
        if (idBuste.size() < limit) {
            this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, false, true, idBuste);
            profilo = idBuste.size() - pdd;
        }
        if (idBuste.size() < limit) {
            this._engine_ReadBusteNonRiferiteDaMessaggi(tipoBusta, limit, logQuery, forceIndex, orderBy, true, true, idBuste);
            pddProfilo = idBuste.size() - pdd - profilo;
        }
        if (logQuery) {
            this.log.debug((Object)("[" + tipoBusta + "] Trovati messaggi cosi suddivisi pdd[" + pdd + "] profilo[" + profilo + "] pddAndProfilo[" + pddProfilo + "]"));
        }
        return idBuste;
    }

    private void _engine_ReadBusteNonRiferiteDaMessaggi(String tipoBusta, int limit, boolean logQuery, boolean forceIndex, boolean orderBy, boolean pdd, boolean profilo, Vector<String> idBuste) throws ProtocolException, GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateful.getConnectionDB();
            Statement pstmt = null;
            ResultSet rs = null;
            String queryString = null;
            try {
                String tipoRovesciato = null;
                tipoRovesciato = "INBOX".equals(tipoBusta) ? "OUTBOX" : "INBOX";
                IGestoreRepository gestoreRepositoryBuste = Configurazione.getGestoreRepositoryBuste();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    if (pdd && profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    query.append(" AND ");
                    query.append("(");
                    query.append("  NOT EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryBuste.createSQLFields());
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    if (pdd && profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    ISQLQueryObject sqlQueryObjectAsincronoNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoNotExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoNotExists.addWhereCondition(true, new String[]{"ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectAsincronoNotExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setString(2, tipoRovesciato);
                long startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "]..."));
                }
                rs = pstmt.executeQuery();
                long endDateSQLCommand = DateManager.getTimeMillis();
                long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteNonRiferite) [" + queryString + "] 1[" + tipoBusta + "] 2[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                int countLimit = 0;
                while (rs.next()) {
                    String id = rs.getString("ID_MESSAGGIO");
                    if (idBuste.contains(id)) continue;
                    idBuste.add(id);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                pstmt.close();
                if (Configurazione.getSqlQueryObjectType() == null) {
                    StringBuffer query = new StringBuffer();
                    query.append("SELECT ");
                    if (forceIndex) {
                        query.append("/*+ index(REPOSITORY_BUSTE REP_BUSTE_SEARCH_TIPO) */");
                    }
                    query.append(" ID_MESSAGGIO FROM ");
                    query.append("REPOSITORY_BUSTE");
                    query.append(" WHERE ");
                    query.append(" TIPO=? AND ");
                    if (pdd && profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        query.append(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    query.append(" AND ");
                    query.append("(");
                    query.append("  EXISTS (");
                    query.append("  SELECT * FROM ");
                    query.append("ASINCRONO");
                    query.append("  WHERE ");
                    query.append("    ( ");
                    query.append("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO AND ");
                    query.append("REPOSITORY_BUSTE.SCADENZA_BUSTA < ?");
                    query.append("    ) ");
                    query.append("  )");
                    query.append(") AND ");
                    query.append("(");
                    query.append(" NOT EXISTS (");
                    query.append(" SELECT * FROM ");
                    query.append(MESSAGGI);
                    query.append(" WHERE ");
                    query.append("( ");
                    query.append("MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO");
                    query.append(" ) OR ( ");
                    query.append("MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO AND ");
                    query.append("MESSAGGI.TIPO=?");
                    query.append(" ) ");
                    query.append(")");
                    query.append(")");
                    queryString = query.toString();
                } else {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    if (forceIndex) {
                        sqlQueryObject.addSelectForceIndex("REPOSITORY_BUSTE", "REP_BUSTE_SEARCH_TIPO");
                    }
                    sqlQueryObject.addSelectField("ID_MESSAGGIO");
                    sqlQueryObject.addSelectField("TIPO");
                    sqlQueryObject.addSelectField(gestoreRepositoryBuste.createSQLFields());
                    sqlQueryObject.addSelectField(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                    sqlQueryObject.addFromTable("REPOSITORY_BUSTE");
                    sqlQueryObject.addWhereCondition("TIPO=?");
                    if (pdd && profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPddAndProfilo());
                    } else if (pdd) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyPdd());
                    } else if (profilo) {
                        sqlQueryObject.addWhereCondition(gestoreRepositoryBuste.createSQLCondition_enableOnlyProfilo());
                    } else {
                        throw new Exception("Utilizzo errato del metodo, almeno una indicazione tra pdd e profilo deve essere fornita");
                    }
                    ISQLQueryObject sqlQueryObjectAsincronoExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectAsincronoExists.addFromTable("ASINCRONO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("ASINCRONO.TIPO=REPOSITORY_BUSTE.TIPO");
                    sqlQueryObjectAsincronoExists.addWhereCondition("REPOSITORY_BUSTE.SCADENZA_BUSTA < ?");
                    sqlQueryObjectAsincronoExists.setANDLogicOperator(true);
                    sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectAsincronoExists);
                    ISQLQueryObject sqlQueryObjectMessaggiNotExists = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                    sqlQueryObjectMessaggiNotExists.addFromTable(MESSAGGI);
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.ID_MESSAGGIO=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=REPOSITORY_BUSTE.TIPO"});
                    sqlQueryObjectMessaggiNotExists.addWhereCondition(true, new String[]{"MESSAGGI.RIFERIMENTO_MSG=REPOSITORY_BUSTE.ID_MESSAGGIO", "MESSAGGI.TIPO=?"});
                    sqlQueryObjectMessaggiNotExists.setANDLogicOperator(false);
                    sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectMessaggiNotExists);
                    sqlQueryObject.setANDLogicOperator(true);
                    if (orderBy) {
                        sqlQueryObject.addOrderBy(MESSAGGI_COLUMN_ORA_REGISTRAZIONE);
                        sqlQueryObject.setSortType(true);
                    }
                    sqlQueryObject.setLimit(limit);
                    queryString = sqlQueryObject.createSQLQuery();
                }
                Timestamp now = DateManager.getTimestamp();
                pstmt = connectionDB.prepareStatement(queryString);
                pstmt.setString(1, tipoBusta);
                pstmt.setTimestamp(2, now);
                pstmt.setString(3, tipoRovesciato);
                startDateSQLCommand = DateManager.getTimeMillis();
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + now + "] 3[" + tipoRovesciato + "]..."));
                }
                rs = pstmt.executeQuery();
                endDateSQLCommand = DateManager.getTimeMillis();
                secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
                if (logQuery) {
                    this.log.debug((Object)("[QUERY] (Messaggi.busteNonRiferite_asincrono) [" + queryString + "] 1[" + tipoBusta + "] 2[" + now + "] 3[" + tipoRovesciato + "] effettuata in " + secondSQLCommand + " secondi"));
                }
                countLimit = 0;
                while (rs.next()) {
                    String id = rs.getString("ID_MESSAGGIO");
                    if (idBuste.contains(id)) continue;
                    idBuste.add(id);
                    if (Configurazione.getSqlQueryObjectType() != null || ++countLimit != limit) continue;
                    break;
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception e) {
                String errorMsg = "[RepositoryBuste.getBusteDaEliminare] errore, queryString[" + queryString + "]: " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                try {
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw new ProtocolException(errorMsg, (Throwable)e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public void logicDeleteMessage() throws GestoreMessaggiException {
        this.aggiornaProprietarioMessaggio_engine("GestoreMessaggi", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMessageWithLock(String causa, long attesaAttivaLock, int checkIntervalLock) throws GestoreMessaggiException {
        try {
            try {
                GestoreMessaggi.acquireLock(this.msgDiag, causa, attesaAttivaLock, checkIntervalLock);
            }
            catch (Exception e) {
                throw new GestoreMessaggiException(e.getMessage(), e);
            }
            this.deleteMessage();
        }
        finally {
            try {
                GestoreMessaggi.releaseLock(this.msgDiag, causa);
            }
            catch (Exception e) {}
        }
    }

    public void deleteMessageWithoutLock() throws GestoreMessaggiException {
        this.deleteMessage();
    }

    private void deleteMessage() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful || this.oneWayVersione11) {
            StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
            Connection connectionDB = stateMSG.getConnectionDB();
            PreparedStatement pstmtDeleteSIL = null;
            Statement pstmtDeleteMSG = null;
            try {
                if ("INBOX".equals(this.tipo)) {
                    String query = "DELETE FROM MSG_SERVIZI_APPLICATIVI WHERE ID_MESSAGGIO=?";
                    pstmtDeleteSIL = connectionDB.prepareStatement(query);
                    pstmtDeleteSIL.setString(1, this.idBusta);
                    pstmtDeleteSIL.execute();
                    pstmtDeleteSIL.close();
                }
                SoapMessage msgDelete = new SoapMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
                msgDelete.delete(this.isRichiesta, this.oneWayVersione11);
                String query = "DELETE FROM MESSAGGI WHERE ID_MESSAGGIO=? AND TIPO=?";
                pstmtDeleteMSG = connectionDB.prepareStatement(query);
                pstmtDeleteMSG.setString(1, this.idBusta);
                pstmtDeleteMSG.setString(2, this.tipo);
                pstmtDeleteMSG.execute();
                pstmtDeleteMSG.close();
                GestoreMessaggi.deleteFromCache_Proprietario("GestoreMessaggi", this.tipo, this.idBusta);
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                try {
                    if (pstmtDeleteMSG != null) {
                        pstmtDeleteMSG.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                try {
                    if (pstmtDeleteSIL != null) {
                        pstmtDeleteSIL.close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        if (!(this.openspcoopstate instanceof OpenSPCoopStateless)) {
            throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
        }
    }

    public void deleteMessageFromFileSystem() {
        SoapMessage msgDelete = null;
        try {
            msgDelete = new SoapMessage(this.idBusta, this.openspcoopstate, this.tipo, this.workDir, adapter, this.log);
            msgDelete.deleteMessageFromFileSystem();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error deleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
        }
    }

    public void validateAndDeleteMsgOneWayRiscontrato() throws GestoreMessaggiException, ProtocolException {
        StateMessage stateMSG = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        Riscontri gestoreRiscontri = null;
        try {
            gestoreRiscontri = new Riscontri((IState)stateMSG);
            gestoreRiscontri.validazioneRiscontroRicevuto(this.idBusta);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgOneWayRiscontrato", null, false);
    }

    public void validateAndDeleteMsgAsincronoRiscontrato(Busta bustaRicevuta) throws GestoreMessaggiException, ProtocolException {
        StateMessage state = this.isRichiesta ? (StateMessage)this.openspcoopstate.getStatoRichiesta() : (StateMessage)this.openspcoopstate.getStatoRisposta();
        ProfiloDiCollaborazione profiloCollaborazione = null;
        try {
            profiloCollaborazione = new ProfiloDiCollaborazione((IState)state, this.protocolFactory);
            profiloCollaborazione.asincrono_valdazioneRicevuta(bustaRicevuta);
            this.aggiornaProprietarioMessaggio("GestoreMessaggi");
            this.openspcoopstate.commit();
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error validateAndDeleteMsgRiscontrato " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
        this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "validateAndDeleteMsgAsincronoRiscontrato", null, false);
    }

    public boolean forcedDeleteMessage() throws GestoreMessaggiException {
        if (this.openspcoopstate instanceof OpenSPCoopStateful) {
            StatefulMessage stateful = this.isRichiesta ? (StatefulMessage)this.openspcoopstate.getStatoRichiesta() : (StatefulMessage)this.openspcoopstate.getStatoRisposta();
            RollbackRepositoryBuste rollbackMessaggio = null;
            RollbackRepositoryBuste rollbackRepository = null;
            try {
                String strMessageSelector;
                if (!this.existsMessage_noCache()) {
                    return false;
                }
                String rifMsg = this.getRiferimentoMessaggio();
                JMSReceiver receiverJMS = null;
                if ("jms".equals(this.propertiesReader.getNodeReceiver())) {
                    String idT = PdDContext.getValue("ID", this.pddContext);
                    String protocol = null;
                    if (this.protocolFactory != null) {
                        protocol = this.protocolFactory.getProtocol();
                    }
                    receiverJMS = new JMSReceiver(this.propertiesReader.getIdentitaPortaDefault(protocol), "ForcedDeleteMessage", this.propertiesReader.singleConnection_NodeReceiver(), this.log, idT);
                }
                if ("INBOX".equals(this.tipo)) {
                    rollbackMessaggio = new RollbackRepositoryBuste(this.idBusta, (IState)stateful, this.oneWayVersione11);
                    rollbackMessaggio.rollbackBustaIntoInBox();
                    if (rifMsg == null) {
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + this.idBusta + "'")) {
                            this.log.info((Object)("Trovato messaggio nella coda RicezioneBuste con id [" + this.idBusta + "] non consumato"));
                        }
                    } else {
                        rollbackRepository = new RollbackRepositoryBuste(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackRepository.rollbackBustaIntoOutBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info((Object)("Trovato messaggio (tramite riferimento) nella coda RicezioneContenutiApplicativi con id [" + rifMsg + "] non consumato"));
                        }
                    }
                } else {
                    rollbackMessaggio = new RollbackRepositoryBuste(this.idBusta, (IState)stateful, this.oneWayVersione11);
                    rollbackMessaggio.rollbackBustaIntoOutBox();
                    if (rifMsg == null) {
                        if (receiverJMS != null && receiverJMS.clean("RicezioneContenutiApplicativi", strMessageSelector = "ID = '" + this.idBusta + "'")) {
                            this.log.info((Object)("Trovato messaggio nella coda RicezioneContenutiApplicativi con id [" + this.idBusta + "] non consumato"));
                        }
                    } else {
                        rollbackRepository = new RollbackRepositoryBuste(rifMsg, (IState)stateful, this.oneWayVersione11);
                        rollbackRepository.rollbackBustaIntoInBox(false);
                        if (receiverJMS != null && receiverJMS.clean("RicezioneBuste", strMessageSelector = "ID = '" + rifMsg + "'")) {
                            this.log.info((Object)("Trovato messaggio (tramite riferimento) nella coda RicezioneBuste con id [" + rifMsg + "] non consumato"));
                        }
                    }
                }
                this.aggiornaProprietarioMessaggio("GestoreMessaggi");
                this.openspcoopstate.commit();
                this.addProprietariIntoCache_readFromTable("GestoreMessaggi", "forcedDeleteMessage", this.getRiferimentoMessaggio(), false);
                return true;
            }
            catch (Exception e) {
                String errorMsg = "GESTORE_MESSAGGI, Errore forcedDeleteMessage " + this.tipo + "/" + this.idBusta + ": " + e.getMessage();
                this.log.error((Object)errorMsg, (Throwable)e);
                throw new GestoreMessaggiException(errorMsg, e);
            }
        }
        throw new GestoreMessaggiException("Metodo invocato con OpenSPCoopState non valido");
    }

    public OpenSPCoop2Message buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi(IDSoggetto soggettoMittente, String tipoServizio, String servizio, String azione) throws GestoreMessaggiException {
        try {
            String msg = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n<soapenv:Body>\n<pubblicazioneMessaggio xmlns=\"http://gestoreeventi.openspcoop.org\"><richiesta xmlns:types=\"http://types.gestoreeventi.openspcoop.org\"><types:idMessaggio>" + this.idBusta + "</types:idMessaggio>" + "<types:soggetto><types:nome>" + soggettoMittente.getNome() + "</types:nome><types:tipo>" + soggettoMittente.getTipo() + "</types:tipo></types:soggetto>" + "<types:servizio><types:nome>" + servizio + "</types:nome><types:tipo>" + tipoServizio + "</types:tipo></types:servizio>" + "<types:tipoEvento>" + azione + "</types:tipoEvento>" + "</richiesta></pubblicazioneMessaggio>\n" + "</soapenv:Body>\n" + "</soapenv:Envelope>";
            return OpenSPCoop2MessageFactory.getMessageFactory().createMessage(SOAPVersion.SOAP11, msg);
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRichiestaPubblicazioneMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public OpenSPCoop2Message buildRispostaPrelevamentoMessaggio_RepositoryMessaggi(byte[] messaggio, SOAPVersion versioneSoap) throws GestoreMessaggiException {
        try {
            String namespace = "SOAP11".equals(versioneSoap) ? "http://schemas.xmlsoap.org/soap/envelope/" : "http://www.w3.org/2003/05/soap-envelope";
            String msgUpper = "<soapenv:Envelope xmlns:soapenv=\"" + namespace + "\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n" + "<soapenv:Body>\n" + "<prelevaMessaggioResponse xmlns=\"http://gestoreeventi.openspcoop.org\">" + "<prelevaMessaggioReturn>";
            String msgDown = "</prelevaMessaggioReturn></prelevaMessaggioResponse>\n</soapenv:Body>\n</soapenv:Envelope>";
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            bout.write(msgUpper.getBytes());
            bout.write(Base64.encode((byte[])messaggio).getBytes());
            bout.write(msgDown.getBytes());
            return OpenSPCoop2MessageFactory.getMessageFactory().createMessage(versioneSoap, bout.toByteArray());
        }
        catch (Exception e) {
            String errorMsg = "GESTORE_MESSAGGI, error buildRispostaPrelevamentoMessaggio_RepositoryMessaggi: " + e.getMessage();
            this.log.error((Object)errorMsg, (Throwable)e);
            throw new GestoreMessaggiException(errorMsg, e);
        }
    }

    public void setReadyForDrop(boolean readyForDrop) {
        this.readyForDrop = readyForDrop;
    }

    public void setOneWayVersione11(boolean oneWay11) {
        this.oneWayVersione11 = oneWay11;
    }

    public boolean isOneWayVersione11() {
        return this.oneWayVersione11;
    }

    public void setPortaDiTipoStateless(boolean portaDiTipoStateless) {
        this.portaDiTipoStateless = portaDiTipoStateless;
    }

    public void setRoutingStateless(boolean routingStateless) {
        this.routingStateless = routingStateless;
    }

    public boolean isRichiesta() {
        return this.isRichiesta;
    }

    public void setRichiesta(boolean isRichiesta) {
        this.isRichiesta = isRichiesta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void acquireLock(MsgDiagnostico msgDiag, String causa, long attesaAttivaLock, int checkIntervalLock) throws InterruptedException {
        msgDiag.addKeyword("@CAUSA_LOCK@", causa);
        msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneLock.inCorso");
        StringBuffer stringBuffer = LOCK;
        synchronized (stringBuffer) {
            if (LOCK.length() > 0) {
                msgDiag.addKeyword("@CAUSA_LOCK@", LOCK.toString());
                msgDiag.addKeyword("@ID_MODULO_PROPRIETARIO_LOCK@", LOCK_MODULO);
                msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneLock.wait.existsOldOwner");
            } else {
                msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneLock.wait.withoutOwner");
            }
        }
        boolean lockAcquired = LOCK_SEMAPHORE.tryAcquire(attesaAttivaLock, TimeUnit.MILLISECONDS);
        if (!lockAcquired) {
            throw new InterruptedException("Timeout: lock non disponibile dopo una attesa di " + attesaAttivaLock + "ms (attuale modulo proprietario: " + LOCK_MODULO + ", causa: " + LOCK.toString() + ")");
        }
        LOCK.append(causa);
        LOCK_MODULO = msgDiag.getFunzione();
        msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneLock.ok");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseLock(MsgDiagnostico msgDiag, String causa) throws InterruptedException {
        msgDiag.addKeyword("@CAUSA_LOCK@", causa);
        msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneUnlock.inCorso");
        if (LOCK.length() <= 0) {
            msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneUnlock.ko");
            throw new InterruptedException(msgDiag.getMessaggio_replaceKeywords("all", "deleteMessage.acquisizioneUnlock.ko"));
        }
        StringBuffer stringBuffer = LOCK;
        synchronized (stringBuffer) {
            LOCK.delete(0, LOCK.length());
            LOCK_MODULO = null;
        }
        LOCK_SEMAPHORE.release();
        msgDiag.logPersonalizzato("all.", "deleteMessage.acquisizioneUnlock.ok");
    }
}

