/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaElemento;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorrelazioneApplicativaRispostaElemento;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.message.DynamicNamespaceContextFactory;
import org.openspcoop2.message.XPathExpressionEngine;
import org.openspcoop2.pdd.core.GestoreMessaggiException;
import org.openspcoop2.pdd.core.integrazione.HeaderIntegrazione;
import org.openspcoop2.protocol.engine.Configurazione;
import org.openspcoop2.protocol.engine.URLProtocolContext;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroreIntegrazione;
import org.openspcoop2.protocol.sdk.constants.ErroriIntegrazione;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.state.StateMessage;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.xml.DynamicNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GestoreCorrelazioneApplicativa {
    private Logger log = null;
    public static final String CORRELAZIONE_APPLICATIVA = "CORRELAZIONE_APPLICATIVA";
    public static final String CORRELAZIONE_APPLICATIVA_COLUMN_ID_APPLICATIVO = "ID_APPLICATIVO";
    private IState state;
    private String idBustaCorrelato;
    private String idCorrelazione;
    private ErroreIntegrazione errore;
    private IDSoggetto soggettoFruitore;
    private IDServizio idServizio;
    private String servizioApplicativo;
    private boolean riusoIdentificativo = false;
    private IProtocolFactory protocolFactory = null;

    public boolean isRiusoIdentificativo() {
        return this.riusoIdentificativo;
    }

    public GestoreCorrelazioneApplicativa(IState state, Logger alog, IDSoggetto soggettoFruitore, IDServizio idServizio, String servizioApplicativo, IProtocolFactory protocolFactory) {
        this.state = state;
        this.log = alog != null ? alog : Logger.getLogger(GestoreCorrelazioneApplicativa.class);
        this.soggettoFruitore = soggettoFruitore;
        this.idServizio = idServizio;
        this.servizioApplicativo = servizioApplicativo;
        this.protocolFactory = protocolFactory;
    }

    public GestoreCorrelazioneApplicativa(IState state, Logger alog, IProtocolFactory protocolFactory) {
        this(state, alog, null, null, null, protocolFactory);
    }

    public boolean verificaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, URLProtocolContext urlProtocolContext, SOAPEnvelope envelope, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        int elem;
        if (correlazioneApplicativa == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("dati per l'identificazione dell'id di correlazione non presenti");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        NodeList nList = null;
        try {
            if (envelope.getBody() == null || !envelope.getBody().hasChildNodes()) {
                throw new Exception("Body applicativo non presente nel messaggio Soap");
            }
            nList = envelope.getBody().getChildNodes();
            if (nList == null || nList.getLength() == 0) {
                throw new Exception("Elementi del Body non presenti?");
            }
        }
        catch (Exception e) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: " + e.getMessage());
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
        Vector<CorrelazioneApplicativaElemento> c = new Vector<CorrelazioneApplicativaElemento>();
        int posizioneElementoQualsiasi = -1;
        for (int i = 0; i < correlazioneApplicativa.sizeElementoList(); ++i) {
            CorrelazioneApplicativaElemento elemento = correlazioneApplicativa.getElemento(i);
            if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                if (posizioneElementoQualsiasi != -1) {
                    this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: piu' di un elemento '*' non puo' essere definito");
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                }
                posizioneElementoQualsiasi = i;
                continue;
            }
            c.add(elemento);
        }
        if (posizioneElementoQualsiasi >= 0) {
            c.add(correlazioneApplicativa.getElemento(posizioneElementoQualsiasi));
        }
        boolean findCorrelazione = false;
        boolean correlazioneNonRiuscitaDaAccettare = false;
        String idCorrelazioneApplicativa = null;
        int posizioneUltimoNodo = -1;
        for (elem = 0; elem < nList.getLength(); ++elem) {
            Node nodeInEsame = nList.item(elem);
            if (nodeInEsame instanceof Text) continue;
            posizioneUltimoNodo = elem;
        }
        block14: for (elem = 0; elem < nList.getLength() && !findCorrelazione; ++elem) {
            String elementName = null;
            Node nodeInEsame = nList.item(elem);
            try {
                elementName = nodeInEsame.getLocalName();
            }
            catch (Exception e) {
                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("errore durante l'analisi dell'elementName: " + e.getMessage());
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
            if (nodeInEsame instanceof Text || elementName == null) continue;
            for (int i = 0; i < c.size(); ++i) {
                DynamicNamespaceContext dnc;
                CorrelazioneApplicativaElemento elemento = (CorrelazioneApplicativaElemento)c.get(i);
                boolean bloccaIdentificazioneNonRiuscita = true;
                if (CostantiConfigurazione.ACCETTA.equals(elemento.getIdentificazioneFallita())) {
                    bloccaIdentificazioneNonRiuscita = false;
                }
                boolean matchNodePerCorrelazioneApplicativa = false;
                String nomeElemento = null;
                if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = "*";
                    if (!(elem == posizioneUltimoNodo)) {
                        continue;
                    }
                } else if (elementName.equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = elemento.getNome();
                } else {
                    try {
                        dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
                        nomeElemento = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, elemento.getNome());
                        if (nomeElemento != null) {
                            matchNodePerCorrelazioneApplicativa = true;
                        }
                    }
                    catch (Exception e) {
                        this.log.info((Object)("Calcolo non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage()));
                    }
                }
                this.riusoIdentificativo = CostantiConfigurazione.ABILITATO.equals(elemento.getRiusoIdentificativo());
                if (!matchNodePerCorrelazioneApplicativa) continue;
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_DISABILITATO.equals(elemento.getIdentificazione())) {
                    correlazioneNonRiuscitaDaAccettare = true;
                    findCorrelazione = true;
                    continue block14;
                }
                if (readFirstHeaderIntegrazione && headerIntegrazione.getIdApplicativo() != null) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    findCorrelazione = true;
                    continue block14;
                }
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_URL_BASED.equals(elemento.getIdentificazione())) {
                    try {
                        idCorrelazioneApplicativa = RegularExpressionEngine.getStringMatchPattern((String)urlProtocolContext.getUrlInvocazione_formBased(), (String)elemento.getPattern());
                    }
                    catch (Exception e) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione urlBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                } else if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RICHIESTA_INPUT_BASED.equals(elemento.getIdentificazione())) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    if (idCorrelazioneApplicativa == null) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] " + "con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                } else {
                    try {
                        dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
                        idCorrelazioneApplicativa = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, elemento.getPattern());
                    }
                    catch (Exception e) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                        this.log.info((Object)("[AccettaIdentificazioneFallita] Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage()));
                    }
                }
                findCorrelazione = true;
                continue block14;
            }
        }
        if (idCorrelazioneApplicativa == null) {
            if (!correlazioneNonRiuscitaDaAccettare) {
                this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("Identificativo di correlazione applicativa non identificato; nessun elemento tra quelli di correlazione definiti, sono presenti nel body");
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
            return false;
        }
        this.idCorrelazione = idCorrelazioneApplicativa;
        if (this.riusoIdentificativo) {
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                StateMessage stateMSG = (StateMessage)this.state;
                Connection connectionDB = stateMSG.getConnectionDB();
                String valoreAzione = "(AZIONE is null)";
                if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                    valoreAzione = "AZIONE=?";
                }
                StringBuffer query = new StringBuffer();
                query.append("SELECT * FROM CORRELAZIONE_APPLICATIVA WHERE ID_APPLICATIVO=? AND SERVIZIO_APPLICATIVO=? AND TIPO_MITTENTE=? AND MITTENTE=? AND TIPO_DESTINATARIO=? AND DESTINATARIO=? AND TIPO_SERVIZIO=? AND SERVIZIO=? AND " + valoreAzione);
                pstmt = connectionDB.prepareStatement(query.toString());
                pstmt.setString(1, idCorrelazioneApplicativa);
                pstmt.setString(2, this.servizioApplicativo);
                pstmt.setString(3, this.soggettoFruitore.getTipo());
                pstmt.setString(4, this.soggettoFruitore.getNome());
                pstmt.setString(5, this.idServizio.getSoggettoErogatore().getTipo());
                pstmt.setString(6, this.idServizio.getSoggettoErogatore().getNome());
                pstmt.setString(7, this.idServizio.getTipoServizio());
                pstmt.setString(8, this.idServizio.getServizio());
                if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                    pstmt.setString(9, this.idServizio.getAzione());
                }
                if ((rs = pstmt.executeQuery()) == null) {
                    pstmt.close();
                    this.log.error((Object)"Verifica correlazione IDApplicativo - ID non riuscita: ResultSet is null?");
                    throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID non riuscita: ResultSet is null?");
                }
                boolean correlazionePresente = rs.next();
                if (correlazionePresente) {
                    this.idBustaCorrelato = rs.getString("ID_MESSAGGIO");
                }
                rs.close();
                pstmt.close();
            }
            catch (Exception er) {
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                this.log.error((Object)("Verifica correlazione IDApplicativo - ID non riuscita: " + er.getMessage()));
                throw new GestoreMessaggiException("Verifica correlazione IDApplicativo - ID non riuscita: " + er.getMessage());
            }
            return this.idBustaCorrelato != null;
        }
        return false;
    }

    public void verificaCorrelazioneRisposta(CorrelazioneApplicativaRisposta correlazioneApplicativa, SOAPEnvelope envelope, HeaderIntegrazione headerIntegrazione, boolean readFirstHeaderIntegrazione) throws GestoreMessaggiException, ProtocolException {
        int elem;
        if (correlazioneApplicativa == null) {
            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("dati per l'identificazione dell'id di correlazione non presenti");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        XPathExpressionEngine xPathEngine = new XPathExpressionEngine();
        NodeList nList = null;
        try {
            if (envelope.getBody() == null || !envelope.getBody().hasChildNodes()) {
                throw new Exception("Body applicativo non presente nel messaggio Soap");
            }
            nList = envelope.getBody().getChildNodes();
            if (nList == null || nList.getLength() == 0) {
                throw new Exception("Elementi del Body non presenti?");
            }
        }
        catch (Exception e) {
            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: " + e.getMessage());
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        Vector<CorrelazioneApplicativaRispostaElemento> c = new Vector<CorrelazioneApplicativaRispostaElemento>();
        int posizioneElementoQualsiasi = -1;
        for (int i = 0; i < correlazioneApplicativa.sizeElementoList(); ++i) {
            CorrelazioneApplicativaRispostaElemento elemento = correlazioneApplicativa.getElemento(i);
            if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                if (posizioneElementoQualsiasi != -1) {
                    this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: piu' di un elemento '*' non puo' essere definito");
                    throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                }
                posizioneElementoQualsiasi = i;
                continue;
            }
            c.add(elemento);
        }
        if (posizioneElementoQualsiasi >= 0) {
            c.add(correlazioneApplicativa.getElemento(posizioneElementoQualsiasi));
        }
        boolean findCorrelazione = false;
        boolean correlazioneNonRiuscitaDaAccettare = false;
        String idCorrelazioneApplicativa = null;
        int posizioneUltimoNodo = -1;
        for (elem = 0; elem < nList.getLength(); ++elem) {
            Node nodeInEsame = nList.item(elem);
            if (nodeInEsame instanceof Text) continue;
            posizioneUltimoNodo = elem;
        }
        block10: for (elem = 0; elem < nList.getLength() && !findCorrelazione; ++elem) {
            String elementName = null;
            Node nodeInEsame = nList.item(elem);
            try {
                elementName = nodeInEsame.getLocalName();
            }
            catch (Exception e) {
                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("errore durante l'analisi dell'elementName: " + e.getMessage());
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
            if (nodeInEsame instanceof Text || elementName == null) continue;
            for (int i = 0; i < c.size(); ++i) {
                DynamicNamespaceContext dnc;
                CorrelazioneApplicativaRispostaElemento elemento = (CorrelazioneApplicativaRispostaElemento)c.get(i);
                boolean bloccaIdentificazioneNonRiuscita = true;
                if (CostantiConfigurazione.ACCETTA.equals(elemento.getIdentificazioneFallita())) {
                    bloccaIdentificazioneNonRiuscita = false;
                }
                boolean matchNodePerCorrelazioneApplicativa = false;
                String nomeElemento = null;
                if (elemento.getNome() == null || "".equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = "*";
                    if (!(elem == posizioneUltimoNodo)) {
                        continue;
                    }
                } else if (elementName.equals(elemento.getNome())) {
                    matchNodePerCorrelazioneApplicativa = true;
                    nomeElemento = elemento.getNome();
                } else {
                    try {
                        dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
                        nomeElemento = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, elemento.getNome());
                        if (nomeElemento != null) {
                            matchNodePerCorrelazioneApplicativa = true;
                        }
                    }
                    catch (Exception e) {
                        this.log.info((Object)("Calcolo non riuscito [" + elementName + "] [" + elemento.getNome() + "]: " + e.getMessage()));
                    }
                }
                if (!matchNodePerCorrelazioneApplicativa) continue;
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_DISABILITATO.equals(elemento.getIdentificazione())) {
                    correlazioneNonRiuscitaDaAccettare = true;
                    findCorrelazione = true;
                    continue block10;
                }
                if (readFirstHeaderIntegrazione && headerIntegrazione.getIdApplicativo() != null) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    findCorrelazione = true;
                    continue block10;
                }
                if (CostantiConfigurazione.CORRELAZIONE_APPLICATIVA_RISPOSTA_INPUT_BASED.equals(elemento.getIdentificazione())) {
                    idCorrelazioneApplicativa = headerIntegrazione.getIdApplicativo();
                    if (idCorrelazioneApplicativa == null) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("identificativo di correlazione applicativa per l'elemento [" + nomeElemento + "] " + "con modalita' di acquisizione inputBased non presente tra le informazioni di integrazione");
                            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                } else {
                    try {
                        dnc = DynamicNamespaceContextFactory.getInstance().getNamespaceContext((Node)envelope);
                        idCorrelazioneApplicativa = xPathEngine.getStringMatchPattern((SOAPElement)envelope, dnc, elemento.getPattern());
                    }
                    catch (Exception e) {
                        if (bloccaIdentificazioneNonRiuscita) {
                            this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("Identificativo di correlazione applicativa non identificato nell'elemento [" + nomeElemento + "] con modalita' di acquisizione contentBased (Pattern:" + elemento.getPattern() + "): " + e.getMessage());
                            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
                        }
                        correlazioneNonRiuscitaDaAccettare = true;
                    }
                }
                findCorrelazione = true;
                continue block10;
            }
        }
        if (idCorrelazioneApplicativa == null) {
            if (!correlazioneNonRiuscitaDaAccettare) {
                this.errore = ErroriIntegrazione.ERRORE_434_CORRELAZIONE_APPLICATIVA_RISPOSTA_ERRORE.getErrore434_CorrelazioneApplicativaRisposta("Identificativo di correlazione applicativa non identificato; nessun elemento tra quelli di correlazione definiti, sono presenti nel body");
                throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
            }
        } else {
            this.idCorrelazione = idCorrelazioneApplicativa;
        }
    }

    public void applicaCorrelazione(CorrelazioneApplicativa correlazioneApplicativa, String idApplicativo, String idBustaRequest) throws GestoreMessaggiException, ProtocolException {
        if (correlazioneApplicativa == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("dati per l'identificazione dell'id di correlazione non presenti");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        if (idBustaRequest == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo non presente tra i parametri di invocazione");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        if (idApplicativo == null) {
            this.errore = ErroriIntegrazione.ERRORE_416_CORRELAZIONE_APPLICATIVA_RICHIESTA_ERRORE.getErrore416_CorrelazioneApplicativaRichiesta("identificativo applicativo non presente tra i parametri di invocazione");
            throw new GestoreMessaggiException(this.errore.getDescrizione(this.protocolFactory));
        }
        Timestamp scadenzaCorrelazioneT = null;
        if (correlazioneApplicativa.getScadenza() != null) {
            try {
                long scadenza = Long.parseLong(correlazioneApplicativa.getScadenza());
                scadenzaCorrelazioneT = new Timestamp(DateManager.getTimeMillis() + scadenza * 60L * 1000L);
            }
            catch (Exception e) {
                this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
                throw new GestoreMessaggiException("Scadenza impostata per la correlazione applicativa non corretta: " + e.getMessage());
            }
        }
        PreparedStatement pstmtInsert = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            StringBuffer queryInsert = new StringBuffer();
            queryInsert.append("INSERT INTO CORRELAZIONE_APPLICATIVA");
            queryInsert.append(" (ID_MESSAGGIO,ID_APPLICATIVO,SERVIZIO_APPLICATIVO,TIPO_MITTENTE,MITTENTE,TIPO_DESTINATARIO,DESTINATARIO,TIPO_SERVIZIO,SERVIZIO,AZIONE ");
            if (scadenzaCorrelazioneT != null) {
                queryInsert.append(",SCADENZA");
            }
            queryInsert.append(") VALUES (?,?,?,?,?,?,?,?,?,?");
            if (scadenzaCorrelazioneT != null) {
                queryInsert.append(",?");
            }
            queryInsert.append(")");
            pstmtInsert = connectionDB.prepareStatement(queryInsert.toString());
            pstmtInsert.setString(1, idBustaRequest);
            pstmtInsert.setString(2, idApplicativo);
            pstmtInsert.setString(3, this.servizioApplicativo);
            pstmtInsert.setString(4, this.soggettoFruitore.getTipo());
            pstmtInsert.setString(5, this.soggettoFruitore.getNome());
            pstmtInsert.setString(6, this.idServizio.getSoggettoErogatore().getTipo());
            pstmtInsert.setString(7, this.idServizio.getSoggettoErogatore().getNome());
            pstmtInsert.setString(8, this.idServizio.getTipoServizio());
            pstmtInsert.setString(9, this.idServizio.getServizio());
            pstmtInsert.setString(10, this.idServizio.getAzione());
            if (scadenzaCorrelazioneT != null) {
                pstmtInsert.setTimestamp(11, scadenzaCorrelazioneT);
            }
            String valoreAzione = "N.D.";
            if (this.idServizio.getAzione() != null && !"".equals(this.idServizio.getAzione())) {
                valoreAzione = this.idServizio.getAzione();
            }
            stateMSG.getPreparedStatement().put("INSERT CorrelazioneApplicativa_" + idBustaRequest + "_" + idApplicativo + "_" + this.soggettoFruitore.getTipo() + this.soggettoFruitore.getNome() + "_" + this.idServizio.getSoggettoErogatore().getTipo() + this.idServizio.getSoggettoErogatore().getNome() + "_" + this.idServizio.getTipoServizio() + this.idServizio.getServizio() + "_" + valoreAzione, pstmtInsert);
        }
        catch (Exception er) {
            this.errore = ErroriIntegrazione.ERRORE_5XX_GENERICO_PROCESSAMENTO_MESSAGGIO.get5XX_ErroreProcessamento(CodiceErroreIntegrazione.CODICE_529_CORRELAZIONE_APPLICATIVA_RICHIESTA_NON_RIUSCITA);
            this.log.error((Object)("Correlazione IDApplicativo - ID non riuscita: " + er.getMessage()));
            throw new GestoreMessaggiException("Correlazione IDApplicativo - ID non riuscita: " + er.getMessage());
        }
    }

    public Vector<Long> getCorrelazioniScadute(int limit, boolean logQuery, boolean orderBy) throws GestoreMessaggiException {
        Vector<Long> idMsg = new Vector<Long>();
        Statement pstmtMsgScaduti = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            Timestamp nowT = DateManager.getTimestamp();
            if (Configurazione.getSqlQueryObjectType() == null) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT id FROM ");
                query.append(CORRELAZIONE_APPLICATIVA);
                query.append(" WHERE SCADENZA is not null AND SCADENZA < ?");
                queryString = query.toString();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("SCADENZA");
                sqlQueryObject.addFromTable(CORRELAZIONE_APPLICATIVA);
                sqlQueryObject.addWhereCondition("SCADENZA is not null");
                sqlQueryObject.addWhereCondition("SCADENZA < ?");
                sqlQueryObject.setANDLogicOperator(true);
                if (orderBy) {
                    sqlQueryObject.addOrderBy("SCADENZA");
                    sqlQueryObject.setSortType(true);
                }
                sqlQueryObject.setLimit(limit);
                queryString = sqlQueryObject.createSQLQuery();
            }
            pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
            pstmtMsgScaduti.setTimestamp(1, nowT);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + nowT + "]..."));
            }
            rs = pstmtMsgScaduti.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.scaduta) [" + queryString + "] 1[" + nowT + "] effettuata in " + secondSQLCommand + " secondi"));
            }
            int countLimit = 0;
            while (rs.next()) {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    idMsg.add(rs.getLong("id"));
                    if (++countLimit != limit) continue;
                    break;
                }
                idMsg.add(rs.getLong("id"));
            }
            rs.close();
            pstmtMsgScaduti.close();
            return idMsg;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreCorrelazioneApplicativa.getCorrelazioniScadute] errore, queryString[" + queryString + "]: " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtMsgScaduti != null) {
                    pstmtMsgScaduti.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public Vector<Long> getCorrelazioniScaduteRispettoOraRegistrazione(int limit, long scadenzaMsg, boolean logQuery, boolean orderBy, boolean escludiCorrelazioniConScadenza) throws GestoreMessaggiException {
        Vector<Long> idMsg = new Vector<Long>();
        Statement pstmtMsgScaduti = null;
        ResultSet rs = null;
        String queryString = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            long scadenza = DateManager.getTimeMillis() - scadenzaMsg * 60L * 1000L;
            Timestamp scandenzaT = new Timestamp(scadenza);
            if (Configurazione.getSqlQueryObjectType() == null) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT id FROM ");
                query.append(CORRELAZIONE_APPLICATIVA);
                query.append(" WHERE ORA_REGISTRAZIONE < ?");
                if (escludiCorrelazioniConScadenza) {
                    query.append(" AND SCADENZA is null");
                }
                queryString = query.toString();
            } else {
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)Configurazione.getSqlQueryObjectType());
                sqlQueryObject.addSelectField("id");
                sqlQueryObject.addSelectField("SCADENZA");
                sqlQueryObject.addFromTable(CORRELAZIONE_APPLICATIVA);
                sqlQueryObject.addWhereCondition("ORA_REGISTRAZIONE < ?");
                if (escludiCorrelazioniConScadenza) {
                    sqlQueryObject.addWhereCondition("SCADENZA is null");
                }
                sqlQueryObject.setANDLogicOperator(true);
                if (orderBy) {
                    sqlQueryObject.addOrderBy("ORA_REGISTRAZIONE");
                    sqlQueryObject.setSortType(true);
                }
                sqlQueryObject.setLimit(limit);
                queryString = sqlQueryObject.createSQLQuery();
            }
            pstmtMsgScaduti = connectionDB.prepareStatement(queryString);
            pstmtMsgScaduti.setTimestamp(1, scandenzaT);
            long startDateSQLCommand = DateManager.getTimeMillis();
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.storiche) [" + queryString + "] 1[" + scandenzaT + "]..."));
            }
            rs = pstmtMsgScaduti.executeQuery();
            long endDateSQLCommand = DateManager.getTimeMillis();
            long secondSQLCommand = (endDateSQLCommand - startDateSQLCommand) / 1000L;
            if (logQuery) {
                this.log.debug((Object)("[QUERY] (CorrelazioneApplicativa.storiche) [" + queryString + "] 1[" + scandenzaT + "] effettuata in " + secondSQLCommand + " secondi"));
            }
            int countLimit = 0;
            while (rs.next()) {
                if (Configurazione.getSqlQueryObjectType() == null) {
                    idMsg.add(rs.getLong("id"));
                    if (++countLimit != limit) continue;
                    break;
                }
                idMsg.add(rs.getLong("id"));
            }
            rs.close();
            pstmtMsgScaduti.close();
            return idMsg;
        }
        catch (Exception e) {
            String errorMsg = "[GestoreCorrelazioneApplicativa.getCorrelazioniStoriche] errore, queryString[" + queryString + "]: " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtMsgScaduti != null) {
                    pstmtMsgScaduti.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public String[] getIDMappingCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        PreparedStatement pstmtReadMSG = null;
        ResultSet rs = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "SELECT ID_MESSAGGIO,ID_APPLICATIVO  FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtReadMSG = connectionDB.prepareStatement(query);
            pstmtReadMSG.setLong(1, idCorrelazioneApplicativa);
            rs = pstmtReadMSG.executeQuery();
            if (rs.next()) {
                String[] s = new String[]{rs.getString("ID_MESSAGGIO"), rs.getString(CORRELAZIONE_APPLICATIVA_COLUMN_ID_APPLICATIVO)};
                rs.close();
                pstmtReadMSG.close();
                return s;
            }
            rs.close();
            pstmtReadMSG.close();
            throw new Exception("CorrelazioneApplicativa con id[" + idCorrelazioneApplicativa + "] non trovata");
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error getIDMappingCorrelazioneApplicativa [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            try {
                if (pstmtReadMSG != null) {
                    pstmtReadMSG.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public void deleteCorrelazioneApplicativa(long idCorrelazioneApplicativa) throws GestoreMessaggiException {
        PreparedStatement pstmtDeleteMSG = null;
        try {
            StateMessage stateMSG = (StateMessage)this.state;
            Connection connectionDB = stateMSG.getConnectionDB();
            String query = "DELETE FROM CORRELAZIONE_APPLICATIVA WHERE id=?";
            pstmtDeleteMSG = connectionDB.prepareStatement(query);
            pstmtDeleteMSG.setLong(1, idCorrelazioneApplicativa);
            pstmtDeleteMSG.execute();
            pstmtDeleteMSG.close();
        }
        catch (Exception e) {
            String errorMsg = "GestoreCorrelazioneApplicativa, error deleteCorrelazione [" + idCorrelazioneApplicativa + "] : " + e.getMessage();
            try {
                if (pstmtDeleteMSG != null) {
                    pstmtDeleteMSG.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            this.log.error((Object)errorMsg);
            throw new GestoreMessaggiException(errorMsg);
        }
    }

    public String getIdBustaCorrelato() {
        return this.idBustaCorrelato;
    }

    public ErroreIntegrazione getErrore() {
        return this.errore;
    }

    public String getIdCorrelazione() {
        return this.idCorrelazione;
    }
}

