/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.pdd.config;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop2.core.config.AccessoConfigurazionePdD;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.xml.DriverConfigurazioneXML;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.pdd.config.ConfigLocalProperties;
import org.openspcoop2.pdd.config.OpenSPCoop2Properties;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.cache.Cache;
import org.openspcoop2.utils.cache.CacheAlgorithm;
import org.openspcoop2.utils.cache.CacheResponse;

public class ConfigurazionePdD {
    private Cache cache = null;
    private IDriverConfigurazioneGet driverConfigurazionePdD;
    private boolean useConnectionPdD = false;
    private String tipoDatabase = null;
    private Logger log = null;
    private static Configurazione configurazioneGeneralePdD = null;
    private static GestioneErrore gestioneErroreComponenteCooperazione = null;
    private static GestioneErrore gestioneErroreComponenteIntegrazione = null;
    private static RoutingTable routingTable = null;
    private static AccessoRegistro accessoRegistro = null;
    private boolean configurazioneDinamica = false;
    private OpenSPCoop2Properties openspcoopProperties = null;
    private ConfigLocalProperties configLocalProperties = null;

    public void resetCache() throws DriverConfigurazioneException {
        if (this.cache != null) {
            try {
                this.cache.clear();
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String printStatsCache(String separator) throws DriverConfigurazioneException {
        if (this.cache != null) {
            try {
                return this.cache.printStats(separator);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverConfigurazioneException("Cache non abilitata");
    }

    public void abilitaCache() throws DriverConfigurazioneException {
        if (this.cache != null) {
            throw new DriverConfigurazioneException("Cache gia' abilitata");
        }
        try {
            this.cache = new Cache("configurazionePdD");
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void abilitaCache(Long dimensioneCache, Boolean algoritmoCacheLRU, Long itemIdleTime, Long itemLifeSecond) throws DriverConfigurazioneException {
        if (this.cache != null) {
            throw new DriverConfigurazioneException("Cache gia' abilitata");
        }
        try {
            AccessoConfigurazionePdD accessoConfigurazione = new AccessoConfigurazionePdD();
            if (dimensioneCache != null) {
                accessoConfigurazione.setDimensioneCache(Integer.valueOf(dimensioneCache.intValue()));
            }
            if (algoritmoCacheLRU != null) {
                if (algoritmoCacheLRU.booleanValue()) {
                    accessoConfigurazione.setAlgoritmoCache(CostantiConfigurazione.CACHE_LRU);
                } else {
                    accessoConfigurazione.setAlgoritmoCache(CostantiConfigurazione.CACHE_MRU);
                }
            }
            if (itemIdleTime != null) {
                accessoConfigurazione.setItemIdleTimeCache(Integer.valueOf(itemIdleTime.intValue()));
            }
            if (itemLifeSecond != null) {
                accessoConfigurazione.setItemLifeTimeCache(Integer.valueOf(itemLifeSecond.intValue()));
            }
            this.initCacheConfigurazione(accessoConfigurazione, null);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public void disabilitaCache() throws DriverConfigurazioneException {
        if (this.cache == null) {
            throw new DriverConfigurazioneException("Cache gia' disabilitata");
        }
        try {
            this.cache.clear();
            this.cache = null;
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
        }
    }

    public String listKeysCache(String separator) throws DriverConfigurazioneException {
        if (this.cache != null) {
            try {
                return this.cache.printKeys(separator);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverConfigurazioneException("Cache non abilitata");
    }

    public String getObjectCache(String key) throws DriverConfigurazioneException {
        if (this.cache != null) {
            try {
                Object o = this.cache.get(key);
                if (o != null) {
                    return o.toString();
                }
                return "oggetto con chiave [" + key + "] non presente";
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        throw new DriverConfigurazioneException("Cache non abilitata");
    }

    public ConfigurazionePdD(AccessoConfigurazionePdD accessoConfigurazione, Logger alog, Logger alogConsole, Properties localProperties, String jndiNameDatasourcePdD) throws DriverConfigurazioneException {
        try {
            this.openspcoopProperties = OpenSPCoop2Properties.getInstance();
            this.configurazioneDinamica = this.openspcoopProperties.isConfigurazioneDinamica();
            this.log = alog != null ? alog : Logger.getLogger(ConfigurazionePdD.class);
            String msg = "Leggo configurazione di tipo[" + accessoConfigurazione.getTipo() + "]   location[" + accessoConfigurazione.getLocation() + "]";
            this.log.info((Object)msg);
            if (alogConsole != null) {
                alogConsole.info((Object)msg);
            }
            if ("xml".equalsIgnoreCase(accessoConfigurazione.getTipo())) {
                this.driverConfigurazionePdD = new DriverConfigurazioneXML(accessoConfigurazione.getLocation(), this.log);
                if (this.driverConfigurazionePdD == null || !((DriverConfigurazioneXML)this.driverConfigurazionePdD).create) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
                }
            } else if ("db".equalsIgnoreCase(accessoConfigurazione.getTipo())) {
                this.driverConfigurazionePdD = new DriverConfigurazioneDB(accessoConfigurazione.getLocation(), accessoConfigurazione.getContext(), this.log, accessoConfigurazione.getTipoDatabase(), accessoConfigurazione.isCondivisioneDatabasePddRegistro());
                if (this.driverConfigurazionePdD == null || !((DriverConfigurazioneDB)this.driverConfigurazionePdD).create) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
                }
                this.useConnectionPdD = jndiNameDatasourcePdD.equals(accessoConfigurazione.getLocation());
                this.tipoDatabase = accessoConfigurazione.getTipoDatabase();
            } else {
                throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di tipo sconosciuto " + accessoConfigurazione.getTipo() + " con location: " + accessoConfigurazione.getLocation());
            }
            if (accessoConfigurazione.getUtilizzoCache()) {
                this.initCacheConfigurazione(accessoConfigurazione, alogConsole);
            }
            this.configLocalProperties = new ConfigLocalProperties(this.log, this.openspcoopProperties.getRootDirectory(), localProperties);
        }
        catch (Exception e) {
            String msg = "Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop: " + e.getMessage();
            this.log.error((Object)msg, (Throwable)e);
            if (alogConsole != null) {
                alogConsole.info((Object)msg);
            }
            throw new DriverConfigurazioneException("Riscontrato errore durante l'inizializzazione della configurazione di OpenSPCoop: " + e.getMessage());
        }
    }

    private void initCacheConfigurazione(AccessoConfigurazionePdD accessoConfigurazione, Logger alogConsole) throws Exception {
        this.cache = new Cache("configurazionePdD");
        String msg = null;
        if (accessoConfigurazione.getDimensioneCache() != null || accessoConfigurazione.getAlgoritmoCache() != null) {
            if (accessoConfigurazione.getDimensioneCache() != null) {
                try {
                    msg = "Dimensione della cache (ConfigurazionePdD) impostata al valore: " + accessoConfigurazione.getDimensioneCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    this.cache.setCacheSize(accessoConfigurazione.getDimensioneCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per la dimensione della cache (ConfigurazionePdD): " + error.getMessage());
                }
            }
            if (accessoConfigurazione.getAlgoritmoCache() != null) {
                msg = "Algoritmo di cache (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getAlgoritmoCache();
                this.log.info((Object)msg);
                if (alogConsole != null) {
                    alogConsole.info((Object)msg);
                }
                if (CostantiConfigurazione.CACHE_MRU.equals(accessoConfigurazione.getAlgoritmoCache())) {
                    this.cache.setCacheAlgoritm(CacheAlgorithm.MRU);
                } else {
                    this.cache.setCacheAlgoritm(CacheAlgorithm.LRU);
                }
            }
        }
        if (accessoConfigurazione.getItemIdleTimeCache() != null || accessoConfigurazione.getItemLifeTimeCache() != null) {
            if (accessoConfigurazione.getItemIdleTimeCache() != null) {
                try {
                    msg = "Attributo 'IdleTime' (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getItemIdleTimeCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    this.cache.setItemIdleTime((long)accessoConfigurazione.getItemIdleTimeCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'IdleTime' (ConfigurazionePdD): " + error.getMessage());
                }
            }
            if (accessoConfigurazione.getItemLifeTimeCache() != null) {
                try {
                    msg = "Attributo 'MaxLifeSecond' (ConfigurazionePdD) impostato al valore: " + accessoConfigurazione.getItemLifeTimeCache();
                    this.log.info((Object)msg);
                    if (alogConsole != null) {
                        alogConsole.info((Object)msg);
                    }
                    this.cache.setItemLifeTime((long)accessoConfigurazione.getItemLifeTimeCache().intValue());
                }
                catch (Exception error) {
                    throw new DriverConfigurazioneException("Parametro errato per l'attributo 'MaxLifeSecond' (ConfigurazionePdD): " + error.getMessage());
                }
            }
        }
    }

    protected IDriverConfigurazioneGet getDriverConfigurazionePdD() {
        return this.driverConfigurazionePdD;
    }

    public synchronized Object getObjectCache(String keyCache, String methodName, Connection connectionPdD, Object ... arguments) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        DriverConfigurazioneNotFound dNotFound = null;
        Object obj = null;
        try {
            CacheResponse response;
            if (keyCache == null) {
                throw new DriverConfigurazioneException("[" + methodName + "]: KeyCache non definita");
            }
            if (this.cache != null && (response = (CacheResponse)this.cache.get(keyCache)) != null) {
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto (tipo:" + response.getObject().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") in cache."));
                    return response.getObject();
                }
                if (response.getException() != null) {
                    this.log.debug((Object)("Eccezione (tipo:" + response.getException().getClass().getName() + ") con chiave [" + keyCache + "] (methodo:" + methodName + ") in cache."));
                    throw (Exception)response.getException();
                }
                this.log.error((Object)"In cache non e' presente ne un oggetto ne un'eccezione.");
            }
            this.log.debug((Object)("oggetto con chiave [" + keyCache + "] (methodo:" + methodName + ") ricerco nella configurazione..."));
            try {
                obj = this.getObject(methodName, connectionPdD, arguments);
            }
            catch (DriverConfigurazioneNotFound e) {
                dNotFound = e;
            }
            if (this.cache != null) {
                if (dNotFound != null) {
                    this.log.info((Object)("Aggiungo eccezione not found [" + keyCache + "] in cache"));
                } else if (obj != null) {
                    this.log.info((Object)("Aggiungo oggetto [" + keyCache + "] in cache"));
                } else {
                    throw new Exception("Metodo (" + methodName + ") ha ritornato un valore null");
                }
                try {
                    CacheResponse responseCache = new CacheResponse();
                    if (dNotFound != null) {
                        responseCache.setException((Serializable)((Object)dNotFound));
                    } else {
                        responseCache.setObject((Serializable)obj);
                    }
                    this.cache.put(keyCache, responseCache);
                }
                catch (UtilsException e) {
                    this.log.error((Object)("Errore durante l'inserimento in cache [" + keyCache + "]: " + e.getMessage()));
                }
            }
        }
        catch (DriverConfigurazioneException e) {
            throw e;
        }
        catch (DriverConfigurazioneNotFound e) {
            throw e;
        }
        catch (Exception e) {
            if (DriverConfigurazioneNotFound.class.getName().equals(e.getClass().getName())) {
                throw (DriverConfigurazioneNotFound)((Object)e);
            }
            throw new DriverConfigurazioneException("Configurazione, Algoritmo di Cache fallito: " + e.getMessage(), (Throwable)e);
        }
        if (dNotFound != null) {
            throw dNotFound;
        }
        return obj;
    }

    public Object getObject(String methodName, Connection connectionPdD, Object ... arguments) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        DriverConfigurazioneNotFound notFound;
        Object obj;
        block30: {
            obj = null;
            notFound = null;
            this.log.debug((Object)"Cerco nella configurazione");
            try {
                IDriverConfigurazioneGet driver = this.getDriver(connectionPdD);
                this.log.debug((Object)("invocazione metodo [" + methodName + "]..."));
                if (arguments.length == 0) {
                    Method method = driver.getClass().getMethod(methodName, new Class[0]);
                    obj = method.invoke((Object)driver, new Object[0]);
                    break block30;
                }
                if (arguments.length == 1) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass());
                    obj = method.invoke((Object)driver, arguments[0]);
                    break block30;
                }
                if (arguments.length == 2) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1]);
                    break block30;
                }
                if (arguments.length == 3) {
                    Method method = driver.getClass().getMethod(methodName, arguments[0].getClass(), arguments[1].getClass(), arguments[2].getClass());
                    obj = method.invoke((Object)driver, arguments[0], arguments[1], arguments[2]);
                    break block30;
                }
                throw new Exception("Troppi argomenti per gestire la chiamata del metodo");
            }
            catch (DriverConfigurazioneNotFound e) {
                this.log.debug((Object)("Ricerca nella configurazione non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                notFound = e;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nella configurazione non riuscita [NotFound] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()));
                        notFound = new DriverConfigurazioneNotFound(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    if (DriverConfigurazioneException.class.getName().equals(e.getTargetException().getClass().getName())) {
                        this.log.debug((Object)("Ricerca nella configurazione non riuscita [DriverException] (metodo [" + methodName + "]): " + e.getTargetException().getMessage()), e.getTargetException());
                        throw new DriverConfigurazioneException(e.getTargetException().getMessage(), e.getTargetException());
                    }
                    this.log.debug((Object)("Ricerca nella configurazione non riuscita [InvTargetExcp.getTarget] (metodo [" + methodName + "]), " + e.getTargetException().getMessage()), e.getTargetException());
                    throw new DriverConfigurazioneException(e.getTargetException().getMessage(), e.getTargetException());
                }
                this.log.debug((Object)("Ricerca nella configurazione non riuscita [InvTargetExcp] (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                this.log.debug((Object)("ricerca nella configurazione non riuscita (metodo [" + methodName + "]), " + e.getMessage()), (Throwable)e);
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (notFound != null) {
            try {
                if ("getGestioneErroreComponenteCooperazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreCooperazione(null);
                } else if ("getGestioneErroreComponenteIntegrazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreIntegrazione(null);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Refresh nella configurazione locale non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
            if (obj == null) {
                throw notFound;
            }
        } else {
            try {
                if ("getRoutingTable".equals(methodName)) {
                    obj = this.configLocalProperties.updateRouting((RoutingTable)obj);
                } else if ("getAccessoRegistro".equals(methodName)) {
                    obj = this.configLocalProperties.updateAccessoRegistro((AccessoRegistro)obj);
                } else if ("getGestioneErroreComponenteCooperazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreCooperazione((GestioneErrore)obj);
                } else if ("getGestioneErroreComponenteIntegrazione".equals(methodName)) {
                    obj = this.configLocalProperties.updateGestioneErroreIntegrazione((GestioneErrore)obj);
                } else if ("getConfigurazioneGenerale".equals(methodName)) {
                    obj = this.configLocalProperties.updateConfigurazione((Configurazione)obj);
                }
            }
            catch (Exception e) {
                this.log.debug((Object)("Refresh nella configurazione locale non riuscita (metodo [" + methodName + "]): " + e.getMessage()));
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        this.log.debug((Object)("invocazione metodo [" + methodName + "] completata."));
        return obj;
    }

    private IDriverConfigurazioneGet getDriver(Connection connectionPdD) throws DriverConfigurazioneException {
        IDriverConfigurazioneGet driver = this.driverConfigurazionePdD;
        if (driver instanceof DriverConfigurazioneDB && connectionPdD != null && this.useConnectionPdD) {
            driver = new DriverConfigurazioneDB(connectionPdD, this.log, this.tipoDatabase);
            if (!((DriverConfigurazioneDB)driver).create) {
                throw new DriverConfigurazioneException("Inizializzazione DriverConfigurazioneDB con connessione PdD non riuscita");
            }
        }
        return driver;
    }

    public Soggetto getSoggetto(Connection connectionPdD, IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getSoggetto_" + aSoggetto.getTipo() + aSoggetto.getNome())) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto sogg = null;
        sogg = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggetto", connectionPdD, aSoggetto) : (Soggetto)this.getObject("getSoggetto", connectionPdD, aSoggetto);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto non Trovato");
    }

    public Soggetto getSoggetto(Connection connectionPdD, String location) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (location == null) {
            throw new DriverConfigurazioneException("[getSoggetto(Location)]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getSoggetto(location)_" + location)) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto sogg = null;
        sogg = this.cache != null ? (Soggetto)this.getObjectCache(key, "getSoggetto", connectionPdD, location) : (Soggetto)this.getObject("getSoggetto", connectionPdD, location);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto(location)] Soggetto non Trovato");
    }

    public Soggetto getRouter(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getRouter")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (Soggetto)response.getObject();
        }
        Soggetto sogg = null;
        sogg = this.cache != null ? (Soggetto)this.getObjectCache(key, "getRouter", connectionPdD, new Object[0]) : (Soggetto)this.getObject("getRouter", connectionPdD, new Object[0]);
        if (sogg != null) {
            return sogg;
        }
        throw new DriverConfigurazioneNotFound("[getRouter] Soggetto non Trovato");
    }

    public HashSet<String> getSoggettiVirtuali(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getSoggettiVirtuali")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (HashSet)response.getObject();
        }
        HashSet lista = null;
        lista = this.cache != null ? (HashSet)this.getObjectCache(key, "getSoggettiVirtuali", connectionPdD, new Object[0]) : (HashSet)this.getObject("getSoggettiVirtuali", connectionPdD, new Object[0]);
        if (lista != null) {
            return lista;
        }
        throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Lista Soggetti Virtuali non costruita");
    }

    public HashSet<IDServizio> getServizi_SoggettiVirtuali(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getServizi_SoggettiVirtuali")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (HashSet)response.getObject();
        }
        HashSet lista = null;
        lista = this.cache != null ? (HashSet)this.getObjectCache(key, "getServizi_SoggettiVirtuali", connectionPdD, new Object[0]) : (HashSet)this.getObject("getServizi_SoggettiVirtuali", connectionPdD, new Object[0]);
        if (lista != null) {
            return lista;
        }
        throw new DriverConfigurazioneNotFound("[getServizi_SoggettiVirtuali] Lista Servizi erogati da Soggetti Virtuali non costruita");
    }

    public PortaDelegata getPortaDelegata(Connection connectionPdD, IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (idPD)");
        }
        if (idPD.getLocationPD() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (location)");
        }
        if (idPD.getSoggettoFruitore() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (soggettoFruitore is null)");
        }
        if (idPD.getSoggettoFruitore().getTipo() == null || idPD.getSoggettoFruitore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata]: Parametro non definito (soggettoFruitore is null tipo[" + idPD.getSoggettoFruitore().getTipo() + "] nome[" + idPD.getSoggettoFruitore().getNome() + "])");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getPortaDelegata_" + idPD.getLocationPD() + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome())) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (PortaDelegata)response.getObject();
        }
        PortaDelegata pd = null;
        pd = this.cache != null ? (PortaDelegata)this.getObjectCache(key, "getPortaDelegata", connectionPdD, idPD) : (PortaDelegata)this.getObject("getPortaDelegata", connectionPdD, idPD);
        if (pd != null) {
            return pd;
        }
        throw new DriverConfigurazioneNotFound("[getPortaDelegata] PD non trovata");
    }

    private String toStringFiltriProprieta(Hashtable<String, String> filtroProprietaPorteApplicative) {
        StringBuffer bf = new StringBuffer();
        if (filtroProprietaPorteApplicative == null || filtroProprietaPorteApplicative.size() <= 0) {
            bf.append("Non presenti");
        } else {
            Enumeration<String> keys = filtroProprietaPorteApplicative.keys();
            while (keys.hasMoreElements()) {
                bf.append("\n");
                String key = keys.nextElement();
                bf.append(key + " = " + filtroProprietaPorteApplicative.get(key));
            }
        }
        return bf.toString();
    }

    private boolean checkProprietaFiltroPortaApplicativa(PortaApplicativa pa, Hashtable<String, String> proprietaPresentiBustaRicevuta) {
        boolean filtriPAPresenti = false;
        if (proprietaPresentiBustaRicevuta != null && proprietaPresentiBustaRicevuta.size() > 0) {
            for (int i = 0; i < pa.sizeProprietaProtocolloList(); ++i) {
                String nome = pa.getProprietaProtocollo(i).getNome();
                String value = pa.getProprietaProtocollo(i).getValore();
                this.log.debug((Object)("ProprietaProtocollo della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "]"));
                if (value.indexOf("!#!") == -1) continue;
                filtriPAPresenti = true;
                String[] split = value.split("!#!");
                if (split == null || split.length != 2) continue;
                String operatoreP = split[1].trim();
                String valoreP = split[0].trim();
                String proprietaArrivata = proprietaPresentiBustaRicevuta.get(nome);
                this.log.debug((Object)("ProtocolProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "] interpretata come [" + nome + "][" + operatoreP + "][" + valoreP + "]. Viene utilizzata per la proprieta' della busta con valore [" + proprietaArrivata + "]"));
                if (proprietaArrivata == null) continue;
                proprietaArrivata = proprietaArrivata.trim();
                if ("=".equals(operatoreP)) {
                    if (!proprietaArrivata.equals(valoreP)) continue;
                    return true;
                }
                if (">".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) <= 0) continue;
                    return true;
                }
                if (">=".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) < 0) continue;
                    return true;
                }
                if ("<".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) >= 0) continue;
                    return true;
                }
                if ("<=".equals(operatoreP)) {
                    if (proprietaArrivata.compareTo(valoreP) > 0) continue;
                    return true;
                }
                if ("<>".equals(operatoreP)) {
                    if (proprietaArrivata.equals(valoreP)) continue;
                    return true;
                }
                if ("like".equalsIgnoreCase(operatoreP)) {
                    String valoreMatch = valoreP.replaceAll("%", "");
                    int indexExpr = proprietaArrivata.indexOf(valoreMatch);
                    if (indexExpr < 0) continue;
                    return true;
                }
                this.log.error((Object)("[checkProprietaFiltroPortaApplicativa] Operator [" + operatoreP + "] non supportato per le protocol properties..."));
            }
        } else {
            for (int i = 0; i < pa.sizeProprietaProtocolloList(); ++i) {
                String nome = pa.getProprietaProtocollo(i).getNome();
                String value = pa.getProprietaProtocollo(i).getValore();
                this.log.debug((Object)("ProtocolProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "]"));
                if (value.indexOf("!#!") == -1) continue;
                this.log.debug((Object)("ProtocolProperty della PA[" + pa.getNome() + "] nome[" + nome + "] valore[" + value + "] contiene una richiesta di filtro, siccome la busta arrivata non contiene proprieta', la PA non ha diritto a riceverla."));
                filtriPAPresenti = true;
                break;
            }
        }
        return !filtriPAPresenti;
    }

    public PortaApplicativa getPortaApplicativa(Connection connectionPdD, IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA is null)");
        }
        if (idPA.getIDServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA.getIDServizio() is null)");
        }
        if (idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (tipoServizio=[" + idPA.getIDServizio().getTipoServizio() + "] servizio=[" + idPA.getIDServizio().getServizio() + "])");
        }
        if (idPA.getIDServizio().getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (idPA.getIDServizio().getSoggettoErogatore() is null)");
        }
        if (idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (tipoSoggetto=[" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + "] servizio=[" + idPA.getIDServizio().getSoggettoErogatore().getNome() + "])");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getPortaApplicativa_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get(key)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                PortaApplicativa pa = (PortaApplicativa)response.getObject();
                if (pa != null) {
                    return pa;
                }
            }
        }
        PortaApplicativa pa = null;
        pa = this.cache != null ? (PortaApplicativa)this.getObjectCache(key, "getPortaApplicativa", connectionPdD, idPA) : (PortaApplicativa)this.getObject("getPortaApplicativa", connectionPdD, idPA);
        if (pa != null) {
            return pa;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PA non trovata");
    }

    public PortaApplicativa getPortaApplicativa(Connection connectionPdD, String nomePorta, IDSoggetto soggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (nomePorta == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (nomePorta is null)");
        }
        if (soggettoProprietario.getNome() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (soggettoProprietario.getNome() is null)");
        }
        if (soggettoProprietario.getTipo() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (soggettoProprietario.getTipo() is null)");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getPortaApplicativa_" + nomePorta + "_" + soggettoProprietario.toString())) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            PortaApplicativa pa = (PortaApplicativa)response.getObject();
            if (pa != null) {
                return pa;
            }
        }
        PortaApplicativa pa = null;
        pa = this.cache != null ? (PortaApplicativa)this.getObjectCache(key, "getPortaApplicativa", connectionPdD, nomePorta, soggettoProprietario) : (PortaApplicativa)this.getObject("getPortaApplicativa", connectionPdD, nomePorta, soggettoProprietario);
        if (pa != null) {
            return pa;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PA non trovata");
    }

    public Hashtable<IDSoggetto, PortaApplicativa> getPorteApplicative_SoggettiVirtuali(Connection connectionPdD, IDPortaApplicativa idPA, Hashtable<String, String> proprietaPresentiBustaRicevuta, boolean useFiltroProprieta) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null || idPA.getIDServizio() == null || idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null || idPA.getIDServizio().getSoggettoErogatore() == null || idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null) {
            throw new DriverConfigurazioneException("[getPorteApplicative_SoggettiVirtuali]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            this.log.debug((Object)"Search porte applicative soggetti virtuali in cache...");
            key = "getPorteApplicative_SoggettiVirtuali_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get(key)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                if (response.getObject() != null) {
                    this.log.debug((Object)("Oggetto in cache trovato. Analizzo porte virtuali trovate rispetto alle proprieta' presenti nella busta arrivata: " + this.toStringFiltriProprieta(proprietaPresentiBustaRicevuta)));
                    Hashtable pa = (Hashtable)response.getObject();
                    Hashtable<IDSoggetto, PortaApplicativa> paChecked = new Hashtable<IDSoggetto, PortaApplicativa>();
                    Enumeration enumer = pa.keys();
                    while (enumer.hasMoreElements()) {
                        IDSoggetto idS = (IDSoggetto)enumer.nextElement();
                        PortaApplicativa paC = (PortaApplicativa)pa.get(idS);
                        this.log.debug((Object)("Analizzo pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]..."));
                        if (useFiltroProprieta) {
                            boolean ricezioneAutorizzata = this.checkProprietaFiltroPortaApplicativa(paC, proprietaPresentiBustaRicevuta);
                            if (ricezioneAutorizzata) {
                                this.log.debug((Object)("Filtri matchano le protocol properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                                paChecked.put(idS, paC);
                                continue;
                            }
                            this.log.debug((Object)("Filtri non matchano le protocol properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                            continue;
                        }
                        this.log.debug((Object)("Invocazione metodo senza la richiesta di filtro per proprieta, aggiunta pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                        paChecked.put(idS, paC);
                    }
                    if (paChecked.size() > 0) {
                        return paChecked;
                    }
                }
            }
        }
        Hashtable pa = null;
        pa = this.cache != null ? (Hashtable)this.getObjectCache(key, "getPorteApplicative_SoggettiVirtuali", connectionPdD, idPA) : (Hashtable)this.getObject("getPorteApplicative_SoggettiVirtuali", connectionPdD, idPA);
        if (pa != null) {
            this.log.debug((Object)("Oggetto trovato. Analizzo porte virtuali trovate rispetto alle proprieta' presenti nella busta arrivata: " + this.toStringFiltriProprieta(proprietaPresentiBustaRicevuta)));
            Hashtable<IDSoggetto, PortaApplicativa> paChecked = new Hashtable<IDSoggetto, PortaApplicativa>();
            Enumeration enumer = pa.keys();
            while (enumer.hasMoreElements()) {
                IDSoggetto idS = (IDSoggetto)enumer.nextElement();
                PortaApplicativa paC = (PortaApplicativa)pa.get(idS);
                this.log.debug((Object)("Analizzo pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]..."));
                if (useFiltroProprieta) {
                    boolean ricezioneAutorizzata = this.checkProprietaFiltroPortaApplicativa(paC, proprietaPresentiBustaRicevuta);
                    if (ricezioneAutorizzata) {
                        this.log.debug((Object)("Filtri matchano le protocol properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                        paChecked.put(idS, paC);
                        continue;
                    }
                    this.log.debug((Object)("Filtri non matchano le protocol properties della pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                    continue;
                }
                this.log.debug((Object)("Invocazione metodo senza la richiesta di filtro per proprieta, aggiunta pa [" + paC.getNome() + "] del soggetto [" + idS.toString() + "]"));
                paChecked.put(idS, paC);
            }
            if (paChecked.size() > 0) {
                return paChecked;
            }
        }
        throw new DriverConfigurazioneNotFound("[getPorteApplicative_SoggettiVirtuali] PA_SoggettiVirtuali non trovati");
    }

    public List<PortaApplicativa> getPorteApplicative(Connection connectionPdD, String nomePA, String tipoSoggettoProprietario, String nomeSoggettoProprietario) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        String tmpNomeSoggetto;
        if (nomePA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa]: Parametro non definito (nomePA is null)");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getPorteApplicativeAsList_" + nomePA;
            if (tipoSoggettoProprietario != null) {
                key = key + "_" + tipoSoggettoProprietario;
            }
            if (nomeSoggettoProprietario != null) {
                key = key + "_" + nomeSoggettoProprietario;
            }
            if ((response = (CacheResponse)this.cache.get(key)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                List listPA = (List)((Object)response.getObject());
                if (listPA != null) {
                    return listPA;
                }
            }
        }
        List listPA = null;
        String tmpTipoSoggetto = tipoSoggettoProprietario;
        if (tmpTipoSoggetto == null) {
            tmpTipoSoggetto = "";
        }
        if ((tmpNomeSoggetto = nomeSoggettoProprietario) == null) {
            tmpNomeSoggetto = "";
        }
        if ((listPA = this.cache != null ? (List)this.getObjectCache(key, "getPorteApplicative", connectionPdD, nomePA, tmpTipoSoggetto, tmpNomeSoggetto) : (List)this.getObject("getPorteApplicative", connectionPdD, nomePA, tmpTipoSoggetto, tmpNomeSoggetto)) != null) {
            return listPA;
        }
        throw new DriverConfigurazioneNotFound("[getPortaApplicativa] PA non trovata");
    }

    public ServizioApplicativo getServizioApplicativo(Connection connectionPdD, IDPortaDelegata idPD, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (idPD)");
        }
        if (idPD.getLocationPD() == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (location)");
        }
        if (idPD.getSoggettoFruitore() == null || idPD.getSoggettoFruitore().getTipo() == null || idPD.getSoggettoFruitore().getNome() == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (soggetto fruitore)");
        }
        if (servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito (servizioApplicativo)");
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getServizioApplicativo_" + idPD.getLocationPD() + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome() + "_" + servizioApplicativo)) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (ServizioApplicativo)response.getObject();
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativo", connectionPdD, idPD, servizioApplicativo) : (ServizioApplicativo)this.getObject("getServizioApplicativo", connectionPdD, idPD, servizioApplicativo);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativo(Connection connectionPdD, IDPortaApplicativa idPA, String servizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null || idPA.getIDServizio() == null || idPA.getIDServizio().getServizio() == null || idPA.getIDServizio().getTipoServizio() == null || idPA.getIDServizio().getSoggettoErogatore() == null || idPA.getIDServizio().getSoggettoErogatore().getTipo() == null || idPA.getIDServizio().getSoggettoErogatore().getNome() == null || servizioApplicativo == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativo]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativo_" + idPA.getIDServizio().getSoggettoErogatore().getTipo() + idPA.getIDServizio().getSoggettoErogatore().getNome() + "_" + idPA.getIDServizio().getTipoServizio() + idPA.getIDServizio().getServizio();
            if (idPA.getIDServizio().getAzione() != null) {
                key = key + "_" + idPA.getIDServizio().getAzione();
            }
            if ((response = (CacheResponse)this.cache.get(key = key + "_SA:" + servizioApplicativo)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativo", connectionPdD, idPA, servizioApplicativo) : (ServizioApplicativo)this.getObject("getServizioApplicativo", connectionPdD, idPA, servizioApplicativo);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativo] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(Connection connectionPdD, IDPortaDelegata idPD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null || aPassword == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativoAutenticatoBASIC";
            if (idPD != null && idPD.getLocationPD() != null) {
                key = key + "_" + idPD.getLocationPD();
            }
            if (idPD != null && idPD.getSoggettoFruitore() != null) {
                key = key + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome();
            }
            if ((response = (CacheResponse)this.cache.get(key = key + "_" + aUser + "_" + aPassword)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", connectionPdD, idPD, aUser, aPassword) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", connectionPdD, idPD, aUser, aPassword);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(Connection connectionPdD, String aUser, String aPassword) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null || aPassword == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            key = "getServizioApplicativoAutenticatoBASIC";
            CacheResponse response = (CacheResponse)this.cache.get(key = key + "_" + aUser + "_" + aPassword);
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", connectionPdD, aUser, aPassword) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", connectionPdD, aUser, aPassword);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(Connection connectionPdD, IDPortaDelegata idPD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSubject == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            CacheResponse response;
            key = "getServizioApplicativoAutenticatoSSL";
            if (idPD != null && idPD.getLocationPD() != null) {
                key = key + "_" + idPD.getLocationPD();
            }
            if (idPD != null && idPD.getSoggettoFruitore() != null) {
                key = key + "_" + idPD.getSoggettoFruitore().getTipo() + idPD.getSoggettoFruitore().getNome();
            }
            if ((response = (CacheResponse)this.cache.get(key = key + "_" + aSubject)) != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", connectionPdD, idPD, aSubject) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", connectionPdD, idPD, aSubject);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public ServizioApplicativo getServizioApplicativoAutenticato(Connection connectionPdD, String aSubject) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSubject == null) {
            throw new DriverConfigurazioneException("[getServizioApplicativoAutenticato]: Parametro non definito");
        }
        String key = null;
        if (this.cache != null) {
            key = "getServizioApplicativoAutenticatoSSL";
            CacheResponse response = (CacheResponse)this.cache.get(key = key + "_" + aSubject);
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)((Object)response.getException());
                    }
                    throw (DriverConfigurazioneException)((Object)response.getException());
                }
                return (ServizioApplicativo)response.getObject();
            }
        }
        ServizioApplicativo s = null;
        s = this.cache != null ? (ServizioApplicativo)this.getObjectCache(key, "getServizioApplicativoAutenticato", connectionPdD, aSubject) : (ServizioApplicativo)this.getObject("getServizioApplicativoAutenticato", connectionPdD, aSubject);
        if (s != null) {
            return s;
        }
        throw new DriverConfigurazioneNotFound("[getServizioApplicativoAutenticato] Servizio Applicativo non trovato");
    }

    public RoutingTable getRoutingTable(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && routingTable != null) {
            return routingTable;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getRoutingTable")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (RoutingTable)response.getObject();
        }
        RoutingTable r = null;
        r = this.cache != null ? (RoutingTable)this.getObjectCache(key, "getRoutingTable", connectionPdD, new Object[0]) : (RoutingTable)this.getObject("getRoutingTable", connectionPdD, new Object[0]);
        if (r != null) {
            if (!this.configurazioneDinamica) {
                routingTable = r;
            }
            return r;
        }
        throw new DriverConfigurazioneNotFound("[getRoutingTable] RoutingTable non trovata");
    }

    public AccessoRegistro getAccessoRegistro(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && accessoRegistro != null) {
            return accessoRegistro;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getAccessoRegistro")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (AccessoRegistro)response.getObject();
        }
        AccessoRegistro ar = null;
        ar = this.cache != null ? (AccessoRegistro)this.getObjectCache(key, "getAccessoRegistro", connectionPdD, new Object[0]) : (AccessoRegistro)this.getObject("getAccessoRegistro", connectionPdD, new Object[0]);
        if (ar != null) {
            if (!this.configurazioneDinamica) {
                accessoRegistro = ar;
            }
            return ar;
        }
        throw new DriverConfigurazioneNotFound("[getAccessoRegistro] Configurazione di accesso ai registri non trovata");
    }

    public GestioneErrore getGestioneErroreComponenteCooperazione(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(connectionPdD, true);
    }

    public GestioneErrore getGestioneErroreComponenteIntegrazione(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getGestioneErrore(connectionPdD, false);
    }

    /*
     * Unable to fully structure code
     */
    private GestioneErrore getGestioneErrore(Connection connectionPdD, boolean cooperazione) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (!this.configurazioneDinamica) {
            if (cooperazione) {
                if (ConfigurazionePdD.gestioneErroreComponenteCooperazione != null) {
                    return ConfigurazionePdD.gestioneErroreComponenteCooperazione;
                }
            } else if (ConfigurazionePdD.gestioneErroreComponenteIntegrazione != null) {
                return ConfigurazionePdD.gestioneErroreComponenteIntegrazione;
            }
        }
        key = null;
        if (this.cache != null) {
            key = "getGestioneErrore";
            key = cooperazione != false ? key + "ComponenteCooperazione" : key + "ComponenteIntegrazione";
            response = (CacheResponse)this.cache.get(key);
            if (response != null) {
                if (response.getException() != null) {
                    if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                        throw (DriverConfigurazioneNotFound)response.getException();
                    }
                    throw (DriverConfigurazioneException)response.getException();
                }
                return (GestioneErrore)response.getObject();
            }
        }
        ge = null;
        nomeMetodo = "getGestioneErrore";
        nomeMetodo = cooperazione != false ? nomeMetodo + "ComponenteCooperazione" : nomeMetodo + "ComponenteIntegrazione";
        if (this.cache != null) {
            try {
                ge = (GestioneErrore)this.getObjectCache(key, nomeMetodo, connectionPdD, new Object[0]);
            }
            catch (DriverConfigurazioneException e) {
                erroreCooperazione = "Configurazione, Algoritmo di Cache fallito: Metodo (getGestioneErroreComponenteCooperazione) ha ritornato un valore null";
                erroreIntegrazione = "Configurazione, Algoritmo di Cache fallito: Metodo (getGestioneErroreComponenteIntegrazione) ha ritornato un valore null";
                if (e.getMessage() == null || erroreCooperazione.equals(e.getMessage()) || erroreIntegrazione.equals(e.getMessage())) ** GOTO lbl32
                throw e;
            }
        } else {
            ge = (GestioneErrore)this.getObject(nomeMetodo, connectionPdD, new Object[0]);
        }
lbl32:
        // 3 sources

        if (ge != null) {
            if (!this.configurazioneDinamica) {
                if (cooperazione) {
                    ConfigurazionePdD.gestioneErroreComponenteCooperazione = ge;
                } else {
                    ConfigurazionePdD.gestioneErroreComponenteIntegrazione = ge;
                }
            }
            return ge;
        }
        throw new DriverConfigurazioneNotFound("[getGestioneErrore] GestioneErrore non trovato");
    }

    public Configurazione getConfigurazioneGenerale(Connection connectionPdD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        CacheResponse response;
        if (!this.configurazioneDinamica && configurazioneGeneralePdD != null) {
            return configurazioneGeneralePdD;
        }
        String key = null;
        if (this.cache != null && (response = (CacheResponse)this.cache.get(key = "getConfigurazioneGenerale")) != null) {
            if (response.getException() != null) {
                if (DriverConfigurazioneNotFound.class.getName().equals(response.getException().getClass().getName())) {
                    throw (DriverConfigurazioneNotFound)((Object)response.getException());
                }
                throw (DriverConfigurazioneException)((Object)response.getException());
            }
            return (Configurazione)response.getObject();
        }
        Configurazione c = null;
        c = this.cache != null ? (Configurazione)this.getObjectCache(key, "getConfigurazioneGenerale", connectionPdD, new Object[0]) : (Configurazione)this.getObject("getConfigurazioneGenerale", connectionPdD, new Object[0]);
        if (c != null) {
            if (!this.configurazioneDinamica) {
                configurazioneGeneralePdD = c;
            }
            return c;
        }
        throw new DriverConfigurazioneNotFound("[getConfigurazioneGenerale] Configurazione Generale non trovata");
    }

    public StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazionePdD.getStatoServiziPdD();
    }

    public void updateStatoServiziPdD(StatoServiziPdd servizi) throws DriverConfigurazioneException {
        if (this.driverConfigurazionePdD instanceof DriverConfigurazioneDB) {
            ((DriverConfigurazioneDB)this.driverConfigurazionePdD).updateStatoServiziPdD(servizi);
        }
    }

    public SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.driverConfigurazionePdD.getSystemPropertiesPdD();
    }

    public void updateSystemPropertiesPdD(SystemProperties systemProperties) throws DriverConfigurazioneException {
        if (this.driverConfigurazionePdD instanceof DriverConfigurazioneDB) {
            ((DriverConfigurazioneDB)this.driverConfigurazionePdD).updateSystemPropertiesPdD(systemProperties);
        }
    }
}

