/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.utenti;

import java.sql.Connection;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.lib.users.DriverUsersDBException;
import org.openspcoop2.web.lib.users.dao.User;
import org.openspcoop2.web.lib.users.dao.UserObjects;

public class UtentiCore
extends ControlStationCore {
    public UtentiCore() throws DriverControlStationException {
    }

    public UtentiCore(ControlStationCore core) {
        super(core);
    }

    public boolean existsUser(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "existsUser";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverUsersDB().existsUser(login);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> getUsersWithType(String permesso) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUsersWithType";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverUsersDB().getUsersByPermesso(permesso);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public User getUser(String login) throws DriverUsersDBException {
        return this.getUser(login, true);
    }

    public User getUser(String login, boolean logError) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUser";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            User user = driver.getDriverUsersDB().getUser(login);
            return user;
        }
        catch (Exception e) {
            if (logError) {
                ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            }
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public User getUser(long id) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUser";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            User user = driver.getDriverUsersDB().getUser(Long.valueOf(id));
            return user;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<User> userList(ISearch ricerca) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "userList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverUsersDB().userList(ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> getUsersByProtocolloSupportato(String protocollo) throws DriverUsersDBException {
        return this.getUsersByProtocolloSupportato(protocollo, false);
    }

    public List<String> getUsersByProtocolloSupportato(String protocollo, boolean esclusiUtentiConSoloPermessoUtente) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getUsersByProtocolloSupportato";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverUsersDB().getUsersByProtocolloSupportato(protocollo, esclusiUtentiConSoloPermessoUtente);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDServizio> utentiServiziList(String login, ISearch ricerca) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "utentiServiziList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverUsersDB().utentiServiziList(login, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] Exception :" + e.getMessage(), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDSoggetto> utentiSoggettiList(String login, ISearch ricerca) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "utentiSoggettiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverUsersDB().utentiSoggettiList(login, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] Exception :" + e.getMessage(), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void salvaModalitaUserPddConsole(String login, String protocollo) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "salvaModalitaUserPddConsole";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            driver.getDriverUsersDB().saveProtocolloUtilizzatoPddConsole(login, protocollo);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void salvaSoggettoOperativoUserPddConsole(String login, String soggetto) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "salvaSoggettoOperativoUserPddConsole";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            driver.getDriverUsersDB().saveSoggettoUtilizzatoPddConsole(login, soggetto);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void modificaSoggettoUtilizzatoConsole(String oldSoggetto, String newSoggetto) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "modificaSoggettoUtilizzatoConsole";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            driver.getDriverUsersDB().modificaSoggettoUtilizzatoConsole(oldSoggetto, newSoggetto);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public UserObjects countUserServizi(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "countUserServizi";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            UserObjects userObjects = driver.getDriverUsersDB().countUserServizi(login);
            return userObjects;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public UserObjects countUserCooperazione(String login) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "countUserCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            UserObjects userObjects = driver.getDriverUsersDB().countUserCooperazione(login);
            return userObjects;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public UserObjects updateUserServizi(String oldUser, String newUser) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "updateUserServizi";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            UserObjects userObjects = driver.getDriverUsersDB().updateUserServizi(oldUser, newUser);
            return userObjects;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public UserObjects updateUserCooperazione(String oldUser, String newUser) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "updateUserCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            UserObjects userObjects = driver.getDriverUsersDB().updateUserCooperazione(oldUser, newUser);
            return userObjects;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

