/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Proprieta;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.IDSoggettoDB;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.pdd.core.autenticazione.ApiKeyUtilities;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.resources.MapReader;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.registro.GestoreRegistroServiziRemoto;
import org.openspcoop2.web.lib.users.DriverUsersDBException;

public class SoggettiCore
extends ControlStationCore {
    public SoggettiCore() throws DriverControlStationException {
    }

    public SoggettiCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    /*
     * Loose catch block
     */
    public List<IDSoggetto> getAllIdSoggettiRegistro(FiltroRicercaSoggetti filtroRicerca) throws DriverRegistroServiziException {
        String nomeMetodo;
        Connection con;
        block7: {
            con = null;
            nomeMetodo = "getAllIdSoggettiRegistro";
            DriverControlStationDB driver = null;
            if (!this.isRegistroServiziLocale()) break block7;
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getAllIdSoggetti(filtroRicerca);
            ControlStationCore.dbM.releaseConnection(con);
            return list;
        }
        try {
            List list = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getAllIdSoggetti(filtroRicerca);
            ControlStationCore.dbM.releaseConnection(con);
            return list;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logInfo(this.getPrefixError(nomeMetodo, (Exception)((Object)de)));
            ArrayList<IDSoggetto> arrayList = new ArrayList<IDSoggetto>();
            ControlStationCore.dbM.releaseConnection(con);
            return arrayList;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
            {
                catch (Throwable throwable) {
                    ControlStationCore.dbM.releaseConnection(con);
                    throw throwable;
                }
            }
        }
    }

    public boolean existsSoggetto(long idSoggetto) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsSoggetto(long)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsSoggetto(idSoggetto);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsSoggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverConfigurazioneDB().existsSoggetto(idSoggetto);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsSoggetto(String codiceIPA) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "existsSoggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsSoggetto(codiceIPA);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoByCodiceIPA(String codiceIPA) throws DriverConfigurazioneException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getSoggettoByCodiceIPA";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggetto(codiceIPA);
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getCodiceIPA(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getCodiceIPA";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            String string = driver.getDriverRegistroServiziDB().getCodiceIPA(idSoggetto);
            return string;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Soggetto getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getSoggettoRegistro";
        DriverControlStationDB driver = null;
        try {
            if (this.isRegistroServiziLocale()) {
                con = ControlStationCore.dbM.getConnection();
                driver = new DriverControlStationDB(con, null, this.tipoDB);
                Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggetto(idSoggetto);
                ControlStationCore.dbM.releaseConnection(con);
                return soggetto;
            }
        }
        catch (DriverRegistroServiziNotFound de) {
            try {
                ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
                throw de;
                catch (Exception e) {
                    ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
                    throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                ControlStationCore.dbM.releaseConnection(con);
                throw throwable;
            }
        }
        {
            Soggetto soggetto = GestoreRegistroServiziRemoto.getDriverRegistroServizi(ControlStationCore.log).getSoggetto(idSoggetto);
            ControlStationCore.dbM.releaseConnection(con);
            return soggetto;
        }
    }

    public IDSoggetto getIdSoggettoRegistro(long idErogatore) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdSoggettoRegistro";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDSoggetto iDSoggetto = driver.getDriverRegistroServiziDB().getIdSoggetto(idErogatore);
            return iDSoggetto;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoRegistro(long idErogatore) throws DriverRegistroServiziNotFound, DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getSoggettoRegistro";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggetto(idErogatore);
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsSoggettoServiziWithoutConnettore(long idSoggetto) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsSoggettoServiziWithoutConnettore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsSoggettoServiziWithoutConnettore(idSoggetto);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existFruizioniServiziSoggettoWithoutConnettore(long idSoggetto, boolean escludiSoggettiEsterni) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existFruizioniServiziSoggettoWithoutConnettore";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existFruizioniServiziSoggettoWithoutConnettore(idSoggetto, escludiSoggettiEsterni);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public org.openspcoop2.core.config.Soggetto getRouter() throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getRouter";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.config.Soggetto soggetto = driver.getDriverConfigurazioneDB().getRouter();
            return soggetto;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logInfo(this.getPrefixError(nomeMetodo, (Exception)((Object)de)));
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public org.openspcoop2.core.config.Soggetto getSoggetto(IDSoggetto soggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        Connection con = null;
        String nomeMetodo = "getSoggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.config.Soggetto soggetto2 = driver.getDriverConfigurazioneDB().getSoggetto(soggetto);
            return soggetto2;
        }
        catch (DriverControlStationException e) {
            ControlStationCore.logError(e.getMessage(), (Throwable)((Object)e));
            throw new DriverConfigurazioneException((Throwable)((Object)e));
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logInfo(this.getPrefixError(nomeMetodo, (Exception)((Object)de)));
            throw de;
        }
        catch (DriverConfigurazioneException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public org.openspcoop2.core.config.Soggetto getSoggetto(long idSoggetto) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggetto";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.config.Soggetto soggetto = driver.getDriverConfigurazioneDB().getSoggetto(idSoggetto);
            return soggetto;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logInfo(this.getPrefixError(nomeMetodo, (Exception)((Object)de)));
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public SoggettoCtrlStat getSoggettoCtrlStat(long idSoggetto) throws DriverConfigurazioneNotFound, DriverRegistroServiziNotFound, DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "getSoggettoCtrlStat";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            org.openspcoop2.core.config.Soggetto soggConf = driver.getDriverConfigurazioneDB().getSoggetto(idSoggetto);
            Soggetto soggReg = null;
            if (this.isRegistroServiziLocale()) {
                soggReg = driver.getDriverRegistroServiziDB().getSoggetto(idSoggetto);
            }
            SoggettoCtrlStat soggettoCtrlStat = new SoggettoCtrlStat(soggReg, soggConf);
            return soggettoCtrlStat;
        }
        catch (DriverConfigurazioneNotFound de) {
            ControlStationCore.logInfo(this.getPrefixError(nomeMetodo, (Exception)((Object)de)));
            throw de;
        }
        catch (DriverRegistroServiziNotFound de) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)de)), de);
            throw de;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public long getIdSoggetto(String nomeSoggetto, String tipoSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getIdSoggetto";
        DriverControlStationDB driver = null;
        long idSoggetto = -1L;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDSoggetto aSoggetto = new IDSoggetto(tipoSoggetto, nomeSoggetto);
            idSoggetto = driver.getDriverConfigurazioneDB().getSoggetto(aSoggetto).getId();
        }
        catch (DriverConfigurazioneNotFound e) {
            ControlStationCore.logDebug(this.getPrefixNotFound(nomeMetodo, (Exception)((Object)e)), e);
            throw new DriverConfigurazioneException(this.getPrefixNotFound(nomeMetodo, (Exception)((Object)e)), (Throwable)e);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
        return idSoggetto;
    }

    public List<org.openspcoop2.core.config.Soggetto> soggettiList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().soggettiList(superuser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<org.openspcoop2.core.config.Soggetto> soggettiWithServiziList(String superuser, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiWithServiziList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().soggettiWithServiziList(superuser, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isSoggettoInUso(Soggetto soggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "isSoggettoInUso(Registro)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isSoggettoInUso(soggetto, whereIsInUso, normalizeObjectIds, verificaRuoli);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isSoggettoInUso(org.openspcoop2.core.config.Soggetto soggetto, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds, boolean verificaRuoli) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "isSoggettoInUso(Config)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isSoggettoInUso(soggetto, whereIsInUso, normalizeObjectIds, verificaRuoli);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isSoggettoInUsoInPackageFinali(Soggetto soggetto, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "isSoggettoInUsoInPackageFinali";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().isSoggettoInUsoInPackageFinali(soggetto, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isSoggettoInUsoInPackagePubblici(Soggetto soggetto, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverControlStationException {
        Connection con = null;
        String nomeMetodo = "isSoggettoInUsoInPackagePubblici";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().isSoggettoInUsoInPackagePubblici(soggetto, whereIsInUso);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverControlStationException(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDSoggetto> getSoggettiWithSuperuser(String user) throws DriverUsersDBException {
        Connection con = null;
        String nomeMetodo = "getSoggettiWithSuperuser";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverConfigurazioneDB().getSoggettiWithSuperuser(user);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverUsersDBException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> getTipiSoggettiGestiti() throws DriverRegistroServiziException {
        String nomeMetodo = "getTipiSoggettiGestiti";
        try {
            ArrayList<String> tipi = new ArrayList<String>();
            MapReader protocolFactories = this.protocolFactoryManager.getProtocolFactories();
            Enumeration protocolli = protocolFactories.keys();
            while (protocolli.hasMoreElements()) {
                String protocollo = (String)protocolli.nextElement();
                IProtocolFactory protocolFactory = (IProtocolFactory)protocolFactories.get((Object)protocollo);
                for (String tipo : protocolFactory.createProtocolConfiguration().getTipiSoggetti()) {
                    if (tipi.contains(tipo)) continue;
                    tipi.add(tipo);
                }
            }
            return tipi;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getTipoSoggettoDefaultProtocollo(String protocollo) throws DriverRegistroServiziException {
        String getTipoServizioDefault = "getTipoSoggettoDefaultProtocollo";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().getTipoSoggettoDefault();
        }
        catch (Exception e) {
            String msgError = this.getPrefixError(getTipoServizioDefault, e);
            ControlStationCore.logError(msgError, e);
            throw new DriverRegistroServiziException(msgError, (Throwable)e);
        }
    }

    public List<String> getTipiSoggettiGestitiProtocollo(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "getTipiSoggettiGestitiProtocollo";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().getTipiSoggetti();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getProtocolloAssociatoTipoSoggetto(String tipoSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getProtocolloAssociatoTipoSoggetto";
        try {
            return this.protocolFactoryManager.getProtocolByOrganizationType(tipoSoggetto);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getWebContextProtocolAssociatoTipoSoggetto(String tipoSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getWebContextProtocolAssociatoTipoSoggetto";
        try {
            String protocollo = this.getProtocolloAssociatoTipoSoggetto(tipoSoggetto);
            IProtocolFactory pf = this.protocolFactoryManager.getProtocolFactoryByName(protocollo);
            if (pf.getManifest().getWeb().getEmptyContext() != null && pf.getManifest().getWeb().getEmptyContext().isEnabled()) {
                return "";
            }
            return pf.getManifest().getWeb().getContext(0).getName();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getIdentificativoPortaDefault(String protocollo, IDSoggetto soggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "getIdentificativoPortaDefault";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createTraduttore().getIdentificativoPortaDefault(soggetto);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoIdentificativoPorta(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoIdentificativoPorta";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoIdentificativoPortaSoggetto();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoCodiceIPA(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoCodiceIPA";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoCodiceIPA();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoTrattinoNomeSoggetto(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoTrattinoNomeSoggetto";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoSoggettoUtilizzoTrattino();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoAutenticazioneSoggetti(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoAutenticazioneSoggetti";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoAutenticazioneSoggetti();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoAutenticazioneApplicativiErogazione(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoAutenticazioneApplicativiErogazione";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportoAutenticazioneApplicativiErogazioni();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public boolean isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazione(String protocollo) throws DriverRegistroServiziException {
        String nomeMetodo = "isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazione";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazioni();
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public String getCodiceIPADefault(String protocollo, IDSoggetto soggetto, boolean createURI) throws DriverRegistroServiziException {
        String nomeMetodo = "getCodiceIPADefault";
        try {
            return this.protocolFactoryManager.getProtocolFactoryByName(protocollo).createTraduttore().getIdentificativoCodiceIPADefault(soggetto, createURI);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public List<String> soggettiRuoliList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiRuoliList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().soggettiRuoliList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto soggettoWithCredenzialiBasic(String user, String password, boolean checkPassword) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettoWithCredenzialiBasic";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().soggettoWithCredenzialiBasic(user, password, checkPassword);
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String toAppId(String protocollo, IDSoggetto idSoggetto, boolean multipleApiKeys) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "toAppId";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            String string = ApiKeyUtilities.toAppId((String)protocollo, (IDSoggetto)idSoggetto, (boolean)multipleApiKeys, (DriverRegistroServiziDB)driver.getDriverRegistroServiziDB());
            return string;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ApiKey newApiKey(String protocollo, IDSoggetto idSoggetto) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "newApiKey";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            ApiKey apiKey = ApiKeyUtilities.newApiKey((String)protocollo, (IDSoggetto)idSoggetto, (int)this.getSoggettiApiKeyLunghezzaPasswordGenerate(), (DriverRegistroServiziDB)driver.getDriverRegistroServiziDB());
            return apiKey;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public ApiKey newMultipleApiKey() throws DriverConfigurazioneException {
        String nomeMetodo = "newMultipleApiKey";
        try {
            return ApiKeyUtilities.newMultipleApiKey((int)this.getSoggettiApiKeyLunghezzaPasswordGenerate());
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public Soggetto soggettoWithCredenzialiApiKey(String user, boolean appId) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettoWithCredenzialiApiKey";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().soggettoWithCredenzialiApiKey(user, appId);
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoRegistroAutenticatoBasic(String user, String password) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettoAutenticatoBasic";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggettoByCredenzialiBasic(user, password, this.getSoggettiPasswordEncrypt());
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound e) {
            Soggetto soggetto = null;
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoRegistroAutenticatoSsl(String subject, String issuer) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettoRegistroAutenticatoSsl(subject,issuer)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggettoByCredenzialiSsl(subject, issuer);
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound e) {
            Soggetto soggetto = null;
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoRegistroAutenticatoSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettoRegistroAutenticatoSsl(certificate)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggettoByCredenzialiSsl(certificate, strictVerifier);
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound e) {
            Soggetto soggetto = null;
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Soggetto> soggettoWithCredenzialiSslList(CertificateInfo certificate, boolean strictVerifier) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettoRegistroAutenticatoSsl";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().soggettoWithCredenzialiSslList(certificate, strictVerifier);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public Soggetto getSoggettoRegistroAutenticatoPrincipal(String principal) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettoAutenticatoPrincipal";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            Soggetto soggetto = driver.getDriverRegistroServiziDB().getSoggettoByCredenzialiPrincipal(principal);
            return soggetto;
        }
        catch (DriverRegistroServiziNotFound e) {
            Soggetto soggetto = null;
            return soggetto;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDSoggettoDB> getSoggettiFromTipoAutenticazione(List<String> tipiSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, PddTipologia pddTipologia) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "getSoggettiFromTipoAutenticazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getSoggettiFromTipoAutenticazione(tipiSoggetto, superuser, credenziale, appId, pddTipologia);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public String getDettagliSoggettoInUso(Soggetto soggetto, boolean verificaRuoli) throws DriverControlStationException {
        EnumMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new EnumMap<ErrorsHandlerCostant, List<String>>(ErrorsHandlerCostant.class);
        boolean normalizeObjectIds = true;
        boolean saInUso = this.isSoggettoInUso(soggetto, whereIsInUso, normalizeObjectIds, verificaRuoli);
        StringBuilder inUsoMessage = new StringBuilder();
        if (saInUso) {
            IDSoggetto idSoggetto = new IDSoggetto();
            idSoggetto.setTipo(soggetto.getTipo());
            idSoggetto.setNome(soggetto.getNome());
            idSoggetto.setCodicePorta(soggetto.getIdentificativoPorta());
            String s = DBOggettiInUsoUtils.toString((IDSoggetto)idSoggetto, whereIsInUso, (boolean)false, (String)"\n", (boolean)normalizeObjectIds);
            if (s != null && s.startsWith("\n") && s.length() > 1) {
                s = s.substring(1);
            }
            inUsoMessage.append(s);
            inUsoMessage.append("\n");
        } else {
            inUsoMessage.append("Il soggetto non risulta utilizzato in alcuna configurazione");
        }
        return inUsoMessage.toString();
    }

    public List<Proprieta> soggettiProprietaList(long idSoggetto, ISearch ricerca) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "soggettiProprietaList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().soggettiProprietaList(idSoggetto, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<String> nomiProprietaSoggetti(List<String> tipoSoggettiProtocollo) throws DriverConfigurazioneException {
        Connection con = null;
        String nomeMetodo = "nomiProprietaSoggetti";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().nomiProprietaSoggetti(tipoSoggettiProtocollo);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverConfigurazioneException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

