/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.soggetti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.pdd.core.autenticazione.ApiKey;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.KeystoreType;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.OggettoDialogEnum;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiAddStrutsBean;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class SoggettiAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        SoggettiAddStrutsBean strutsBean = new SoggettiAddStrutsBean();
        strutsBean.consoleOperationType = ConsoleOperationType.ADD;
        TipoOperazione tipoOp = TipoOperazione.ADD;
        try {
            boolean singlePdD;
            String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
            SoggettiHelper soggettiHelper = new SoggettiHelper(request, pd, session);
            strutsBean.protocollo = soggettiHelper.getParameter("protocollo");
            strutsBean.nomeprov = soggettiHelper.getParameter("nomeprov");
            strutsBean.tipoprov = soggettiHelper.getParameter("tipoprov");
            strutsBean.tipologia = soggettiHelper.getParameter("tipologia");
            strutsBean.portadom = soggettiHelper.getParameter("portadom");
            strutsBean.descr = soggettiHelper.getParameter("descr");
            strutsBean.versioneProtocollo = soggettiHelper.getParameter("profilo");
            strutsBean.pdd = soggettiHelper.getParameter("pdd");
            String isRouterParameter = soggettiHelper.getParameter("is_router");
            String isPrivatoParameter = soggettiHelper.getParameter("privato");
            strutsBean.privato = ServletUtils.isCheckBoxEnabled((String)isPrivatoParameter);
            strutsBean.codiceIpa = soggettiHelper.getParameter("codice_ipa");
            strutsBean.pdUrlPrefixRewriter = soggettiHelper.getParameter("pd_url_prefix_rewriter");
            strutsBean.paUrlPrefixRewriter = soggettiHelper.getParameter("pa_url_prefix_rewriter");
            strutsBean.isRouter = ServletUtils.isCheckBoxEnabled((String)isRouterParameter);
            strutsBean.dominio = soggettiHelper.getParameter("dominio");
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            strutsBean.singlePdD = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, Boolean.class, (String)"singlePdD");
            strutsBean.editMode = soggettiHelper.getParameter("edit-mode");
            strutsBean.tipoauthSoggetto = soggettiHelper.getParameter("tipoauthCredenziali");
            strutsBean.utenteSoggetto = soggettiHelper.getParameter("utenteCredenziali");
            strutsBean.passwordSoggetto = soggettiHelper.getParameter("passwordCredenziali");
            strutsBean.subjectSoggetto = soggettiHelper.getParameter("subjectCredenziali");
            strutsBean.principalSoggetto = soggettiHelper.getParameter("principalCredenziali");
            String changepwd = soggettiHelper.getParameter("changepwd");
            String tipoCredenzialiSSLSorgente = soggettiHelper.getParameter("confSSLCredenziali");
            if (tipoCredenzialiSSLSorgente == null) {
                tipoCredenzialiSSLSorgente = "uploadCert";
            }
            String tipoCredenzialiSSLTipoArchivioS = soggettiHelper.getParameter("confSSLCredTipoArch");
            ArchiveType tipoCredenzialiSSLTipoArchivio = null;
            tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
            BinaryParameter tipoCredenzialiSSLFileCertificato = soggettiHelper.getBinaryParameter("confSSLCredFileCert");
            String tipoCredenzialiSSLFileCertificatoPassword = soggettiHelper.getParameter("confSSLCredFileCertPwd");
            List<String> listaAliasEstrattiCertificato = new ArrayList();
            String tipoCredenzialiSSLAliasCertificato = soggettiHelper.getParameter("confSSLCredAliasCert");
            if (tipoCredenzialiSSLAliasCertificato == null) {
                tipoCredenzialiSSLAliasCertificato = "";
            }
            String tipoCredenzialiSSLAliasCertificatoSubject = soggettiHelper.getParameter("confSSLCredAliasCertSub");
            String tipoCredenzialiSSLAliasCertificatoIssuer = soggettiHelper.getParameter("confSSLCredAliasCertIss");
            String tipoCredenzialiSSLAliasCertificatoType = soggettiHelper.getParameter("confSSLCredAliasCertType");
            Object tipoCredenzialiSSLAliasCertificatoVersion = soggettiHelper.getParameter("confSSLCredAliasCertVers");
            Object tipoCredenzialiSSLAliasCertificatoSerialNumber = soggettiHelper.getParameter("confSSLCredAliasCertSN");
            String tipoCredenzialiSSLAliasCertificatoSelfSigned = soggettiHelper.getParameter("confSSLCredAliasCertSS");
            String tipoCredenzialiSSLAliasCertificatoNotBefore = soggettiHelper.getParameter("confSSLCredAliasCertNB");
            String tipoCredenzialiSSLAliasCertificatoNotAfter = soggettiHelper.getParameter("confSSLCredAliasCertNA");
            String tipoCredenzialiSSLVerificaTuttiICampi = soggettiHelper.getParameter("confSSLCredVerifTutti");
            if ((tipoCredenzialiSSLVerificaTuttiICampi == null || StringUtils.isEmpty((String)tipoCredenzialiSSLVerificaTuttiICampi)) && (soggettiHelper.isEditModeInProgress() && soggettiHelper.getPostBackElementName() == null || "dominio".equalsIgnoreCase(soggettiHelper.getPostBackElementName()) || "tipologia".equalsIgnoreCase(soggettiHelper.getPostBackElementName()))) {
                tipoCredenzialiSSLVerificaTuttiICampi = "yes";
            }
            if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = soggettiHelper.getParameter("confSSLManSS")) == null) {
                tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "no";
            }
            String issuerSoggetto = soggettiHelper.getParameter("subjectIssuer");
            String tipoCredenzialiSSLWizardStep = soggettiHelper.getParameter("confSSLCredWizStep");
            if (tipoCredenzialiSSLWizardStep == null) {
                tipoCredenzialiSSLWizardStep = "0";
            }
            String oldTipoCredenzialiSSLWizardStep = tipoCredenzialiSSLWizardStep;
            String multipleApiKey = soggettiHelper.getParameter("apiKeyMultipleCred");
            String appId = soggettiHelper.getParameter("appIdCred");
            String apiKey = soggettiHelper.getParameter("apiKeyCred");
            boolean visualizzaModificaCertificato = false;
            boolean visualizzaAddCertificato = false;
            String servletCredenzialiList = null;
            List<Parameter> parametersServletCredenzialiList = null;
            Integer numeroCertificati = 0;
            String servletCredenzialiAdd = null;
            boolean isRouter = ServletUtils.isCheckBoxEnabled((String)isRouterParameter);
            soggettiHelper.makeMenu();
            String[] pddList = null;
            String[] pddEsterneList = null;
            List<String> tipiSoggetti = null;
            int totPdd = 1;
            String nomePddGestioneLocale = null;
            List<Object> versioniProtocollo = null;
            SoggettiCore soggettiCore = new SoggettiCore();
            PddCore pddCore = new PddCore(soggettiCore);
            ServiziApplicativiCore saCore = new ServiziApplicativiCore(soggettiCore);
            List<String> listaTipiProtocollo = soggettiCore.getProtocolli(request, session);
            if (strutsBean.protocollo == null) {
                strutsBean.protocollo = soggettiCore.getProtocolloDefault(request, session, null);
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                ArrayList<PdDControlStation> lista = new ArrayList<PdDControlStation>();
                PdDControlStation tmp = new PdDControlStation();
                tmp.setNome("-");
                lista.add(tmp);
                if (soggettiCore.isVisioneOggettiGlobale(userLogin)) {
                    lista.addAll(pddCore.pddList(null, (ISearch)new ConsoleSearch(true)));
                } else {
                    lista.addAll(pddCore.pddList(userLogin, (ISearch)new ConsoleSearch(true)));
                }
                totPdd = lista.size();
                pddList = new String[lista.size()];
                int i = 0;
                ArrayList<String> pddEsterne = new ArrayList<String>();
                pddEsterne.add("-");
                for (PdDControlStation pddTmp : lista) {
                    pddList[i] = pddTmp.getNome();
                    ++i;
                    if (strutsBean.singlePdD != null && strutsBean.singlePdD.booleanValue() && nomePddGestioneLocale == null && PddTipologia.OPERATIVO.toString().equals(pddTmp.getTipo())) {
                        nomePddGestioneLocale = pddTmp.getNome();
                    }
                    if (strutsBean.singlePdD == null || !strutsBean.singlePdD.booleanValue() || !PddTipologia.ESTERNO.toString().equals(pddTmp.getTipo())) continue;
                    pddEsterne.add(pddTmp.getNome());
                }
                pddEsterneList = pddEsterne.toArray(new String[1]);
                if (!soggettiCore.isGestionePddAbilitata(soggettiHelper)) {
                    if (nomePddGestioneLocale == null) {
                        throw new ControlStationCoreException("Non \u00e8 stata rilevata una pdd di tipologia 'operativo'");
                    }
                    strutsBean.pdd = SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE.equals(strutsBean.dominio) ? nomePddGestioneLocale : null;
                }
            }
            tipiSoggetti = soggettiCore.getTipiSoggettiGestitiProtocollo(strutsBean.protocollo);
            if (strutsBean.tipoprov == null) {
                strutsBean.tipoprov = soggettiCore.getTipoSoggettoDefaultProtocollo(strutsBean.protocollo);
            }
            String postBackElementName = soggettiHelper.getPostBackElementName();
            String labelButtonSalva = "Salva";
            if (postBackElementName != null) {
                if (postBackElementName.equalsIgnoreCase("dominio")) {
                    strutsBean.tipoauthSoggetto = null;
                    strutsBean.tipologia = "Erogatore";
                }
                if (postBackElementName.equalsIgnoreCase("protocollo")) {
                    strutsBean.versioneProtocollo = null;
                    soggettiHelper.deleteProtocolPropertiesBinaryParameters(new BinaryParameter[0]);
                }
                if (postBackElementName.equalsIgnoreCase("tipologia")) {
                    strutsBean.tipoauthSoggetto = null;
                }
                if (postBackElementName.equalsIgnoreCase("tipoauthCredenziali")) {
                    if (strutsBean.tipoauthSoggetto != null && strutsBean.tipoauthSoggetto.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                        tipoCredenzialiSSLSorgente = "uploadCert";
                        tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                        tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                        tipoCredenzialiSSLAliasCertificato = "";
                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                        tipoCredenzialiSSLAliasCertificatoType = "";
                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                        listaAliasEstrattiCertificato = new ArrayList();
                        tipoCredenzialiSSLWizardStep = "1";
                    } else {
                        tipoCredenzialiSSLWizardStep = "0";
                    }
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredenziali") || postBackElementName.equalsIgnoreCase("confSSLCredFileModificaCertLink")) {
                    listaAliasEstrattiCertificato = new ArrayList();
                    tipoCredenzialiSSLTipoArchivio = ArchiveType.CER;
                    tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                    tipoCredenzialiSSLAliasCertificato = "";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                    soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
                    tipoCredenzialiSSLWizardStep = "1";
                    if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                        strutsBean.subjectSoggetto = "";
                        issuerSoggetto = "";
                        tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "no";
                        tipoCredenzialiSSLWizardStep = "0";
                    }
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredTipoArch")) {
                    soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
                    tipoCredenzialiSSLAliasCertificato = "";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                    listaAliasEstrattiCertificato = new ArrayList();
                    tipoCredenzialiSSLVerificaTuttiICampi = "yes";
                    tipoCredenzialiSSLWizardStep = "1";
                }
                if (postBackElementName.equalsIgnoreCase("confSSLCredAliasCert")) {
                    tipoCredenzialiSSLWizardStep = StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificato) ? "3" : "4";
                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                    tipoCredenzialiSSLAliasCertificatoType = "";
                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                }
                if (postBackElementName.equalsIgnoreCase("apiKeyMultipleCred")) {
                    appId = null;
                    apiKey = null;
                }
            }
            if (strutsBean.versioneProtocollo == null) {
                strutsBean.versioneProtocollo = soggettiCore.getVersioneDefaultProtocollo(strutsBean.protocollo);
            }
            if (soggettiHelper.isModalitaAvanzata()) {
                versioniProtocollo = soggettiCore.getVersioniProtocollo(strutsBean.protocollo);
            } else {
                versioniProtocollo = new ArrayList();
                versioniProtocollo.add(strutsBean.versioneProtocollo);
            }
            boolean isSupportatoCodiceIPA = soggettiCore.isSupportatoCodiceIPA(strutsBean.protocollo);
            boolean isSupportatoIdentificativoPorta = soggettiCore.isSupportatoIdentificativoPorta(strutsBean.protocollo);
            boolean isSupportatoAutenticazioneSoggetti = soggettiCore.isSupportatoAutenticazioneSoggetti(strutsBean.protocollo);
            boolean isPddEsterna = pddCore.isPddEsterna(strutsBean.pdd);
            if (isSupportatoAutenticazioneSoggetti) {
                if (isPddEsterna) {
                    if (strutsBean.tipologia == null || "".equals(strutsBean.tipologia)) {
                        strutsBean.tipologia = "Erogatore";
                    }
                    if ("nessuna".equals(strutsBean.tipoauthSoggetto) && !saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(strutsBean.protocollo)) {
                        strutsBean.tipoauthSoggetto = null;
                    }
                }
                if (strutsBean.tipoauthSoggetto == null) {
                    strutsBean.tipoauthSoggetto = isPddEsterna ? ("Fruitore".equals(strutsBean.tipologia) || "Fruitore/Erogatore".equals(strutsBean.tipologia) ? soggettiCore.getAutenticazione_generazioneAutomaticaPorteApplicative() : "nessuna") : "nessuna";
                }
            }
            boolean checkWizard = false;
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(strutsBean.tipoauthSoggetto)) {
                block112: {
                    if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                        if (tipoCredenzialiSSLFileCertificato.getValue() != null && tipoCredenzialiSSLFileCertificato.getValue().length > 0) {
                            Certificate cSelezionato;
                            tipoCredenzialiSSLWizardStep = "4";
                            if (!tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER)) {
                                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLFileCertificatoPassword) || KeystoreType.JKS.isType(tipoCredenzialiSSLTipoArchivio.name()) && !soggettiCore.isLoadCertificateWizardJksPasswordRequiredRequired() || KeystoreType.PKCS12.isType(tipoCredenzialiSSLTipoArchivio.name()) && !soggettiCore.isLoadCertificateWizardPkcs12PasswordRequiredRequired()) {
                                    try {
                                        listaAliasEstrattiCertificato = ArchiveLoader.readAliases((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLFileCertificatoPassword);
                                        Collections.sort(listaAliasEstrattiCertificato);
                                        if (!listaAliasEstrattiCertificato.isEmpty() && listaAliasEstrattiCertificato.size() == 1) {
                                            tipoCredenzialiSSLAliasCertificato = (String)listaAliasEstrattiCertificato.get(0);
                                        }
                                        if (oldTipoCredenzialiSSLWizardStep.equals("1") || oldTipoCredenzialiSSLWizardStep.equals("5") || oldTipoCredenzialiSSLWizardStep.equals("2")) {
                                            checkWizard = true;
                                            if (listaAliasEstrattiCertificato.size() > 1) {
                                                pd.setMessage("Il file caricato contiene pi&ugrave; certificati, selezionare un'Alias", MessageType.INFO);
                                            }
                                        }
                                    }
                                    catch (UtilsException e) {
                                        pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                        tipoCredenzialiSSLWizardStep = "2";
                                        tipoCredenzialiSSLAliasCertificato = "";
                                        tipoCredenzialiSSLAliasCertificatoSubject = "";
                                        tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                        tipoCredenzialiSSLAliasCertificatoType = "";
                                        tipoCredenzialiSSLAliasCertificatoVersion = "";
                                        tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                        tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                        tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                        tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                    }
                                    if (!listaAliasEstrattiCertificato.isEmpty() && StringUtils.isNotEmpty((String)tipoCredenzialiSSLAliasCertificato)) {
                                        try {
                                            cSelezionato = ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                                            tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                            tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                            tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                            tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                            tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                            tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                            tipoCredenzialiSSLAliasCertificatoNotBefore = strutsBean.sdf.format(cSelezionato.getCertificate().getNotBefore());
                                            tipoCredenzialiSSLAliasCertificatoNotAfter = strutsBean.sdf.format(cSelezionato.getCertificate().getNotAfter());
                                            tipoCredenzialiSSLWizardStep = "3";
                                        }
                                        catch (UtilsException e) {
                                            pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                            tipoCredenzialiSSLWizardStep = "2";
                                            tipoCredenzialiSSLAliasCertificato = "";
                                            tipoCredenzialiSSLAliasCertificatoSubject = "";
                                            tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                            tipoCredenzialiSSLAliasCertificatoType = "";
                                            tipoCredenzialiSSLAliasCertificatoVersion = "";
                                            tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                            tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                            tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                            tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                        }
                                    }
                                } else {
                                    tipoCredenzialiSSLWizardStep = "5";
                                }
                            } else {
                                try {
                                    cSelezionato = ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue());
                                    tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                                    tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                                    tipoCredenzialiSSLAliasCertificatoSelfSigned = cSelezionato.getCertificate().isSelfSigned() ? "Si" : "No";
                                    tipoCredenzialiSSLAliasCertificatoSerialNumber = cSelezionato.getCertificate().getSerialNumber();
                                    tipoCredenzialiSSLAliasCertificatoType = cSelezionato.getCertificate().getType();
                                    tipoCredenzialiSSLAliasCertificatoVersion = "" + cSelezionato.getCertificate().getVersion();
                                    tipoCredenzialiSSLAliasCertificatoNotBefore = strutsBean.sdf.format(cSelezionato.getCertificate().getNotBefore());
                                    tipoCredenzialiSSLAliasCertificatoNotAfter = strutsBean.sdf.format(cSelezionato.getCertificate().getNotAfter());
                                    if (oldTipoCredenzialiSSLWizardStep.equals("6") || oldTipoCredenzialiSSLWizardStep.equals("3")) {
                                        tipoCredenzialiSSLWizardStep = "3";
                                        break block112;
                                    }
                                    tipoCredenzialiSSLWizardStep = "6";
                                    checkWizard = true;
                                }
                                catch (UtilsException e) {
                                    pd.setMessage("Il Certificato selezionato non &egrave; valido: " + e.getMessage());
                                    tipoCredenzialiSSLWizardStep = "2";
                                    tipoCredenzialiSSLAliasCertificato = "";
                                    tipoCredenzialiSSLAliasCertificatoSubject = "";
                                    tipoCredenzialiSSLAliasCertificatoIssuer = "";
                                    tipoCredenzialiSSLAliasCertificatoType = "";
                                    tipoCredenzialiSSLAliasCertificatoVersion = "";
                                    tipoCredenzialiSSLAliasCertificatoSerialNumber = "";
                                    tipoCredenzialiSSLAliasCertificatoSelfSigned = "";
                                    tipoCredenzialiSSLAliasCertificatoNotBefore = "";
                                    tipoCredenzialiSSLAliasCertificatoNotAfter = "";
                                }
                            }
                        } else {
                            tipoCredenzialiSSLWizardStep = "1";
                        }
                    }
                }
                if (StringUtils.isNotEmpty((String)tipoCredenzialiSSLWizardStep) && (tipoCredenzialiSSLWizardStep.equals("1") || tipoCredenzialiSSLWizardStep.equals("5") || tipoCredenzialiSSLWizardStep.equals("2"))) {
                    if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                        labelButtonSalva = "Carica Certificato";
                    }
                } else {
                    labelButtonSalva = "Salva";
                }
            } else {
                labelButtonSalva = "Salva";
            }
            if (labelButtonSalva != null) {
                pd.setLabelBottoneInvia(labelButtonSalva);
            }
            IDSoggetto idSoggetto = new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov);
            strutsBean.protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(strutsBean.protocollo);
            strutsBean.consoleDynamicConfiguration = strutsBean.protocolFactory.createDynamicConfigurationConsole();
            strutsBean.registryReader = soggettiCore.getRegistryReader(strutsBean.protocolFactory);
            strutsBean.configRegistryReader = soggettiCore.getConfigIntegrationReader(strutsBean.protocolFactory);
            strutsBean.consoleConfiguration = strutsBean.consoleDynamicConfiguration.getDynamicConfigSoggetto(strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
            strutsBean.protocolProperties = soggettiHelper.estraiProtocolPropertiesDaRequest(strutsBean.consoleConfiguration, strutsBean.consoleOperationType);
            boolean multipleApiKeysEnabled = false;
            boolean appIdModificabile = false;
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                multipleApiKeysEnabled = ServletUtils.isCheckBoxEnabled((String)multipleApiKey);
                if (appIdModificabile && multipleApiKeysEnabled) {
                    boolean soggettoDefined;
                    boolean bl = soggettoDefined = idSoggetto != null && idSoggetto.getTipo() != null && !"".equals(idSoggetto.getTipo()) && idSoggetto.getNome() != null && !"".equals(idSoggetto.getNome());
                    if ((appId == null || "".equals(appId)) && soggettoDefined) {
                        appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                    }
                }
            }
            if (ServletUtils.isEditModeInProgress((String)strutsBean.editMode) || checkWizard) {
                ServletUtils.setPageDataTitle_ServletAdd((PageData)pd, (String)"Soggetti", (String)"soggettiList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (strutsBean.nomeprov == null) {
                    strutsBean.nomeprov = "";
                    idSoggetto = new IDSoggetto(strutsBean.tipoprov, strutsBean.nomeprov);
                }
                if (strutsBean.portadom == null) {
                    strutsBean.portadom = "";
                }
                if (strutsBean.descr == null) {
                    strutsBean.descr = "";
                }
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                dati = soggettiHelper.addSoggettiToDati(TipoOperazione.ADD, dati, strutsBean.nomeprov, strutsBean.tipoprov, strutsBean.portadom, strutsBean.descr, isRouter, tipiSoggetti, strutsBean.versioneProtocollo, strutsBean.privato, strutsBean.codiceIpa, versioniProtocollo, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, strutsBean.pdd, listaTipiProtocollo, strutsBean.protocollo, isSupportatoAutenticazioneSoggetti, strutsBean.utenteSoggetto, strutsBean.passwordSoggetto, strutsBean.subjectSoggetto, strutsBean.principalSoggetto, strutsBean.tipoauthSoggetto, isPddEsterna, strutsBean.tipologia, strutsBean.dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSoggetto, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd);
                dati = soggettiHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = soggettiHelper.soggettiCheckData(tipoOp, null, strutsBean.tipoprov, strutsBean.nomeprov, strutsBean.codiceIpa, strutsBean.pdUrlPrefixRewriter, strutsBean.paUrlPrefixRewriter, null, false, strutsBean.descr, strutsBean.pdd);
            boolean bl = singlePdD = strutsBean.singlePdD != null && strutsBean.singlePdD != false;
            if (isOk && soggettiCore.isRegistroServiziLocale() && !singlePdD) {
                isOk = false;
                for (int i = 0; i < totPdd; ++i) {
                    String tmpPdd = pddList[i];
                    if (!tmpPdd.equals(strutsBean.pdd) || strutsBean.pdd.equals("-")) continue;
                    isOk = true;
                }
                if (!isOk) {
                    pd.setMessage("La Porta di Dominio dev'essere scelta tra quelle definite nel pannello Porte di Dominio");
                }
            }
            if (isOk) {
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
            }
            if (isOk) {
                try {
                    soggettiHelper.validaProtocolProperties(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (isOk) {
                try {
                    strutsBean.consoleDynamicConfiguration.validateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                }
                catch (ProtocolException e) {
                    ControlStationCore.getLog().error(e.getMessage(), (Throwable)e);
                    pd.setMessage(e.getMessage());
                    isOk = false;
                }
            }
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletAdd((PageData)pd, (String)"Soggetti", (String)"soggettiList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                strutsBean.consoleDynamicConfiguration.updateDynamicConfigSoggetto(strutsBean.consoleConfiguration, strutsBean.consoleOperationType, (IConsoleHelper)soggettiHelper, strutsBean.protocolProperties, strutsBean.registryReader, strutsBean.configRegistryReader, idSoggetto);
                dati = soggettiHelper.addSoggettiToDati(TipoOperazione.ADD, dati, strutsBean.nomeprov, strutsBean.tipoprov, strutsBean.portadom, strutsBean.descr, isRouter, tipiSoggetti, strutsBean.versioneProtocollo, strutsBean.privato, strutsBean.codiceIpa, versioniProtocollo, isSupportatoCodiceIPA, isSupportatoIdentificativoPorta, pddList, pddEsterneList, nomePddGestioneLocale, strutsBean.pdd, listaTipiProtocollo, strutsBean.protocollo, isSupportatoAutenticazioneSoggetti, strutsBean.utenteSoggetto, strutsBean.passwordSoggetto, strutsBean.subjectSoggetto, strutsBean.principalSoggetto, strutsBean.tipoauthSoggetto, isPddEsterna, strutsBean.tipologia, strutsBean.dominio, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, (String)tipoCredenzialiSSLAliasCertificatoVersion, (String)tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuerSoggetto, tipoCredenzialiSSLWizardStep, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd);
                dati = soggettiHelper.addProtocolPropertiesToDatiRegistry(dati, strutsBean.consoleConfiguration, strutsBean.consoleOperationType, strutsBean.protocolProperties);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.ADD());
            }
            if (strutsBean.codiceIpa == null || strutsBean.codiceIpa.equals("")) {
                strutsBean.codiceIpa = soggettiCore.getCodiceIPADefault(strutsBean.protocollo, idSoggetto, false);
            }
            if (strutsBean.portadom == null || strutsBean.portadom.equals("")) {
                strutsBean.portadom = soggettiCore.getIdentificativoPortaDefault(strutsBean.protocollo, idSoggetto);
            }
            boolean secret = false;
            String secretPassword = null;
            String secretUser = null;
            boolean secretAppId = false;
            Soggetto soggettoRegistro = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistro = new Soggetto();
            }
            org.openspcoop2.core.config.Soggetto soggettoConfig = new org.openspcoop2.core.config.Soggetto();
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistro.setNome(strutsBean.nomeprov);
                soggettoRegistro.setTipo(strutsBean.tipoprov);
                soggettoRegistro.setDescrizione(strutsBean.descr);
                soggettoRegistro.setVersioneProtocollo(strutsBean.versioneProtocollo);
                soggettoRegistro.setIdentificativoPorta(strutsBean.portadom);
                soggettoRegistro.setCodiceIpa(strutsBean.codiceIpa);
                if (!pddCore.isGestionePddAbilitata(soggettiHelper)) {
                    strutsBean.pdd = SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE.equals(strutsBean.dominio) ? nomePddGestioneLocale : null;
                }
                if (soggettiCore.isSinglePdD()) {
                    if (strutsBean.pdd == null || strutsBean.pdd.equals("-")) {
                        soggettoRegistro.setPortaDominio(null);
                    } else {
                        soggettoRegistro.setPortaDominio(strutsBean.pdd);
                    }
                } else {
                    soggettoRegistro.setPortaDominio(strutsBean.pdd);
                }
                soggettoRegistro.setSuperUser(userLogin);
                soggettoRegistro.setPrivato(Boolean.valueOf(strutsBean.privato));
                if (isSupportatoAutenticazioneSoggetti) {
                    if (strutsBean.tipoauthSoggetto != null && !"".equals(strutsBean.tipoauthSoggetto) && !"nessuna".equals(strutsBean.tipoauthSoggetto)) {
                        CredenzialiSoggetto credenziali = new CredenzialiSoggetto();
                        credenziali.setTipo(CredenzialeTipo.toEnumConstant((String)strutsBean.tipoauthSoggetto));
                        credenziali.setUser(strutsBean.utenteSoggetto);
                        if (strutsBean.principalSoggetto != null && !"".equals(strutsBean.principalSoggetto)) {
                            credenziali.setUser(strutsBean.principalSoggetto);
                        }
                        credenziali.setPassword(strutsBean.passwordSoggetto);
                        ApiKey apiKeyGenerated = null;
                        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto)) {
                            credenziali.setAppId(multipleApiKeysEnabled);
                            if (multipleApiKeysEnabled) {
                                apiKeyGenerated = soggettiCore.newMultipleApiKey();
                                if (!appIdModificabile) {
                                    appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                                }
                            } else {
                                appId = soggettiCore.toAppId(strutsBean.protocollo, idSoggetto, multipleApiKeysEnabled);
                                apiKeyGenerated = soggettiCore.newApiKey(strutsBean.protocollo, idSoggetto);
                            }
                            credenziali.setUser(appId);
                            credenziali.setPassword(apiKeyGenerated.getPassword());
                        } else {
                            credenziali.setAppId(false);
                        }
                        if (soggettiCore.isSoggettiPasswordEncryptEnabled() && (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(strutsBean.tipoauthSoggetto) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(strutsBean.tipoauthSoggetto))) {
                            secret = true;
                            secretUser = credenziali.getUser();
                            secretPassword = apiKeyGenerated != null ? apiKeyGenerated.getApiKey() : credenziali.getPassword();
                            secretAppId = credenziali.isAppId();
                        }
                        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(strutsBean.tipoauthSoggetto)) {
                            if (tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                                Certificate cSelezionato = null;
                                cSelezionato = tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])tipoCredenzialiSSLFileCertificato.getValue()) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])tipoCredenzialiSSLFileCertificato.getValue(), (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                                credenziali.setCertificateStrictVerification(ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi));
                                credenziali.setCnIssuer(cSelezionato.getCertificate().getIssuer().getCN());
                                credenziali.setCnSubject(cSelezionato.getCertificate().getSubject().getCN());
                                credenziali.setCertificate(cSelezionato.getCertificate().getCertificate().getEncoded());
                            } else {
                                credenziali.setSubject(strutsBean.subjectSoggetto);
                                if (ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLConfigurazioneManualeSelfSigned)) {
                                    credenziali.setIssuer(strutsBean.subjectSoggetto);
                                } else {
                                    credenziali.setIssuer(issuerSoggetto);
                                }
                            }
                        }
                        soggettoRegistro.addCredenziali(credenziali);
                    } else {
                        soggettoRegistro.getCredenzialiList().clear();
                    }
                }
            }
            Connettore connettore = null;
            if (soggettiCore.isRegistroServiziLocale()) {
                connettore = new Connettore();
                connettore.setTipo(CostantiDB.CONNETTORE_TIPO_DISABILITATO);
            }
            boolean bl2 = singlePdD = strutsBean.singlePdD != null && strutsBean.singlePdD != false;
            if (!singlePdD && soggettiCore.isRegistroServiziLocale() && !strutsBean.pdd.equals("-")) {
                PdDControlStation aPdD = pddCore.getPdDControlStation(strutsBean.pdd);
                int porta = aPdD.getPorta() <= 0 ? 80 : aPdD.getPorta();
                String tipoPdD = aPdD.getTipo();
                if (tipoPdD != null && !strutsBean.singlePdD.booleanValue() && (tipoPdD.equals(PddTipologia.OPERATIVO.toString()) || tipoPdD.equals(PddTipologia.NONOPERATIVO.toString()))) {
                    String ipPdd = aPdD.getIp();
                    Object url = aPdD.getProtocollo() + "://" + ipPdd + ":" + porta + "/" + soggettiCore.getSuffissoConnettoreAutomatico();
                    url = ((String)url).replace("@protocol@", soggettiCore.getWebContextProtocolAssociatoTipoSoggetto(strutsBean.tipoprov));
                    connettore.setTipo(CostantiDB.CONNETTORE_TIPO_HTTP);
                    Property property = new Property();
                    property.setNome("location");
                    property.setValore((String)url);
                    connettore.addProperty(property);
                }
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                soggettoRegistro.setConnettore(connettore);
            }
            soggettoConfig.setNome(strutsBean.nomeprov);
            soggettoConfig.setTipo(strutsBean.tipoprov);
            soggettoConfig.setDescrizione(strutsBean.descr);
            soggettoConfig.setIdentificativoPorta(strutsBean.portadom);
            soggettoConfig.setRouter(strutsBean.isRouter);
            soggettoConfig.setSuperUser(userLogin);
            if (soggettoRegistro != null) {
                soggettoRegistro.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)strutsBean.protocolProperties, (ConsoleOperationType)strutsBean.consoleOperationType, null));
            }
            SoggettoCtrlStat sog = new SoggettoCtrlStat(soggettoRegistro, soggettoConfig);
            soggettiCore.performCreateOperation(userLogin, soggettiHelper.smista(), sog);
            soggettiHelper.deleteBinaryProtocolPropertiesTmpFiles(strutsBean.protocolProperties);
            soggettiHelper.deleteBinaryParameters(tipoCredenzialiSSLFileCertificato);
            if (secret) {
                soggettiHelper.setSecretPleaseCopy(secretPassword, secretUser, secretAppId, strutsBean.tipoauthSoggetto, OggettoDialogEnum.SOGGETTO, sog.getNome());
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            if (soggettiCore.isSetSearchAfterAdd()) {
                soggettiCore.setSearchAfterAdd(Liste.SOGGETTI, soggettoConfig.getNome(), request, session, (ISearch)ricerca);
            }
            if (soggettiCore.isRegistroServiziLocale()) {
                List<Soggetto> listaSoggettiRegistro = null;
                listaSoggettiRegistro = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiRegistroList(null, (ISearch)ricerca) : soggettiCore.soggettiRegistroList(userLogin, (ISearch)ricerca);
                soggettiHelper.prepareSoggettiList(listaSoggettiRegistro, (ISearch)ricerca);
            } else {
                List<org.openspcoop2.core.config.Soggetto> listaSoggettiConfig = null;
                listaSoggettiConfig = soggettiCore.isVisioneOggettiGlobale(userLogin) ? soggettiCore.soggettiList(null, (ISearch)ricerca) : soggettiCore.soggettiList(userLogin, (ISearch)ricerca);
                soggettiHelper.prepareSoggettiConfigList(listaSoggettiConfig, (ISearch)ricerca);
            }
            if (!pddCore.isPddEsterna(strutsBean.pdd)) {
                generalHelper = new GeneralHelper(session);
                gd = generalHelper.initGeneralData(request);
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"soggetti", (ForwardParams)ForwardParams.ADD());
        }
    }
}

