/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.sa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataServizioApplicativo;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ConfigurazioneFiltroServiziApplicativi;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.KeystoreParams;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.crypt.PasswordGenerator;
import org.openspcoop2.utils.crypt.PasswordVerifier;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ServiziApplicativiHelper
extends ConnettoriHelper {
    public ServiziApplicativiHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public ServiziApplicativiHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public boolean servizioApplicativoEndPointCheckData(String protocollo, List<ExtendedConnettore> listExtendedConnettore, ServizioApplicativo saOld) throws Exception {
        try {
            String sbustamento = this.getParameter("sbustamento");
            String sbustamentoInformazioniProtocolloRichiesta = this.getParameter("sbustamentoInformazioniProtocolloRichiesta");
            String getmsg = this.getParameter("getmsg");
            String getmsgUsername = this.getParameter("utenteCredenziali");
            String getmsgPassword = this.getParameter("passwordCredenziali");
            String tipoauth = this.getParameter("tipoauthInv");
            if (tipoauth == null) {
                tipoauth = "nessuna";
            }
            String utente = this.getParameter("utenteInv");
            String password = this.getLockedParameter("passwordInv");
            String servizioApplicativoServerEnabledS = this.getParameter("saServerEnabled");
            boolean servizioApplicativoServerEnabled = ServletUtils.isCheckBoxEnabled((String)servizioApplicativoServerEnabledS);
            if (!servizioApplicativoServerEnabled) {
                if (tipoauth.equals("")) {
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Tipo");
                    return false;
                }
                if (tipoauth.equals(CostantiConfigurazione.CREDENZIALE_BASIC.toString()) && (utente.equals("") || password.equals(""))) {
                    Object tmpElenco = "";
                    if (utente.equals("")) {
                        tmpElenco = "Utente";
                    }
                    if (password.equals("")) {
                        tmpElenco = ((String)tmpElenco).equals("") ? "Password" : (String)tmpElenco + ", Password";
                    }
                    this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                    return false;
                }
                if (tipoauth.equals(CostantiConfigurazione.CREDENZIALE_BASIC.toString()) && (utente.indexOf(" ") != -1 || password.indexOf(" ") != -1)) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!CostantiConfigurazione.ABILITATO.toString().equals(getmsg) && !CostantiConfigurazione.DISABILITATO.toString().equals(getmsg)) {
                    this.pd.setMessage("Servizio 'Servizio IntegrationManager/MessageBox' dev'essere " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                    return false;
                }
                if (getmsg != null && getmsg.equals(CostantiConfigurazione.ABILITATO.toString())) {
                    StringBuilder motivazioneErrore;
                    PasswordVerifier passwordVerifier;
                    Credenziali c;
                    boolean add = true;
                    if (saOld != null && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().sizeCredenzialiList() > 0 && CredenzialeTipo.BASIC.equals((Object)(c = saOld.getInvocazionePorta().getCredenziali(0)).getTipo())) {
                        add = false;
                    }
                    boolean encryptEnabled = this.saCore.isApplicativiPasswordEncryptEnabled();
                    boolean validaPassword = false;
                    if (add || !encryptEnabled) {
                        validaPassword = true;
                    } else {
                        String changePwd = this.getParameter("changepwd");
                        if (ServletUtils.isCheckBoxEnabled((String)changePwd)) {
                            validaPassword = true;
                        }
                    }
                    boolean passwordEmpty = false;
                    if (validaPassword && (getmsgPassword == null || getmsgPassword.equals(""))) {
                        passwordEmpty = true;
                    }
                    if (getmsgUsername == null || "".equals(getmsgUsername)) {
                        this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare 'Username' per il servizio 'Servizio IntegrationManager/MessageBox'");
                        return false;
                    }
                    if (passwordEmpty) {
                        this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare 'Password' per il servizio 'Servizio IntegrationManager/MessageBox'");
                        return false;
                    }
                    if (getmsgUsername.indexOf(" ") != -1 || validaPassword && getmsgPassword.indexOf(" ") != -1) {
                        this.pd.setMessage("Non inserire spazi nei campi di testo");
                        return false;
                    }
                    if (validaPassword && (passwordVerifier = this.saCore.getApplicativiPasswordVerifier()) != null && !passwordVerifier.validate(getmsgUsername, getmsgPassword, motivazioneErrore = new StringBuilder())) {
                        this.pd.setMessage(motivazioneErrore.toString());
                        return false;
                    }
                    boolean checkPassword = this.saCore.isApplicativiCredenzialiBasicCheckUniqueUsePassword();
                    List<ServizioApplicativo> saList = this.saCore.servizioApplicativoWithCredenzialiBasicList(getmsgUsername, getmsgPassword, checkPassword);
                    for (int i = 0; i < saList.size(); ++i) {
                        ServizioApplicativo sa = saList.get(i);
                        if (saOld != null && saOld.getId().longValue() == sa.getId().longValue()) continue;
                        IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
                        String labelSoggetto = this.getLabelNomeSoggetto(idSoggettoProprietario);
                        if (sa.getTipo() != null && StringUtils.isNotEmpty((String)sa.getTipo())) {
                            this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 l'utente (http-basic) indicato");
                        } else {
                            IDServizioApplicativo idSA = new IDServizioApplicativo();
                            idSA.setIdSoggettoProprietario(idSoggettoProprietario);
                            idSA.setNome(sa.getNome());
                            List<IDPortaApplicativa> list = this.porteApplicativeCore.porteApplicativeWithApplicativoErogatore(idSA);
                            Object labelErogazione = sa.getNome();
                            if (list != null && !list.isEmpty()) {
                                try {
                                    PortaApplicativa paFound = this.porteApplicativeCore.getPortaApplicativa(list.get(0));
                                    MappingErogazionePortaApplicativa mappingPA = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(paFound);
                                    labelErogazione = this.getLabelIdServizio(mappingPA.getIdServizio());
                                    if (!mappingPA.isDefault()) {
                                        labelErogazione = (String)labelErogazione + " (gruppo:" + mappingPA.getDescrizione() + ")";
                                    }
                                }
                                catch (Throwable t) {
                                    this.logError("Errore durante l'identificazione dell'erogazione: " + t.getMessage(), t);
                                }
                            }
                            this.pd.setMessage("L'erogazione " + (String)labelErogazione + " possiede gi\u00e0 l'utente (http-basic) indicato per il servizio 'Servizio IntegrationManager/MessageBox'");
                        }
                        return false;
                    }
                }
                if (!(tipoauth.equals(CostantiConfigurazione.CREDENZIALE_BASIC.toString()) || tipoauth.equals(CostantiConfigurazione.CREDENZIALE_SSL.toString()) || tipoauth.equals("nessuna"))) {
                    this.pd.setMessage("Tipo Autenticazione dev'essere " + CostantiConfigurazione.CREDENZIALE_BASIC.toString() + ", " + CostantiConfigurazione.CREDENZIALE_SSL.toString() + " o nessuna");
                    return false;
                }
                if (!sbustamento.equals(CostantiConfigurazione.ABILITATO.toString()) && !sbustamento.equals(CostantiConfigurazione.DISABILITATO.toString())) {
                    this.pd.setMessage("Sbustamento SOAP dev'essere " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                    return false;
                }
                if (!sbustamentoInformazioniProtocolloRichiesta.equals(CostantiConfigurazione.ABILITATO.toString()) && !sbustamentoInformazioniProtocolloRichiesta.equals(CostantiConfigurazione.DISABILITATO.toString())) {
                    this.pd.setMessage("Sbustamento Informazioni del Protocollo dev'essere " + CostantiConfigurazione.ABILITATO + " o " + CostantiConfigurazione.DISABILITATO);
                    return false;
                }
            }
            return this.endPointCheckData(null, protocollo, true, listExtendedConnettore);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<DataElement> addServizioApplicativoToDati(List<DataElement> dati, String oldNomeSA, String nome, String descrizione, String tipoENomeSoggetto, String fault, TipoOperazione tipoOperazione, long idSA, Boolean contaListe, String[] soggettiList, String[] soggettiListLabel, String provider, String dominio, String utente, String password, String subject, String principal, String tipoauth, String faultactor, String genericfault, String prefixfault, String invrif, String sbustamentoInformazioniProtocolloRisposta, String servlet, String id, String nomeProtocollo, String ruoloFruitore, String ruoloErogatore, String sbustamento, String sbustamentoInformazioniProtocolloRichiesta, String getmsg, String invrifRichiesta, String risprif, String endpointtype, String autenticazioneHttp, String url, String nomeCodaJMS, String tipoCodaJMS, String userRichiesta, String passwordRichiesta, String initcont, String urlpgk, String provurl, String connfact, String sendas, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String tipoconn, String connettoreDebug, Boolean isConnettoreCustomUltimaImmagineSalvata, String proxyEnabled, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, String tipoProtocollo, List<String> listaTipiProtocollo, List<ExtendedConnettore> listExtendedConnettore, String tipoCredenzialiSSLSorgente, ArchiveType tipoCredenzialiSSLTipoArchivio, BinaryParameter tipoCredenzialiSSLFileCertificato, String tipoCredenzialiSSLFileCertificatoPassword, List<String> listaAliasEstrattiCertificato, String tipoCredenzialiSSLAliasCertificato, String tipoCredenzialiSSLAliasCertificatoSubject, String tipoCredenzialiSSLAliasCertificatoIssuer, String tipoCredenzialiSSLAliasCertificatoType, String tipoCredenzialiSSLAliasCertificatoVersion, String tipoCredenzialiSSLAliasCertificatoSerialNumber, String tipoCredenzialiSSLAliasCertificatoSelfSigned, String tipoCredenzialiSSLAliasCertificatoNotBefore, String tipoCredenzialiSSLAliasCertificatoNotAfter, String tipoCredenzialiSSLVerificaTuttiICampi, String tipoCredenzialiSSLConfigurazioneManualeSelfSigned, String issuer, String tipoCredenzialiSSLStatoElaborazioneCertificato, String changepwd, String multipleApiKey, String appId, String apiKey, boolean autenticazioneToken, String tokenPolicy, String tipoSA, boolean useAsClient, boolean integrationManagerEnabled, boolean visualizzaModificaCertificato, boolean visualizzaAddCertificato, String servletCredenzialiList, List<Parameter> parametersServletCredenzialiList, Integer numeroCertificati, String servletCredenzialiAdd, String tokenPolicySA, String tokenClientIdSA, boolean tokenWithHttpsEnabledByConfigSA, String autenticazioneApiKey, boolean useOAS3Names, boolean useAppId, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams) throws Exception {
        boolean faultChoice;
        Parameter pDominio;
        DataElement de;
        if (oldNomeSA == null || invrifRichiesta != null) {
            // empty if block
        }
        ServizioApplicativo sa = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            sa = this.saCore.getServizioApplicativo(idSA);
            if (sa == null) {
                throw new ControlStationCoreException("Servizi applicativo con id '" + idSA + "' non trovato");
            }
            IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
            idServizioApplicativo.setNome(sa.getNome());
            idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            String labelApplicativo = this.isSoggettoMultitenantSelezionato() ? sa.getNome() : this.getLabelServizioApplicativoConDominioSoggetto(idServizioApplicativo);
            Parameter pSAId = new Parameter("id", "" + sa.getId());
            Parameter pSAIdSoggetto = new Parameter("provider", "" + sa.getIdSoggetto());
            Parameter pDominio2 = new Parameter("dominio", dominio);
            ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
            listaParametriChange.add(pSAId);
            listaParametriChange.add(pSAIdSoggetto);
            listaParametriChange.add(pDominio2);
            this.addComandoInUsoButton(labelApplicativo, "" + idSA, InUsoType.SERVIZIO_APPLICATIVO);
            if (this.core.isApplicativiVerificaCertificati()) {
                boolean ssl = false;
                InvocazionePorta ip = sa.getInvocazionePorta();
                for (int i = 0; i < ip.sizeCredenzialiList(); ++i) {
                    Credenziali c = ip.getCredenziali(i);
                    if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) continue;
                    ssl = true;
                }
                boolean modi = this.core.isProfiloModIPA(tipoProtocollo);
                boolean sicurezzaMessaggioModi = false;
                boolean server = "server".equals(sa.getTipo());
                if (modi) {
                    KeystoreParams keystoreParams = ModIUtils.getApplicativoKeystoreParams((List)sa.getProtocolPropertyList());
                    boolean bl = sicurezzaMessaggioModi = keystoreParams != null;
                }
                if (ssl || sicurezzaMessaggioModi || server) {
                    this.pd.addComandoVerificaCertificatiElementoButton("serviziApplicativiVerificaCertificati.do", listaParametriChange);
                }
            }
            if ("server".equals(sa.getTipo())) {
                ArrayList<Parameter> listaParametriVerificaConnettivitaChange = new ArrayList<Parameter>();
                listaParametriVerificaConnettivitaChange.addAll(listaParametriChange);
                listaParametriVerificaConnettivitaChange.add(new Parameter("tokenVerConn", "true"));
                this.pd.addComandoVerificaConnettivitaElementoButton("serviziApplicativiVerificaCertificati.do", listaParametriVerificaConnettivitaChange);
            }
            if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                listaParametriChange.add(new Parameter("rmElFromCache", "true"));
                this.pd.addComandoResetCacheElementoButton("serviziApplicativiChange.do", listaParametriChange);
            }
            if (sa != null && this.existsProprietaOggetto(sa.getProprietaOggetto(), sa.getDescrizione())) {
                this.addComandoProprietaOggettoButton(labelApplicativo, "" + idSA, InUsoType.SERVIZIO_APPLICATIVO);
            }
        }
        if (ruoloFruitore == null) {
            ruoloFruitore = TipologiaFruizione.DISABILITATO.getValue();
        }
        if (ruoloErogatore == null) {
            ruoloErogatore = TipologiaErogazione.DISABILITATO.getValue();
        }
        boolean multitenant = this.saCore.isMultitenant();
        boolean configurazioneStandardNonApplicabile = false;
        Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
        if (parentSA == null) {
            parentSA = 0;
        }
        Boolean useIdSoggObject = parentSA == 1;
        boolean useIdSogg = false;
        if (useIdSoggObject != null) {
            useIdSogg = useIdSoggObject;
        }
        IProtocolFactory p = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
        IProtocolConfiguration config = p.createProtocolConfiguration();
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        de = new DataElement();
        if (this.isModalitaCompleta()) {
            de.setLabel("Servizio Applicativo");
        } else {
            de.setLabel("Applicativo");
        }
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (!useIdSogg) {
            boolean showProtocolli;
            de = new DataElement();
            de.setLabel("Profilo Interoperabilit\u00e0");
            boolean bl = showProtocolli = TipoOperazione.CHANGE.equals((Object)tipoOperazione) && this.core.countProtocolli(this.request, this.session) > 1;
            if (listaTipiProtocollo != null && listaTipiProtocollo.size() > 1 || showProtocolli) {
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                    DataElement deLABEL = new DataElement();
                    deLABEL.setLabel("Profilo Interoperabilit\u00e0");
                    deLABEL.setType(DataElementType.TEXT);
                    deLABEL.setName("protocollo__label");
                    deLABEL.setValue(this.getLabelProtocollo(tipoProtocollo));
                    dati.add(deLABEL);
                    de.setValue(tipoProtocollo);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("protocollo");
                } else {
                    de.setLabel("Profilo Interoperabilit\u00e0");
                    de.setValues(listaTipiProtocollo);
                    de.setLabels(this.getLabelsProtocolli(listaTipiProtocollo));
                    de.setSelected(tipoProtocollo);
                    de.setType(DataElementType.SELECT);
                    de.setName("protocollo");
                    de.setPostBack(true);
                }
            } else {
                de.setValue(tipoProtocollo);
                de.setType(DataElementType.HIDDEN);
                de.setName("protocollo");
            }
            de.setSize(this.getSize());
            dati.add(de);
        }
        boolean dominioEsterno = false;
        boolean isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(nomeProtocollo);
        if (isSupportatoAutenticazioneApplicativiEsterni) {
            de = new DataElement();
            de.setLabel("Dominio");
            de.setName("dominio");
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(dominio);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.TEXT);
                de.setLabel("Dominio");
                de.setName("dominio__label");
                String valueDom = dominio;
                String[] sdValues = SoggettiCostanti.getSoggettiDominiValue();
                String[] sdLabels = SoggettiCostanti.getSoggettiDominiLabel();
                for (int i = 0; i < sdValues.length; ++i) {
                    if (!sdValues[i].equals(dominio)) continue;
                    valueDom = sdLabels[i];
                    break;
                }
                de.setValue(valueDom);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(SoggettiCostanti.getSoggettiDominiValue());
                de.setLabels(SoggettiCostanti.getSoggettiDominiLabel());
                de.setSelected(dominio);
                de.setPostBack(true);
            }
            dominioEsterno = SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE.equals(dominio);
            dati.add(de);
        }
        String oldtipoauth = null;
        String nomePdd = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            Soggetto soggetto;
            if (sa == null) {
                sa = this.saCore.getServizioApplicativo(idSA);
            }
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            if (this.core.isRegistroServiziLocale()) {
                soggetto = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto());
                tipoSoggetto = soggetto.getTipo();
                nomeSoggetto = soggetto.getNome();
                nomePdd = soggetto.getPortaDominio();
            } else {
                soggetto = this.soggettiCore.getSoggetto(sa.getIdSoggetto());
                tipoSoggetto = soggetto.getTipo();
                nomeSoggetto = soggetto.getNome();
            }
            if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                CredenzialeTipo tipo = sa.getInvocazionePorta().getCredenziali(0).getTipo();
                oldtipoauth = tipo != null ? tipo.getValue() : "nessuna";
            }
            de = new DataElement();
            if (multitenant && !this.isSoggettoMultitenantSelezionato()) {
                de.setType(DataElementType.TEXT);
            } else if (isSupportatoAutenticazioneApplicativiEsterni) {
                de.setType(DataElementType.TEXT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setLabel("Soggetto");
            de.setValue(tipoENomeSoggetto);
            dati.add(de);
            if (this.isModalitaCompleta()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setValue("Visualizza Dati Soggetto");
                de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + sa.getIdSoggetto()), new Parameter("tipoprov", tipoSoggetto), new Parameter("nomeprov", nomeSoggetto)});
                dati.add(de);
            }
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("provider");
            de.setValue(provider);
            dati.add(de);
        } else {
            de = new DataElement();
            de.setLabel("Soggetto");
            de.setName("provider");
            if (!useIdSogg) {
                boolean visualizzaSoggetto = isSupportatoAutenticazioneApplicativiEsterni;
                if (visualizzaSoggetto && !dominioEsterno) {
                    boolean bl = visualizzaSoggetto = soggettiList != null && soggettiList.length > 1;
                }
                if (multitenant && !this.isSoggettoMultitenantSelezionato() || visualizzaSoggetto) {
                    de.setType(DataElementType.SELECT);
                    de.setPostBack(true);
                    de.setValues(soggettiList);
                    de.setLabels(soggettiListLabel);
                    if (provider != null && !provider.equals("")) {
                        de.setSelected(provider);
                    }
                } else {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(provider);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(provider);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Soggetto");
                org.openspcoop2.core.config.Soggetto sog = this.soggettiCore.getSoggetto(Integer.parseInt(provider));
                de.setType(DataElementType.TEXT);
                de.setValue(this.getLabelNomeSoggetto(tipoProtocollo, sog.getTipo(), sog.getNome()));
                de.setSize(this.getSize());
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setSize(this.getSize());
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setName("nome");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("descr");
        de.setSize(this.getSize());
        dati.add(de);
        boolean applicativiServerEnabled = this.saCore.isApplicativiServerEnabled(this);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setName("tipoSA");
        de.setSize(this.getSize());
        boolean applicativoServerSelezionabile = true;
        if (isSupportatoAutenticazioneApplicativiEsterni && PddTipologia.ESTERNO.toString().equals(dominio)) {
            applicativoServerSelezionabile = false;
            tipoSA = "client";
        }
        if (applicativiServerEnabled) {
            if (tipoOperazione.equals((Object)TipoOperazione.ADD) && applicativoServerSelezionabile) {
                de.setSelected(tipoSA);
                de.setType(DataElementType.SELECT);
                de.setLabels(ServiziApplicativiCostanti.getLabelsServiziApplicativiTipo());
                de.setValues(ServiziApplicativiCostanti.getValuesServiziApplicativiTipo());
                de.setPostBack(true);
            } else {
                de.setValue(tipoSA);
                de.setType(DataElementType.HIDDEN);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Tipo");
                de.setName("tipoSA__label");
                de.setType(DataElementType.TEXT);
                de.setValue(this.getTipo(tipoSA, applicativiServerEnabled && useAsClient));
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tipoSA);
        }
        dati.add(de);
        if (!this.isModalitaCompleta()) {
            de = new DataElement();
            de.setLabel("Tipologia");
            de.setName("ruoloSA");
            de.setType(DataElementType.HIDDEN);
            if (!TipologiaFruizione.DISABILITATO.equals(ruoloFruitore) && !TipologiaErogazione.DISABILITATO.equals(ruoloErogatore)) {
                if (!applicativiServerEnabled) {
                    de.setLabel(null);
                    de.setValue("Configurazione non visualizzabile");
                    de.setType(DataElementType.TEXT);
                    de.setPostBack(false);
                    configurazioneStandardNonApplicabile = true;
                }
            } else if (!TipologiaFruizione.DISABILITATO.equals(ruoloFruitore)) {
                de.setValue("Fruitore");
                if (!applicativiServerEnabled) {
                    if (tipoauth == null || tipoauth.equals("nessuna")) {
                        tipoauth = this.saCore.getAutenticazione_generazioneAutomaticaPorteDelegate();
                    }
                } else if ("client".equals(tipoSA) && (tipoauth == null || tipoauth.equals("nessuna"))) {
                    tipoauth = this.saCore.getAutenticazione_generazioneAutomaticaPorteDelegate();
                }
            } else if (!TipologiaErogazione.DISABILITATO.equals(ruoloErogatore)) {
                de.setValue("Erogatore");
                if ((endpointtype == null || TipiConnettore.DISABILITATO.getNome().equals(endpointtype)) && (getmsg == null || CostantiConfigurazione.DISABILITATO.equals(getmsg))) {
                    this.pd.setMessage("Abilitare il servizio di IntegrationManager prima di disabilitare il connettore");
                    endpointtype = TipiConnettore.HTTP.getNome();
                }
            } else {
                de.setValue("Fruitore");
                ruoloFruitore = TipologiaFruizione.NORMALE.getValue();
                if ((tipoauth == null || tipoauth.equals("nessuna")) && (tipoauth = this.saCore.getAutenticazione_generazioneAutomaticaPorteDelegate()).equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL) && StringUtils.isNotEmpty((String)tipoCredenzialiSSLStatoElaborazioneCertificato) && (tipoCredenzialiSSLStatoElaborazioneCertificato.equals("1") || tipoCredenzialiSSLStatoElaborazioneCertificato.equals("5") || tipoCredenzialiSSLStatoElaborazioneCertificato.equals("2")) && tipoCredenzialiSSLSorgente.equals("uploadCert")) {
                    this.pd.setLabelBottoneInvia("Carica Certificato");
                }
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
        }
        if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            ArrayList<Parameter> parametersServletSAChange = new ArrayList<Parameter>();
            Parameter pIdSA = new Parameter("id", "" + sa.getId());
            parametersServletSAChange.add(pIdSA);
            int idProv = sa.getIdSoggetto().intValue();
            Parameter pIdSoggettoSA = new Parameter("provider", "" + idProv);
            parametersServletSAChange.add(pIdSoggettoSA);
            if (dominio != null) {
                pDominio = new Parameter("dominio", dominio);
                parametersServletSAChange.add(pDominio);
            }
            de.setUrl("serviziApplicativiProprietaList.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()]));
            if (contaListe.booleanValue()) {
                de.setValue("Propriet&agrave;(" + sa.sizeProprietaList() + ")");
            } else {
                de.setValue("Propriet&agrave;");
            }
            dati.add(de);
        }
        boolean showLinkInvocazioneServizio = false;
        boolean showLinkRispostaAsincrona = false;
        boolean supportAsincroni = false;
        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
            if (this.isModalitaCompleta() && !this.pddCore.isPddEsterna(nomePdd)) {
                showLinkInvocazioneServizio = true;
                showLinkRispostaAsincrona = true;
            } else if (!this.pddCore.isPddEsterna(nomePdd)) {
                ServiceBinding serviceBinding;
                List<ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(nomeProtocollo);
                pDominio = serviceBindingListProtocollo.iterator();
                while (pDominio.hasNext() && !(supportAsincroni = this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(nomeProtocollo, serviceBinding = pDominio.next(), ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) || this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(nomeProtocollo, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO))) {
                }
            }
        }
        if (supportAsincroni) {
            boolean attualeConnettoreDisabilitato;
            RispostaAsincrona rispAsin = sa.getRispostaAsincrona();
            Connettore connettoreRis = rispAsin != null ? rispAsin.getConnettore() : null;
            StatoFunzionalita getMSGRisp = rispAsin != null ? rispAsin.getGetMessage() : null;
            boolean bl = attualeConnettoreDisabilitato = (connettoreRis == null || TipiConnettore.DISABILITATO.getNome().equals(connettoreRis.getTipo())) && CostantiConfigurazione.DISABILITATO.equals((Object)getMSGRisp);
            if (!attualeConnettoreDisabilitato || !this.isModalitaStandard()) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setLabel("Risposta Asincrona");
                if (this.pddCore.isPddEsterna(nomePdd)) {
                    de.setType(DataElementType.TEXT);
                    de.setValue("(non presente)");
                } else {
                    if (attualeConnettoreDisabilitato) {
                        de.setValue("Risposta Asincrona (disabilitato)");
                    } else {
                        de.setValue("Risposta Asincrona (visualizza)");
                    }
                    de.setUrl("serviziApplicativiEndPointRispostaAsincrona.do", new Parameter[]{new Parameter("provider", "" + sa.getIdSoggetto()), new Parameter("nomeservizioApplicativo", sa.getNome()), new Parameter("idsil", "" + sa.getId())});
                }
                dati.add(de);
            }
        }
        boolean showFruitore = false;
        boolean showErogatore = false;
        boolean connettoreErogatoreForceEnabled = false;
        if (applicativiServerEnabled) {
            showFruitore = "client".equals(tipoSA);
            showErogatore = "server".equals(tipoSA);
            if (getmsg != null && CostantiConfigurazione.ABILITATO.toString().equals(getmsg)) {
                connettoreErogatoreForceEnabled = false;
            } else {
                connettoreErogatoreForceEnabled = true;
                if (TipiConnettore.DISABILITATO.getNome().equals(endpointtype)) {
                    endpointtype = TipiConnettore.HTTP.getNome();
                }
            }
        } else {
            showFruitore = !TipologiaFruizione.DISABILITATO.equals(ruoloFruitore);
            showErogatore = this.isModalitaStandard() && !TipologiaErogazione.DISABILITATO.equals(ruoloErogatore);
        }
        boolean postBackViaPost = false;
        if (showErogatore) {
            postBackViaPost = true;
        }
        if (this.isModalitaCompleta() || showFruitore) {
            boolean dominioEsternoProfiloModIPA;
            if (utente == null) {
                utente = "";
            }
            if (password == null) {
                password = "";
            }
            if (subject == null) {
                subject = "";
            }
            if (principal == null) {
                principal = "";
            }
            boolean showLabelCredenzialiAccesso = true;
            boolean visualizzaTipoAutenticazione = true;
            String titleConfigSslCredenziali = null;
            String subtitleConfigSslCredenziali = null;
            boolean bl = dominioEsternoProfiloModIPA = dominioEsterno && this.isProfiloModIPA(nomeProtocollo);
            if (dominioEsternoProfiloModIPA) {
                String label;
                visualizzaTipoAutenticazione = false;
                boolean trovato = false;
                for (String tipoAuthModIEsterno : ConnettoriCostanti.CREDENZIALI_MODI_ESTERNO_VALUES) {
                    if (!tipoAuthModIEsterno.equals(tipoauth)) continue;
                    trovato = true;
                }
                if (!trovato && !ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoauth)) {
                    tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
                }
                if ((label = "ModI") != null && !"".equals(label)) {
                    showLabelCredenzialiAccesso = false;
                    titleConfigSslCredenziali = label;
                }
                subtitleConfigSslCredenziali = "Sicurezza Messaggio";
            }
            if (!dominioEsternoProfiloModIPA) {
                dati = this.addCredenzialiToDati(tipoOperazione, dati, tipoauth, oldtipoauth, utente, password, subject, principal, servlet, showLabelCredenzialiAccesso, null, false, visualizzaTipoAutenticazione, null, true, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, subtitleConfigSslCredenziali, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, true, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, dominioEsterno, tipoProtocollo, postBackViaPost);
            }
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                de = new DataElement();
                de.setLabel("Ruoli");
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                if (useIdSogg) {
                    de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())});
                } else if (this.isModalitaCompleta()) {
                    de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId())});
                } else {
                    de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("accessoDaChange", "yes")});
                }
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.saCore.servizioApplicativoRuoliList(sa.getId(), (ISearch)searchForCount);
                    int numRuoli = searchForCount.getNumEntries(Liste.SERVIZIO_APPLICATIVO_RUOLI);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numRuoli));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
                dati.add(de);
            }
            if (dominioEsternoProfiloModIPA) {
                if (!showLabelCredenzialiAccesso) {
                    de = new DataElement();
                    de.setLabel(titleConfigSslCredenziali);
                    de.setType(DataElementType.TITLE);
                    dati.add(de);
                }
                dati = this.addCredenzialiToDati(tipoOperazione, dati, tipoauth, oldtipoauth, utente, password, subject, principal, servlet, showLabelCredenzialiAccesso, null, false, visualizzaTipoAutenticazione, null, true, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, subtitleConfigSslCredenziali, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, true, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, dominioEsterno, tipoProtocollo, postBackViaPost);
            }
        } else if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && applicativiServerEnabled && "server".equals(tipoSA) && useAsClient) {
            de = new DataElement();
            de.setLabel("Ruoli");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            if (useIdSogg) {
                de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())});
            } else if (this.isModalitaCompleta()) {
                de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId())});
            } else {
                de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("accessoDaChange", "yes")});
            }
            if (contaListe.booleanValue()) {
                ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                this.saCore.servizioApplicativoRuoliList(sa.getId(), (ISearch)searchForCount);
                int numRuoli = searchForCount.getNumEntries(Liste.SERVIZIO_APPLICATIVO_RUOLI);
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numRuoli));
            } else {
                ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
            }
            dati.add(de);
        }
        boolean avanzatoFruitore = this.isModalitaAvanzata() && !TipologiaFruizione.DISABILITATO.equals(ruoloFruitore);
        boolean bl = faultChoice = avanzatoFruitore && config.isSupportoSceltaFault();
        if (faultChoice) {
            de = new DataElement();
            de.setLabel("Errore Applicativo generato della Porta");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        if (TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("Modalit&agrave; di fault");
            de.setName("fault");
            if (faultChoice) {
                de.setType(DataElementType.SELECT);
                de.setValues(ServiziApplicativiCostanti.getServiziApplicativiFault());
                de.setSelected(fault);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(fault);
            }
            dati.add(de);
        } else {
            de = new DataElement();
            de.setLabel("Modalit&agrave; di fault");
            de.setName("fault");
            if (faultChoice) {
                de.setType(DataElementType.SELECT);
                de.setValues(ServiziApplicativiCostanti.getServiziApplicativiFault());
                de.setSelected(fault);
                if (postBackViaPost) {
                    de.setPostBack_viaPOST(true);
                } else {
                    de.setPostBack(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(fault);
            }
            dati.add(de);
            if (fault.equals(ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_FAULT_SOAP)) {
                de = new DataElement();
                de.setLabel("Fault Actor");
                de.setValue(faultactor);
                if (faultChoice) {
                    de.setType(DataElementType.TEXT_EDIT);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setName("faultactor");
                de.setSize(this.getSize());
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Generic Fault Code");
            de.setName("genericfault");
            if (faultChoice) {
                de.setType(DataElementType.SELECT);
                de.setValues(ServiziApplicativiCostanti.getServiziApplicativiFaultGenericCode());
                de.setSelected(genericfault);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(genericfault);
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Prefix Fault Code");
            de.setValue(prefixfault);
            if (faultChoice) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("prefixfault");
            de.setSize(this.getSize());
            dati.add(de);
        }
        if (this.isModalitaCompleta() && !TipoOperazione.ADD.equals((Object)tipoOperazione) || avanzatoFruitore && config.isSupportoSbustamentoProtocollo()) {
            de = new DataElement();
            de.setLabel("Trattamento Messaggio");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("sbustamentoInformazioniProtocolloRisposta");
        de.setLabel(ServiziApplicativiCostanti.getLabelSbustamentoProtocollo(nomeProtocollo));
        if (avanzatoFruitore && config.isSupportoSbustamentoProtocollo()) {
            de.setType(DataElementType.SELECT);
            de.setValues(ServiziApplicativiCostanti.getServiziApplicativiSbustamentoProtocollo());
            de.setSelected(sbustamentoInformazioniProtocolloRisposta);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(sbustamentoInformazioniProtocolloRisposta);
        }
        dati.add(de);
        if (!this.isModalitaCompleta()) {
            de = new DataElement();
            de.setLabel("Invio per Riferimento");
            de.setType(DataElementType.HIDDEN);
            de.setName("invrifRisposta");
            de.setValue(invrif == null || "".equals(invrif) ? CostantiConfigurazione.DISABILITATO.toString() : invrif);
            dati.add(de);
        } else if (!TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            de = new DataElement();
            de.setLabel("Invio per Riferimento");
            de.setType(DataElementType.SELECT);
            de.setName("invrifRisposta");
            de.setValues(ServiziApplicativiCostanti.getServiziApplicativiInvioPerRiferimento());
            de.setSelected(invrif);
            dati.add(de);
        } else {
            de = new DataElement();
            de.setLabel("Invio per Riferimento");
            de.setType(DataElementType.HIDDEN);
            de.setName("invrifRisposta");
            de.setValue(invrif == null || "".equals(invrif) ? ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_INVIO_PER_RIFERIMENTO_DISABILITATO : invrif);
            dati.add(de);
        }
        if (showLinkInvocazioneServizio || showLinkRispostaAsincrona) {
            de = new DataElement();
            de.setLabel("Informazioni di Integrazione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            if (showLinkInvocazioneServizio) {
                InvocazioneServizio invServ = sa.getInvocazioneServizio();
                Connettore connettoreInv = invServ != null ? invServ.getConnettore() : null;
                StatoFunzionalita getMSGInv = invServ != null ? invServ.getGetMessage() : null;
                de = new DataElement();
                de.setLabel("Invocazione Servizio");
                de.setType(DataElementType.LINK);
                if (this.pddCore.isPddEsterna(nomePdd)) {
                    de.setType(DataElementType.TEXT);
                    de.setValue("(non presente)");
                } else {
                    if ((connettoreInv == null || TipiConnettore.DISABILITATO.getNome().equals(connettoreInv.getTipo())) && CostantiConfigurazione.DISABILITATO.equals((Object)getMSGInv)) {
                        de.setValue("Invocazione Servizio (disabilitato)");
                    } else {
                        de.setValue("Invocazione Servizio (visualizza)");
                    }
                    de.setUrl("serviziApplicativiEndPointInvocazioneServizio.do", new Parameter[]{new Parameter("provider", "" + sa.getIdSoggetto()), new Parameter("nomeservizioApplicativo", sa.getNome()), new Parameter("idsil", "" + sa.getId())});
                }
                dati.add(de);
            }
            if (showLinkRispostaAsincrona) {
                RispostaAsincrona rispAsin = sa.getRispostaAsincrona();
                Connettore connettoreRis = rispAsin != null ? rispAsin.getConnettore() : null;
                StatoFunzionalita getMSGRisp = rispAsin != null ? rispAsin.getGetMessage() : null;
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setLabel("Risposta Asincrona");
                if (this.pddCore.isPddEsterna(nomePdd)) {
                    de.setType(DataElementType.TEXT);
                    de.setValue("(non presente)");
                } else {
                    if ((connettoreRis == null || TipiConnettore.DISABILITATO.getNome().equals(connettoreRis.getTipo())) && CostantiConfigurazione.DISABILITATO.equals((Object)getMSGRisp)) {
                        de.setValue("Risposta Asincrona (disabilitato)");
                    } else {
                        de.setValue("Risposta Asincrona (visualizza)");
                    }
                    de.setUrl("serviziApplicativiEndPointRispostaAsincrona.do", new Parameter[]{new Parameter("provider", "" + sa.getIdSoggetto()), new Parameter("nomeservizioApplicativo", sa.getNome()), new Parameter("idsil", "" + sa.getId())});
                }
                dati.add(de);
            }
        }
        if (showErogatore) {
            boolean servizioApplicativoServerEnabled = false;
            if (utente == null) {
                utente = "";
            }
            if (password == null) {
                password = "";
            }
            this.addEndPointToDati(dati, id, nome, sbustamento, sbustamentoInformazioniProtocolloRichiesta, getmsg, utente, password, true, invrif, risprif, nomeProtocollo, false, true, true, parentSA, null, null, servizioApplicativoServerEnabled, tipoSA, useAsClient, integrationManagerEnabled, tipoOperazione, tipoCredenzialiSSLVerificaTuttiICampi, changepwd, postBackViaPost);
            if (!applicativiServerEnabled && TipologiaFruizione.DISABILITATO.equals(ruoloFruitore) && CostantiConfigurazione.ABILITATO.equals(getmsg)) {
                if (tipoauth == null || tipoauth.equals("nessuna")) {
                    tipoauth = this.saCore.getAutenticazione_generazioneAutomaticaPorteDelegate();
                }
                if (subject == null) {
                    subject = "";
                }
                if (principal == null) {
                    principal = "";
                }
                dati = this.addCredenzialiToDati(tipoOperazione, dati, tipoauth, oldtipoauth, utente, password, subject, principal, servlet, true, null, false, true, null, true, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, true, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, dominioEsterno, tipoProtocollo, postBackViaPost);
            }
            dati = this.addEndPointToDati(dati, null, connettoreDebug, endpointtype, autenticazioneHttp, "", url, nomeCodaJMS, tipoCodaJMS, userRichiesta, passwordRichiesta, initcont, urlpgk, provurl, connfact, sendas, "serviziApplicativi", TipoOperazione.CHANGE, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, "serviziApplicativiEndPointInvocazioneServizio.do", nome, id, null, null, null, null, null, null, true, isConnettoreCustomUltimaImmagineSalvata, proxyEnabled, proxyHost, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, false, false, listExtendedConnettore, connettoreErogatoreForceEnabled, nomeProtocollo, false, false, false, servizioApplicativoServerEnabled, null, null, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, postBackViaPost);
        }
        if (configurazioneStandardNonApplicabile) {
            this.pd.setMessage("Attenzione: Configurazione non standard (Utilizzare l'interfaccia avanzata)", Costanti.MESSAGE_TYPE_INFO);
            this.pd.disableEditMode();
            for (int i = 0; i < dati.size(); ++i) {
                DataElement deCheck = dati.get(i);
                if (!"saServerEnabled".equals(deCheck.getName())) continue;
                dati.remove(i);
                break;
            }
        }
        return dati;
    }

    public boolean servizioApplicativoCheckData(TipoOperazione tipoOperazione, String[] soggettiList, long idProvOld, String ruoloFruitoreParam, String ruoloErogatore, List<ExtendedConnettore> listExtendedConnettore, ServizioApplicativo saOld, StringBuilder sbWarningChange) throws Exception {
        try {
            boolean isOk;
            boolean validaEndPoint;
            String labelSoggetto;
            Soggetto tmpSoggettoProprietarioSa;
            String portaDominio4;
            boolean tokenModiPDNDOauth;
            boolean tokenWithHttpsEnabledByConfigSA;
            boolean encryptEnabled;
            boolean dominioEsternoModI;
            Soggetto mySogg;
            if (ruoloFruitoreParam != null) {
                // empty if block
            }
            String tipoSA = this.getParameter("tipoSA");
            boolean isApplicativiServerEnabled = this.saCore.isApplicativiServerEnabled(this);
            boolean useAsClient = false;
            if (isApplicativiServerEnabled && tipoSA.equals("server")) {
                String tmp = this.getParameter("useAsClient");
                useAsClient = ServletUtils.isCheckBoxEnabled((String)tmp);
            }
            if (ruoloErogatore == null) {
                ruoloErogatore = TipologiaErogazione.DISABILITATO.getValue();
            }
            String nome = this.getParameter("nome");
            String provider = this.getParameter("provider");
            String descrizione = this.getParameter("descr");
            int newProv = 0;
            if (provider == null) {
                provider = "";
            } else {
                newProv = Integer.parseInt(provider);
            }
            String fault = this.getParameter("fault");
            if (nome.equals("") || tipoOperazione.equals((Object)TipoOperazione.ADD) && provider.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (tipoOperazione.equals((Object)TipoOperazione.ADD) && provider.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Soggetto" : (String)tmpElenco + ", Soggetto";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + (String)tmpElenco);
                return false;
            }
            if (descrizione != null && StringUtils.isNotEmpty((String)descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (nome.indexOf(" ") != -1 || nome.indexOf(34) != -1) {
                this.pd.setMessage("Non inserire spazi o doppi apici nei campi di testo");
                return false;
            }
            if (!this.checkIntegrationEntityName(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!fault.equals(ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_FAULT_SOAP) && !fault.equals(ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_FAULT_XML)) {
                this.pd.setMessage("Modalit&agrave; di fault dev'essere " + ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_FAULT_SOAP + " o " + ServiziApplicativiCostanti.SERVIZI_APPLICATIVI_FAULT_XML);
                return false;
            }
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                boolean trovatoProv = false;
                if (soggettiList != null) {
                    for (int i = 0; i < soggettiList.length; ++i) {
                        String tmpSogg = soggettiList[i];
                        if (!tmpSogg.equals(provider)) continue;
                        trovatoProv = true;
                    }
                }
                if (!trovatoProv) {
                    this.pd.setMessage("Il soggetto dev'essere scelto tra quelli definiti nel pannello Soggetti");
                    return false;
                }
            }
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && isApplicativiServerEnabled && "server".equals(tipoSA) && !useAsClient && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().getRuoli() != null && saOld.getInvocazionePorta().getRuoli().sizeRuoloList() > 0) {
                this.pd.setMessage("Prima di disabilitare l'opzione 'Utilizzabile come Client' devono essere rimossi i ruoli assegnati all'applicativo");
                return false;
            }
            IDSoggetto ids = null;
            String portaDominioSoggetto = null;
            if (this.core.isRegistroServiziLocale()) {
                mySogg = this.soggettiCore.getSoggettoRegistro(newProv);
                ids = new IDSoggetto(mySogg.getTipo(), mySogg.getNome());
                portaDominioSoggetto = mySogg.getPortaDominio();
            } else {
                mySogg = this.soggettiCore.getSoggetto(newProv);
                ids = new IDSoggetto(mySogg.getTipo(), mySogg.getNome());
            }
            IDServizioApplicativo idSA = new IDServizioApplicativo();
            idSA.setIdSoggettoProprietario(ids);
            idSA.setNome(nome);
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(idSA.getIdSoggettoProprietario().getTipo());
            boolean bl = dominioEsternoModI = this.isProfiloModIPA(protocollo) && this.pddCore.isPddEsterna(portaDominioSoggetto);
            if (tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = this.saCore.existsServizioApplicativo(idSA);
                if (giaRegistrato) {
                    this.pd.setMessage("Il Servizio Applicativo " + nome + " &egrave; gi&agrave; stato registrato per il soggetto scelto.");
                    return false;
                }
            } else if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                long idSa = 0L;
                boolean giaRegistrato = this.saCore.existsServizioApplicativo(idSA);
                if (giaRegistrato) {
                    ServizioApplicativo sa = this.saCore.getServizioApplicativo(idSA);
                    idSa = sa.getId();
                    if (saOld == null || saOld.getId() != idSa) {
                        this.pd.setMessage("Il Servizio Applicativo " + nome + " &egrave; gi&agrave; stato registrato per il soggetto scelto.");
                        return false;
                    }
                }
            }
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                boolean tokenModiPDNDOauth2;
                String tipoauthAttuale;
                String tipoauth;
                boolean tokenWithHttpsEnabledByConfigSA2;
                String oldTipoAuth = null;
                String oldTokenPolicy = null;
                TipologiaFruizione tipologiaFruizione = null;
                if (saOld != null) {
                    tipologiaFruizione = TipologiaFruizione.toEnumConstant((String)saOld.getTipologiaFruizione());
                }
                if (tipologiaFruizione != null && !TipologiaFruizione.DISABILITATO.equals((Object)tipologiaFruizione) && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().sizeCredenzialiList() > 0) {
                    CredenzialeTipo tipo = saOld.getInvocazionePorta().getCredenziali(0).getTipo();
                    oldTipoAuth = tipo != null ? tipo.getValue() : "nessuna";
                    oldTokenPolicy = saOld.getInvocazionePorta().getCredenziali(0).getTokenPolicy();
                }
                boolean bl2 = tokenWithHttpsEnabledByConfigSA2 = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth = (tipoauthAttuale = this.getParameter("tipoauthCredenziali"))) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth);
                if (tokenWithHttpsEnabledByConfigSA2) {
                    tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
                }
                boolean bl3 = tokenModiPDNDOauth2 = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth);
                if (tokenModiPDNDOauth2) {
                    tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN;
                }
                boolean changeTipoAuth = false;
                if (oldTipoAuth != null && !oldTipoAuth.equals(tipoauth)) {
                    changeTipoAuth = true;
                }
                boolean segnalaWarning = false;
                if (changeTipoAuth && oldTokenPolicy != null) {
                    boolean tokenWithHttsSupportato = false;
                    boolean dominioEsterno = this.pddCore.isPddEsterna(portaDominioSoggetto);
                    if (dominioEsterno && protocollo != null) {
                        ProtocolFactoryManager protocolFactoryManager = ProtocolFactoryManager.getInstance();
                        tokenWithHttsSupportato = protocolFactoryManager.getProtocolFactoryByName(protocollo).createProtocolConfiguration().isSupportatoAutenticazioneApplicativiHttpsConToken();
                    }
                    boolean tokenModIPDND = this.saCore.isPolicyGestioneTokenPDND(oldTokenPolicy);
                    if (tokenWithHttsSupportato) {
                        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(oldTipoAuth)) {
                            oldTipoAuth = tokenModIPDND ? ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND : ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH;
                        } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(oldTipoAuth)) {
                            oldTipoAuth = tokenModIPDND ? ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND : ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH;
                        }
                    }
                    if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(oldTipoAuth) && ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauthAttuale)) {
                        changeTipoAuth = false;
                    } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(oldTipoAuth) && ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauthAttuale)) {
                        segnalaWarning = true;
                    } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(oldTipoAuth) && ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauthAttuale)) {
                        changeTipoAuth = false;
                    } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(oldTipoAuth) && ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauthAttuale)) {
                        segnalaWarning = true;
                    }
                }
                if (changeTipoAuth) {
                    String msg;
                    StringBuilder sbWarningDetails = new StringBuilder();
                    FiltroRicercaPorteDelegate filtro = new FiltroRicercaPorteDelegate();
                    filtro.setTipoSoggetto(idSA.getIdSoggettoProprietario().getTipo());
                    filtro.setNomeSoggetto(idSA.getIdSoggettoProprietario().getNome());
                    filtro.setNomeServizioApplicativo(idSA.getNome());
                    List<IDPortaDelegata> list = this.porteDelegateCore.getAllIdPorteDelegate(filtro);
                    if (list != null && list.size() > 0) {
                        String msg2 = "l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione trasporto) di " + list.size() + " fruizion" + (list.size() > 1 ? "i" : "e");
                        if (segnalaWarning) {
                            if (sbWarningDetails.length() > 0) {
                                sbWarningDetails.append("<br/>");
                            }
                            sbWarningDetails.append("- " + msg2);
                        } else {
                            this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; " + msg2);
                            return false;
                        }
                    }
                    String tipoTrasporto = "trasporto";
                    if (this.isProfiloModIPA(protocollo)) {
                        tipoTrasporto = "messaggio";
                    }
                    FiltroRicercaPorteApplicative filtroPA = new FiltroRicercaPorteApplicative();
                    IDServizioApplicativo idServizioApplicativoAutorizzato = new IDServizioApplicativo();
                    idServizioApplicativoAutorizzato.setIdSoggettoProprietario(new IDSoggetto(idSA.getIdSoggettoProprietario().getTipo(), idSA.getIdSoggettoProprietario().getNome()));
                    idServizioApplicativoAutorizzato.setNome(idSA.getNome());
                    filtroPA.setIdServizioApplicativoAutorizzato(idServizioApplicativoAutorizzato);
                    List<IDPortaApplicativa> listPA = this.porteApplicativeCore.getAllIdPorteApplicative(filtroPA);
                    if (listPA != null && listPA.size() > 0) {
                        msg = "l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione " + tipoTrasporto + ") di " + listPA.size() + " erogazion" + (listPA.size() > 1 ? "i" : "e");
                        if (segnalaWarning) {
                            if (sbWarningDetails.length() > 0) {
                                sbWarningDetails.append("<br/>");
                            }
                            sbWarningDetails.append("- " + msg);
                        } else {
                            this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; " + msg);
                            return false;
                        }
                    }
                    filtro = new FiltroRicercaPorteDelegate();
                    filtro.setTipoSoggetto(idSA.getIdSoggettoProprietario().getTipo());
                    filtro.setNomeSoggetto(idSA.getIdSoggettoProprietario().getNome());
                    filtro.setNomeServizioApplicativoToken(idSA.getNome());
                    list = this.porteDelegateCore.getAllIdPorteDelegate(filtro);
                    if (list != null && !list.isEmpty()) {
                        msg = "l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione token) di " + list.size() + " fruizion" + (list.size() > 1 ? "i" : "e");
                        if (segnalaWarning) {
                            if (sbWarningDetails.length() > 0) {
                                sbWarningDetails.append("<br/>");
                            }
                            sbWarningDetails.append("- " + msg);
                        } else {
                            this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; " + msg);
                            return false;
                        }
                    }
                    filtroPA = new FiltroRicercaPorteApplicative();
                    filtroPA.setIdServizioApplicativoAutorizzatoToken(idServizioApplicativoAutorizzato);
                    listPA = this.porteApplicativeCore.getAllIdPorteApplicative(filtroPA);
                    if (listPA != null && !listPA.isEmpty()) {
                        msg = "l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione token) di " + listPA.size() + " erogazion" + (listPA.size() > 1 ? "i" : "e");
                        if (segnalaWarning) {
                            if (sbWarningDetails.length() > 0) {
                                sbWarningDetails.append("<br/>");
                            }
                            sbWarningDetails.append("- " + msg);
                        } else {
                            this.pd.setMessage("Non &egrave; possibile modificare il tipo di credenziali poich&egrave; " + msg);
                            return false;
                        }
                    }
                    if (segnalaWarning && sbWarningDetails.length() > 0) {
                        sbWarningChange.append("Il certificato di firma dell'applicativo potrebbe essere richiesto per fruire di una API.");
                        sbWarningChange.append("<br/>");
                        sbWarningChange.append("Verificare le configurazioni dove risulta associato l'applicativo:");
                        sbWarningChange.append("<br/>");
                        sbWarningChange.append(sbWarningDetails.toString());
                    }
                }
            }
            if (tipoOperazione.equals((Object)TipoOperazione.CHANGE)) {
                Object nomeProv = "";
                boolean servizioApplicativoInUso = false;
                if ((long)newProv != idProvOld) {
                    int j;
                    int i;
                    org.openspcoop2.core.config.Soggetto oldSogg = this.soggettiCore.getSoggetto(idProvOld);
                    nomeProv = oldSogg.getTipo() + "/" + oldSogg.getNome();
                    for (i = 0; i < oldSogg.sizePortaDelegataList(); ++i) {
                        PortaDelegata pde = oldSogg.getPortaDelegata(i);
                        for (j = 0; j < pde.sizeServizioApplicativoList(); ++j) {
                            PortaDelegataServizioApplicativo tmpSA = pde.getServizioApplicativo(j);
                            if (!nome.equals(tmpSA.getNome())) continue;
                            servizioApplicativoInUso = true;
                            break;
                        }
                        if (servizioApplicativoInUso) break;
                    }
                    if (!servizioApplicativoInUso) {
                        for (i = 0; i < oldSogg.sizePortaApplicativaList(); ++i) {
                            PortaApplicativa pa = oldSogg.getPortaApplicativa(i);
                            for (j = 0; j < pa.sizeServizioApplicativoList(); ++j) {
                                PortaApplicativaServizioApplicativo tmpSA = pa.getServizioApplicativo(j);
                                if (!nome.equals(tmpSA.getNome())) continue;
                                servizioApplicativoInUso = true;
                                break;
                            }
                            if (servizioApplicativoInUso) break;
                        }
                    }
                }
                if (servizioApplicativoInUso) {
                    this.pd.setMessage("Il Servizio Applicativo " + nome + " &egrave; gi&agrave; stato associato ad alcune porte delegate e/o applicative del Soggetto " + (String)nomeProv + ". Se si desidera modificare il Soggetto, &egrave; necessario eliminare prima tutte le occorrenze del Servizio Applicativo");
                    return false;
                }
            }
            boolean oldPasswordCifrata = false;
            if (saOld != null && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().sizeCredenzialiList() > 0 && saOld.getInvocazionePorta().getCredenziali(0).isCertificateStrictVerification()) {
                oldPasswordCifrata = true;
            }
            if (!this.credenzialiCheckData(tipoOperazione, oldPasswordCifrata, encryptEnabled = this.saCore.isApplicativiPasswordEncryptEnabled(), this.saCore.getApplicativiPasswordVerifier())) {
                return false;
            }
            String tipoauth = this.getParameter("tipoauthCredenziali");
            if (tipoauth == null) {
                tipoauth = "nessuna";
            }
            String utente = this.getParameter("utenteCredenziali");
            String password = this.getParameter("passwordCredenziali");
            String subject = this.getParameter("subjectCredenziali");
            String issuer = this.getParameter("subjectIssuer");
            if ("".equals(issuer)) {
                issuer = null;
            }
            String principal = this.getParameter("principalCredenziali");
            String tokenPolicy = this.getParameter("tokenPolicyCred");
            String tokenClientId = this.getParameter("tokenClientIdCred");
            boolean tokenByPDND = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth);
            boolean bl4 = tokenWithHttpsEnabledByConfigSA = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth);
            if (tokenWithHttpsEnabledByConfigSA) {
                tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
            }
            boolean bl5 = tokenModiPDNDOauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth);
            if (tokenModiPDNDOauth) {
                tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN;
            }
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC)) {
                boolean checkPasswordSoggetti;
                Soggetto soggettoAutenticato;
                boolean checkPassword = this.saCore.isApplicativiCredenzialiBasicCheckUniqueUsePassword();
                List<ServizioApplicativo> saList = this.saCore.servizioApplicativoWithCredenzialiBasicList(utente, password, checkPassword);
                String portaDominio2 = null;
                if (this.core.isRegistroServiziLocale()) {
                    Soggetto soggettoToCheck = tipoOperazione.equals((Object)TipoOperazione.CHANGE) ? this.soggettiCore.getSoggettoRegistro(idProvOld) : this.soggettiCore.getSoggettoRegistro(newProv);
                    portaDominio2 = soggettoToCheck.getPortaDominio();
                }
                for (int i = 0; i < saList.size(); ++i) {
                    Soggetto tmpSoggettoProprietarioSa2;
                    ServizioApplicativo sa = saList.get(i);
                    if (!this.core.isSinglePdD() && !portaDominio2.equals((tmpSoggettoProprietarioSa2 = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto())).getPortaDominio()) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nome.equals(sa.getNome()) && idProvOld == sa.getIdSoggetto() || saOld != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld.getId().longValue() == sa.getId().longValue()) continue;
                    String labelSoggetto2 = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    if (sa.getTipo() != null && StringUtils.isNotEmpty((String)sa.getTipo())) {
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto2 + ") possiede gi\u00e0 l'utente (http-basic) indicato");
                    } else {
                        this.pd.setMessage("L'erogazione " + sa.getNome() + " possiede gi\u00e0 l'utente (http-basic) indicato per il servizio 'Servizio IntegrationManager/MessageBox'");
                    }
                    return false;
                }
                if (!this.soggettiCore.isSoggettiApplicativiCredenzialiBasicPermitSameCredentials() && (soggettoAutenticato = this.soggettiCore.soggettoWithCredenzialiBasic(utente, password, checkPasswordSoggetti = this.soggettiCore.isSoggettiCredenzialiBasicCheckUniqueUsePassword())) != null) {
                    String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                    this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 l'utente (http-basic) indicato");
                    return false;
                }
            } else if (!tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY)) {
                if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL) && !tokenWithHttpsEnabledByConfigSA) {
                    String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
                    String tipoCredenzialiSSLSorgente = this.getParameter("confSSLCredenziali");
                    if (tipoCredenzialiSSLSorgente == null) {
                        tipoCredenzialiSSLSorgente = "confMan";
                    }
                    if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter("confSSLManSS")) == null) {
                        tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "yes";
                    }
                    String details = "";
                    List<ServizioApplicativo> saList = null;
                    String tipoSsl = null;
                    Certificate cSelezionato = null;
                    boolean strictVerifier = false;
                    if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                        saList = this.saCore.servizioApplicativoWithCredenzialiSslList(subject, issuer, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                        tipoSsl = "subject/issuer";
                    } else {
                        List<ServizioApplicativo> saListCheck;
                        BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter("confSSLCredFileCert");
                        String tipoCredenzialiSSLVerificaTuttiICampi = this.getParameter("confSSLCredVerifTutti");
                        strictVerifier = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                        String tipoCredenzialiSSLTipoArchivioS = this.getParameter("confSSLCredTipoArch");
                        String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter("confSSLCredFileCertPwd");
                        String tipoCredenzialiSSLAliasCertificato = this.getParameter("confSSLCredAliasCert");
                        if (tipoCredenzialiSSLAliasCertificato == null) {
                            tipoCredenzialiSSLAliasCertificato = "";
                        }
                        ArchiveType tipoCredenzialiSSLTipoArchivio = null;
                        tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
                        byte[] archivio = tipoCredenzialiSSLFileCertificato.getValue();
                        if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && archivio == null) {
                            archivio = saOld.getInvocazionePorta().getCredenziali(0).getCertificate();
                        }
                        cSelezionato = tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])archivio) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])archivio, (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                        saList = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                        if (!(strictVerifier || saList == null || saList.isEmpty() || (saListCheck = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), true, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps())) != null && !saListCheck.isEmpty())) {
                            details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                        }
                        tipoSsl = "certificato";
                    }
                    String portaDominio3 = null;
                    if (this.core.isRegistroServiziLocale()) {
                        Soggetto soggettoToCheck = tipoOperazione.equals((Object)TipoOperazione.CHANGE) ? this.soggettiCore.getSoggettoRegistro(idProvOld) : this.soggettiCore.getSoggettoRegistro(newProv);
                        portaDominio3 = soggettoToCheck.getPortaDominio();
                    }
                    if (saList != null) {
                        for (int i = 0; i < saList.size(); ++i) {
                            Soggetto tmpSoggettoProprietarioSa3;
                            ServizioApplicativo sa = saList.get(i);
                            if (!this.core.isSinglePdD() && !portaDominio3.equals((tmpSoggettoProprietarioSa3 = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto())).getPortaDominio()) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nome.equals(sa.getNome()) && idProvOld == sa.getIdSoggetto() || saOld != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld.getId().longValue() == sa.getId().longValue()) continue;
                            String labelSoggetto3 = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                            this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto3 + ") possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                            return false;
                        }
                    }
                    if (!(tokenWithHttpsEnabledByConfigSA || this.soggettiCore.isSoggettiApplicativiCredenzialiSslPermitSameCredentials() || dominioEsternoModI)) {
                        details = "";
                        Soggetto soggettoAutenticato = null;
                        if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                            soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoSsl(subject, issuer);
                            tipoSsl = "subject/issuer";
                        } else {
                            List<Soggetto> soggettiAutenticati = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier);
                            if (soggettiAutenticati != null && !soggettiAutenticati.isEmpty()) {
                                List<Soggetto> soggettiAutenticatiCheck;
                                soggettoAutenticato = soggettiAutenticati.get(0);
                                if (!strictVerifier && ((soggettiAutenticatiCheck = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), true)) == null || soggettiAutenticatiCheck.isEmpty())) {
                                    details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                                }
                            }
                            tipoSsl = "certificato";
                        }
                        if (soggettoAutenticato != null) {
                            String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                            this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                            return false;
                        }
                    }
                } else if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL)) {
                    Soggetto soggettoAutenticato;
                    List<ServizioApplicativo> saList = this.saCore.servizioApplicativoWithCredenzialiPrincipalList(principal);
                    portaDominio4 = null;
                    if (this.core.isRegistroServiziLocale()) {
                        Soggetto soggettoToCheck = tipoOperazione.equals((Object)TipoOperazione.CHANGE) ? this.soggettiCore.getSoggettoRegistro(idProvOld) : this.soggettiCore.getSoggettoRegistro(newProv);
                        portaDominio4 = soggettoToCheck.getPortaDominio();
                    }
                    for (int i = 0; i < saList.size(); ++i) {
                        ServizioApplicativo sa = saList.get(i);
                        if (!this.core.isSinglePdD() && !portaDominio4.equals((tmpSoggettoProprietarioSa = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto())).getPortaDominio()) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nome.equals(sa.getNome()) && idProvOld == sa.getIdSoggetto() || saOld != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld.getId().longValue() == sa.getId().longValue()) continue;
                        labelSoggetto = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 il principal indicato");
                        return false;
                    }
                    if (!this.soggettiCore.isSoggettiApplicativiCredenzialiPrincipalPermitSameCredentials() && (soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoPrincipal(principal)) != null) {
                        String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                        this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 il principal indicato");
                        return false;
                    }
                }
            }
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoauth) || tokenWithHttpsEnabledByConfigSA) {
                if (tokenPolicy == null || StringUtils.isEmpty((String)tokenPolicy) || "-".equals(tokenPolicy)) {
                    this.pd.setMessage("TokenPolicy non indicata");
                }
                if (ControlStationCore.isAPIMode()) {
                    GenericProperties gp = null;
                    try {
                        gp = this.confCore.getGenericProperties(tokenPolicy, "gestionePolicyToken", false);
                    }
                    catch (DriverConfigurazioneNotFound portaDominio4) {
                        // empty catch block
                    }
                    if (gp == null) {
                        this.pd.setMessage("TokenPolicy indicata '" + tokenPolicy + "' non esiste");
                        return false;
                    }
                }
                List<ServizioApplicativo> saList = this.saCore.servizioApplicativoWithCredenzialiTokenList(tokenPolicy, tokenClientId);
                portaDominio4 = null;
                if (this.core.isRegistroServiziLocale()) {
                    Soggetto soggettoToCheck = tipoOperazione.equals((Object)TipoOperazione.CHANGE) ? this.soggettiCore.getSoggettoRegistro(idProvOld) : this.soggettiCore.getSoggettoRegistro(newProv);
                    portaDominio4 = soggettoToCheck.getPortaDominio();
                }
                for (int i = 0; i < saList.size(); ++i) {
                    ServizioApplicativo sa = saList.get(i);
                    if (!this.core.isSinglePdD() && !portaDominio4.equals((tmpSoggettoProprietarioSa = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto())).getPortaDominio()) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nome.equals(sa.getNome()) && idProvOld == sa.getIdSoggetto() || saOld != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld.getId().longValue() == sa.getId().longValue()) continue;
                    labelSoggetto = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    if (protocollo != null && this.core.isProfiloModIPA(protocollo)) {
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 l'identificativo client indicato");
                    } else {
                        this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 le credenziali indicate");
                    }
                    return false;
                }
                String oldTokenPolicy = null;
                if (tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld != null && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().sizeCredenzialiList() > 0) {
                    oldTokenPolicy = saOld.getInvocazionePorta().getCredenziali(0).getTokenPolicy();
                }
                if (oldTokenPolicy != null && !oldTokenPolicy.equals(tokenPolicy)) {
                    FiltroRicercaPorteDelegate filtro = new FiltroRicercaPorteDelegate();
                    filtro.setTipoSoggetto(idSA.getIdSoggettoProprietario().getTipo());
                    filtro.setNomeSoggetto(idSA.getIdSoggettoProprietario().getNome());
                    filtro.setNomeServizioApplicativo(idSA.getNome());
                    List<IDPortaDelegata> list = this.porteDelegateCore.getAllIdPorteDelegate(filtro);
                    if (list != null && !list.isEmpty()) {
                        this.pd.setMessage("Non &egrave; possibile modificare la token policy poich&egrave; l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione trasporto) di " + list.size() + " fruizion" + (list.size() > 1 ? "i" : "e"));
                        return false;
                    }
                    String tipoTrasporto = "trasporto";
                    if (this.isProfiloModIPA(protocollo)) {
                        tipoTrasporto = "messaggio";
                    }
                    FiltroRicercaPorteApplicative filtroPA = new FiltroRicercaPorteApplicative();
                    IDServizioApplicativo idServizioApplicativoAutorizzato = new IDServizioApplicativo();
                    idServizioApplicativoAutorizzato.setIdSoggettoProprietario(new IDSoggetto(idSA.getIdSoggettoProprietario().getTipo(), idSA.getIdSoggettoProprietario().getNome()));
                    idServizioApplicativoAutorizzato.setNome(idSA.getNome());
                    filtroPA.setIdServizioApplicativoAutorizzato(idServizioApplicativoAutorizzato);
                    List<IDPortaApplicativa> listPA = this.porteApplicativeCore.getAllIdPorteApplicative(filtroPA);
                    if (listPA != null && !listPA.isEmpty()) {
                        this.pd.setMessage("Non &egrave; possibile modificare la token policy poich&egrave; l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione " + tipoTrasporto + ") di " + listPA.size() + " erogazion" + (listPA.size() > 1 ? "i" : "e"));
                        return false;
                    }
                    filtro = new FiltroRicercaPorteDelegate();
                    filtro.setTipoSoggetto(idSA.getIdSoggettoProprietario().getTipo());
                    filtro.setNomeSoggetto(idSA.getIdSoggettoProprietario().getNome());
                    filtro.setNomeServizioApplicativoToken(idSA.getNome());
                    list = this.porteDelegateCore.getAllIdPorteDelegate(filtro);
                    if (list != null && !list.isEmpty()) {
                        this.pd.setMessage("Non &egrave; possibile modificare la token policy poich&egrave; l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione token) di " + list.size() + " fruizion" + (list.size() > 1 ? "i" : "e"));
                        return false;
                    }
                    filtroPA = new FiltroRicercaPorteApplicative();
                    filtroPA.setIdServizioApplicativoAutorizzatoToken(idServizioApplicativoAutorizzato);
                    listPA = this.porteApplicativeCore.getAllIdPorteApplicative(filtroPA);
                    if (listPA != null && !listPA.isEmpty()) {
                        this.pd.setMessage("Non &egrave; possibile modificare la token policy poich&egrave; l'applicativo viene utilizzato all'interno del controllo degli accessi (autorizzazione token) di " + listPA.size() + " erogazion" + (listPA.size() > 1 ? "i" : "e"));
                        return false;
                    }
                }
            }
            boolean bl6 = validaEndPoint = this.isModalitaStandard() && !TipologiaErogazione.DISABILITATO.equals(ruoloErogatore);
            if (isApplicativiServerEnabled) {
                validaEndPoint = "server".equals(tipoSA);
            }
            return !validaEndPoint || (isOk = this.servizioApplicativoEndPointCheckData(protocollo, listExtendedConnettore, saOld));
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    private void addFilterRuoloServizioApplicativo(String ruoloSA, boolean postBack) throws Exception {
        try {
            String[] tmp = ServiziApplicativiCostanti.getServiziApplicativiRuolo();
            String[] values = new String[tmp.length + 1];
            String[] labels = new String[tmp.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < tmp.length; ++i) {
                labels[i + 1] = tmp[i];
                values[i + 1] = tmp[i];
            }
            String selectedValue = ruoloSA != null ? ruoloSA : "";
            String label = "Tipologia";
            this.pd.addFilter("filtroRuoloSA", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    private void addFilterTipoServizioApplicativo(String tipoSA, boolean postBack) throws Exception {
        try {
            String[] tmp_labels = ServiziApplicativiCostanti.getLabelsServiziApplicativiTipo();
            String[] tmp_values = ServiziApplicativiCostanti.getValuesServiziApplicativiTipo();
            String[] values = new String[tmp_values.length + 1];
            String[] labels = new String[tmp_labels.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "clientORserver";
            for (int i = 0; i < tmp_labels.length; ++i) {
                labels[i + 1] = tmp_labels[i];
                values[i + 1] = tmp_values[i];
            }
            String selectedValue = tipoSA != null ? tipoSA : "clientORserver";
            String label = "Tipo";
            this.pd.addFilter("filtroTipoSA", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void prepareServizioApplicativoList(ISearch ricerca, List<ServizioApplicativo> lista, boolean useIdSoggetto) throws Exception {
        this.prepareServizioApplicativoList(ricerca, lista, useIdSoggetto, true);
    }

    public void prepareServizioApplicativoList(ISearch ricerca, List<ServizioApplicativo> lista, boolean useIdSoggetto, boolean readProvider) throws Exception {
        try {
            ExporterUtils exporterUtils;
            List<String> nomiProprieta;
            String protocolloPerFiltroProprieta;
            boolean modalitaCompleta = this.isModalitaCompleta();
            String idProvider = null;
            if (readProvider) {
                idProvider = this.getParameter("provider");
            }
            boolean multitenant = this.saCore.isMultitenant();
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentSA == null) {
                parentSA = 0;
            }
            Boolean useIdSoggObject = parentSA == 1;
            boolean useIdSogg = false;
            if (useIdSoggObject != null) {
                useIdSogg = useIdSoggObject;
            }
            if (useIdSogg) {
                Parameter pProvider = new Parameter("provider", idProvider);
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativi", (Parameter[])new Parameter[]{pProvider});
            } else {
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativi", (Parameter[])new Parameter[0]);
            }
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            Boolean singlePdD = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"singlePdD");
            if (!modalitaCompleta && !useIdSogg) {
                this.pd.setCustomListViewName("applicativi");
            }
            String tmpTitle = null;
            String protocolloSoggetto = null;
            boolean supportAsincroni = true;
            if (useIdSogg) {
                Soggetto tmpSogg;
                if (this.core.isRegistroServiziLocale()) {
                    tmpSogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                } else {
                    tmpSogg = this.soggettiCore.getSoggetto(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                }
                List<ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(protocolloSoggetto);
                for (ServiceBinding serviceBinding : serviceBindingListProtocollo) {
                    supportAsincroni = this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) || this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                }
                if (!supportAsincroni && this.isModalitaAvanzata()) {
                    supportAsincroni = this.core.isElenchiSAAsincroniNonSupportatiVisualizzaRispostaAsincrona();
                }
            }
            int idLista = useIdSogg ? Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO : Liste.SERVIZIO_APPLICATIVO;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterProtocollo = null;
            String filterSoggetto = null;
            boolean profiloSelezionato = false;
            boolean supportatoAutenticazioneApplicativiEsterni = false;
            String protocolloS = null;
            if (!useIdSogg) {
                List<String> protocolli;
                filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
                protocolloS = filterProtocollo;
                if (protocolloS == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                    protocolloS = protocolli.get(0);
                }
                if (protocolloS != null && !"".equals(protocolloS)) {
                    supportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloS);
                }
                if (filterProtocollo != null && !"".equals(filterProtocollo) || filterProtocollo == null && protocolloS != null) {
                    profiloSelezionato = true;
                }
                if (profiloSelezionato && (!this.isSoggettoMultitenantSelezionato() || supportatoAutenticazioneApplicativiEsterni)) {
                    boolean soloSoggettiOperativi = true;
                    if (supportatoAutenticazioneApplicativiEsterni) {
                        soloSoggettiOperativi = false;
                    }
                    filterSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    this.addFilterSoggetto(filterSoggetto, protocolloS, soloSoggettiOperativi, true);
                }
            }
            if (this.isSoggettoMultitenantSelezionato()) {
                filterSoggetto = this.getSoggettoMultitenantSelezionato();
            }
            String filterDominio = null;
            if (!this.core.isGestionePddAbilitata(this) && multitenant && supportatoAutenticazioneApplicativiEsterni) {
                filterDominio = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroDominio");
                this.addFilterDominio(filterDominio, true);
            }
            if (modalitaCompleta) {
                String filterRuoloSA = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRuoloSA");
                this.addFilterRuoloServizioApplicativo(filterRuoloSA, false);
            }
            boolean applicativiServerEnabled = this.core.isApplicativiServerEnabled(this);
            String filterTipoSA = null;
            if (applicativiServerEnabled) {
                filterTipoSA = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoSA");
                this.addFilterTipoServizioApplicativo(filterTipoSA, true);
            }
            String filterTipoCredenziali = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroTipoCredenziali");
            this.addFilterTipoCredenziali(filterTipoCredenziali, true, true);
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(filterTipoCredenziali)) {
                String filterCredenzialeTokenPolicy = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCredenzialeTokenPolicy");
                this.addFilterCredenzialeTokenPolicy(filterCredenzialeTokenPolicy, false);
            }
            String filterCredenziale = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCredenziale");
            this.addFilterCredenziale(filterTipoCredenziali, filterCredenziale);
            String filterCredenzialeIssuer = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroCredenzialeIssuer");
            this.addFilterCredenzialeIssuer(filterTipoCredenziali, filterCredenzialeIssuer);
            String filterRuolo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRuolo");
            this.addFilterRuolo(filterRuolo, false);
            String filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            this.addFilterGruppo(filterProtocollo, filterGruppo, true);
            String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
            this.addFilterApiContesto(filterApiContesto, true);
            if (profiloSelezionato && filterApiContesto != null && !"".equals(filterApiContesto)) {
                String filterApiImplementazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
                this.addFilterApiImplementazione(filterProtocollo, filterSoggetto, filterGruppo, filterApiContesto, filterApiImplementazione, false);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
            }
            if (applicativiServerEnabled && (filterTipoSA == null || "clientORserver".equals(filterTipoSA) || "server".equals(filterTipoSA))) {
                this.addFilterSubtitle("subtDatiConn", "Dati Connettore", false);
                String filterTipoConnettore = this.addFilterTipoConnettore(ricerca, idLista, true);
                this.addFilterConnettorePlugin(ricerca, idLista, filterTipoConnettore);
                if (!this.isModalitaStandard()) {
                    this.addFilterConnettoreDebug(ricerca, idLista, filterTipoConnettore);
                }
                this.addFilterConnettoreTokenPolicy(ricerca, idLista, filterTipoConnettore);
                this.addFilterConnettoreEndpoint(ricerca, idLista, filterTipoConnettore);
                this.addFilterConnettoreKeystore(ricerca, idLista, filterTipoConnettore);
                this.impostaAperturaSubtitle("subtDatiConn");
            }
            if (filterTipoSA == null || "clientORserver".equals(filterTipoSA) || "client".equals(filterTipoSA)) {
                boolean profiloModipaSelezionato = false;
                if (this.core.getProtocolli().contains("modipa")) {
                    ArrayList<String> profiloModipaSelezionatoOpzioniAccettate = new ArrayList<String>();
                    profiloModipaSelezionatoOpzioniAccettate.add("modipa");
                    if (this.core.isModipaFiltroRicercaProfiloQualsiasiVisualizzaDatiModi()) {
                        profiloModipaSelezionatoOpzioniAccettate.add("");
                    }
                    if (filterProtocollo != null && profiloModipaSelezionatoOpzioniAccettate.contains(filterProtocollo) || filterProtocollo == null && protocolloS != null && profiloModipaSelezionatoOpzioniAccettate.contains(protocolloS)) {
                        profiloModipaSelezionato = true;
                    }
                }
                if (profiloModipaSelezionato) {
                    this.addFilterSubtitle("subtDatiProfiloModI", "Dati Profilo ModI", false);
                    if (!this.core.isGestionePddAbilitata(this) && multitenant && !SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE.equals(filterDominio)) {
                        String sicurezzaToken;
                        String sicurezzaMessaggio = this.addFilterModISicurezzaMessaggioSA(ricerca, idLista, true);
                        if (sicurezzaMessaggio != null && !"".equals(sicurezzaMessaggio) && StatoFunzionalita.ABILITATO.getValue().equals(sicurezzaMessaggio)) {
                            this.addFilterModIKeystorePath(ricerca, idLista);
                            this.addFilterModIKeystoreSubject(ricerca, idLista);
                            this.addFilterModIKeystoreIssuer(ricerca, idLista);
                        }
                        if ((sicurezzaToken = this.addFilterModISicurezzaTokenSA(ricerca, idLista, true)) != null && !"".equals(sicurezzaToken) && StatoFunzionalita.ABILITATO.getValue().equals(sicurezzaToken)) {
                            this.addFilterModITokenPolicy(ricerca, idLista, false);
                            this.addFilterModITokenClientId(ricerca, idLista);
                        }
                    }
                    this.addFilterModIAudience(ricerca, idLista, true, null, filterDominio);
                    this.impostaAperturaSubtitle("subtDatiProfiloModI");
                }
            }
            if ((protocolloPerFiltroProprieta = protocolloS) == null) {
                protocolloPerFiltroProprieta = "".equals(filterProtocollo) ? null : filterProtocollo;
            }
            String soggettoPerFiltroProprieta = null;
            if (profiloSelezionato) {
                if (!this.isSoggettoMultitenantSelezionato()) {
                    soggettoPerFiltroProprieta = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    if ("".equals(soggettoPerFiltroProprieta)) {
                        soggettoPerFiltroProprieta = null;
                    }
                } else {
                    soggettoPerFiltroProprieta = this.getSoggettoMultitenantSelezionato();
                }
            }
            if ((nomiProprieta = this.nomiProprietaSA(protocolloPerFiltroProprieta, soggettoPerFiltroProprieta)) != null && !nomiProprieta.isEmpty()) {
                this.addFilterSubtitle("subtDatiProp", "Dati Propriet&agrave;", false);
                this.addFilterProprietaNome(ricerca, idLista, nomiProprieta);
                this.addFilterProprietaValore(ricerca, idLista, nomiProprieta);
                this.impostaAperturaSubtitle("subtDatiProp");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!modalitaCompleta) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            if (!useIdSogg) {
                this.pd.setSearchLabel("Nome");
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(labelApplicativi, "serviziApplicativiList.do")});
                } else {
                    ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(labelApplicativi, "serviziApplicativiList.do"), new Parameter("Risultati ricerca", null)});
                }
            } else {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                this.pd.setSearchLabel("Nome");
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    lstParam.add(new Parameter(labelApplicativiDi + tmpTitle, null));
                } else {
                    lstParam.add(new Parameter(labelApplicativiDi + tmpTitle, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", idProvider)}));
                    lstParam.add(new Parameter("Risultati ricerca", null));
                }
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParam.toArray(new Parameter[lstParam.size()]));
            }
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)labelApplicativi, (String)search);
            }
            boolean showProtocolli = this.core.countProtocolli(this.request, this.session) > 1;
            supportatoAutenticazioneApplicativiEsterni = false;
            if (lista != null) {
                for (ServizioApplicativo sa : lista) {
                    String protocolloCheck = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
                    if (!this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocolloCheck)) continue;
                    supportatoAutenticazioneApplicativiEsterni = true;
                    break;
                }
            }
            this.setLabelColonne(modalitaCompleta, useIdSogg, multitenant, supportatoAutenticazioneApplicativiEsterni, showProtocolli, supportAsincroni);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<ServizioApplicativo> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = !modalitaCompleta && !useIdSogg ? this.creaEntryCustom(multitenant, useIdSogg, showProtocolli, supportatoAutenticazioneApplicativiEsterni, applicativiServerEnabled, it) : this.creaEntry(modalitaCompleta, multitenant, useIdSogg, contaListe, supportAsincroni, showProtocolli, supportatoAutenticazioneApplicativiEsterni, applicativiServerEnabled, it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(org.openspcoop2.protocol.sdk.constants.ArchiveType.SERVIZIO_APPLICATIVO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(ServiziApplicativiCostanti.LABEL_SERVIZI_APPLICATIVI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    private List<DataElement> creaEntry(boolean modalitaCompleta, boolean multitenant, Boolean useIdSogg, Boolean contaListe, boolean supportAsincroni, boolean showProtocolli, boolean supportatoAutenticazioneApplicativiEsterni, boolean applicativiServerEnabled, Iterator<ServizioApplicativo> it) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverControlStationException, DriverControlStationNotFound, Exception, DriverConfigurazioneException {
        IDSoggetto tmpIDS;
        Soggetto tmpSogg;
        String nomePdd;
        ServizioApplicativo sa = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setValue("" + sa.getId());
        e.add(de);
        String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
        IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
        Soggetto soggettoProprietario = this.soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
        String dominio = this.pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
        de = new DataElement();
        de.setUrl("serviziApplicativiChange.do", new Parameter[]{new Parameter("id", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto()), new Parameter("dominio", dominio)});
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        de.setValue(sa.getNome());
        de.setIdToRemove(sa.getId().toString());
        e.add(de);
        if (!useIdSogg.booleanValue() && (multitenant && !this.isSoggettoMultitenantSelezionato() || supportatoAutenticazioneApplicativiEsterni)) {
            de = new DataElement();
            if (modalitaCompleta) {
                de.setUrl("soggettiChange.do", new Parameter[]{new Parameter("id", "" + sa.getIdSoggetto()), new Parameter("nomeprov", sa.getNomeSoggettoProprietario()), new Parameter("tipoprov", sa.getTipoSoggettoProprietario())});
            }
            de.setValue(this.getLabelNomeSoggetto(protocollo, sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
            e.add(de);
        }
        if (showProtocolli) {
            de = new DataElement();
            de.setValue(this.getLabelProtocollo(protocollo));
            e.add(de);
        }
        boolean pddEsterna = false;
        if (this.core.isRegistroServiziLocale() && this.pddCore.isPddEsterna(nomePdd = (tmpSogg = this.soggettiCore.getSoggettoRegistro(tmpIDS = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()))).getPortaDominio())) {
            pddEsterna = true;
        }
        boolean isServer = false;
        if (applicativiServerEnabled) {
            de = new DataElement();
            isServer = "server".equals(sa.getTipo());
            String tipoLabel = this.getTipo(sa);
            if (sa.isUseAsClient()) {
                isServer = false;
            }
            de.setValue(tipoLabel);
            e.add(de);
        }
        if (!modalitaCompleta) {
            de = new DataElement();
            if (isServer) {
                de.setValue("-");
            } else {
                if (useIdSogg.booleanValue()) {
                    de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())});
                } else {
                    de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId())});
                }
                if (contaListe.booleanValue()) {
                    ConsoleSearch searchForCount = new ConsoleSearch(true, 1);
                    this.saCore.servizioApplicativoRuoliList(sa.getId(), (ISearch)searchForCount);
                    int numRuoli = searchForCount.getNumEntries(Liste.SERVIZIO_APPLICATIVO_RUOLI);
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de, (Long)Long.valueOf(numRuoli));
                } else {
                    ServletUtils.setDataElementVisualizzaLabel((DataElement)de);
                }
            }
            e.add(de);
        }
        if (modalitaCompleta) {
            de = new DataElement();
            de.setValue(this.getTipologia(sa));
            e.add(de);
        }
        if (modalitaCompleta) {
            de = new DataElement();
            if (pddEsterna) {
                de.setValue("-");
            } else {
                de.setUrl("serviziApplicativiEndPointInvocazioneServizio.do", new Parameter[]{new Parameter("nomeservizioApplicativo", sa.getNome()), new Parameter("idsil", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())});
                InvocazioneServizio is = sa.getInvocazioneServizio();
                if (is == null) {
                    de.setValue(CostantiConfigurazione.ABILITATO.toString());
                } else {
                    boolean messageBoxDisabilitato;
                    Connettore connettore = is.getConnettore();
                    boolean connettoreDisabilitato = CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo()) || "".equals(connettore.getTipo()) || connettore.getTipo() == null;
                    boolean bl = messageBoxDisabilitato = CostantiConfigurazione.DISABILITATO.equals((Object)is.getGetMessage()) || is.getGetMessage() == null || "".equals(is.getGetMessage().getValue());
                    if (connettoreDisabilitato && messageBoxDisabilitato) {
                        de.setValue(CostantiConfigurazione.DISABILITATO.toString());
                    } else if (connettoreDisabilitato) {
                        de.setValue(ServiziApplicativiCostanti.LABEL_CONNETTORE_ABILITATO_SOLO_IM);
                    } else {
                        de.setValue(CostantiConfigurazione.ABILITATO.toString());
                    }
                }
            }
            e.add(de);
        }
        if (supportAsincroni && modalitaCompleta) {
            de = new DataElement();
            boolean supportoAsincronoPuntualeSoggetto = true;
            if (!useIdSogg.booleanValue()) {
                String protocolloPuntuale = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
                List<ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(protocolloPuntuale);
                for (ServiceBinding serviceBinding : serviceBindingListProtocollo) {
                    supportoAsincronoPuntualeSoggetto = this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloPuntuale, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) || this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloPuntuale, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                }
                if (!supportoAsincronoPuntualeSoggetto && this.isModalitaAvanzata()) {
                    supportoAsincronoPuntualeSoggetto = this.core.isElenchiSAAsincroniNonSupportatiVisualizzaRispostaAsincrona();
                }
            }
            if (pddEsterna || !supportoAsincronoPuntualeSoggetto) {
                de.setValue("-");
            } else {
                de.setUrl("serviziApplicativiEndPointRispostaAsincrona.do", new Parameter[]{new Parameter("nomeservizioApplicativo", sa.getNome()), new Parameter("idsil", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())});
                RispostaAsincrona ra = sa.getRispostaAsincrona();
                if (ra == null) {
                    de.setValue(CostantiConfigurazione.DISABILITATO.toString());
                } else {
                    boolean messageBoxDisabilitato;
                    Connettore connettore = ra.getConnettore();
                    boolean connettoreDisabilitato = CostantiConfigurazione.DISABILITATO.equals(connettore.getTipo()) || "".equals(connettore.getTipo()) || connettore.getTipo() == null;
                    boolean bl = messageBoxDisabilitato = CostantiConfigurazione.DISABILITATO.equals((Object)ra.getGetMessage()) || ra.getGetMessage() == null || "".equals(ra.getGetMessage().getValue());
                    if (connettoreDisabilitato && messageBoxDisabilitato) {
                        de.setValue(CostantiConfigurazione.DISABILITATO.toString());
                    } else if (connettoreDisabilitato) {
                        de.setValue(ServiziApplicativiCostanti.LABEL_CONNETTORE_ABILITATO_SOLO_IM);
                    } else {
                        de.setValue(CostantiConfigurazione.ABILITATO.toString());
                    }
                }
            }
            e.add(de);
        }
        return e;
    }

    private List<DataElement> creaEntryCustom(boolean multitenant, Boolean useIdSoggParam, boolean showProtocolli, boolean supportatoAutenticazioneApplicativiEsterni, boolean applicativiServerEnabled, Iterator<ServizioApplicativo> it) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverControlStationException, DriverControlStationNotFound, DriverConfigurazioneException {
        ServizioApplicativo sa = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(sa.getTipoSoggettoProprietario());
        IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
        Soggetto soggettoProprietario = this.soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
        String dominio = this.pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
        Parameter pSAId = new Parameter("id", "" + sa.getId());
        Parameter pSAIdSoggetto = new Parameter("provider", "" + sa.getIdSoggetto());
        Parameter pDominio = new Parameter("dominio", dominio);
        ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
        listaParametriChange.add(pSAId);
        listaParametriChange.add(pSAIdSoggetto);
        listaParametriChange.add(pDominio);
        Object nome = sa.getNome();
        DataElement de = new DataElement();
        de.setUrl("serviziApplicativiChange.do", new Parameter[]{pSAId, pSAIdSoggetto, pDominio});
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        de.setIdToRemove(sa.getId().toString());
        de.setType(DataElementType.TITLE);
        boolean useIdSogg = false;
        if (useIdSoggParam != null) {
            useIdSogg = useIdSoggParam;
        }
        if (!useIdSogg && (multitenant && !this.isSoggettoMultitenantSelezionato() || supportatoAutenticazioneApplicativiEsterni)) {
            nome = (String)nome + "@" + this.getLabelNomeSoggetto(protocollo, sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
        }
        de.setValue((String)nome);
        e.add(de);
        String tipoLabel = "";
        boolean isServer = false;
        if (applicativiServerEnabled || showProtocolli) {
            String labelProtocollo;
            de = new DataElement();
            boolean addMetadati = true;
            if (applicativiServerEnabled) {
                isServer = "server".equals(sa.getTipo());
                tipoLabel = this.getTipo(sa);
                if (sa.isUseAsClient()) {
                    isServer = false;
                }
                if (showProtocolli) {
                    labelProtocollo = this.getLabelProtocollo(protocollo);
                    de.setValue(MessageFormat.format("Profilo Interoperabilit&agrave;: {0}, Tipo: {1}", labelProtocollo, tipoLabel));
                } else {
                    de.setValue(MessageFormat.format("Tipo: {0}", tipoLabel));
                }
            } else if (showProtocolli) {
                labelProtocollo = this.getLabelProtocollo(protocollo);
                de.setValue(MessageFormat.format("Profilo Interoperabilit&agrave;: {0}", labelProtocollo));
            } else {
                de.setValue("");
                addMetadati = false;
            }
            de.setType(DataElementType.SUBTITLE);
            if (addMetadati) {
                e.add(de);
            }
        }
        if (!isServer) {
            List<String> listaRuoli = this.saCore.servizioApplicativoRuoliList(sa.getId(), (ISearch)new ConsoleSearch(true));
            for (int j = 0; j < listaRuoli.size(); ++j) {
                String ruolo = listaRuoli.get(j);
                de = new DataElement();
                de.setName("ruolo_" + j);
                de.setType(DataElementType.BUTTON);
                de.setLabel(ruolo);
                de.setStyleClass("ruolo-label-info-0");
                de.setUrl("serviziApplicativiRuoliList.do", new Parameter[]{new Parameter("idsil", "" + sa.getId())});
                de.setToolTip("Ruoli");
                e.add(de);
            }
        }
        IDServizioApplicativo idServizioApplicativo = new IDServizioApplicativo();
        idServizioApplicativo.setNome(sa.getNome());
        idServizioApplicativo.setIdSoggettoProprietario(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
        listaParametriChange.add(new Parameter("certVerFromLista", "true"));
        listaParametriChange.add(new Parameter("resetFromLista", "true"));
        this.addInUsoButton(e, this.isSoggettoMultitenantSelezionato() ? sa.getNome() : this.getLabelServizioApplicativoConDominioSoggetto(idServizioApplicativo), "" + sa.getId(), InUsoType.SERVIZIO_APPLICATIVO);
        if (this.core.isApplicativiVerificaCertificati()) {
            boolean ssl = false;
            InvocazionePorta ip = sa.getInvocazionePorta();
            for (int i = 0; i < ip.sizeCredenzialiList(); ++i) {
                Credenziali c = ip.getCredenziali(i);
                if (!CredenzialeTipo.SSL.equals((Object)c.getTipo())) continue;
                ssl = true;
            }
            boolean modi = this.core.isProfiloModIPA(protocollo);
            boolean sicurezzaMessaggioModi = false;
            boolean server = "server".equals(sa.getTipo());
            if (modi) {
                KeystoreParams keystoreParams = ModIUtils.getApplicativoKeystoreParams((List)sa.getProtocolPropertyList());
                boolean bl = sicurezzaMessaggioModi = keystoreParams != null;
            }
            if (ssl || sicurezzaMessaggioModi || server) {
                this.addVerificaCertificatiButton(e, "serviziApplicativiVerificaCertificati.do", listaParametriChange);
            }
        }
        if ("server".equals(sa.getTipo())) {
            ArrayList<Parameter> listaParametriVerificaConnettivitaChange = new ArrayList<Parameter>();
            listaParametriVerificaConnettivitaChange.addAll(listaParametriChange);
            listaParametriVerificaConnettivitaChange.add(new Parameter("tokenVerConn", "true"));
            this.addVerificaConnettivitaButton(e, "serviziApplicativiVerificaCertificati.do", listaParametriVerificaConnettivitaChange);
        }
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            this.addComandoResetCacheButton(e, this.isSoggettoMultitenantSelezionato() ? sa.getNome() : this.getLabelServizioApplicativoConDominioSoggetto(idServizioApplicativo), "serviziApplicativiChange.do", listaParametriChange);
        }
        this.addProprietaOggettoButton(e, this.isSoggettoMultitenantSelezionato() ? sa.getNome() : this.getLabelServizioApplicativoConDominioSoggetto(idServizioApplicativo), "" + sa.getId(), InUsoType.SERVIZIO_APPLICATIVO);
        return e;
    }

    private void setLabelColonne(boolean modalitaCompleta, boolean useIdSogg, boolean multitenant, boolean supportatoAutenticazioneApplicativiEsterni, boolean showProtocolli, boolean supportAsincroni) {
        if (!modalitaCompleta && !useIdSogg) {
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Applicativi");
            this.pd.setLabels(labels.toArray(new String[1]));
        } else {
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Nome");
            if (!useIdSogg && (multitenant && !this.isSoggettoMultitenantSelezionato() || supportatoAutenticazioneApplicativiEsterni)) {
                labels.add("Soggetto");
            }
            if (showProtocolli) {
                labels.add("Profilo");
            }
            if (this.core.isApplicativiServerEnabled(this)) {
                labels.add("Tipo");
            }
            if (!modalitaCompleta) {
                labels.add("Ruoli");
            }
            if (modalitaCompleta) {
                labels.add("Tipologia");
            }
            if (modalitaCompleta) {
                labels.add("Invocazione Servizio");
            }
            if (supportAsincroni && modalitaCompleta) {
                labels.add("Risposta Asincrona");
            }
            this.pd.setLabels(labels.toArray(new String[1]));
        }
    }

    private String getTipo(ServizioApplicativo sa) {
        return this.getTipo(sa.getTipo(), sa.isUseAsClient());
    }

    private String getTipo(String tipo, boolean useServerAsClient) {
        if (tipo == null) {
            return "Non Configurato";
        }
        if (tipo.equals("client")) {
            return "Client";
        }
        if (tipo.equals("server")) {
            if (useServerAsClient) {
                return "Server / Client";
            }
            return "Server";
        }
        return tipo;
    }

    private String getTipologia(ServizioApplicativo sa) {
        String ruoloFruitore = sa.getTipologiaFruizione();
        String ruoloErogatore = sa.getTipologiaErogazione();
        TipologiaFruizione tipologiaFruizione = TipologiaFruizione.toEnumConstant((String)ruoloFruitore);
        TipologiaErogazione tipologiaErogazione = TipologiaErogazione.toEnumConstant((String)ruoloErogatore);
        if (tipologiaFruizione == null) {
            tipologiaFruizione = sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0 ? TipologiaFruizione.NORMALE : TipologiaFruizione.DISABILITATO;
        }
        if (tipologiaErogazione == null) {
            tipologiaErogazione = sa.getInvocazioneServizio() != null ? (StatoFunzionalita.ABILITATO.equals((Object)sa.getInvocazioneServizio().getGetMessage()) ? TipologiaErogazione.MESSAGE_BOX : (sa.getInvocazioneServizio().getConnettore() != null && !TipiConnettore.DISABILITATO.getNome().equals(sa.getInvocazioneServizio().getConnettore().getTipo()) ? TipologiaErogazione.TRASPARENTE : TipologiaErogazione.DISABILITATO)) : TipologiaErogazione.DISABILITATO;
        }
        if (!TipologiaFruizione.DISABILITATO.equals((Object)tipologiaFruizione) && !TipologiaErogazione.DISABILITATO.equals((Object)tipologiaErogazione)) {
            return "Fruitore/Erogatore";
        }
        if (!TipologiaFruizione.DISABILITATO.equals((Object)tipologiaFruizione)) {
            return "Fruitore";
        }
        if (!TipologiaErogazione.DISABILITATO.equals((Object)tipologiaErogazione)) {
            return "Erogatore";
        }
        return "Non Configurato";
    }

    public void addEndPointToDati(List<DataElement> dati, String idsil, String nomeservizioApplicativo, String sbustamento, String sbustamentoInformazioniProtocolloRichiesta, String getmsg, String usernameGetMsg, String passwordGetMsg, boolean gestioneCredenzialiGetMsg, String invrif, String risprif, String nomeProtocollo, boolean showName, boolean isInvocazioneServizio, boolean showTitleTrattamentoMessaggio, Integer parentSA, ServiceBinding serviceBinding, String accessoDaAPSParametro, boolean servizioApplicativoServerEnabled, String tipoSA, boolean useAsClient, boolean integrationManagerEnabled, TipoOperazione tipoOperazione, String tipoCredenzialiSSLVerificaTuttiICampi, String changepwd, boolean postBackViaPost) throws Exception {
        if (servizioApplicativoServerEnabled) {
            this.addEndPointToDatiAsHidden(dati, idsil, nomeservizioApplicativo, sbustamento, sbustamentoInformazioniProtocolloRichiesta, getmsg, usernameGetMsg, passwordGetMsg, gestioneCredenzialiGetMsg, invrif, risprif, nomeProtocollo, showName, isInvocazioneServizio, showTitleTrattamentoMessaggio, parentSA, serviceBinding, accessoDaAPSParametro, servizioApplicativoServerEnabled);
            return;
        }
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(nomeProtocollo);
        IProtocolConfiguration config = protocolFactory.createProtocolConfiguration();
        DataElement de = new DataElement();
        de.setLabel("idsil");
        de.setValue(idsil);
        de.setType(DataElementType.HIDDEN);
        de.setName("idsil");
        dati.add(de);
        if (accessoDaAPSParametro != null && !"".equals(accessoDaAPSParametro)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(accessoDaAPSParametro);
            de.setName("connettoreDaListaAps");
            dati.add(de);
        }
        boolean showFromConfigurazione = false;
        if (parentSA != null && parentSA == 2) {
            showFromConfigurazione = true;
        }
        if (showName && !showFromConfigurazione) {
            de = new DataElement();
            de.setLabel("Servizio Applicativo");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomeservizioApplicativo);
            de.setType(DataElementType.TEXT);
            de.setName("nomeservizioApplicativo");
            de.setSize(this.getSize());
            dati.add(de);
        }
        boolean sbustamentoSoapEnabled = !this.isModalitaStandard() && (serviceBinding == null || serviceBinding.equals((Object)ServiceBinding.SOAP));
        boolean sbustamentoProtocolloEnabled = !this.isModalitaStandard() && config.isSupportoSbustamentoProtocollo();
        boolean bl = showTitleTrattamentoMessaggio = showTitleTrattamentoMessaggio && (sbustamentoSoapEnabled || sbustamentoProtocolloEnabled || this.isModalitaCompleta());
        if (showTitleTrattamentoMessaggio) {
            de = new DataElement();
            de.setLabel("Trattamento Messaggio");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        String[] tipoSbustamentoSOAP = new String[]{CostantiConfigurazione.ABILITATO.toString(), CostantiConfigurazione.DISABILITATO.toString()};
        de = new DataElement();
        de.setLabel("Sbustamento SOAP");
        de.setName("sbustamento");
        if (sbustamentoSoapEnabled) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoSbustamentoSOAP);
            if (sbustamento == null) {
                de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setSelected(sbustamento);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            if (sbustamento == null) {
                de.setValue(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setValue(sbustamento);
            }
        }
        dati.add(de);
        String[] tipoSbustamentoInformazioniProtocollo = new String[]{CostantiConfigurazione.ABILITATO.toString(), CostantiConfigurazione.DISABILITATO.toString()};
        de = new DataElement();
        if (nomeProtocollo != null && !"".equals(nomeProtocollo)) {
            de.setLabel(ServiziApplicativiCostanti.getLabelSbustamentoProtocollo(nomeProtocollo));
        } else {
            de.setLabel("Sbustamento Protocollo");
        }
        de.setName("sbustamentoInformazioniProtocolloRichiesta");
        if (sbustamentoProtocolloEnabled) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoSbustamentoInformazioniProtocollo);
            if (sbustamentoInformazioniProtocolloRichiesta == null) {
                de.setSelected(CostantiConfigurazione.ABILITATO.toString());
            } else {
                de.setSelected(sbustamentoInformazioniProtocolloRichiesta);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            if (sbustamentoInformazioniProtocolloRichiesta == null) {
                de.setValue(CostantiConfigurazione.ABILITATO.toString());
            } else {
                de.setValue(sbustamentoInformazioniProtocolloRichiesta);
            }
        }
        dati.add(de);
        if (!this.isModalitaCompleta()) {
            de = new DataElement();
            de.setLabel("Invio per Riferimento");
            de.setType(DataElementType.HIDDEN);
            de.setName("invrifRichiesta");
            de.setValue(invrif);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Risposta per Riferimento");
            de.setType(DataElementType.HIDDEN);
            de.setName("risprif");
            de.setValue(risprif);
            dati.add(de);
        } else {
            String[] tipoInvRif = new String[]{CostantiConfigurazione.ABILITATO.toString(), CostantiConfigurazione.DISABILITATO.toString()};
            de = new DataElement();
            de.setLabel("Invio per Riferimento");
            de.setType(DataElementType.SELECT);
            de.setName("invrifRichiesta");
            de.setValues(tipoInvRif);
            if (invrif == null) {
                de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setSelected(invrif);
            }
            dati.add(de);
            String[] tipoRispRif = new String[]{CostantiConfigurazione.ABILITATO.toString(), CostantiConfigurazione.DISABILITATO.toString()};
            de = new DataElement();
            de.setLabel("Risposta per Riferimento");
            de.setType(DataElementType.SELECT);
            de.setName("risprif");
            de.setValues(tipoRispRif);
            if (risprif == null) {
                de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setSelected(risprif);
            }
            dati.add(de);
        }
        if (integrationManagerEnabled) {
            de = new DataElement();
            de.setLabel("Servizio IntegrationManager/MessageBox");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        String[] tipoGM = new String[]{CostantiConfigurazione.ABILITATO.toString(), CostantiConfigurazione.DISABILITATO.toString()};
        de = new DataElement();
        de.setLabel("Attivazione MessageBox");
        de.setName("getmsg");
        if (integrationManagerEnabled) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoGM);
            if (getmsg == null) {
                de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setSelected(getmsg);
            }
            if (postBackViaPost) {
                de.setPostBack_viaPOST(true);
            } else {
                de.setPostBack(true);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            if (getmsg == null) {
                de.setValue(CostantiConfigurazione.DISABILITATO.toString());
            } else {
                de.setValue(getmsg);
            }
        }
        dati.add(de);
        if (gestioneCredenzialiGetMsg && CostantiConfigurazione.ABILITATO.toString().equals(getmsg)) {
            de = new DataElement();
            de.setLabel("Utente");
            de.setValue(StringEscapeUtils.escapeHtml((String)usernameGetMsg));
            if (integrationManagerEnabled) {
                de.setType(DataElementType.TEXT_EDIT);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            de.setName("utenteCredenziali");
            de.setSize(this.getSize());
            de.setRequired(true);
            dati.add(de);
            boolean change = TipoOperazione.CHANGE.equals((Object)tipoOperazione);
            boolean passwordCifrata = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
            if (change && passwordCifrata) {
                try {
                    long idS = -1L;
                    if (idsil != null) {
                        idS = Long.valueOf(idsil);
                    }
                    if (idS > 0L) {
                        ServizioApplicativo oldSA = this.saCore.getServizioApplicativo(idS);
                        boolean oldIMState = false;
                        if (isInvocazioneServizio) {
                            oldIMState = oldSA.getInvocazioneServizio() != null && oldSA.getInvocazioneServizio().getGetMessage() != null && StatoFunzionalita.ABILITATO.equals((Object)oldSA.getInvocazioneServizio().getGetMessage());
                        } else {
                            boolean bl2 = oldIMState = oldSA.getRispostaAsincrona() != null && oldSA.getRispostaAsincrona().getGetMessage() != null && StatoFunzionalita.ABILITATO.equals((Object)oldSA.getRispostaAsincrona().getGetMessage());
                        }
                        if (!oldIMState) {
                            passwordCifrata = false;
                        }
                    }
                }
                catch (Throwable idS) {
                    // empty catch block
                }
            }
            if (change && passwordCifrata) {
                DataElement deModifica = new DataElement();
                deModifica.setLabel("Modifica Password");
                deModifica.setType(DataElementType.CHECKBOX);
                deModifica.setName("changepwd");
                deModifica.setPostBack(true);
                deModifica.setSelected(changepwd);
                deModifica.setSize(this.getSize());
                dati.add(deModifica);
                DataElement deCifratura = new DataElement();
                deCifratura.setName("confSSLCredVerifTutti");
                deCifratura.setType(DataElementType.HIDDEN);
                deCifratura.setValue(tipoCredenzialiSSLVerificaTuttiICampi);
                dati.add(deCifratura);
            }
            if (!change || !passwordCifrata || ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                de = new DataElement();
                if (ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                    de.setLabel("Nuova Password");
                } else {
                    de.setLabel("Password");
                }
                if (change && passwordCifrata && ServletUtils.isCheckBoxEnabled((String)changepwd)) {
                    de.setValue(null);
                } else {
                    de.setValue(StringEscapeUtils.escapeHtml((String)passwordGetMsg));
                }
                if (integrationManagerEnabled) {
                    de.setType(DataElementType.CRYPT);
                    de.getPassword().setVisualizzaPasswordChiaro(true);
                    de.getPassword().setVisualizzaBottoneGeneraPassword(true);
                    PasswordVerifier passwordVerifier = null;
                    boolean isBasicPasswordEnableConstraints = this.connettoriCore.isApplicativiBasicPasswordEnableConstraints();
                    int lunghezzaPasswordGenerate = this.connettoriCore.getApplicativiBasicLunghezzaPasswordGenerate();
                    if (isBasicPasswordEnableConstraints) {
                        passwordVerifier = this.connettoriCore.getApplicativiPasswordVerifier();
                    }
                    if (passwordVerifier != null) {
                        PasswordGenerator passwordGenerator = new PasswordGenerator(passwordVerifier);
                        de.getPassword().setPasswordGenerator(passwordGenerator);
                        de.setNote(passwordVerifier.help("<br/>"));
                    }
                    de.getPassword().getPasswordGenerator().setDefaultLength(lunghezzaPasswordGenerate);
                } else {
                    de.setType(DataElementType.HIDDEN);
                }
                de.setName("passwordCredenziali");
                de.setSize(this.getSize());
                de.setRequired(true);
                dati.add(de);
            } else {
                de = new DataElement();
                de.setType(DataElementType.HIDDEN);
                de.setName("passwordCredenziali");
                de.setValue(StringEscapeUtils.escapeHtml((String)passwordGetMsg));
                dati.add(de);
            }
            if ("server".equals(tipoSA)) {
                de = new DataElement();
                de.setLabel("Utilizzabile come Client");
                de.setName("useAsClient");
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(useAsClient);
                dati.add(de);
            }
        }
    }

    public void addEndPointToDatiAsHidden(List<DataElement> dati, String idsil, String nomeservizioApplicativo, String sbustamento, String sbustamentoInformazioniProtocolloRichiesta, String getmsg, String usernameGetMsg, String passwordGetMsg, boolean gestioneCredenzialiGetMsg, String invrif, String risprif, String nomeProtocollo, boolean showName, boolean isInvocazioneServizio, boolean showTitleTrattamentoMessaggio, Integer parentSA, ServiceBinding serviceBinding, String accessoDaAPSParametro, boolean servizioApplicativoServerEnabled) throws Exception {
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(nomeProtocollo);
        IProtocolConfiguration config = protocolFactory.createProtocolConfiguration();
        DataElement de = new DataElement();
        de.setLabel("idsil");
        de.setValue(idsil);
        de.setType(DataElementType.HIDDEN);
        de.setName("idsil");
        dati.add(de);
        if (accessoDaAPSParametro != null && !"".equals(accessoDaAPSParametro)) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setValue(accessoDaAPSParametro);
            de.setName("connettoreDaListaAps");
            dati.add(de);
        }
        boolean showFromConfigurazione = false;
        if (parentSA != null && parentSA == 2) {
            showFromConfigurazione = true;
        }
        if (showName && !showFromConfigurazione) {
            de = new DataElement();
            de.setLabel("Nome");
            de.setValue(nomeservizioApplicativo);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeservizioApplicativo");
            de.setSize(this.getSize());
            dati.add(de);
        }
        boolean sbustamentoSoapEnabled = !this.isModalitaStandard() && (serviceBinding == null || serviceBinding.equals((Object)ServiceBinding.SOAP));
        boolean sbustamentoProtocolloEnabled = !this.isModalitaStandard() && config.isSupportoSbustamentoProtocollo();
        showTitleTrattamentoMessaggio = showTitleTrattamentoMessaggio && (sbustamentoSoapEnabled || sbustamentoProtocolloEnabled || this.isModalitaCompleta());
        de = new DataElement();
        de.setLabel("Sbustamento SOAP");
        de.setName("sbustamento");
        de.setType(DataElementType.HIDDEN);
        if (sbustamento == null) {
            de.setValue(CostantiConfigurazione.DISABILITATO.toString());
        } else {
            de.setValue(sbustamento);
        }
        dati.add(de);
        de = new DataElement();
        de.setName("sbustamentoInformazioniProtocolloRichiesta");
        de.setType(DataElementType.HIDDEN);
        if (sbustamentoInformazioniProtocolloRichiesta == null) {
            de.setValue(CostantiConfigurazione.ABILITATO.toString());
        } else {
            de.setValue(sbustamentoInformazioniProtocolloRichiesta);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Invio per Riferimento");
        de.setType(DataElementType.HIDDEN);
        de.setName("invrifRichiesta");
        if (invrif == null) {
            de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
        } else {
            de.setSelected(invrif);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Risposta per Riferimento");
        de.setType(DataElementType.HIDDEN);
        de.setName("risprif");
        if (risprif == null) {
            de.setSelected(CostantiConfigurazione.DISABILITATO.toString());
        } else {
            de.setSelected(risprif);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Attivazione MessageBox");
        de.setName("getmsg");
        de.setType(DataElementType.HIDDEN);
        if (getmsg == null) {
            de.setValue(CostantiConfigurazione.DISABILITATO.toString());
        } else {
            de.setValue(getmsg);
        }
        dati.add(de);
        if (gestioneCredenzialiGetMsg && CostantiConfigurazione.ABILITATO.toString().equals(getmsg)) {
            de = new DataElement();
            de.setLabel("Utente");
            de.setValue(StringEscapeUtils.escapeHtml((String)usernameGetMsg));
            de.setType(DataElementType.HIDDEN);
            de.setName("utenteCredenziali");
            de.setSize(this.getSize());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Password");
            de.setValue(StringEscapeUtils.escapeHtml((String)passwordGetMsg));
            de.setType(DataElementType.HIDDEN);
            de.setName("passwordCredenziali");
            de.setSize(this.getSize());
            dati.add(de);
        }
    }

    public List<DataElement> addHiddenFieldsToDati(List<DataElement> dati, String provider, String idAsps, String idPorta) {
        DataElement de = new DataElement();
        de.setLabel("provider");
        de.setValue(provider);
        de.setType(DataElementType.HIDDEN);
        de.setName("provider");
        dati.add(de);
        de = new DataElement();
        de.setLabel("idAsps");
        de.setValue(idAsps);
        de.setType(DataElementType.HIDDEN);
        de.setName("idAsps");
        dati.add(de);
        de = new DataElement();
        de.setLabel("idPorta");
        de.setValue(idPorta);
        de.setType(DataElementType.HIDDEN);
        de.setName("idPorta");
        dati.add(de);
        return dati;
    }

    public void prepareRuoliList(ISearch ricerca, List<String> lista) throws Exception {
        try {
            String idsil = this.getParameter("idsil");
            String idProvider = this.getParameter("provider");
            String accessDaChangeTmp = this.getParameter("accessoDaChange");
            boolean accessDaChange = ServletUtils.isCheckBoxEnabled((String)accessDaChangeTmp);
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentSA == null) {
                parentSA = 0;
            }
            Boolean useIdSogg = parentSA == 1;
            Parameter pSA = new Parameter("idsil", idsil);
            if (useIdSogg.booleanValue()) {
                Parameter pProvider = new Parameter("provider", idProvider);
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiRuoli", (Parameter[])new Parameter[]{pSA, pProvider});
            } else {
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiRuoli", (Parameter[])new Parameter[]{pSA, new Parameter("accessoDaChange", accessDaChangeTmp)});
            }
            int idLista = Liste.SERVIZIO_APPLICATIVO_RUOLI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            int idSilInt = Integer.parseInt(idsil);
            ServizioApplicativo sa = this.saCore.getServizioApplicativo(idSilInt);
            String nomeservizioApplicativo = sa.getNome();
            String tipoENomeSoggetto = null;
            String nomeProtocollo = null;
            if (useIdSogg.booleanValue()) {
                Soggetto tmpSogg;
                if (this.core.isRegistroServiziLocale()) {
                    tmpSogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idProvider));
                    nomeProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tipoENomeSoggetto = this.getLabelNomeSoggetto(nomeProtocollo, tmpSogg.getTipo(), tmpSogg.getNome());
                } else {
                    tmpSogg = this.soggettiCore.getSoggetto(Integer.parseInt(idProvider));
                    nomeProtocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tipoENomeSoggetto = this.getLabelNomeSoggetto(nomeProtocollo, tmpSogg.getTipo(), tmpSogg.getNome());
                }
            }
            ArrayList<Parameter> listSA = new ArrayList<Parameter>();
            listSA.add(new Parameter("id", idsil));
            listSA.add(new Parameter("idsil", idsil));
            if (useIdSogg.booleanValue()) {
                listSA.add(new Parameter("provider", idProvider));
            }
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!this.isModalitaCompleta()) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            if (accessDaChange) {
                ServletUtils.setPageDataTitle_ServletFirst((PageData)this.pd, (String)labelApplicativi, (String)"serviziApplicativiList.do");
                ServletUtils.appendPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(nomeservizioApplicativo, "serviziApplicativiChange.do", new Parameter[]{new Parameter("id", "" + sa.getId()), new Parameter("provider", "" + sa.getIdSoggetto())})});
                ServletUtils.appendPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Ruoli", null)});
            } else if (!useIdSogg.booleanValue()) {
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(labelApplicativi, "serviziApplicativiList.do"), new Parameter("Ruoli di " + nomeservizioApplicativo, "serviziApplicativiChange.do", listSA)});
                } else {
                    ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(labelApplicativi, "serviziApplicativiList.do"), new Parameter("Ruoli di " + nomeservizioApplicativo, "serviziApplicativiChange.do", listSA), new Parameter("Risultati ricerca", null)});
                }
            } else {
                ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
                lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                lstParam.add(new Parameter(labelApplicativiDi + tipoENomeSoggetto, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", idProvider)}));
                if (search.equals("")) {
                    this.pd.setSearchDescription("");
                    lstParam.add(new Parameter("Ruoli di " + nomeservizioApplicativo, "serviziApplicativiChange.do", listSA));
                } else {
                    lstParam.add(new Parameter("Ruoli di " + nomeservizioApplicativo, "serviziApplicativiChange.do", listSA));
                    lstParam.add(new Parameter("Risultati ricerca", null));
                }
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParam.toArray(new Parameter[lstParam.size()]));
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Ruoli", (String)search);
            }
            String[] labels = new String[]{"Nome"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (String ruolo : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    DataElement de = new DataElement();
                    de.setValue(ruolo);
                    de.setIdToRemove(ruolo);
                    if (!this.isModalitaCompleta()) {
                        Ruolo ruoloObj = this.ruoliCore.getRuolo(ruolo);
                        Parameter pIdRuolo = new Parameter("ruoloId", "" + ruoloObj.getId());
                        String url = new Parameter("", "ruoliChange.do", new Parameter[]{pIdRuolo}).getValue();
                        String tooltip = ruolo;
                        this.newDataElementVisualizzaInNuovoTab(de, url, tooltip);
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<Parameter> getTitoloSA(Integer parentSA, String idsogg, String idAsps, String idPorta) throws Exception, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (parentSA == null) {
            throw new Exception("Param parentSA is null");
        }
        if (idsogg == null) {
            throw new Exception("Param idsogg is null");
        }
        String soggettoTitle = null;
        if (this.core.isRegistroServiziLocale()) {
            Soggetto mySogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idsogg));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(mySogg.getTipo());
            soggettoTitle = this.getLabelNomeSoggetto(protocollo, mySogg.getTipo(), mySogg.getNome());
        } else {
            org.openspcoop2.core.config.Soggetto mySogg = this.soggettiCore.getSoggetto(Integer.parseInt(idsogg));
            String protocollo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(mySogg.getTipo());
            soggettoTitle = this.getLabelNomeSoggetto(protocollo, mySogg.getTipo(), mySogg.getNome());
        }
        return this._getTitoloSA(parentSA, idsogg, idAsps, soggettoTitle, idPorta);
    }

    private List<Parameter> _getTitoloSA(Integer parentSA, String idsogg, String idAsps, String soggettoTitle, String idPorta) throws Exception, DriverRegistroServiziNotFound, DriverRegistroServiziException {
        if (parentSA == null) {
            throw new Exception("Param parentSA is null");
        }
        ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
        switch (parentSA) {
            case 2: {
                AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
                String servizioTmpTile = this.getLabelIdServizio(asps);
                Parameter pIdServizio = new Parameter("id", "" + asps.getId());
                Parameter pNomeServizio = new Parameter("nomeservizio", asps.getNome());
                Parameter pTipoServizio = new Parameter("tiposervizio", asps.getTipo());
                Parameter pIdsoggErogatore = new Parameter("idSoggErogatore", "" + asps.getIdSoggetto());
                Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)this.session, (HttpServletRequest)this.request).getValue();
                if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                    lstParam.add(new Parameter("Erogazioni", "aspsErogazioniList.do"));
                    lstParam.add(new Parameter(servizioTmpTile, "aspsErogazioniChange.do", new Parameter[]{pIdServizio, pNomeServizio, pTipoServizio}));
                } else {
                    lstParam.add(new Parameter("Erogazioni", "accordiServizioParteSpecificaList.do"));
                }
                lstParam.add(new Parameter("Configurazione", "accordiServizioParteSpecificaPorteApplicativeList.do", new Parameter[]{pIdServizio, pNomeServizio, pTipoServizio, pIdsoggErogatore}));
                break;
            }
            case 1: {
                lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                lstParam.add(new Parameter("Servizi Applicativi di " + soggettoTitle, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", idsogg)}));
                break;
            }
            default: {
                String labelApplicativi = "Servizi Applicativi";
                if (!this.isModalitaCompleta()) {
                    labelApplicativi = "Applicativi";
                }
                lstParam.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
            }
        }
        return lstParam;
    }

    public void impostaSADefaultAlleConfigurazioniCheUsanoConnettoreDelMappingDiDefault(String idAsps, PortaApplicativa pa, ServizioApplicativo sa, List<Object> oggettiDaAggiornare) throws DriverConfigurazioneException, Exception, DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverConfigurazioneNotFound {
        MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(pa);
        if (mappingErogazionePortaApplicativa.isDefault()) {
            String nomeSA = sa.getNome();
            String tipoSA = sa.getTipo();
            String servizioApplicativoDefault = pa.getServizioApplicativoDefault();
            List<Object> listaMappingErogazionePortaApplicativa = new ArrayList();
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa2 : listaMappingErogazionePortaApplicativa) {
                PortaApplicativa portaApplicativaTmp;
                if (mappingErogazionePortaApplicativa2.isDefault() || (portaApplicativaTmp = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa2.getIdPortaApplicativa())).getServizioApplicativoDefault() == null || servizioApplicativoDefault == null || !portaApplicativaTmp.getServizioApplicativoDefault().equals(servizioApplicativoDefault)) continue;
                PortaApplicativaServizioApplicativo paSAtmpInner = null;
                for (PortaApplicativaServizioApplicativo paSAInner : portaApplicativaTmp.getServizioApplicativoList()) {
                    if (!paSAInner.getNome().equals(nomeSA)) continue;
                    paSAtmpInner = paSAInner;
                    break;
                }
                if (paSAtmpInner != null && "server".equals(tipoSA)) {
                    portaApplicativaTmp.getServizioApplicativoList().remove(paSAtmpInner);
                }
                PortaApplicativaServizioApplicativo paSAInner = new PortaApplicativaServizioApplicativo();
                paSAInner.setNome(servizioApplicativoDefault);
                portaApplicativaTmp.getServizioApplicativoList().add(paSAInner);
                portaApplicativaTmp.setServizioApplicativoDefault(null);
                oggettiDaAggiornare.add(portaApplicativaTmp);
            }
        }
    }

    public void impostaSAServerAlleConfigurazioniCheUsanoConnettoreDelMappingDiDefault(String idAsps, String nuovoSAServer, PortaApplicativa pa, ServizioApplicativo sa, List<Object> oggettiDaAggiornare) throws DriverConfigurazioneException, Exception, DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverConfigurazioneNotFound {
        MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = this.porteApplicativeCore.getMappingErogazionePortaApplicativa(pa);
        if (mappingErogazionePortaApplicativa.isDefault()) {
            String servizioApplicativoDefault = pa.getServizioApplicativoDefault();
            List<Object> listaMappingErogazionePortaApplicativa = new ArrayList();
            AccordoServizioParteSpecifica asps = this.apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
            IDServizio idServizio = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
            listaMappingErogazionePortaApplicativa = this.apsCore.mappingServiziPorteAppList(idServizio, asps.getId(), null);
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa2 : listaMappingErogazionePortaApplicativa) {
                PortaApplicativa portaApplicativaTmp;
                if (mappingErogazionePortaApplicativa2.isDefault() || ((portaApplicativaTmp = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa2.getIdPortaApplicativa())).getServizioApplicativoDefault() != null || servizioApplicativoDefault != null) && (portaApplicativaTmp.getServizioApplicativoDefault() == null || servizioApplicativoDefault == null || !portaApplicativaTmp.getServizioApplicativoDefault().equals(servizioApplicativoDefault))) continue;
                PortaApplicativaServizioApplicativo paSAtmpInner = null;
                for (PortaApplicativaServizioApplicativo paSAInner : portaApplicativaTmp.getServizioApplicativoList()) {
                    if (!paSAInner.getNome().equals(sa.getNome())) continue;
                    paSAtmpInner = paSAInner;
                    break;
                }
                if (paSAtmpInner != null) {
                    if ("server".equals(sa.getTipo())) {
                        portaApplicativaTmp.getServizioApplicativoList().remove(paSAtmpInner);
                    } else {
                        portaApplicativaTmp.getServizioApplicativoList().remove(paSAtmpInner);
                        portaApplicativaTmp.setServizioApplicativoDefault(sa.getNome());
                    }
                }
                PortaApplicativaServizioApplicativo paSAInner = new PortaApplicativaServizioApplicativo();
                paSAInner.setNome(nuovoSAServer);
                portaApplicativaTmp.getServizioApplicativoList().add(paSAInner);
                oggettiDaAggiornare.add(portaApplicativaTmp);
            }
        }
    }

    public static String[] toArray(List<IDServizioApplicativoDB> listIDSa) {
        if (listIDSa == null || listIDSa.isEmpty()) {
            return null;
        }
        String[] l = new String[listIDSa.size()];
        for (int i = 0; i < listIDSa.size(); ++i) {
            l[i] = listIDSa.get(i).getNome();
        }
        return l;
    }

    public void prepareServizioApplicativoCredenzialiList(ServizioApplicativo sa, String id) throws Exception {
        try {
            boolean modalitaCompleta = this.isModalitaCompleta();
            String idProvider = this.getParameter("provider");
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentSA == null) {
                parentSA = 0;
            }
            Boolean useIdSogg = parentSA == 1;
            IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
            Soggetto soggettoProprietario = this.soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
            String dominio = this.pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
            ArrayList<Parameter> parametersServletSAChange = new ArrayList<Parameter>();
            Parameter pIdSA = new Parameter("id", "" + sa.getId());
            parametersServletSAChange.add(pIdSA);
            Parameter pIdSoggettoSA = new Parameter("provider", "" + sa.getIdSoggetto());
            parametersServletSAChange.add(pIdSoggettoSA);
            if (dominio != null) {
                Parameter pDominio = new Parameter("dominio", dominio);
                parametersServletSAChange.add(pDominio);
            }
            if (useIdSogg.booleanValue()) {
                Parameter pProvider = new Parameter("provider", idProvider);
                ArrayList<Parameter> parametersServletSAChangeProvider = new ArrayList<Parameter>();
                parametersServletSAChangeProvider.add(pProvider);
                parametersServletSAChangeProvider.addAll(parametersServletSAChange);
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiCredenziali", (Parameter[])parametersServletSAChangeProvider.toArray(new Parameter[parametersServletSAChangeProvider.size()]));
            } else {
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiCredenziali", (Parameter[])parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()]));
            }
            String tmpTitle = null;
            String protocolloSoggetto = null;
            boolean supportAsincroni = true;
            if (useIdSogg.booleanValue()) {
                Soggetto tmpSogg;
                if (this.core.isRegistroServiziLocale()) {
                    tmpSogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                } else {
                    tmpSogg = this.soggettiCore.getSoggetto(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                }
                List<ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(protocolloSoggetto);
                for (ServiceBinding serviceBinding : serviceBindingListProtocollo) {
                    supportAsincroni = this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) || this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                }
                if (!supportAsincroni && this.isModalitaAvanzata()) {
                    supportAsincroni = this.core.isElenchiSAAsincroniNonSupportatiVisualizzaRispostaAsincrona();
                }
            }
            this.pd.setIndex(0);
            this.pd.setPageSize(sa.getInvocazionePorta().sizeCredenzialiList());
            this.pd.setNumEntries(sa.getInvocazionePorta().sizeCredenzialiList());
            ServletUtils.disabledPageDataSearch((PageData)this.pd);
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!modalitaCompleta) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            if (!useIdSogg.booleanValue()) {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter(labelApplicativi, "serviziApplicativiList.do"), new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])), new Parameter("Certificati", null)});
            } else {
                String provider = this.getParameter("provider");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Soggetti", "soggettiList.do"), new Parameter(labelApplicativiDi + tmpTitle, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", provider)}), new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])), new Parameter("Certificati", null)});
            }
            ArrayList<String> labels = new ArrayList<String>();
            labels.add("Principale");
            labels.add("Subject");
            labels.add("Issuer");
            labels.add("Verifica");
            labels.add("Not Before");
            labels.add("Not After");
            this.pd.setLabels(labels.toArray(new String[1]));
            ArrayList dati = new ArrayList();
            List lista = sa.getInvocazionePorta().getCredenzialiList();
            int i = 0;
            if (lista != null) {
                Iterator it = lista.iterator();
                while (it.hasNext()) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Credenziali credenziali = (Credenziali)it.next();
                    Certificate cSelezionato = ArchiveLoader.load((byte[])credenziali.getCertificate());
                    String tipoCredenzialiSSLAliasCertificatoIssuer = cSelezionato.getCertificate().getIssuer().getNameNormalized();
                    String tipoCredenzialiSSLAliasCertificatoSubject = cSelezionato.getCertificate().getSubject().getNameNormalized();
                    boolean verificaTuttiCampi = credenziali.getCertificateStrictVerification();
                    Date notBefore = cSelezionato.getCertificate().getNotBefore();
                    String tipoCredenzialiSSLAliasCertificatoNotBefore = this.getSdfCredenziali().format(notBefore);
                    Date notAfter = cSelezionato.getCertificate().getNotAfter();
                    String tipoCredenzialiSSLAliasCertificatoNotAfter = this.getSdfCredenziali().format(notAfter);
                    Parameter pIdCredenziale = new Parameter("idCred", "" + i);
                    ArrayList<Parameter> parametersServletCredenzialeChange = new ArrayList<Parameter>();
                    parametersServletCredenzialeChange.add(pIdCredenziale);
                    parametersServletCredenzialeChange.addAll(parametersServletSAChange);
                    parametersServletCredenzialeChange.add(new Parameter("confSSLCredFileCertUpdate", "yes"));
                    DataElement de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setValue(i == 0 ? "Si" : "No");
                    de.allineaTdAlCentro();
                    de.setWidthPx(60);
                    e.add(de);
                    de = new DataElement();
                    de.setUrl("serviziApplicativiCredenzialiChange.do", parametersServletCredenzialeChange.toArray(new Parameter[parametersServletCredenzialeChange.size()]));
                    de.setSize(60);
                    de.setValue(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoSubject));
                    de.setToolTip(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoSubject));
                    de.setIdToRemove("" + i);
                    e.add(de);
                    de = new DataElement();
                    Object issuerValue = StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoIssuer);
                    if (((String)issuerValue).length() > 60) {
                        issuerValue = ((String)issuerValue).substring(0, 57) + "...";
                    }
                    de.setValue((String)issuerValue);
                    de.setToolTip(StringEscapeUtils.escapeHtml((String)tipoCredenzialiSSLAliasCertificatoIssuer));
                    e.add(de);
                    de = new DataElement();
                    de.setType(DataElementType.TEXT);
                    de.setValue(verificaTuttiCampi ? "Certificato" : "Subject/Issuer");
                    de.allineaTdAlCentro();
                    de.setWidthPx(70);
                    e.add(de);
                    de = new DataElement();
                    if (verificaTuttiCampi) {
                        de.setValue(tipoCredenzialiSSLAliasCertificatoNotBefore);
                    } else {
                        de.setValue("-");
                    }
                    de.setType(DataElementType.TEXT);
                    de.allineaTdAlCentro();
                    de.setWidthPx(140);
                    if (verificaTuttiCampi && notBefore.after(new Date())) {
                        de.setLabelStyleClass("spanNoEdit-bold");
                        de.setWidthPx(150);
                    }
                    e.add(de);
                    de = new DataElement();
                    if (verificaTuttiCampi) {
                        de.setValue(tipoCredenzialiSSLAliasCertificatoNotAfter);
                    } else {
                        de.setValue("-");
                    }
                    de.setType(DataElementType.TEXT);
                    de.allineaTdAlCentro();
                    de.setWidthPx(140);
                    if (verificaTuttiCampi && notAfter.before(new Date())) {
                        de.setLabelStyleClass("spanNoEdit-bold-red");
                        de.setWidthPx(150);
                    }
                    e.add(de);
                    dati.add(e);
                    ++i;
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<DataElement> addServizioApplicativoHiddenToDati(List<DataElement> dati, String idSA, String idSoggettoSA, String dominio, String nomeSA) throws Exception {
        DataElement de = new DataElement();
        de.setLabel("id");
        de.setValue(idSA);
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        dati.add(de);
        if (idSoggettoSA != null) {
            de = new DataElement();
            de.setLabel("provider");
            de.setValue(idSoggettoSA);
            de.setType(DataElementType.HIDDEN);
            de.setName("provider");
            dati.add(de);
        }
        if (dominio != null) {
            de = new DataElement();
            de.setLabel("dominio");
            de.setValue(dominio);
            de.setType(DataElementType.HIDDEN);
            de.setName("dominio");
            dati.add(de);
        }
        if (nomeSA != null) {
            de = new DataElement();
            de.setLabel("nome");
            de.setValue(nomeSA);
            de.setType(DataElementType.HIDDEN);
            de.setName("nome");
            dati.add(de);
        }
        return dati;
    }

    public boolean servizioApplicativoCredenzialiCertificatiCheckData(TipoOperazione tipoOperazione, long idProvOld, ServizioApplicativo saOld, int idxCertificato, String protocollo, int idxCredenziale) throws Exception {
        try {
            ServizioApplicativo saCheck;
            Credenziali c;
            String tipoCredenzialiSSLConfigurazioneManualeSelfSigned;
            String tipoCredenzialiSSLSorgente;
            String nome = this.getParameter("nome");
            String provider = this.getParameter("provider");
            int newProv = 0;
            if (provider != null) {
                newProv = Integer.parseInt(provider);
            }
            if ((tipoCredenzialiSSLSorgente = this.getParameter("confSSLCredenziali")) == null) {
                tipoCredenzialiSSLSorgente = "confMan";
            }
            if ((tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter("confSSLManSS")) == null) {
                tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "yes";
            }
            String subject = this.getParameter("subjectCredenziali");
            String issuer = this.getParameter("subjectIssuer");
            if ("".equals(issuer)) {
                issuer = null;
            }
            boolean tokenWithHttpsEnabledByConfigSA = false;
            if (saOld != null && saOld.getInvocazionePorta() != null && saOld.getInvocazionePorta().sizeCredenzialiList() > 0 && (c = saOld.getInvocazionePorta().getCredenziali(0)) != null && c.getTokenPolicy() != null && StringUtils.isNotEmpty((String)c.getTokenPolicy())) {
                tokenWithHttpsEnabledByConfigSA = true;
            }
            boolean dominioEsternoModI = false;
            if (saOld != null) {
                Soggetto soggetto = this.soggettiCore.getSoggettoRegistro(saOld.getIdSoggetto());
                dominioEsternoModI = this.isProfiloModIPA(protocollo) && this.pddCore.isPddEsterna(soggetto.getPortaDominio());
            }
            String details = "";
            List<ServizioApplicativo> saList = null;
            String tipoSsl = null;
            Certificate cSelezionato = null;
            boolean strictVerifier = false;
            if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                saList = this.saCore.servizioApplicativoWithCredenzialiSslList(subject, issuer, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                tipoSsl = "subject/issuer";
            } else {
                List<ServizioApplicativo> saListCheck;
                BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter("confSSLCredFileCert");
                String tipoCredenzialiSSLVerificaTuttiICampi = this.getParameter("confSSLCredVerifTutti");
                strictVerifier = ServletUtils.isCheckBoxEnabled((String)tipoCredenzialiSSLVerificaTuttiICampi);
                String tipoCredenzialiSSLTipoArchivioS = this.getParameter("confSSLCredTipoArch");
                String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter("confSSLCredFileCertPwd");
                String tipoCredenzialiSSLAliasCertificato = this.getParameter("confSSLCredAliasCert");
                if (tipoCredenzialiSSLAliasCertificato == null) {
                    tipoCredenzialiSSLAliasCertificato = "";
                }
                ArchiveType tipoCredenzialiSSLTipoArchivio = null;
                tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
                byte[] archivio = tipoCredenzialiSSLFileCertificato.getValue();
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && archivio == null) {
                    archivio = saOld.getInvocazionePorta().getCredenziali(idxCertificato).getCertificate();
                }
                cSelezionato = tipoCredenzialiSSLTipoArchivio.equals((Object)ArchiveType.CER) ? ArchiveLoader.load((byte[])archivio) : ArchiveLoader.load((ArchiveType)tipoCredenzialiSSLTipoArchivio, (byte[])archivio, (String)tipoCredenzialiSSLAliasCertificato, (String)tipoCredenzialiSSLFileCertificatoPassword);
                saList = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps());
                if (!(strictVerifier || saList == null || saList.isEmpty() || (saListCheck = this.saCore.servizioApplicativoWithCredenzialiSslList(cSelezionato.getCertificate(), true, dominioEsternoModI ? ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiModIFirma() : ConfigurazioneFiltroServiziApplicativi.getFiltroApplicativiHttps())) != null && !saListCheck.isEmpty())) {
                    details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                }
                tipoSsl = "certificato";
            }
            String portaDominio = null;
            if (this.core.isRegistroServiziLocale()) {
                Soggetto soggettoToCheck = tipoOperazione.equals((Object)TipoOperazione.CHANGE) ? this.soggettiCore.getSoggettoRegistro(idProvOld) : this.soggettiCore.getSoggettoRegistro(newProv);
                portaDominio = soggettoToCheck.getPortaDominio();
            }
            if (saList != null && !tokenWithHttpsEnabledByConfigSA) {
                for (int i = 0; i < saList.size(); ++i) {
                    Soggetto tmpSoggettoProprietarioSa;
                    ServizioApplicativo sa = saList.get(i);
                    if (!this.core.isSinglePdD() && !portaDominio.equals((tmpSoggettoProprietarioSa = this.soggettiCore.getSoggettoRegistro(sa.getIdSoggetto())).getPortaDominio()) || tipoOperazione.equals((Object)TipoOperazione.CHANGE) && nome.equals(sa.getNome()) && idProvOld == sa.getIdSoggetto() || saOld != null && tipoOperazione.equals((Object)TipoOperazione.CHANGE) && saOld.getId().longValue() == sa.getId().longValue()) continue;
                    String labelSoggetto = this.getLabelNomeSoggetto(new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario()));
                    this.pd.setMessage("L'applicativo " + sa.getNome() + " (soggetto: " + labelSoggetto + ") possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                    return false;
                }
            }
            if (!(tokenWithHttpsEnabledByConfigSA || this.soggettiCore.isSoggettiApplicativiCredenzialiSslPermitSameCredentials() || dominioEsternoModI)) {
                details = "";
                Soggetto soggettoAutenticato = null;
                List<Soggetto> soggettiAutenticati = null;
                if (tipoCredenzialiSSLSorgente.equals("confMan")) {
                    soggettoAutenticato = this.soggettiCore.getSoggettoRegistroAutenticatoSsl(subject, issuer);
                    tipoSsl = "subject/issuer";
                } else {
                    soggettiAutenticati = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), strictVerifier);
                    if (soggettiAutenticati != null && !soggettiAutenticati.isEmpty()) {
                        List<Soggetto> soggettiAutenticatiCheck;
                        soggettoAutenticato = soggettiAutenticati.get(0);
                        if (!strictVerifier && ((soggettiAutenticatiCheck = this.soggettiCore.soggettoWithCredenzialiSslList(cSelezionato.getCertificate(), true)) == null || soggettiAutenticatiCheck.isEmpty())) {
                            details = "<br/><br/><b>Nota:</b> Il certiticato selezionato possiede un serial number diverso da quello del certificato gi\u00e0 in uso. Abilita l'opzione 'Verifica' per consentire la distinzione tra i due certificati.<br>";
                        }
                    }
                    tipoSsl = "certificato";
                }
                if (soggettoAutenticato != null) {
                    String labelSoggettoAutenticato = this.getLabelNomeSoggetto(new IDSoggetto(soggettoAutenticato.getTipo(), soggettoAutenticato.getNome()));
                    this.pd.setMessage("Il soggetto " + labelSoggettoAutenticato + " possiede gi\u00e0 le credenziali ssl (" + tipoSsl + ") indicate." + details);
                    return false;
                }
            }
            String actionConfirm = this.getParameter("actionConfirm");
            boolean promuoviInCorso = false;
            if (actionConfirm != null && actionConfirm.equals("ok")) {
                promuoviInCorso = true;
            }
            String aggiornatoCertificatoPrecaricatoTmp = this.getParameter("confSSLCredFileCertUpdate");
            boolean aggiornatoCertificatoPrecaricato = ServletUtils.isCheckBoxEnabled((String)aggiornatoCertificatoPrecaricatoTmp);
            if (!promuoviInCorso && !aggiornatoCertificatoPrecaricato && cSelezionato != null && saOld != null && (saCheck = saOld).getInvocazionePorta() != null && saCheck.getInvocazionePorta().sizeCredenzialiList() > 0) {
                int i = 0;
                for (Credenziali c2 : saCheck.getInvocazionePorta().getCredenzialiList()) {
                    Certificate check = ArchiveLoader.load((byte[])c2.getCertificate());
                    if (check.getCertificate().equals((Object)cSelezionato.getCertificate()) && i != idxCredenziale) {
                        this.pd.setMessage("Il certificato selezionato risulta gi\u00e0 associato all'applicativo");
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<DataElement> addProprietaToDati(TipoOperazione tipoOp, int size, String nome, String valore, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Propriet&agrave;");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("propNome");
        de.setSize(size);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("propValore");
        this.core.getLockUtilities().lockProperty(de, valore);
        de.setRequired(true);
        de.setSize(size);
        dati.add(de);
        return dati;
    }

    public boolean serviziApplicativiProprietaCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String id = this.getParameter("id");
            int idServizioApplicativo = Integer.parseInt(id);
            String nome = this.getParameter("propNome");
            String valore = this.getLockedParameter("propValore", false);
            if (nome.equals("") || valore.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (valore.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Valore" : (String)tmpElenco + ", Valore";
                }
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", tmpElenco));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nei campi di testo");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (!this.core.getDriverBYOKUtilities().isEnabledBYOK() || !this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(valore)) {
                if (valore.indexOf(" ") != -1) {
                    this.pd.setMessage("Non inserire spazi nei campi di testo");
                    return false;
                }
                if (!this.checkLength4000(valore, "Valore")) {
                    return false;
                }
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                boolean giaRegistrato = false;
                ServizioApplicativo sa = this.saCore.getServizioApplicativo(idServizioApplicativo);
                String nomeporta = sa.getNome();
                for (int i = 0; i < sa.sizeProprietaList(); ++i) {
                    Proprieta tmpProp = sa.getProprieta(i);
                    if (!nome.equals(tmpProp.getNome())) continue;
                    giaRegistrato = true;
                    break;
                }
                if (giaRegistrato) {
                    this.pd.setMessage(MessageFormat.format("La propriet&agrave; {0} &egrave; gi&agrave; stata associata all''applicativo {1}", nome, nomeporta));
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void prepareServiziApplicativiProprietaList(ServizioApplicativo sa, ConsoleSearch ricerca, List<Proprieta> lista) throws DriverControlStationException {
        try {
            boolean modalitaCompleta = this.isModalitaCompleta();
            String idProvider = this.getParameter("provider");
            Integer parentSA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)this.session, (HttpServletRequest)this.request);
            if (parentSA == null) {
                parentSA = 0;
            }
            Boolean useIdSogg = parentSA == 1;
            IDSoggetto idSoggettoProprietario = new IDSoggetto(sa.getTipoSoggettoProprietario(), sa.getNomeSoggettoProprietario());
            Soggetto soggettoProprietario = this.soggettiCore.getSoggettoRegistro(idSoggettoProprietario);
            String dominio = this.pddCore.isPddEsterna(soggettoProprietario.getPortaDominio()) ? SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE : SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE;
            ArrayList<Parameter> parametersServletSAChange = new ArrayList<Parameter>();
            Parameter pIdSA = new Parameter("id", "" + sa.getId());
            parametersServletSAChange.add(pIdSA);
            Parameter pIdSoggettoSA = new Parameter("provider", "" + sa.getIdSoggetto());
            parametersServletSAChange.add(pIdSoggettoSA);
            if (dominio != null) {
                Parameter pDominio = new Parameter("dominio", dominio);
                parametersServletSAChange.add(pDominio);
            }
            if (useIdSogg != null && useIdSogg.booleanValue()) {
                Parameter pProvider = new Parameter("provider", idProvider);
                ArrayList<Parameter> parametersServletSAChangeProvider = new ArrayList<Parameter>();
                parametersServletSAChangeProvider.add(pProvider);
                parametersServletSAChangeProvider.addAll(parametersServletSAChange);
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiProprieta", (Parameter[])parametersServletSAChangeProvider.toArray(new Parameter[parametersServletSAChangeProvider.size()]));
            } else {
                ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"serviziApplicativiProprieta", (Parameter[])parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()]));
            }
            int idLista = Liste.SERVIZI_APPLICATIVI_PROP;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            String tmpTitle = null;
            String protocolloSoggetto = null;
            boolean supportAsincroni = true;
            if (useIdSogg != null && useIdSogg.booleanValue()) {
                Soggetto tmpSogg;
                if (this.core.isRegistroServiziLocale()) {
                    tmpSogg = this.soggettiCore.getSoggettoRegistro(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                } else {
                    tmpSogg = this.soggettiCore.getSoggetto(Integer.parseInt(idProvider));
                    protocolloSoggetto = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tmpSogg.getTipo());
                    tmpTitle = this.getLabelNomeSoggetto(protocolloSoggetto, tmpSogg.getTipo(), tmpSogg.getNome());
                }
                List<ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(protocolloSoggetto);
                for (ServiceBinding serviceBinding : serviceBindingListProtocollo) {
                    supportAsincroni = this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_ASIMMETRICO) || this.core.isProfiloDiCollaborazioneSupportatoDalProtocollo(protocolloSoggetto, serviceBinding, ProfiloDiCollaborazione.ASINCRONO_SIMMETRICO);
                }
                if (!supportAsincroni && this.isModalitaAvanzata()) {
                    supportAsincroni = this.core.isElenchiSAAsincroniNonSupportatiVisualizzaRispostaAsincrona();
                }
            }
            if (supportAsincroni) {
                // empty if block
            }
            String labelApplicativi = "Servizi Applicativi";
            String labelApplicativiDi = "Servizi Applicativi di ";
            if (!modalitaCompleta) {
                labelApplicativi = "Applicativi";
                labelApplicativiDi = "Applicativi di ";
            }
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            if (useIdSogg == null || !useIdSogg.booleanValue()) {
                lstParam.add(new Parameter(labelApplicativi, "serviziApplicativiList.do"));
                lstParam.add(new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])));
            } else {
                String provider = this.getParameter("provider");
                lstParam.add(new Parameter("Soggetti", "soggettiList.do"));
                lstParam.add(new Parameter(labelApplicativiDi + tmpTitle, "serviziApplicativiList.do", new Parameter[]{new Parameter("provider", provider)}));
                lstParam.add(new Parameter(sa.getNome(), "serviziApplicativiChange.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])));
            }
            this.pd.setSearchLabel("Nome");
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                lstParam.add(new Parameter("Propriet&agrave;", null));
            } else {
                lstParam.add(new Parameter("Propriet&agrave;", "serviziApplicativiProprietaList.do", parametersServletSAChange.toArray(new Parameter[parametersServletSAChange.size()])));
                lstParam.add(new Parameter("Risultati ricerca", null));
            }
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParam.toArray(new Parameter[lstParam.size()]));
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Propriet&agrave;", (String)search);
            }
            String valueLabel = "Valore";
            String[] labels = new String[]{"Nome", valueLabel};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (lista != null) {
                for (Proprieta ssp : lista) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    Parameter pNomeProprieta = new Parameter("propNome", ssp.getNome());
                    ArrayList<Parameter> parametersServletProprietaChange = new ArrayList<Parameter>();
                    parametersServletProprietaChange.add(pNomeProprieta);
                    parametersServletProprietaChange.addAll(parametersServletSAChange);
                    DataElement de = new DataElement();
                    de.setUrl("serviziApplicativiProprietaChange.do", parametersServletProprietaChange.toArray(new Parameter[parametersServletProprietaChange.size()]));
                    de.setValue(ssp.getNome());
                    de.setIdToRemove(ssp.getNome());
                    e.add(de);
                    de = new DataElement();
                    if (ssp.getValore() != null) {
                        if (StringUtils.isNotEmpty((String)ssp.getValore()) && BYOKManager.isEnabledBYOK() && this.core.getDriverBYOKUtilities().isWrappedWithAnyPolicy(ssp.getValore())) {
                            de.setValue("******");
                        } else {
                            de.setValue(ssp.getValore());
                        }
                    }
                    e.add(de);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void addDescrizioneVerificaConnettivitaToDati(List<DataElement> dati, Connettore connettore, String server, String aliasConnettore) throws Exception {
        ArrayList<Parameter> downloadCertServerParameters = new ArrayList<Parameter>();
        downloadCertServerParameters.add(new Parameter("idConn", "" + connettore.getId()));
        this.addDescrizioneVerificaConnettivitaToDati(dati, connettore, server, false, aliasConnettore, downloadCertServerParameters, true, false);
    }
}

