/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ruoli;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class RuoliHelper
extends ConsoleHelper {
    public static final int POSIZIONE_FILTRO_PROTOCOLLO = 3;

    public RuoliHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public RuoliHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public List<DataElement> addRuoloToDati(TipoOperazione tipoOP, Long ruoloId, String nome, String descrizione, String tipologia, String nomeEsterno, String contesto, List<DataElement> dati, String oldNomeRuolo) throws DriverConfigurazioneException {
        Ruolo ruolo = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOP) && oldNomeRuolo != null && StringUtils.isNotEmpty((String)oldNomeRuolo)) {
            ruolo = this.ruoliCore.getRuolo(oldNomeRuolo);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOP)) {
            ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
            Parameter pId = new Parameter("ruoloId", "" + ruoloId);
            listaParametriChange.add(pId);
            this.addComandoInUsoButton(nome, nome, InUsoType.RUOLO);
            if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
                listaParametriChange.add(new Parameter("rmElFromCache", "true"));
                this.pd.addComandoResetCacheElementoButton("ruoliChange.do", listaParametriChange);
            }
            if (ruolo != null && this.existsProprietaOggetto(ruolo.getProprietaOggetto(), ruolo.getDescrizione())) {
                this.addComandoProprietaOggettoButton(nome, nome, InUsoType.RUOLO);
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Ruolo");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (ruoloId != null) {
            de = new DataElement();
            de.setLabel("ruoloId");
            de.setValue("" + ruoloId);
            de.setType(DataElementType.HIDDEN);
            de.setName("ruoloId");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("ruoloNome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("ruoloDescrizione");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Fonte");
        de.setType(DataElementType.SELECT);
        de.setName("ruoloTipologia");
        de.setLabels(RuoliCostanti.getRuoliTipologiaLabel());
        de.setValues(RuoliCostanti.getRuoliTipologia());
        de.setSelected(tipologia);
        de.setPostBack(true);
        dati.add(de);
        RuoloTipologia ruoloTipologia = null;
        if (tipologia != null) {
            try {
                ruoloTipologia = RuoloTipologia.toEnumConstant((String)tipologia, (boolean)false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        de = new DataElement();
        de.setLabel("Identificativo Esterno");
        de.setValue(nomeEsterno);
        if (ruoloTipologia != null && (RuoloTipologia.QUALSIASI.equals((Object)ruoloTipologia) || RuoloTipologia.ESTERNO.equals((Object)ruoloTipologia))) {
            de.setType(DataElementType.TEXT_EDIT);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("ruoloNomeEsterno");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Contesto");
        de.setType(DataElementType.SELECT);
        de.setName("ruoloContesto");
        de.setLabels(RuoliCostanti.getRuoliContestoUtilizzoLabel());
        de.setValues(RuoliCostanti.getRuoliContestoUtilizzo());
        de.setSelected(contesto);
        dati.add(de);
        return dati;
    }

    public boolean ruoloCheckData(TipoOperazione tipoOp, Ruolo ruolo) throws Exception {
        try {
            String nome = this.getParameter("ruoloNome");
            String descrizione = this.getParameter("ruoloDescrizione");
            String nomeEsterno = this.getParameter("ruoloNomeEsterno");
            if (nome.equals("")) {
                String tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo 'Nome'");
                return false;
            }
            if (!this.checkNCName(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (nomeEsterno != null && !"".equals(nomeEsterno) && !this.checkLength255(nomeEsterno, "Identificativo Esterno")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (this.ruoliCore.existsRuolo(nome)) {
                    this.pd.setMessage("Un ruolo con nome '" + nome + "' risulta gi&agrave; stato registrato");
                    return false;
                }
            } else if (!ruolo.getNome().equals(nome) && this.ruoliCore.existsRuolo(nome)) {
                this.pd.setMessage("Un ruolo con nome '" + nome + "' risulta gi&agrave; stato registrato");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public void prepareRuoliList(ISearch ricerca, List<Ruolo> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"ruoli", (Parameter[])new Parameter[0]);
            boolean modalitaCompleta = this.isModalitaCompleta();
            if (!modalitaCompleta) {
                this.pd.setCustomListViewName("ruoli");
            }
            int idLista = Liste.RUOLI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterRuoloTipologia = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRuoloTipologia");
            this.addFilterRuoloTipologia(filterRuoloTipologia, false);
            String filterRuoloContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroRuoloContesto");
            this.addFilterRuoloContesto(filterRuoloContesto, false);
            String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
            this.addFilterApiContestoRuoli(filterApiContesto, true);
            String filterProtocollo = null;
            String filterSoggetto = null;
            boolean profiloSelezionato = false;
            if (filterApiContesto != null && !"".equals(filterApiContesto)) {
                List<String> protocolli;
                filterProtocollo = this.addFilterProtocol(ricerca, idLista, true);
                String protocollo = filterProtocollo;
                if (protocollo == null && (protocolli = this.core.getProtocolli(this.request, this.session)) != null && protocolli.size() == 1) {
                    protocollo = protocolli.get(0);
                }
                if (filterProtocollo != null && !"".equals(filterProtocollo) || filterProtocollo == null && protocollo != null) {
                    profiloSelezionato = true;
                }
                if ("Soggetti".equals(filterApiContesto)) {
                    filterSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    boolean soloSoggettiOperativi = false;
                    this.addFilterSoggetto(filterSoggetto, protocollo, soloSoggettiOperativi, true);
                } else if (profiloSelezionato && !this.isSoggettoMultitenantSelezionato()) {
                    filterSoggetto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggetto");
                    boolean soloSoggettiOperativi = true;
                    this.addFilterSoggetto(filterSoggetto, protocollo, soloSoggettiOperativi, true);
                } else {
                    filterSoggetto = this.getSoggettoMultitenantSelezionato();
                }
            }
            String filterGruppo = null;
            if (!(filterApiContesto == null || "".equals(filterApiContesto) || "Applicativi".equals(filterApiContesto) || "Soggetti".equals(filterApiContesto))) {
                filterGruppo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
                this.addFilterGruppo(filterProtocollo, filterGruppo, true);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroGruppo");
            }
            if (profiloSelezionato && filterApiContesto != null && !"".equals(filterApiContesto) && !"Applicativi".equals(filterApiContesto)) {
                String filterApiImplementazione = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
                this.addFilterApiImplementazione(filterProtocollo, filterSoggetto, filterGruppo, filterApiContesto, filterApiImplementazione, false);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiImpl");
            }
            if (profiloSelezionato && filterApiContesto != null && !"".equals(filterApiContesto) && "Applicativi".equals(filterApiContesto)) {
                String filterApplicativo = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSA");
                this.addFilterApplicativo(filterProtocollo, filterSoggetto, filterApplicativo, false);
            } else {
                SearchUtils.clearFilter((ISearch)ricerca, (int)idLista, (String)"filtroSA");
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Ruoli", "ruoliList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Ruoli", "ruoliList.do"), new Parameter("Risultati ricerca", null)});
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Ruoli", (String)search);
            }
            this.setLabelColonne(modalitaCompleta);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<Ruolo> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = modalitaCompleta ? this.creaEntry(it) : this.creaEntryCustom(it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.RUOLO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(RuoliCostanti.LABEL_RUOLI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private List<DataElement> creaEntry(Iterator<Ruolo> it) {
        Ruolo ruolo = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("ruoloId", "" + ruolo.getId());
        de.setUrl("ruoliChange.do", new Parameter[]{pId});
        de.setToolTip(ruolo.getDescrizione());
        de.setValue(ruolo.getNome());
        de.setIdToRemove(ruolo.getNome());
        de.setToolTip(ruolo.getDescrizione());
        de.setSize(this.core.getElenchiMenuIdentificativiLunghezzaMassima());
        e.add(de);
        de = new DataElement();
        if (RuoloTipologia.INTERNO.getValue().equals(ruolo.getTipologia().getValue())) {
            de.setValue("Registro");
        } else if (RuoloTipologia.ESTERNO.getValue().equals(ruolo.getTipologia().getValue())) {
            de.setValue("Esterna");
        } else {
            de.setValue("Qualsiasi");
        }
        e.add(de);
        de = new DataElement();
        if (RuoloContesto.PORTA_APPLICATIVA.getValue().equals(ruolo.getContestoUtilizzo().getValue())) {
            de.setValue("Erogazione");
        } else if (RuoloContesto.PORTA_DELEGATA.getValue().equals(ruolo.getContestoUtilizzo().getValue())) {
            de.setValue("Fruizione");
        } else {
            de.setValue("Qualsiasi");
        }
        e.add(de);
        return e;
    }

    private List<DataElement> creaEntryCustom(Iterator<Ruolo> it) {
        Ruolo ruolo = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("ruoloId", "" + ruolo.getId());
        de.setUrl("ruoliChange.do", new Parameter[]{pId});
        de.setToolTip(ruolo.getDescrizione());
        de.setValue(ruolo.getNome());
        de.setIdToRemove(ruolo.getNome());
        de.setToolTip(ruolo.getDescrizione());
        de.setType(DataElementType.TITLE);
        e.add(de);
        de = new DataElement();
        String tipologiaRuoloLabel = "";
        tipologiaRuoloLabel = RuoloTipologia.INTERNO.getValue().equals(ruolo.getTipologia().getValue()) ? "Registro" : (RuoloTipologia.ESTERNO.getValue().equals(ruolo.getTipologia().getValue()) ? "Esterna" : "Qualsiasi");
        String contestoRuoloLabel = "";
        contestoRuoloLabel = RuoloContesto.PORTA_APPLICATIVA.getValue().equals(ruolo.getContestoUtilizzo().getValue()) ? "Erogazione" : (RuoloContesto.PORTA_DELEGATA.getValue().equals(ruolo.getContestoUtilizzo().getValue()) ? "Fruizione" : "Qualsiasi");
        String identificativoEsternoLabelPrefix = "";
        if (ruolo.getNomeEsterno() != null) {
            identificativoEsternoLabelPrefix = MessageFormat.format("Identificativo Esterno: {0}, ", ruolo.getNomeEsterno());
        }
        de.setValue(identificativoEsternoLabelPrefix + MessageFormat.format("Fonte: {0}, Contesto: {1}", tipologiaRuoloLabel, contestoRuoloLabel));
        de.setType(DataElementType.SUBTITLE);
        e.add(de);
        ArrayList<Parameter> listaParametriChange = new ArrayList<Parameter>();
        listaParametriChange.add(pId);
        listaParametriChange.add(new Parameter("resetFromLista", "true"));
        this.addInUsoButton(e, ruolo.getNome(), ruolo.getNome(), InUsoType.RUOLO);
        if (this.core.isElenchiVisualizzaComandoResetCacheSingoloElemento()) {
            this.addComandoResetCacheButton(e, ruolo.getNome(), "ruoliChange.do", listaParametriChange);
        }
        this.addProprietaOggettoButton(e, ruolo.getNome(), ruolo.getNome(), InUsoType.RUOLO);
        return e;
    }

    private void setLabelColonne(boolean modalitaCompleta) {
        if (!modalitaCompleta) {
            String[] labels = new String[]{"Ruoli"};
            this.pd.setLabels(labels);
        } else {
            String[] labels = new String[]{"Nome", "Fonte", "Contesto"};
            this.pd.setLabels(labels);
        }
    }
}

