/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ruoli;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliUtilities;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class RuoliChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            RuoliHelper ruoliHelper = new RuoliHelper(request, pd, session);
            String id = ruoliHelper.getParameter("ruoloId");
            long ruoloId = Long.parseLong(id);
            String nome = ruoliHelper.getParameter("ruoloNome");
            String descrizione = ruoliHelper.getParameter("ruoloDescrizione");
            String tipologia = ruoliHelper.getParameter("ruoloTipologia");
            String nomeEsterno = ruoliHelper.getParameter("ruoloNomeEsterno");
            String contesto = ruoliHelper.getParameter("ruoloContesto");
            String resetElementoCacheS = ruoliHelper.getParameter("rmElFromCache");
            boolean resetElementoCache = ServletUtils.isCheckBoxEnabled((String)resetElementoCacheS);
            RuoliCore ruoliCore = new RuoliCore();
            ruoliHelper.makeMenu();
            Ruolo ruolo = ruoliCore.getRuolo(ruoloId);
            if (resetElementoCache) {
                List<String> aliases = ruoliCore.getJmxPdDAliases();
                String alias = null;
                if (aliases != null && !aliases.isEmpty()) {
                    alias = aliases.get(0);
                }
                String labelRuolo = ruolo.getNome();
                ruoliCore.invokeJmxMethodAllNodesAndSetResult(pd, ruoliCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), ruoliCore.getJmxPdDConfigurazioneSistemaNomeMetodoRipulisciRiferimentiCacheRuolo(alias), MessageFormat.format("{0} eliminato dalla cache", labelRuolo), MessageFormat.format("Eliminazione {0} dalla cache non riuscita: ", labelRuolo), ruolo.getId());
                String resetFromLista = ruoliHelper.getParameter("resetFromLista");
                boolean arrivoDaLista = "true".equalsIgnoreCase(resetFromLista);
                if (arrivoDaLista) {
                    ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
                    int idLista = Liste.RUOLI;
                    List<Ruolo> lista = null;
                    if (!ServletUtils.isSearchDone((IConsoleHelper)ruoliHelper)) {
                        lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Ruolo.class);
                    }
                    ricerca = ruoliHelper.checkSearchParameters(idLista, ricerca);
                    ruoliHelper.clearFiltroSoggettoByPostBackProtocollo(3, (ISearch)ricerca, idLista);
                    if (lista == null) {
                        List<String> protocolli;
                        boolean filtroSoggetto = false;
                        String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
                        if (!"Soggetti".equals(filterApiContesto) && ruoliHelper.isSoggettoMultitenantSelezionato() && (protocolli = ruoliCore.getProtocolli(request, session, false)) != null && protocolli.size() == 1) {
                            filtroSoggetto = true;
                        }
                        if (filtroSoggetto) {
                            ricerca.addFilter(idLista, "filtroSoggetto", ruoliHelper.getSoggettoMultitenantSelezionato());
                        }
                        lista = ruoliCore.isVisioneOggettiGlobale(userLogin) ? ruoliCore.ruoliList(null, (ISearch)ricerca) : ruoliCore.ruoliList(userLogin, (ISearch)ricerca);
                    }
                    if (!ruoliHelper.isPostBackFilterElement()) {
                        ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
                    }
                    ruoliHelper.prepareRuoliList((ISearch)ricerca, lista);
                    ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
                    ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                    return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.CHANGE());
                }
            }
            if (ruoliHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Ruoli", (String)"ruoliList.do", (String)ruolo.getNome());
                if (nome == null) {
                    nome = ruolo.getNome();
                }
                if (descrizione == null) {
                    descrizione = ruolo.getDescrizione();
                }
                if (tipologia == null) {
                    tipologia = ruolo.getTipologia().getValue();
                    nomeEsterno = ruolo.getNomeEsterno();
                }
                if (contesto == null) {
                    contesto = ruolo.getContestoUtilizzo().getValue();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = ruoliHelper.addRuoloToDati(TipoOperazione.CHANGE, ruoloId, nome, descrizione, tipologia, nomeEsterno, contesto, dati, ruolo.getNome());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = ruoliHelper.ruoloCheckData(TipoOperazione.CHANGE, ruolo);
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Ruoli", (String)"ruoliList.do", (String)ruolo.getNome());
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = ruoliHelper.addRuoloToDati(TipoOperazione.CHANGE, ruoloId, nome, descrizione, tipologia, nomeEsterno, contesto, dati, ruolo.getNome());
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.CHANGE());
            }
            Ruolo ruoloNEW = new Ruolo();
            ruoloNEW.setNome(nome);
            ruoloNEW.setDescrizione(descrizione);
            ruoloNEW.setTipologia(RuoloTipologia.toEnumConstant((String)tipologia, (boolean)true));
            if (ruoloNEW.getTipologia() != null && (RuoloTipologia.QUALSIASI.equals((Object)ruoloNEW.getTipologia()) || RuoloTipologia.ESTERNO.equals((Object)ruoloNEW.getTipologia()))) {
                String n = nomeEsterno;
                if (n != null) {
                    n = n.trim();
                }
                ruoloNEW.setNomeEsterno(n);
            }
            ruoloNEW.setContestoUtilizzo(RuoloContesto.toEnumConstant((String)contesto, (boolean)true));
            ruoloNEW.setSuperUser(userLogin);
            ruoloNEW.setOldIDRuoloForUpdate(new IDRuolo(nome));
            ArrayList<Object> listOggettiDaAggiornare = new ArrayList<Object>();
            listOggettiDaAggiornare.add(ruoloNEW);
            if (!ruolo.getNome().equals(nome)) {
                IDRuolo oldIdRuolo = ruoloNEW.getOldIDRuoloForUpdate();
                oldIdRuolo.setNome(ruolo.getNome());
                RuoliUtilities.findOggettiDaAggiornare(oldIdRuolo, ruoloNEW, ruoliCore, listOggettiDaAggiornare);
            }
            ruoliCore.performUpdateOperation(userLogin, ruoliHelper.smista(), listOggettiDaAggiornare.toArray());
            if (!ruolo.getNome().equals(nome)) {
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.RUOLI);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Ruolo> lista = null;
            lista = ruoliCore.isVisioneOggettiGlobale(userLogin) ? ruoliCore.ruoliList(null, (ISearch)ricerca) : ruoliCore.ruoliList(userLogin, (ISearch)ricerca);
            ruoliHelper.prepareRuoliList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

