/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.web.ctrlstat.core.UrlParameters;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class PorteApplicativeExtendedUtilities {
    private PorteApplicativeExtendedUtilities() {
    }

    public static void addToHiddenDati(TipoOperazione tipoOperazione, List<DataElement> dati, ConsoleHelper consoleHelper) throws ExtendedException {
        try {
            String idPorta = consoleHelper.getParameter("id");
            String idsogg = consoleHelper.getParameter("idsogg");
            String idasps = consoleHelper.getParameter("idAsps");
            PorteApplicativeHelper porteApplicativeHelper = (PorteApplicativeHelper)consoleHelper;
            porteApplicativeHelper.addHiddenFieldsToDati(tipoOperazione, idPorta, idsogg, idPorta, idasps, dati);
        }
        catch (Exception e) {
            throw new ExtendedException(e.getMessage(), e);
        }
    }

    public static Object getObject(ConsoleHelper consoleHelper) throws Exception {
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(consoleHelper.getCore());
        String idPorta = consoleHelper.getParameter("id");
        int idInt = Integer.parseInt(idPorta);
        return porteApplicativeCore.getPortaApplicativa(idInt);
    }

    public static List<Parameter> getTitle(ConsoleHelper consoleHelper) throws Exception {
        String idsogg = consoleHelper.getParameter("idsogg");
        String idAsps = consoleHelper.getParameter("idAsps");
        if (idAsps == null) {
            idAsps = "";
        }
        PorteApplicativeHelper paHelper = new PorteApplicativeHelper(consoleHelper.getCore(), consoleHelper.getRequest(), consoleHelper.getPd(), consoleHelper.getSession());
        Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)consoleHelper.getSession(), (HttpServletRequest)consoleHelper.getRequest());
        if (parentPA == null) {
            parentPA = 0;
        }
        return paHelper.getTitoloPA(parentPA, idsogg, idAsps);
    }

    public static Parameter[] getParameterList(ConsoleHelper consoleHelper) throws Exception {
        String idPorta = consoleHelper.getParameter("id");
        String idsogg = consoleHelper.getParameter("idsogg");
        String idasps = consoleHelper.getParameter("idAsps");
        String nomePorta = consoleHelper.getParameter("nomePorta");
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        list.add(new Parameter("id", idPorta));
        list.add(new Parameter("idsogg", idsogg));
        if (StringUtils.isNotEmpty((String)idasps)) {
            list.add(new Parameter("idAsps", idasps));
        }
        if (StringUtils.isNotEmpty((String)nomePorta)) {
            list.add(new Parameter("nomePorta", nomePorta));
        }
        return list.toArray(new Parameter[1]);
    }

    public static UrlParameters getUrlExtendedChange(ConsoleHelper consoleHelper) throws Exception {
        String idPorta = consoleHelper.getParameter("id");
        String idsogg = consoleHelper.getParameter("idsogg");
        String idasps = consoleHelper.getParameter("idAsps");
        String nomePorta = consoleHelper.getParameter("nomePorta");
        UrlParameters urlExtended = new UrlParameters();
        urlExtended.addParameter(new Parameter("id", idPorta));
        urlExtended.addParameter(new Parameter("idsogg", idsogg));
        if (StringUtils.isNotEmpty((String)idasps)) {
            urlExtended.addParameter(new Parameter("idAsps", idasps));
        }
        if (StringUtils.isNotEmpty((String)nomePorta)) {
            urlExtended.addParameter(new Parameter("nomePorta", nomePorta));
        }
        urlExtended.setUrl("porteApplicativeExtendedChange.do");
        return urlExtended;
    }

    public static UrlParameters getUrlExtendedList(ConsoleHelper consoleHelper) throws Exception {
        String idPorta = consoleHelper.getParameter("id");
        String idsogg = consoleHelper.getParameter("idsogg");
        String idasps = consoleHelper.getParameter("idAsps");
        String nomePorta = consoleHelper.getParameter("nomePorta");
        UrlParameters urlExtended = new UrlParameters();
        urlExtended.addParameter(new Parameter("id", idPorta));
        urlExtended.addParameter(new Parameter("idsogg", idsogg));
        if (StringUtils.isNotEmpty((String)idasps)) {
            urlExtended.addParameter(new Parameter("idAsps", idasps));
        }
        if (StringUtils.isNotEmpty((String)nomePorta)) {
            urlExtended.addParameter(new Parameter("nomePorta", nomePorta));
        }
        urlExtended.setUrl("porteApplicativeExtendedList.do");
        return urlExtended;
    }
}

