/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativoConnettore;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class PorteApplicativeConnettoriMultipliAbilitazione
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            String nomeConnettoreChangeList;
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String changeAbilitato = porteApplicativeHelper.getParameter("abilita");
            String schedulingP = porteApplicativeHelper.getParameter("cmScheduling");
            boolean scheduling = "true".equalsIgnoreCase(schedulingP);
            String nomePorta = porteApplicativeHelper.getParameter("nomePorta");
            String idPorta = porteApplicativeHelper.getParameter("id");
            String nomeSAConnettore = porteApplicativeHelper.getParameter("paCMNomeSA");
            String idConnTab = porteApplicativeHelper.getParameter("idConnTab");
            if (StringUtils.isNotEmpty((String)idConnTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idConnTab, (String)"idConnTab");
            }
            String fromAPIPageInfo = porteApplicativeHelper.getParameter("fromApiPageInfo");
            boolean fromApi = "true".equalsIgnoreCase(fromAPIPageInfo);
            String actionConferma = porteApplicativeHelper.getParameter("actionConfirm");
            porteApplicativeHelper.makeMenu();
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
            PortaApplicativaServizioApplicativo oldPaSA = null;
            for (PortaApplicativaServizioApplicativo paSATmp : pa.getServizioApplicativoList()) {
                if (!paSATmp.getNome().equals(nomeSAConnettore)) continue;
                oldPaSA = paSATmp;
            }
            if (actionConferma == null) {
                String[][] bottoni;
                boolean eseguiOperazione = true;
                StringBuilder sbErrore = new StringBuilder();
                if (!ServletUtils.isCheckBoxEnabled((String)changeAbilitato)) {
                    AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteApplicativeCore);
                    AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteApplicativeCore);
                    String idAsps = porteApplicativeHelper.getParameter("idAsps");
                    if (idAsps == null) {
                        idAsps = "";
                    }
                    long idAspsLong = Long.parseLong(idAsps);
                    AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idAspsLong);
                    AccordoServizioParteComuneSintetico apc = apcCore.getAccordoServizioSintetico(asps.getIdAccordo());
                    ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(apc.getServiceBinding());
                    ArrayList<String> messaggiSezioniConnettore = new ArrayList<String>();
                    int numeroElementiDaControllare = 1;
                    boolean connettoreUtilizzatiConfig = porteApplicativeHelper.isConnettoreMultiploInUso(numeroElementiDaControllare, nomeSAConnettore, pa, asps, apc, serviceBinding, messaggiSezioniConnettore);
                    if (!scheduling) {
                        if (connettoreUtilizzatiConfig) {
                            sbErrore.append("Impossibile disabilitare il connettore selezionato.<br/>&Egrave; utilizzato all'interno della sezione 'Configurazione Connettori Multipli'");
                            sbErrore.append(":").append("<br/>");
                            for (String s : messaggiSezioniConnettore) {
                                sbErrore.append(s);
                            }
                            eseguiOperazione = false;
                        }
                        if (!connettoreUtilizzatiConfig) {
                            int numeroAbilitati = 0;
                            for (PortaApplicativaServizioApplicativo paSATmp : pa.getServizioApplicativoList()) {
                                boolean abilitato;
                                if (paSATmp.getNome().equals(nomeSAConnettore) || !(abilitato = paSATmp.getDatiConnettore() != null ? paSATmp.getDatiConnettore().getStato().equals((Object)StatoFunzionalita.ABILITATO) : true)) continue;
                                ++numeroAbilitati;
                            }
                            if (numeroAbilitati < 1) {
                                eseguiOperazione = false;
                                sbErrore.append(MessageFormat.format("Impossibile disabilitare il connettore ''{0}'', deve rimanare almento un connettore abilitato", porteApplicativeHelper.getLabelNomePortaApplicativaServizioApplicativo(oldPaSA)));
                            }
                        }
                    }
                }
                String messaggio = null;
                String title = null;
                if (eseguiOperazione) {
                    messaggio = porteApplicativeHelper.getMessaggioConfermaModificaRegolaStatoConnettoreMultiplo(fromApi, oldPaSA, ServletUtils.isCheckBoxEnabled((String)changeAbilitato), true, true, scheduling);
                    bottoni = new String[][]{{"Annulla", "AnnullaConferma()"}, {"Conferma", "EseguiConferma()"}};
                    pd.setBottoni(bottoni);
                } else {
                    messaggio = sbErrore.toString();
                    title = "Attenzione";
                    bottoni = new String[][]{{"Chiudi", "AnnullaConferma()"}};
                    pd.setBottoni(bottoni);
                }
                pd.setMessage(messaggio, title, MessageType.CONFIRM);
            }
            if (actionConferma != null && actionConferma.equals("ok")) {
                pa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
                PortaApplicativaServizioApplicativo paSA = null;
                for (PortaApplicativaServizioApplicativo paSATmp : pa.getServizioApplicativoList()) {
                    if (!paSATmp.getNome().equals(nomeSAConnettore)) continue;
                    paSA = paSATmp;
                }
                PortaApplicativaServizioApplicativoConnettore datiConnettore = paSA.getDatiConnettore();
                if (datiConnettore == null) {
                    datiConnettore = new PortaApplicativaServizioApplicativoConnettore();
                    datiConnettore.setNome("Default");
                }
                String nomeConnettore = datiConnettore.getNome();
                paSA.setDatiConnettore(datiConnettore);
                if (scheduling) {
                    if (ServletUtils.isCheckBoxEnabled((String)changeAbilitato)) {
                        datiConnettore.setScheduling(StatoFunzionalita.ABILITATO);
                    } else {
                        datiConnettore.setScheduling(StatoFunzionalita.DISABILITATO);
                    }
                } else if (ServletUtils.isCheckBoxEnabled((String)changeAbilitato)) {
                    datiConnettore.setStato(StatoFunzionalita.ABILITATO);
                } else {
                    datiConnettore.setStato(StatoFunzionalita.DISABILITATO);
                }
                String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
                if (datiConnettore.getProprietaOggetto() == null) {
                    datiConnettore.setProprietaOggetto(new ProprietaOggetto());
                }
                datiConnettore.getProprietaOggetto().setUtenteUltimaModifica(userLogin);
                datiConnettore.getProprietaOggetto().setDataUltimaModifica(DateManager.getDate());
                porteApplicativeCore.performUpdateOperation(userLogin, porteApplicativeHelper.smista(), pa);
                List<String> aliasJmx = porteApplicativeCore.getJmxPdDAliases();
                if (aliasJmx != null && !aliasJmx.isEmpty()) {
                    boolean repositoryUpdated = false;
                    for (String alias : aliasJmx) {
                        boolean success = false;
                        String metodo = null;
                        metodo = scheduling ? (StatoFunzionalita.ABILITATO.equals((Object)datiConnettore.getScheduling()) ? porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoEnableSchedulingConnettoreMultiplo(alias) : porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisableSchedulingConnettoreMultiplo(alias)) : (StatoFunzionalita.ABILITATO.equals((Object)datiConnettore.getStato()) ? porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoEnableConnettoreMultiplo(alias) : porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisableConnettoreMultiplo(alias));
                        try {
                            String stato = porteApplicativeCore.getInvoker().invokeJMXMethod(alias, porteApplicativeCore.getJmxPdDConfigurazioneSistemaType(alias), porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), metodo, new Object[]{pa.getNome(), nomeConnettore, userLogin});
                            if (stato == null) {
                                throw new ServletException("Aggiornamento fallito");
                            }
                            if (!("Operazione effettuata con successo".equals(stato) || stato != null && stato.startsWith("Operazione effettuata con successo; "))) {
                                throw new ServletException(stato);
                            }
                            success = true;
                        }
                        catch (Exception e) {
                            String msgErrore = "Errore durante l'aggiornamento dello " + (scheduling ? "scheduling" : "stato") + " del connettore " + nomeConnettore + " della PortaApplicativa '" + pa.getNome() + "' via jmx (jmxMethod '" + metodo + "') (node:" + alias + "): " + e.getMessage();
                            ControlStationCore.logError(msgErrore, e);
                        }
                        if (!scheduling || repositoryUpdated || !success) continue;
                        metodo = StatoFunzionalita.ABILITATO.equals((Object)datiConnettore.getScheduling()) ? porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoEnableSchedulingConnettoreMultiploRuntimeRepository(alias) : porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeMetodoDisableSchedulingConnettoreMultiploRuntimeRepository(alias);
                        try {
                            boolean slowOperation = true;
                            String stato = porteApplicativeCore.getInvoker().invokeJMXMethod(alias, porteApplicativeCore.getJmxPdDConfigurazioneSistemaType(alias), porteApplicativeCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(alias), metodo, Boolean.valueOf(slowOperation), new Object[]{pa.getNome(), nomeConnettore});
                            if (stato == null) {
                                throw new ServletException("Aggiornamento fallito");
                            }
                            if (!("Operazione effettuata con successo".equals(stato) || stato != null && stato.startsWith("Operazione effettuata con successo; "))) {
                                throw new ServletException(stato);
                            }
                            repositoryUpdated = true;
                            ControlStationCore.logDebug("Aggiornato scheduling del connettore: " + stato);
                        }
                        catch (Exception e) {
                            String msgErrore = "Errore durante l'aggiornamento dello scheduling del connettore " + nomeConnettore + " della PortaApplicativa '" + pa.getNome() + "' via jmx (jmxMethod '" + metodo + "') (node:" + alias + "): " + e.getMessage();
                            ControlStationCore.logError(msgErrore, e);
                        }
                    }
                }
                ServletUtils.removeRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI);
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.PORTE_APPLICATIVE_CONNETTORI_MULTIPLI;
            ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
            PortaApplicativa portaApplicativa = porteApplicativeCore.getPortaApplicativa(Integer.parseInt(idPorta));
            IDSoggetto idSoggettoProprietario = new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario());
            List<PortaApplicativaServizioApplicativo> listaFiltrata = porteApplicativeHelper.applicaFiltriRicercaConnettoriMultipli((ISearch)ricerca, idLista, pa.getServizioApplicativoList(), idSoggettoProprietario);
            PortaApplicativaServizioApplicativo paSA = null;
            for (PortaApplicativaServizioApplicativo paSATmp : pa.getServizioApplicativoList()) {
                if (!paSATmp.getNome().equals(nomeSAConnettore)) continue;
                paSA = paSATmp;
            }
            if (paSA == null) {
                throw new Exception("Connettore '" + nomeSAConnettore + "' non trovato");
            }
            PortaApplicativaServizioApplicativoConnettore datiConnettore = paSA.getDatiConnettore();
            if (datiConnettore == null) {
                datiConnettore = new PortaApplicativaServizioApplicativoConnettore();
                datiConnettore.setNome("Default");
            }
            if ((nomeConnettoreChangeList = datiConnettore.getNome()) == null) {
                nomeConnettoreChangeList = "Default";
            }
            porteApplicativeHelper.preparePorteAppConnettoriMultipliList_fromChangeConnettore(nomePorta, ricerca, listaFiltrata, portaApplicativa, nomeConnettoreChangeList);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"porteApplicativeConnettoriMultipliAbilitazione", (ForwardParams)ForwardParams.OTHER((String)""));
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeConnettoriMultipliAbilitazione", (ForwardParams)ForwardParams.OTHER((String)""));
        }
    }
}

