/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.monitor;

import java.math.BigInteger;
import java.util.List;
import javax.xml.ws.BindingProvider;
import org.openspcoop2.pdd.monitor.driver.FilterSearch;
import org.openspcoop2.pdd.monitor.driver.FiltroStatoConsegnaAsincrona;
import org.openspcoop2.pdd.monitor.driver.StatoConsegneAsincrone;
import org.openspcoop2.pdd.monitor.ws.client.messaggio.all.BustaSoggetto;
import org.openspcoop2.pdd.monitor.ws.client.messaggio.all.Filtro;
import org.openspcoop2.pdd.monitor.ws.client.messaggio.all.Messaggio;
import org.openspcoop2.pdd.monitor.ws.client.messaggio.all.MessaggioSoap11Service;
import org.openspcoop2.pdd.monitor.ws.client.messaggio.all.SearchFilterMessaggio;
import org.openspcoop2.pdd.monitor.ws.client.statopdd.all.Busta;
import org.openspcoop2.pdd.monitor.ws.client.statopdd.all.BustaServizio;
import org.openspcoop2.pdd.monitor.ws.client.statopdd.all.SearchFilterStatoPdd;
import org.openspcoop2.pdd.monitor.ws.client.statopdd.all.StatoPdd;
import org.openspcoop2.pdd.monitor.ws.client.statopdd.all.StatoPddSoap11Service;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.monitor.Monitor;

public class MonitorUtilities {
    public static long countListaRichiestePendenti(FilterSearch filter, String pddName, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).countListaRichiestePendenti(filter);
        }
        return MonitorUtilities.getMessaggioWS(pddName).count(MonitorUtilities.convertToSearchFilterMessaggio(filter));
    }

    public static List<org.openspcoop2.pdd.monitor.Messaggio> getListaRichiestePendenti(FilterSearch filter, String pddName, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).getListaRichiestePendenti(filter);
        }
        return MonitorUtilities.getMessaggioWS(pddName).findAll(MonitorUtilities.convertToSearchFilterMessaggio(filter));
    }

    public static long deleteRichiestePendenti(FilterSearch filter, String pddName, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).deleteRichiestePendenti(filter);
        }
        return MonitorUtilities.getMessaggioWS(pddName).deleteAllByFilter(MonitorUtilities.convertToSearchFilterMessaggio(filter));
    }

    public static long aggiornaDataRispedizioneRichiestePendenti(FilterSearch filter, String pddName, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).aggiornaDataRispedizioneRichiestePendenti(filter);
        }
        throw new Exception("Not Implemented");
    }

    public static org.openspcoop2.pdd.monitor.StatoPdd getStatoRichiestePendenti(FilterSearch filter, String pddName, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).getStatoRichiestePendenti(filter);
        }
        return MonitorUtilities.getStatoPddWS(pddName).find(MonitorUtilities.convertToSearchFilterStatoPdd(filter));
    }

    public static StatoConsegneAsincrone getStatoConsegneAsincrone(FiltroStatoConsegnaAsincrona filtro, String sorgenteDati) throws Exception {
        if (Monitor.singlePdD.booleanValue()) {
            return Monitor.driverMonitoraggioLocale.get(sorgenteDati).getStatoConsegneAsincrone(filtro);
        }
        throw new Exception("Non supportato");
    }

    private static String getWSUrl(String pddName, boolean statoPdD) throws Exception {
        String ipPdd = null;
        String protocollo = null;
        int porta = 80;
        try {
            PdDControlStation pdd = Monitor.pddCore.getPdDControlStation(pddName);
            ipPdd = pdd.getIpGestione();
            protocollo = pdd.getProtocolloGestione();
            porta = pdd.getPortaGestione();
            if (ipPdd == null || protocollo == null || porta <= 0) {
                throw new Exception("Parametri Porta di Dominio non validi.");
            }
        }
        catch (Exception e) {
            ControlStationLogger.getPddConsoleCoreLogger().error("Riscontrato errore durante la get dell'ip del pdd(" + pddName + "): " + e.toString(), (Throwable)e);
            throw new Exception("Riscontrato errore durante la get dell'ip del pdd(" + pddName + "): " + e.toString(), e);
        }
        String prefixUrl = protocollo + "://" + ipPdd + ":" + porta + "/";
        if (statoPdD) {
            return prefixUrl + Monitor.consoleProperties.getGestioneCentralizzataWSMonitorEndpointSuffixStatoPdd();
        }
        return prefixUrl + Monitor.consoleProperties.getGestioneCentralizzataWSMonitorEndpointSuffixMessaggio();
    }

    private static Messaggio getMessaggioWS(String pddName) throws Exception {
        MessaggioSoap11Service messaggioService = new MessaggioSoap11Service();
        Messaggio messaggioPort = messaggioService.getMessaggioPortSoap11();
        ((BindingProvider)messaggioPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", MonitorUtilities.getWSUrl(pddName, false));
        ((BindingProvider)messaggioPort).getRequestContext().put("schema-validation-enabled", true);
        String username = Monitor.consoleProperties.getGestioneCentralizzataWSMonitorCredenzialiBasicUsername();
        String password = Monitor.consoleProperties.getGestioneCentralizzataWSMonitorCredenzialiBasicPassword();
        if (username != null && password != null) {
            ((BindingProvider)messaggioPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
            ((BindingProvider)messaggioPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
        return messaggioPort;
    }

    private static StatoPdd getStatoPddWS(String pddName) throws Exception {
        StatoPddSoap11Service statoPddService = new StatoPddSoap11Service();
        StatoPdd statoPddPort = statoPddService.getStatoPddPortSoap11();
        ((BindingProvider)statoPddPort).getRequestContext().put("javax.xml.ws.service.endpoint.address", MonitorUtilities.getWSUrl(pddName, true));
        ((BindingProvider)statoPddPort).getRequestContext().put("schema-validation-enabled", true);
        String username = Monitor.consoleProperties.getGestioneCentralizzataWSMonitorCredenzialiBasicUsername();
        String password = Monitor.consoleProperties.getGestioneCentralizzataWSMonitorCredenzialiBasicPassword();
        if (username != null && password != null) {
            ((BindingProvider)statoPddPort).getRequestContext().put("javax.xml.ws.security.auth.username", username);
            ((BindingProvider)statoPddPort).getRequestContext().put("javax.xml.ws.security.auth.password", password);
        }
        return statoPddPort;
    }

    private static SearchFilterMessaggio convertToSearchFilterMessaggio(FilterSearch filter) {
        SearchFilterMessaggio filterWS = new SearchFilterMessaggio();
        if (filter.getLimit() > 0L) {
            filterWS.setLimit(new BigInteger("" + filter.getLimit()));
        }
        if (filter.getOffset() >= 0L) {
            filterWS.setOffset(new BigInteger("" + filter.getOffset()));
        }
        Filtro filtroInternoWS = new Filtro();
        filtroInternoWS.setTipo(filter.getTipo());
        filtroInternoWS.setStato(filter.getStato());
        if (filter.getSoglia() > 0L) {
            filtroInternoWS.setSoglia(Long.valueOf(filter.getSoglia()));
        }
        filtroInternoWS.setMessagePattern(filter.getMessagePattern());
        filtroInternoWS.setIdMessaggio(filter.getIdMessaggio());
        filtroInternoWS.setCorrelazioneApplicativa(filter.getCorrelazioneApplicativa());
        org.openspcoop2.pdd.monitor.ws.client.messaggio.all.Busta busta = null;
        if (filter.getBusta() != null) {
            busta = new org.openspcoop2.pdd.monitor.ws.client.messaggio.all.Busta();
            busta.setAttesaRiscontro(Boolean.valueOf(filter.getBusta().getAttesaRiscontro()));
            busta.setAzione(filter.getBusta().getAzione());
            busta.setCollaborazione(filter.getBusta().getCollaborazione());
            BustaSoggetto bustaDestinatario = null;
            if (filter.getBusta().getDestinatario() != null) {
                bustaDestinatario = new BustaSoggetto();
                bustaDestinatario.setNome(filter.getBusta().getDestinatario().getNome());
                bustaDestinatario.setTipo(filter.getBusta().getDestinatario().getTipo());
            }
            busta.setDestinatario(bustaDestinatario);
            BustaSoggetto bustaMittente = null;
            if (filter.getBusta().getMittente() != null) {
                bustaMittente = new BustaSoggetto();
                bustaMittente.setNome(filter.getBusta().getMittente().getNome());
                bustaMittente.setTipo(filter.getBusta().getMittente().getTipo());
            }
            busta.setMittente(bustaMittente);
            org.openspcoop2.pdd.monitor.ws.client.messaggio.all.BustaServizio bustaServizio = null;
            if (filter.getBusta().getServizio() != null) {
                bustaServizio = new org.openspcoop2.pdd.monitor.ws.client.messaggio.all.BustaServizio();
                bustaServizio.setNome(filter.getBusta().getServizio().getNome());
                bustaServizio.setTipo(filter.getBusta().getServizio().getTipo());
            }
            busta.setServizio(bustaServizio);
            busta.setProfiloCollaborazione(filter.getBusta().getProfiloCollaborazione());
            busta.setRiferimentoMessaggio(filter.getBusta().getRiferimentoMessaggio());
        }
        filtroInternoWS.setBusta(busta);
        filterWS.setFiltro(filtroInternoWS);
        return filterWS;
    }

    private static SearchFilterStatoPdd convertToSearchFilterStatoPdd(FilterSearch filter) {
        SearchFilterStatoPdd filterWS = new SearchFilterStatoPdd();
        if (filter.getLimit() > 0L) {
            filterWS.setLimit(new BigInteger("" + filter.getLimit()));
        }
        if (filter.getOffset() >= 0L) {
            filterWS.setOffset(new BigInteger("" + filter.getOffset()));
        }
        org.openspcoop2.pdd.monitor.ws.client.statopdd.all.Filtro filtroInternoWS = new org.openspcoop2.pdd.monitor.ws.client.statopdd.all.Filtro();
        filtroInternoWS.setTipo(filter.getTipo());
        filtroInternoWS.setStato(filter.getStato());
        if (filter.getSoglia() > 0L) {
            filtroInternoWS.setSoglia(Long.valueOf(filter.getSoglia()));
        }
        filtroInternoWS.setMessagePattern(filter.getMessagePattern());
        filtroInternoWS.setIdMessaggio(filter.getIdMessaggio());
        filtroInternoWS.setCorrelazioneApplicativa(filter.getCorrelazioneApplicativa());
        Busta busta = null;
        if (filter.getBusta() != null) {
            busta = new Busta();
            busta.setAttesaRiscontro(Boolean.valueOf(filter.getBusta().getAttesaRiscontro()));
            busta.setAzione(filter.getBusta().getAzione());
            busta.setCollaborazione(filter.getBusta().getCollaborazione());
            org.openspcoop2.pdd.monitor.ws.client.statopdd.all.BustaSoggetto bustaDestinatario = null;
            if (filter.getBusta().getDestinatario() != null) {
                bustaDestinatario = new org.openspcoop2.pdd.monitor.ws.client.statopdd.all.BustaSoggetto();
                bustaDestinatario.setNome(filter.getBusta().getDestinatario().getNome());
                bustaDestinatario.setTipo(filter.getBusta().getDestinatario().getTipo());
            }
            busta.setDestinatario(bustaDestinatario);
            org.openspcoop2.pdd.monitor.ws.client.statopdd.all.BustaSoggetto bustaMittente = null;
            if (filter.getBusta().getMittente() != null) {
                bustaMittente = new org.openspcoop2.pdd.monitor.ws.client.statopdd.all.BustaSoggetto();
                bustaMittente.setNome(filter.getBusta().getMittente().getNome());
                bustaMittente.setTipo(filter.getBusta().getMittente().getTipo());
            }
            busta.setMittente(bustaMittente);
            BustaServizio bustaServizio = null;
            if (filter.getBusta().getServizio() != null) {
                bustaServizio = new BustaServizio();
                bustaServizio.setNome(filter.getBusta().getServizio().getNome());
                bustaServizio.setTipo(filter.getBusta().getServizio().getTipo());
            }
            busta.setServizio(bustaServizio);
            busta.setProfiloCollaborazione(filter.getBusta().getProfiloCollaborazione());
            busta.setRiferimentoMessaggio(filter.getBusta().getRiferimentoMessaggio());
        }
        filtroInternoWS.setBusta(busta);
        filterWS.setFiltro(filtroInternoWS);
        return filterWS;
    }
}

