/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.login;

import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.oauth2.OAuth2Utilities;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.login.AuthorizationFilter;
import org.springframework.http.HttpStatus;

public class OAuth2LoginStartServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.engineDoGet(httpServletRequest, httpServletResponse);
    }

    private void engineDoGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        GeneralHelper generalHelper = null;
        Properties loginProperties = null;
        HttpSession session = httpServletRequest.getSession();
        try {
            loginProperties = ConsoleProperties.getInstance().getLoginProperties();
            String state = UUID.randomUUID().toString();
            session.setAttribute("oauth2state", (Object)state);
            String codeChallenge = null;
            String codeChallengeMethod = null;
            if (OAuth2Utilities.isPkceEnabled((Properties)loginProperties)) {
                String codeVerifier = OAuth2Utilities.generateCodeVerifier();
                codeChallengeMethod = OAuth2Utilities.getPkceMethod((Properties)loginProperties);
                codeChallenge = OAuth2Utilities.generateCodeChallenge((String)codeVerifier, (String)codeChallengeMethod);
                session.setAttribute("oauth2code_verifier", (Object)codeVerifier);
            }
            String authorizationUrl = OAuth2Utilities.getURLLoginOAuth2((Properties)loginProperties, (String)state, codeChallenge, (String)codeChallengeMethod);
            httpServletResponse.sendRedirect(authorizationUrl);
        }
        catch (IOException e) {
            ControlStationCore.logError("Si e' verificato un errore il login OAuth2, impossibile autenticare l'utente: " + e.getMessage(), e);
            try {
                AuthorizationFilter.setErrorMsg(generalHelper, session, httpServletRequest, httpServletResponse, "/jsplib/info.jsp", "L'ultima operazione effettuata ha provocato un errore che ha reso l'interfaccia non utilizzabile.<BR><BR>Effettuare nuovamente il login", httpServletRequest.getServletContext(), HttpStatus.SERVICE_UNAVAILABLE);
            }
            catch (IOException | ServletException e1) {
                ControlStationCore.logError("Errore durante esecuzione redirect: " + e1.getMessage(), e1);
            }
        }
        catch (OpenSPCoop2ConfigurationException | UtilsException e) {
            ControlStationCore.logError("Errore durante la lettura delle properties: " + e.getMessage(), e);
            httpServletResponse.setStatus(503);
            try {
                httpServletResponse.getWriter().write("Autenticazione Oauth2 non disponibile: si e' verificato un'errore: " + e.getMessage());
            }
            catch (IOException e1) {
                ControlStationCore.logError("Errore durante esecuzione redirect: " + e1.getMessage(), e1);
            }
        }
    }
}

