/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.gruppi;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCostanti;
import org.openspcoop2.web.lib.mvc.AreaBottoni;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class GruppiHelper
extends ConsoleHelper {
    public GruppiHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public GruppiHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public List<DataElement> addGruppoToDati(TipoOperazione tipoOP, Long gruppoId, String nome, String descrizione, String serviceBinding, List<DataElement> dati) throws DriverConfigurazioneException {
        Gruppo gruppo = null;
        if (TipoOperazione.CHANGE.equals((Object)tipoOP) && nome != null && StringUtils.isNotEmpty((String)nome)) {
            gruppo = this.gruppiCore.getGruppo(nome);
        }
        if (TipoOperazione.CHANGE.equals((Object)tipoOP)) {
            this.addComandoInUsoButton(nome, nome, InUsoType.GRUPPO);
            if (gruppo != null && this.existsProprietaOggetto(gruppo.getProprietaOggetto(), gruppo.getDescrizione())) {
                this.addComandoProprietaOggettoButton(nome, nome, InUsoType.GRUPPO);
            }
        }
        DataElement de = new DataElement();
        de.setLabel("Tag");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        if (gruppoId != null) {
            de = new DataElement();
            de.setLabel("gruppoId");
            de.setValue("" + gruppoId);
            de.setType(DataElementType.HIDDEN);
            de.setName("gruppoId");
            de.setSize(this.getSize());
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("gruppoNome");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(2);
        de.setName("gruppoDescrizione");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.SELECT);
        de.setName("gruppoServiceBinding");
        de.setLabels(GruppiCostanti.getLabelsSelectParametroGruppoServiceBinding());
        de.setValues(GruppiCostanti.getValuesSelectParametroGruppoServiceBinding());
        de.setSelected(serviceBinding);
        dati.add(de);
        return dati;
    }

    public boolean gruppoCheckData(TipoOperazione tipoOp, Gruppo gruppo) throws Exception {
        try {
            String nome = this.getParameter("gruppoNome");
            String descrizione = this.getParameter("gruppoDescrizione");
            String serviceBinding = this.getParameter("gruppoServiceBinding");
            if (nome.equals("")) {
                String tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare: " + tmpElenco);
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo 'Nome'");
                return false;
            }
            if (!this.checkNCName(nome, "Nome")) {
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (descrizione != null && !"".equals(descrizione) && !this.checkLength4000(descrizione, "Descrizione")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (this.gruppiCore.existsGruppo(nome)) {
                    this.pd.setMessage("Un gruppo con nome '" + nome + "' risulta gi&agrave; stato registrato");
                    return false;
                }
            } else {
                String oldServiceBinding = "";
                if (gruppo.getServiceBinding() != null) {
                    oldServiceBinding = gruppo.getServiceBinding().name();
                }
                if (!serviceBinding.equals("") && !serviceBinding.equals(oldServiceBinding)) {
                    HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
                    boolean normalizeObjectIds = !this.isModalitaCompleta();
                    boolean gruppoInUso = this.gruppiCore.isGruppoInUso(gruppo.getNome(), whereIsInUso, normalizeObjectIds);
                    String newLine = "<br/>";
                    StringBuilder inUsoMessage = new StringBuilder();
                    if (gruppoInUso) {
                        inUsoMessage.append(DBOggettiInUsoUtils.toString((IDGruppo)new IDGruppo(gruppo.getNome()), whereIsInUso, (boolean)true, (String)newLine, (String)" non modificabile perch&egrave; :"));
                        inUsoMessage.append(newLine);
                        this.pd.setMessage(inUsoMessage.toString());
                        return false;
                    }
                }
                if (!gruppo.getNome().equals(nome) && this.gruppiCore.existsGruppo(nome)) {
                    this.pd.setMessage("Un gruppo con nome '" + nome + "' risulta gi&agrave; stato registrato");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public void prepareGruppiList(ISearch ricerca, List<Gruppo> lista) throws Exception {
        try {
            ExporterUtils exporterUtils;
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)"gruppi", (Parameter[])new Parameter[0]);
            this.pd.setCustomListViewName("gruppi");
            int idLista = Liste.GRUPPI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            String filterGruppoServiceBinding = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroServiceBinding");
            this.addFilterServiceBinding(filterGruppoServiceBinding, false, false);
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (search.equals("")) {
                this.pd.setSearchDescription("");
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Tags", "gruppiList.do")});
            } else {
                ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])new Parameter[]{new Parameter("Tags", "gruppiList.do"), new Parameter("Risultati ricerca", null)});
            }
            this.pd.setSearchLabel("Nome");
            if (!search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)"Tags", (String)search);
            }
            String[] labels = new String[]{"Tags"};
            this.pd.setLabels(labels);
            ArrayList<List<DataElement>> dati = new ArrayList<List<DataElement>>();
            if (lista != null) {
                Iterator<Gruppo> it = lista.iterator();
                while (it.hasNext()) {
                    List<DataElement> e = this.creaEntryGruppoCustom(it);
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
            if (lista != null && !lista.isEmpty() && this.core.isShowPulsantiImportExport() && (exporterUtils = new ExporterUtils(this.archiviCore)).existsAtLeastOneExportMode(ArchiveType.GRUPPO, this.request, this.session)) {
                ArrayList<AreaBottoni> bottoni = new ArrayList<AreaBottoni>();
                AreaBottoni ab = new AreaBottoni();
                ArrayList<DataElement> otherbott = new ArrayList<DataElement>();
                DataElement de = new DataElement();
                de.setValue("Esporta");
                de.setOnClick(GruppiCostanti.LABEL_GRUPPI_ESPORTA_SELEZIONATI_ONCLICK);
                de.setDisabilitaAjaxStatus();
                otherbott.add(de);
                ab.setBottoni(otherbott);
                bottoni.add(ab);
                this.pd.setAreaBottoni(bottoni);
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new Exception(e.getMessage(), e);
        }
    }

    public List<DataElement> creaEntryGruppo(Iterator<Gruppo> it) {
        Gruppo gruppo = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("gruppoId", "" + gruppo.getId());
        de.setUrl("gruppiChange.do", new Parameter[]{pId});
        de.setToolTip(gruppo.getDescrizione());
        de.setValue(gruppo.getNome());
        de.setIdToRemove(gruppo.getNome());
        de.setToolTip(gruppo.getDescrizione());
        e.add(de);
        de = new DataElement();
        if (gruppo.getServiceBinding() == null) {
            de.setValue("Qualsiasi");
        } else {
            switch (gruppo.getServiceBinding()) {
                case REST: {
                    de.setValue("Rest");
                    break;
                }
                case SOAP: {
                    de.setValue("Soap");
                    break;
                }
                default: {
                    de.setValue("?");
                }
            }
        }
        e.add(de);
        this.addInUsoButtonVisualizzazioneClassica(e, gruppo.getNome(), gruppo.getNome(), InUsoType.GRUPPO);
        return e;
    }

    private List<DataElement> creaEntryGruppoCustom(Iterator<Gruppo> it) {
        Gruppo gruppo = it.next();
        ArrayList<DataElement> e = new ArrayList<DataElement>();
        DataElement de = new DataElement();
        Parameter pId = new Parameter("gruppoId", "" + gruppo.getId());
        de.setUrl("gruppiChange.do", new Parameter[]{pId});
        de.setValue(gruppo.getNome());
        de.setIdToRemove(gruppo.getNome());
        de.setToolTip(gruppo.getDescrizione());
        de.setType(DataElementType.TITLE);
        e.add(de);
        de = new DataElement();
        if (gruppo.getServiceBinding() == null) {
            de.setValue(MessageFormat.format("Tipo: {0}", "Qualsiasi"));
        } else {
            switch (gruppo.getServiceBinding()) {
                case REST: {
                    de.setValue(MessageFormat.format("Tipo: {0}", "Rest"));
                    break;
                }
                case SOAP: {
                    de.setValue(MessageFormat.format("Tipo: {0}", "Soap"));
                    break;
                }
                default: {
                    de.setValue("?");
                }
            }
        }
        de.setType(DataElementType.SUBTITLE);
        e.add(de);
        this.addInUsoButton(e, gruppo.getNome(), gruppo.getNome(), InUsoType.GRUPPO);
        this.addProprietaOggettoButton(e, gruppo.getNome(), gruppo.getNome(), InUsoType.GRUPPO);
        return e;
    }
}

