/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.gruppi;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.registry.Gruppo;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiHelper;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiUtilities;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class GruppiChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            GruppiHelper gruppiHelper = new GruppiHelper(request, pd, session);
            String id = gruppiHelper.getParameter("gruppoId");
            long gruppoId = Long.parseLong(id);
            String nome = gruppiHelper.getParameter("gruppoNome");
            String descrizione = gruppiHelper.getParameter("gruppoDescrizione");
            String serviceBinding = gruppiHelper.getParameter("gruppoServiceBinding");
            GruppiCore gruppiCore = new GruppiCore();
            gruppiHelper.makeMenu();
            Gruppo gruppo = gruppiCore.getGruppo(gruppoId);
            if (gruppiHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Tags", (String)"gruppiList.do", (String)gruppo.getNome());
                if (nome == null) {
                    nome = gruppo.getNome();
                }
                if (descrizione == null) {
                    descrizione = gruppo.getDescrizione();
                }
                if (serviceBinding == null) {
                    serviceBinding = gruppo.getServiceBinding() == null ? "" : gruppo.getServiceBinding().name();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = gruppiHelper.addGruppoToDati(TipoOperazione.CHANGE, gruppoId, nome, descrizione, serviceBinding, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"gruppi", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = gruppiHelper.gruppoCheckData(TipoOperazione.CHANGE, gruppo);
            if (!isOk) {
                ServletUtils.setPageDataTitle_ServletChange((PageData)pd, (String)"Tags", (String)"gruppiList.do", (String)gruppo.getNome());
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = gruppiHelper.addGruppoToDati(TipoOperazione.CHANGE, gruppoId, nome, descrizione, serviceBinding, dati);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"gruppi", (ForwardParams)ForwardParams.CHANGE());
            }
            Gruppo gruppoNEW = new Gruppo();
            gruppoNEW.setNome(nome);
            gruppoNEW.setDescrizione(descrizione);
            if (!serviceBinding.equals("")) {
                gruppoNEW.setServiceBinding(ServiceBinding.valueOf((String)serviceBinding));
            } else {
                gruppoNEW.setServiceBinding(null);
            }
            gruppoNEW.setSuperUser(userLogin);
            gruppoNEW.setOldIDGruppoForUpdate(new IDGruppo(nome));
            ArrayList<Object> listOggettiDaAggiornare = new ArrayList<Object>();
            listOggettiDaAggiornare.add(gruppoNEW);
            if (!gruppo.getNome().equals(nome)) {
                IDGruppo oldIdGruppo = gruppoNEW.getOldIDGruppoForUpdate();
                oldIdGruppo.setNome(gruppo.getNome());
                GruppiUtilities.findOggettiDaAggiornare(oldIdGruppo, gruppoNEW, gruppiCore, listOggettiDaAggiornare);
            }
            gruppiCore.performUpdateOperation(userLogin, gruppiHelper.smista(), listOggettiDaAggiornare.toArray());
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<Gruppo> lista = null;
            lista = gruppiCore.isVisioneOggettiGlobale(userLogin) ? gruppiCore.gruppiList(null, (ISearch)ricerca) : gruppiCore.gruppiList(userLogin, (ISearch)ricerca);
            gruppiHelper.prepareGruppiList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"gruppi", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"gruppi", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

