/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.AllarmeHistory;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.utils.ConfigurazionePdDUtils;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ConfigurazioneUtilities {
    public static boolean alreadyExists(TipoOperazione tipoOperazione, ConfigurazioneCore confCore, ConfigurazioneHelper confHelper, AttivazionePolicy policy, InfoPolicy infoPolicy, RuoloPolicy ruoloPorta, String nomePorta, ServiceBinding serviceBinding, StringBuilder existsMessage, String newLine, String modalita) throws Exception {
        if (infoPolicy != null) {
            String perApi = "globale";
            if (ruoloPorta != null && nomePorta != null && !"".equals(nomePorta)) {
                perApi = "per l'API";
            }
            AttivazionePolicy p = null;
            try {
                p = confCore.getPolicy(policy.getIdPolicy(), policy.getFiltro(), policy.getGroupBy(), ruoloPorta, nomePorta);
            }
            catch (DriverControlStationNotFound driverControlStationNotFound) {
                // empty catch block
            }
            if (p != null && (TipoOperazione.ADD.equals((Object)tipoOperazione) || p.getId() != null && policy.getId() != null && p.getId().longValue() != policy.getId().longValue())) {
                String prefisso = "Esiste gi\u00e0 una attivazione " + perApi + " della policy '" + policy.getIdPolicy() + "' ";
                if ("Scegli criteri".equals(modalita)) {
                    prefisso = "Esiste gi\u00e0 una policy " + perApi + " con i criteri indicati ";
                }
                String messaggio = prefisso + newLine + "e" + newLine + "Raggruppamento: " + confHelper.toStringCompactGroupBy(policy.getGroupBy(), ruoloPorta, nomePorta, serviceBinding) + newLine + "e" + newLine + "Filtro: " + confHelper.toStringCompactFilter(policy.getFiltro(), ruoloPorta, nomePorta, serviceBinding);
                existsMessage.append(messaggio);
                return true;
            }
            AttivazionePolicy pAlias = null;
            if (policy.getAlias() != null && !"".equals(policy.getAlias())) {
                try {
                    pAlias = confCore.getPolicyByAlias(policy.getAlias(), ruoloPorta, nomePorta);
                }
                catch (DriverControlStationNotFound messaggio) {
                    // empty catch block
                }
                if (pAlias != null && (TipoOperazione.ADD.equals((Object)tipoOperazione) || pAlias.getId() != null && policy.getId() != null && pAlias.getId().longValue() != policy.getId().longValue())) {
                    String messaggio = "Esiste gi\u00e0 una policy " + perApi + " con Nome '" + policy.getAlias() + "'";
                    existsMessage.append(messaggio);
                    return true;
                }
            }
        }
        return false;
    }

    private static String _getAttivazionePolicyTipo(AttivazionePolicy attivazionePolicy) {
        Object tipo = "";
        tipo = attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getRuoloPorta() != null && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta()) ? attivazionePolicy.getFiltro().getRuoloPorta().getValue() + "_" + attivazionePolicy.getFiltro().getNomePorta() : "globale";
        return tipo;
    }

    private static String _buildLabelApi(Allarme allarme, ConfigurazioneHelper confHelper, ConfigurazioneCore confCore) {
        if (allarme.getFiltro() != null && allarme.getFiltro().isEnabled() && allarme.getFiltro().getRuoloPorta() != null && allarme.getFiltro().getNomePorta() != null && StringUtils.isNotEmpty((String)allarme.getFiltro().getNomePorta())) {
            switch (allarme.getFiltro().getRuoloPorta()) {
                case APPLICATIVA: {
                    try {
                        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(confCore);
                        IDPortaApplicativa idPA = new IDPortaApplicativa();
                        idPA.setNome(allarme.getFiltro().getNomePorta());
                        PortaApplicativa paFound = porteApplicativeCore.getPortaApplicativa(idPA);
                        MappingErogazionePortaApplicativa mappingPA = porteApplicativeCore.getMappingErogazionePortaApplicativa(paFound);
                        Object labelErogazione = confHelper.getLabelIdServizio(mappingPA.getIdServizio());
                        if (!mappingPA.isDefault()) {
                            labelErogazione = (String)labelErogazione + " (gruppo:" + mappingPA.getDescrizione() + ")";
                        }
                        return labelErogazione;
                    }
                    catch (Throwable t) {
                        ControlStationCore.getLog().error("Errore durante l'identificazione dell'erogazione: " + t.getMessage(), t);
                        break;
                    }
                }
                case DELEGATA: {
                    try {
                        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(confCore);
                        SoggettiCore soggettiCore = new SoggettiCore(confCore);
                        IDPortaDelegata idPD = new IDPortaDelegata();
                        idPD.setNome(allarme.getFiltro().getNomePorta());
                        PortaDelegata pdFound = porteDelegateCore.getPortaDelegata(idPD);
                        MappingFruizionePortaDelegata mappingPD = porteDelegateCore.getMappingFruizionePortaDelegata(pdFound);
                        Object labelFruizione = confHelper.getLabelServizioFruizione(soggettiCore.getProtocolloAssociatoTipoSoggetto(mappingPD.getIdFruitore().getTipo()), mappingPD.getIdFruitore(), mappingPD.getIdServizio());
                        if (!mappingPD.isDefault()) {
                            labelFruizione = (String)labelFruizione + " (gruppo:" + mappingPD.getDescrizione() + ")";
                        }
                        return labelFruizione;
                    }
                    catch (Throwable t) {
                        ControlStationCore.getLog().error("Errore durante l'identificazione della fruizione: " + t.getMessage(), t);
                        break;
                    }
                }
            }
        }
        return null;
    }

    public static void deleteAttivazionePolicy(List<AttivazionePolicy> policies, ConfigurazioneHelper confHelper, ConfigurazioneCore confCore, String userLogin, StringBuilder inUsoMessage, String newLine, List<AttivazionePolicy> policiesRimosse) throws DriverControlStationException, DriverConfigurazioneNotFound, DriverConfigurazioneException, DriverRegistroServiziNotFound, DriverRegistroServiziException, ControlStationCoreException, Exception {
        StringBuilder deleteMessage = new StringBuilder();
        boolean oneOnlyConfig = false;
        if (policies.size() == 1) {
            oneOnlyConfig = true;
        } else {
            oneOnlyConfig = true;
            String tipo = ConfigurazioneUtilities._getAttivazionePolicyTipo(policies.get(0));
            for (int i = 1; i < policies.size(); ++i) {
                AttivazionePolicy attivazionePolicyI = policies.get(i);
                String tipoI = ConfigurazioneUtilities._getAttivazionePolicyTipo(attivazionePolicyI);
                if (tipoI.equals(tipo)) continue;
                oneOnlyConfig = false;
                break;
            }
        }
        for (AttivazionePolicy attivazionePolicy : policies) {
            boolean policyApi;
            boolean delete = true;
            boolean bl = policyApi = attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().isEnabled() && attivazionePolicy.getFiltro().getRuoloPorta() != null && attivazionePolicy.getFiltro().getNomePorta() != null && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta());
            if ("DimensioneMassimaMessaggi".equals(attivazionePolicy.getAlias()) && !policyApi) {
                if (deleteMessage.length() > 0) {
                    deleteMessage.append(newLine);
                }
                StringBuilder bf = new StringBuilder();
                bf.append(newLine);
                bf.append("La policy '" + attivazionePolicy.getAlias() + "' non \u00e8 eliminabile; \u00e8 consentito modificarne i valori di soglia o disabilitarla");
                deleteMessage.append(bf.toString());
                delete = false;
            }
            if (delete && confCore.isConfigurazioneAllarmiEnabled()) {
                RuoloPorta ruoloPorta = null;
                String nomePorta = null;
                if (attivazionePolicy.getFiltro() != null && attivazionePolicy.getFiltro().getRuoloPorta() != null && StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta())) {
                    switch (attivazionePolicy.getFiltro().getRuoloPorta()) {
                        case DELEGATA: {
                            ruoloPorta = RuoloPorta.DELEGATA;
                            break;
                        }
                        case APPLICATIVA: {
                            ruoloPorta = RuoloPorta.APPLICATIVA;
                            break;
                        }
                    }
                    nomePorta = attivazionePolicy.getFiltro().getNomePorta();
                }
                List<Allarme> allarmiObjectUtilizzanoPolicy = confCore.allarmiForPolicyRateLimiting(attivazionePolicy.getIdActivePolicy(), ruoloPorta, nomePorta);
                ArrayList<String> allarmiUtilizzanoPolicy = null;
                if (allarmiObjectUtilizzanoPolicy != null && !allarmiObjectUtilizzanoPolicy.isEmpty()) {
                    allarmiUtilizzanoPolicy = new ArrayList<String>();
                    for (Allarme allarme : allarmiObjectUtilizzanoPolicy) {
                        String labelApi;
                        Object nomeAllarme = allarme.getAlias();
                        if (!oneOnlyConfig && (labelApi = ConfigurazioneUtilities._buildLabelApi(allarme, confHelper, confCore)) != null) {
                            nomeAllarme = (String)nomeAllarme + " - " + labelApi;
                        }
                        allarmiUtilizzanoPolicy.add((String)nomeAllarme);
                    }
                }
                if (allarmiUtilizzanoPolicy != null && !allarmiUtilizzanoPolicy.isEmpty()) {
                    StringBuilder bf = new StringBuilder();
                    bf.append(newLine);
                    bf.append("La policy '" + attivazionePolicy.getAlias() + "' risulta utilizzata da ");
                    bf.append(allarmiUtilizzanoPolicy.size());
                    if (allarmiUtilizzanoPolicy.size() < 2) {
                        bf.append(" allarme");
                    } else {
                        bf.append(" allarmi");
                    }
                    if (oneOnlyConfig) {
                        boolean globale;
                        boolean bl2 = globale = attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getRuoloPorta() == null || !StringUtils.isNotEmpty((String)attivazionePolicy.getFiltro().getNomePorta());
                        if (!globale) {
                            bf.append(RuoloPolicy.APPLICATIVA.equals((Object)attivazionePolicy.getFiltro().getRuoloPorta()) ? " configurati sull'erogazione" : " configurati sulla fruizione");
                        }
                    }
                    bf.append(": ");
                    for (int j = 0; j < allarmiUtilizzanoPolicy.size(); ++j) {
                        bf.append(newLine);
                        bf.append("- ").append((String)allarmiUtilizzanoPolicy.get(j));
                    }
                    if (deleteMessage.length() > 0) {
                        deleteMessage.append(newLine);
                    }
                    deleteMessage.append(bf.toString());
                    delete = false;
                }
            }
            if (!delete) continue;
            policiesRimosse.add(attivazionePolicy);
        }
        if (deleteMessage.length() > 0) {
            if (!policiesRimosse.isEmpty()) {
                inUsoMessage.append("Non \u00e8 stato possibile completare l'eliminazione di tutti gli elementi selezionati:" + newLine + deleteMessage.toString());
            } else {
                inUsoMessage.append("Non \u00e8 stato possibile eliminare gli elementi selezionati:" + newLine + deleteMessage.toString());
            }
        }
        if (!policiesRimosse.isEmpty()) {
            confCore.performDeleteOperation(userLogin, confHelper.smista(), policiesRimosse.toArray(new AttivazionePolicy[1]));
        }
    }

    public static void updatePosizioneAttivazionePolicy(ConfigurazioneCore confCore, InfoPolicy infoPolicy, AttivazionePolicy policy, RuoloPolicy ruoloPorta, String nomePorta) throws Exception {
        confCore.updatePosizioneAttivazionePolicy(infoPolicy, policy, ruoloPorta, nomePorta);
    }

    public static int getProssimaPosizioneUrlInvocazioneRegola(Configurazione config) {
        return ConfigurazionePdDUtils.getProssimaPosizioneUrlInvocazioneRegola((Configurazione)config);
    }

    public static AllarmeHistory createAllarmeHistory(Allarme allarme, String userLogin) {
        AllarmeHistory history = new AllarmeHistory();
        history.setEnabled(allarme.getEnabled());
        history.setAcknowledged(allarme.getAcknowledged());
        history.setDettaglioStato(allarme.getDettaglioStato());
        IdAllarme idConfigurazioneAllarme = new IdAllarme();
        idConfigurazioneAllarme.setNome(allarme.getNome());
        history.setIdAllarme(idConfigurazioneAllarme);
        history.setStato(allarme.getStato());
        history.setTimestampUpdate(allarme.getLasttimestampUpdate());
        history.setUtente(userLogin);
        return history;
    }

    public static void deleteAllarmi(List<Allarme> allarmiToRemove, ConfigurazioneHelper confHelper, ConfigurazioneCore confCore, String userLogin, StringBuilder inUsoMessage, String newLine, List<Allarme> allarmiRimossi) throws DriverControlStationException, DriverConfigurazioneNotFound, DriverConfigurazioneException, DriverRegistroServiziNotFound, DriverRegistroServiziException, ControlStationCoreException, Exception {
        StringBuilder deleteMessage = new StringBuilder();
        for (Allarme allarmeDaEliminare : allarmiToRemove) {
            boolean delete = true;
            List<ConfigurazionePolicy> policyObjectUtilizzanoAllarme = confCore.configurazioneControlloTrafficoConfigurazionePolicyListConApplicabilitaAllarme(allarmeDaEliminare.getNome());
            ArrayList<String> policyUtilizzanoAllarme = null;
            if (policyObjectUtilizzanoAllarme != null && !policyObjectUtilizzanoAllarme.isEmpty()) {
                policyUtilizzanoAllarme = new ArrayList<String>();
                for (ConfigurazionePolicy policy : policyObjectUtilizzanoAllarme) {
                    String nomePolicy = policy.getIdPolicy();
                    policyUtilizzanoAllarme.add(nomePolicy);
                }
            }
            if (policyUtilizzanoAllarme != null && policyUtilizzanoAllarme.size() > 0) {
                StringBuilder bf = new StringBuilder();
                bf.append(newLine);
                bf.append("L'allarme '" + allarmeDaEliminare.getAlias() + "' risulta utilizzata da ");
                bf.append(policyUtilizzanoAllarme.size());
                bf.append(" policy del Controllo del Traffico (criterio di applicabilit\u00e0)");
                bf.append(": ");
                for (int j = 0; j < policyUtilizzanoAllarme.size(); ++j) {
                    bf.append(newLine);
                    bf.append("- ").append((String)policyUtilizzanoAllarme.get(j));
                }
                if (deleteMessage.length() > 0) {
                    deleteMessage.append(newLine);
                }
                deleteMessage.append(bf.toString());
                delete = false;
            }
            if (!delete) continue;
            allarmiRimossi.add(allarmeDaEliminare);
        }
        if (deleteMessage.length() > 0) {
            if (allarmiRimossi.size() > 0) {
                inUsoMessage.append("Non \u00e8 stato possibile completare l'eliminazione di tutti gli elementi selezionati:" + newLine + deleteMessage.toString());
            } else {
                inUsoMessage.append("Non \u00e8 stato possibile eliminare gli elementi selezionati:" + newLine + deleteMessage.toString());
            }
        }
    }
}

