/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneCanaliChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            String idCanaleS = confHelper.getParameter("canaliID");
            String nome = confHelper.getParameter("canaliNome");
            String descrizione = confHelper.getParameter("canaliDescrizione");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            Configurazione configurazioneGenerale = confCore.getConfigurazioneGenerale();
            CanaliConfigurazione gestioneCanali = configurazioneGenerale.getGestioneCanali();
            long idCanale = Long.parseLong(idCanaleS);
            CanaleConfigurazione oldCanale = null;
            if (gestioneCanali != null) {
                for (CanaleConfigurazione canale : gestioneCanali.getCanaleList()) {
                    if (canale.getId() != idCanale) continue;
                    oldCanale = canale;
                    break;
                }
            }
            confHelper.makeMenu();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Canali", "configurazioneCanaliList.do"));
            if (oldCanale != null) {
                lstParam.add(new Parameter(oldCanale.getNome(), null));
            }
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (nome == null) {
                    nome = oldCanale.getNome();
                    descrizione = oldCanale.getDescrizione();
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addCanaleToDati(TipoOperazione.CHANGE, dati, idCanaleS, nome, descrizione);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneCanali", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = confHelper.canaleCheckData(TipoOperazione.CHANGE, oldCanale.getNome());
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addCanaleToDati(TipoOperazione.CHANGE, dati, idCanaleS, nome, descrizione);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneCanali", (ForwardParams)ForwardParams.CHANGE());
            }
            configurazioneGenerale = confCore.getConfigurazioneGenerale();
            if (configurazioneGenerale.getGestioneCanali() == null) {
                configurazioneGenerale.setGestioneCanali(new CanaliConfigurazione());
            }
            for (CanaleConfigurazione canale : configurazioneGenerale.getGestioneCanali().getCanaleList()) {
                if (canale.getId() != idCanale) continue;
                canale.setNome(nome);
                if (descrizione != null && !"".equals(descrizione)) {
                    canale.setDescrizione(descrizione);
                    break;
                }
                canale.setDescrizione(null);
                break;
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), configurazioneGenerale);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_CANALI;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<CanaleConfigurazione> lista = confCore.canaleConfigurazioneList((ISearch)ricerca);
            confHelper.prepareCanaleConfigurazioneList(ricerca, lista);
            pd.setMessage("Configurazione Propriet&agrave; di Sistema modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneCanali", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneCanali", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

