/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.wsdl.Definition;
import org.apache.commons.lang.StringUtils;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.TrasformazioneSoap;
import org.openspcoop2.core.config.TrasformazioneSoapRisposta;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.CredenzialiSoggetto;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.AccordoServizioUtils;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapper;
import org.openspcoop2.core.registry.wsdl.AccordoServizioWrapperUtilities;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.pdd.core.keystore.RemoteStoreKeyEntry;
import org.openspcoop2.pdd.core.trasformazioni.TipoTrasformazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.utils.json.YAMLUtils;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.utils.wsdl.WSDLUtilities;
import org.openspcoop2.utils.xml.AbstractXMLUtils;
import org.openspcoop2.utils.xml.XMLException;
import org.openspcoop2.utils.xml.XSDSchemaCollection;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.protocol_properties.ProtocolPropertiesCore;
import org.openspcoop2.web.ctrlstat.servlet.remote_stores.RemoteStoresCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public class DocumentoExporter
extends HttpServlet {
    private static final long serialVersionUID = -7341279067126334095L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        ArchiviHelper archiviHelper = null;
        byte[] docBytes = null;
        Object fileName = null;
        try {
            archiviHelper = new ArchiviHelper(request, pd, session);
            ControlStationCore.logDebug("Ricevuta Richiesta di esportazione...");
            Enumeration<?> en = archiviHelper.getParameterNames();
            ControlStationCore.logDebug("Parametri (nome = valore):\n-----------------");
            while (en.hasMoreElements()) {
                String param = (String)en.nextElement();
                String value = archiviHelper.getParameter(param);
                ControlStationCore.logDebug(param + " = " + value);
            }
            ControlStationCore.logDebug("-----------------");
            String idAllegato = archiviHelper.getParameter("idAllegato");
            String idAccordo = archiviHelper.getParameter("idAccordo");
            String tipoDocumento = archiviHelper.getParameter("tipoDocumento");
            String tipoDocumentoDaScaricare = archiviHelper.getParameter("tipoDocumentoDaScaricare");
            if (tipoDocumentoDaScaricare == null || "".equals(tipoDocumentoDaScaricare)) {
                tipoDocumentoDaScaricare = "documento";
            }
            String tipoSoggettoFruitore = archiviHelper.getParameter("wsdlImplementativoTipoSoggettoFruitore");
            String nomeSoggettoFruitore = archiviHelper.getParameter("wsdlImplementativoNomeSoggettoFruitore");
            long idAccordoLong = this.getIdAccordoLong(idAccordo);
            ArchiviCore archiviCore = new ArchiviCore();
            ProtocolPropertiesCore ppCore = new ProtocolPropertiesCore(archiviCore);
            PorteDelegateCore pdCore = new PorteDelegateCore(archiviCore);
            PorteApplicativeCore paCore = new PorteApplicativeCore(archiviCore);
            if ("documento".equals(tipoDocumentoDaScaricare)) {
                long idAllegatoInt = Long.parseLong(idAllegato);
                if (!"aspc".equals(tipoDocumento) && !"asps".equals(tipoDocumento) && !"ac".equals(tipoDocumento)) throw new ServletException("Tipo archivio [" + tipoDocumento + "] non gestito (tipo documento: " + tipoDocumentoDaScaricare + ")");
                Documento doc = archiviCore.getDocumento(idAllegatoInt, true);
                fileName = doc.getFile();
                docBytes = doc.getByteContenuto();
            } else if ("aspc".equals(tipoDocumento)) {
                AccordiServizioParteComuneCore asCore = new AccordiServizioParteComuneCore(archiviCore);
                AccordoServizioParteComune as = asCore.getAccordoServizioFull(idAccordoLong);
                if ("wsdlDefinitorio".equals(tipoDocumentoDaScaricare)) {
                    fileName = "InterfacciaDefinitoria.xsd";
                    docBytes = as.getByteWsdlDefinitorio();
                } else if ("wsdlConcettuale".equals(tipoDocumentoDaScaricare)) {
                    docBytes = as.getByteWsdlConcettuale();
                    if (as.getFormatoSpecifica() != null) {
                        switch (as.getFormatoSpecifica()) {
                            case WSDL_11: {
                                fileName = "InterfacciaConcettuale.wsdl";
                                break;
                            }
                            case OPEN_API_3: {
                                YAMLUtils yamlUtils = YAMLUtils.getInstance();
                                if (yamlUtils.isYaml(docBytes)) {
                                    fileName = "InterfacciaOpenAPI.yaml";
                                    break;
                                }
                                fileName = "InterfacciaOpenAPI.json";
                                break;
                            }
                            case SWAGGER_2: {
                                YAMLUtils yamlUtils = YAMLUtils.getInstance();
                                if (yamlUtils.isYaml(docBytes)) {
                                    fileName = "InterfacciaSwagger.yaml";
                                    break;
                                }
                                fileName = "InterfacciaSwagger.json";
                                break;
                            }
                            case WADL: {
                                fileName = "Interfaccia.wadl";
                            }
                        }
                    } else {
                        fileName = "InterfacciaConcettuale.wsdl";
                    }
                } else if ("wsdlLogicoErogatore".equals(tipoDocumentoDaScaricare)) {
                    fileName = "InterfacciaLogicaErogatore.wsdl";
                    docBytes = as.getByteWsdlLogicoErogatore();
                } else if ("wsdlLogicoFruitore".equals(tipoDocumentoDaScaricare)) {
                    fileName = "InterfacciaLogicaFruitore.wsdl";
                    docBytes = as.getByteWsdlLogicoFruitore();
                } else if ("specificaConversazioneConcettuale".equals(tipoDocumentoDaScaricare)) {
                    fileName = "ConversazioneConcettuale.xml";
                    docBytes = as.getByteSpecificaConversazioneConcettuale();
                } else if ("specificaConversazioneLogicoErogatore".equals(tipoDocumentoDaScaricare)) {
                    fileName = "ConversazioneLogicaErogatore.xml";
                    docBytes = as.getByteSpecificaConversazioneErogatore();
                } else if ("specificaConversazioneLogicoFruitore".equals(tipoDocumentoDaScaricare)) {
                    fileName = "ConversazioneLogicaFruitore.xml";
                    docBytes = as.getByteSpecificaConversazioneFruitore();
                } else {
                    if (!"xsdSchemaCollection".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                    AccordoServizioParteComune asConAllegati = asCore.getAccordoServizioFull(IDAccordoFactory.getInstance().getIDAccordoFromAccordo(as), true);
                    try {
                        if (ServiceBinding.REST.equals((Object)asConAllegati.getServiceBinding())) {
                            asConAllegati.setByteWsdlConcettuale(null);
                            asConAllegati.setByteWsdlLogicoErogatore(null);
                            asConAllegati.setByteWsdlLogicoFruitore(null);
                        }
                        AccordoServizioUtils asUtils = new AccordoServizioUtils(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), ControlStationCore.getLog());
                        XSDSchemaCollection schemaCollection = asUtils.buildSchemaCollection(asConAllegati, true);
                        fileName = "XSDSchemaCollection.zip";
                        docBytes = this.serializeWsdl(ControlStationCore.getLog(), schemaCollection, asConAllegati);
                    }
                    catch (Exception e) {
                        ControlStationCore.getLog().error("XSDSchemaCollection build error: " + e.getMessage(), (Throwable)e);
                        fileName = "XSDSchemaCollection.buildError.txt";
                        String msg = e.getMessage();
                        if (msg == null || msg.equals("")) {
                            if (e instanceof NullPointerException) {
                                msg = "Internal Error (NP)";
                            } else {
                                msg = e.toString();
                                if (msg == null || msg.equals("")) {
                                    msg = "Internal Error";
                                }
                            }
                        }
                        docBytes = msg.getBytes();
                    }
                }
            } else if ("asps".equals(tipoDocumento)) {
                AccordiServizioParteSpecificaCore asCore = new AccordiServizioParteSpecificaCore(archiviCore);
                AccordoServizioParteSpecifica as = asCore.getAccordoServizioParteSpecifica(idAccordoLong);
                if ("wsdlImplementativoErogatore".equals(tipoDocumentoDaScaricare)) {
                    fileName = "InterfacciaImplementativaErogatore.wsdl";
                    if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
                        for (int i = 0; i < as.sizeFruitoreList(); ++i) {
                            Fruitore f = as.getFruitore(i);
                            if (!tipoSoggettoFruitore.equals(f.getTipo()) || !nomeSoggettoFruitore.equals(f.getNome())) continue;
                            docBytes = f.getByteWsdlImplementativoErogatore();
                            break;
                        }
                    } else {
                        docBytes = as.getByteWsdlImplementativoErogatore();
                    }
                } else {
                    if (!"wsdlImplementativoFruitore".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                    fileName = "InterfacciaImplementativaFruitore.wsdl";
                    if (tipoSoggettoFruitore != null && !"".equals(tipoSoggettoFruitore) && nomeSoggettoFruitore != null && !"".equals(nomeSoggettoFruitore)) {
                        for (int i = 0; i < as.sizeFruitoreList(); ++i) {
                            Fruitore f = as.getFruitore(i);
                            if (!tipoSoggettoFruitore.equals(f.getTipo()) || !nomeSoggettoFruitore.equals(f.getNome())) continue;
                            docBytes = f.getByteWsdlImplementativoFruitore();
                            break;
                        }
                    } else {
                        docBytes = as.getByteWsdlImplementativoFruitore();
                    }
                }
            } else if ("protocolProperty".equals(tipoDocumento)) {
                if (!"propertyBinaria".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                long idAllegatoInt = Long.parseLong(idAllegato);
                ProtocolProperty bp = ppCore.getProtocolPropertyBinaria(idAllegatoInt);
                fileName = bp.getFile();
                docBytes = bp.getByteFile();
                docBytes = archiviCore.getDriverBYOKUtilities().unwrap(docBytes);
            } else if ("pa".equals(tipoDocumento)) {
                if ("xacmlPolicy".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaApplicativa portaApplicativa = paCore.getPortaApplicativa(idPorta);
                    fileName = "xacmlPolicy.xml";
                    String policy = portaApplicativa.getXacmlPolicy();
                    if (StringUtils.isEmpty((String)policy)) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    docBytes = policy.getBytes();
                } else if ("trasfReqConvTemplate".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaApplicativa portaApplicativa = paCore.getPortaApplicativa(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    Trasformazioni trasformazioni = portaApplicativa.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRichiesta richiesta = oldRegola.getRichiesta();
                    if (richiesta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (richiesta.getConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)richiesta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)richiesta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] '" + tipo + "' non disponibile per il tipo archivio [" + tipoDocumento + "]: tipo non supportato");
                        }
                    }
                    docBytes = richiesta.getConversioneTemplate();
                } else if ("trasfReqSoapEnvTemp".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaApplicativa portaApplicativa = paCore.getPortaApplicativa(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    Trasformazioni trasformazioni = portaApplicativa.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRichiesta richiesta = oldRegola.getRichiesta();
                    if (richiesta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (richiesta.getTrasformazioneSoap() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneSoap trasformazioneSoap = richiesta.getTrasformazioneSoap();
                    if (trasformazioneSoap.getEnvelopeBodyConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = trasformazioneSoap.getEnvelopeBodyConversioneTemplate();
                } else if ("trasfResConvTemplate".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaApplicativa portaApplicativa = paCore.getPortaApplicativa(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    String idTrasformazioneRegolaRes = archiviHelper.getParameter("idTrasfRes");
                    long idTrasformazioneRisposta = Long.parseLong(idTrasformazioneRegolaRes);
                    Trasformazioni trasformazioni = portaApplicativa.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRisposta oldRisposta = null;
                    for (int j = 0; j < oldRegola.sizeRispostaList(); ++j) {
                        TrasformazioneRegolaRisposta risposta = oldRegola.getRisposta(j);
                        if (risposta.getId() != idTrasformazioneRisposta) continue;
                        oldRisposta = risposta;
                        break;
                    }
                    if (oldRisposta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (oldRisposta.getConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)oldRisposta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)oldRisposta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = oldRisposta.getConversioneTemplate();
                } else {
                    if (!"trasfResSoapEnvTemp".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaApplicativa portaApplicativa = paCore.getPortaApplicativa(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    String idTrasformazioneRegolaRes = archiviHelper.getParameter("idTrasfRes");
                    long idTrasformazioneRisposta = Long.parseLong(idTrasformazioneRegolaRes);
                    Trasformazioni trasformazioni = portaApplicativa.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRisposta oldRisposta = null;
                    for (int j = 0; j < oldRegola.sizeRispostaList(); ++j) {
                        TrasformazioneRegolaRisposta risposta = oldRegola.getRisposta(j);
                        if (risposta.getId() != idTrasformazioneRisposta) continue;
                        oldRisposta = risposta;
                        break;
                    }
                    if (oldRisposta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (oldRisposta.getTrasformazioneSoap() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneSoapRisposta trasformazioneSoap = oldRisposta.getTrasformazioneSoap();
                    if (trasformazioneSoap.getEnvelopeBodyConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = trasformazioneSoap.getEnvelopeBodyConversioneTemplate();
                }
            } else if ("pd".equals(tipoDocumento)) {
                if ("xacmlPolicy".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaDelegata portaDelegata = pdCore.getPortaDelegata(idPorta);
                    fileName = "xacmlPolicy.xml";
                    String policy = portaDelegata.getXacmlPolicy();
                    if (StringUtils.isEmpty((String)policy)) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    docBytes = policy.getBytes();
                } else if ("trasfReqConvTemplate".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaDelegata portaDelegata = pdCore.getPortaDelegata(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    Trasformazioni trasformazioni = portaDelegata.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRichiesta richiesta = oldRegola.getRichiesta();
                    if (richiesta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (richiesta.getConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)richiesta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)richiesta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = richiesta.getConversioneTemplate();
                } else if ("trasfReqSoapEnvTemp".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaDelegata portaDelegata = pdCore.getPortaDelegata(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    Trasformazioni trasformazioni = portaDelegata.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRichiesta richiesta = oldRegola.getRichiesta();
                    if (richiesta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (richiesta.getTrasformazioneSoap() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneSoap trasformazioneSoap = richiesta.getTrasformazioneSoap();
                    if (trasformazioneSoap.getEnvelopeBodyConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = trasformazioneSoap.getEnvelopeBodyConversioneTemplate();
                } else if ("trasfResConvTemplate".equals(tipoDocumentoDaScaricare)) {
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaDelegata portaDelegata = pdCore.getPortaDelegata(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    String idTrasformazioneRegolaRes = archiviHelper.getParameter("idTrasfRes");
                    long idTrasformazioneRisposta = Long.parseLong(idTrasformazioneRegolaRes);
                    Trasformazioni trasformazioni = portaDelegata.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRisposta oldRisposta = null;
                    for (int j = 0; j < oldRegola.sizeRispostaList(); ++j) {
                        TrasformazioneRegolaRisposta risposta = oldRegola.getRisposta(j);
                        if (risposta.getId() != idTrasformazioneRisposta) continue;
                        oldRisposta = risposta;
                        break;
                    }
                    if (oldRisposta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (oldRisposta.getConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)oldRisposta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)oldRisposta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = oldRisposta.getConversioneTemplate();
                } else {
                    if (!"trasfResSoapEnvTemp".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                    Long idPorta = Long.parseLong(idAccordo);
                    PortaDelegata portaDelegata = pdCore.getPortaDelegata(idPorta);
                    fileName = "template";
                    String idTrasformazioneRegola = archiviHelper.getParameter("idTrasf");
                    long idTrasformazione = Long.parseLong(idTrasformazioneRegola);
                    String idTrasformazioneRegolaRes = archiviHelper.getParameter("idTrasfRes");
                    long idTrasformazioneRisposta = Long.parseLong(idTrasformazioneRegolaRes);
                    Trasformazioni trasformazioni = portaDelegata.getTrasformazioni();
                    TrasformazioneRegola oldRegola = null;
                    for (TrasformazioneRegola reg : trasformazioni.getRegolaList()) {
                        if (reg.getId() != idTrasformazione) continue;
                        oldRegola = reg;
                        break;
                    }
                    if (oldRegola == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneRegolaRisposta oldRisposta = null;
                    for (int j = 0; j < oldRegola.sizeRispostaList(); ++j) {
                        TrasformazioneRegolaRisposta risposta = oldRegola.getRisposta(j);
                        if (risposta.getId() != idTrasformazioneRisposta) continue;
                        oldRisposta = risposta;
                        break;
                    }
                    if (oldRisposta == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    if (oldRisposta.getTrasformazioneSoap() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TrasformazioneSoapRisposta trasformazioneSoap = oldRisposta.getTrasformazioneSoap();
                    if (trasformazioneSoap.getEnvelopeBodyConversioneTemplate() == null) {
                        throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                    }
                    TipoTrasformazione tipo = StringUtils.isNotEmpty((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoap.getEnvelopeBodyConversioneTipo()) : TipoTrasformazione.EMPTY;
                    switch (tipo) {
                        case FREEMARKER_TEMPLATE: 
                        case CONTEXT_FREEMARKER_TEMPLATE: 
                        case FREEMARKER_TEMPLATE_ZIP: 
                        case VELOCITY_TEMPLATE: 
                        case CONTEXT_VELOCITY_TEMPLATE: 
                        case VELOCITY_TEMPLATE_ZIP: 
                        case TEMPLATE: 
                        case XSLT: 
                        case ZIP: 
                        case TGZ: 
                        case TAR: {
                            fileName = (String)fileName + tipo.getExt();
                            break;
                        }
                        case EMPTY: {
                            throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non disponibile per il tipo archivio [" + tipoDocumento + "]: contenuto vuoto o non presente");
                        }
                    }
                    docBytes = trasformazioneSoap.getEnvelopeBodyConversioneTemplate();
                }
            } else if ("sogg".equals(tipoDocumento)) {
                if (!"sslCert".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                Long idSogg = Long.parseLong(idAccordo);
                SoggettiCore soggettiCore = new SoggettiCore(archiviCore);
                String oldnomeprov = null;
                String oldtipoprov = null;
                if (soggettiCore.isRegistroServiziLocale()) {
                    Soggetto soggettoRegistry = soggettiCore.getSoggettoRegistro(idSogg);
                    oldnomeprov = soggettoRegistry.getNome();
                    oldtipoprov = soggettoRegistry.getTipo();
                } else {
                    org.openspcoop2.core.config.Soggetto soggettoConfig = soggettiCore.getSoggetto(idSogg);
                    oldnomeprov = soggettoConfig.getNome();
                    oldtipoprov = soggettoConfig.getTipo();
                }
                IDSoggetto idSoggetto = new IDSoggetto(oldtipoprov, oldnomeprov);
                String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(oldtipoprov);
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                IRegistryReader registryReader = soggettiCore.getRegistryReader(protocolFactory);
                int posizioneCredenziale = 0;
                String pos = archiviHelper.getParameter("idCred");
                if (StringUtils.isNotEmpty((String)pos)) {
                    posizioneCredenziale = Integer.valueOf(pos);
                }
                CredenzialiSoggetto credenziali = null;
                Soggetto soggetto = null;
                soggetto = registryReader.getSoggetto(idSoggetto);
                if (soggetto.sizeCredenzialiList() > 0) {
                    credenziali = soggetto.getCredenziali(posizioneCredenziale);
                }
                fileName = soggetto.getNome() + ".crt";
                if (credenziali == null || credenziali.getTipo() == null || !credenziali.getTipo().equals((Object)CredenzialeTipo.SSL)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non definito per il tipo archivio [" + tipoDocumento + "]");
                if (credenziali.getCertificate() == null || credenziali.getCertificate().length <= 0) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non definito per il tipo archivio [" + tipoDocumento + "]");
                docBytes = credenziali.getCertificate();
            } else if ("sa".equals(tipoDocumento)) {
                if (!"sslCert".equals(tipoDocumentoDaScaricare)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non gestito per il tipo archivio [" + tipoDocumento + "]");
                Long idSA = Long.parseLong(idAccordo);
                ServiziApplicativiCore saCore = new ServiziApplicativiCore(archiviCore);
                ServizioApplicativo sa = saCore.getServizioApplicativo(idSA);
                fileName = sa.getNome() + ".crt";
                int posizioneCredenziale = 0;
                String pos = archiviHelper.getParameter("idCred");
                if (StringUtils.isNotEmpty((String)pos)) {
                    posizioneCredenziale = Integer.valueOf(pos);
                }
                InvocazionePorta ip = sa.getInvocazionePorta();
                Credenziali credenziali = null;
                if (ip != null && ip.sizeCredenzialiList() > 0) {
                    credenziali = ip.getCredenziali(posizioneCredenziale);
                }
                if (credenziali == null || credenziali.getTipo() == null || !credenziali.getTipo().equals((Object)org.openspcoop2.core.config.constants.CredenzialeTipo.SSL)) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non definito per il tipo archivio [" + tipoDocumento + "]");
                if (credenziali.getCertificate() == null || credenziali.getCertificate().length <= 0) throw new ServletException("Tipo documento [" + tipoDocumentoDaScaricare + "] non definito per il tipo archivio [" + tipoDocumento + "]");
                docBytes = credenziali.getCertificate();
            } else if ("certServer".equals(tipoDocumento)) {
                String aliasForVerificaConnettore = archiviHelper.getParameter("aliasConn");
                String tipoConnettoreRegistro = archiviHelper.getParameter("tipoConn");
                boolean connettoreRegistro = ServletUtils.isCheckBoxEnabled((String)tipoConnettoreRegistro);
                String labelConnettore = connettoreRegistro ? "connettore del registro" : "connettore della configurazione";
                String idConnettore = archiviHelper.getParameter("idConn");
                String tokenTipologia = archiviHelper.getParameter("tokTlg");
                String tokenNome = archiviHelper.getParameter("tokNome");
                String tokenConnettoreTipo = archiviHelper.getParameter("tokTipo");
                String nameConnettore = archiviHelper.getParameter("nomeConn");
                fileName = nameConnettore + ".pem";
                String risorsa = null;
                risorsa = connettoreRegistro ? archiviCore.getJmxPdDConfigurazioneSistemaNomeRisorsaAccessoRegistroServizi(aliasForVerificaConnettore) : archiviCore.getJmxPdDConfigurazioneSistemaNomeRisorsaConfigurazionePdD(aliasForVerificaConnettore);
                String metodo = null;
                ArrayList<Object> parameters = new ArrayList<Object>();
                if (idConnettore != null) {
                    metodo = archiviCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetCertificatiConnettoreById(aliasForVerificaConnettore);
                    parameters.add(idConnettore);
                } else {
                    if (tokenTipologia == null) throw new DriverControlStationException("Nessuna risorsa definita da cui effettuare l'export dei certificati server");
                    if ("gestionePolicyToken".equals(tokenTipologia)) {
                        metodo = archiviCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetCertificatiConnettoreTokenPolicyValidazione(aliasForVerificaConnettore);
                        parameters.add(tokenNome);
                        if (tokenConnettoreTipo != null && StringUtils.isNotEmpty((String)tokenConnettoreTipo)) {
                            parameters.add(tokenConnettoreTipo);
                        }
                    } else if ("retrievePolicyToken".equals(tokenTipologia)) {
                        metodo = archiviCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetCertificatiConnettoreTokenPolicyNegoziazione(aliasForVerificaConnettore);
                        parameters.add(tokenNome);
                    } else {
                        if (!"attributeAuthority".equals(tokenTipologia)) throw new DriverControlStationException("Tipologia '" + tokenTipologia + "' da utilizzare per l'export dei certificati server non supportata");
                        metodo = archiviCore.getJmxPdDConfigurazioneSistemaNomeMetodoGetCertificatiConnettoreAttributeAuthority(aliasForVerificaConnettore);
                        parameters.add(tokenNome);
                    }
                }
                try {
                    String stato = archiviCore.getInvoker().invokeJMXMethod(aliasForVerificaConnettore, archiviCore.getJmxPdDConfigurazioneSistemaType(aliasForVerificaConnettore), risorsa, metodo, parameters.toArray());
                    if (stato == null) {
                        throw new ServletException("Recupero certificati server fallito");
                    }
                    if (stato == null || stato.startsWith("Operazione non riuscita: ")) {
                        throw new ServletException(stato);
                    }
                    docBytes = stato.getBytes();
                }
                catch (Exception e) {
                    String msgErrore = "Errore durante il recupero dei certificati server del " + labelConnettore + " con parametri '" + parameters + "' (jmxResource '" + risorsa + "') (node:" + aliasForVerificaConnettore + "): " + e.getMessage();
                    ControlStationCore.logError(msgErrore, e);
                    fileName = (String)fileName + ".error";
                    docBytes = msgErrore.getBytes();
                }
            } else if ("jar".equals(tipoDocumento)) {
                String nomePlugin = archiviHelper.getParameter("nomePlugin");
                String nomeJar = archiviHelper.getParameter("nomeJar");
                fileName = nomeJar;
                ConfigurazioneCore confCore = new ConfigurazioneCore(archiviCore);
                try {
                    RegistroPluginArchivio jar = confCore.getRegistroPluginArchivio(nomePlugin, nomeJar);
                    docBytes = jar.getContenuto();
                }
                catch (Exception e) {
                    String msgErrore = "Errore durante il recupero dell'archivio jar '" + nomeJar + "' del plugin " + nomePlugin + ": " + e.getMessage();
                    ControlStationCore.logError(msgErrore, e);
                    fileName = (String)fileName + ".error";
                    docBytes = msgErrore.getBytes();
                }
            } else {
                if (!"remStEntry".equals(tipoDocumento)) throw new ServletException("Tipo archivio [" + tipoDocumento + "] non gestito (tipo documento: " + tipoDocumentoDaScaricare + ")");
                RemoteStoresCore remoteStoresCore = new RemoteStoresCore(archiviCore);
                RemoteStoreKeyEntry remoteStoreKeyEntry = remoteStoresCore.getRemoteStoreKeyEntry(idAccordoLong);
                fileName = remoteStoreKeyEntry.getKid() + ".jwk";
                docBytes = remoteStoreKeyEntry.getContentKey();
            }
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            if (docBytes == null) return;
            ServletOutputStream out = response.getOutputStream();
            out.write(docBytes);
            out.flush();
            out.close();
            return;
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante il download dei documenti " + e.getMessage(), e);
        }
    }

    private long getIdAccordoLong(String idAccordo) {
        long idAccordoLong = 0L;
        try {
            idAccordoLong = Long.valueOf(idAccordo);
        }
        catch (Exception e) {
            idAccordoLong = 0L;
        }
        return idAccordoLong;
    }

    private byte[] serializeWsdl(Logger log, XSDSchemaCollection schemaCollection, AccordoServizioParteComune asConAllegati) throws XMLException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            this.serializeWsdl(log, bout, schemaCollection, asConAllegati);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e);
        }
    }

    private void serializeWsdl(Logger log, OutputStream out, XSDSchemaCollection schemaCollection, AccordoServizioParteComune asConAllegati) throws XMLException {
        ZipOutputStream zipOut = null;
        try {
            String nomeFile;
            zipOut = new ZipOutputStream(out);
            schemaCollection.zipSerialize(log, zipOut);
            String rootPackageDir = "wsdl" + File.separatorChar;
            if (asConAllegati.getByteWsdlLogicoErogatore() != null) {
                nomeFile = "InterfacciaLogicaErogatore.wsdl";
                this.writeWsdl(log, rootPackageDir + nomeFile, zipOut, true, asConAllegati);
            }
            if (asConAllegati.getByteWsdlLogicoFruitore() != null) {
                nomeFile = "InterfacciaLogicaFruitore.wsdl";
                this.writeWsdl(log, rootPackageDir + nomeFile, zipOut, false, asConAllegati);
            }
            zipOut.flush();
        }
        catch (Exception e) {
            throw new XMLException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (zipOut != null) {
                    zipOut.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void writeWsdl(Logger log, String nomeFile, ZipOutputStream zipOut, boolean erogatore, AccordoServizioParteComune asConAllegati) throws IOException {
        try {
            AccordoServizioWrapperUtilities wsdlWrapperUtilities = new AccordoServizioWrapperUtilities(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log);
            wsdlWrapperUtilities.setAccordoServizio(new AccordoServizioWrapper());
            wsdlWrapperUtilities.getAccordoServizioWrapper().setAccordoServizio((AccordoServizioParteComune)asConAllegati.clone());
            WSDLUtilities wsdlUtilities = new WSDLUtilities((AbstractXMLUtils)MessageXMLUtils.DEFAULT);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            Definition wsdl = null;
            wsdl = erogatore ? wsdlWrapperUtilities.buildWsdlErogatoreFromBytes() : wsdlWrapperUtilities.buildWsdlFruitoreFromBytes();
            wsdlUtilities.writeWsdlTo(wsdl, (OutputStream)bout);
            bout.flush();
            bout.close();
            zipOut.putNextEntry(new ZipEntry((String)nomeFile));
            zipOut.write(bout.toByteArray());
        }
        catch (Exception e) {
            String tipo = "Erogatore";
            if (!erogatore) {
                tipo = "Fruitore";
            }
            log.error("Costruzione WSDL " + tipo + " fallita: " + e.getMessage(), (Throwable)e);
            nomeFile = (String)nomeFile + ".buildFailed.txt";
            zipOut.putNextEntry(new ZipEntry((String)nomeFile));
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                if (e instanceof NullPointerException) {
                    msg = "Internal Error (NP)";
                } else {
                    msg = e.toString();
                    if (msg == null || msg.equals("")) {
                        msg = "Internal Error";
                    }
                }
            }
            zipOut.write(msg.getBytes());
        }
    }
}

