/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.ProfiloCollaborazione;
import org.openspcoop2.core.registry.constants.ProprietariDocumento;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.TipiDocumentoCoordinamento;
import org.openspcoop2.core.registry.constants.TipiDocumentoSemiformale;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.basic.Costanti;
import org.openspcoop2.protocol.basic.archive.BasicArchive;
import org.openspcoop2.protocol.engine.BasicProtocolFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissing;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingException;
import org.openspcoop2.protocol.engine.archive.ImporterInformationMissingUtils;
import org.openspcoop2.protocol.information_missing.ConditionsType;
import org.openspcoop2.protocol.information_missing.Default;
import org.openspcoop2.protocol.information_missing.Description;
import org.openspcoop2.protocol.information_missing.DescriptionType;
import org.openspcoop2.protocol.information_missing.Input;
import org.openspcoop2.protocol.information_missing.Proprieta;
import org.openspcoop2.protocol.information_missing.ProprietaDefault;
import org.openspcoop2.protocol.information_missing.ProprietaRequisitoInput;
import org.openspcoop2.protocol.information_missing.RequisitoInput;
import org.openspcoop2.protocol.information_missing.Wizard;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.ImportMode;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.costanti.ConnettoreServletType;
import org.openspcoop2.web.ctrlstat.costanti.TipologiaConnettori;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.servlet.ServletExtendedConnettoreUtils;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ImporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriHelper;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.User;

public class ArchiviHelper
extends ServiziApplicativiHelper {
    public ArchiviHelper(HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(request, pd, session);
    }

    public ArchiviHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) throws Exception {
        super(core, request, pd, session);
    }

    public void addExportToDati(List<DataElement> dati, List<String> protocolliSelectList, String protocollo, List<ExportMode> exportModes, String exportMode, org.openspcoop2.protocol.sdk.constants.ArchiveType servletSourceExport, String objToExport, String cascadePolicyConfig, String cascadePluginConfig, String cascade, String configurazioneType, String cascadePdd, String cascadeRuoli, String cascadeScope, String cascadeSoggetti, String cascadeServiziApplicativi, String cascadePorteDelegate, String cascadePorteApplicative, String cascadeAc, String cascadeAspc, String cascadeAsc, String cascadeAsps, String cascadeFruizioni) throws Exception {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Esporta");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        de.setType(DataElementType.HIDDEN);
        de.setValue(protocollo);
        de.setName("protocollo");
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.TEXT);
        de.setLabel("Profilo Interoperabilit\u00e0");
        boolean tutti_protocolli = false;
        if (protocolliSelectList.size() <= 1) {
            de.setValue(this.getLabelProtocollo(protocollo));
        } else {
            de.setValue("Tutti");
            tutti_protocolli = true;
        }
        dati.add(de);
        if (!tutti_protocolli && this.archiviCore.isMultitenant()) {
            de = new DataElement();
            de.setType(DataElementType.TEXT);
            de.setLabel("Soggetto");
            if (this.isSoggettoMultitenantSelezionato()) {
                IDSoggetto idSoggettoSelezionato = this.soggettiCore.convertSoggettoSelezionatoToID(this.getSoggettoMultitenantSelezionato());
                de.setValue(this.getLabelNomeSoggetto(idSoggettoSelezionato));
            } else {
                de.setValue("Tutti");
            }
            if (!(org.openspcoop2.protocol.sdk.constants.ArchiveType.ALL.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.ALL_WITHOUT_CONFIGURAZIONE.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE.equals((Object)servletSourceExport))) {
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Tipologia archivio");
        if (exportModes.size() > 1) {
            ArrayList<String> exportMode_tmp = new ArrayList<String>();
            for (ExportMode exp : exportModes) {
                exportMode_tmp.add(exp.toString());
            }
            de.setType(DataElementType.SELECT);
            de.setValues(exportMode_tmp.toArray(new String[1]));
            de.setLabels(exportMode_tmp.toArray(new String[1]));
            de.setSelected(exportMode);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(exportMode);
        }
        de.setName("tipologiaArchivio");
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        if (org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE.equals((Object)servletSourceExport)) {
            de = new DataElement();
            de.setLabel("Modalit\u00e0");
            de.setName("tipoDump");
            if (this.archiviCore.isExportArchive_configurazione_soloDumpCompleto() || !Costanti.OPENSPCOOP_ARCHIVE_MODE_TYPE.getType().equals(exportMode)) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(configurazioneType);
            } else {
                de.setType(DataElementType.SELECT);
                de.setLabels(ArchiviCostanti.getParametroLabelArchiviExportTipoDump());
                de.setValues(ArchiviCostanti.getParametroValoriArchiviExportTipoDump());
                de.setSelected(configurazioneType);
                de.setPostBack(true);
            }
            dati.add(de);
        }
        boolean cascadeEnabled = false;
        ArchiveCascadeConfiguration cascadeConfig = null;
        if (!org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE.equals((Object)servletSourceExport)) {
            cascadeEnabled = this.archiviCore.isCascadeEnabled(exportModes, exportMode);
            cascadeConfig = this.archiviCore.getCascadeConfig(exportModes, exportMode);
            if (cascadeEnabled && configurazioneType != null && org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE.equals((Object)org.openspcoop2.protocol.sdk.constants.ArchiveType.valueOf((String)configurazioneType))) {
                cascadeEnabled = false;
            }
        }
        boolean showPolicyConfigOption = true;
        if (org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_TOKEN_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_ATTRIBUTE_AUTHORITY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_CLASSE.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_ARCHVIO.equals((Object)servletSourceExport)) {
            showPolicyConfigOption = false;
        }
        de = new DataElement();
        de.setName("cascadePolicyConfig");
        if (cascadeEnabled && showPolicyConfigOption) {
            de.setType(DataElementType.CHECKBOX);
            de.setPostBack(true);
            de.setLabel("Policy di Configurazione");
            if (this.archiviCore.isConfigurazioneAllarmiEnabled()) {
                de.setLabelRight("Vengono incluse le policy globali (Token, Rate Limiting, Allarmi)");
            } else {
                de.setLabelRight("Vengono incluse le policy globali (Token, Rate Limiting)");
            }
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)cascadePolicyConfig));
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (showPolicyConfigOption) {
            de.setValue(cascadePolicyConfig);
        } else {
            de.setValue("no");
        }
        dati.add(de);
        boolean showPluginConfigOption = this.archiviCore.isConfigurazionePluginsEnabled();
        if (org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_TOKEN_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_ATTRIBUTE_AUTHORITY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_CLASSE.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_ARCHVIO.equals((Object)servletSourceExport)) {
            showPluginConfigOption = false;
        }
        de = new DataElement();
        de.setName("cascadePluginConfig");
        if (cascadeEnabled && showPluginConfigOption) {
            de.setType(DataElementType.CHECKBOX);
            de.setPostBack(true);
            de.setLabel("Plugins");
            de.setLabelRight("Vengono inclusi i plugins (Classi, Archivi)");
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)cascadePluginConfig));
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (showPluginConfigOption) {
            de.setValue(cascadePluginConfig);
        } else {
            de.setValue("no");
        }
        dati.add(de);
        boolean showIncludiElementiRiferitiOption = true;
        if (org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_TOKEN_POLICY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_ATTRIBUTE_AUTHORITY.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_CLASSE.equals((Object)servletSourceExport) || org.openspcoop2.protocol.sdk.constants.ArchiveType.CONFIGURAZIONE_PLUGIN_ARCHVIO.equals((Object)servletSourceExport)) {
            showIncludiElementiRiferitiOption = false;
        }
        de = new DataElement();
        de.setName("cascade");
        if (cascadeEnabled && showIncludiElementiRiferitiOption) {
            de.setType(DataElementType.CHECKBOX);
            de.setPostBack(true);
            de.setLabel("Elementi di Registro");
            de.setLabelRight("Vengono inclusi gli elementi riferiti");
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)cascade));
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        if (showIncludiElementiRiferitiOption) {
            de.setValue(cascade);
        } else {
            de.setValue("no");
        }
        dati.add(de);
        if (!this.archiviCore.isExportArchive_servizi_standard() && ServletUtils.isCheckBoxEnabled((String)cascade) && cascadeEnabled) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Configurazione 'Cascade'");
            dati.add(de);
            if (cascadeConfig.isCascadePdd()) {
                de = new DataElement();
                de.setLabel("Porte di Dominio");
                de.setName("cascadePdd");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadePdd);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeRuoli()) {
                de = new DataElement();
                de.setLabel("Ruoli");
                de.setName("cascadeRuoli");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeRuoli);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeScope()) {
                de = new DataElement();
                de.setLabel("Scope");
                de.setName("cascadeScope");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeScope);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeSoggetti()) {
                de = new DataElement();
                de.setLabel("Soggetti");
                de.setName("cascadeSoggetti");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeSoggetti);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeServiziApplicativi()) {
                de = new DataElement();
                de.setLabel("Servizi Applicativi");
                de.setName("cascadeServiziApplicativi");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeServiziApplicativi);
                dati.add(de);
            }
            if (cascadeConfig.isCascadePorteDelegate()) {
                de = new DataElement();
                de.setLabel("Porte Delegate");
                de.setName("cascadePorteDelegate");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadePorteDelegate);
                dati.add(de);
            }
            if (cascadeConfig.isCascadePorteApplicative()) {
                de = new DataElement();
                de.setLabel("Porte Applicative");
                de.setName("cascadePorteApplicative");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadePorteApplicative);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeAccordoCooperazione()) {
                de = new DataElement();
                de.setLabel("Accordi Cooperazione");
                de.setName("cascadeAc");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeAc);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeAccordoServizioParteComune()) {
                de = new DataElement();
                de.setLabel("APIs");
                de.setName("cascadeAspc");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeAspc);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeAccordoServizioComposto()) {
                de = new DataElement();
                de.setLabel("Accordi Servizio Composto");
                de.setName("cascadeAsc");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeAsc);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeAccordoServizioParteSpecifica()) {
                de = new DataElement();
                de.setLabel("Servizi");
                de.setName("cascadeAsps");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeAsps);
                dati.add(de);
            }
            if (cascadeConfig.isCascadeFruizioni()) {
                de = new DataElement();
                de.setLabel("Fruizioni");
                de.setName("cascadeFruizioni");
                de.setType(DataElementType.CHECKBOX);
                de.setPostBack(true);
                de.setSelected(cascadeFruizioni);
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("tipoExport");
        de.setValue(servletSourceExport.toString());
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("obj");
        de.setValue(objToExport);
        dati.add(de);
    }

    public boolean importCheckData(FormFile ff, ImporterUtils importerUtils, String protocollo, ArchiveMode importMode, ArchiveModeType importType) throws Exception {
        if (ff == null || ff.getFileName() == null || "".equals(ff.getFileName()) || ff.getFileData() == null || ff.getFileData().length <= 0) {
            this.pd.setMessage("Non \u00e8 stato selezionato alcun file");
            return false;
        }
        if (!ff.getFileName().contains(".")) {
            this.pd.setMessage("Estensione di file non valida");
            return false;
        }
        String ext = ff.getFileName().substring(ff.getFileName().lastIndexOf(46) + 1, ff.getFileName().length());
        List<String> validExts = importerUtils.getValidExtensions(importType, importMode, protocollo);
        if (!validExts.contains(ext)) {
            this.pd.setMessage("Estensione di file [" + ext + "] non supportata (tipologia-archivio:" + importMode + " ,tipo:" + importType + "). Sono supportati i seguenti formati: " + validExts.toString());
            return false;
        }
        return true;
    }

    public boolean checkRequiisitiWizard(Wizard wizard) {
        if (wizard.getRequisiti() == null) {
            return true;
        }
        StringBuilder bf = new StringBuilder();
        for (int i = 0; i < wizard.getRequisiti().sizeProtocolloList(); ++i) {
            String protocollo = wizard.getRequisiti().getProtocollo(i).getNome();
            try {
                IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                pf.toString();
                continue;
            }
            catch (Exception e) {
                this.log.error("Requisito[" + i + "] protocollo [" + protocollo + "] non trovato: " + e.getMessage(), (Throwable)e);
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(protocollo);
            }
        }
        if (bf.length() > 0) {
            this.pd.setMessage("I seguenti plugin di protocollo, richiesti dall'archivio selezionato, non risultano essere installati: " + bf.toString());
            return false;
        }
        return true;
    }

    public boolean importInformationMissingCheckData(String importInformationMissing_soggettoInput, String importInformationMissing_versioneInput, String importInformationMissing_modalitaAcquisizioneInformazioniProtocollo, String postBackElementName, String importInformationMissing_portTypeImplementedInput, String importInformationMissing_accordoServizioParteComuneInput, String importInformationMissing_accordoCooperazioneInput) throws Exception {
        String message;
        int index = 0;
        String pRequisitoHidden = this.getParameter("RequisitoProprietaInputHidden_" + index);
        while (pRequisitoHidden != null || "".equals(pRequisitoHidden)) {
            String pValue = this.getParameter("RequisitoProprietaInputValue_" + index);
            if ((pValue == null || "".equals(pValue)) && "true".equalsIgnoreCase(pRequisitoHidden)) {
                this.pd.setMessage("Deve essere indicato un valore in tutti i campi obbligatori");
                return false;
            }
            pRequisitoHidden = this.getParameter("RequisitoProprietaInputHidden_" + ++index);
        }
        if (importInformationMissing_soggettoInput != null && !"".equals(importInformationMissing_soggettoInput)) {
            if ("-".equals(importInformationMissing_soggettoInput)) {
                this.pd.setMessage("Deve essere selezionato un soggetto tra quelli indicati");
                return false;
            }
            String[] splitSoggetto = importInformationMissing_soggettoInput.split("/");
            if (splitSoggetto == null || splitSoggetto.length != 2) {
                this.pd.setMessage("Il soggetto indicato [" + importInformationMissing_soggettoInput + "] non risulta valido");
                return false;
            }
        }
        if (importInformationMissing_versioneInput != null) {
            try {
                Integer.parseInt(importInformationMissing_versioneInput);
            }
            catch (Exception e) {
                this.pd.setMessage("Versione indicata [" + importInformationMissing_versioneInput + "] non valida: " + e.getMessage());
                return false;
            }
        }
        index = 0;
        String pHidden = this.getParameter("ProprietaInputHidden_" + index);
        while (pHidden != null || "".equals(pHidden)) {
            String pValue = this.getParameter("ProprietaInputValue_" + index);
            if (pValue == null || "".equals(pValue)) {
                this.pd.setMessage("Deve essere indicato un valore in tutti i campi");
                return false;
            }
            pHidden = this.getParameter("ProprietaInputHidden_" + ++index);
        }
        if ("Configurazione manuale dei servizi e delle operazioni presenti nel WSDL".equals(importInformationMissing_modalitaAcquisizioneInformazioniProtocollo)) {
            int contatoreServizio = 1;
            String servizioParam = "servizioInputIsDefined" + contatoreServizio;
            String serviziTmpInput = this.getParameter(servizioParam);
            while (serviziTmpInput != null && !"".equals(serviziTmpInput)) {
                servizioParam = "servizioInput" + contatoreServizio;
                String nomeServizio = this.getParameter(servizioParam);
                if (nomeServizio == null || "".equals(nomeServizio)) {
                    this.pd.setMessage("Deve essere indicato il nome del servizio da associare ad ogni port-type esistente");
                    return false;
                }
                int contatoreAzione = 1;
                String azioniTmpInput = this.getParameter(servizioParam + "_azioneInputIsDefined" + contatoreAzione);
                while (azioniTmpInput != null && !"".equals(azioniTmpInput)) {
                    String nomeAzione = this.getParameter(servizioParam + "_azioneInput" + contatoreAzione);
                    if (nomeAzione == null || "".equals(nomeAzione)) {
                        this.pd.setMessage("Deve essere indicato il nome di ogni azione da associare alle operations dei port-types");
                        return false;
                    }
                    String nomeProfilo = this.getParameter(servizioParam + "_profiloCollaborazioneInput" + contatoreAzione);
                    if (nomeProfilo == null || "".equals(nomeProfilo)) {
                        this.pd.setMessage("Deve essere indicato un profilo di collaborazione per ogni operation dei port-types");
                        return false;
                    }
                    if (!(CostantiRegistroServizi.ONEWAY.equals(nomeProfilo) || CostantiRegistroServizi.SINCRONO.equals(nomeProfilo) || CostantiRegistroServizi.ASINCRONO_ASIMMETRICO.equals(nomeProfilo) || CostantiRegistroServizi.ASINCRONO_SIMMETRICO.equals(nomeProfilo))) {
                        this.pd.setMessage("Deve essere indicato un profilo di collaborazione valido per ogni operation dei port-types. Trovato un profilo non valido: " + nomeProfilo);
                        return false;
                    }
                    azioniTmpInput = this.getParameter(servizioParam + "_azioneInputIsDefined" + ++contatoreAzione);
                }
                servizioParam = "servizioInputIsDefined" + ++contatoreServizio;
                serviziTmpInput = this.getParameter(servizioParam);
            }
        }
        if (postBackElementName != null) {
            if (postBackElementName.startsWith("servizioInput") && postBackElementName.contains("_profiloCollaborazioneInput")) {
                return false;
            }
            if ("modalitaAcquisizione".equals(postBackElementName)) {
                return false;
            }
        }
        if (importInformationMissing_portTypeImplementedInput != null && !"".equals(importInformationMissing_portTypeImplementedInput) && "-".equals(importInformationMissing_portTypeImplementedInput)) {
            this.pd.setMessage("Deve essere selezionato un servizio, da implementare, tra quelli indicati");
            return false;
        }
        if (importInformationMissing_accordoServizioParteComuneInput != null && !"".equals(importInformationMissing_accordoServizioParteComuneInput)) {
            if ("-".equals(importInformationMissing_accordoServizioParteComuneInput)) {
                this.pd.setMessage("Deve essere selezionato un'accordo tra quelli indicati");
                return false;
            }
            try {
                IDAccordoFactory.getInstance().getIDAccordoFromUri(importInformationMissing_accordoServizioParteComuneInput);
            }
            catch (Exception e) {
                this.pd.setMessage("L'accordo indicato [" + importInformationMissing_accordoServizioParteComuneInput + "] non risulta valido");
                return false;
            }
        }
        if (importInformationMissing_accordoCooperazioneInput != null && !"".equals(importInformationMissing_accordoCooperazioneInput)) {
            if ("-".equals(importInformationMissing_accordoCooperazioneInput)) {
                this.pd.setMessage("Deve essere selezionato un'accordo tra quelli indicati");
                return false;
            }
            try {
                IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(importInformationMissing_accordoCooperazioneInput);
            }
            catch (Exception e) {
                this.pd.setMessage("L'accordo indicato [" + importInformationMissing_accordoCooperazioneInput + "] non risulta valido");
                return false;
            }
        }
        if (!this.isEditModeInProgress()) {
            try {
                InvocazioneServizio is = this.readInvocazioneServizio();
                if (is != null) {
                    ServiziApplicativiHelper saHelper = new ServiziApplicativiHelper(this.request, this.pd, this.session);
                    String endpointtype = this.readEndPointType();
                    List<ExtendedConnettore> listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(is.getConnettore(), ConnettoreServletType.WIZARD_CONFIG, (ConsoleHelper)this, false, endpointtype);
                    boolean isOk = saHelper.servizioApplicativoEndPointCheckData(null, listExtendedConnettore, null);
                    if (!isOk) {
                        return false;
                    }
                    if (StatoFunzionalita.ABILITATO.equals((Object)is.getGetMessage()) && !(isOk = this.credenzialiCheckData(TipoOperazione.ADD, false, this.saCore.isApplicativiPasswordEncryptEnabled(), this.saCore.getApplicativiPasswordVerifier()))) {
                        return false;
                    }
                }
            }
            catch (Exception e) {
                message = "Rilevato ErroreGenerico durante la lettura dei dati di invocazione servizio relativo al servizio applicativo: " + e.getMessage();
                this.log.error(message, (Throwable)e);
                this.pd.setMessage(message);
                return false;
            }
        }
        if (!this.isEditModeInProgress()) {
            try {
                String endpointtype;
                List<ExtendedConnettore> listExtendedConnettore;
                boolean isOk;
                Connettore connettore = this.readConnettore();
                if (connettore != null && !(isOk = this.endPointCheckData(null, null, false, listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(connettore, ConnettoreServletType.WIZARD_REGISTRY, (ConsoleHelper)this, false, endpointtype = this.readEndPointType())))) {
                    return false;
                }
            }
            catch (Exception e) {
                message = "Rilevato ErroreGenerico durante la lettura dei dati del connettore: " + e.getMessage();
                this.log.error(message, (Throwable)e);
                this.pd.setMessage(message);
                return false;
            }
        }
        if (!this.isEditModeInProgress()) {
            try {
                ConnettoriHelper connettoriHelper;
                boolean isOk;
                Credenziali credenziali = this.readCredenzialiSA();
                if (credenziali != null && !(isOk = (connettoriHelper = new ConnettoriHelper(this.request, this.pd, this.session)).credenzialiCheckData(TipoOperazione.ADD, false, this.saCore.isApplicativiPasswordEncryptEnabled(), this.saCore.getApplicativiPasswordVerifier()))) {
                    return false;
                }
            }
            catch (Exception e) {
                message = "Rilevato ErroreGenerico durante la lettura dei dati delle credenziali di accesso alla PdD del servizio applicativo: " + e.getMessage();
                this.log.error(message, (Throwable)e);
                this.pd.setMessage(message);
                return false;
            }
        }
        return true;
    }

    public void addImportToDati(List<DataElement> dati, boolean validazioneDocumenti, boolean updateEnabled, boolean importDeletePolicyConfig, boolean importDeletePluginConfig, boolean importConfig, boolean showProtocols, List<String> protocolliSelectList, String protocollo, List<ImportMode> importModes, String importMode, List<ArchiveModeType> importTypes, String importType, boolean deleter) throws Exception {
        DataElement dataElement = new DataElement();
        if (deleter) {
            dataElement.setLabel("Elimina");
        } else {
            dataElement.setLabel("Importa");
        }
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de.setLabel("Profilo Interoperabilit\u00e0");
        if (showProtocols && protocolliSelectList.size() > 2) {
            de.setType(DataElementType.SELECT);
            de.setValues(protocolliSelectList.toArray(new String[1]));
            ArrayList<String> protocolliSelectListLabels = new ArrayList<String>();
            for (String p : protocolliSelectList) {
                if ("-".equals(p)) {
                    protocolliSelectListLabels.add("Tutti");
                    continue;
                }
                protocolliSelectListLabels.add(this.getLabelProtocollo(p));
            }
            de.setLabels(protocolliSelectListLabels);
            de.setSelected(protocollo);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(protocollo);
        }
        de.setName("protocollo");
        de.setSize(this.getSize());
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipologia archivio");
        if (importModes.size() > 1) {
            ArrayList<String> tmpArchivi = new ArrayList<String>();
            for (ImportMode imp : importModes) {
                tmpArchivi.add(imp.toString());
            }
            de.setType(DataElementType.SELECT);
            de.setValues(tmpArchivi.toArray(new String[1]));
            de.setLabels(tmpArchivi.toArray(new String[1]));
            de.setSelected(importMode);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(importMode);
        }
        de.setName("tipologiaArchivio");
        de.setSize(this.getSize());
        if (importModes.size() > 1) {
            de.setPostBack(true);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        if (importTypes.size() > 1) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (ArchiveModeType type : importTypes) {
                tmp.add(type.toString());
            }
            de.setType(DataElementType.SELECT);
            de.setValues(tmp.toArray(new String[1]));
            de.setLabels(tmp.toArray(new String[1]));
            de.setSelected(importType);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(importType);
        }
        de.setName("tipoArchivio");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Validazione Documenti");
        de.setLabelRight("Le interfacce delle API (Wsdl, OpenAPI 3) vengono validate");
        de.setValue("" + validazioneDocumenti);
        if (this.isModalitaAvanzata()) {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(validazioneDocumenti);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setName("validazioneDocumenti");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Aggiornamento");
        de.setLabelRight("Gli elementi gi\u00e0 esistenti verranno aggiornati");
        de.setValue("" + updateEnabled);
        if (deleter) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(updateEnabled);
        }
        de.setName("updateEnabled");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel(deleter ? "Policy di Configurazione" : "Policy di Configurazione");
        if (this.archiviCore.isConfigurazioneAllarmiEnabled()) {
            de.setLabelRight(deleter ? "Eventuali policy globali (Token, Rate Limiting, Allarmi) presenti nell'archivio verranno eliminate" : "Eventuali policy globali (Token, Rate Limiting, Allarmi) presenti nell'archivio verranno importate");
        } else {
            de.setLabelRight(deleter ? "Eventuali policy globali (Token, Rate Limiting) presenti nell'archivio verranno eliminate" : "Eventuali policy globali (Token, Rate Limiting) presenti nell'archivio verranno importate");
        }
        de.setValue("" + importDeletePolicyConfig);
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(importDeletePolicyConfig);
        de.setName("policyConfigEnabled");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel(deleter ? "Plugins" : "Plugins");
        de.setLabelRight(deleter ? "Eventuali plugins (Classi, Archivi) presenti nell'archivio verranno eliminati" : "Eventuali plugins (Classi, Archivi) presenti nell'archivio verranno importati");
        de.setValue("" + importDeletePluginConfig);
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(importDeletePluginConfig);
        de.setName("pluginConfigEnabled");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Configurazione di GovWay");
        de.setLabelRight("Una eventuale configurazione presente nell'archivio verr\u00e0 importata");
        de.setValue("" + importConfig);
        if (deleter) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(importConfig);
        }
        de.setName("configEnabled");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setValue("");
        de.setType(DataElementType.FILE);
        de.setName("theFile");
        de.setLabel("File");
        de.setSize(this.getSize());
        dati.add(de);
    }

    public List<PortType> readInformazioniProtocolloServiziAzioni(String modalitaAcquisizione, String protocollo, Object object) throws Exception {
        AccordoServizioParteComune aspc = null;
        if (object == null) {
            throw new Exception("Accordo non fornito come parametro 'object'");
        }
        if (!(object instanceof AccordoServizioParteComune)) {
            throw new Exception("Accordo fornito come parametro 'object' non e' di tipo " + AccordoServizioParteComune.class.getName());
        }
        aspc = (AccordoServizioParteComune)object;
        while (aspc.sizePortTypeList() > 0) {
            aspc.removePortType(0);
        }
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        protocolFactory.createArchive().setProtocolInfo(aspc);
        if ("Automatica dall'accordo (WSDL,SpecificaConversazione,...)".equals(modalitaAcquisizione)) {
            return aspc.getPortTypeList();
        }
        int contatoreServizio = 1;
        String servizioParam = "servizioInput" + contatoreServizio;
        String serviziTmpInput = this.getParameter(servizioParam);
        ArrayList<PortType> portTypes = new ArrayList<PortType>();
        while (serviziTmpInput != null && !"".equals(serviziTmpInput)) {
            PortType ptOpenSPCoop = new PortType();
            ptOpenSPCoop.setNome(serviziTmpInput);
            ptOpenSPCoop.setProfiloCollaborazione(ProfiloCollaborazione.toEnumConstant((String)AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_SINCRONO));
            ptOpenSPCoop.setProfiloPT("ridefinito");
            ptOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
            int contatoreAzione = 1;
            String azioniTmpInput = this.getParameter(servizioParam + "_azioneInput" + contatoreAzione);
            while (azioniTmpInput != null && !"".equals(azioniTmpInput)) {
                Operation operationOpenSPCoop = new Operation();
                operationOpenSPCoop.setNome(azioniTmpInput);
                operationOpenSPCoop.setProfAzione("ridefinito");
                operationOpenSPCoop.setFiltroDuplicati(CostantiRegistroServizi.ABILITATO);
                String profiliCollaborazioneTmpInput = this.getParameter(servizioParam + "_profiloCollaborazioneInput" + contatoreAzione);
                operationOpenSPCoop.setProfiloCollaborazione(ProfiloCollaborazione.toEnumConstant((String)profiliCollaborazioneTmpInput));
                if (AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO.equals(profiliCollaborazioneTmpInput) || AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO.equals(profiliCollaborazioneTmpInput)) {
                    String azioniCorrelataTmpInput;
                    String servizioAzioneCorrelataTmpInput = this.getParameter(servizioParam + "_servizioAzioneCorrelataInput" + contatoreAzione);
                    if (servizioAzioneCorrelataTmpInput != null && !"".equals(servizioAzioneCorrelataTmpInput)) {
                        operationOpenSPCoop.setCorrelataServizio(servizioAzioneCorrelataTmpInput);
                    }
                    if ((azioniCorrelataTmpInput = this.getParameter(servizioParam + "_azioneCorrelataInput" + contatoreAzione)) != null && !"".equals(azioniCorrelataTmpInput)) {
                        operationOpenSPCoop.setCorrelata(azioniCorrelataTmpInput);
                    }
                }
                ptOpenSPCoop.addAzione(operationOpenSPCoop);
                azioniTmpInput = this.getParameter(servizioParam + "_azioneInput" + ++contatoreAzione);
            }
            servizioParam = "servizioInput" + ++contatoreServizio;
            serviziTmpInput = this.getParameter(servizioParam);
            portTypes.add(ptOpenSPCoop);
        }
        return portTypes;
    }

    public MapPlaceholder readPlaceholder() throws Exception {
        MapPlaceholder map = new MapPlaceholder();
        int index = 0;
        String pHidden = this.getParameter("ProprietaInputHidden_" + index);
        while (pHidden != null || "".equals(pHidden)) {
            String pValue = this.getParameter("ProprietaInputValue_" + index);
            map.put(pHidden, pValue);
            pHidden = this.getParameter("ProprietaInputHidden_" + ++index);
        }
        if (map.size() <= 0) {
            return null;
        }
        return map;
    }

    public HashMap<String, String> readRequisitiInput() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        String pHidden = this.getParameter("RequisitoProprietaInputHidden_" + index);
        while (pHidden != null || "".equals(pHidden)) {
            String pName = this.getParameter("RequisitoProprietaInputNameHidden_" + index);
            String pValue = this.getParameter("RequisitoProprietaInputValue_" + index);
            map.put(pName, pValue);
            pHidden = this.getParameter("RequisitoProprietaInputHidden_" + ++index);
        }
        if (map.size() <= 0) {
            return null;
        }
        return map;
    }

    public HashMap<String, String> readRequisitiStepIncrementInput() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        int index = 0;
        String pHidden = this.getParameter("RequisitoProprietaInputHidden_" + index);
        while (pHidden != null || "".equals(pHidden)) {
            String pName = this.getParameter("RequisitoProprietaInputNameHidden_" + index);
            String pValue = this.getParameter("RequisitoProprietaInputStepIncrementHidden_" + index);
            map.put(pName, pValue);
            pHidden = this.getParameter("RequisitoProprietaInputHidden_" + ++index);
        }
        if (map.size() <= 0) {
            return null;
        }
        return map;
    }

    public Credenziali readCredenzialiSA() throws Exception {
        Credenziali cis = null;
        String tipoauth = this.getParameter("tipoauthCredenziali");
        if (tipoauth == null) {
            return null;
        }
        String utente = this.getParameter("utenteCredenziali");
        String password = this.getParameter("passwordCredenziali");
        String subject = this.getParameter("subjectCredenziali");
        String issuer = this.getParameter("subjectIssuer");
        String principal = this.getParameter("principalCredenziali");
        if (tipoauth != null && !tipoauth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_NONE.toString())) {
            if (cis == null) {
                cis = new Credenziali();
            }
            if ("nessuna".equals(tipoauth)) {
                cis.setTipo(null);
            } else {
                cis.setTipo(CredenzialeTipo.toEnumConstant((String)tipoauth));
            }
            cis.setUser("");
            cis.setPassword("");
            cis.setSubject("");
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC)) {
                cis.setUser(utente);
                cis.setPassword(password);
            }
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL)) {
                cis.setSubject(subject);
                if (StringUtils.isNotEmpty((String)issuer)) {
                    cis.setIssuer(issuer);
                }
            }
            if (tipoauth.equals(ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL)) {
                cis.setUser(principal);
            }
        }
        return cis;
    }

    public InvocazioneCredenziali readCredenzialiConnettore() throws Exception {
        InvocazioneCredenziali cis = null;
        String tipoauth = this.getParameter("tipoauthInv");
        if (tipoauth == null) {
            tipoauth = "nessuna";
        }
        String utente = this.getParameter("utenteInv");
        String password = this.getLockedParameter("passwordInv");
        if (tipoauth != null && tipoauth.equals(CostantiConfigurazione.INVOCAZIONE_SERVIZIO_AUTENTICAZIONE_BASIC.toString())) {
            if (cis == null) {
                cis = new InvocazioneCredenziali();
            }
            cis.setUser(utente);
            cis.setPassword(password);
        }
        return cis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocazioneServizio readInvocazioneServizio() throws Exception {
        InvocazioneServizio invServizio = new InvocazioneServizio();
        String sbustamento = this.getParameter("sbustamento");
        if (sbustamento == null) {
            return null;
        }
        String sbustamentoInformazioniProtocolloRichiesta = this.getParameter("sbustamentoInformazioniProtocolloRichiesta");
        String getmsg = this.getParameter("getmsg");
        invServizio.setSbustamentoSoap(StatoFunzionalita.toEnumConstant((String)sbustamento));
        invServizio.setSbustamentoInformazioniProtocollo(StatoFunzionalita.toEnumConstant((String)sbustamentoInformazioniProtocolloRichiesta));
        invServizio.setGetMessage(StatoFunzionalita.toEnumConstant((String)getmsg));
        InvocazioneCredenziali invCr = this.readCredenzialiConnettore();
        invServizio.setCredenziali(invCr);
        if (invCr != null) {
            invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
        }
        TipologiaConnettori tipologiaConnettoriOriginale = null;
        try {
            tipologiaConnettoriOriginale = Utilities.getTipologiaConnettori(this.core);
            Utilities.setTipologiaConnettori(TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP);
            String endpointtype = this.readEndPointType();
            if (endpointtype == null) {
                InvocazioneServizio invocazioneServizio = null;
                return invocazioneServizio;
            }
            String tipoconn = this.getParameter("tipoconn");
            String user = null;
            String password = null;
            String connettoreDebug = this.getParameter("connettore_debug");
            String autenticazioneTokenS = this.getParameter("connettore_token_policy_stat");
            boolean autenticazioneToken = ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenS);
            String tokenPolicy = this.getParameter("connettore_token_policy");
            String proxyEnabled = this.getParameter("connettore_proxy_enabled");
            String proxyHostname = this.getParameter("connettore_proxy_host");
            String proxyPort = this.getParameter("connettore_proxy_port");
            String proxyUsername = this.getParameter("connettore_proxy_username");
            String proxyPassword = this.getLockedParameter("connettore_proxy_password");
            String tempiRispostaEnabled = this.getParameter("connettore_tempi_redefine");
            String tempiRispostaConnectionTimeout = this.getParameter("connettore_tempi_ct");
            String tempiRispostaReadTimeout = this.getParameter("connettore_tempi_rt");
            String tempiRispostaTempoMedioRisposta = this.getParameter("connettore_tempi_avg");
            String transferMode = this.getParameter("transfer_mode");
            String transferModeChunkSize = this.getParameter("transfer_chunk_size");
            String redirectMode = this.getParameter("redirect_mode");
            String redirectMaxHop = this.getParameter("redirect_max_hop");
            String opzioniAvanzate = ConnettoriHelper.getOpzioniAvanzate(this, transferMode, redirectMode);
            String url = this.getParameter("url");
            if (TipiConnettore.HTTP.toString().equals(endpointtype)) {
                user = this.getParameter("utenteInv");
                password = this.getLockedParameter("passwordInv");
            }
            String autenticazioneApiKey = this.getParameter("endpointtype_apikey");
            String apiKeyHeader = this.getParameter("connettore_apikey_hdr");
            if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                apiKeyHeader = "X-API-KEY";
            }
            String apiKeyValue = this.getLockedParameter("connettore_apikey_value");
            String appIdHeader = this.getParameter("connettore_appid_header");
            if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                appIdHeader = "X-APP-ID";
            }
            String appIdValue = this.getParameter("connettore_appid_value");
            String useOAS3NamesTmp = this.getParameter("connettore_apikey_nomi_oas");
            boolean useOAS3Names = true;
            useOAS3Names = useOAS3NamesTmp != null && StringUtils.isNotEmpty((String)useOAS3NamesTmp) ? ServletUtils.isCheckBoxEnabled((String)useOAS3NamesTmp) : this.isAutenticazioneApiKeyUseOAS3Names(apiKeyHeader, appIdHeader);
            String useAppIdTmp = this.getParameter("connettore_appid_use");
            boolean useAppId = false;
            useAppId = useAppIdTmp != null && StringUtils.isNotEmpty((String)useAppIdTmp) ? ServletUtils.isCheckBoxEnabled((String)useAppIdTmp) : this.isAutenticazioneApiKeyUseAppId(appIdValue);
            String nomeCodaJMS = this.getParameter("nomeJms");
            String tipo = this.getParameter("tipoJms");
            String initcont = this.getParameter("initcont");
            String urlpgk = this.getParameter("urlpgk");
            String provurl = this.getParameter("provurl");
            String connfact = this.getParameter("connfact");
            String sendas = this.getParameter("sendas");
            if (TipiConnettore.JMS.toString().equals(endpointtype)) {
                user = this.getParameter("userJms");
                password = this.getLockedParameter("passwordJms");
            }
            String httpsurl = url;
            String httpstipologia = this.getParameter("httpstipologia");
            String httpshostverifyS = this.getParameter("httpshostverify");
            boolean httpshostverify = ServletUtils.isCheckBoxEnabled((String)httpshostverifyS);
            String httpsTrustVerifyCertS = this.getParameter("httpstrustverify");
            boolean httpsTrustVerifyCert = ServletUtils.isCheckBoxEnabled((String)httpsTrustVerifyCertS);
            String httpspath = this.getParameter("httpspath");
            String httpstipo = this.getParameter("httpstipo");
            String httpspwd = this.getLockedParameter("httpspwd");
            String httpsalgoritmo = this.getParameter("httpsalgoritmo");
            String httpsstatoS = this.getParameter("httpsstato");
            boolean httpsstato = ServletUtils.isCheckBoxEnabled((String)httpsstatoS);
            String httpskeystore = this.getParameter("httpskeystore");
            String httpspwdprivatekeytrust = this.getLockedParameter("httpspwdprivatekeytrust");
            String httpspathkey = this.getParameter("httpspathkey");
            String httpstipokey = this.getParameter("httpstipokey");
            String httpspwdkey = this.getLockedParameter("httpspwdkey");
            String httpspwdprivatekey = this.getLockedParameter("httpspwdprivatekey");
            String httpsalgoritmokey = this.getParameter("httpsalgoritmokey");
            String httpsKeyAlias = this.getParameter("httpsaliasprivatekey");
            String httpsTrustStoreCRLs = this.getParameter("httpscrl");
            String httpsTrustStoreOCSPPolicy = this.getParameter("httpsocsp");
            String httpsKeyStoreBYOKPolicy = this.getParameter("httpsbyok");
            if (TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                user = this.getParameter("utenteInv");
                password = this.getLockedParameter("passwordInv");
            }
            String requestOutputFileName = this.getParameter("requestOutputFileName");
            String requestOutputFileNamePermissions = this.getParameter("requestOutputFileNameP");
            String requestOutputFileNameHeaders = this.getParameter("requestOutputFileNameHeaders");
            String requestOutputFileNameHeadersPermissions = this.getParameter("requestOutputFileNameHeadersP");
            String requestOutputParentDirCreateIfNotExists = this.getParameter("requestOutputDirectoryAutoCreate");
            String requestOutputOverwriteIfExists = this.getParameter("requestOutputOverwriteFileName");
            String responseInputMode = this.getParameter("responseInputMode");
            String responseInputFileName = this.getParameter("responseInputFileName");
            String responseInputFileNameHeaders = this.getParameter("responseInputFileNameHeaders");
            String responseInputDeleteAfterRead = this.getParameter("responseInputFileNameDelete");
            String responseInputWaitTime = this.getParameter("responseInputWaitTime");
            ConnettoreStatusParams connettoreStatusParams = ConnettoreStatusParams.fillFrom(this);
            org.openspcoop2.core.config.Connettore connis = invServizio.getConnettore();
            if (connis == null) {
                connis = new org.openspcoop2.core.config.Connettore();
            }
            String oldConnT = TipiConnettore.DISABILITATO.getNome();
            List<ExtendedConnettore> listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(connis, ConnettoreServletType.WIZARD_CONFIG, (ConsoleHelper)this, false, endpointtype);
            this.fillConnettore(connis, connettoreDebug, endpointtype, oldConnT, tipoconn, url, nomeCodaJMS, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, tokenPolicy, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, listExtendedConnettore);
            invServizio.setConnettore(connis);
        }
        finally {
            Utilities.setTipologiaConnettori(tipologiaConnettoriOriginale);
        }
        return invServizio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connettore readConnettore() throws Exception {
        TipologiaConnettori tipologiaConnettoriOriginale = null;
        try {
            tipologiaConnettoriOriginale = Utilities.getTipologiaConnettori(this.core);
            Utilities.setTipologiaConnettori(TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP);
            String endpointtype = this.readEndPointType();
            if (endpointtype == null) {
                Connettore connettore = null;
                return connettore;
            }
            String tipoconn = this.getParameter("tipoconn");
            String user = null;
            String password = null;
            String connettoreDebug = this.getParameter("connettore_debug");
            String autenticazioneTokenS = this.getParameter("connettore_token_policy_stat");
            boolean autenticazioneToken = ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenS);
            String tokenPolicy = this.getParameter("connettore_token_policy");
            String proxyEnabled = this.getParameter("connettore_proxy_enabled");
            String proxyHostname = this.getParameter("connettore_proxy_host");
            String proxyPort = this.getParameter("connettore_proxy_port");
            String proxyUsername = this.getParameter("connettore_proxy_username");
            String proxyPassword = this.getLockedParameter("connettore_proxy_password");
            String tempiRispostaEnabled = this.getParameter("connettore_tempi_redefine");
            String tempiRispostaConnectionTimeout = this.getParameter("connettore_tempi_ct");
            String tempiRispostaReadTimeout = this.getParameter("connettore_tempi_rt");
            String tempiRispostaTempoMedioRisposta = this.getParameter("connettore_tempi_avg");
            String transferMode = this.getParameter("transfer_mode");
            String transferModeChunkSize = this.getParameter("transfer_chunk_size");
            String redirectMode = this.getParameter("redirect_mode");
            String redirectMaxHop = this.getParameter("redirect_max_hop");
            String opzioniAvanzate = ConnettoriHelper.getOpzioniAvanzate(this, transferMode, redirectMode);
            String url = this.getParameter("url");
            if (TipiConnettore.HTTP.toString().equals(endpointtype)) {
                user = this.getParameter("utenteInv");
                password = this.getLockedParameter("passwordInv");
            }
            String autenticazioneApiKey = this.getParameter("endpointtype_apikey");
            String apiKeyHeader = this.getParameter("connettore_apikey_hdr");
            if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                apiKeyHeader = "X-API-KEY";
            }
            String apiKeyValue = this.getLockedParameter("connettore_apikey_value");
            String appIdHeader = this.getParameter("connettore_appid_header");
            if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                appIdHeader = "X-APP-ID";
            }
            String appIdValue = this.getParameter("connettore_appid_value");
            String useOAS3NamesTmp = this.getParameter("connettore_apikey_nomi_oas");
            boolean useOAS3Names = true;
            useOAS3Names = useOAS3NamesTmp != null && StringUtils.isNotEmpty((String)useOAS3NamesTmp) ? ServletUtils.isCheckBoxEnabled((String)useOAS3NamesTmp) : this.isAutenticazioneApiKeyUseOAS3Names(apiKeyHeader, appIdHeader);
            String useAppIdTmp = this.getParameter("connettore_appid_use");
            boolean useAppId = false;
            useAppId = useAppIdTmp != null && StringUtils.isNotEmpty((String)useAppIdTmp) ? ServletUtils.isCheckBoxEnabled((String)useAppIdTmp) : this.isAutenticazioneApiKeyUseAppId(appIdValue);
            String nomeCodaJMS = this.getParameter("nomeJms");
            String tipo = this.getParameter("tipoJms");
            String initcont = this.getParameter("initcont");
            String urlpgk = this.getParameter("urlpgk");
            String provurl = this.getParameter("provurl");
            String connfact = this.getParameter("connfact");
            String sendas = this.getParameter("sendas");
            if (TipiConnettore.JMS.toString().equals(endpointtype)) {
                user = this.getParameter("userJms");
                password = this.getLockedParameter("passwordJms");
            }
            String httpsurl = url;
            String httpstipologia = this.getParameter("httpstipologia");
            String httpshostverifyS = this.getParameter("httpshostverify");
            boolean httpshostverify = ServletUtils.isCheckBoxEnabled((String)httpshostverifyS);
            String httpsTrustVerifyCertS = this.getParameter("httpstrustverify");
            boolean httpsTrustVerifyCert = ServletUtils.isCheckBoxEnabled((String)httpsTrustVerifyCertS);
            String httpspath = this.getParameter("httpspath");
            String httpstipo = this.getParameter("httpstipo");
            String httpspwd = this.getLockedParameter("httpspwd");
            String httpsalgoritmo = this.getParameter("httpsalgoritmo");
            String httpsstatoS = this.getParameter("httpsstato");
            boolean httpsstato = ServletUtils.isCheckBoxEnabled((String)httpsstatoS);
            String httpskeystore = this.getParameter("httpskeystore");
            String httpspwdprivatekeytrust = this.getLockedParameter("httpspwdprivatekeytrust");
            String httpspathkey = this.getParameter("httpspathkey");
            String httpstipokey = this.getParameter("httpstipokey");
            String httpspwdkey = this.getLockedParameter("httpspwdkey");
            String httpspwdprivatekey = this.getLockedParameter("httpspwdprivatekey");
            String httpsalgoritmokey = this.getParameter("httpsalgoritmokey");
            String httpsKeyAlias = this.getParameter("httpsaliasprivatekey");
            String httpsTrustStoreCRLs = this.getParameter("httpscrl");
            String httpsTrustStoreOCSPPolicy = this.getParameter("httpsocsp");
            String httpsKeyStoreBYOKPolicy = this.getParameter("httpsbyok");
            if (TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                user = this.getParameter("utenteInv");
                password = this.getLockedParameter("passwordInv");
            }
            String requestOutputFileName = this.getParameter("requestOutputFileName");
            String requestOutputFileNamePermissions = this.getParameter("requestOutputFileNameP");
            String requestOutputFileNameHeaders = this.getParameter("requestOutputFileNameHeaders");
            String requestOutputFileNameHeadersPermissions = this.getParameter("requestOutputFileNameHeadersP");
            String requestOutputParentDirCreateIfNotExists = this.getParameter("requestOutputDirectoryAutoCreate");
            String requestOutputOverwriteIfExists = this.getParameter("requestOutputOverwriteFileName");
            String responseInputMode = this.getParameter("responseInputMode");
            String responseInputFileName = this.getParameter("responseInputFileName");
            String responseInputFileNameHeaders = this.getParameter("responseInputFileNameHeaders");
            String responseInputDeleteAfterRead = this.getParameter("responseInputFileNameDelete");
            String responseInputWaitTime = this.getParameter("responseInputWaitTime");
            ConnettoreStatusParams connettoreStatusParams = ConnettoreStatusParams.fillFrom(this);
            Connettore connettore = new Connettore();
            List<ExtendedConnettore> listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(connettore, ConnettoreServletType.WIZARD_REGISTRY, (ConsoleHelper)this, false, endpointtype);
            String oldConnT = TipiConnettore.DISABILITATO.getNome();
            this.fillConnettore(connettore, connettoreDebug, endpointtype, oldConnT, tipoconn, url, nomeCodaJMS, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, tokenPolicy, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, listExtendedConnettore);
            Connettore connettore2 = connettore;
            return connettore2;
        }
        finally {
            Utilities.setTipologiaConnettori(tipologiaConnettoriOriginale);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addImportInformationMissingToDati(List<DataElement> dati, ImporterUtils importerUtils, FormFile ff, String protocolloSelect, String inputMode, String protocolloEffettivo, String inputType, boolean validazioneDocumenti, boolean updateEnabled, boolean importDeletePolicyConfig, boolean importDeletePluginConfig, boolean importConfig, ImportInformationMissingCollection importInformationMissingCollection, ImportInformationMissingException importInformationMissingException, String modalitaAcquisizioneInformazioniProtocollo, List<PortType> portTypesOpenSPCoop, List<String> protocolliForModes, boolean readedDatiConnettori, Wizard wizard, int step, boolean delete) throws Exception {
        InterfaceType originalInterfaceType;
        DataElement de;
        ServiceBinding serviceBinding;
        boolean showSection;
        block127: {
            int contatoreServizio;
            String protocolloAccordo;
            Object idAccordo;
            block128: {
                block126: {
                    Object oldMessage = this.pd.getMessage();
                    oldMessage = oldMessage != null && !"".equals(oldMessage) ? "<BR><BR><B>Errore</B>: " + (String)oldMessage : "";
                    boolean showIntestazioneArchivio = true;
                    showSection = true;
                    serviceBinding = null;
                    if (wizard != null) {
                        if (importInformationMissingException != null && importInformationMissingException.isMissingRequisitiInfoInput()) {
                            this.pd.setMessage(wizard.getDescrizione() + (String)oldMessage, org.openspcoop2.web.lib.mvc.Costanti.MESSAGE_TYPE_INFO);
                        } else {
                            ImportInformationMissing miss;
                            int actualStep = step;
                            int stepConfigurated = -1;
                            if (wizard.getStep() > 0) {
                                stepConfigurated = wizard.getStep();
                            }
                            if (delete && wizard.getStepInDelete() > 0) {
                                stepConfigurated = wizard.getStepInDelete();
                            }
                            if (importInformationMissingCollection != null && importInformationMissingCollection.exists("[[InformationMissingRequisiti]]") && (miss = importInformationMissingCollection.get("[[InformationMissingRequisiti]]")).getRequisitiInput() != null && !miss.getRequisitiInput().isEmpty() && miss.getRequisitiInputStepIncrement() != null && !miss.getRequisitiInputStepIncrement().isEmpty()) {
                                --actualStep;
                                for (String inputName : miss.getRequisitiInputStepIncrement().keySet()) {
                                    String stepIncrementValue_incrementNumber_incrementCondition = (String)miss.getRequisitiInputStepIncrement().get(inputName);
                                    int increment = -1;
                                    String stepIncrementValue = null;
                                    if (stepIncrementValue_incrementNumber_incrementCondition.contains(" ")) {
                                        String[] tmp = stepIncrementValue_incrementNumber_incrementCondition.split(" ");
                                        increment = Integer.valueOf(tmp[0]);
                                        stepIncrementValue = stepIncrementValue_incrementNumber_incrementCondition.substring((tmp[0] + " ").length());
                                    }
                                    String value = (String)miss.getRequisitiInput().get(inputName);
                                    if (stepIncrementValue == null || !stepIncrementValue.equals(value)) continue;
                                    stepConfigurated += increment;
                                }
                            }
                            String stepDescription = " (Fase " + actualStep;
                            if (stepConfigurated > 0) {
                                stepDescription = stepDescription + "/" + stepConfigurated;
                            }
                            stepDescription = stepDescription + ")";
                            this.pd.setMessage(wizard.getDescrizione() + stepDescription + (String)oldMessage, org.openspcoop2.web.lib.mvc.Costanti.MESSAGE_TYPE_INFO);
                        }
                        showIntestazioneArchivio = wizard.getIntestazioneOriginale();
                        if (importInformationMissingException != null) {
                            DataElement de2 = new DataElement();
                            de2.setLabel(importInformationMissingException.getIdObjectDescription());
                            de2.setType(DataElementType.TITLE);
                            dati.add(de2);
                        }
                        showSection = false;
                    } else {
                        this.pd.setMessage("Attenzione: L'archivio non possiede tutte le informazioni necessarie per completare l'operazione di import" + (String)oldMessage);
                    }
                    String sessionId = this.request.getSession().getId();
                    de = new DataElement();
                    de.setValue(protocolloSelect);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("protocollo");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue(inputMode);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("tipologiaArchivio");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue(inputType);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("tipoArchivio");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("" + validazioneDocumenti);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("validazioneDocumenti");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("" + updateEnabled);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("updateEnabled");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("" + importDeletePolicyConfig);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("policyConfigEnabled");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("" + importDeletePluginConfig);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("pluginConfigEnabled");
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setValue("" + importConfig);
                    de.setType(DataElementType.HIDDEN);
                    de.setName("configEnabled");
                    de.setSize(this.getSize());
                    dati.add(de);
                    if (importInformationMissingException != null) {
                        de = new DataElement();
                        de.setValue(importInformationMissingException.getIdObject());
                        de.setType(DataElementType.HIDDEN);
                        de.setName("importInformationMissingObjectId");
                        de.setSize(this.getSize());
                        dati.add(de);
                    }
                    File fileFormFile = importerUtils.writeFormFile(sessionId, ff);
                    de = new DataElement();
                    de.setValue(fileFormFile.getAbsolutePath());
                    de.setType(DataElementType.HIDDEN);
                    de.setName("filePath");
                    dati.add(de);
                    File fileImportInformationMissingCollection = null;
                    if (importInformationMissingCollection != null) {
                        fileImportInformationMissingCollection = importerUtils.writeImportInformationMissingCollectionFile(sessionId, importInformationMissingCollection);
                        de = new DataElement();
                        de.setValue(fileImportInformationMissingCollection.getAbsolutePath());
                        de.setType(DataElementType.HIDDEN);
                        de.setName("importInformationMissingCollectionFilePath");
                        dati.add(de);
                    }
                    de = new DataElement();
                    if (importInformationMissingException != null && importInformationMissingException.getClassObject() != null) {
                        de.setValue(importInformationMissingException.getClassObject().getName());
                    } else {
                        de.setValue("");
                    }
                    de.setType(DataElementType.HIDDEN);
                    de.setName("importInformationMissingClassObject");
                    dati.add(de);
                    File fileImportInformationMissingObject = null;
                    if (importInformationMissingException != null && importInformationMissingException.getObject() != null) {
                        fileImportInformationMissingObject = importerUtils.writeImportInformationMissingObjectFile(sessionId, importInformationMissingException.getObject());
                    }
                    de = new DataElement();
                    if (fileImportInformationMissingObject != null) {
                        de.setValue(fileImportInformationMissingObject.getAbsolutePath());
                    } else {
                        de.setValue("");
                    }
                    de.setType(DataElementType.HIDDEN);
                    de.setName("importInformationMissingObjectFilePath");
                    dati.add(de);
                    if (showIntestazioneArchivio) {
                        de = new DataElement();
                        de.setLabel("Archivio");
                        de.setType(DataElementType.TITLE);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setValue(ff.getFileName());
                    if (showIntestazioneArchivio) {
                        de.setType(DataElementType.TEXT);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                    }
                    de.setName("fileName");
                    de.setLabel("File Caricato");
                    dati.add(de);
                    if (importInformationMissingException != null) {
                        de = new DataElement();
                        de.setValue(importInformationMissingException.getIdObjectDescription());
                        if (showIntestazioneArchivio) {
                            de.setType(DataElementType.TEXT);
                        } else {
                            de.setType(DataElementType.HIDDEN);
                        }
                        de.setName("importInformationMissingObjectIdDescription");
                        de.setLabel("Descrizione");
                        dati.add(de);
                    }
                    if (importInformationMissingException != null && importInformationMissingException.isMissingRequisitiInfoInput()) {
                        HashMap<String, String> mapRequisitiInput;
                        RequisitoInput requisitoInput = importInformationMissingException.getMissingRequisitiInfoInputObject();
                        if (showSection) {
                            de = new DataElement();
                            de.setLabel(requisitoInput.getDescrizione());
                            de.setType(DataElementType.TITLE);
                            dati.add(de);
                        }
                        if ((mapRequisitiInput = this.readRequisitiInput()) == null) {
                            mapRequisitiInput = new HashMap();
                        }
                        for (int i = 0; i < requisitoInput.sizeProprietaList(); ++i) {
                            ProprietaRequisitoInput p = requisitoInput.getProprieta(i);
                            if (mapRequisitiInput.containsKey(p.getNome()) || p.getConditions() != null && !ImporterInformationMissingUtils.checkConditions((ConditionsType)p.getConditions(), mapRequisitiInput)) continue;
                            mapRequisitiInput.put(p.getNome(), p.getDefault());
                        }
                        int indexParam = 0;
                        for (int k = 0; k < requisitoInput.sizeProprietaList(); ++k) {
                            ProprietaRequisitoInput p = requisitoInput.getProprieta(k);
                            if (delete && !p.isUseInDelete() || p.getConditions() != null && !ImporterInformationMissingUtils.checkConditions((ConditionsType)p.getConditions(), mapRequisitiInput)) continue;
                            if (p.getHeader() != null) {
                                this.addDescriptionInformationMissingToDati(dati, p.getHeader());
                            }
                            boolean required = false;
                            String valore = p.getDefault();
                            if (mapRequisitiInput != null && mapRequisitiInput.containsKey(p.getNome())) {
                                valore = mapRequisitiInput.get(p.getNome());
                            }
                            de = new DataElement();
                            de.setName("RequisitoProprietaInputValue_" + indexParam);
                            switch (p.getTipo()) {
                                case HIDDEN: {
                                    de.setType(DataElementType.HIDDEN);
                                    de.setValue(valore);
                                    break;
                                }
                                case CHECKBOX: {
                                    de.setType(DataElementType.CHECKBOX);
                                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)valore));
                                    de.setPostBack(p.isReloadOnChange());
                                    break;
                                }
                                case TEXTEDIT: {
                                    de.setRequired(true);
                                    de.setType(DataElementType.TEXT_EDIT);
                                    de.setValue(valore);
                                    required = true;
                                    break;
                                }
                            }
                            de.setLabel(p.getLabel());
                            de.setSize(this.getSize());
                            dati.add(de);
                            de = new DataElement();
                            de.setName("RequisitoProprietaInputHidden_" + indexParam);
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + required);
                            dati.add(de);
                            de = new DataElement();
                            de.setName("RequisitoProprietaInputNameHidden_" + indexParam);
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(p.getNome());
                            dati.add(de);
                            de = new DataElement();
                            de.setName("RequisitoProprietaInputStepIncrementHidden_" + indexParam);
                            de.setType(DataElementType.HIDDEN);
                            de.setValue((String)(p.getStepIncrementCondition() == null ? "1 N.D." : p.getStepIncrement() + " " + p.getStepIncrementCondition()));
                            dati.add(de);
                            if (p.getFooter() != null) {
                                this.addDescriptionInformationMissingToDati(dati, p.getFooter());
                            }
                            ++indexParam;
                        }
                    }
                    if (importInformationMissingException != null && (importInformationMissingException.isMissingInfoSoggetto() || importInformationMissingException.isMissingInfoVersione() || importInformationMissingException.isMissingInfoAccordoServizioParteComune() || importInformationMissingException.isMissingInfoAccordoCooperazione())) {
                        Object selected;
                        String labelSection = "Informazioni d'identificazione mancanti";
                        String labelSoggettoDataElement = "Soggetto";
                        if (importInformationMissingException.isMissingInfoSoggetto() && !importInformationMissingException.isMissingInfoVersione() && !importInformationMissingException.isMissingInfoAccordoServizioParteComune() && !importInformationMissingException.isMissingInfoAccordoCooperazione()) {
                            labelSection = "Soggetto";
                            labelSoggettoDataElement = "Nome";
                        }
                        if (showSection) {
                            de = new DataElement();
                            de.setLabel(labelSection);
                            de.setType(DataElementType.TITLE);
                            dati.add(de);
                        }
                        if (importInformationMissingException.getMissingInfoHeader() != null) {
                            this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
                        }
                        if (importInformationMissingException.isMissingInfoSoggetto()) {
                            List<String> soggettiLabel = null;
                            try {
                                soggettiLabel = importerUtils.getIdSoggetti(protocolliForModes, inputMode, importInformationMissingException.getMissingInfoProtocollo(), importInformationMissingException.getMissingInfoSoggetto_tipoPdD(), wizard, this);
                            }
                            catch (Exception e) {
                                this.pd.setMessage(this.pd.getMessage() + "<BR><BR><B>Errore</B>: " + e.getMessage());
                                this.pd.disableEditMode();
                                return;
                            }
                            de = new DataElement();
                            de.setName("soggetto");
                            de.setType(DataElementType.SELECT);
                            de.setLabel(labelSoggettoDataElement);
                            de.setValues(soggettiLabel.toArray(new String[1]));
                            ArrayList<String> labelSoggettiByProtocol = new ArrayList<String>();
                            for (String soggetto : soggettiLabel) {
                                if (soggetto.contains("/")) {
                                    IDSoggetto idSoggetto = new IDSoggetto(soggetto.split("/")[0], soggetto.split("/")[1]);
                                    labelSoggettiByProtocol.add(this.getLabelNomeSoggetto(idSoggetto));
                                    continue;
                                }
                                labelSoggettiByProtocol.add(soggetto);
                            }
                            de.setLabels(labelSoggettiByProtocol.toArray(new String[1]));
                            selected = null;
                            if (importInformationMissingException.getMissingInfoDefault() != null && importInformationMissingException.getMissingInfoDefault().getValore() != null && soggettiLabel.contains(importInformationMissingException.getMissingInfoDefault().getValore())) {
                                selected = importInformationMissingException.getMissingInfoDefault().getValore();
                            }
                            if (selected == null) {
                                selected = soggettiLabel.size() > 1 ? "-" : soggettiLabel.get(0);
                            }
                            de.setSelected((String)selected);
                            de.setSize(this.getSize());
                            dati.add(de);
                        }
                        if (importInformationMissingException.isMissingInfoVersione()) {
                            de = new DataElement();
                            de.setName("versione");
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setLabel("Versione");
                            Integer version = null;
                            if (importInformationMissingException.getMissingInfoDefault() != null && importInformationMissingException.getMissingInfoDefault().getValore() != null) {
                                try {
                                    version = Integer.valueOf(importInformationMissingException.getMissingInfoDefault().getValore());
                                }
                                catch (Exception labelSoggettiByProtocol) {
                                    // empty catch block
                                }
                            }
                            if (version == null) {
                                version = 1;
                            }
                            de.setValue("" + version);
                            de.setSize(30);
                            dati.add(de);
                        }
                        if (importInformationMissingException.isMissingInfoAccordoServizioParteComune()) {
                            List<String> accordiServizioParteComuneLabel = importerUtils.getIdAccordiServizioParteComune(protocolliForModes, inputMode, importInformationMissingException.getMissingInfoProtocollo(), this);
                            de = new DataElement();
                            de.setName("accordoServizioParteComune");
                            de.setType(DataElementType.SELECT);
                            de.setLabel("AccordoServizioParteComune/ServizioComposto");
                            de.setValues(accordiServizioParteComuneLabel.toArray(new String[1]));
                            ArrayList<String> labelAccordiByProtocol = new ArrayList<String>();
                            for (String uriAccordo : accordiServizioParteComuneLabel) {
                                idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(uriAccordo);
                                labelAccordiByProtocol.add(this.getLabelIdAccordo((IDAccordo)idAccordo));
                            }
                            de.setLabels(labelAccordiByProtocol.toArray(new String[1]));
                            selected = null;
                            if (importInformationMissingException.getMissingInfoDefault() != null && importInformationMissingException.getMissingInfoDefault().getValore() != null && accordiServizioParteComuneLabel.contains(importInformationMissingException.getMissingInfoDefault().getValore())) {
                                selected = importInformationMissingException.getMissingInfoDefault().getValore();
                            }
                            if (selected == null) {
                                selected = "-";
                            }
                            de.setSelected((String)selected);
                            de.setSize(this.getSize());
                            dati.add(de);
                        }
                        if (importInformationMissingException.isMissingInfoAccordoCooperazione()) {
                            List<String> accordiCooperazioneLabel = importerUtils.getIdAccordiCooperazione(protocolliForModes, inputMode, importInformationMissingException.getMissingInfoProtocollo(), this);
                            de = new DataElement();
                            de.setName("accordoCooperazione");
                            de.setType(DataElementType.SELECT);
                            de.setLabel("AccordoCooperazione");
                            de.setValues(accordiCooperazioneLabel.toArray(new String[1]));
                            ArrayList<String> labelAccordiByProtocol = new ArrayList<String>();
                            for (String uriAccordo : accordiCooperazioneLabel) {
                                idAccordo = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(uriAccordo);
                                labelAccordiByProtocol.add(this.getLabelIdAccordoCooperazione((IDAccordoCooperazione)idAccordo));
                            }
                            de.setLabels(labelAccordiByProtocol.toArray(new String[1]));
                            selected = null;
                            if (importInformationMissingException.getMissingInfoDefault() != null && importInformationMissingException.getMissingInfoDefault().getValore() != null && accordiCooperazioneLabel.contains(importInformationMissingException.getMissingInfoDefault().getValore())) {
                                selected = importInformationMissingException.getMissingInfoDefault().getValore();
                            }
                            if (selected == null) {
                                selected = "-";
                            }
                            de.setSelected((String)selected);
                            de.setSize(this.getSize());
                            dati.add(de);
                        }
                        if (importInformationMissingException.getMissingInfoFooter() != null) {
                            this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoFooter());
                        }
                    }
                    if (importInformationMissingException != null && importInformationMissingException.isMissingInfoInput()) {
                        Input input = importInformationMissingException.getMissingInfoInputObject();
                        if (showSection) {
                            de = new DataElement();
                            de.setLabel(input.getDescrizione());
                            de.setType(DataElementType.TITLE);
                            dati.add(de);
                        }
                        for (int i = 0; i < input.sizeProprietaList(); ++i) {
                            Proprieta p = input.getProprieta(i);
                            if (delete && !p.isUseInDelete()) continue;
                            if (p.getHeader() != null) {
                                this.addDescriptionInformationMissingToDati(dati, p.getHeader());
                            }
                            de = new DataElement();
                            de.setName("ProprietaInputHidden_" + i);
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(p.getPlaceholder());
                            de.setSize(30);
                            dati.add(de);
                            de = new DataElement();
                            de.setName("ProprietaInputValue_" + i);
                            de.setRequired(true);
                            de.setType(DataElementType.TEXT_EDIT);
                            de.setLabel(p.getNome());
                            de.setValue(p.getDefault());
                            de.setSize(this.getSize());
                            dati.add(de);
                            if (p.getFooter() == null) continue;
                            this.addDescriptionInformationMissingToDati(dati, p.getFooter());
                        }
                    }
                    if (importInformationMissingException == null || !importInformationMissingException.isMissingInfoProfiliServizi()) break block126;
                    if (showSection) {
                        de = new DataElement();
                        de.setLabel("Informazioni di protocollo non presenti (es. profilo di collaborazione, correlazione per gli asincroni ...)");
                        de.setType(DataElementType.TITLE);
                        dati.add(de);
                    }
                    if (importInformationMissingException.getMissingInfoHeader() != null) {
                        this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
                    }
                    String[] modalitaAcquisizione = new String[]{"Automatica dall'accordo (WSDL,SpecificaConversazione,...)", "Configurazione manuale dei servizi e delle operazioni presenti nel WSDL"};
                    de = new DataElement();
                    de.setName("modalitaAcquisizione");
                    de.setLabel("Modalit\u00e0 Acquisizione");
                    de.setType(DataElementType.SELECT);
                    de.setValues(modalitaAcquisizione);
                    de.setSelected(modalitaAcquisizioneInformazioniProtocollo);
                    de.setPostBack(true);
                    dati.add(de);
                    if (modalitaAcquisizioneInformazioniProtocollo == null || !"Configurazione manuale dei servizi e delle operazioni presenti nel WSDL".equals(modalitaAcquisizioneInformazioniProtocollo)) break block127;
                    Object object = importInformationMissingException.getObject();
                    AccordoServizioParteComune aspc = (AccordoServizioParteComune)object;
                    serviceBinding = this.apcCore.toMessageServiceBinding(aspc.getServiceBinding());
                    protocolloAccordo = null;
                    if (aspc.getSoggettoReferente() != null && aspc.getSoggettoReferente().getTipo() != null) {
                        protocolloAccordo = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(aspc.getSoggettoReferente().getTipo());
                    }
                    if (protocolloAccordo == null) {
                        protocolloAccordo = protocolloEffettivo;
                    }
                    BasicArchive basicArchive = new BasicArchive((IProtocolFactory)new BasicProtocolFactory(this.log));
                    basicArchive.setProtocolInfo(aspc, ControlStationCore.getLog());
                    if (aspc.sizePortTypeList() <= 0) {
                        throw new Exception("Informazioni di protocollo non definite e i wsdl presenti all'interno dell'archivio non possiedeno nemmeno un port type");
                    }
                    contatoreServizio = 1;
                    idAccordo = aspc.getPortTypeList().iterator();
                    break block128;
                }
                de = new DataElement();
                de.setName("modalitaAcquisizione");
                de.setLabel("Modalit\u00e0 Acquisizione");
                de.setType(DataElementType.HIDDEN);
                de.setValue("");
                dati.add(de);
                break block127;
            }
            while (idAccordo.hasNext()) {
                PortType ptWSDL = (PortType)idAccordo.next();
                PortType ptOpenSPCoop = null;
                if (portTypesOpenSPCoop.size() >= contatoreServizio) {
                    ptOpenSPCoop = portTypesOpenSPCoop.get(contatoreServizio - 1);
                }
                de = new DataElement();
                de.setLabel("Informazioni per il port type '@PT_NAME@'".replace("@PT_NAME@", ptWSDL.getNome()));
                de.setType(DataElementType.TITLE);
                dati.add(de);
                de = new DataElement();
                de.setName("servizioInputIsDefined" + contatoreServizio);
                de.setType(DataElementType.HIDDEN);
                de.setValue(CostantiConfigurazione.ABILITATO.toString());
                dati.add(de);
                String nomeFieldServizio = "servizioInput" + contatoreServizio;
                de = new DataElement();
                de.setName(nomeFieldServizio);
                de.setType(DataElementType.TEXT_EDIT);
                if (ptOpenSPCoop != null) {
                    de.setValue(ptOpenSPCoop.getNome());
                } else {
                    de.setValue(ptWSDL.getNome());
                }
                de.setLabel("Nome servizio");
                de.setSize(this.getSize());
                dati.add(de);
                ++contatoreServizio;
                int contatoreAzione = 1;
                for (Operation opWSDL : ptWSDL.getAzioneList()) {
                    Operation opOpenSPCoop = null;
                    if (ptOpenSPCoop != null && ptOpenSPCoop.sizeAzioneList() >= contatoreAzione) {
                        opOpenSPCoop = ptOpenSPCoop.getAzione(contatoreAzione - 1);
                    }
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Operation '@OP_NAME@'".replace("@OP_NAME@", opWSDL.getNome()));
                    de.setSize(this.getSize());
                    dati.add(de);
                    de = new DataElement();
                    de.setName(nomeFieldServizio + "_azioneInputIsDefined" + contatoreAzione);
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(CostantiConfigurazione.ABILITATO.toString());
                    dati.add(de);
                    de = new DataElement();
                    de.setName(nomeFieldServizio + "_azioneInput" + contatoreAzione);
                    de.setType(DataElementType.TEXT_EDIT);
                    if (opOpenSPCoop != null) {
                        de.setValue(opOpenSPCoop.getNome());
                    } else {
                        de.setValue(opWSDL.getNome());
                    }
                    de.setLabel("Nome azione");
                    de.setSize(this.getSize());
                    dati.add(de);
                    String profiloCollaborazione = null;
                    if (opOpenSPCoop != null) {
                        if (opOpenSPCoop.getProfiloCollaborazione() != null) {
                            profiloCollaborazione = opOpenSPCoop.getProfiloCollaborazione().toString();
                        }
                    } else if (opWSDL.getProfiloCollaborazione() != null) {
                        profiloCollaborazione = opWSDL.getProfiloCollaborazione().toString();
                    }
                    de = new DataElement();
                    de.setName(nomeFieldServizio + "_profiloCollaborazioneInput" + contatoreAzione);
                    de.setLabel("Profilo di collaborazione");
                    de.setType(DataElementType.SELECT);
                    de.setValues(this.core.getProfiliDiCollaborazioneSupportatiDalProtocollo(protocolloAccordo, serviceBinding));
                    de.setSelected(profiloCollaborazione);
                    if (this.archiviCore.isShowCorrelazioneAsincronaInAccordi()) {
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_ASIMMETRICO.equals(profiloCollaborazione) || AccordiServizioParteComuneCostanti.TIPO_PROFILO_COLLABORAZIONE_ASINCRONO_SIMMETRICO.equals(profiloCollaborazione)) {
                        de = new DataElement();
                        de.setName(nomeFieldServizio + "_servizioAzioneCorrelataInput" + contatoreAzione);
                        de.setType(DataElementType.TEXT_EDIT);
                        if (opOpenSPCoop != null && opOpenSPCoop.getCorrelataServizio() != null) {
                            de.setValue(opOpenSPCoop.getCorrelataServizio());
                        } else {
                            de.setValue("");
                        }
                        de.setLabel("Nome del servizio di richiesta correlato");
                        de.setSize(this.getSize());
                        dati.add(de);
                        de = new DataElement();
                        de.setName(nomeFieldServizio + "_azioneCorrelataInput" + contatoreAzione);
                        de.setType(DataElementType.TEXT_EDIT);
                        if (opOpenSPCoop != null && opOpenSPCoop.getCorrelata() != null) {
                            de.setValue(opOpenSPCoop.getCorrelata());
                        } else {
                            de.setValue("");
                        }
                        de.setLabel("Nome dell'azione di richiesta correlata");
                        de.setSize(this.getSize());
                        dati.add(de);
                    }
                    ++contatoreAzione;
                }
            }
        }
        if (importInformationMissingException != null && importInformationMissingException.isMismatchPortTypeRifServiziParteComune()) {
            if (showSection) {
                de = new DataElement();
                de.setLabel("Servizio (PortType) implementato non esistente");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            if (importInformationMissingException.getMissingInfoHeader() != null) {
                this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
            }
            de = new DataElement();
            de.setType(DataElementType.NOTE);
            de.setValue("Il servizio implementato (@ID_PORT_TYPE@) non risulta registrato nell'accordo di servizio parte comune (o composto) riferito. Selezionare uno dei servizi esistenti".replace("@ID_PORT_TYPE@", importInformationMissingException.getMismatchPortTypeRifServiziParteComune_nome()));
            dati.add(de);
            de = new DataElement();
            de.setLabel("Servizio");
            de.setType(DataElementType.SELECT);
            ArrayList<String> listServizi = new ArrayList<String>();
            listServizi.add("-");
            listServizi.addAll(importInformationMissingException.getMismatchPortTypeRifServiziParteComune_serviziParteComune());
            de.setValues(listServizi);
            de.setSelected("-");
            de.setName("portTypeImplemented");
            dati.add(de);
            if (importInformationMissingException.getMissingInfoFooter() != null) {
                this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoFooter());
            }
        }
        if (importInformationMissingException != null && importInformationMissingException.isMissingInfoInvocazioneServizio()) {
            block123: {
                if (importInformationMissingException.getMissingInfoHeader() != null) {
                    this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
                }
                originalInterfaceType = null;
                User userSession = null;
                try {
                    String protocollo = importInformationMissingException.getMissingInfoProtocollo();
                    if (protocollo == null) {
                        protocollo = protocolloEffettivo;
                    }
                    InterfaceType interfaceType = InterfaceType.STANDARD;
                    TipologiaConnettori tipologiaConnettori = null;
                    Default defaultProperties = importInformationMissingException.getMissingInfoDefault();
                    if (defaultProperties != null && defaultProperties.sizeProprietaList() > 0) {
                        for (ProprietaDefault p : defaultProperties.getProprietaList()) {
                            if ("interfaccia".equalsIgnoreCase(p.getNome())) {
                                if ("standard".equalsIgnoreCase(p.getValore())) {
                                    interfaceType = InterfaceType.STANDARD;
                                    continue;
                                }
                                if (!"avanzata".equalsIgnoreCase(p.getValore())) continue;
                                interfaceType = InterfaceType.AVANZATA;
                                continue;
                            }
                            if (!"connettore".equalsIgnoreCase(p.getNome())) continue;
                            if ("http".equalsIgnoreCase(p.getValore())) {
                                tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP;
                                continue;
                            }
                            if (!"qualsiasi".equalsIgnoreCase(p.getValore())) continue;
                            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
                        }
                    }
                    userSession = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                    originalInterfaceType = userSession.getInterfaceType();
                    userSession.setInterfaceType(interfaceType);
                    String sbustamento = null;
                    String sbustamentoInformazioniProtocolloRichiesta = null;
                    String getmsg = null;
                    String getmsgUsername = null;
                    String getmsgPassword = null;
                    sbustamento = this.getParameter(readedDatiConnettori, defaultProperties, "sbustamento");
                    sbustamentoInformazioniProtocolloRichiesta = this.getParameter(readedDatiConnettori, defaultProperties, "sbustamentoInformazioniProtocolloRichiesta");
                    getmsg = this.getParameter(readedDatiConnettori, defaultProperties, "getmsg");
                    getmsgUsername = this.getParameter(readedDatiConnettori, defaultProperties, "utenteCredenziali");
                    getmsgPassword = this.getParameter(readedDatiConnettori, defaultProperties, "passwordCredenziali");
                    boolean erogazioneServizioApplicativoServerEnabled = false;
                    boolean integrationManagerEnabled = !this.isModalitaStandard() && this.archiviCore.isIntegrationManagerEnabled();
                    boolean postBackViaPost = true;
                    this.addEndPointToDati(dati, "", "", sbustamento, sbustamentoInformazioniProtocolloRichiesta, getmsg, getmsgUsername, getmsgPassword, true, null, null, protocollo, false, true, showSection, null, null, null, erogazioneServizioApplicativoServerEnabled, null, false, integrationManagerEnabled, TipoOperazione.ADD, null, null, postBackViaPost);
                    boolean forceEnabled = true;
                    boolean showSectionTitle = false;
                    if (!InterfaceType.STANDARD.equals((Object)interfaceType)) {
                        showSectionTitle = true;
                        forceEnabled = getmsg == null || !CostantiConfigurazione.ABILITATO.toString().equals(getmsg);
                    }
                    this.addDatiConnettore(dati, serviceBinding, readedDatiConnettori, importInformationMissingException.getMissingInfoDefault(), showSectionTitle, ConnettoreServletType.WIZARD_CONFIG, forceEnabled, tipologiaConnettori);
                    if (userSession == null) break block123;
                }
                catch (Throwable throwable) {
                    if (userSession != null) {
                        userSession.setInterfaceType(originalInterfaceType);
                    }
                    throw throwable;
                }
                userSession.setInterfaceType(originalInterfaceType);
            }
            if (importInformationMissingException.getMissingInfoFooter() != null) {
                this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoFooter());
            }
        }
        if (importInformationMissingException != null && importInformationMissingException.isMissingInfoConnettore()) {
            block124: {
                if (importInformationMissingException.getMissingInfoHeader() != null) {
                    this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
                }
                originalInterfaceType = null;
                User userSession = null;
                try {
                    InterfaceType interfaceType = InterfaceType.STANDARD;
                    TipologiaConnettori tipologiaConnettori = null;
                    Default defaultProperties = importInformationMissingException.getMissingInfoDefault();
                    if (defaultProperties != null && defaultProperties.sizeProprietaList() > 0) {
                        for (ProprietaDefault p : defaultProperties.getProprietaList()) {
                            if ("interfaccia".equalsIgnoreCase(p.getNome())) {
                                if ("standard".equalsIgnoreCase(p.getValore())) {
                                    interfaceType = InterfaceType.STANDARD;
                                    continue;
                                }
                                if (!"avanzata".equalsIgnoreCase(p.getValore())) continue;
                                interfaceType = InterfaceType.AVANZATA;
                                continue;
                            }
                            if (!"connettore".equalsIgnoreCase(p.getNome())) continue;
                            if ("http".equalsIgnoreCase(p.getValore())) {
                                tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP;
                                continue;
                            }
                            if (!"qualsiasi".equalsIgnoreCase(p.getValore())) continue;
                            tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
                        }
                    }
                    userSession = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                    originalInterfaceType = userSession.getInterfaceType();
                    userSession.setInterfaceType(interfaceType);
                    boolean forceEnabled = true;
                    this.addDatiConnettore(dati, serviceBinding, readedDatiConnettori, importInformationMissingException.getMissingInfoDefault(), showSection, ConnettoreServletType.WIZARD_REGISTRY, forceEnabled, tipologiaConnettori);
                    if (userSession == null) break block124;
                }
                catch (Throwable throwable) {
                    if (userSession != null) {
                        userSession.setInterfaceType(originalInterfaceType);
                    }
                    throw throwable;
                }
                userSession.setInterfaceType(originalInterfaceType);
            }
            if (importInformationMissingException.getMissingInfoFooter() != null) {
                this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoFooter());
            }
        }
        if (importInformationMissingException != null && importInformationMissingException.isMissingInfoCredenziali()) {
            block125: {
                if (importInformationMissingException.getMissingInfoHeader() != null) {
                    this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoHeader());
                }
                originalInterfaceType = null;
                User userSession = null;
                try {
                    userSession = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
                    originalInterfaceType = userSession.getInterfaceType();
                    userSession.setInterfaceType(InterfaceType.STANDARD);
                    this.addDatiCredenzialiAccesso(dati, readedDatiConnettori, importInformationMissingException.getMissingInfoDefault(), showSection);
                    if (userSession == null) break block125;
                }
                catch (Throwable throwable) {
                    if (userSession != null) {
                        userSession.setInterfaceType(originalInterfaceType);
                    }
                    throw throwable;
                }
                userSession.setInterfaceType(originalInterfaceType);
            }
            if (importInformationMissingException.getMissingInfoFooter() != null) {
                this.addDescriptionInformationMissingToDati(dati, importInformationMissingException.getMissingInfoFooter());
            }
        }
    }

    private void addDescriptionInformationMissingToDati(List<DataElement> dati, Description header) {
        for (DescriptionType item : header.getItemList()) {
            DataElement de = new DataElement();
            switch (item.getTipo()) {
                case TITLE: {
                    de.setType(DataElementType.TITLE);
                    break;
                }
                case SUBTITLE: {
                    de.setType(DataElementType.SUBTITLE);
                    break;
                }
                case NOTE: {
                    de.setType(DataElementType.NOTE);
                    break;
                }
                case TEXT: {
                    de.setType(DataElementType.TEXT);
                }
            }
            if (item.getLabel() != null) {
                de.setLabel(item.getLabel());
            }
            if (item.getValore() != null) {
                de.setValue(item.getValore());
            }
            if (item.isBold()) {
                de.setBold(true);
            }
            dati.add(de);
        }
    }

    private void addDatiCredenzialiAccesso(List<DataElement> dati, boolean readedDatiConnettori, Default defaultProperties, boolean showSectionTitle) throws Exception {
        String tipoauth = null;
        String utente = null;
        String password = null;
        String subject = null;
        String principal = null;
        String tipoCredenzialiSSLSorgente = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredenziali");
        if (tipoCredenzialiSSLSorgente == null) {
            tipoCredenzialiSSLSorgente = "confMan";
        }
        String tipoCredenzialiSSLTipoArchivioS = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredTipoArch");
        BinaryParameter tipoCredenzialiSSLFileCertificato = this.getBinaryParameter(readedDatiConnettori, defaultProperties, "confSSLCredFileCert");
        ArrayList<String> listaAliasEstrattiCertificato = new ArrayList<String>();
        String tipoCredenzialiSSLFileCertificatoPassword = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredFileCertPwd");
        String tipoCredenzialiSSLAliasCertificato = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCert");
        String tipoCredenzialiSSLAliasCertificatoSubject = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertSub");
        String tipoCredenzialiSSLAliasCertificatoIssuer = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertIss");
        String tipoCredenzialiSSLAliasCertificatoType = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertType");
        String tipoCredenzialiSSLAliasCertificatoVersion = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertVers");
        String tipoCredenzialiSSLAliasCertificatoSerialNumber = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertSN");
        String tipoCredenzialiSSLAliasCertificatoSelfSigned = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertSS");
        String tipoCredenzialiSSLAliasCertificatoNotBefore = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertNB");
        String tipoCredenzialiSSLAliasCertificatoNotAfter = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredAliasCertNA");
        String tipoCredenzialiSSLVerificaTuttiICampi = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredVerifTutti");
        String tipoCredenzialiSSLConfigurazioneManualeSelfSigned = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLManSS");
        String issuer = this.getParameter(readedDatiConnettori, defaultProperties, "subjectIssuer");
        String tipoCredenzialiSSLStatoElaborazioneCertificato = this.getParameter(readedDatiConnettori, defaultProperties, "confSSLCredWizStep");
        if (tipoCredenzialiSSLStatoElaborazioneCertificato == null) {
            tipoCredenzialiSSLStatoElaborazioneCertificato = "-1";
        }
        if ((tipoauth = this.getParameter(readedDatiConnettori, defaultProperties, "tipoauthCredenziali")) == null) {
            tipoauth = "nessuna";
        }
        utente = this.getParameter(readedDatiConnettori, defaultProperties, "utenteCredenziali");
        password = this.getParameter(readedDatiConnettori, defaultProperties, "passwordCredenziali");
        subject = this.getParameter(readedDatiConnettori, defaultProperties, "subjectCredenziali");
        principal = this.getParameter(readedDatiConnettori, defaultProperties, "principalCredenziali");
        String changepwd = this.getParameter(readedDatiConnettori, defaultProperties, "changepwd");
        String multipleApiKey = this.getParameter(readedDatiConnettori, defaultProperties, "apiKeyMultipleCred");
        String appId = this.getParameter(readedDatiConnettori, defaultProperties, "appIdCred");
        String apiKey = this.getParameter(readedDatiConnettori, defaultProperties, "apiKeyCred");
        String tokenPolicySA = this.getParameter("tokenPolicyCred");
        String tokenClientIdSA = this.getParameter("tokenClientIdCred");
        boolean tokenWithHttpsEnabledByConfigSA = false;
        if (tipoauth != null && !StringUtils.isEmpty((String)tokenPolicySA)) {
            boolean tokenModiPDNDOauth;
            boolean tokenByPDND = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth);
            boolean bl = tokenWithHttpsEnabledByConfigSA = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL_E_TOKEN_OAUTH.equals(tipoauth);
            if (tokenWithHttpsEnabledByConfigSA) {
                tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL;
            }
            boolean bl2 = tokenModiPDNDOauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_PDND.equals(tipoauth) || ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN_OAUTH.equals(tipoauth);
            if (tokenModiPDNDOauth) {
                tipoauth = ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN;
            }
            if (tokenPolicySA == null || StringUtils.isEmpty((String)tokenPolicySA) || "-".equals(tokenPolicySA)) {
                if (tokenByPDND) {
                    tokenPolicySA = this.saCore.getDefaultPolicyGestioneTokenPDND();
                }
            } else if (!tokenByPDND && (tokenWithHttpsEnabledByConfigSA || tokenModiPDNDOauth) && this.saCore.isPolicyGestioneTokenPDND(tokenPolicySA)) {
                tokenPolicySA = null;
            } else if (tokenByPDND && !this.saCore.isPolicyGestioneTokenPDND(tokenPolicySA)) {
                tokenPolicySA = this.saCore.getDefaultPolicyGestioneTokenPDND();
            }
        }
        if (tipoauth == null || tipoauth.equals("nessuna")) {
            tipoauth = this.saCore.getAutenticazione_generazioneAutomaticaPorteDelegate();
        }
        if (utente == null) {
            utente = "";
        }
        if (password == null) {
            password = "";
        }
        if (subject == null) {
            subject = "";
        }
        if (principal == null) {
            principal = "";
        }
        if (issuer == null) {
            issuer = "";
        }
        ArchiveType tipoCredenzialiSSLTipoArchivio = null;
        tipoCredenzialiSSLTipoArchivio = tipoCredenzialiSSLTipoArchivioS == null ? ArchiveType.CER : ArchiveType.valueOf((String)tipoCredenzialiSSLTipoArchivioS);
        if (tipoCredenzialiSSLConfigurazioneManualeSelfSigned == null) {
            tipoCredenzialiSSLConfigurazioneManualeSelfSigned = "no";
        }
        if (tipoCredenzialiSSLVerificaTuttiICampi == null) {
            tipoCredenzialiSSLVerificaTuttiICampi = "yes";
        }
        if (tipoCredenzialiSSLAliasCertificato == null) {
            tipoCredenzialiSSLAliasCertificato = "";
        }
        boolean visualizzaModificaCertificato = false;
        boolean visualizzaAddCertificato = false;
        String servletCredenzialiList = null;
        List<Parameter> parametersServletCredenzialiList = null;
        Integer numeroCertificati = null;
        String servletCredenzialiAdd = null;
        boolean postBackViaPost = false;
        this.addCredenzialiToDati(TipoOperazione.OTHER, dati, tipoauth, null, utente, password, subject, principal, "serviziApplicativiAdd.do", showSectionTitle, null, false, true, null, true, tipoCredenzialiSSLSorgente, tipoCredenzialiSSLTipoArchivio, tipoCredenzialiSSLFileCertificato, tipoCredenzialiSSLFileCertificatoPassword, listaAliasEstrattiCertificato, tipoCredenzialiSSLAliasCertificato, tipoCredenzialiSSLAliasCertificatoSubject, tipoCredenzialiSSLAliasCertificatoIssuer, tipoCredenzialiSSLAliasCertificatoType, tipoCredenzialiSSLAliasCertificatoVersion, tipoCredenzialiSSLAliasCertificatoSerialNumber, tipoCredenzialiSSLAliasCertificatoSelfSigned, tipoCredenzialiSSLAliasCertificatoNotBefore, tipoCredenzialiSSLAliasCertificatoNotAfter, tipoCredenzialiSSLVerificaTuttiICampi, tipoCredenzialiSSLConfigurazioneManualeSelfSigned, issuer, tipoCredenzialiSSLStatoElaborazioneCertificato, changepwd, multipleApiKey, appId, apiKey, visualizzaModificaCertificato, visualizzaAddCertificato, servletCredenzialiList, parametersServletCredenzialiList, numeroCertificati, servletCredenzialiAdd, false, tokenPolicySA, tokenClientIdSA, tokenWithHttpsEnabledByConfigSA, false, null, postBackViaPost);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDatiConnettore(List<DataElement> dati, ServiceBinding serviceBinding, boolean readedDatiConnettori, Default defaultProperties, boolean showSectionTitle, ConnettoreServletType connettoreServletType, boolean forceEnabled, TipologiaConnettori tipologiaConnettoriInfoMissing) throws Exception {
        TipologiaConnettori tipologiaConnettoriOriginale = null;
        try {
            tipologiaConnettoriOriginale = Utilities.getTipologiaConnettori(this.core);
            if (tipologiaConnettoriInfoMissing != null) {
                Utilities.setTipologiaConnettori(tipologiaConnettoriInfoMissing);
            } else {
                Utilities.setTipologiaConnettori(TipologiaConnettori.TIPOLOGIA_CONNETTORI_HTTP);
            }
            String endpointtype = null;
            String tipoconn = null;
            String autenticazioneHttp = null;
            String user = null;
            String password = null;
            String connettoreDebug = null;
            String url = null;
            String nomeCodaJMS = null;
            String tipo = null;
            String initcont = null;
            String urlpgk = null;
            String provurl = null;
            String connfact = null;
            String sendas = null;
            String httpsurl = null;
            String httpstipologia = null;
            String httpshostverifyS = null;
            boolean httpsTrustVerifyCert = true;
            String httpspath = null;
            String httpstipo = null;
            String httpspwd = null;
            String httpsalgoritmo = null;
            String httpsstatoS = null;
            String httpskeystore = null;
            String httpspwdprivatekeytrust = null;
            String httpspathkey = null;
            String httpstipokey = null;
            String httpspwdkey = null;
            String httpspwdprivatekey = null;
            String httpsalgoritmokey = null;
            String httpsKeyAlias = null;
            String httpsTrustStoreCRLs = null;
            String httpsTrustStoreOCSPPolicy = null;
            String httpsKeyStoreBYOKPolicy = null;
            boolean httpshostverify = false;
            boolean httpsstato = false;
            String proxyEnabled = null;
            String proxyHostname = null;
            String proxyPort = null;
            String proxyUsername = null;
            String proxyPassword = null;
            String tempiRispostaEnabled = null;
            String tempiRispostaConnectionTimeout = null;
            String tempiRispostaReadTimeout = null;
            String tempiRispostaTempoMedioRisposta = null;
            String transferMode = null;
            String transferModeChunkSize = null;
            String redirectMode = null;
            String redirectMaxHop = null;
            String opzioniAvanzate = null;
            String requestOutputFileName = null;
            String requestOutputFileNamePermissions = null;
            String requestOutputFileNameHeaders = null;
            String requestOutputFileNameHeadersPermissions = null;
            String requestOutputParentDirCreateIfNotExists = null;
            String requestOutputOverwriteIfExists = null;
            String responseInputMode = null;
            String responseInputFileName = null;
            String responseInputFileNameHeaders = null;
            String responseInputDeleteAfterRead = null;
            String responseInputWaitTime = null;
            endpointtype = this.getParameter(readedDatiConnettori, defaultProperties, "endpointtype");
            String endpointtypeCheck = this.getParameter(readedDatiConnettori, defaultProperties, "endpointtype_ckb");
            String endpointtypeSsl = this.getParameter(readedDatiConnettori, defaultProperties, "endpointtype_https");
            endpointtype = this.readEndPointType(endpointtype, endpointtypeCheck, endpointtypeSsl);
            if (endpointtype == null || forceEnabled && TipiConnettore.DISABILITATO.getNome().equals(endpointtype)) {
                endpointtype = TipiConnettore.HTTP.toString();
            }
            tipoconn = this.getParameter(readedDatiConnettori, defaultProperties, "tipoconn");
            autenticazioneHttp = this.getParameter(readedDatiConnettori, defaultProperties, "endpointtype_http");
            connettoreDebug = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_debug");
            String autenticazioneTokenS = this.getParameter("connettore_token_policy_stat");
            boolean autenticazioneToken = ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenS);
            String tokenPolicy = this.getParameter("connettore_token_policy");
            boolean forcePDND = false;
            boolean forceOAuth = false;
            proxyEnabled = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_proxy_enabled");
            proxyHostname = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_proxy_host");
            proxyPort = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_proxy_port");
            proxyUsername = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_proxy_username");
            proxyPassword = this.getLockedParameter(readedDatiConnettori, defaultProperties, "connettore_proxy_password");
            tempiRispostaEnabled = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_tempi_redefine");
            tempiRispostaConnectionTimeout = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_tempi_ct");
            tempiRispostaReadTimeout = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_tempi_rt");
            tempiRispostaTempoMedioRisposta = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_tempi_avg");
            transferMode = this.getParameter(readedDatiConnettori, defaultProperties, "transfer_mode");
            transferModeChunkSize = this.getParameter(readedDatiConnettori, defaultProperties, "transfer_chunk_size");
            redirectMode = this.getParameter(readedDatiConnettori, defaultProperties, "redirect_mode");
            redirectMaxHop = this.getParameter(readedDatiConnettori, defaultProperties, "redirect_max_hop");
            opzioniAvanzate = ConnettoriHelper.getOpzioniAvanzate(this, transferMode, redirectMode);
            url = this.getParameter(readedDatiConnettori, defaultProperties, "url");
            if (TipiConnettore.HTTP.toString().equals(endpointtype)) {
                user = this.getParameter(readedDatiConnettori, defaultProperties, "utenteInv");
                password = this.getLockedParameter(readedDatiConnettori, defaultProperties, "passwordInv");
            }
            String autenticazioneApiKey = this.getParameter(readedDatiConnettori, defaultProperties, "endpointtype_apikey");
            String apiKeyHeader = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_apikey_hdr");
            if (apiKeyHeader == null || StringUtils.isEmpty((String)apiKeyHeader)) {
                apiKeyHeader = "X-API-KEY";
            }
            String apiKeyValue = this.getLockedParameter(readedDatiConnettori, defaultProperties, "connettore_apikey_value");
            String appIdHeader = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_appid_header");
            if (appIdHeader == null || StringUtils.isEmpty((String)appIdHeader)) {
                appIdHeader = "X-APP-ID";
            }
            String appIdValue = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_appid_value");
            String useOAS3NamesTmp = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_apikey_nomi_oas");
            boolean useOAS3Names = true;
            useOAS3Names = useOAS3NamesTmp != null && StringUtils.isNotEmpty((String)useOAS3NamesTmp) ? ServletUtils.isCheckBoxEnabled((String)useOAS3NamesTmp) : this.isAutenticazioneApiKeyUseOAS3Names(apiKeyHeader, appIdHeader);
            String useAppIdTmp = this.getParameter(readedDatiConnettori, defaultProperties, "connettore_appid_use");
            boolean useAppId = false;
            useAppId = useAppIdTmp != null && StringUtils.isNotEmpty((String)useAppIdTmp) ? ServletUtils.isCheckBoxEnabled((String)useAppIdTmp) : this.isAutenticazioneApiKeyUseAppId(appIdValue);
            nomeCodaJMS = this.getParameter(readedDatiConnettori, defaultProperties, "nomeJms");
            tipo = this.getParameter(readedDatiConnettori, defaultProperties, "tipoJms");
            initcont = this.getParameter(readedDatiConnettori, defaultProperties, "initcont");
            urlpgk = this.getParameter(readedDatiConnettori, defaultProperties, "urlpgk");
            provurl = this.getParameter(readedDatiConnettori, defaultProperties, "provurl");
            connfact = this.getParameter(readedDatiConnettori, defaultProperties, "connfact");
            sendas = this.getParameter(readedDatiConnettori, defaultProperties, "sendas");
            if (TipiConnettore.JMS.toString().equals(endpointtype)) {
                user = this.getParameter(readedDatiConnettori, defaultProperties, "userJms");
                password = this.getLockedParameter(readedDatiConnettori, defaultProperties, "passwordJms");
            }
            httpsurl = url;
            httpstipologia = this.getParameter(readedDatiConnettori, defaultProperties, "httpstipologia");
            httpshostverifyS = this.getParameter(readedDatiConnettori, defaultProperties, "httpshostverify");
            httpshostverify = ServletUtils.isCheckBoxEnabled((String)httpshostverifyS);
            String httpsTrustVerifyCertS = this.getParameter(readedDatiConnettori, defaultProperties, "httpstrustverify");
            httpsTrustVerifyCert = ServletUtils.isCheckBoxEnabled((String)httpsTrustVerifyCertS);
            httpspath = this.getParameter(readedDatiConnettori, defaultProperties, "httpspath");
            httpstipo = this.getParameter(readedDatiConnettori, defaultProperties, "httpstipo");
            httpspwd = this.getLockedParameter(readedDatiConnettori, defaultProperties, "httpspwd");
            httpsalgoritmo = this.getParameter(readedDatiConnettori, defaultProperties, "httpsalgoritmo");
            httpsstatoS = this.getParameter(readedDatiConnettori, defaultProperties, "httpsstato");
            httpsstato = ServletUtils.isCheckBoxEnabled((String)httpsstatoS);
            httpskeystore = this.getParameter(readedDatiConnettori, defaultProperties, "httpskeystore");
            httpspwdprivatekeytrust = this.getLockedParameter(readedDatiConnettori, defaultProperties, "httpspwdprivatekeytrust");
            httpspathkey = this.getParameter(readedDatiConnettori, defaultProperties, "httpspathkey");
            httpstipokey = this.getParameter(readedDatiConnettori, defaultProperties, "httpstipokey");
            httpspwdkey = this.getLockedParameter(readedDatiConnettori, defaultProperties, "httpspwdkey");
            httpspwdprivatekey = this.getLockedParameter(readedDatiConnettori, defaultProperties, "httpspwdprivatekey");
            httpsalgoritmokey = this.getParameter(readedDatiConnettori, defaultProperties, "httpsalgoritmokey");
            httpsKeyAlias = this.getParameter(readedDatiConnettori, defaultProperties, "httpsaliasprivatekey");
            httpsTrustStoreCRLs = this.getParameter(readedDatiConnettori, defaultProperties, "httpscrl");
            httpsTrustStoreOCSPPolicy = this.getParameter(readedDatiConnettori, defaultProperties, "httpsocsp");
            httpsKeyStoreBYOKPolicy = this.getParameter(readedDatiConnettori, defaultProperties, "httpsbyok");
            if (TipiConnettore.HTTPS.toString().equals(endpointtype)) {
                user = this.getParameter(readedDatiConnettori, defaultProperties, "utenteInv");
                password = this.getLockedParameter(readedDatiConnettori, defaultProperties, "passwordInv");
            }
            requestOutputFileName = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputFileName");
            requestOutputFileNamePermissions = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputFileNameP");
            requestOutputFileNameHeaders = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputFileNameHeaders");
            requestOutputFileNameHeadersPermissions = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputFileNameHeadersP");
            requestOutputParentDirCreateIfNotExists = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputDirectoryAutoCreate");
            requestOutputOverwriteIfExists = this.getParameter(readedDatiConnettori, defaultProperties, "requestOutputOverwriteFileName");
            responseInputMode = this.getParameter(readedDatiConnettori, defaultProperties, "responseInputMode");
            responseInputFileName = this.getParameter(readedDatiConnettori, defaultProperties, "responseInputFileName");
            responseInputFileNameHeaders = this.getParameter(readedDatiConnettori, defaultProperties, "responseInputFileNameHeaders");
            responseInputDeleteAfterRead = this.getParameter(readedDatiConnettori, defaultProperties, "responseInputFileNameDelete");
            responseInputWaitTime = this.getParameter(readedDatiConnettori, defaultProperties, "responseInputWaitTime");
            ConnettoreStatusParams connettoreStatusParams = ConnettoreStatusParams.fillFrom(this);
            Boolean isConnettoreCustomUltimaImmagineSalvata = null;
            if (endpointtype == null || forceEnabled && TipiConnettore.DISABILITATO.getNome().equals(endpointtype)) {
                endpointtype = TipiConnettore.HTTP.toString();
            }
            org.openspcoop2.core.config.Connettore conTmp = null;
            List<ExtendedConnettore> listExtendedConnettore = ServletExtendedConnettoreUtils.getExtendedConnettore(conTmp, connettoreServletType, (ConsoleHelper)this, false, endpointtype);
            boolean postBackViaPost = true;
            this.addEndPointToDati(dati, serviceBinding, connettoreDebug, endpointtype, autenticazioneHttp, "", url, nomeCodaJMS, tipo, user, password, initcont, urlpgk, provurl, connfact, sendas, "serviziApplicativi", TipoOperazione.CHANGE, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, tipoconn, "serviziApplicativiEndPointInvocazioneServizio.do", "", "", null, null, null, null, null, null, showSectionTitle, isConnettoreCustomUltimaImmagineSalvata, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, autenticazioneToken, tokenPolicy, forcePDND, forceOAuth, listExtendedConnettore, forceEnabled, null, false, false, false, false, null, null, autenticazioneApiKey, useOAS3Names, useAppId, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, postBackViaPost);
        }
        finally {
            Utilities.setTipologiaConnettori(tipologiaConnettoriOriginale);
        }
    }

    public boolean accordiAllegatiCheckData(TipoOperazione tipoOperazione, FormFile formFile, Documento documento, ProprietariDocumento proprietario, IProtocolFactory<?> pf) throws Exception {
        try {
            String ruolo = this.getParameter("ruolo");
            if (ruolo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Tipo di documento");
                return false;
            }
            if (formFile == null || formFile.getFileName() != null && "".equals(formFile.getFileName())) {
                this.pd.setMessage("&Egrave; necessario selezionare un documento.");
                return false;
            }
            if (formFile == null || formFile.getFileSize() <= 0) {
                this.pd.setMessage("Il documento selezionato non pu&ograve; essere vuoto.");
                return false;
            }
            if (documento.getTipo() == null || "".equals(documento.getTipo()) || documento.getTipo().length() > 30 || formFile.getFileName().lastIndexOf(".") == -1) {
                if (documento.getTipo() == null || "".equals(documento.getTipo()) || formFile.getFileName().lastIndexOf(".") == -1) {
                    this.pd.setMessage("L'estensione del documento non &egrave; valida.");
                } else {
                    this.pd.setMessage("L'estensione del documento non &egrave; valida. La dimensione dell'estensione &egrave; troppo lunga.");
                }
                return false;
            }
            boolean documentoUnivocoIndipendentementeTipo = true;
            if (this.archiviCore.existsDocumento(documento, proprietario, documentoUnivocoIndipendentementeTipo)) {
                Documento existing;
                String tipo = documento.getTipo();
                String ruoloDoc = documento.getRuolo();
                Object msgTipo = "(tipo: " + documento.getTipo() + ") ";
                if (documentoUnivocoIndipendentementeTipo) {
                    tipo = null;
                    ruoloDoc = null;
                    msgTipo = "";
                }
                if ((existing = this.archiviCore.getDocumento(documento.getFile(), tipo, ruoloDoc, documento.getIdProprietarioDocumento(), false, proprietario)).getId().longValue() == documento.getId().longValue()) {
                    return true;
                }
                if (RuoliDocumento.allegato.toString().equals(documento.getRuolo()) || documentoUnivocoIndipendentementeTipo) {
                    this.pd.setMessage("L'allegato con nome " + documento.getFile() + " " + (String)msgTipo + "&egrave; gi&agrave; presente nella API.");
                } else {
                    this.pd.setMessage("La specifica semiformale con nome " + documento.getFile() + " " + (String)msgTipo + "&egrave; gi&agrave; presente nella API.");
                }
                return false;
            }
            ValidazioneResult valida = pf.createValidazioneDocumenti().valida(documento);
            if (!valida.isEsito()) {
                this.pd.setMessage(valida.getMessaggioErrore());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    public boolean accordiAllegatiCheckData(TipoOperazione tipoOperazione, List<BinaryParameter> binaryParameterDocumenti, Long idProprietarioDocumento, ProprietariDocumento proprietario, IProtocolFactory<?> pf) throws Exception {
        try {
            String ruolo = this.getParameter("ruolo");
            String tipoFile = this.getParameter("tipoFile");
            if (ruolo.equals("")) {
                this.pd.setMessage("Dati incompleti. &Egrave; necessario indicare il Tipo di documento");
                return false;
            }
            boolean almenoUnoSelezionato = false;
            for (int i = 0; i < binaryParameterDocumenti.size(); ++i) {
                BinaryParameter binaryParameter = binaryParameterDocumenti.get(i);
                if (binaryParameter.getValue() == null || binaryParameter.getValue().length <= 0) continue;
                almenoUnoSelezionato = true;
                break;
            }
            if (!almenoUnoSelezionato) {
                this.pd.setMessage("&Egrave; necessario selezionare almeno un documento.");
                return false;
            }
            ArrayList<Object> listaErrori = new ArrayList<Object>();
            for (int i = 0; i < binaryParameterDocumenti.size(); ++i) {
                ValidazioneResult valida;
                BinaryParameter binaryParameter = binaryParameterDocumenti.get(i);
                if (StringUtils.isBlank((String)binaryParameter.getFilename())) {
                    listaErrori.add("Il documento selezionato in posizione (" + (i + 1) + ") non ha un nome valido.");
                    continue;
                }
                if (binaryParameter.getValue() == null || binaryParameter.getValue().length <= 0) {
                    listaErrori.add("Il documento '" + binaryParameter.getFilename() + "' &egrave; vuoto.");
                    continue;
                }
                String tipo = null;
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        tipo = binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length());
                        break;
                    }
                    case specificaSemiformale: {
                        tipo = TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome();
                        break;
                    }
                    case specificaCoordinamento: {
                        tipo = TipiDocumentoCoordinamento.valueOf((String)tipoFile).getNome();
                    }
                }
                if (tipo == null || "".equals(tipo) || tipo.length() > 30 || binaryParameter.getFilename().lastIndexOf(".") == -1) {
                    if (tipo == null || "".equals(tipo) || binaryParameter.getFilename().lastIndexOf(".") == -1) {
                        listaErrori.add("L'estensione del documento '" + binaryParameter.getFilename() + "' non &egrave; valida.");
                        continue;
                    }
                    listaErrori.add("L'estensione del documento '" + binaryParameter.getFilename() + "' non &egrave; valida. La dimensione dell'estensione &egrave; troppo lunga.");
                    continue;
                }
                Documento documento = new Documento();
                documento.setRuolo(RuoliDocumento.valueOf((String)ruolo).toString());
                documento.setByteContenuto(binaryParameter.getValue());
                documento.setFile(binaryParameter.getFilename());
                switch (RuoliDocumento.valueOf((String)ruolo)) {
                    case allegato: {
                        documento.setTipo(binaryParameter.getFilename().substring(binaryParameter.getFilename().lastIndexOf(46) + 1, binaryParameter.getFilename().length()));
                        break;
                    }
                    case specificaSemiformale: {
                        documento.setTipo(TipiDocumentoSemiformale.valueOf((String)tipoFile).getNome());
                        break;
                    }
                    case specificaCoordinamento: {
                        documento.setTipo(TipiDocumentoCoordinamento.valueOf((String)tipoFile).getNome());
                    }
                }
                documento.setIdProprietarioDocumento(idProprietarioDocumento);
                boolean documentoUnivocoIndipendentementeTipo = true;
                if (this.archiviCore.existsDocumento(documento, proprietario, documentoUnivocoIndipendentementeTipo)) {
                    Documento existing;
                    tipo = documento.getTipo();
                    String ruoloDoc = documento.getRuolo();
                    Object msgTipo = "(tipo: " + documento.getTipo() + ") ";
                    if (documentoUnivocoIndipendentementeTipo) {
                        tipo = null;
                        ruoloDoc = null;
                        msgTipo = "";
                    }
                    if ((existing = this.archiviCore.getDocumento(documento.getFile(), tipo, ruoloDoc, documento.getIdProprietarioDocumento(), false, proprietario)).getId().longValue() != documento.getId().longValue()) {
                        if (RuoliDocumento.allegato.toString().equals(documento.getRuolo()) || documentoUnivocoIndipendentementeTipo) {
                            listaErrori.add("L'allegato con nome '" + documento.getFile() + "' " + (String)msgTipo + "&egrave; gi&agrave; presente nella API.");
                            continue;
                        }
                        listaErrori.add("La specifica semiformale con nome '" + documento.getFile() + "' " + (String)msgTipo + "&egrave; gi&agrave; presente nella API.");
                        continue;
                    }
                }
                if ((valida = pf.createValidazioneDocumenti().valida(documento)).isEsito()) continue;
                listaErrori.add(valida.getMessaggioErrore());
            }
            if (!listaErrori.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < listaErrori.size(); ++i) {
                    if (i != 0) {
                        sb.append("<br/>");
                    }
                    sb.append((String)listaErrori.get(i));
                }
                this.pd.setMessage(sb.toString());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.log.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new Exception(e);
        }
    }

    private String getLockedParameter(boolean readedDatiConnettori, Default defaultProperties, String name) throws Exception {
        return this.getParameterEngine(true, readedDatiConnettori, defaultProperties, name);
    }

    private String getParameter(boolean readedDatiConnettori, Default defaultProperties, String name) throws Exception {
        return this.getParameterEngine(false, readedDatiConnettori, defaultProperties, name);
    }

    private String getParameterEngine(boolean locked, boolean readedDatiConnettori, Default defaultProperties, String name) throws Exception {
        String value = null;
        if (!readedDatiConnettori) {
            String string = value = locked ? this.getLockedParameter(name) : this.getParameter(name);
        }
        if (value == null && defaultProperties != null && defaultProperties.sizeProprietaList() > 0) {
            for (ProprietaDefault defaultProperty : defaultProperties.getProprietaList()) {
                if (!name.equals(defaultProperty.getNome())) continue;
                return defaultProperty.getValore();
            }
        }
        return value;
    }

    private BinaryParameter getBinaryParameter(boolean readedDatiConnettori, Default defaultProperties, String name) throws Exception {
        BinaryParameter toReturn = this.getBinaryParameter(name);
        byte[] value = null;
        if (!readedDatiConnettori) {
            value = toReturn.getValue();
        }
        if (value == null && defaultProperties != null && defaultProperties.sizeProprietaList() > 0) {
            for (ProprietaDefault defaultProperty : defaultProperties.getProprietaList()) {
                if (!name.equals(defaultProperty.getNome())) continue;
                toReturn.setValue(defaultProperty.getValore().getBytes());
                break;
            }
        }
        return toReturn;
    }
}

