/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.slf4j.Logger;

public final class ErogazioniList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ErogazioniHelper erogazioniHelper = new ErogazioniHelper(request, pd, session);
            ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)true, (String)"_tabKey_vistaErogazioni");
            erogazioniHelper.makeMenu();
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SERVIZI;
            List<AccordoServizioParteSpecifica> lista = null;
            if (!ServletUtils.isSearchDone((IConsoleHelper)erogazioniHelper)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, AccordoServizioParteSpecifica.class);
            }
            ricerca = erogazioniHelper.checkSearchParameters(idLista, ricerca);
            erogazioniHelper.clearFiltroSoggettoByPostBackProtocollo(0, (ISearch)ricerca, idLista);
            String tipologiaParameterName = "_tabKey_tipologiaErogazione";
            String tipologia = erogazioniHelper.getParameter(tipologiaParameterName);
            if (tipologia == null) {
                tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
            }
            boolean gestioneFruitori = false;
            boolean gestioneErogatori = false;
            if (tipologia != null) {
                if ("fruizione".equals(tipologia)) {
                    gestioneFruitori = true;
                } else if ("erogazione".equals(tipologia)) {
                    gestioneErogatori = true;
                }
            }
            erogazioniHelper.checkGestione(request, session, ricerca, idLista, tipologiaParameterName, true);
            String superUser = ServletUtils.getUserLoginFromSession((HttpSession)session);
            PermessiUtente pu = ServletUtils.getUserFromSession((HttpServletRequest)request, (HttpSession)session).getPermessi();
            boolean[] permessi = new boolean[]{pu.isServizi(), pu.isAccordiCooperazione()};
            if (lista == null) {
                lista = apsCore.isVisioneOggettiGlobale(superUser) ? apsCore.soggettiServizioList(null, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori) : apsCore.soggettiServizioList(superUser, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori);
            }
            if (!erogazioniHelper.isPostBackFilterElement()) {
                ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
            }
            erogazioniHelper.prepareErogazioniList((ISearch)ricerca, lista);
            String msg = erogazioniHelper.getParameter("errorExport");
            if (msg != null && !"".equals(msg)) {
                pd.setMessage("Errore durante esportazione: " + msg);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"aspsErogazioni", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"aspsErogazioni", (ForwardParams)ForwardParams.LIST());
        }
    }
}

