/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteComuneServizioCompostoServizioComponente;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.UtilitiesSQLQuery;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;

public class AccordoServizioParteComuneServiziCompostiCore
extends ControlStationCore {
    protected AccordoServizioParteComuneServiziCompostiCore(ControlStationCore core) throws DriverControlStationException {
        super(core);
    }

    public List<IDAccordoDB> idAccordiServizioCompostiList(String superuser, ISearch ricerca, boolean soloAccordiConsistentiRest, boolean soloAccordiConsistentiSoap) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "idAccordiServizioCompostiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().idAccordiServizioCompostiList(superuser, ricerca, soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteComune> accordiServizioServiziComponentiConSoggettoErogatore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiServizio_serviziComponentiConSoggettoErogatore";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.accordiServizio_serviziComponentiConSoggettoErogatore(idSoggetto);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteComune> accordiServizioServiziComponenti(IDServizio idServizio) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiServizio_serviziComponenti";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.accordiServizio_serviziComponenti(idServizio);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteComune> accordiServizioWithAccordoCooperazione(IDAccordoCooperazione idAccordoCooperazione) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiServizioWithAccordoCooperazione";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.accordiServizioWithAccordoCooperazione(idAccordoCooperazione);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoServizioParteComuneServizioCompostoServizioComponente> accordiComponentiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiComponentiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().accordiComponentiList(idAccordo, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String[]> getAccordiServizioCompostoLabels(AccordoServizioParteComune as, long idAccordoLong, String userLogin, List<String> tipiServiziCompatibili, List<String> tipiSoggettiCompatibili, ConsoleHelper helper) {
        String[] serviziList = null;
        String[] serviziListLabel = null;
        Connection con = null;
        String nomeMetodo = "getAccordiServizioCompostoLabels";
        Statement stmt = null;
        ResultSet risultato = null;
        try {
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(this);
            con = ControlStationCore.dbM.getConnection();
            ISQLQueryObject sqlQueryObject = new UtilitiesSQLQuery().getSQLQueryObject();
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("acc_serv_composti");
            sqlQueryObject.addSelectCountField("servizi.id", "tot", true);
            sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo=?");
            sqlQueryObject.addWhereCondition("servizi.id_accordo<>?");
            if (as.getPrivato() == null || !as.getPrivato().booleanValue()) {
                sqlQueryObject.addWhereCondition("servizi.privato=?");
            }
            sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
            if (!this.isVisioneOggettiGlobale(userLogin)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObjectNotExist = new UtilitiesSQLQuery().getSQLQueryObject();
            sqlQueryObjectNotExist.addFromTable("acc_serv_componenti");
            sqlQueryObjectNotExist.addWhereCondition("acc_serv_componenti.id_servizio_composto=acc_serv_composti.id");
            sqlQueryObjectNotExist.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
            sqlQueryObjectNotExist.setANDLogicOperator(true);
            sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectNotExist);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idAccordoLong);
            stmt.setLong(2, idAccordoLong);
            int index = 3;
            if (as.getPrivato() == null || !as.getPrivato().booleanValue()) {
                stmt.setInt(index, 0);
                ++index;
            }
            if (!this.isVisioneOggettiGlobale(userLogin)) {
                stmt.setString(index, userLogin);
                ++index;
            }
            risultato = stmt.executeQuery();
            int totServ = 0;
            if (risultato.next()) {
                totServ = risultato.getInt("tot");
            }
            risultato.close();
            stmt.close();
            ArrayList<Object> serviziL = new ArrayList<Object>();
            ArrayList<String> serviziLabelL = new ArrayList<String>();
            serviziL.add("-1");
            serviziLabelL.add("-");
            if (totServ != 0) {
                sqlQueryObject = new UtilitiesSQLQuery().getSQLQueryObject();
                sqlQueryObject.addFromTable("servizi");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("acc_serv_composti");
                sqlQueryObject.addSelectAliasField("servizi", "id", "idServizio");
                sqlQueryObject.addWhereCondition("acc_serv_composti.id_accordo=?");
                sqlQueryObject.addWhereCondition("servizi.id_accordo<>?");
                if (as.getPrivato() == null || !as.getPrivato().booleanValue()) {
                    sqlQueryObject.addWhereCondition("servizi.privato=?");
                }
                sqlQueryObject.addWhereCondition("soggetti.id=servizi.id_soggetto");
                if (!this.isVisioneOggettiGlobale(userLogin)) {
                    sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObjectNotExist = new UtilitiesSQLQuery().getSQLQueryObject();
                sqlQueryObjectNotExist.addFromTable("acc_serv_componenti");
                sqlQueryObjectNotExist.addWhereCondition("acc_serv_componenti.id_servizio_composto=acc_serv_composti.id");
                sqlQueryObjectNotExist.addWhereCondition("acc_serv_componenti.id_servizio_componente=servizi.id");
                sqlQueryObjectNotExist.setANDLogicOperator(true);
                sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectNotExist);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idAccordoLong);
                stmt.setLong(2, idAccordoLong);
                index = 3;
                if (as.getPrivato() == null || !as.getPrivato().booleanValue()) {
                    stmt.setInt(index, 0);
                    ++index;
                }
                if (!this.isVisioneOggettiGlobale(userLogin)) {
                    stmt.setString(index, userLogin);
                    ++index;
                }
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    long idServizio = risultato.getLong("idServizio");
                    AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(idServizio);
                    if (!tipiServiziCompatibili.contains(asps.getTipo()) || !tipiSoggettiCompatibili.contains(asps.getTipoSoggettoErogatore())) continue;
                    serviziL.add("" + idServizio);
                    serviziLabelL.add(helper.getLabelIdServizio(asps));
                }
                risultato.close();
                stmt.close();
                serviziList = serviziL.toArray(new String[1]);
                serviziListLabel = serviziLabelL.toArray(new String[1]);
            }
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
        }
        finally {
            try {
                if (risultato != null) {
                    risultato.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            ControlStationCore.dbM.releaseConnection(con);
        }
        ArrayList<String[]> toRet = new ArrayList<String[]>();
        toRet.add(serviziList);
        toRet.add(serviziListLabel);
        return toRet;
    }
}

