/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ac;

import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationDB;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;

public class AccordiCooperazioneCore
extends ControlStationCore {
    public AccordiCooperazioneCore() throws Exception {
    }

    public AccordiCooperazioneCore(ControlStationCore core) throws Exception {
        super(core);
    }

    public ValidazioneResult validazione(AccordoCooperazione ac, SoggettiCore soggettiCore) throws DriverRegistroServiziException {
        String nomeMetodo = "validazione";
        try {
            String protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(ac.getSoggettoReferente().getTipo());
            IProtocolFactory protocol = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            return protocol.createValidazioneAccordi().valida(ac);
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
    }

    public long getIdAccordoCoopeazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "getIdAccordoCoopeazione";
        try {
            con = ControlStationCore.dbM.getConnection();
            long l = DBUtils.getIdAccordoCooperazione((IDAccordoCooperazione)idAccordo, (Connection)con, (String)this.tipoDB);
            return l;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDSoggetto> accordiCoopPartecipantiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiCoopPartecipantiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().accordiCoopPartecipantiList(idAccordo, ricerca);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public void validaStatoAccordoCooperazione(AccordoCooperazione ac) throws DriverRegistroServiziException, ValidazioneStatoPackageException {
        Connection con = null;
        String nomeMetodo = "validaStatoAccordoCooperazione";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            driver.validaStatoAccordoCooperazione(ac);
        }
        catch (ValidazioneStatoPackageException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] ValidazioneStatoPackageException :" + e.getMessage(), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError("[ControlStationCore::" + nomeMetodo + "] DriverRegistroServiziException :" + e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<Documento> accordiCoopAllegatiList(long idAccordo, ISearch ricerca) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiCoopAllegatiList";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().accordiCoopAllegatiList(idAccordo, ricerca);
            return list;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean isAccordoCooperazioneInUso(AccordoCooperazione ac, Map<ErrorsHandlerCostant, List<String>> whereIsInUso, boolean normalizeObjectIds) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "isAccordoCooperazioneInUso";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.isAccordoCooperazioneInUso(ac, whereIsInUso, normalizeObjectIds);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "existsAccordoCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            boolean bl = driver.getDriverRegistroServiziDB().existsAccordoCooperazione(idAccordo);
            return bl;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public IDAccordoCooperazione getIdAccordoCooperazione(long idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getIdAccordoCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            IDAccordoCooperazione iDAccordoCooperazione = driver.getDriverRegistroServiziDB().getIdAccordoCooperazione(idAccordo);
            return iDAccordoCooperazione;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAccordoCooperazione(id)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoCooperazione accordoCooperazione = driver.getDriverRegistroServiziDB().getAccordoCooperazione(idAccordo);
            return accordoCooperazione;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo, boolean deepRead) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAccordoCooperazione(id,deepRead)";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoCooperazione accordoCooperazione = driver.getDriverRegistroServiziDB().getAccordoCooperazione(idAccordo, deepRead);
            return accordoCooperazione;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public AccordoCooperazione getAccordoCooperazione(long idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAccordoCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            AccordoCooperazione accordoCooperazione = driver.getDriverRegistroServiziDB().getAccordoCooperazione(idAccordo);
            return accordoCooperazione;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException("[RegservCore::" + nomeMetodo + "] Error :" + e.getMessage(), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<IDAccordoCooperazione> getAllIdAccordiCooperazione(FiltroRicercaAccordi filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Connection con = null;
        String nomeMetodo = "getAccordoCooperazione";
        DriverControlStationDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverControlStationDB(con, null, this.tipoDB);
            List list = driver.getDriverRegistroServiziDB().getAllIdAccordiCooperazione(filtroRicerca);
            return list;
        }
        catch (DriverRegistroServiziNotFound e) {
            ControlStationCore.logDebug(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }

    public List<AccordoCooperazione> accordiCoopWithSoggettoPartecipante(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        Connection con = null;
        String nomeMetodo = "accordiCoopWithSoggettoPartecipante";
        DriverRegistroServiziDB driver = null;
        try {
            con = ControlStationCore.dbM.getConnection();
            driver = new DriverRegistroServiziDB(con, ControlStationCore.log, this.tipoDB);
            List list = driver.accordiCoopWithSoggettoPartecipante(idSoggetto);
            return list;
        }
        catch (DriverRegistroServiziException e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, (Exception)((Object)e)), e);
            throw e;
        }
        catch (Exception e) {
            ControlStationCore.logError(this.getPrefixError(nomeMetodo, e), e);
            throw new DriverRegistroServiziException(this.getPrefixError(nomeMetodo, e), (Throwable)e);
        }
        finally {
            ControlStationCore.dbM.releaseConnection(con);
        }
    }
}

