/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.util.Properties;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import org.openspcoop2.pdd.config.OpenSPCoop2ConfigurationException;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.resources.GestoreJNDI;
import org.openspcoop2.web.lib.queue.config.QueueProperties;

public class QueueManager {
    private static QueueManager manager;
    private static String cfName;
    private static Properties cfProp;
    private QueueConnectionFactory qcf;
    private GestoreJNDI jndi;

    private QueueManager() {
        try {
            QueueManager.readQueueProperties();
            this.jndi = new GestoreJNDI(cfProp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static synchronized void init() {
        if (manager == null) {
            manager = new QueueManager();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static QueueManager getInstance() {
        if (manager != null) return manager;
        Class<QueueManager> clazz = QueueManager.class;
        synchronized (QueueManager.class) {
            QueueManager.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public Queue getQueue(String queueName) throws UtilsException {
        return (Queue)this.jndi.lookup(queueName);
    }

    public QueueConnectionFactory getQueueConnectionFactory() throws NamingException {
        try {
            this.qcf = (QueueConnectionFactory)this.jndi.lookup(cfName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.qcf == null) {
            throw new NamingException("ConnectionFactory non inizializzata.");
        }
        return this.qcf;
    }

    private static void readQueueProperties() throws UtilsException, OpenSPCoop2ConfigurationException {
        QueueProperties queueProperties = QueueProperties.getInstance();
        cfName = queueProperties.getConnectionFactory();
        cfProp = queueProperties.getConnectionFactoryContext();
    }
}

