/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.sql;

import java.util.Hashtable;
import java.util.Vector;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLQueryObjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SQLQueryObjectCore
implements ISQLQueryObject {
    Vector<String> fields = new Vector();
    Vector<String> nomiFields = new Vector();
    Vector<String> tabelle = new Vector();
    Hashtable<String, String> alias = new Hashtable();
    Vector<String> conditions = new Vector();
    Vector<String> forceIndexTableNames = new Vector();
    boolean andLogicOperator = false;
    boolean notBeforeConditions = false;
    Vector<String> groupBy = new Vector();
    Vector<String> orderBy = new Vector();
    boolean sortTypeAsc = true;
    boolean distinct = false;
    int limit = -1;
    int offset = -1;
    Vector<String> updateFieldsName = new Vector();
    Vector<String> updateFieldsValue = new Vector();
    String updateTable = null;
    Vector<String> insertFieldsName = new Vector();
    Vector<String> insertFieldsValue = new Vector();
    String insertTable = null;

    @Override
    public void addSelectField(String nomeField) throws SQLQueryObjectException {
        this.addSelectField(null, nomeField);
    }

    @Override
    public void addSelectAliasField(String nomeField, String alias) throws SQLQueryObjectException {
        this.addSelectField(null, nomeField, alias, true);
    }

    @Override
    public void addSelectField(String nomeTabella, String nomeField) throws SQLQueryObjectException {
        this.addSelectField(nomeTabella, nomeField, null, true);
    }

    @Override
    public void addSelectAliasField(String nomeTabella, String nomeField, String alias) throws SQLQueryObjectException {
        this.addSelectField(nomeTabella, nomeField, alias, true);
    }

    protected void addSelectField(String nomeTabella, String nomeField, String alias, boolean addFieldName) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field is null or empty string");
        }
        if (alias != null) {
            if (this.fields.contains("*")) {
                throw new SQLQueryObjectException("Alias " + alias + " del field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.nomiFields.contains(alias)) {
                throw new SQLQueryObjectException("Alias " + alias + " gia inserito tra i select fields");
            }
        } else {
            if (!"*".equals(nomeField) && this.fields.contains("*")) {
                throw new SQLQueryObjectException("Field " + nomeField + " non utilizzabile tra i select fields. La presenza del select field '*' non permette di inserirne altri");
            }
            if (this.fields.contains(nomeField)) {
                throw new SQLQueryObjectException("Field " + nomeField + " gia inserito per tra i select fields");
            }
        }
        if (nomeTabella != null && !"".equals(nomeTabella)) {
            if (!this.tabelle.contains(nomeTabella)) {
                throw new SQLQueryObjectException("Tabella " + nomeTabella + " non esiste tra le tabella su cui effettuare la ricerca");
            }
            if (alias != null) {
                this.fields.add(nomeTabella + "." + nomeField + " as " + alias);
                this.alias.put(alias, nomeTabella + "." + nomeField);
            } else {
                this.fields.add(nomeTabella + "." + nomeField);
            }
        } else if (alias != null) {
            this.fields.add(nomeField + " as " + alias);
            this.alias.put(alias, nomeField);
        } else {
            this.fields.add(nomeField);
        }
        if (addFieldName) {
            if (alias != null) {
                this.nomiFields.add(alias);
            } else {
                this.nomiFields.add(nomeField);
            }
        }
    }

    @Override
    public void addSelectCountField(String fieldCount, String alias) throws SQLQueryObjectException {
        if (fieldCount == null) {
            fieldCount = "*";
        }
        String fieldSQL = "count(" + fieldCount + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    @Override
    public void addSelectCountField(String fieldCount, String alias, boolean distinct) throws SQLQueryObjectException {
        if (fieldCount == null && distinct) {
            throw new SQLQueryObjectException("Non e' possibile utilizzare DISTINCT senza specificare un fieldCount");
        }
        this.addSelectCountField("DISTINCT " + fieldCount, alias);
    }

    @Override
    public void addSelectAvgField(String fieldAvg, String alias) throws SQLQueryObjectException {
        if (fieldAvg == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "avg(" + fieldAvg + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    @Override
    public void addSelectAvgTimestampField(String fieldAvg, String alias) throws SQLQueryObjectException {
        this.addSelectAvgField(fieldAvg, alias);
    }

    @Override
    public void addSelectMaxField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(" + field + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    @Override
    public void addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        this.addSelectMaxField(field, alias);
    }

    @Override
    public void addSelectMinField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(" + field + ")";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    @Override
    public void addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        this.addSelectMinField(field, alias);
    }

    @Override
    public void addSelectForceIndex(String nomeTabella, String indexName) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabela is null or empty string");
        }
        if (indexName == null || "".equals(indexName)) {
            throw new SQLQueryObjectException("Nome indice is null or empty string");
        }
        String forceIndex = "/*+ index(" + nomeTabella + " " + indexName + ") */";
        if (this.forceIndexTableNames.contains(forceIndex)) {
            throw new SQLQueryObjectException("Forzatura all'utilizzo dell'indice (" + forceIndex + ") gia inserito tra le forzature");
        }
        this.forceIndexTableNames.add(forceIndex);
    }

    @Override
    public Vector<String> getFieldsName() throws SQLQueryObjectException {
        if (this.nomiFields == null || this.nomiFields.size() == 0) {
            throw new SQLQueryObjectException("Nessun field impostato");
        }
        return this.nomiFields;
    }

    @Override
    public void setSelectDistinct(boolean value) throws SQLQueryObjectException {
        this.distinct = value;
    }

    @Override
    public void addFromTable(String tabella) throws SQLQueryObjectException {
        if (tabella == null || "".equals(tabella)) {
            throw new SQLQueryObjectException("Tabella is null or empty string");
        }
        if (this.tabelle.contains(tabella)) {
            throw new SQLQueryObjectException("Tabella " + tabella + " gia' esistente tra le tabella su cui effettuare la ricerca");
        }
        this.tabelle.add(tabella);
    }

    @Override
    public void addWhereCondition(String condition) throws SQLQueryObjectException {
        if (condition == null || "".equals(condition)) {
            throw new SQLQueryObjectException("Where Condition is null or empty string");
        }
        String buildCondition = "( " + condition + " )";
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition)) {
            throw new SQLQueryObjectException("Where Condition " + condition + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
    }

    @Override
    public void addWhereCondition(boolean andLogicOperator, String ... conditions) throws SQLQueryObjectException {
        this.addWhereCondition(andLogicOperator, false, conditions);
    }

    @Override
    public void addWhereCondition(boolean andLogicOperator, boolean not, String ... conditions) throws SQLQueryObjectException {
        if (conditions == null || conditions.length <= 0) {
            throw new SQLQueryObjectException("Where Conditions non esistenti");
        }
        StringBuffer buildCondition = new StringBuffer();
        if (not) {
            buildCondition.append("( NOT ");
        }
        buildCondition.append("( ");
        for (int i = 0; i < conditions.length; ++i) {
            if (i > 0) {
                if (andLogicOperator) {
                    buildCondition.append(" AND ");
                } else {
                    buildCondition.append(" OR ");
                }
            }
            if (conditions[i] == null || "".equals(conditions[i])) {
                throw new SQLQueryObjectException("Where Condition[" + i + "] is null or empty string");
            }
            buildCondition.append("(");
            buildCondition.append(conditions[i]);
            buildCondition.append(")");
        }
        buildCondition.append(" )");
        if (not) {
            buildCondition.append(")");
        }
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition.toString());
    }

    private String createWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String escapeValue = SQLQueryObjectCore.escapeStringValue(searchPattern);
        String buildCondition = "( " + columnName + " LIKE '" + escapeValue + "' )";
        return buildCondition;
    }

    @Override
    public void addWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern);
    }

    private String createWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        if (columnName == null || "".equals(columnName)) {
            throw new SQLQueryObjectException("Where Condition column name is null or empty string");
        }
        if (searchPattern == null || "".equals(searchPattern)) {
            throw new SQLQueryObjectException("Where Condition searchPattern is null or empty string");
        }
        if (searchPattern.length() > 1) {
            if (searchPattern.startsWith("'")) {
                searchPattern = searchPattern.substring(1);
            }
            if (searchPattern.endsWith("'")) {
                searchPattern = searchPattern.substring(0, searchPattern.length() - 1);
            }
        }
        String buildCondition = null;
        String escapeValue = SQLQueryObjectCore.escapeStringValue(searchPattern);
        buildCondition = contains && caseInsensitive ? "( lower(" + columnName + ") LIKE '%" + escapeValue.toLowerCase() + "%' )" : (contains ? "( " + columnName + " LIKE '%" + escapeValue + "%' )" : (caseInsensitive ? "( lower(" + columnName + ") LIKE '" + escapeValue.toLowerCase() + "' )" : "( " + columnName + " LIKE '" + escapeValue + "' )"));
        return buildCondition;
    }

    @Override
    public void addWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        String buildCondition = this.createWhereLikeCondition(columnName, searchPattern, contains, caseInsensitive);
        if (buildCondition.indexOf("?") == -1 && this.conditions.contains(buildCondition.toString())) {
            throw new SQLQueryObjectException("Where Condition " + buildCondition.toString() + " gia' esistente tra le condizioni di where");
        }
        this.conditions.add(buildCondition);
    }

    @Override
    public String getWhereLikeCondition(String columnName, String searchPattern, boolean contains, boolean caseInsensitive) throws SQLQueryObjectException {
        return this.createWhereLikeCondition(columnName, searchPattern, contains, caseInsensitive);
    }

    private String createWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene effettuato il controllo di exists, non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append("EXISTS (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public void addWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereExistsCondition(notExists, sqlQueryObject));
    }

    @Override
    public String getWhereExistsCondition(boolean notExists, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        return this.createWhereExistsCondition(notExists, sqlQueryObject);
    }

    @Override
    public void addWhereSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, false, field, sqlQueryObject));
    }

    @Override
    public void addWhereINSelectSQLCondition(boolean notExists, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        this.addWhereCondition(this.createWhereSQLConditionCondition(notExists, true, field, sqlQueryObject));
    }

    private String createWhereSQLConditionCondition(boolean notExists, boolean in, String field, ISQLQueryObject sqlQueryObject) throws SQLQueryObjectException {
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("ISQLQueryObject, su cui viene costruita la ricerca, non fornito");
        }
        if (field == null) {
            throw new SQLQueryObjectException("Field non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (notExists) {
            bf.append("NOT ");
        }
        bf.append(field);
        if (in) {
            bf.append(" IN ");
        } else {
            bf.append(" = ");
        }
        bf.append(" (");
        bf.append(sqlQueryObject.createSQLQuery());
        bf.append(" )");
        return bf.toString();
    }

    @Override
    public void setANDLogicOperator(boolean andLogicOperator) throws SQLQueryObjectException {
        this.andLogicOperator = andLogicOperator;
    }

    @Override
    public void setNOTBeforeConditions(boolean not) throws SQLQueryObjectException {
        this.notBeforeConditions = not;
    }

    @Override
    public void addGroupBy(String groupByNomeField) throws SQLQueryObjectException {
        if (groupByNomeField == null || "".equals(groupByNomeField)) {
            throw new SQLQueryObjectException("GroupBy Condition is null or empty string");
        }
        this.groupBy.add(groupByNomeField);
    }

    @Override
    public void addOrderBy(String orderByNomeField) throws SQLQueryObjectException {
        if (orderByNomeField == null || "".equals(orderByNomeField)) {
            throw new SQLQueryObjectException("OrderBy Condition is null or empty string");
        }
        this.orderBy.add(orderByNomeField);
    }

    @Override
    public void setSortType(boolean sort) throws SQLQueryObjectException {
        if (this.orderBy.isEmpty()) {
            throw new SQLQueryObjectException("OrderBy Conditions non definite");
        }
        this.sortTypeAsc = sort;
    }

    @Override
    public void setLimit(int limit) throws SQLQueryObjectException {
        this.limit = limit;
    }

    @Override
    public void setOffset(int offset) throws SQLQueryObjectException {
        this.offset = offset;
    }

    @Override
    public abstract String createSQLQuery() throws SQLQueryObjectException;

    public String toString() {
        try {
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    @Override
    public String toString(boolean delete) {
        try {
            if (delete) {
                return this.createSQLDelete();
            }
            return this.createSQLQuery();
        }
        catch (Exception e) {
            return "Oggetto non corretto: " + e.getMessage();
        }
    }

    protected void checkUnionField(ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        int i;
        if (sqlQueryObject == null || sqlQueryObject.length <= 0) {
            throw new SQLQueryObjectException("Parametro is null");
        }
        if (sqlQueryObject.length == 1) {
            throw new SQLQueryObjectException("Parametro contiene un solo sqlQueryObject (minimo 2)");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            ISQLQueryObject sqlQueryObjectDaVerificare = sqlQueryObject[i];
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObjectDaVerificare.getFieldsName();
            if (nomiFieldSqlQueryObjectDaVerificare != null && nomiFieldSqlQueryObjectDaVerificare.size() != 0) continue;
            throw new SQLQueryObjectException("La select numero " + (i + 1) + " non possiede fields?");
        }
        for (i = 0; i < sqlQueryObject.length; ++i) {
            Vector<String> nomiFieldSqlQueryObjectDaVerificare = sqlQueryObject[i].getFieldsName();
            String[] nomi = nomiFieldSqlQueryObjectDaVerificare.toArray(new String[1]);
            for (int indiceField = 0; indiceField < nomi.length; ++indiceField) {
                String fieldDaVerificare = nomi[indiceField];
                for (int altriSqlObject = 0; altriSqlObject < sqlQueryObject.length; ++altriSqlObject) {
                    if (altriSqlObject == i || sqlQueryObject[altriSqlObject].getFieldsName().contains(fieldDaVerificare) || sqlQueryObject[altriSqlObject].getFieldsName().contains("*")) continue;
                    throw new SQLQueryObjectException("Field [" + fieldDaVerificare + "] trovato nella select numero " + (i + 1) + " non presente nella select numero " + (altriSqlObject + 1));
                }
            }
        }
    }

    @Override
    public void addUpdateTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.updateTable = nomeTabella;
    }

    @Override
    public void addUpdateField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.updateFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli update fields");
        }
        this.updateFieldsName.add(nomeField);
        this.updateFieldsValue.add(valueField);
    }

    @Override
    public void addInsertTable(String nomeTabella) throws SQLQueryObjectException {
        if (nomeTabella == null || "".equals(nomeTabella)) {
            throw new SQLQueryObjectException("Nome tabella is null or empty string");
        }
        this.insertTable = nomeTabella;
    }

    @Override
    public void addInsertField(String nomeField, String valueField) throws SQLQueryObjectException {
        if (nomeField == null || "".equals(nomeField)) {
            throw new SQLQueryObjectException("Field name is null or empty string");
        }
        if (valueField == null) {
            throw new SQLQueryObjectException("Field value is null");
        }
        if (this.insertFieldsName.contains(nomeField)) {
            throw new SQLQueryObjectException("Field name " + nomeField + " gia inserito tra gli insert fields");
        }
        this.insertFieldsName.add(nomeField);
        this.insertFieldsValue.add(valueField);
    }

    @Override
    public String createSQLInsert() throws SQLQueryObjectException {
        int i;
        if (this.insertTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'inserimento non definito");
        }
        if (this.insertFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da inserire presente");
        }
        if (this.insertFieldsName.size() != this.insertFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("INSERT INTO ");
        bf.append(this.insertTable);
        bf.append(" (");
        for (i = 0; i < this.insertFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsName.get(i));
        }
        bf.append(") VALUES (");
        for (i = 0; i < this.insertFieldsValue.size(); ++i) {
            if (i > 0) {
                bf.append(",");
            }
            bf.append(this.insertFieldsValue.get(i));
        }
        bf.append(")");
        return bf.toString();
    }

    @Override
    public void addDeleteTable(String tabella) throws SQLQueryObjectException {
        this.addFromTable(tabella);
    }

    public static String escapeStringValue(String value) throws SQLQueryObjectException {
        if (value == null) {
            throw new SQLQueryObjectException("Valore non fornito per escape");
        }
        int index = value.indexOf(39);
        if (index >= 0) {
            StringBuffer str = new StringBuffer();
            char[] v = value.toCharArray();
            for (int i = 0; i < v.length; ++i) {
                if (v[i] == '\'') {
                    str.append('\'');
                }
                str.append(v[i]);
            }
            return str.toString();
        }
        return value;
    }
}

