/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.sql;

import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.MySQLQueryObject;
import org.openspcoop.utils.sql.OracleQueryObject;
import org.openspcoop.utils.sql.PostgreSQLQueryObject;
import org.openspcoop.utils.sql.SQLQueryObjectCore;
import org.openspcoop.utils.sql.SQLQueryObjectException;

public class SQLObjectFactory {
    public static ISQLQueryObject createSQLQueryObject(String tipoDatabase) throws SQLQueryObjectException {
        SQLQueryObjectCore sqlQueryObject = null;
        if ("postgresql".equals(tipoDatabase)) {
            sqlQueryObject = new PostgreSQLQueryObject();
        } else if ("mysql".equals(tipoDatabase)) {
            sqlQueryObject = new MySQLQueryObject();
        } else if ("oracle".equals(tipoDatabase)) {
            sqlQueryObject = new OracleQueryObject();
        } else {
            throw new SQLQueryObjectException("Tipo database non gestito [" + tipoDatabase + "]");
        }
        return sqlQueryObject;
    }
}

