/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.sql;

import java.util.Iterator;
import org.openspcoop.utils.sql.ISQLQueryObject;
import org.openspcoop.utils.sql.SQLQueryObjectCore;
import org.openspcoop.utils.sql.SQLQueryObjectException;

public class OracleQueryObject
extends SQLQueryObjectCore {
    public void addSelectAvgTimestampField(String fieldAvg, String alias) throws SQLQueryObjectException {
        if (fieldAvg == null) {
            throw new SQLQueryObjectException("field avg non puo' essere null");
        }
        String fieldSQL = "avg(((cast(" + fieldAvg + " as date) - to_date('19700101','YYYYMMDD')) * 86400 * 1000))";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    public void addSelectMaxTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "max(((cast(" + field + " as date) - to_date('19700101','YYYYMMDD')) * 86400 * 1000))";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    public void addSelectMinTimestampField(String field, String alias) throws SQLQueryObjectException {
        if (field == null) {
            throw new SQLQueryObjectException("field non puo' essere null");
        }
        String fieldSQL = "min(((cast(" + field + " as date) - to_date('19700101','YYYYMMDD')) * 86400 * 1000))";
        if (alias != null) {
            fieldSQL = fieldSQL + " as " + alias;
        }
        this.addSelectField(null, fieldSQL, null, false);
        this.nomiFields.add(alias);
    }

    public String createSQLQuery() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT ");
        if (!(this.offset >= 0 || this.limit >= 0)) {
            Iterator itForceIndex = this.forceIndexTableNames.iterator();
            while (itForceIndex.hasNext()) {
                bf.append(" " + (String)itForceIndex.next() + " ");
            }
        }
        if (this.distinct) {
            bf.append(" DISTINCT ");
        }
        if (this.fields.size() == 0) {
            bf.append("*");
        } else {
            Iterator it = this.fields.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (!first) {
                    bf.append(",");
                } else {
                    first = false;
                }
                String field = (String)it.next();
                if (this.offset >= 0 || this.limit >= 0) {
                    String fLowerCase;
                    int indexOf = field.indexOf(".");
                    if (indexOf != -1 && indexOf + 1 < field.length()) {
                        field = field.substring(indexOf + 1);
                    }
                    if ((indexOf = (fLowerCase = field.toLowerCase()).indexOf(" as ")) != -1 && indexOf + 4 < field.length()) {
                        field = field.substring(indexOf + 4);
                        field = field.trim();
                    }
                }
                bf.append(field);
            }
        }
        bf.append(this.getSQL(false, false));
        return bf.toString();
    }

    public String createSQLDelete() throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        bf.append("DELETE ");
        bf.append(this.getSQL(true, false));
        return bf.toString();
    }

    private String getSQL(boolean delete, boolean update) throws SQLQueryObjectException {
        StringBuffer bf = new StringBuffer();
        if (!update) {
            bf.append(" FROM ");
            if (!(this.offset < 0 && this.limit < 0 || delete)) {
                String f;
                Iterator itForceIndex;
                if (!this.distinct) {
                    boolean first;
                    Iterator it;
                    bf.append(" ( SELECT ");
                    itForceIndex = this.forceIndexTableNames.iterator();
                    while (itForceIndex.hasNext()) {
                        bf.append(" " + (String)itForceIndex.next() + " ");
                    }
                    bf.append(" ROW_NUMBER() OVER ( ORDER BY ");
                    if (this.orderBy.size() == 0) {
                        throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                    }
                    if (this.orderBy.size() > 0) {
                        it = this.orderBy.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            String condizione = (String)it.next();
                            if (this.alias.containsKey(condizione)) {
                                bf.append((String)this.alias.get(condizione));
                                continue;
                            }
                            bf.append(condizione);
                        }
                        if (this.sortTypeAsc) {
                            bf.append(" ASC ");
                        } else {
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) AS rowNumber,");
                    if (this.fields.size() == 0) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" FROM ");
                    if (this.tabelle.size() == 0) {
                        throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                    }
                    it = this.tabelle.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                    if (this.conditions.size() > 0) {
                        bf.append(" WHERE ");
                        if (this.notBeforeConditions) {
                            bf.append(" NOT ( ");
                        }
                        for (int i = 0; i < this.conditions.size(); ++i) {
                            if (i > 0) {
                                if (this.andLogicOperator) {
                                    bf.append(" AND ");
                                } else {
                                    bf.append(" OR ");
                                }
                            }
                            String cond = (String)this.conditions.get(i);
                            bf.append(cond);
                        }
                        if (this.notBeforeConditions) {
                            bf.append(" )");
                        }
                    }
                } else {
                    boolean first;
                    Iterator it;
                    bf.append(" ( SELECT ");
                    itForceIndex = this.forceIndexTableNames.iterator();
                    while (itForceIndex.hasNext()) {
                        bf.append(" " + (String)itForceIndex.next() + " ");
                    }
                    bf.append(" ROWNUM AS rowNumber,");
                    if (this.fields.size() == 0) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            String fLowerCase;
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            String field = (String)it.next();
                            int indexOf = field.indexOf(".");
                            if (indexOf != -1 && indexOf + 1 < field.length()) {
                                field = field.substring(indexOf + 1);
                            }
                            if ((indexOf = (fLowerCase = field.toLowerCase()).indexOf(" as ")) != -1 && indexOf + 4 < field.length()) {
                                field = field.substring(indexOf + 4);
                                field = field.trim();
                            }
                            bf.append(field);
                        }
                    }
                    bf.append(" FROM ");
                    bf.append(" ( SELECT DISTINCT ");
                    if (this.fields.size() == 0) {
                        bf.append("*");
                    } else {
                        it = this.fields.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            f = (String)it.next();
                            bf.append(f);
                        }
                    }
                    bf.append(" FROM ");
                    if (this.tabelle.size() == 0) {
                        throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                    }
                    it = this.tabelle.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                    bf.append(" ");
                    if (this.conditions.size() > 0) {
                        bf.append(" WHERE ");
                        if (this.notBeforeConditions) {
                            bf.append(" NOT ( ");
                        }
                        for (int i = 0; i < this.conditions.size(); ++i) {
                            if (i > 0) {
                                if (this.andLogicOperator) {
                                    bf.append(" AND ");
                                } else {
                                    bf.append(" OR ");
                                }
                            }
                            String cond = (String)this.conditions.get(i);
                            bf.append(cond);
                        }
                        if (this.notBeforeConditions) {
                            bf.append(" )");
                        }
                    }
                    if (this.orderBy.size() == 0) {
                        throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
                    }
                    if (this.orderBy.size() > 0) {
                        bf.append(" ORDER BY ");
                        it = this.orderBy.iterator();
                        first = true;
                        while (it.hasNext()) {
                            if (!first) {
                                bf.append(",");
                            } else {
                                first = false;
                            }
                            bf.append((String)it.next());
                        }
                        if (this.sortTypeAsc) {
                            bf.append(" ASC ");
                        } else {
                            bf.append(" DESC ");
                        }
                    }
                    bf.append(" ) ");
                }
                bf.append(" ) WHERE ( ");
                if (this.offset >= 0) {
                    bf.append(" rowNumber > ");
                    bf.append(this.offset);
                }
                if (this.limit > 0) {
                    if (this.offset >= 0) {
                        bf.append(" AND");
                    }
                    bf.append(" rowNumber <=  ");
                    if (this.offset >= 0) {
                        bf.append(this.offset + this.limit);
                    } else {
                        bf.append(this.limit);
                    }
                }
                bf.append(" )");
                if (this.orderBy.size() > 0) {
                    bf.append(" ORDER BY ");
                    Iterator it = this.orderBy.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        String fLowerCase;
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        String field = (String)it.next();
                        Iterator itRicercaAlias = this.fields.iterator();
                        boolean findAlias = false;
                        while (itRicercaAlias.hasNext()) {
                            String fieldRicercaAliasa = (String)itRicercaAlias.next();
                            String[] split = null;
                            if (fieldRicercaAliasa.contains(" as ")) {
                                split = fieldRicercaAliasa.split(" as ");
                            } else if (fieldRicercaAliasa.contains(" As ")) {
                                split = fieldRicercaAliasa.split(" As ");
                            } else if (fieldRicercaAliasa.contains(" aS ")) {
                                split = fieldRicercaAliasa.split(" aS ");
                            } else if (fieldRicercaAliasa.contains(" AS ")) {
                                split = fieldRicercaAliasa.split(" AS ");
                            }
                            if (split == null || split.length != 2) continue;
                            split[0] = split[0].trim();
                            split[1] = split[1].trim();
                            if (!field.equals(split[0])) continue;
                            bf.append(split[1]);
                            findAlias = true;
                            break;
                        }
                        if (findAlias) continue;
                        int indexOf = field.indexOf(".");
                        if (indexOf != -1 && indexOf + 1 < field.length()) {
                            field = field.substring(indexOf + 1);
                        }
                        if ((indexOf = (fLowerCase = field.toLowerCase()).indexOf(" as ")) != -1 && indexOf + 4 < field.length()) {
                            field = field.substring(indexOf + 4);
                            field = field.trim();
                        }
                        bf.append(field);
                    }
                    if (this.sortTypeAsc) {
                        bf.append(" ASC ");
                    } else {
                        bf.append(" DESC ");
                    }
                }
            } else {
                if (this.tabelle.size() == 0) {
                    throw new SQLQueryObjectException("Tabella di ricerca (... FROM Table ...) non definita");
                }
                if (delete && this.tabelle.size() > 2) {
                    throw new SQLQueryObjectException("Non e' possibile effettuare una delete con piu' di una tabella alla volta");
                }
                Iterator it = this.tabelle.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (this.conditions.size() > 0) {
                    bf.append(" WHERE ");
                    if (this.notBeforeConditions) {
                        bf.append("NOT (");
                    }
                    for (int i = 0; i < this.conditions.size(); ++i) {
                        if (i > 0) {
                            if (this.andLogicOperator) {
                                bf.append(" AND ");
                            } else {
                                bf.append(" OR ");
                            }
                        }
                        bf.append((String)this.conditions.get(i));
                    }
                    if (this.notBeforeConditions) {
                        bf.append(")");
                    }
                }
                if (this.groupBy.size() > 0 && !delete) {
                    bf.append(" GROUP BY ");
                    it = this.groupBy.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                }
                if (this.orderBy.size() > 0 && !delete) {
                    bf.append(" ORDER BY ");
                    it = this.orderBy.iterator();
                    first = true;
                    while (it.hasNext()) {
                        if (!first) {
                            bf.append(",");
                        } else {
                            first = false;
                        }
                        bf.append((String)it.next());
                    }
                    if (this.sortTypeAsc) {
                        bf.append(" ASC ");
                    } else {
                        bf.append(" DESC ");
                    }
                }
            }
        } else if (this.conditions.size() > 0) {
            bf.append(" WHERE ");
            if (this.notBeforeConditions) {
                bf.append("NOT (");
            }
            for (int i = 0; i < this.conditions.size(); ++i) {
                if (i > 0) {
                    if (this.andLogicOperator) {
                        bf.append(" AND ");
                    } else {
                        bf.append(" OR ");
                    }
                }
                bf.append((String)this.conditions.get(i));
            }
            if (this.notBeforeConditions) {
                bf.append(")");
            }
        }
        return bf.toString();
    }

    public String createSQLUnion(boolean unionAll, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(sqlQueryObject);
        StringBuffer bf = new StringBuffer();
        if (this.offset >= 0 || this.limit >= 0) {
            int i;
            boolean first;
            Iterator it;
            bf.append("SELECT * from ");
            bf.append(" ( SELECT ROW_NUMBER() OVER ( ORDER BY ");
            if (this.orderBy.size() == 0) {
                throw new SQLQueryObjectException("Condizioni di OrderBy richieste");
            }
            if (this.orderBy.size() > 0) {
                it = this.orderBy.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (this.sortTypeAsc) {
                    bf.append(" ASC ");
                } else {
                    bf.append(" DESC ");
                }
            }
            bf.append(" ) AS rowNumber,");
            if (this.fields.size() == 0) {
                bf.append("*");
            } else {
                it = this.fields.iterator();
                first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    String f = (String)it.next();
                    bf.append(f);
                }
            }
            bf.append(" FROM ( ");
            for (i = 0; i < sqlQueryObject.length; ++i) {
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(sqlQueryObject[i].createSQLQuery());
                bf.append(") ");
            }
            bf.append(" ) ");
            if (this.conditions.size() > 0) {
                bf.append(" WHERE ");
                if (this.notBeforeConditions) {
                    bf.append(" NOT ( ");
                }
                for (i = 0; i < this.conditions.size(); ++i) {
                    if (i > 0) {
                        if (this.andLogicOperator) {
                            bf.append(" AND ");
                        } else {
                            bf.append(" OR ");
                        }
                    }
                    String cond = (String)this.conditions.get(i);
                    bf.append(cond);
                }
                if (this.notBeforeConditions) {
                    bf.append(" )");
                }
            }
            bf.append(" ) WHERE ( ");
            if (this.offset >= 0) {
                bf.append(" rowNumber > ");
                bf.append(this.offset);
            }
            if (this.limit >= 0) {
                if (this.offset >= 0) {
                    bf.append(" AND");
                }
                bf.append(" rowNumber <=  ");
                if (this.offset >= 0) {
                    bf.append(this.offset + this.limit);
                } else {
                    bf.append(this.limit);
                }
            }
            bf.append(" )");
        } else {
            bf.append("SELECT * from ( ");
            for (int i = 0; i < sqlQueryObject.length; ++i) {
                if (i > 0) {
                    bf.append(" UNION ");
                    if (unionAll) {
                        bf.append(" ALL ");
                    }
                }
                bf.append("( ");
                bf.append(sqlQueryObject[i].createSQLQuery());
                bf.append(") ");
            }
            bf.append(") ");
            if (this.orderBy.size() > 0) {
                bf.append(" ORDER BY ");
                Iterator it = this.orderBy.iterator();
                boolean first = true;
                while (it.hasNext()) {
                    if (!first) {
                        bf.append(",");
                    } else {
                        first = false;
                    }
                    bf.append((String)it.next());
                }
                if (this.sortTypeAsc) {
                    bf.append(" ASC ");
                } else {
                    bf.append(" DESC ");
                }
            }
        }
        return bf.toString();
    }

    public String createSQLUnionCount(boolean unionAll, String aliasCount, ISQLQueryObject ... sqlQueryObject) throws SQLQueryObjectException {
        this.checkUnionField(sqlQueryObject);
        if (aliasCount == null) {
            throw new SQLQueryObjectException("Alias per il count non definito");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("SELECT count(*) as ");
        bf.append(aliasCount);
        bf.append(" FROM ( ");
        for (int i = 0; i < sqlQueryObject.length; ++i) {
            if (i > 0) {
                bf.append(" UNION ");
                if (unionAll) {
                    bf.append(" ALL ");
                }
            }
            bf.append("( ");
            bf.append(sqlQueryObject[i].createSQLQuery());
            bf.append(") ");
        }
        bf.append(") ");
        return bf.toString();
    }

    public String createSQLUpdate() throws SQLQueryObjectException {
        if (this.updateTable == null) {
            throw new SQLQueryObjectException("Nome Tabella per l'aggiornamento non definito");
        }
        if (this.updateFieldsName.size() <= 0) {
            throw new SQLQueryObjectException("Nessuna coppia nome/valore da aggiornare presente");
        }
        if (this.updateFieldsName.size() != this.updateFieldsValue.size()) {
            throw new SQLQueryObjectException("FieldsName.size <> FieldsValue.size");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("UPDATE ");
        bf.append(this.updateTable);
        bf.append(" SET ");
        for (int i = 0; i < this.updateFieldsName.size(); ++i) {
            if (i > 0) {
                bf.append(" , ");
            }
            bf.append((String)this.updateFieldsName.get(i));
            bf.append(" = ");
            bf.append((String)this.updateFieldsValue.get(i));
        }
        bf.append(this.getSQL(false, true));
        return bf.toString();
    }
}

