/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.regexp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.MessageElement;
import org.apache.commons.lang.StringEscapeUtils;
import org.openspcoop.utils.DynamicNamespaceContext;
import org.openspcoop.utils.regexp.RegularExpressionException;
import org.openspcoop.utils.regexp.RegularExpressionNotFoundException;
import org.xml.sax.InputSource;

public class RegularExpressionEngine {
    private static XPathFactory xPathFactory = null;

    public static String[] getAllStringMatchPatternURLBased(String url, String pattern) throws RegularExpressionException, RegularExpressionNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegularExpressionNotFoundException("Pattern di ricerca non fornito");
        }
        if (url == null || url.length() == 0) {
            throw new RegularExpressionNotFoundException("URL su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(url);
            String[] result = null;
            if (matcher.matches()) {
                result = new String[matcher.groupCount()];
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    result[i - 1] = matcher.group(i);
                }
            } else {
                throw new RegularExpressionNotFoundException("URLBased, nessun match trovato");
            }
            return result;
        }
        catch (RegularExpressionNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RegularExpressionException("getAllStringMatchPatternURLBased url[" + url + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static String getStringMatchPatternURLBased(String url, String pattern) throws RegularExpressionException, RegularExpressionNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegularExpressionNotFoundException("Pattern di ricerca non fornito");
        }
        if (url == null || url.length() == 0) {
            throw new RegularExpressionNotFoundException("URL su cui effettuare una ricerca non fornita");
        }
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(url);
            String result = null;
            if (!matcher.matches()) {
                throw new RegularExpressionNotFoundException("URLBased, nessun match trovato");
            }
            result = matcher.group(1);
            if ("".equals(result)) {
                throw new RegularExpressionNotFoundException("URLBased, nessun match trovato");
            }
            return result;
        }
        catch (RegularExpressionNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RegularExpressionException("getStringMatchPatternURLBased url[" + url + "] pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static String getStringMatchPatternContentBased(MessageElement element, DynamicNamespaceContext dnc, String pattern) throws RegularExpressionException, RegularExpressionNotFoundException {
        byte[] envelopeByte = null;
        try {
            if (element == null) {
                throw new RegularExpressionNotFoundException("elemento xml non fornito");
            }
            String msg = element.getAsString();
            if (msg.indexOf("&lt;") >= 0) {
                msg = StringEscapeUtils.unescapeXml((String)msg);
            }
            String xmlInstruction = "<?xml";
            int instructionStart = msg.indexOf(xmlInstruction);
            while (instructionStart >= 0) {
                int instructionEnd = msg.indexOf(">", instructionStart + xmlInstruction.length());
                String replaceMsg = msg.substring(instructionStart, instructionEnd + 1);
                msg = msg.replace(replaceMsg, "");
                instructionStart = msg.indexOf(xmlInstruction);
            }
            envelopeByte = msg.getBytes();
        }
        catch (Exception e) {
            throw new RegularExpressionException("getStringMatchPatternContentBased pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
        return RegularExpressionEngine.getStringMatchPatternContentBased(envelopeByte, dnc, pattern);
    }

    public static String getStringMatchPatternContentBased(byte[] envelope, DynamicNamespaceContext dnc, String pattern) throws RegularExpressionException, RegularExpressionNotFoundException {
        if (pattern == null || pattern.length() == 0) {
            throw new RegularExpressionNotFoundException("Pattern di ricerca non fornito");
        }
        if (envelope == null) {
            throw new RegularExpressionNotFoundException("Contenuto Applicativo su cui effettuare la ricerca non fornito");
        }
        try {
            pattern = pattern.trim();
            XPathFactory factory = RegularExpressionEngine.getXPathFactory();
            XPath xpath = factory.newXPath();
            if (xpath == null) {
                throw new Exception("Costruzione xpath non riuscita");
            }
            if (dnc != null) {
                xpath.setNamespaceContext(dnc);
            }
            if (pattern.startsWith("concat_openspcoop") && pattern.endsWith(")")) {
                String param = pattern.substring("concat_openspcoop(".length(), pattern.length() - 1);
                String[] params = param.split(",");
                StringBuffer bfResult = new StringBuffer();
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].startsWith("\"") && params[i].endsWith("\"")) {
                        bfResult.append(params[i].substring(1, params[i].length() - 1));
                        continue;
                    }
                    ByteArrayInputStream is = null;
                    try {
                        is = new ByteArrayInputStream(envelope);
                    }
                    catch (Exception e) {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                        }
                        catch (Exception er) {
                            // empty catch block
                        }
                        throw e;
                    }
                    XPathExpression expression = null;
                    try {
                        expression = xpath.compile(params[i]);
                    }
                    catch (Exception e) {
                        throw new Exception("Compilazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore interno (" + e.getMessage() + ")");
                    }
                    if (expression == null) {
                        throw new Exception("Costruzione XPathExpression non riuscita per espressione contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    String result = null;
                    try {
                        result = expression.evaluate(new InputSource(is));
                    }
                    catch (Exception e) {
                        throw new Exception("Valutazione dell'espressione XPATH contenuta in concat_openspcoop (" + params[i] + ") ha causato un errore interno (" + e.getMessage() + ")");
                    }
                    ((InputStream)is).close();
                    if (result == null || "".equals(result)) {
                        throw new RegularExpressionNotFoundException("ContentBased, nessun match trovato per l'espressionie xpath contenuta in concat_openspcoop (" + params[i] + ")");
                    }
                    bfResult.append(result);
                }
                if (bfResult.length() <= 0) {
                    throw new RegularExpressionNotFoundException("ContentBased, nessun match trovato per l'espressione xpath (concat_openspcoop) [" + pattern + "]");
                }
                return bfResult.toString();
            }
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(envelope);
            }
            catch (Exception e) {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (Exception er) {
                    // empty catch block
                }
                throw e;
            }
            XPathExpression expression = null;
            try {
                expression = xpath.compile(pattern);
            }
            catch (Exception e) {
                throw new Exception("Compilazione dell'espressione XPATH ha causato un errore interno (" + e.getMessage() + ")");
            }
            if (expression == null) {
                throw new Exception("Costruzione XPathExpression non riuscita");
            }
            String result = null;
            try {
                result = expression.evaluate(new InputSource(is));
            }
            catch (Exception e) {
                throw new Exception("Valutazione dell'espressione XPATH ha causato un errore interno (" + e.getMessage() + ")");
            }
            ((InputStream)is).close();
            if (result == null || "".equals(result)) {
                throw new RegularExpressionNotFoundException("ContentBased, nessun match trovato per l'espressione xpath [" + pattern + "]");
            }
            return result;
        }
        catch (RegularExpressionNotFoundException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new RegularExpressionException("getStringMatchPatternContentBased pattern[" + pattern + "] error: " + e.getMessage(), e);
        }
    }

    public static XPathFactory getXPathFactory() {
        if (xPathFactory == null) {
            RegularExpressionEngine.initXPathFactory();
        }
        return xPathFactory;
    }

    public static synchronized void initXPathFactory() {
        try {
            if (xPathFactory == null) {
                xPathFactory = XPathFactory.newInstance();
            }
        }
        catch (Exception e) {
            System.out.println("ERRORE: " + e.getMessage());
        }
    }
}

