/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.date;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.net.TimeTCPClient;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.IDate;

public class TCPTimeDate
implements IDate {
    private static InetAddress server = null;
    private static int port = 37;
    private static int defaultTimeout = -1;
    private static Hashtable<String, Date> time = null;
    private static boolean cacheEnabled = true;
    private static int cacheRefresh = 100;

    private static TimeTCPClient getTCPClient() throws Exception {
        if (server == null) {
            throw new Exception("Inizializzazione non effettuata, invocare metodo init");
        }
        TimeTCPClient tcpClient = new TimeTCPClient();
        if (defaultTimeout != -1) {
            tcpClient.setDefaultTimeout(defaultTimeout);
        }
        tcpClient.connect(server, port);
        return tcpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Date getDateCached() throws Exception {
        String key;
        TimeTCPClient tcpClient;
        block22: {
            block21: {
                block20: {
                    tcpClient = null;
                    if (cacheEnabled) break block20;
                    tcpClient = TCPTimeDate.getTCPClient();
                    Date date = tcpClient.getDate();
                    try {
                        if (tcpClient == null) return date;
                        if (!tcpClient.isConnected()) return date;
                        tcpClient.disconnect();
                        return date;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return date;
                }
                key = System.currentTimeMillis() / (long)cacheRefresh + "";
                if (!time.containsKey(key)) break block21;
                Date date = time.get(key);
                try {
                    if (tcpClient == null) return date;
                    if (!tcpClient.isConnected()) return date;
                    tcpClient.disconnect();
                    return date;
                }
                catch (Exception e) {
                    // empty catch block
                }
                return date;
            }
            Hashtable<String, Date> hashtable = time;
            // MONITORENTER : hashtable
            if (!time.containsKey(key)) break block22;
            Date e = time.get(key);
            // MONITOREXIT : hashtable
            try {
                if (tcpClient == null) return e;
                if (!tcpClient.isConnected()) return e;
                tcpClient.disconnect();
                return e;
            }
            catch (Exception e2) {
                // empty catch block
            }
            return e;
        }
        tcpClient = TCPTimeDate.getTCPClient();
        Date d = tcpClient.getDate();
        time.clear();
        time.put(key, d);
        Date date = d;
        // MONITOREXIT : hashtable
        {
            catch (Exception e) {
                throw new UtilsException("getDateCached error: " + e.getMessage(), e);
            }
        }
        try {
            if (tcpClient == null) return date;
            if (!tcpClient.isConnected()) return date;
            tcpClient.disconnect();
            return date;
        }
        catch (Exception e) {
            // empty catch block
        }
        return date;
        catch (Throwable throwable) {
            try {
                if (tcpClient == null) throw throwable;
                if (!tcpClient.isConnected()) throw throwable;
                tcpClient.disconnect();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void init(Properties properties) throws UtilsException {
        try {
            String cacheRefreshS;
            String cacheS;
            String ipaddressS;
            String timeoutS = properties.getProperty("time.timeout");
            if (timeoutS != null) {
                try {
                    defaultTimeout = Integer.parseInt(timeoutS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.timeout value non valido: " + e.getMessage(), e);
                }
            }
            String portaS = properties.getProperty("time.porta");
            port = 37;
            if (timeoutS != null) {
                try {
                    port = Integer.parseInt(portaS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.porta value non valido: " + e.getMessage(), e);
                }
            }
            if ((ipaddressS = properties.getProperty("time.server")) == null) {
                throw new Exception("org.openspcoop.pdd.date.property.time.server value non definito");
            }
            if (ipaddressS != null) {
                try {
                    server = InetAddress.getByName(ipaddressS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.server value non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheS = properties.getProperty("time.cache.enable")) != null) {
                try {
                    cacheEnabled = Boolean.parseBoolean(cacheS);
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.enable non valido: " + e.getMessage(), e);
                }
            }
            if ((cacheRefreshS = properties.getProperty("time.cache.refresh")) != null) {
                try {
                    int value = Integer.parseInt(cacheRefreshS);
                    if (value > 1000) {
                        throw new Exception("Valore deve essere minore di 1000");
                    }
                    cacheRefresh = 1000 / value;
                }
                catch (Exception e) {
                    throw new Exception("org.openspcoop.pdd.date.property.time.cache.refresh non valido: " + e.getMessage(), e);
                }
            }
            time = new Hashtable();
        }
        catch (Exception e) {
            server = null;
            throw new UtilsException("Inizializzazione TimeTCP Client (properties) non riuscita: " + e.getMessage(), e);
        }
    }

    public void close() throws UtilsException {
    }

    public Date getDate() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return TCPTimeDate.getDateCached();
        }
        catch (Exception e) {
            throw new UtilsException("getDate error: " + e.getMessage(), e);
        }
    }

    public long getTimeMillis() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return TCPTimeDate.getDateCached().getTime();
        }
        catch (Exception e) {
            throw new UtilsException("getTimeMillis error: " + e.getMessage(), e);
        }
    }

    public Timestamp getTimestamp() throws UtilsException {
        try {
            if (server == null) {
                throw new Exception("Inizializzazione non effettuata, invocare metodo init");
            }
            return new Timestamp(TCPTimeDate.getDateCached().getTime());
        }
        catch (Exception e) {
            throw new UtilsException("getTimestamp error: " + e.getMessage(), e);
        }
    }
}

