/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.date;

import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.IDate;

public class DateManager {
    private static IDate dataManager;
    private static Logger log;
    private static String tipoTempoEGov;
    public static final String TIPO_TEMPO_LOCALE = "EGOV_IT_Locale";
    public static final String TIPO_TEMPO_SPC = "EGOV_IT_SPC";

    public static void initializeDataManager(String className, Properties properties, Logger log) throws UtilsException {
        DateManager.initializeDataManager(TIPO_TEMPO_LOCALE, className, properties, log);
    }

    public static synchronized void initializeDataManager(String tipoTempoEGov, String className, Properties properties, Logger log) throws UtilsException {
        if (dataManager == null) {
            try {
                if (tipoTempoEGov == null) {
                    throw new Exception("Tipo di tempo egov is null");
                }
                if (!TIPO_TEMPO_LOCALE.equals(tipoTempoEGov) && !TIPO_TEMPO_SPC.equals(tipoTempoEGov)) {
                    throw new Exception("Tipo di tempo egov (valori ammissibili: EGOV_IT_Locale/EGOV_IT_SPC) non conosciuto: " + tipoTempoEGov);
                }
                Class<?> c = Class.forName(className);
                dataManager = (IDate)c.newInstance();
                dataManager.init(properties);
                DateManager.log = log;
                DateManager.tipoTempoEGov = tipoTempoEGov;
            }
            catch (Exception e) {
                throw new UtilsException("Riscontrato errore durante il caricamento del data manager specificato [class:" + className + "]: " + e.getMessage(), e);
            }
        }
    }

    public static void close() {
        if (dataManager != null) {
            try {
                dataManager.close();
            }
            catch (Exception e) {
                log.error((Object)("Riscontrato errore durante la chiusura del data manager: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static Date getDate() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger((String)"DateManager");
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getDate();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getDate() non riuscita", (Throwable)e);
            return new Date();
        }
    }

    public static long getTimeMillis() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger((String)"DateManager");
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getTimeMillis();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getTimeMillis() non riuscita", (Throwable)e);
            return new Date().getTime();
        }
    }

    public static Timestamp getTimestamp() {
        try {
            if (dataManager == null) {
                Logger log = Logger.getLogger((String)"DateManager");
                log.warn((Object)"DateManager non inizializzato");
                DateManager.initializeDataManager("org.openspcoop.utils.date.SystemDate", new Properties(), log);
            }
            return dataManager.getTimestamp();
        }
        catch (Exception e) {
            log.error((Object)"DateManager.getTimestamp() non riuscita", (Throwable)e);
            return new Timestamp(new Date().getTime());
        }
    }

    public static String getTipoTempoEGov() {
        return tipoTempoEGov;
    }

    static {
        tipoTempoEGov = null;
    }
}

