/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils.crypt;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Random;
import org.openspcoop.utils.crypt.MD5Crypt;

public class Procedure {
    public int number;
    public String[][] datiConf = new String[20][2];

    public void parse(String filename) {
        this.number = 0;
        this.datiConf = new String[20][2];
        try {
            FileReader fileIn = new FileReader(filename);
            StreamTokenizer in = new StreamTokenizer(fileIn);
            in.commentChar(35);
            in.ordinaryChar(47);
            in.ordinaryChar(61);
            in.quoteChar(34);
            in.eolIsSignificant(false);
            while (in.nextToken() != -1) {
                in.pushBack();
                this.rule(in);
            }
            if (fileIn != null) {
                fileIn.close();
            }
        }
        catch (FileNotFoundException ex) {
            Date now = new Date();
            System.out.println(now + " " + ex);
        }
        catch (IOException ex) {
            Date now = new Date();
            System.out.println(now + " " + ex);
        }
    }

    public void rule(StreamTokenizer in) throws IOException {
        this.nome(in);
        this.skipDP(in);
        this.valore(in);
    }

    public void skipDP(StreamTokenizer in) throws IOException {
        in.nextToken();
        if (in.ttype != 61) {
            throw new IOException("Line " + in.lineno() + ": Missing '=' separator");
        }
    }

    public void nome(StreamTokenizer in) throws IOException {
        in.nextToken();
        if (in.ttype != -3) {
            throw new IOException("Line " + in.lineno() + ": Expected word");
        }
        this.datiConf[this.number][0] = in.sval;
    }

    public void valore(StreamTokenizer in) throws IOException {
        in.nextToken();
        switch (in.ttype) {
            case -3: 
            case 34: {
                this.datiConf[this.number][1] = in.sval;
                ++this.number;
                break;
            }
            case -2: {
                String NtoS;
                this.datiConf[this.number][1] = NtoS = "" + (int)in.nval;
                ++this.number;
                break;
            }
            default: {
                throw new IOException("Line " + in.lineno() + ": Expected word or number");
            }
        }
    }

    public String newPw(String pwLower) {
        int c = 0;
        byte[] arrByte = new byte[8];
        Random rd = new Random();
        rd.nextBytes(arrByte);
        for (int i = 0; i < 8; ++i) {
            c = arrByte[i] >> 6;
            if ((c = arrByte[i] - (c << 6)) <= 11) {
                c += 46;
            }
            if (c >= 12 && c <= 37) {
                c = pwLower.equals("no") ? (c += 53) : (c += 85);
            }
            if (c >= 38 && c <= 63) {
                c += 59;
            }
            arrByte[i] = (byte)c;
        }
        String pw = new String(arrByte);
        return pw;
    }

    public String newSalt() {
        int c = 0;
        byte[] arrByte = new byte[2];
        Random rd = new Random();
        rd.nextBytes(arrByte);
        for (int i = 0; i < 2; ++i) {
            c = arrByte[i] >> 6;
            if ((c = arrByte[i] - (c << 6)) <= 11) {
                c += 46;
            }
            if (c >= 12 && c <= 37) {
                c += 53;
            }
            if (c >= 38 && c <= 63) {
                c += 59;
            }
            arrByte[i] = (byte)c;
        }
        String pw = new String(arrByte);
        return pw;
    }

    public String cryptPw(String password) {
        String mypwcryptS = "";
        String salt = this.newSalt();
        mypwcryptS = MD5Crypt.crypt(password, salt);
        return mypwcryptS;
    }

    public boolean checkPw(String password, String pwcrypt) {
        boolean checkPwS = false;
        String salt = pwcrypt.substring(3, 11);
        String newPw = MD5Crypt.crypt(password, salt);
        if (newPw.equals(pwcrypt)) {
            checkPwS = true;
        }
        return checkPwS;
    }

    public boolean isOk(String regExp, String stringToCheck) {
        boolean ok = false;
        try {
            RE exp = new RE((Object)regExp);
            REMatch mResult = exp.getMatch((Object)stringToCheck);
            if (mResult != null) {
                ok = true;
            }
        }
        catch (REException ree) {
            Date now = new Date();
            System.err.println(now + " REException " + ree.getMessage());
        }
        return ok;
    }

    public String getValueFromFile(String filename, String variabile) {
        String valoreToRet = "";
        try {
            File f = new File(filename);
            FileReader r = new FileReader(f);
            BufferedReader bin = new BufferedReader(r);
            String strToFind = variabile + ":";
            String line = bin.readLine();
            while (line != null) {
                if (line.startsWith(strToFind) && line.length() > strToFind.length()) {
                    valoreToRet = line.substring(strToFind.length(), line.length());
                }
                line = bin.readLine();
            }
            if (bin != null) {
                bin.close();
            }
            if (r != null) {
                r.close();
            }
        }
        catch (IOException ioe) {
            Date now = new Date();
            System.err.println(now + " IOException " + ioe.getMessage());
        }
        return valoreToRet;
    }

    public String readFile(String filename) {
        String stringaLetta = "";
        try {
            File f = new File(filename);
            FileReader r = new FileReader(f);
            BufferedReader bin = new BufferedReader(r);
            String line = bin.readLine();
            while (line != null) {
                stringaLetta = stringaLetta + "" + line + "\n";
                line = bin.readLine();
            }
            if (bin != null) {
                bin.close();
            }
            if (r != null) {
                r.close();
            }
        }
        catch (IOException ioe) {
            Date now = new Date();
            System.err.println(now + " IOException " + ioe.getMessage());
        }
        return stringaLetta;
    }

    public String readFileSingleLine(String filename) {
        String stringaLetta = "";
        try {
            File f = new File(filename);
            FileReader r = new FileReader(f);
            BufferedReader bin = new BufferedReader(r);
            String line = bin.readLine();
            if (line != null) {
                stringaLetta = line;
            }
            if (bin != null) {
                bin.close();
            }
            if (r != null) {
                r.close();
            }
        }
        catch (IOException ioe) {
            Date now = new Date();
            System.err.println(now + " IOException " + ioe.getMessage());
        }
        return stringaLetta;
    }

    public boolean validateUrl(String url) {
        try {
            URL testUrl = new URL(url);
            testUrl.toString();
            return true;
        }
        catch (MalformedURLException ex) {
            System.err.println("MalformedURLException: " + ex.getMessage());
            return false;
        }
    }
}

