/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Node;

public class ValidatoreXSD {
    private Schema schema;

    public ValidatoreXSD(Schema schema) throws Exception {
        try {
            if (schema == null) {
                throw new Exception("Schema is null?");
            }
            this.schema = schema;
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage());
        }
    }

    public ValidatoreXSD(InputStream inputStream) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(inputStream);
            this.initializeSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage());
        }
    }

    public ValidatoreXSD(InputStream ... inputStream) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[inputStream.length];
            for (int i = 0; i < inputStream.length; ++i) {
                ss[i] = new StreamSource(inputStream[i]);
            }
            this.initializeSchema(ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (InputStream): " + e.getMessage());
        }
    }

    public ValidatoreXSD(File file) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(file);
            this.initializeSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (File:" + file.getName() + "): " + e.getMessage());
        }
    }

    public ValidatoreXSD(File ... file) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[file.length];
            for (int i = 0; i < file.length; ++i) {
                ss[i] = new StreamSource(file[i]);
            }
            this.initializeSchema(ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (Files): " + e.getMessage());
        }
    }

    public ValidatoreXSD(String url) throws Exception {
        try {
            StreamSource streamSource = new StreamSource(url);
            this.initializeSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage());
        }
    }

    public ValidatoreXSD(String ... url) throws Exception {
        try {
            StreamSource[] ss = new StreamSource[url.length];
            for (int i = 0; i < url.length; ++i) {
                ss[i] = new StreamSource(url[i]);
            }
            this.initializeSchema(ss);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante la costruzione dello schema (URL:" + url + "): " + e.getMessage());
        }
    }

    public void initializeSchema(StreamSource streamSource) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage());
        }
    }

    public void initializeSchema(StreamSource[] streamSource) throws Exception {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            this.schema = factory.newSchema(streamSource);
        }
        catch (Exception e) {
            throw new Exception("Riscontrato errore durante l'inizializzazione dello schema: " + e.getMessage());
        }
    }

    public void valida(Node nodeXML) throws Exception {
        this.valida(new DOMSource(nodeXML));
    }

    public void valida(InputStream inputStreamXML) throws Exception {
        this.valida(new StreamSource(inputStreamXML));
    }

    public void valida(File fileXML) throws Exception {
        this.valida(new StreamSource(fileXML));
    }

    public void valida(String urlXML) throws Exception {
        this.valida(new StreamSource(urlXML));
    }

    public void valida(Source source) throws Exception {
        Validator validator = this.schema.newValidator();
        validator.validate(source);
    }
}

