/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.axis.AxisEngine;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.client.AxisClient;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.SOAPHeader;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.server.AxisServer;
import org.apache.log4j.Logger;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.date.DateManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    public static final int DIMENSIONE_BUFFER = 65536;
    private static AxisServer axisServer = null;
    private static AxisClient axisClient = null;
    private static MessageContext msgContext = null;
    private static long serialNumber = 0L;

    public static byte[] requestHTTPFile(String path) throws UtilsException {
        InputStream is = null;
        ByteArrayOutputStream outResponse = null;
        try {
            URL url = new URL(path);
            URLConnection connection = url.openConnection();
            HttpURLConnection httpConn = (HttpURLConnection)connection;
            httpConn.setRequestMethod("GET");
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            int resultHTTPOperation = httpConn.getResponseCode();
            if (resultHTTPOperation == 404) {
                throw new UtilsException("404");
            }
            outResponse = new ByteArrayOutputStream();
            is = httpConn.getInputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = is.read(readB)) != -1) {
                outResponse.write(readB, 0, readByte);
            }
            is.close();
            httpConn.disconnect();
            byte[] xmlottenuto = outResponse.toByteArray();
            outResponse.close();
            return xmlottenuto;
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (outResponse != null) {
                    outResponse.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e.getMessage() != null && e.getMessage().contains("404")) {
                throw new UtilsException("404");
            }
            throw new UtilsException("Utilities.requestHTTPFile error " + e.getMessage(), e);
        }
    }

    @Deprecated
    public static byte[] eraserType(byte[] xml) throws UtilsException {
        ByteArrayOutputStream cleanXML = null;
        try {
            String eraserString = " xsi:type=\"xsd:string\"";
            cleanXML = new ByteArrayOutputStream();
            int i = 0;
            while (i < xml.length) {
                if (xml[i] == 32) {
                    if (i + eraserString.length() < xml.length) {
                        StringBuffer test = new StringBuffer();
                        for (int k = 0; k < eraserString.length(); ++k) {
                            test.append((char)xml[i + k]);
                        }
                        if (test.toString().equals(eraserString)) {
                            i += eraserString.length();
                            continue;
                        }
                    }
                    cleanXML.write(xml[i]);
                    ++i;
                    continue;
                }
                cleanXML.write(xml[i]);
                ++i;
            }
            byte[] risultato = cleanXML.toByteArray();
            cleanXML.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (cleanXML != null) {
                    cleanXML.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.eraserType error " + e.getMessage(), e);
        }
    }

    public static String hash(String key) throws UtilsException {
        try {
            StringBuffer returnKey = new StringBuffer();
            for (int i = 0; i < key.length(); ++i) {
                if (key.charAt(i) == '_' || key.charAt(i) == '-' || key.charAt(i) == '.' || key.charAt(i) == ':') continue;
                returnKey.append(key.charAt(i));
            }
            return returnKey.toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.hash error " + e.getMessage(), e);
        }
    }

    public static void saveAxisMessage(String path, Message msg) throws UtilsException {
        FileOutputStream fos = null;
        try {
            File fileMsg = new File(path);
            if (fileMsg.exists()) {
                throw new UtilsException("L'identificativo del Messaggio risulta gia' registrato: " + path);
            }
            fos = new FileOutputStream(path);
            msg.writeTo((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception er) {
                // empty catch block
            }
            throw new UtilsException("Utilities.saveAxisMessage error " + e.getMessage(), e);
        }
    }

    public static void closePreparedStatement(Hashtable<String, PreparedStatement> tablePstmt, Logger log) {
        if (tablePstmt != null && tablePstmt.keys().hasMoreElements()) {
            ArrayList<String> listKeys = Collections.list(tablePstmt.keys());
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key = listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    log.debug((Object)("Utilities.closePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e));
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void executePreparedStatement(Hashtable<String, PreparedStatement> tablePstmt) throws UtilsException {
        if (tablePstmt != null && tablePstmt.keys().hasMoreElements()) {
            ArrayList<String> listKeys = Collections.list(tablePstmt.keys());
            Collections.sort(listKeys);
            for (int i = 0; i < listKeys.size(); ++i) {
                String key = listKeys.get(i);
                PreparedStatement pstmt = tablePstmt.get(key);
                try {
                    pstmt.execute();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante l'esecuzione della PreparedStatement [" + key + "]: " + e, e);
                }
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    throw new UtilsException("Utilities.executePreparedStatement error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e, e);
                }
                tablePstmt.remove(key);
            }
        }
    }

    public static void addPreparedStatement(Hashtable<String, PreparedStatement> pstmtSorgente, Hashtable<String, PreparedStatement> pstmtDestinazione, Logger log) throws UtilsException {
        Enumeration<String> keys = pstmtSorgente.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!pstmtDestinazione.containsKey(key)) {
                pstmtDestinazione.put(key, pstmtSorgente.get(key));
                continue;
            }
            try {
                PreparedStatement pstmt = pstmtSorgente.get(key);
                pstmt.close();
            }
            catch (Exception e) {
                throw new UtilsException("Utilities.closePreparedStatementGiaPresente error: Riscontrato errore durante la chiusura della PreparedStatement [" + key + "]: " + e, e);
            }
        }
    }

    public static byte[] readFile(String file) throws UtilsException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = fis.read(readB)) != -1) {
                byteBuffer.write(readB, 0, readByte);
            }
            fis.close();
            return byteBuffer.toByteArray();
        }
        catch (Exception e) {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Utilities.readFile, Errore durante la lettura del file: " + e.getMessage(), e);
        }
    }

    public static void bypassMustUnderstandAxisHeaderElement(SOAPHeader header, Properties filtri, boolean isProcessed) throws UtilsException {
        try {
            Iterator it = header.getChildElements();
            block2: while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                Enumeration<Object> en = filtri.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (!key.equals(element.getLocalName()) || !filtri.get(key).equals(element.getNamespaceURI())) continue;
                    element.setProcessed(isProcessed);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), e);
        }
    }

    public static void bypassMustUnderstandAxisHeaderElement(SOAPHeader header, boolean isProcessed) throws UtilsException {
        try {
            Iterator it = header.getChildElements();
            while (it.hasNext()) {
                SOAPHeaderElement element = (SOAPHeaderElement)it.next();
                if (element.getActor() != null || !element.getMustUnderstand()) continue;
                element.setProcessed(isProcessed);
            }
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.bypassMustUnderstandAxisHeaderElement Riscontrato errore durante l'applicazione del bypassFilter: " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, Properties sorgente) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = sorgente.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = sorgente.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public static Properties readProperties(String prefix, String[] key, String[] name) throws UtilsException {
        Properties sorgente = new Properties();
        if (key != null && name != null && key.length == name.length) {
            for (int i = 0; i < key.length; ++i) {
                sorgente.put(key[i], name[i]);
            }
        }
        return Utilities.readProperties(prefix, sorgente);
    }

    public static String convertSystemTimeIntoString_millisecondi(long time, boolean millisecondiCheck) {
        long millisecondi = time % 1000L;
        long diff = time / 1000L;
        long ore = diff / 3600L;
        long minuti = diff % 3600L / 60L;
        long secondi = diff % 3600L % 60L;
        StringBuffer bf = new StringBuffer();
        if (ore == 1L) {
            bf.append(ore + " ora ");
        } else if (ore > 0L) {
            bf.append(ore + " ore ");
        }
        if (minuti == 1L) {
            bf.append(minuti + " minuto ");
        } else if (minuti > 0L) {
            bf.append(minuti + " minuti ");
        }
        if (secondi == 1L) {
            bf.append(secondi + " secondo ");
        } else if (secondi > 0L) {
            bf.append(secondi + " secondi ");
        }
        if (millisecondiCheck) {
            if (millisecondi == 1L) {
                bf.append(millisecondi + " millisecondo");
            } else if (millisecondi >= 0L) {
                bf.append(millisecondi + " millisecondi");
            }
        }
        if (bf.length() == 0) {
            bf.append("conversione non riuscita");
        }
        return bf.toString();
    }

    public static synchronized void initAxisServer() {
        if (axisServer == null) {
            axisServer = new AxisServer();
        }
    }

    public static AxisServer getAxisServer() {
        if (axisServer == null) {
            Utilities.initAxisServer();
        }
        return axisServer;
    }

    public static synchronized void initAxisClient() {
        if (axisClient == null) {
            axisClient = new AxisClient();
        }
    }

    public static AxisClient getAxisClient() {
        if (axisClient == null) {
            Utilities.initAxisClient();
        }
        return axisClient;
    }

    public static synchronized void initMessageContext() {
        if (msgContext == null) {
            msgContext = new MessageContext((AxisEngine)new AxisServer());
            msgContext.setProperty("sendXsiTypes", (Object)false);
        }
    }

    public static String getAsString(MessageElement me) throws UtilsException {
        return Utilities.getAsString(me, false);
    }

    public static String getAsString(MessageElement me, boolean pretty) throws UtilsException {
        try {
            StringWriter writer = new StringWriter();
            if (msgContext == null) {
                Utilities.initMessageContext();
            }
            MessageContext msgContext = Utilities.msgContext;
            SerializationContext serializeContext = new SerializationContext((Writer)writer, msgContext);
            if (pretty) {
                serializeContext.setPretty(true);
            }
            serializeContext.setSendDecl(false);
            me.setDirty(false);
            me.output(serializeContext);
            writer.close();
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            throw new UtilsException("Utilities.getAsString, errore: " + e.getMessage(), e);
        }
    }

    public static synchronized String getUniqueID() {
        if (serialNumber + 1L > Long.MAX_VALUE) {
            serialNumber = 0L;
        }
        return "T:" + DateManager.getTimeMillis() + "_S:" + ++serialNumber;
    }

    public static void setSQLStringValue(PreparedStatement pstmt, int index, String value) throws SQLException {
        if (value != null && !"".equals(value)) {
            pstmt.setString(index, value);
        } else {
            pstmt.setString(index, null);
        }
    }
}

