/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.axis.message.InputStreamBody;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.PrefixedQName;
import org.apache.axis.message.SOAPBody;
import org.apache.axis.message.SOAPFault;
import org.apache.axis.soap.MessageFactoryImpl;
import org.openspcoop.utils.AttachmentsUtils;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.UtilsException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SoapUtils {
    public static String getSoapAction(Message msg) throws UtilsException {
        String soapAction = null;
        try {
            MimeHeaders mhs = msg.getMimeHeaders();
            Iterator it = mhs.getAllHeaders();
            while (it.hasNext()) {
                MimeHeader mh = (MimeHeader)it.next();
                if (!"soapaction".equalsIgnoreCase(mh.getName())) continue;
                soapAction = mh.getValue();
            }
            return soapAction;
        }
        catch (Exception e) {
            throw new UtilsException("Lettura SOAPAction non riuscita", e);
        }
    }

    public static boolean matchLocalName(Node nodo, String nodeName, String prefix, String namespace) {
        if (nodo == null) {
            return false;
        }
        if (nodo.getNodeName() == null) {
            return false;
        }
        if (nodo.getNodeName().equals(prefix + nodeName)) {
            return true;
        }
        String namespaceNodo = nodo.getNamespaceURI();
        if (namespaceNodo != null && namespaceNodo.equals(namespace)) {
            String xmlns = nodo.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!xmlns.equals("")) {
                xmlns = xmlns + ":";
            }
            if (nodo.getNodeName().equals(xmlns + nodeName)) {
                return true;
            }
        }
        return false;
    }

    public static Node getAttributeNode(Node node, String attributeName, String prefix) {
        if (node == null) {
            return null;
        }
        NamedNodeMap map = node.getAttributes();
        Node attr = SoapUtils.getAttributeNode(map, attributeName, prefix);
        if (attr == null) {
            String xmlns = node.getPrefix();
            if (xmlns == null) {
                xmlns = "";
            } else if (!xmlns.equals("")) {
                xmlns = xmlns + ":";
            }
            attr = SoapUtils.getAttributeNode(map, attributeName, xmlns);
        }
        return attr;
    }

    private static Node getAttributeNode(NamedNodeMap map, String attributeName, String prefix) {
        Node attr = map.getNamedItem(attributeName);
        if (attr == null) {
            attr = map.getNamedItem(prefix + attributeName);
            if (attr != null) {
                return attr;
            }
            return null;
        }
        return attr;
    }

    public static Message buildOpenSPCoopOK_axisMsg(String idEGov) throws UtilsException {
        try {
            ByteArrayInputStream inputBody = new ByteArrayInputStream(SoapUtils.buildOpenSPCoopOK(idEGov));
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message responseAxisMessage = (Message)mf.createMessage();
            javax.xml.soap.SOAPBody soapBody = responseAxisMessage.getSOAPBody();
            InputStreamBody isBody = new InputStreamBody((InputStream)inputBody);
            soapBody.addChildElement((SOAPElement)isBody);
            inputBody.close();
            return responseAxisMessage;
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] buildOpenSPCoopOK(String idEGov) throws UtilsException {
        try {
            PrefixedQName name = new PrefixedQName("http://www.openspcoop.org/pdd/services/PD", "RispostaOK", "OpenSPCoop");
            MessageElement ok = new MessageElement((Name)name);
            ok.setAttribute("ID", idEGov);
            return Utilities.getAsString(ok).getBytes();
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgOpenSPCoopOK non riuscito: " + e.getMessage(), e);
        }
    }

    public static String toString(SOAPFault fault) throws UtilsException {
        try {
            if (fault != null) {
                AxisFault af = fault.getFault();
                af.removeHostname();
                af.removeFaultDetail(new QName("http://xml.apache.org/axis/", "stackTrace"));
                return af.dumpToString();
            }
            return "SOAPFault non presente";
        }
        catch (Exception e) {
            throw new UtilsException("toString SOAPFault: " + e.getMessage(), e);
        }
    }

    public static Message build_Soap_Empty() {
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            Message msg = (Message)mf.createMessage();
            return msg;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static byte[] build_Soap_Fault(String aFault, String aActor, String aCode, String[] aDetailPrefix, String[] aDetailLocalName, String[] aDetailURI) throws UtilsException {
        ByteArrayOutputStream byteEGOV = null;
        try {
            MessageFactoryImpl mf = new MessageFactoryImpl();
            SOAPMessage msg = mf.createMessage();
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            String xsi = "http://www.w3.org/2001/XMLSchema-instance";
            env.addNamespaceDeclaration("SOAP_ENV", "http://schemas.xmlsoap.org/soap/envelope/");
            env.addNamespaceDeclaration("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
            env.addNamespaceDeclaration("xsi", xsi);
            env.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            javax.xml.soap.SOAPBody bdy = env.getBody();
            bdy.addFault();
            javax.xml.soap.SOAPFault fault = bdy.getFault();
            if (aFault != null) {
                fault.setFaultString(aFault);
            } else {
                fault.setFaultString("");
            }
            if (aCode != null) {
                fault.setFaultCode(aCode);
            }
            if (aActor != null) {
                fault.setFaultActor(aActor);
            }
            if (aDetailPrefix.length > 0) {
                fault.addDetail();
                Detail d = fault.getDetail();
                for (int i = 0; i < aDetailPrefix.length; ++i) {
                    Name name = env.createName(aDetailLocalName[i], aDetailPrefix[i], aDetailURI[i]);
                    d.addDetailEntry(name);
                }
            }
            byteEGOV = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)byteEGOV);
            byte[] risultato = byteEGOV.toByteArray();
            byteEGOV.close();
            return risultato;
        }
        catch (Exception e) {
            try {
                if (byteEGOV != null) {
                    byteEGOV.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            throw new UtilsException("Creazione MsgSOAPFault non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] build_Server_Error(String soggetto, String text, String faultString, String faultCode) throws UtilsException {
        try {
            String t = text;
            String[] testText = text.split(" ");
            if (testText.length > 1) {
                t = testText[0];
            }
            String actorString = null;
            String[] detailPrefix = new String[]{soggetto};
            String[] detailLocalName = new String[]{t};
            String[] detailURI = new String[]{"http://www.openspcoop.org"};
            return SoapUtils.build_Soap_Fault(faultString, actorString, faultCode, detailPrefix, detailLocalName, detailURI);
        }
        catch (Exception e) {
            throw new UtilsException("Creazione MsgSOAPFault_ServerError non riuscito: " + e.getMessage(), e);
        }
    }

    public static void sbustamentoMessaggio(Message msg, OutputStream stream) throws UtilsException {
        try {
            if (msg.countAttachments() == 0) {
                SOAPBody bd = (SOAPBody)msg.getSOAPBody();
                if (bd.hasFault()) {
                    SOAPFault fault = (SOAPFault)bd.getFault();
                    stream.write(fault.getAsString().getBytes());
                } else {
                    Iterator it = bd.getChildElements();
                    while (it.hasNext()) {
                        MessageElement bodyElement = (MessageElement)it.next();
                        stream.write(bodyElement.getAsString().getBytes());
                    }
                }
            } else {
                javax.xml.soap.SOAPBody body = msg.getSOAPBody();
                if (body != null && body.hasChildNodes() && body.getFirstChild() != null && "SOAPTunnel".equals(body.getFirstChild().getLocalName()) && "http://www.openspcoop.org/pdd/services/PDtoSOAP".equals(body.getFirstChild().getNamespaceURI()) && "OpenSPCoop".equals(body.getFirstChild().getPrefix())) {
                    javax.xml.soap.AttachmentPart ap = (javax.xml.soap.AttachmentPart)msg.getAttachments().next();
                    InputStream inputDH = (InputStream)ap.getContent();
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    byte[] readB = new byte[8192];
                    int readByte = 0;
                    while ((readByte = inputDH.read(readB)) != -1) {
                        bout.write(readB, 0, readByte);
                    }
                    inputDH.close();
                    bout.close();
                    stream.write(bout.toByteArray());
                } else {
                    ByteArrayOutputStream sbustamentoAttachments = new ByteArrayOutputStream();
                    msg.writeTo((OutputStream)sbustamentoAttachments);
                    String msgString = sbustamentoAttachments.toString();
                    byte[] msgByte = sbustamentoAttachments.toByteArray();
                    String soapEnvelopeStart = "<" + msg.getSOAPEnvelope().getPrefix() + ":" + msg.getSOAPEnvelope().getName();
                    String xmlTagDecode = "<?xml";
                    String soapEnvelopeStop = "</" + msg.getSOAPEnvelope().getPrefix() + ":" + msg.getSOAPEnvelope().getName() + ">";
                    if (msgString.indexOf(xmlTagDecode) != -1) {
                        stream.write(msgByte, 0, msgString.indexOf(xmlTagDecode));
                    } else {
                        stream.write(msgByte, 0, msgString.indexOf(soapEnvelopeStart));
                    }
                    SOAPBody bd = (SOAPBody)msg.getSOAPBody();
                    if (bd.hasFault()) {
                        SOAPFault fault = (SOAPFault)bd.getFault();
                        stream.write(fault.getAsString().getBytes());
                    } else {
                        Iterator it = bd.getChildElements();
                        while (it.hasNext()) {
                            MessageElement bodyElement = (MessageElement)it.next();
                            stream.write(bodyElement.getAsString().getBytes());
                        }
                    }
                    int indexOf = msgString.indexOf(soapEnvelopeStop) + soapEnvelopeStop.length();
                    stream.write(msgByte, indexOf, msgByte.length - indexOf);
                }
            }
        }
        catch (Exception e) {
            throw new UtilsException("Sbustamento AxisMsg_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoMessaggio(Message msg) throws UtilsException {
        ByteArrayOutputStream bodySbustato = new ByteArrayOutputStream();
        try {
            SoapUtils.sbustamentoMessaggio(msg, bodySbustato);
            return bodySbustato.toByteArray();
        }
        catch (Exception e) {
            try {
                if (bodySbustato != null) {
                    bodySbustato.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Sbustamento AxisMsg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] sbustamentoSOAPEnvelope(org.apache.axis.message.SOAPEnvelope env) throws UtilsException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            SOAPBody bd = (SOAPBody)env.getBody();
            if (bd.hasFault()) {
                SOAPFault fault = (SOAPFault)bd.getFault();
                stream.write(fault.getAsString().getBytes());
            } else {
                Iterator it = bd.getChildElements();
                while (it.hasNext()) {
                    MessageElement bodyElement = (MessageElement)it.next();
                    stream.write(bodyElement.getAsString().getBytes());
                }
            }
            byte[] body = stream.toByteArray();
            stream.close();
            return body;
        }
        catch (Exception e) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UtilsException("Sbustamento SoapEnvelope non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggioConAttachment(InputStream inputBody, String tipoAttachment, boolean buildAsDataHandler) throws UtilsException {
        Message msg = null;
        try {
            ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
            byte[] readB = new byte[65536];
            int readByte = 0;
            while ((readByte = inputBody.read(readB)) != -1) {
                byteBuffer.write(readB, 0, readByte);
            }
            inputBody.close();
            if (byteBuffer.size() == 0) {
                throw new UtilsException("Contenuto da imbustare non presente");
            }
            MessageFactoryImpl mf = new MessageFactoryImpl();
            msg = (Message)mf.createMessage();
            javax.xml.soap.SOAPBody soapBody = msg.getSOAPBody();
            PrefixedQName name = null;
            name = "application/openspcoop".equals(tipoAttachment) ? new PrefixedQName("http://www.openspcoop.org/pdd/services/PDtoSOAP", "SOAPTunnel", "OpenSPCoop") : new PrefixedQName("http://www.openspcoop.org/pdd/services/PDtoSOAP", "Attachments", "OpenSPCoop");
            soapBody.addBodyElement((Name)name);
            AttachmentPart ap = (AttachmentPart)msg.createAttachmentPart();
            if (buildAsDataHandler) {
                ap.setDataHandler(new DataHandler((Object)new ByteArrayInputStream(byteBuffer.toByteArray()), tipoAttachment));
            } else {
                ap.setContent((Object)new ByteArrayInputStream(byteBuffer.toByteArray()), tipoAttachment);
            }
            msg.addAttachmentPart((javax.xml.soap.AttachmentPart)ap);
            return msg;
        }
        catch (Exception e) {
            throw new UtilsException("Imbustamento msgConAttachment_inputStream non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggioConAttachment(byte[] body) throws UtilsException {
        ByteArrayInputStream inputBody = null;
        Message risposta = null;
        try {
            inputBody = new ByteArrayInputStream(body);
            risposta = SoapUtils.imbustamentoMessaggioConAttachment(inputBody, "text/plain", false);
            inputBody.close();
            return risposta;
        }
        catch (Exception e) {
            try {
                if (inputBody != null) {
                    inputBody.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            throw new UtilsException("Imbustamento msgConAttachment non riuscito: " + e.getMessage(), e);
        }
    }

    public static Message imbustamentoMessaggio(byte[] body, boolean eraserXMLTag) throws UtilsException {
        return SoapUtils.build(body, true, eraserXMLTag);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream) throws UtilsException {
        return SoapUtils.build(byteMsg, isBodyStream, false, true);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream, boolean eraserXMLTag) throws UtilsException {
        return SoapUtils.build(byteMsg, isBodyStream, eraserXMLTag, true);
    }

    public static Message build(byte[] byteMsg, boolean isBodyStream, boolean eraserXMLTag, boolean checkEmptyBody) throws UtilsException {
        try {
            if (byteMsg == null || byteMsg.length == 0) {
                throw new Exception("Nessun contenuto su cui costruire il messaggio");
            }
            int offset = 0;
            String contentType = "text/xml";
            if (AttachmentsUtils.messageWithAttachment(byteMsg)) {
                String IDfirst = AttachmentsUtils.firstContentID(byteMsg);
                String boundary = AttachmentsUtils.findBoundary(byteMsg);
                if (boundary == null) {
                    throw new Exception("Errore avvenuto durante la lettura del boundary associato al multipart message.");
                }
                contentType = IDfirst == null ? "multipart/related; type=\"text/xml\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" " : "multipart/related; type=\"text/xml\"; start=\"" + IDfirst + "\"; \tboundary=\"" + boundary.substring(2, boundary.length()) + "\" ";
                if (isBodyStream) {
                    int puliziaSpaziBianchi_e_XML;
                    String msg = new String(byteMsg);
                    int firstBound = msg.indexOf(boundary);
                    int secondBound = msg.indexOf(boundary, firstBound + boundary.length());
                    if (firstBound == -1 || secondBound == -1) {
                        throw new Exception("multipart/related non correttamente formato (bound not found)");
                    }
                    String bodyOriginal = msg.substring(firstBound + boundary.length(), secondBound);
                    int indexCarriage = bodyOriginal.indexOf("\r\n\r\n");
                    if (indexCarriage == -1) {
                        throw new Exception("multipart/related non correttamente formato (\\r\\n\\r\\n not found)");
                    }
                    String contenutoBody = bodyOriginal.substring(indexCarriage + "\r\n\r\n".length());
                    for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) == ' '; ++puliziaSpaziBianchi_e_XML) {
                    }
                    String bodyPulito = contenutoBody.substring(puliziaSpaziBianchi_e_XML);
                    if (bodyPulito.startsWith("<?xml")) {
                        if (eraserXMLTag) {
                            for (puliziaSpaziBianchi_e_XML = 0; puliziaSpaziBianchi_e_XML < contenutoBody.length() && contenutoBody.charAt(puliziaSpaziBianchi_e_XML) != '>'; ++puliziaSpaziBianchi_e_XML) {
                            }
                            bodyPulito = bodyPulito.substring(puliziaSpaziBianchi_e_XML + 1);
                        } else {
                            throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                        }
                    }
                    String contenutoBodyImbustato = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>" + bodyPulito + "</soapenv:Body></soapenv:Envelope>\r\n";
                    String bodyOriginalImbustato = bodyOriginal.replace(contenutoBody, contenutoBodyImbustato);
                    msg = msg.replace(bodyOriginal, bodyOriginalImbustato);
                    byteMsg = msg.getBytes();
                    isBodyStream = false;
                }
            } else if (isBodyStream) {
                int i;
                for (i = 0; i < byteMsg.length && (char)byteMsg[i] == ' '; ++i) {
                }
                String xml = "";
                if (byteMsg.length > i + 5 && (xml = "" + (char)byteMsg[i] + (char)byteMsg[i + 1] + (char)byteMsg[i + 2] + (char)byteMsg[i + 3] + (char)byteMsg[i + 4]).equals("<?xml")) {
                    if (eraserXMLTag) {
                        while (i < byteMsg.length && (char)byteMsg[i] != '>') {
                            ++i;
                        }
                        offset = i + 1;
                    } else {
                        throw new Exception("Tag <?xml non permesso con la funzionalita di imbustamento SOAP");
                    }
                }
            }
            ByteArrayInputStream messageInput = new ByteArrayInputStream(byteMsg, offset, byteMsg.length);
            Message message = new Message((Object)messageInput, isBodyStream, contentType, null);
            if (message.countAttachments() == 0) {
                message.getSOAPPartAsBytes();
            }
            try {
                message.getSOAPEnvelope().getAsString();
            }
            catch (Exception e) {
                throw new Exception("Costruzione di un msg soap non riuscita per il pacchetto [" + new String(byteMsg) + "]: " + e.getMessage(), e);
            }
            if (checkEmptyBody && (message.getSOAPBody() == null || !message.getSOAPBody().hasChildNodes())) {
                throw new Exception("Costruzione di un msg soap non riuscita: soap body senza contenuto");
            }
            return message;
        }
        catch (Exception e) {
            throw new UtilsException("Build msg non riuscito: " + e.getMessage(), e);
        }
    }

    public static byte[] msgElementoToByte(MessageElement elem) throws UtilsException {
        try {
            elem.addNamespaceDeclaration("xsd", "http://www.w3.org/2001/XMLSchema");
            elem.addNamespaceDeclaration("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            byte[] risultato = Utilities.getAsString(elem).getBytes();
            return risultato;
        }
        catch (Exception e) {
            throw new UtilsException("MsgElementToByte non riuscito: " + e.getMessage(), e);
        }
    }
}

