/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.util.Enumeration;
import java.util.Properties;
import org.openspcoop.utils.UtilsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesReader {
    private Properties properties;

    public PropertiesReader(Properties properties) {
        this.properties = properties;
    }

    public String getValue(String key) throws UtilsException {
        String value = this.properties.getProperty(key);
        return value;
    }

    public String convertEnvProperties(String value) throws UtilsException {
        if (value.indexOf("${") != -1) {
            while (value.indexOf("${") != -1) {
                int indexStart = value.indexOf("${");
                int indexEnd = value.indexOf("}");
                if (indexEnd == -1) {
                    throw new UtilsException("Errore durante l'interpretazione del valore [" + value + "]: ${ utilizzato senza la rispettiva chiusura }");
                }
                String nameSystemProperty = value.substring(indexStart + "${".length(), indexEnd);
                String valueSystemProperty = System.getProperty(nameSystemProperty);
                if (valueSystemProperty == null) {
                    throw new UtilsException("Errore durante l'interpretazione del valore [" + value + "]: variabile di sistema ${" + nameSystemProperty + "} non esistente");
                }
                value = value.replace("${" + nameSystemProperty + "}", valueSystemProperty);
            }
        }
        return value;
    }

    public String getValue_convertEnvProperties(String key) throws UtilsException {
        String value = this.properties.getProperty(key);
        if (value != null) {
            value = this.convertEnvProperties(value);
        }
        return value;
    }

    public Properties readProperties(String prefix) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = this.properties.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.properties.getProperty(property)) != null) {
                    value = value.trim();
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public Properties readProperties_convertEnvProperties(String prefix) throws UtilsException {
        Properties prop = new Properties();
        try {
            Enumeration<?> en = this.properties.propertyNames();
            while (en.hasMoreElements()) {
                String value;
                String property = (String)en.nextElement();
                if (!property.startsWith(prefix)) continue;
                String key = property.substring(prefix.length());
                if (key != null) {
                    key = key.trim();
                }
                if ((value = this.properties.getProperty(property)) != null) {
                    value = value.trim();
                    value = this.convertEnvProperties(value);
                }
                if (key == null || value == null) continue;
                prop.setProperty(key, value);
            }
            return prop;
        }
        catch (Exception e) {
            throw new UtilsException("readProperties Riscontrato errore durante la lettura delle propriete con prefisso [" + prefix + "]: " + e.getMessage(), e);
        }
    }

    public Enumeration<?> propertyNames() {
        return this.properties.propertyNames();
    }
}

