/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;

public class GestoreJNDI {
    private Properties contextProperties;

    public GestoreJNDI(Properties contextP) {
        this.contextProperties = contextP;
    }

    public GestoreJNDI() {
        this.contextProperties = new Properties();
    }

    public Object lookup(String fullPath) throws Exception {
        InitialContext ctx = null;
        try {
            Object obj;
            ctx = this.contextProperties.size() > 0 ? new InitialContext(this.contextProperties) : new InitialContext();
            Object object = obj = ctx.lookup(fullPath);
            return object;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (ctx != null) {
                    ctx.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unbind(String fullPath) {
        InitialContext currentContext = null;
        try {
            int ix;
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            String[] components = name.split("/");
            for (ix = components.length - 1; ix >= 0; --ix) {
                String nextPath = components[ix];
                try {
                    currentContext.unbind(nextPath);
                    continue;
                }
                catch (NameNotFoundException ignored) {
                    System.out.println("unbinding EXCEPTION context[" + ignored + "]");
                    boolean bl = false;
                    try {
                        if (currentContext != null) {
                            currentContext.close();
                        }
                    }
                    catch (Exception eClose) {
                        // empty catch block
                    }
                    return bl;
                }
            }
            ix = 1;
            return ix != 0;
        }
        catch (Exception e) {
            System.out.println("unbinding EXCEPTION [" + e + "]");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception eClose) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind(String fullPath, Object toBind) {
        Context currentContext = null;
        try {
            currentContext = new InitialContext();
            String name = currentContext.composeName(fullPath, currentContext.getNameInNamespace());
            String[] components = name.split("/");
            int stop = components.length - 1;
            for (int ix = 0; ix < stop; ++ix) {
                String nextPath = components[ix];
                try {
                    currentContext = (Context)currentContext.lookup(nextPath);
                    continue;
                }
                catch (NameNotFoundException ignored) {
                    currentContext = currentContext.createSubcontext(nextPath);
                }
            }
            currentContext.bind(components[stop], toBind);
            System.out.println("binding [" + fullPath + "] to " + currentContext);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            System.out.println("binding EXCEPTION [" + e + "]");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (currentContext != null) {
                    currentContext.close();
                }
            }
            catch (Exception eClose) {}
        }
    }
}

