/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import org.apache.axis.message.SOAPEnvelope;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicNamespaceContext
implements NamespaceContext {
    private Properties context = new Properties();

    public void addNamespace(String prefix, String url) {
        if (!this.context.containsKey(prefix)) {
            this.context.setProperty(prefix, url);
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (!this.context.containsKey(prefix)) {
            return "";
        }
        Enumeration<?> en = this.context.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.equals(prefix)) continue;
            return this.context.getProperty(key);
        }
        return "";
    }

    @Override
    public String getPrefix(String namespace) {
        if (!this.context.containsValue(namespace)) {
            return "";
        }
        Enumeration<?> en = this.context.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!this.context.getProperty(key).equals(namespace)) continue;
            return key;
        }
        return "";
    }

    public Iterator<?> getPrefixes(String namespace) {
        return null;
    }

    public void findPrefixNamespace(Node node) {
        NodeList list;
        if (node == null) {
            return;
        }
        if (node.getPrefix() != null && !node.getPrefix().equals("")) {
            this.addNamespace(node.getPrefix(), node.getNamespaceURI());
        }
        if ((list = node.getChildNodes()) == null) {
            return;
        }
        int nodes = list.getLength();
        for (int i = 0; i < nodes; ++i) {
            Node child = list.item(i);
            this.findPrefixNamespace(child);
        }
    }

    public static DynamicNamespaceContext getNamespaceContext(Node node) {
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace(node);
        return dnc;
    }

    public static DynamicNamespaceContext getNamespaceContextFromSoapEnvelope(byte[] soapenvelope) throws SAXException {
        SOAPEnvelope envelope = new SOAPEnvelope((InputStream)new ByteArrayInputStream(soapenvelope));
        DynamicNamespaceContext dnc = new DynamicNamespaceContext();
        dnc.findPrefixNamespace((Node)envelope);
        return dnc;
    }
}

