/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import com.ibm.wsdl.TypesImpl;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Message;
import org.openspcoop.dao.registry.MessagePart;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.WSDL;
import org.openspcoop.dao.registry.driver.WSDLAccordoServizio;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSDLUtility {
    private Logger logger = null;
    private WSDLAccordoServizio accordoServizio = null;

    public WSDLUtility(Logger log) {
        this.logger = log != null ? log : Logger.getLogger((String)"WSDLUtility");
    }

    public WSDLAccordoServizio getAccordoServizio() {
        return this.accordoServizio;
    }

    public void setAccordoServizio(WSDLAccordoServizio accordoServizio) {
        this.accordoServizio = accordoServizio;
    }

    public Schema buildSchema() throws DriverRegistroServiziException {
        if (this.accordoServizio == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizio.getLocationWsdlDefinitorio() == null || "".equals(this.accordoServizio.getLocationWsdlDefinitorio())) {
            throw new DriverRegistroServiziException("Location del WsdlDefinitorio non definito");
        }
        return this.buildSchema(this.accordoServizio.getLocationWsdlDefinitorio());
    }

    public Schema buildSchema(String location) throws DriverRegistroServiziException {
        try {
            if (location == null || "".equals(location)) {
                throw new Exception("Location del WsdlDefinitorio non definito");
            }
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = null;
            StreamSource streamSource = null;
            if (location.startsWith("http://") || location.startsWith("file://")) {
                streamSource = new StreamSource(location);
            } else {
                File f = new File(location);
                if (!f.exists()) {
                    throw new Exception("File non esistente");
                }
                streamSource = new StreamSource(f);
            }
            schema = factory.newSchema(streamSource);
            return schema;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema [" + location + "]: " + e.getMessage(), e);
        }
    }

    public Schema buildSchemaFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizio == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizio.getLocationWsdlDefinitorioByte() == null) {
            throw new DriverRegistroServiziException("WsdlDefinitorio non definito");
        }
        return this.buildSchemaFromBytes(this.accordoServizio.getLocationWsdlDefinitorioByte());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema buildSchemaFromBytes(byte[] definitorio) throws DriverRegistroServiziException {
        Schema schema2;
        ByteArrayInputStream bin = null;
        try {
            try {
                Schema schema;
                if (definitorio == null) throw new Exception("WsdlDefinitorio non definito");
                if (definitorio.length <= 0) {
                    throw new Exception("WsdlDefinitorio non definito");
                }
                SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                bin = new ByteArrayInputStream(definitorio);
                StreamSource streamSource = new StreamSource(bin);
                schema2 = schema = factory.newSchema(streamSource);
                Object var8_8 = null;
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema dai bytes: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                bin.close();
                throw throwable;
            }
            catch (Exception eClose) {
                throw throwable;
            }
        }
        try {}
        catch (Exception eClose) {
            // empty catch block
            return schema2;
        }
        bin.close();
        return schema2;
    }

    public Schema buildSchemaFromWsdlTypes(Definition wsdl) throws DriverRegistroServiziException {
        try {
            if (wsdl == null) {
                throw new Exception("Wsdl non fornito");
            }
            Types definitorio = wsdl.getTypes();
            if (definitorio == null) {
                throw new Exception("Wsdl non contiene la definizione degli elementi (Types)");
            }
            Element schema = definitorio.getDocumentationElement();
            if (schema == null || !schema.hasChildNodes()) {
                throw new Exception("Wsdl non contiene la definizione degli elementi (Types)");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.ElementToStream((Element)schema, (OutputStream)bout);
            return this.buildSchemaFromBytes(bout.toByteArray());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante l'inizializzazione dello schema dal wsdl: " + e.getMessage(), e);
        }
    }

    public Definition buildWsdlErogatore() throws DriverRegistroServiziException {
        if (this.accordoServizio == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizio.getLocationWsdlLogicoErogatore() == null || "".equals(this.accordoServizio.getLocationWsdlLogicoErogatore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoErogatore non definito");
        }
        Definition wsdl = this.buildWsdl(this.accordoServizio.getLocationWsdlLogicoErogatore());
        if (this.accordoServizio.getLocationWsdlImplementativoErogatore() != null && !"".equals(this.accordoServizio.getLocationWsdlImplementativoErogatore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizio.getLocationWsdlImplementativoErogatore());
            this.logger.debug((Object)"Add parte implementativa...");
            this.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdlFruitore() throws DriverRegistroServiziException {
        if (this.accordoServizio == null) {
            throw new DriverRegistroServiziException("Accordo di Servizio non definito, utilizza setAccordoServizio()");
        }
        if (this.accordoServizio.getLocationWsdlLogicoFruitore() == null || "".equals(this.accordoServizio.getLocationWsdlLogicoFruitore())) {
            throw new DriverRegistroServiziException("Location del WsdlLogicoFruitore non definito, utilizza setLocationWsdlLogicoFruitore(String)");
        }
        Definition wsdl = this.buildWsdl(this.accordoServizio.getLocationWsdlLogicoFruitore());
        if (this.accordoServizio.getLocationWsdlImplementativoFruitore() != null && !"".equals(this.accordoServizio.getLocationWsdlImplementativoFruitore())) {
            Definition wsdlImplementativo = this.buildWsdl(this.accordoServizio.getLocationWsdlImplementativoFruitore());
            this.logger.debug((Object)"Add parte implementativa...");
            this.addParteImplementativa(wsdl, wsdlImplementativo);
        }
        return wsdl;
    }

    public Definition buildWsdl(String url) throws DriverRegistroServiziException {
        try {
            WSDLReaderImpl builderWSDL = new WSDLReaderImpl();
            Definition wsdl = null;
            if (url.startsWith("http://") || url.startsWith("file://")) {
                wsdl = builderWSDL.readWSDL(url);
            } else {
                File f = new File(url);
                wsdl = builderWSDL.readWSDL(f.toURI().toString());
            }
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl [" + url + "]: " + e.getMessage(), e);
        }
    }

    public Definition buildWsdlErogatoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizio.getLocationWsdlLogicoErogatoreByte() == null || "".equals(this.accordoServizio.getLocationWsdlLogicoErogatoreByte())) {
            throw new DriverRegistroServiziException("Byte del WsdlLogicoErogatore non definito, utilizza setLocationWsdlLogicoErogatoreByte(byte[])");
        }
        return this.buildWsdlFromBytes(this.accordoServizio.getLocationWsdlDefinitorioByte(), this.accordoServizio.getLocationWsdlLogicoErogatoreByte(), this.accordoServizio.getLocationWsdlImplementativoErogatoreByte());
    }

    public Definition buildWsdlFruitoreFromBytes() throws DriverRegistroServiziException {
        if (this.accordoServizio.getLocationWsdlLogicoFruitoreByte() == null || "".equals(this.accordoServizio.getLocationWsdlLogicoFruitoreByte())) {
            throw new DriverRegistroServiziException("Byte del WsdlLogicoFruitore non definito, utilizza setLocationWsdlLogicoFruitoreByte(byte[])");
        }
        return this.buildWsdlFromBytes(this.accordoServizio.getLocationWsdlDefinitorioByte(), this.accordoServizio.getLocationWsdlLogicoFruitoreByte(), this.accordoServizio.getLocationWsdlImplementativoFruitoreByte());
    }

    public Definition buildWsdlFromBytes(byte[] definitorioByte, byte[] logicoByte, byte[] implementativoByte) throws DriverRegistroServiziException {
        try {
            WSDLReaderImpl builderWSDL = new WSDLReaderImpl();
            Definition wsdl = null;
            if (logicoByte == null) {
                throw new Exception("Wsdl logico (byte[]) non definito");
            }
            this.logger.debug((Object)"Leggo WSDL logico");
            ByteArrayInputStream binLogico = new ByteArrayInputStream(logicoByte);
            Document documentLogico = XMLUtils.newDocument((InputStream)binLogico);
            binLogico.close();
            this.logger.debug((Object)"Rimuovo import da WSDL Logico");
            this.removeImportFromWsdl(documentLogico);
            this.logger.debug((Object)"Costruisco WSDL Logico");
            wsdl = builderWSDL.readWSDL(null, documentLogico);
            this.logger.debug((Object)"Aggiungo definitorio a WSDL logico");
            if (definitorioByte != null) {
                TypesImpl wsdlDefinitorio = new TypesImpl();
                ByteArrayInputStream binD = new ByteArrayInputStream(definitorioByte);
                Document definitorio = XMLUtils.newDocument((InputStream)binD);
                binD.close();
                wsdlDefinitorio.setDocumentationElement(definitorio.getDocumentElement());
                wsdl.setTypes((Types)wsdlDefinitorio);
            }
            if (implementativoByte != null) {
                this.logger.debug((Object)"Leggo WSDL implementativo");
                ByteArrayInputStream binImplementativo = new ByteArrayInputStream(implementativoByte);
                Document documentImplementativo = XMLUtils.newDocument((InputStream)binImplementativo);
                binImplementativo.close();
                this.logger.debug((Object)"Rimuovo import da WSDL Loimplementativogico");
                this.removeImportFromWsdl(documentImplementativo);
                this.logger.debug((Object)"Costruisco WSDL Implementativo");
                Definition wsdlImplementativo = builderWSDL.readWSDL(null, documentImplementativo);
                this.addParteImplementativa(wsdl, wsdlImplementativo);
            }
            return wsdl;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la costruzione del wsdl dai bytes: " + e.getMessage(), e);
        }
    }

    public void removeImportFromWsdl(Document document) {
        NodeList list = document.getChildNodes();
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList listDefinition;
                Node child = list.item(i);
                if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                for (int j = 0; j < listDefinition.getLength(); ++j) {
                    Node childDefinition = listDefinition.item(j);
                    if (!"import".equals(childDefinition.getLocalName())) continue;
                    child.removeChild(childDefinition);
                }
            }
        }
    }

    public void addParteImplementativa(Definition wsdlOriginale, Definition wsdlImplementativo) {
        this.logger.debug((Object)"Aggiungo wsdl-binding...");
        Map bindings = wsdlImplementativo.getAllBindings();
        if (bindings != null && bindings.size() > 0) {
            this.logger.debug((Object)("Aggiungo wsdl-binding [" + bindings.size() + "] a wsdl ritornato"));
            for (Binding bindingWSDL : bindings.values()) {
                wsdlOriginale.addBinding(bindingWSDL);
            }
        }
        this.logger.debug((Object)"Aggiungo wsdl-service...");
        Map services = wsdlImplementativo.getAllServices();
        if (services != null && services.size() > 0) {
            this.logger.debug((Object)("Aggiungo wsdl-service [" + services.size() + "] a wsdl ritornato"));
            for (Service serviceWSDL : services.values()) {
                wsdlOriginale.addService(serviceWSDL);
            }
        }
    }

    public WSDLAccordoServizio buildAccordoServizioFromWsdl(WSDLAccordoServizio wsdlAS, Definition wsdl, boolean readParteImplementativa) throws DriverRegistroServiziException {
        return this.buildAccordoServizioFromWsdl(wsdlAS, null, wsdl, readParteImplementativa);
    }

    public WSDLAccordoServizio buildAccordoServizioFromWsdl(Schema schema, Definition wsdl, boolean readParteImplementativa) throws DriverRegistroServiziException {
        return this.buildAccordoServizioFromWsdl(null, schema, wsdl, readParteImplementativa);
    }

    private WSDLAccordoServizio buildAccordoServizioFromWsdl(WSDLAccordoServizio wsdlASParam, Schema schema, Definition wsdl, boolean readParteImplementativa) throws DriverRegistroServiziException {
        try {
            WSDLAccordoServizio wsdlAS = null;
            if (wsdlASParam != null) {
                wsdlAS = wsdlASParam;
            } else {
                wsdlAS = new WSDLAccordoServizio();
                wsdlAS.setSchema(schema);
            }
            javax.wsdl.PortType portTypeWSDL2 = null;
            Map portTypes = wsdl.getPortTypes();
            if (portTypes == null || portTypes.size() <= 0) {
                throw new DriverRegistroServiziException("Port types non presenti");
            }
            for (javax.wsdl.PortType portTypeWSDL2 : portTypes.values()) {
                PortType ptAS = new PortType();
                ptAS.setNome(portTypeWSDL2.getQName().getLocalPart());
                this.logger.debug((Object)("add port type: [" + portTypeWSDL2.getQName().getLocalPart() + "]"));
                List operations = portTypeWSDL2.getOperations();
                if (operations == null || operations.size() <= 0) {
                    throw new DriverRegistroServiziException("operations per il port type [" + ptAS.getNome() + "] non presenti");
                }
                for (int opIndex = 0; opIndex < operations.size(); ++opIndex) {
                    Map argumentsOperationOutput;
                    String elementName;
                    Part argument;
                    MessagePart partAS;
                    Iterator argumentsIterator;
                    Map argumentsOperationInput;
                    javax.wsdl.Operation operationWSDL = (javax.wsdl.Operation)operations.get(opIndex);
                    Operation operationAS = new Operation();
                    operationAS.setNome(operationWSDL.getName());
                    this.logger.debug((Object)("add operation: [" + operationWSDL.getName() + "]"));
                    if (operationWSDL.getInput() != null && operationWSDL.getInput().getMessage() != null && operationWSDL.getInput().getMessage().getParts() != null && (argumentsOperationInput = operationWSDL.getInput().getMessage().getParts()) != null && argumentsOperationInput.size() > 0) {
                        Message mInputAS = new Message();
                        argumentsIterator = argumentsOperationInput.values().iterator();
                        while (argumentsIterator.hasNext()) {
                            partAS = new MessagePart();
                            argument = (Part)argumentsIterator.next();
                            elementName = argument.getElementName().getLocalPart();
                            partAS.setElementName(elementName);
                            mInputAS.addPart(partAS);
                            this.logger.debug((Object)("add message input dell'operation[" + operationWSDL.getName() + "] con element-name: " + elementName));
                        }
                        operationAS.setMessageInput(mInputAS);
                    }
                    if (operationWSDL.getOutput() != null && operationWSDL.getOutput().getMessage() != null && operationWSDL.getOutput().getMessage().getParts() != null && (argumentsOperationOutput = operationWSDL.getOutput().getMessage().getParts()) != null && argumentsOperationOutput.size() > 0) {
                        Message mOutputAS = new Message();
                        argumentsIterator = argumentsOperationOutput.values().iterator();
                        while (argumentsIterator.hasNext()) {
                            partAS = new MessagePart();
                            argument = (Part)argumentsIterator.next();
                            elementName = argument.getElementName().getLocalPart();
                            partAS.setElementName(elementName);
                            mOutputAS.addPart(partAS);
                            this.logger.debug((Object)("add message output dell'operation[" + operationWSDL.getName() + "] con element-name: " + elementName));
                        }
                        operationAS.setMessageOutput(mOutputAS);
                    }
                    ptAS.addAzione(operationAS);
                }
                wsdlAS.addPortType(ptAS);
            }
            if (readParteImplementativa) {
                Map bindings = wsdl.getAllBindings();
                if (bindings == null || bindings.size() <= 0) {
                    throw new DriverRegistroServiziException("bindings non presenti");
                }
                this.logger.debug((Object)("bindings presenti [" + bindings.size() + "]"));
                Binding bindingWSDL2 = null;
                for (Binding bindingWSDL2 : bindings.values()) {
                    List bindingsOperation;
                    String nomePortType = bindingWSDL2.getPortType().getQName().getLocalPart();
                    PortType ptAS = wsdlAS.removePortType(nomePortType);
                    if (ptAS == null) {
                        throw new DriverRegistroServiziException("Port type [" + nomePortType + "] non presente, nella lista dei port type, durante l'analisi della parte di binding");
                    }
                    this.logger.debug((Object)("esamino binding per port type: [" + nomePortType + "]"));
                    List extendibleElements = bindingWSDL2.getExtensibilityElements();
                    if (extendibleElements != null) {
                        this.logger.debug((Object)("esamino binding extendibles [" + extendibleElements.size() + "] per port type: [" + nomePortType + "]"));
                        for (int i = 0; i < extendibleElements.size(); ++i) {
                            ExtensibilityElement elem = (ExtensibilityElement)extendibleElements.get(i);
                            this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBinding:" + (elem instanceof SOAPBinding)));
                            if (!(elem instanceof SOAPBinding)) continue;
                            SOAPBinding soapBinding = (SOAPBinding)elem;
                            ptAS.setStyle(soapBinding.getStyle());
                            this.logger.debug((Object)("add style port type [" + nomePortType + "]: " + soapBinding.getStyle()));
                        }
                    }
                    if ((bindingsOperation = bindingWSDL2.getBindingOperations()) == null || bindingsOperation.size() <= 0) {
                        throw new DriverRegistroServiziException("Bindings operations per il port type [" + ptAS.getNome() + "] non presenti");
                    }
                    for (int i = 0; i < bindingsOperation.size(); ++i) {
                        List extendibleElementsMessageOutput;
                        BindingOutput bindingOutput;
                        List extendibleElementsMessageInput;
                        BindingInput bindingInput;
                        BindingOperation bindingOperation = (BindingOperation)bindingsOperation.get(i);
                        String nomeOperation = bindingOperation.getName();
                        Operation operationAS = null;
                        for (int j = 0; j < ptAS.sizeAzioneList(); ++j) {
                            if (!nomeOperation.equals(ptAS.getAzione(j).getNome())) continue;
                            operationAS = ptAS.removeAzione(j);
                            ++j;
                        }
                        if (operationAS == null) {
                            throw new DriverRegistroServiziException("Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "] non presente, nella lista delle operation, durante l'analisi della parte di binding");
                        }
                        List extendibleElementsOperations = bindingOperation.getExtensibilityElements();
                        if (extendibleElementsOperations != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsOperations.size() + "] per azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsOperations.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsOperations.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPOperation:" + (elem instanceof SOAPOperation)));
                                if (!(elem instanceof SOAPOperation)) continue;
                                SOAPOperation soapOperation = (SOAPOperation)elem;
                                operationAS.setStyle(soapOperation.getStyle());
                                this.logger.debug((Object)("add style Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getStyle()));
                                operationAS.setSoapAction(soapOperation.getSoapActionURI());
                                this.logger.debug((Object)("add SOAPAction Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapOperation.getSoapActionURI()));
                            }
                        }
                        if ((bindingInput = bindingOperation.getBindingInput()) != null && (extendibleElementsMessageInput = bindingInput.getExtensibilityElements()) != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsMessageInput.size() + "] per message-input dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsMessageInput.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageInput.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody)));
                                if (!(elem instanceof SOAPBody)) continue;
                                SOAPBody soapBody = (SOAPBody)elem;
                                operationAS.getMessageInput().setUse(soapBody.getUse());
                                this.logger.debug((Object)("add use message input Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse()));
                            }
                        }
                        if ((bindingOutput = bindingOperation.getBindingOutput()) != null && (extendibleElementsMessageOutput = bindingOutput.getExtensibilityElements()) != null) {
                            this.logger.debug((Object)("esamino binding extendibles [" + extendibleElementsMessageOutput.size() + "] per message-output dell'azione[" + nomeOperation + "] del port type[" + nomePortType + "]"));
                            for (int j = 0; j < extendibleElementsMessageOutput.size(); ++j) {
                                ExtensibilityElement elem = (ExtensibilityElement)extendibleElementsMessageOutput.get(j);
                                this.logger.debug((Object)("esamino binding extendibles di tipo:" + elem.getClass().getName() + " instance of SOAPBody:" + (elem instanceof SOAPBody)));
                                if (!(elem instanceof SOAPBody)) continue;
                                SOAPBody soapBody = (SOAPBody)elem;
                                operationAS.getMessageOutput().setUse(soapBody.getUse());
                                this.logger.debug((Object)("add use message output Operation [" + nomeOperation + "] del Port type [" + ptAS.getNome() + "]: " + soapBody.getUse()));
                            }
                        }
                        ptAS.addAzione(operationAS);
                    }
                    wsdlAS.addPortType(ptAS);
                }
            }
            return wsdlAS;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del wsdl: " + e.getMessage(), e);
        }
    }

    public WSDLAccordoServizio buildAccordoServizioFromWsdl(Schema schema, AccordoServizio as) throws DriverRegistroServiziException {
        WSDLAccordoServizio wsdlAS = new WSDLAccordoServizio();
        wsdlAS.setSchema(schema);
        for (int i = 0; i < as.sizePortTypeList(); ++i) {
            wsdlAS.addPortType(as.getPortType(i));
        }
        return wsdlAS;
    }

    public Definition readWSDLFromLocation(String path) throws WSDLException {
        try {
            if (path == null) {
                throw new Exception("Path non definito");
            }
            WSDLReaderImpl reader = new WSDLReaderImpl();
            Definition def = reader.readWSDL(path);
            return def;
        }
        catch (Exception e) {
            throw new WSDLException("WSDLDefinitorio.readWSDLFromLocation(String path)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromBytes(byte[] wsdl) throws WSDLException {
        try {
            if (wsdl == null) {
                throw new Exception("Bytes non definiti");
            }
            WSDLReaderImpl reader = new WSDLReaderImpl();
            ByteArrayInputStream bin = new ByteArrayInputStream(wsdl);
            Document document = XMLUtils.newDocument((InputStream)bin);
            bin.close();
            Definition def = reader.readWSDL(null, document);
            return def;
        }
        catch (Exception e) {
            throw new WSDLException("WSDLDefinitorio.readWSDLFromBytes(byte[] wsdl)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromDocument(Document doc) throws WSDLException {
        try {
            if (doc == null) {
                throw new Exception("Document non definito");
            }
            WSDLReaderImpl reader = new WSDLReaderImpl();
            Definition def = reader.readWSDL(null, doc);
            return def;
        }
        catch (Exception e) {
            throw new WSDLException("WSDLDefinitorio.readWSDLFromDocument(Document doc)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromElement(Element elem) throws WSDLException {
        try {
            if (elem == null) {
                throw new Exception("Element non definito");
            }
            WSDLReaderImpl reader = new WSDLReaderImpl();
            String param = null;
            Definition def = reader.readWSDL(param, elem);
            return def;
        }
        catch (Exception e) {
            throw new WSDLException("WSDLDefinitorio.readWSDLFromElement(Element elem)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public Definition readWSDLFromURI(URI uri) throws WSDLException {
        try {
            if (uri == null) {
                throw new Exception("URI non definita");
            }
            WSDLReaderImpl reader = new WSDLReaderImpl();
            Definition def = reader.readWSDL(null, uri.getPath());
            return def;
        }
        catch (Exception e) {
            throw new WSDLException("WSDLDefinitorio.readWSDLFromURI(URI uri)", "Lettura del wsdl non riuscita: " + e.getMessage());
        }
    }

    public void removeAllImports(Definition definition) throws WSDLException {
        if (definition == null) {
            throw new WSDLException("removeAllImports(Definition definition)", "WSDL non fornito");
        }
        WSDL wsdl = new WSDL(definition);
        wsdl.removeAllImports();
    }

    public void removeAllMessages(Definition definition) throws WSDLException {
        if (definition == null) {
            throw new WSDLException("removeAllMessages(Definition definition)", "WSDL non fornito");
        }
        WSDL wsdl = new WSDL(definition);
        wsdl.removeAllMessages();
    }

    public void removeAllPortTypes(Definition definition) throws WSDLException {
        if (definition == null) {
            throw new WSDLException("removeAllPortTypes(Definition definition)", "WSDL non fornito");
        }
        WSDL wsdl = new WSDL(definition);
        wsdl.removeAllPortTypes();
    }

    public void removeAllBindings(Definition definition) throws WSDLException {
        if (definition == null) {
            throw new WSDLException("removeAllBindings(Definition definition)", "WSDL non fornito");
        }
        WSDL wsdl = new WSDL(definition);
        wsdl.removeAllBindings();
    }

    public void removeAllServices(Definition definition) throws WSDLException {
        if (definition == null) {
            throw new WSDLException("removeAllServices(Definition definition)", "WSDL non fornito");
        }
        WSDL wsdl = new WSDL(definition);
        wsdl.removeAllServices();
    }
}

