/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import com.ibm.wsdl.DefinitionImpl;
import com.ibm.wsdl.ImportImpl;
import com.ibm.wsdl.xml.WSDLReaderImpl;
import com.ibm.wsdl.xml.WSDLWriterImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openspcoop.dao.registry.driver.WSDL;
import org.openspcoop.dao.registry.driver.WSDLUtility;
import org.openspcoop.utils.Utilities;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class WSDL2SPCoopUtility {
    File tempDir = null;
    private WSDLUtility wsdlUtility = new WSDLUtility(null);
    public WSDL wsdlErogatore;
    public WSDL wsdlFruitore;
    public WSDL wsdlImplementativoErogatore;
    public WSDL wsdlImplementativoFruitore;
    public WSDL wsdlLogicoErogatore;
    public WSDL wsdlLogicoFruitore;
    public WSDL wsdlConcettuale;
    public byte[] wsdlDefinitorio;
    private boolean wsdlSorgenteSoloErogatore = false;
    private boolean debug = false;
    private String path = null;
    private String schemaPath = null;

    public WSDL2SPCoopUtility(String tmpDir) throws WSDLException {
        try {
            this.tempDir = new File(tmpDir);
            if (this.tempDir.exists()) {
                if (!this.tempDir.isDirectory()) {
                    throw new Exception("Path indicato [" + tmpDir + "] esiste e non \u00e8 una directory");
                }
            } else if (!this.tempDir.mkdir()) {
                throw new Exception("Path indicato [" + tmpDir + "] non esiste e non \u00e8 possibile crearlo come directory");
            }
        }
        catch (Exception e) {
            throw new WSDLException("WSDL2SPCoopUtility(String tmpDir)", "Errore durante l'inizializzazione della directory: " + e.getMessage());
        }
    }

    public WSDL getWsdlErogatore() {
        return this.wsdlErogatore;
    }

    public WSDL getWsdlFruitore() {
        return this.wsdlFruitore;
    }

    public void buildWSDLStandard(String pathWsdlImplementativoErogatore, String pathWsdlImplementativoFruitore, boolean unicoWSDLDestinazione) throws WSDLException {
        try {
            if (pathWsdlImplementativoErogatore == null) {
                throw new Exception("pathWsdlImplementativoErogatore is null");
            }
            File wsdlErogatoreTmpFile = File.createTempFile("WSDLErogatore-", "-standard", this.tempDir);
            if (!wsdlErogatoreTmpFile.exists()) {
                wsdlErogatoreTmpFile.createNewFile();
            }
            String wsdlErogatorePath = wsdlErogatoreTmpFile.getAbsolutePath();
            File wsdlFruitoreTmpFile = null;
            String wsdlFruitorePath = null;
            if (!unicoWSDLDestinazione) {
                wsdlFruitoreTmpFile = File.createTempFile("WSDLFruitore-", "-standard", this.tempDir);
                if (!wsdlFruitoreTmpFile.exists()) {
                    wsdlFruitoreTmpFile.createNewFile();
                }
                wsdlFruitorePath = wsdlFruitoreTmpFile.getAbsolutePath();
            }
            this.setWsdlSorgenteSoloErogatore(!unicoWSDLDestinazione);
            this.creaDaWSDL(pathWsdlImplementativoErogatore, pathWsdlImplementativoFruitore, wsdlErogatorePath, wsdlFruitorePath);
            this.wsdlErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlErogatorePath));
            if (!unicoWSDLDestinazione) {
                this.wsdlFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlFruitorePath));
            }
            wsdlErogatoreTmpFile.delete();
            if (wsdlFruitoreTmpFile != null) {
                wsdlFruitoreTmpFile.delete();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("WSDL2SPCoopUtility(String pathWsdlImplementativoErogatore,WSDL pathWsdlImplementativoFruitore)", "Costruzione non riuscita: " + e.getMessage());
        }
    }

    public void buildWSDLStandard(String pathWsdlImplementativoErogatore) throws WSDLException {
        this.buildWSDLStandard(pathWsdlImplementativoErogatore, null, true);
    }

    public void buildWSDLStandard(byte[] definitorio, byte[] byteWsdlImplementativoErogatore, byte[] byteWsdlLogicoErogatore, byte[] byteWsdlImplementativoFruitore, byte[] byteWsdlLogicoFruitore, boolean unicoWSDLDestinazione) throws WSDLException {
        try {
            if (byteWsdlImplementativoErogatore == null) {
                throw new Exception("byteWsdlImplementativoErogatore is null");
            }
            if (byteWsdlLogicoErogatore == null) {
                throw new Exception("byteWsdlLogicoErogatore is null");
            }
            if (definitorio == null) {
                throw new Exception("definitorio is null");
            }
            this.wsdlErogatore = new WSDL(this.wsdlUtility.buildWsdlFromBytes(definitorio, byteWsdlLogicoErogatore, byteWsdlImplementativoErogatore));
            if (byteWsdlImplementativoFruitore != null && byteWsdlLogicoFruitore != null) {
                this.wsdlFruitore = new WSDL(this.wsdlUtility.buildWsdlFromBytes(definitorio, byteWsdlLogicoFruitore, byteWsdlImplementativoFruitore));
            }
            if (unicoWSDLDestinazione && this.wsdlFruitore != null) {
                Map<?, ?> messages = this.wsdlFruitore.getMessages();
                for (Message msg : messages.values()) {
                    this.wsdlErogatore.addMessage(msg);
                }
                Map<?, ?> porttypes = this.wsdlFruitore.getPortTypes();
                for (PortType pt : porttypes.values()) {
                    this.wsdlErogatore.addPortType(pt);
                }
                Map<?, ?> bindings = this.wsdlFruitore.getBindings();
                for (Binding bd : bindings.values()) {
                    this.wsdlErogatore.addBinding(bd);
                }
                Map<?, ?> services = this.wsdlFruitore.getServices();
                for (Service s : services.values()) {
                    this.wsdlErogatore.addService(s);
                }
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("WSDL2SPCoopUtility(Byte)", "Costruzione non riuscita: " + e.getMessage());
        }
    }

    public void buildWSDLStandard(byte[] definitorio, byte[] byteWsdlImplementativoErogatore, byte[] byteWsdlLogicoErogatore) throws WSDLException {
        this.buildWSDLStandard(definitorio, byteWsdlImplementativoErogatore, byteWsdlLogicoErogatore, null, null, true);
    }

    public WSDL getWsdlConcettuale() {
        return this.wsdlConcettuale;
    }

    public byte[] getWsdlDefinitorio() {
        return this.wsdlDefinitorio;
    }

    public WSDL getWsdlImplementativoErogatore() {
        return this.wsdlImplementativoErogatore;
    }

    public WSDL getWsdlImplementativoFruitore() {
        return this.wsdlImplementativoFruitore;
    }

    public WSDL getWsdlLogicoErogatore() {
        return this.wsdlLogicoErogatore;
    }

    public WSDL getWsdlLogicoFruitore() {
        return this.wsdlLogicoFruitore;
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String wsdlFruitore) throws WSDLException {
        try {
            File wsdlDefinitorioTmpFile;
            if (wsdlErogatore == null) {
                throw new Exception("WSDL Erogatore non fornito");
            }
            this.wsdlErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore));
            if (wsdlFruitore != null) {
                this.wsdlFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlFruitore));
            }
            Import[] imports = null;
            imports = this.wsdlFruitore == null ? new Import[1] : (this.wsdlErogatore.getTargetNamespace().equals(this.wsdlFruitore.getTargetNamespace()) ? new Import[1] : new Import[2]);
            imports[0] = new ImportImpl();
            imports[0].setNamespaceURI(this.wsdlErogatore.getTargetNamespace());
            if (imports.length > 1) {
                imports[1] = new ImportImpl();
                imports[1].setNamespaceURI(this.wsdlFruitore.getTargetNamespace());
            }
            if (!(wsdlDefinitorioTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "definitorio.xsd")).exists()) {
                wsdlDefinitorioTmpFile.createNewFile();
            }
            String wsdlDefinitorioPath = wsdlDefinitorioTmpFile.getAbsolutePath();
            File wsdlConcettualeTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "concettuale.wsdl");
            if (!wsdlConcettualeTmpFile.exists()) {
                wsdlConcettualeTmpFile.createNewFile();
            }
            String wsdlConcettualePath = wsdlConcettualeTmpFile.getAbsolutePath();
            File wsdlLogicoErogatoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "logicoErogatore.wsdl");
            if (!wsdlLogicoErogatoreTmpFile.exists()) {
                wsdlLogicoErogatoreTmpFile.createNewFile();
            }
            String wsdlLogicoErogatorePath = wsdlLogicoErogatoreTmpFile.getAbsolutePath();
            File wsdlImplementativoErogatoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "implementativoErogatore.wsdl");
            if (!wsdlImplementativoErogatoreTmpFile.exists()) {
                wsdlImplementativoErogatoreTmpFile.createNewFile();
            }
            String wsdlImplementativoErogatorePath = wsdlImplementativoErogatoreTmpFile.getAbsolutePath();
            String wsdlLogicoFruitorePath = null;
            File wsdlLogicoFruitoreTmpFile = null;
            if (this.wsdlFruitore != null) {
                wsdlLogicoFruitoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "logicoFruitore.wsdl");
                if (!wsdlLogicoFruitoreTmpFile.exists()) {
                    wsdlLogicoFruitoreTmpFile.createNewFile();
                }
                wsdlLogicoFruitorePath = wsdlLogicoFruitoreTmpFile.getAbsolutePath();
            }
            String wsdlImplementativoFruitorePath = null;
            File wsdlImplementativoFruitoreTmpFile = null;
            if (this.wsdlFruitore != null) {
                wsdlImplementativoFruitoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "implementativoFruitore.wsdl");
                if (!wsdlImplementativoFruitoreTmpFile.exists()) {
                    wsdlImplementativoFruitoreTmpFile.createNewFile();
                }
                wsdlImplementativoFruitorePath = wsdlImplementativoFruitoreTmpFile.getAbsolutePath();
            }
            this.creaDefinitorio(wsdlErogatore, wsdlDefinitorioPath);
            if (this.wsdlFruitore != null) {
                this.estendiDefinitorio(wsdlDefinitorioPath, wsdlFruitore);
            }
            imports[0].setLocationURI("definitorio.xsd");
            if (imports.length > 1) {
                imports[1].setLocationURI("definitorio.xsd");
            }
            WSDL fruitorePerConcettuale = null;
            if (wsdlFruitore != null) {
                fruitorePerConcettuale = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlFruitore));
            }
            this.creaConcettuale(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlConcettualePath, imports, fruitorePerConcettuale, null);
            Import[] importLogicoErogatore = new Import[]{imports[0]};
            importLogicoErogatore[0].setLocationURI("definitorio.xsd");
            this.creaLogico(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlLogicoErogatorePath, importLogicoErogatore, null, null, null);
            Import[] importLogicoFruitore = null;
            if (this.wsdlFruitore != null) {
                importLogicoFruitore = new Import[]{imports.length > 1 ? imports[1] : imports[0]};
                importLogicoFruitore[0].setLocationURI("definitorio.xsd");
                this.creaLogico(this.wsdlUtility.readWSDLFromLocation(wsdlFruitore), wsdlLogicoFruitorePath, importLogicoFruitore, null, null, null);
            }
            importLogicoErogatore[0].setLocationURI("logicoErogatore.wsdl");
            WSDL fruitorePerImplementativoErogatore = null;
            if (wsdlFruitore != null) {
                fruitorePerImplementativoErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlFruitore));
            }
            this.creaImplementativo(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlImplementativoErogatorePath, importLogicoErogatore, null, null, fruitorePerImplementativoErogatore);
            if (this.wsdlFruitore != null) {
                importLogicoFruitore[0].setLocationURI("logicoFruitore.wsdl");
                this.creaImplementativo(this.wsdlUtility.readWSDLFromLocation(wsdlFruitore), wsdlImplementativoFruitorePath, importLogicoFruitore, null, null, this.wsdlUtility.readWSDLFromLocation(wsdlFruitore));
            }
            this.wsdlDefinitorio = Utilities.readFile(wsdlDefinitorioPath);
            this.wsdlConcettuale = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlConcettualePath));
            this.wsdlLogicoErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlLogicoErogatorePath));
            this.wsdlImplementativoErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlImplementativoErogatorePath));
            if (this.wsdlFruitore != null) {
                this.wsdlLogicoFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlLogicoFruitorePath));
                this.wsdlImplementativoFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlImplementativoFruitorePath));
            }
            wsdlDefinitorioTmpFile.delete();
            wsdlConcettualeTmpFile.delete();
            wsdlLogicoErogatoreTmpFile.delete();
            wsdlImplementativoErogatoreTmpFile.delete();
            if (this.wsdlFruitore != null) {
                wsdlLogicoFruitoreTmpFile.delete();
                wsdlImplementativoFruitoreTmpFile.delete();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(String)", "Split non riuscito: " + e.getMessage());
        }
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore) throws WSDLException {
        String fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore);
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore) throws WSDLException {
        try {
            int j;
            if (wsdlErogatore == null) {
                throw new Exception("WSDL Erogatore non fornito");
            }
            if (porttypesErogatore == null) {
                throw new Exception("PortyTypes per il wsdl erogatore non forniti");
            }
            if (operationPorttypesErogatore == null) {
                throw new Exception("Operations dei PortyTypes per il wsdl erogatore non forniti");
            }
            if (porttypesErogatore.length != operationPorttypesErogatore.length) {
                throw new Exception("Operations [" + operationPorttypesErogatore.length + "] dei PortyTypes [" + porttypesErogatore.length + "] per il wsdl erogatore non correlato correttamente ai port types");
            }
            if (porttypesFruitore != null) {
                if (operationPorttypesFruitore == null) {
                    throw new Exception("Operations dei PortyTypes per il wsdl fruitore non forniti");
                }
                if (porttypesFruitore.length != operationPorttypesFruitore.length) {
                    throw new Exception("Operations [" + operationPorttypesErogatore.length + "] dei PortyTypes [" + porttypesErogatore.length + "] per il wsdl fruitore non correlato correttamente ai port types");
                }
            }
            this.wsdlErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore));
            Import[] imports = new Import[]{new ImportImpl()};
            imports[0].setNamespaceURI(this.wsdlErogatore.getTargetNamespace());
            File wsdlDefinitorioTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "definitorio.xsd");
            if (!wsdlDefinitorioTmpFile.exists()) {
                wsdlDefinitorioTmpFile.createNewFile();
            }
            String wsdlDefinitorioPath = wsdlDefinitorioTmpFile.getAbsolutePath();
            File wsdlConcettualeTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "concettuale.wsdl");
            if (!wsdlConcettualeTmpFile.exists()) {
                wsdlConcettualeTmpFile.createNewFile();
            }
            String wsdlConcettualePath = wsdlConcettualeTmpFile.getAbsolutePath();
            File wsdlLogicoErogatoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "logicoErogatore.wsdl");
            if (!wsdlLogicoErogatoreTmpFile.exists()) {
                wsdlLogicoErogatoreTmpFile.createNewFile();
            }
            String wsdlLogicoErogatorePath = wsdlLogicoErogatoreTmpFile.getAbsolutePath();
            File wsdlImplementativoErogatoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "implementativoErogatore.wsdl");
            if (!wsdlImplementativoErogatoreTmpFile.exists()) {
                wsdlImplementativoErogatoreTmpFile.createNewFile();
            }
            String wsdlImplementativoErogatorePath = wsdlImplementativoErogatoreTmpFile.getAbsolutePath();
            String wsdlLogicoFruitorePath = null;
            File wsdlLogicoFruitoreTmpFile = null;
            if (porttypesFruitore != null) {
                wsdlLogicoFruitoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "logicoFruitore.wsdl");
                if (!wsdlLogicoFruitoreTmpFile.exists()) {
                    wsdlLogicoFruitoreTmpFile.createNewFile();
                }
                wsdlLogicoFruitorePath = wsdlLogicoFruitoreTmpFile.getAbsolutePath();
            }
            String wsdlImplementativoFruitorePath = null;
            File wsdlImplementativoFruitoreTmpFile = null;
            if (porttypesFruitore != null) {
                wsdlImplementativoFruitoreTmpFile = new File(this.tempDir.getAbsolutePath() + File.separator + "implementativoFruitore.wsdl");
                if (!wsdlImplementativoFruitoreTmpFile.exists()) {
                    wsdlImplementativoFruitoreTmpFile.createNewFile();
                }
                wsdlImplementativoFruitorePath = wsdlImplementativoFruitoreTmpFile.getAbsolutePath();
            }
            this.creaDefinitorio(wsdlErogatore, wsdlDefinitorioPath);
            imports[0].setLocationURI("definitorio.xsd");
            String[] portTypesDaConsiderare = null;
            portTypesDaConsiderare = porttypesFruitore != null ? new String[porttypesErogatore.length + porttypesFruitore.length] : new String[porttypesErogatore.length];
            int i = 0;
            for (j = 0; j < porttypesErogatore.length; ++j) {
                portTypesDaConsiderare[i] = porttypesErogatore[j];
                ++i;
            }
            if (porttypesFruitore != null) {
                for (j = 0; j < porttypesFruitore.length; ++j) {
                    portTypesDaConsiderare[i] = porttypesFruitore[j];
                    ++i;
                }
            }
            this.creaConcettuale(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlConcettualePath, imports, null, portTypesDaConsiderare);
            imports[0].setLocationURI("definitorio.xsd");
            this.creaLogico(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlLogicoErogatorePath, imports, porttypesErogatore, operationPorttypesErogatore, null);
            if (porttypesFruitore != null) {
                this.creaLogico(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlLogicoFruitorePath, imports, porttypesFruitore, operationPorttypesFruitore, null);
            }
            imports[0].setLocationURI("logicoErogatore.wsdl");
            this.creaImplementativo(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlImplementativoErogatorePath, imports, porttypesErogatore, operationPorttypesErogatore, null);
            if (porttypesFruitore != null) {
                imports[0].setLocationURI("logicoFruitore.wsdl");
                this.creaImplementativo(this.wsdlUtility.readWSDLFromLocation(wsdlErogatore), wsdlImplementativoFruitorePath, imports, porttypesFruitore, operationPorttypesFruitore, null);
            }
            this.wsdlDefinitorio = Utilities.readFile(wsdlDefinitorioPath);
            this.wsdlConcettuale = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlConcettualePath));
            if (porttypesFruitore == null) {
                this.puliziaWSDLConcettuale_singoloWSDLErogatore(porttypesErogatore, operationPorttypesErogatore);
            }
            this.wsdlLogicoErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlLogicoErogatorePath));
            this.wsdlImplementativoErogatore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlImplementativoErogatorePath));
            if (porttypesFruitore != null) {
                this.wsdlLogicoFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlLogicoFruitorePath));
                this.wsdlImplementativoFruitore = new WSDL(this.wsdlUtility.readWSDLFromLocation(wsdlImplementativoFruitorePath));
            }
            wsdlDefinitorioTmpFile.delete();
            wsdlConcettualeTmpFile.delete();
            wsdlLogicoErogatoreTmpFile.delete();
            wsdlImplementativoErogatoreTmpFile.delete();
            if (porttypesFruitore != null) {
                wsdlLogicoFruitoreTmpFile.delete();
                wsdlImplementativoFruitoreTmpFile.delete();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(String,portTypes...)", "Split non riuscito: " + e.getMessage());
        }
    }

    public void splitIntoWSDLSPCoop(String wsdlErogatore, String[] porttypesErogatore, String[] operationPorttypesErogatore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, porttypesErogatore, operationPorttypesErogatore, null, null);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, byte[] wsdlFruitore) throws WSDLException {
        try {
            File wsdlErogatoreTmpFile = File.createTempFile("WSDLErogatoreFromByte-", "-spcoop", this.tempDir);
            if (!wsdlErogatoreTmpFile.exists()) {
                wsdlErogatoreTmpFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(wsdlErogatoreTmpFile);
            fout.write(wsdlErogatore);
            fout.flush();
            fout.close();
            String pathFileErogatore = wsdlErogatoreTmpFile.getAbsolutePath();
            String pathFileFruitore = null;
            File wsdlFruitoreTmpFile = null;
            if (wsdlFruitore != null) {
                wsdlFruitoreTmpFile = File.createTempFile("WSDLFruitoreFromByte-", "-spcoop", this.tempDir);
                if (!wsdlFruitoreTmpFile.exists()) {
                    wsdlFruitoreTmpFile.createNewFile();
                }
                fout = new FileOutputStream(wsdlFruitoreTmpFile);
                fout.write(wsdlFruitore);
                fout.flush();
                fout.close();
                pathFileFruitore = wsdlFruitoreTmpFile.getAbsolutePath();
            }
            this.splitIntoWSDLSPCoop(pathFileErogatore, pathFileFruitore);
            wsdlErogatoreTmpFile.delete();
            if (wsdlFruitore != null) {
                wsdlFruitoreTmpFile.delete();
            }
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(Byte)", "Split non riuscito: " + e.getMessage());
        }
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore) throws WSDLException {
        byte[] fruitore = null;
        this.splitIntoWSDLSPCoop(wsdlErogatore, fruitore);
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, String[] porttypesErogatore, String[] operationPorttypesErogatore, String[] porttypesFruitore, String[] operationPorttypesFruitore) throws WSDLException {
        try {
            File wsdlErogatoreTmpFile = File.createTempFile("WSDLErogatoreFromByte-", "-spcoop", this.tempDir);
            if (!wsdlErogatoreTmpFile.exists()) {
                wsdlErogatoreTmpFile.createNewFile();
            }
            FileOutputStream fout = new FileOutputStream(wsdlErogatoreTmpFile);
            fout.write(wsdlErogatore);
            fout.flush();
            fout.close();
            String pathFileErogatore = wsdlErogatoreTmpFile.getAbsolutePath();
            this.splitIntoWSDLSPCoop(pathFileErogatore, porttypesErogatore, operationPorttypesErogatore, porttypesFruitore, operationPorttypesFruitore);
            wsdlErogatoreTmpFile.delete();
        }
        catch (Exception e) {
            if (this.debug) {
                e.printStackTrace();
            }
            throw new WSDLException("splitIntoWSDLSPCoop(Byte,PortType...)", "Split non riuscito: " + e.getMessage());
        }
    }

    public void splitIntoWSDLSPCoop(byte[] wsdlErogatore, String[] porttypesErogatore, String[] operationPorttypesErogatore) throws WSDLException {
        this.splitIntoWSDLSPCoop(wsdlErogatore, porttypesErogatore, operationPorttypesErogatore, null, null);
    }

    public boolean isWsdlSorgenteSoloErogatore() {
        return this.wsdlSorgenteSoloErogatore;
    }

    public void setWsdlSorgenteSoloErogatore(boolean wsdlSorgenteSoloErogatore) {
        this.wsdlSorgenteSoloErogatore = wsdlSorgenteSoloErogatore;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSchemaPath() {
        return this.schemaPath;
    }

    public void setSchemaPath(String schemaPath) {
        this.schemaPath = schemaPath;
    }

    private void puliziaWSDLConcettuale_singoloWSDLErogatore(String[] porttypesErogatore, String[] operationPorttypesErogatore) {
        Map<?, ?> map = this.wsdlConcettuale.getPortTypes();
        Iterator<?> it = map.values().iterator();
        Vector<Message> mess = new Vector<Message>();
        while (it.hasNext()) {
            PortType pt = (PortType)it.next();
            String[] operations = null;
            for (int j = 0; j < porttypesErogatore.length; ++j) {
                if (!pt.getQName().getLocalPart().equals(porttypesErogatore[j])) continue;
                operations = operationPorttypesErogatore[j].split(",");
            }
            List ops = pt.getOperations();
            Vector<String> opRemove = new Vector<String>();
            for (int j = 0; j < ops.size(); ++j) {
                Operation op = (Operation)ops.get(j);
                boolean find = false;
                for (int k = 0; k < operations.length; ++k) {
                    if (!operations[k].trim().equals(op.getName())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                opRemove.add(op.getName());
            }
            while (opRemove.size() > 0) {
                pt.removeOperation((String)opRemove.remove(0), null, null);
            }
            List myl = pt.getOperations();
            int k = myl.size();
            for (int h = 0; h < k; ++h) {
                Message output;
                Message input;
                Operation operationWSDL = (Operation)myl.get(h);
                Message message = input = operationWSDL.getInput() == null ? null : operationWSDL.getInput().getMessage();
                if (input != null) {
                    mess.add(input);
                }
                Message message2 = output = operationWSDL.getOutput() == null ? null : operationWSDL.getOutput().getMessage();
                if (output == null) continue;
                mess.add(output);
            }
        }
        map = this.wsdlConcettuale.getMessages();
        it = map.values().iterator();
        Vector<Message> removeM = new Vector<Message>();
        while (it.hasNext()) {
            Message temp = (Message)it.next();
            if (mess.contains(temp)) continue;
            removeM.add(temp);
        }
        int j = removeM.size();
        for (int i = 0; i < j; ++i) {
            this.wsdlConcettuale.removeMessage(((Message)removeM.get(i)).getQName());
        }
    }

    public void creaDaWSDL(String wsdl, String wsdl_secondario, String path, String path_sec) throws WSDLException, IOException, SAXException, ParserConfigurationException, TransformerException, TransformerConfigurationException {
        if (wsdl == null) {
            if (this.debug) {
                System.err.println("Primo wsdl necessario");
            }
            return;
        }
        if (path_sec != null) {
            this.creaDaWSDL(wsdl, null, path, null);
            this.creaDaWSDL(wsdl_secondario, null, path_sec, null);
            return;
        }
        DefinitionImpl definition = new DefinitionImpl();
        WSDLWriterImpl writer = new WSDLWriterImpl();
        try {
            Definition def = this.wsdlUtility.readWSDLFromLocation(wsdl);
            this.creaDefinizione((Definition)definition, def, path);
            if (wsdl_secondario != null) {
                this.creaDefinizione((Definition)definition, this.wsdlUtility.readWSDLFromLocation(wsdl_secondario), path);
            }
            writer.writeWSDL((Definition)definition, (Writer)new FileWriter(path));
            this.updateBySchema();
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void creaDefinizione(Definition def, Definition def_sec, String path) throws WSDLException, IOException, SAXException, ParserConfigurationException {
        try {
            String p = "temp.wsdl";
            File f = new File(p);
            f.createNewFile();
            new WSDLWriterImpl().writeWSDL(def_sec, (Writer)new FileWriter(p));
            String[] ns = this.getNamespaces(p);
            if (ns != null) {
                int j = ns.length;
                for (int i = 0; i < j; ++i) {
                    String[] namespace = ns[i].split("@@@");
                    String name = namespace[0].replaceAll("xmlns:", "");
                    if (name.indexOf("targetNamespace") == -1) {
                        def.addNamespace(name, namespace[1]);
                    } else {
                        def.setTargetNamespace(namespace[1]);
                    }
                    if (!this.debug) continue;
                    System.out.println(namespace[0].replaceAll("xmlns:", "") + "=" + namespace[1]);
                }
            } else if (this.debug) {
                System.out.println("WSDL di origine senza namespace.");
            }
            def.setExtensionRegistry(def_sec.getExtensionRegistry());
            this.estendiDaImport(def, p, path);
            f.delete();
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void updateBySchema() throws WSDLException, IOException, TransformerException, SAXException, ParserConfigurationException, TransformerConfigurationException {
        try {
            Definition def = new WSDLReaderImpl().readWSDL(this.path);
            String tmpPath = this.path + ".tempFile";
            File file = new File(tmpPath);
            file.createNewFile();
            new WSDLWriterImpl().writeWSDL(def, (Writer)new FileWriter(tmpPath));
            if (this.debug) {
                System.out.println("Temporaneo scritto in " + tmpPath);
            }
            this.aggiungiNodo(this.path, "wsdl:types");
            def = new WSDLReaderImpl().readWSDL(this.path);
            this.estendiTypes(this.path, this.schemaPath);
            def = new WSDLReaderImpl().readWSDL(this.path);
            if (def.getTypes() == null) {
                if (this.debug) {
                    System.err.println("Types nulli");
                }
            } else if (this.debug) {
                System.out.println("Types ok");
                this.printFile(this.path);
            }
            file.delete();
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private String[] getNamespaces(String wsdl) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(wsdl));
            Element el = doc.getDocumentElement();
            if (el == null) {
                if (this.debug) {
                    System.err.println("Document Element nullo");
                }
                return null;
            }
            NamedNodeMap m = el.getAttributes();
            String[] ns = new String[m.getLength()];
            int j = m.getLength();
            for (int i = 0; i < j; ++i) {
                Node n = m.item(i);
                ns[i] = n.getNodeName() + "@@@" + n.getNodeValue();
                if (!this.debug) continue;
                System.out.println(ns[i]);
            }
            return ns;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private void estendiDaImport(Definition def, String im, String path) throws WSDLException {
        int j;
        List l;
        if (def == null || im == null) {
            return;
        }
        String[] locs = im.split("=");
        int j2 = locs.length;
        for (int i = 0; i < j2; ++i) {
            if (locs[i].indexOf("locationURI") == -1) continue;
            im = locs[i + 1].split("\n")[0];
            break;
        }
        if (im.indexOf("xsd") != -1) {
            if (this.debug) {
                System.out.println("Il file " + im + " e' uno schema");
            }
            this.path = path;
            this.schemaPath = im;
            return;
        }
        try {
            Definition temp = new WSDLReaderImpl().readWSDL(im);
            Map imp = temp.getImports();
            Iterator imports = imp.values().iterator();
            while (imports.hasNext()) {
                this.estendiDaImport(def, imports.next().toString(), path);
            }
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        WSDLReaderImpl reader = new WSDLReaderImpl();
        if (this.debug) {
            System.out.println("Leggo il wsdl dal file:" + im);
        }
        Definition def_sec = reader.readWSDL(im);
        Map m = def_sec.getMessages();
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            def.addMessage((Message)it.next());
            if (!this.debug) continue;
            System.out.println("Messaggio aggiunto.");
        }
        m = def_sec.getPortTypes();
        for (PortType pt : m.values()) {
            PortType myPt = def.getPortType(pt.getQName());
            if (myPt != null) {
                if (this.debug) {
                    System.out.println("Il portType esiste gia'. Ne aggiungo le operazioni!");
                }
                l = pt.getOperations();
                j = l.size();
                for (int i = 0; i < j; ++i) {
                    Operation op = (Operation)l.get(i);
                    myPt.addOperation(op);
                    if (!this.debug) continue;
                    System.out.println("Aggiunta operazione:" + op.getName());
                }
                def.removePortType(pt.getQName());
                def.addPortType(myPt);
                if (!this.debug) continue;
                System.out.println("PortType aggiornato.");
                continue;
            }
            def.addPortType(pt);
            if (!this.debug) continue;
            System.out.println("PortType aggiunto.");
        }
        m = def_sec.getServices();
        for (Service ser : m.values()) {
            Service mySer = def.getService(ser.getQName());
            if (mySer != null) {
                if (this.debug) {
                    System.out.println("Il Service esiste gia'. Ne aggiungo i port!");
                }
                Map ports = mySer.getPorts();
                Iterator iter = ports.values().iterator();
                while (iter.hasNext()) {
                    mySer.addPort((Port)iter.next());
                }
                def.removeService(ser.getQName());
                def.addService(mySer);
                if (!this.debug) continue;
                System.out.println("Service aggiornato.");
                continue;
            }
            def.addService(ser);
            if (!this.debug) continue;
            System.out.println("Service aggiunto.");
        }
        m = def_sec.getBindings();
        for (Binding bin : m.values()) {
            Binding myBin = def.getBinding(bin.getQName());
            if (myBin != null) {
                if (this.debug) {
                    System.out.println("Il Service esiste gia'. Ne aggiungo le operazioni!");
                }
                l = bin.getBindingOperations();
                j = l.size();
                for (int i = 0; i < j; ++i) {
                    myBin.addBindingOperation((BindingOperation)l.get(i));
                }
                def.removeBinding(bin.getQName());
                def.addBinding(myBin);
                if (!this.debug) continue;
                System.out.println("Binding aggiornato.");
                continue;
            }
            def.addBinding(bin);
            if (!this.debug) continue;
            System.out.println("Binding aggiunto.");
        }
    }

    private void aggiungiNodo(String path, String nodeName) throws ParserConfigurationException, IOException, SAXException, TransformerException, TransformerConfigurationException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(path));
            Element t = doc.createElement(nodeName);
            doc.getDocumentElement().insertBefore(t, doc.getDocumentElement().getFirstChild());
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(path)));
            xformer.transform(source, result);
            if (this.debug) {
                System.out.println("Il nodo " + nodeName + " e' stato aggiunto al file " + path);
            }
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
    }

    private void estendiTypes(String path, String schema) throws WSDLException, ParserConfigurationException, IOException, SAXException, TransformerConfigurationException, TransformerException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(path));
            NodeList nl = doc.getDocumentElement().getChildNodes();
            if (nl != null) {
                Node types = null;
                int j = nl.getLength();
                for (int i = 0; i < j; ++i) {
                    Node now = nl.item(i);
                    if (!now.getNodeName().equals("wsdl:types")) continue;
                    if (this.debug) {
                        System.out.println("Types trovato!");
                    }
                    types = now;
                    break;
                }
                if (this.wsdlSorgenteSoloErogatore) {
                    Document docSchema = docBuilder.parse(new File(schema));
                    Element schemaElement = docSchema.getDocumentElement();
                    types.appendChild(this.cloneNode(doc, schemaElement));
                    DOMSource source = new DOMSource(doc);
                    Transformer xformer = TransformerFactory.newInstance().newTransformer();
                    StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(path)));
                    xformer.transform(source, result);
                    if (this.debug) {
                        System.out.println("Schema aggiunto ai types!");
                    }
                    return;
                }
                Map m = new WSDLReaderImpl().readWSDL(path).getMessages();
                Iterator it = m.values().iterator();
                Vector<String> localTypes = new Vector<String>();
                while (it.hasNext()) {
                    Message mes = (Message)it.next();
                    Map par = mes.getParts();
                    for (Part p : par.values()) {
                        localTypes.add(p.getElementName().getLocalPart());
                    }
                }
                Document docSchema = docBuilder.parse(new File(schema));
                Element schemaElement = docSchema.getDocumentElement();
                nl = schemaElement.getChildNodes();
                if (nl != null) {
                    int j2 = nl.getLength();
                    for (int i = 0; i < j2; ++i) {
                        Node current = nl.item(i);
                        if (!current.hasAttributes() || !localTypes.contains(current.getAttributes().getNamedItem("name").getNodeValue())) continue;
                        if (this.debug) {
                            System.out.println("Cerco i tipi necessari a " + current.getAttributes().getNamedItem("name").getNodeValue());
                        }
                        localTypes.add(current.getAttributes().getNamedItem("name").getNodeValue());
                        String[] sonsElNames = this.getSonsElname(current, (short)1);
                        if (sonsElNames == null) continue;
                        int y = sonsElNames.length;
                        for (int x = 0; x < y; ++x) {
                            localTypes.add(sonsElNames[x]);
                        }
                    }
                }
                int j3 = schemaElement.getChildNodes().getLength();
                block12: for (int i = 0; i < j3; ++i) {
                    nl = schemaElement.getChildNodes();
                    int y = nl.getLength();
                    for (int x = 0; x < y; ++x) {
                        String name;
                        Node current = nl.item(x);
                        if (!current.hasAttributes() || localTypes.contains(name = current.getAttributes().getNamedItem("name").getNodeValue())) continue;
                        if (this.debug) {
                            System.out.println("Rimuovo " + name + " perche' non riguarda questo documento");
                        }
                        schemaElement.removeChild(current);
                        continue block12;
                    }
                }
                types.appendChild(this.cloneNode(doc, schemaElement));
                DOMSource source = new DOMSource(doc);
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(path)));
                xformer.transform(source, result);
                if (this.debug) {
                    System.out.println("Schema aggiunto ai types!");
                }
            }
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
    }

    private void printFile(String path) throws FileNotFoundException, IOException {
        try {
            String now;
            FileReader r = new FileReader(new File(path));
            BufferedReader reader = new BufferedReader(r);
            while ((now = reader.readLine()) != null) {
                if (!this.debug) continue;
                System.out.println(now);
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    private Node cloneNode(Document doc, Node toClone) {
        int i;
        if (toClone == null) {
            return null;
        }
        if (this.debug) {
            System.out.println("NodeName:" + toClone.getNodeName());
        }
        short type = toClone.getNodeType();
        switch (type) {
            case 2: {
                Attr at = doc.createAttribute(toClone.getNodeName());
                at.setValue(toClone.getNodeValue());
                return at;
            }
            case 8: {
                Comment c = doc.createComment(toClone.getNodeValue());
                return c;
            }
            case 3: {
                Text txt = doc.createTextNode(toClone.getNodeValue());
                return txt;
            }
        }
        Element el = doc.createElement(toClone.getNodeName());
        int j = toClone.getAttributes().getLength();
        for (i = 0; i < j; ++i) {
            if (toClone.getAttributes().item(i) == null) continue;
            el.setAttribute(toClone.getAttributes().item(i).getNodeName(), toClone.getAttributes().item(i).getNodeValue());
            if (!this.debug) continue;
            System.out.println(toClone.getAttributes().item(i).getNodeName() + "," + toClone.getAttributes().item(i).getNodeValue());
        }
        j = toClone.getChildNodes().getLength();
        for (i = 0; i < j; ++i) {
            el.appendChild(this.cloneNode(doc, toClone.getChildNodes().item(i)));
        }
        el.normalize();
        return el;
    }

    private String[] getSonsElname(Node n, short nodeType) {
        if (n == null || n.getChildNodes() == null) {
            return null;
        }
        String[] names = null;
        NodeList nl = n.getChildNodes();
        Vector<String> tmp = new Vector<String>();
        String zz = null;
        if (n.hasAttributes()) {
            Node curName = n.getAttributes().getNamedItem("name");
            if (curName != null) {
                if (this.debug) {
                    System.out.println("Analizzo il nodo(name):" + curName.getNodeValue());
                }
                zz = curName.getNodeValue();
            } else {
                curName = n.getAttributes().getNamedItem("ref");
                if (curName != null) {
                    if (this.debug) {
                        System.out.println("Analizzo il nodo(ref):" + curName.getNodeValue());
                    }
                    zz = curName.getNodeValue();
                } else {
                    curName = n.getAttributes().getNamedItem("type");
                    if (curName != null) {
                        if (this.debug) {
                            System.out.println("Analizzo il nodo(type):" + curName.getNodeValue());
                        }
                        zz = curName.getNodeValue();
                    }
                }
            }
        }
        int j = nl.getLength();
        for (int i = 0; i < j; ++i) {
            String[] chNames;
            Node ch = nl.item(i);
            System.out.println("NodeType:" + ch.getNodeType());
            if (ch.hasAttributes() && ch.getNodeType() == nodeType) {
                System.out.println("NodeType(Element):" + ch.getNodeType());
                Node curName = ch.getAttributes().getNamedItem("ref");
                curName = curName == null ? ch.getAttributes().getNamedItem("type") : curName;
                Node node = curName = curName == null ? ch.getAttributes().getNamedItem("name") : curName;
                if (curName != null) {
                    String elName = curName.getNodeValue();
                    if (this.debug) {
                        System.out.println("getSonsElname:" + elName);
                    }
                    if (!tmp.contains(elName)) {
                        tmp.add(elName);
                    }
                }
            }
            if (ch.getChildNodes() == null) continue;
            if (this.debug) {
                System.out.println("Scendo nei figli di " + zz);
            }
            if ((chNames = this.getSonsElname(ch, nodeType)) == null) continue;
            int y = chNames.length;
            for (int x = 0; x < y; ++x) {
                tmp.add(chNames[x]);
            }
        }
        if (tmp.size() == 0) {
            return null;
        }
        names = new String[tmp.size()];
        names = tmp.toArray(names);
        return names;
    }

    public void removeRootElementFromDocument(String file, String tagName) throws ParserConfigurationException, IOException, SAXException, TransformerException, TransformerConfigurationException {
        try {
            int i;
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(file));
            doc.getDocumentElement().normalize();
            NodeList nl = doc.getDocumentElement().getChildNodes();
            Vector<Node> toDel = new Vector<Node>();
            int j = nl.getLength();
            for (i = 0; i < j; ++i) {
                String temp = nl.item(i).getNodeName();
                if (!temp.equals(tagName)) continue;
                toDel.add(nl.item(i));
            }
            j = toDel.size();
            for (i = 0; i < j; ++i) {
                doc.getDocumentElement().removeChild((Node)toDel.get(i));
            }
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(file)));
            xformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw e;
        }
        catch (SAXException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (TransformerConfigurationException e) {
            throw e;
        }
        catch (TransformerException e) {
            throw e;
        }
    }

    public void createEmptyTag(String src, String dest) throws FileNotFoundException, IOException {
        try {
            String now;
            FileReader r = new FileReader(new File(src));
            FileOutputStream w = new FileOutputStream(new File(dest));
            BufferedReader reader = new BufferedReader(r);
            PrintWriter writer = new PrintWriter(w);
            writer.println("<empty-tag>");
            while ((now = reader.readLine()) != null) {
                if (!now.startsWith("<?xml")) {
                    writer.println(now);
                    continue;
                }
                now = now.substring(now.indexOf("?>") + 2);
                writer.println(now);
            }
            writer.println("</empty-tag>");
            writer.close();
            reader.close();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void cleanEmptyTag(String src) throws FileNotFoundException, IOException {
        try {
            String now;
            FileReader r = new FileReader(new File(src));
            File fi = new File(src + ".tmp");
            fi.createNewFile();
            String tmp = fi.getAbsolutePath();
            FileOutputStream w = new FileOutputStream(new File(tmp));
            BufferedReader reader = new BufferedReader(r);
            PrintWriter writer = new PrintWriter(w);
            while ((now = reader.readLine()) != null) {
                now = now.indexOf("<empty-tag>") == -1 ? now : now.replaceAll("<empty-tag>", "");
                now = now.indexOf("</empty-tag>") == -1 ? now : now.replaceAll("</empty-tag>", "");
                writer.println(now);
            }
            writer.close();
            reader.close();
            r.close();
            w.close();
            reader = new BufferedReader(new FileReader(tmp));
            writer = new PrintWriter(new FileOutputStream(new File(src)));
            while ((now = reader.readLine()) != null) {
                writer.println(now);
            }
            writer.close();
            reader.close();
            fi.delete();
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void creaDefinitorio(String wsdl, String path) throws IOException, WSDLException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        String wsdl_temp = wsdl + ".temp";
        this.createEmptyTag(wsdl, wsdl_temp);
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(wsdl_temp));
        doc.getDocumentElement().normalize();
        NodeList nl = doc.getDocumentElement().getChildNodes();
        Node defin = null;
        int j = nl.getLength();
        for (int i = 0; i < j; ++i) {
            String temp = nl.item(i).getNodeName();
            if (!temp.equals("wsdl:definitions")) continue;
            defin = nl.item(i);
            if (!this.debug) break;
            System.out.println("WSDL definition trovato.");
            break;
        }
        NamedNodeMap attrDefin = defin.getAttributes();
        Node attrXSD = null;
        for (int i = 0; i < attrDefin.getLength(); ++i) {
            Node a = attrDefin.item(i);
            if (!"xmlns:xsd".equals(a.getNodeName()) && !"xmlns:xs".equals(a.getNodeName())) continue;
            attrXSD = a.cloneNode(true);
            break;
        }
        nl = defin.getChildNodes();
        Node insert = null;
        int j2 = nl.getLength();
        for (int i = 0; i < j2; ++i) {
            String temp = nl.item(i).getNodeName();
            if (this.debug) {
                System.out.println(temp);
            }
            if (!temp.equals("wsdl:types")) continue;
            insert = nl.item(i);
            if (!this.debug) break;
            System.out.println("WSDL types trovato.");
            break;
        }
        Node forCopy = insert.cloneNode(true);
        NodeList lista = forCopy.getChildNodes();
        int idx = -1;
        int j3 = lista.getLength();
        for (int i = 0; i < j3; ++i) {
            Node schema = lista.item(i);
            if (!schema.getNodeName().equalsIgnoreCase("xs:schema") && !schema.getNodeName().equalsIgnoreCase("xsd:schema") && !schema.getNodeName().equalsIgnoreCase("schema")) continue;
            if (this.debug) {
                System.out.println("schema trovato");
            }
            idx = i;
            break;
        }
        forCopy = lista.item(idx).cloneNode(true);
        doc.getDocumentElement().removeChild(defin);
        if (attrXSD != null) {
            forCopy.getAttributes().setNamedItemNS(attrXSD);
        }
        doc.getDocumentElement().appendChild(forCopy);
        File f = new File(wsdl_temp);
        if (f.exists()) {
            f.delete();
        }
        DOMSource source = new DOMSource(doc);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        File file = new File(path);
        StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(file)));
        xformer.transform(source, result);
        this.cleanEmptyTag(path);
        if (this.debug) {
            System.out.println("Definitorio scritto a " + path);
        }
    }

    public void estendiDefinitorio(String xml, String wsdl) throws ParserConfigurationException, SAXException, IOException, WSDLException, TransformerConfigurationException, TransformerException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(new File(xml));
        this.creaDefinitorio(wsdl, wsdl + ".xsd.temp");
        Vector<Node> addingList = new Vector<Node>();
        Document doc2 = docBuilder.parse(new File(wsdl + ".xsd.temp"));
        doc2.getDocumentElement().normalize();
        NodeList nl = doc2.getDocumentElement().getChildNodes();
        int j = nl.getLength();
        for (int i = 0; i < j; ++i) {
            Node temp = nl.item(i).cloneNode(true);
            if (temp.getAttributes() == null) continue;
            boolean nodeAdd = true;
            NodeList parNodes = doc.getDocumentElement().getChildNodes();
            int k = parNodes.getLength();
            for (int h = 0; h < k; ++h) {
                String curName;
                String name;
                if (parNodes.item(h).getAttributes() == null || !(name = parNodes.item(h).getAttributes().getNamedItem("name").getNodeValue()).equals(curName = temp.getAttributes().getNamedItem("name").getNodeValue())) continue;
                if (this.debug) {
                    System.err.println("Nodo " + name + " non da aggiungere!");
                }
                nodeAdd = false;
                break;
            }
            if (!nodeAdd) continue;
            if (this.debug) {
                System.out.println("Nodo " + temp.getAttributes().getNamedItem("name").getNodeValue() + " da aggiungere!");
            }
            addingList.add(temp);
        }
        if (this.debug) {
            System.out.println(doc.getDocumentElement().getChildNodes().getLength());
        }
        int j2 = addingList.size();
        for (int i = 0; i < j2; ++i) {
            Node toCopy = (Node)addingList.elementAt(i);
            doc.getDocumentElement().appendChild(this.cloneNode(doc, toCopy));
        }
        if (this.debug) {
            System.out.println(doc.getDocumentElement().getChildNodes().getLength());
        }
        DOMSource source = new DOMSource(doc);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        File file = new File(xml);
        StreamResult result = new StreamResult(new PrintStream(new FileOutputStream(file)));
        xformer.transform(source, result);
        File f = new File(wsdl + ".xsd.temp");
        if (f.exists()) {
            f.delete();
        }
    }

    public void creaConcettuale(Definition def, String path, Import[] imports, Definition second, String[] portTypes) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        WSDLWriterImpl writer = new WSDLWriterImpl();
        this.wsdlUtility.removeAllBindings(def);
        this.wsdlUtility.removeAllServices(def);
        if (imports != null) {
            int j = imports.length;
            for (int i = 0; i < j; ++i) {
                def.addImport(imports[i]);
            }
        }
        if (second != null) {
            Map m = second.getNamespaces();
            for (String ns : m.values()) {
                if (!this.debug) continue;
                System.out.println(ns);
            }
            m = second.getMessages();
            for (Message im : m.values()) {
                def.addMessage(im);
            }
            m = second.getAllPortTypes();
            for (Message im : m.values()) {
                def.addPortType((PortType)im);
            }
        }
        if (portTypes != null) {
            Map m = def.getAllPortTypes();
            for (PortType now : m.values()) {
                String cuBinName = now.getQName().getLocalPart();
                boolean delete = true;
                for (int i = 0; i < portTypes.length; ++i) {
                    String check = portTypes[i];
                    if (!check.equals(cuBinName)) continue;
                    if (this.debug) {
                        System.out.println("PortType da non eliminare:" + check);
                    }
                    delete = false;
                    break;
                }
                if (!delete) continue;
                if (this.debug) {
                    System.out.println("PortType da eliminare:" + now.getQName());
                }
                def.removePortType(now.getQName());
            }
            Vector<Message> mess = new Vector<Message>();
            m = def.getAllPortTypes();
            for (PortType p : m.values()) {
                List myl = p.getOperations();
                int k = myl.size();
                for (int h = 0; h < k; ++h) {
                    Message output;
                    Message input;
                    Operation operationWSDL = (Operation)myl.get(h);
                    Message message = input = operationWSDL.getInput() == null ? null : operationWSDL.getInput().getMessage();
                    if (input != null) {
                        mess.add(input);
                    }
                    Message message2 = output = operationWSDL.getOutput() == null ? null : operationWSDL.getOutput().getMessage();
                    if (output == null) continue;
                    mess.add(output);
                }
            }
            m = def.getMessages();
            Iterator it = m.values().iterator();
            Vector<Message> removeM = new Vector<Message>();
            while (it.hasNext()) {
                Message temp = (Message)it.next();
                if (mess.contains(temp)) continue;
                if (this.debug) {
                    System.out.println("Rimuovo messaggio: " + temp.getQName().getLocalPart());
                }
                removeM.add(temp);
            }
            int j = removeM.size();
            for (int i = 0; i < j; ++i) {
                def.removeMessage(((Message)removeM.get(i)).getQName());
            }
        }
        writer.writeWSDL(def, (Writer)new FileWriter(path));
        this.removeRootElementFromDocument(path, "wsdl:types");
    }

    public void estendiConcettuale(Definition src, Definition dest, String path) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        Map m = src.getImports();
        Iterator it = m.values().iterator();
        while (it.hasNext()) {
            dest.addImport((Import)it.next());
        }
        m = src.getMessages();
        it = m.values().iterator();
        while (it.hasNext()) {
            dest.addMessage((Message)it.next());
        }
        m = src.getAllPortTypes();
        it = m.values().iterator();
        while (it.hasNext()) {
            src.addPortType((PortType)it.next());
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        try {
            writer.writeWSDL(dest, (Writer)new FileWriter(path));
        }
        catch (WSDLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.removeRootElementFromDocument(path, "wsdl:types");
        if (this.debug) {
            System.out.println("Concettuale estreso " + path);
        }
    }

    public void creaLogico(Definition def, String path, Import[] imports, String[] portTypes, String[] operations, Definition second) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        WSDLWriterImpl writer = new WSDLWriterImpl();
        Map m = null;
        Iterator it = null;
        this.wsdlUtility.removeAllBindings(def);
        this.wsdlUtility.removeAllServices(def);
        if (imports != null) {
            int j = imports.length;
            for (int i = 0; i < j; ++i) {
                def.addImport(imports[i]);
            }
        }
        m = def.getPortTypes();
        it = m.values().iterator();
        String prefix = null;
        String namespace = null;
        if (it.hasNext()) {
            PortType p = (PortType)it.next();
            prefix = p.getQName().getPrefix();
            namespace = p.getQName().getNamespaceURI();
        }
        if (prefix == null && namespace == null) {
            if (this.debug) {
                System.err.println("Prefisso o namespace assenti!");
            }
            throw new WSDLException(namespace, prefix);
        }
        if (portTypes == null) {
            writer.writeWSDL(def, (Writer)new FileWriter(path));
            this.removeRootElementFromDocument(path, "wsdl:types");
            if (this.debug) {
                System.out.println("Logico scritto a " + path);
            }
            return;
        }
        Vector<PortType> pts = new Vector<PortType>();
        int j = portTypes.length;
        for (int i = 0; i < j; ++i) {
            String[] myops;
            QName current = new QName(namespace, portTypes[i], prefix);
            PortType now = def.getPortType(current);
            String[] stringArray = myops = operations[i] == null ? null : operations[i].split(",");
            if (myops == null) {
                if (this.debug) {
                    System.out.println(path + "\nPortType " + portTypes[i] + ":Null per l'indice " + i);
                }
                return;
            }
            List opts = now.getOperations();
            Operation[] opp = new Operation[opts.size()];
            opts.toArray(opp);
            if (this.debug) {
                System.out.println("Operazioni nel portType:" + portTypes[i] + ":" + opts.size());
            }
            int y = opts.size();
            for (int x = 0; x < y; ++x) {
                String cur = opp[x].getName();
                boolean delete = true;
                if (this.debug) {
                    System.out.println("Path" + path + " Operazione corrente:" + cur);
                }
                int k = myops.length;
                for (int h = 0; h < k; ++h) {
                    if (!cur.equals(myops[h])) continue;
                    delete = false;
                    break;
                }
                if (!delete) continue;
                now.removeOperation(opp[x].getName(), null, null);
            }
            pts.add(now);
        }
        m = def.getAllPortTypes();
        it = m.values().iterator();
        while (it.hasNext()) {
            it.next();
            it.remove();
        }
        Vector<Message> mess = new Vector<Message>();
        int j2 = pts.size();
        for (int i = 0; i < j2; ++i) {
            PortType p = (PortType)pts.get(i);
            List myl = p.getOperations();
            int k = myl.size();
            for (int h = 0; h < k; ++h) {
                Message output;
                Message input;
                Operation operationWSDL = (Operation)myl.get(h);
                Message message = input = operationWSDL.getInput() == null ? null : operationWSDL.getInput().getMessage();
                if (input != null) {
                    mess.add(input);
                }
                Message message2 = output = operationWSDL.getOutput() == null ? null : operationWSDL.getOutput().getMessage();
                if (output == null) continue;
                mess.add(output);
            }
            def.addPortType(p);
        }
        m = def.getMessages();
        it = m.values().iterator();
        Vector<Message> removeM = new Vector<Message>();
        while (it.hasNext()) {
            Message temp = (Message)it.next();
            if (mess.contains(temp)) continue;
            removeM.add(temp);
        }
        int j3 = removeM.size();
        for (int i = 0; i < j3; ++i) {
            def.removeMessage(((Message)removeM.get(i)).getQName());
        }
        m = def.getAllPortTypes();
        for (PortType now : m.values()) {
            String cuBinName = now.getQName().getLocalPart();
            boolean delete = true;
            for (int i = 0; i < portTypes.length; ++i) {
                String check = portTypes[i];
                if (!check.equals(cuBinName)) continue;
                if (this.debug) {
                    System.out.println("PortType da non eliminare:" + check);
                }
                delete = false;
                break;
            }
            if (!delete) continue;
            if (this.debug) {
                System.out.println("PortType da eliminare:" + now.getQName());
            }
            def.removePortType(now.getQName());
        }
        writer.writeWSDL(def, (Writer)new FileWriter(path));
        this.removeRootElementFromDocument(path, "wsdl:types");
        if (this.debug) {
            System.out.println("Logico scritto a " + path);
        }
    }

    public void creaImplementativo(Definition def, String path, Import[] imports, String[] portTypes, String[] operations, Definition second) throws IOException, WSDLException, ParserConfigurationException, SAXException, IOException, TransformerException, TransformerConfigurationException {
        int i;
        WSDLWriterImpl writer = new WSDLWriterImpl();
        this.wsdlUtility.removeAllMessages(def);
        this.wsdlUtility.removeAllPortTypes(def);
        if (portTypes == null) {
            if (imports != null) {
                int j = imports.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    def.addImport(imports[i2]);
                }
            }
            writer.writeWSDL(def, (Writer)new FileWriter(path));
            this.removeRootElementFromDocument(path, "wsdl:types");
            if (this.debug) {
                System.out.println("Implementativo scritto a " + path);
            }
            return;
        }
        Map m = def.getBindings();
        Iterator it = m.values().iterator();
        Vector<Binding> bnd = new Vector<Binding>();
        while (it.hasNext()) {
            Binding now = def.getBinding(((Binding)it.next()).getQName());
            String refPTName = now.getPortType().getQName().getLocalPart();
            boolean found = false;
            int j = portTypes.length;
            for (i = 0; i < j; ++i) {
                if (!refPTName.equals(portTypes[i])) continue;
                found = true;
                break;
            }
            if (found) {
                List ops = now.getBindingOperations();
                String[] myops = operations[i].split(",");
                Vector<String> toDel = new Vector<String>();
                int k = ops.size();
                for (int h = 0; h < k; ++h) {
                    String curName = ((BindingOperation)ops.get(h)).getName();
                    boolean rem = true;
                    int n = myops.length;
                    for (int mm = 0; mm < n; ++mm) {
                        if (!myops[mm].equals(curName)) continue;
                        rem = false;
                        break;
                    }
                    if (!rem) continue;
                    toDel.add(curName);
                }
                int y = toDel.size();
                for (int x = 0; x < y; ++x) {
                    now.removeBindingOperation((String)toDel.get(x), null, null);
                }
            }
            bnd.add(now);
        }
        m = def.getAllBindings();
        for (Binding now : m.values()) {
            String cuBinName = now.getPortType().getQName().getLocalPart();
            boolean delete = true;
            for (i = 0; i < portTypes.length; ++i) {
                String check = portTypes[i];
                if (!check.equals(cuBinName)) continue;
                if (this.debug) {
                    System.out.println("Binding da non eliminare:" + check);
                }
                delete = false;
                break;
            }
            if (!delete) continue;
            if (this.debug) {
                System.out.println("Binding da eliminare:" + now.getQName());
            }
            def.removeBinding(now.getQName());
        }
        m = def.getAllServices();
        for (Binding now : m.values()) {
            Map pts = now.getPorts();
            Iterator ports = pts.values().iterator();
            boolean delete = true;
            block9: while (ports.hasNext()) {
                Port cuPor = (Port)ports.next();
                String cuBinName = cuPor.getBinding().getPortType().getQName().getLocalPart();
                for (int i3 = 0; i3 < portTypes.length; ++i3) {
                    String check = portTypes[i3];
                    if (!check.equals(cuBinName)) continue;
                    if (this.debug) {
                        System.out.println("Servizio da non eliminare:" + check);
                    }
                    delete = false;
                    continue block9;
                }
            }
            if (!delete) continue;
            if (this.debug) {
                System.out.println("Servizio da eliminare:" + now.getQName());
            }
            def.removeService(now.getQName());
        }
        if (imports != null) {
            int j = imports.length;
            for (int i4 = 0; i4 < j; ++i4) {
                def.addImport(imports[i4]);
            }
        }
        writer.writeWSDL(def, (Writer)new FileWriter(path));
        this.removeRootElementFromDocument(path, "wsdl:types");
        if (this.debug) {
            System.out.println("Implementativo scritto a " + path);
        }
    }

    public Document getSchema(Definition definition) {
        if (definition == null) {
            return null;
        }
        WSDLWriterImpl writer = new WSDLWriterImpl();
        try {
            File f = new File("wsdlSchema.tmp.wsdl");
            f.createNewFile();
            writer.writeWSDL(definition, (Writer)new FileWriter("wsdlSchema.tmp.wsdl"));
            File ff = new File("wsdlSchema2.tmp.wsdl");
            ff.createNewFile();
            this.createEmptyTag(f.getCanonicalPath(), ff.getAbsolutePath());
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(ff.getAbsolutePath()));
            doc.getDocumentElement().normalize();
            NodeList nl = doc.getDocumentElement().getChildNodes();
            Node defin = null;
            int j = nl.getLength();
            for (int i = 0; i < j; ++i) {
                String temp = nl.item(i).getNodeName();
                if (!temp.equals("wsdl:definitions")) continue;
                defin = nl.item(i);
                if (!this.debug) break;
                System.out.println("WSDL definition trovato.");
                break;
            }
            nl = defin.getChildNodes();
            Node insert = null;
            int j2 = nl.getLength();
            for (int i = 0; i < j2; ++i) {
                String temp = nl.item(i).getNodeName();
                if (this.debug) {
                    System.out.println(temp);
                }
                if (!temp.equals("wsdl:types")) continue;
                insert = nl.item(i);
                if (!this.debug) break;
                System.out.println("WSDL types trovato.");
                break;
            }
            Node forCopy = insert.cloneNode(true);
            NodeList lista = forCopy.getChildNodes();
            int idx = -1;
            int j3 = lista.getLength();
            for (int i = 0; i < j3; ++i) {
                Node schema = lista.item(i);
                if (!schema.getNodeName().equals("xs:schema") && !schema.getNodeName().equals("xsd:schema")) continue;
                if (this.debug) {
                    System.out.println("schema trovato");
                }
                idx = i;
                break;
            }
            forCopy = lista.item(idx).cloneNode(true);
            doc.getDocumentElement().removeChild(defin);
            doc.getDocumentElement().appendChild(forCopy);
            return doc;
        }
        catch (WSDLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }
}

