/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import it.cnipa.collprofiles.EgovDecllElement;
import it.cnipa.collprofiles.OperationListType;
import it.cnipa.collprofiles.OperationType;
import it.cnipa.collprofiles.driver.TipiProfiliCollaborazione;
import it.gov.spcoop.sica.dao.AccordoServizioComposto;
import it.gov.spcoop.sica.dao.AccordoServizioParteSpecifica;
import it.gov.spcoop.sica.firma.Firma;
import it.gov.spcoop.sica.manifest.AccordoServizioParteComune;
import it.gov.spcoop.sica.manifest.DocumentoConversazione;
import it.gov.spcoop.sica.manifest.DocumentoCoordinamento;
import it.gov.spcoop.sica.manifest.DocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.DocumentoLivelloServizio;
import it.gov.spcoop.sica.manifest.DocumentoSemiformale;
import it.gov.spcoop.sica.manifest.DocumentoSicurezza;
import it.gov.spcoop.sica.manifest.ElencoAllegati;
import it.gov.spcoop.sica.manifest.ElencoPartecipanti;
import it.gov.spcoop.sica.manifest.ElencoServiziComponenti;
import it.gov.spcoop.sica.manifest.ElencoServiziComposti;
import it.gov.spcoop.sica.manifest.ServizioComposto;
import it.gov.spcoop.sica.manifest.SpecificaConversazione;
import it.gov.spcoop.sica.manifest.SpecificaCoordinamento;
import it.gov.spcoop.sica.manifest.SpecificaInterfaccia;
import it.gov.spcoop.sica.manifest.SpecificaLivelliServizio;
import it.gov.spcoop.sica.manifest.SpecificaPortiAccesso;
import it.gov.spcoop.sica.manifest.SpecificaSemiformale;
import it.gov.spcoop.sica.manifest.SpecificaSicurezza;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoConversazione;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoInterfaccia;
import it.gov.spcoop.sica.manifest.driver.TipiDocumentoSemiformale;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoCooperazioneElencoPartecipantiSoggetto;
import org.openspcoop.dao.registry.AccordoCooperazioneSoggettoReferente;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.AccordoServizioServizioComposto;
import org.openspcoop.dao.registry.AccordoServizioServizioCompostoServizioComponente;
import org.openspcoop.dao.registry.AccordoServizioSoggettoReferente;
import org.openspcoop.dao.registry.Connettore;
import org.openspcoop.dao.registry.ConnettoreProperty;
import org.openspcoop.dao.registry.Documento;
import org.openspcoop.dao.registry.Operation;
import org.openspcoop.dao.registry.PortType;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.RuoliDocumento;
import org.openspcoop.dao.registry.driver.SICAToOpenSPCoopUtilitiesException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SICAtoOpenSPCoopUtilities {
    public static String buildIDSoggettoSica(String soggetto, boolean createURI) throws SICAToOpenSPCoopUtilitiesException {
        if (soggetto == null || "".equals(soggetto)) {
            throw new SICAToOpenSPCoopUtilitiesException("Identificativo soggetto non fornito");
        }
        StringBuffer bf = new StringBuffer();
        if (createURI) {
            bf.append("uri:dn:");
        }
        bf.append("o=");
        bf.append(soggetto);
        bf.append(",c=it");
        return bf.toString();
    }

    public static String idSoggetto_openspcoopToSica(IDSoggetto idSoggetto) throws SICAToOpenSPCoopUtilitiesException {
        if (idSoggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto non definito");
        }
        if (idSoggetto.getTipo() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto.tipo non definito");
        }
        if (idSoggetto.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDSoggetto.nome non definito");
        }
        if (!"SPC".equals(idSoggetto.getTipo())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo soggetto diverso da SPC non utilizzabile");
        }
        return SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idSoggetto.getNome(), true);
    }

    public static IDSoggetto idSoggetto_sicaToOpenspcoop(String uriSoggetto) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(uriSoggetto, true);
    }

    public static IDSoggetto idSoggetto_sicaToOpenspcoop(String uriSoggetto, boolean uri) throws SICAToOpenSPCoopUtilitiesException {
        if (uriSoggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriSoggetto non definito");
        }
        String senzaSpazi = uriSoggetto.replaceAll("", "");
        if (!senzaSpazi.startsWith("uri:dn:") && uri) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
        }
        if (senzaSpazi.indexOf(",c=it") <= 0 && senzaSpazi.indexOf(" c=it") <= 0) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
        }
        if (uri) {
            if (senzaSpazi.indexOf(",o=") <= 0 && senzaSpazi.indexOf(":o=") <= 0 && senzaSpazi.indexOf(" o=") <= 0) {
                throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (uri:dn:o=<identificativo soggetto>,c=it)");
            }
        } else if (senzaSpazi.indexOf(",o=") <= 0 && senzaSpazi.indexOf("o=") < 0) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriSoggetto (" + uriSoggetto + ") non corretto (o=<identificativo soggetto>,c=it)");
        }
        int index = -1;
        int lenghtPrefixO = 3;
        if (uri) {
            index = senzaSpazi.indexOf(",o=");
            if (index <= 0) {
                index = senzaSpazi.indexOf(":o=");
            }
            if (index <= 0) {
                index = senzaSpazi.indexOf(" o=");
            }
        } else {
            index = senzaSpazi.indexOf(",o=");
            if (index <= 0) {
                index = senzaSpazi.indexOf("o=");
                lenghtPrefixO = 2;
            }
        }
        int endSoggetto = senzaSpazi.length();
        if (senzaSpazi.indexOf(",", index + 1) > 0) {
            endSoggetto = senzaSpazi.indexOf(",", index + 1);
        }
        IDSoggetto idSoggetto = new IDSoggetto("SPC", senzaSpazi.substring(index + lenghtPrefixO, endSoggetto));
        return idSoggetto;
    }

    public static String buildIDAccordoCooperazioneSica(String nome_accordo, String versione) throws SICAToOpenSPCoopUtilitiesException {
        if (nome_accordo == null || "".equals(nome_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome accordo non fornito");
        }
        if (versione == null || "".equals(versione)) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("urn:");
        bf.append("adc");
        bf.append(":");
        bf.append(nome_accordo);
        bf.append(":");
        bf.append(versione);
        return bf.toString();
    }

    public static String idAccordoCooperazione_openspcoopToSica(IDAccordoCooperazione idAccordo) throws SICAToOpenSPCoopUtilitiesException {
        if (idAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.nome non definito");
        }
        if (idAccordo.getVersione() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.versione non definito");
        }
        return SICAtoOpenSPCoopUtilities.buildIDAccordoCooperazioneSica(idAccordo.getNome(), idAccordo.getVersione());
    }

    public static IDAccordoCooperazione idAccordoCooperazione_sicaToOpenspcoop(String uriAccordo) throws SICAToOpenSPCoopUtilitiesException {
        if (uriAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordo.split(":");
        if (values.length != 4) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:adc:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:adc:<nome_accordo>:<versione>)");
        }
        String tipoAccordo = values[1];
        if (!"adc".equals(tipoAccordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo presente nell'uriAccordo (" + tipoAccordo + ") non corrisponde quello atteso (adc)");
        }
        String nome = values[2];
        if (nome == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        String versione = values[3];
        if (versione == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromValues(nome, versione);
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo (" + uriAccordo + ") non riuscita: " + e.getMessage(), e);
        }
        return idAccordo;
    }

    public static String buildIDAccordoSica(String tipo_accordo, String soggetto, String nome_accordo, String versione) throws SICAToOpenSPCoopUtilitiesException {
        if (tipo_accordo == null || "".equals(tipo_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo accordo non fornito");
        }
        if (soggetto == null || "".equals(soggetto)) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto organizzativo non fornito");
        }
        if (nome_accordo == null || "".equals(nome_accordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome accordo non fornito");
        }
        if (versione == null || "".equals(versione)) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non fornita");
        }
        StringBuffer bf = new StringBuffer();
        bf.append("urn:");
        bf.append(tipo_accordo);
        bf.append(":");
        bf.append(soggetto);
        bf.append(":");
        bf.append(nome_accordo);
        bf.append(":");
        bf.append(versione);
        return bf.toString();
    }

    public static String idAccordoServizioParteComune_openspcoopToSica(IDAccordo idAccordo) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_openspcoopToSica(idAccordo, "adsc");
    }

    public static IDAccordo idAccordoServizioParteComune_sicaToOpenspcoop(String uriAccordo) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_sicaToOpenspcoop(uriAccordo, "adsc");
    }

    public static String idAccordoServizioComposto_openspcoopToSica(IDAccordo idAccordo) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_openspcoopToSica(idAccordo, "sc");
    }

    public static IDAccordo idAccordoServizioComposto_sicaToOpenspcoop(String uriAccordo) throws SICAToOpenSPCoopUtilitiesException {
        return SICAtoOpenSPCoopUtilities.idAccordo_sicaToOpenspcoop(uriAccordo, "sc");
    }

    public static String idAccordoServizioParteSpecifica_openspcoopToSica(IDServizio idAccordoParteSpecifica) throws SICAToOpenSPCoopUtilitiesException {
        if (idAccordoParteSpecifica == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo non definito");
        }
        if (idAccordoParteSpecifica.getTipoServizio() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.servizio.tipo non definito");
        }
        if (!"SPC".equals(idAccordoParteSpecifica.getTipoServizio())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo servizio diverso da SPC non utilizzabile");
        }
        if (idAccordoParteSpecifica.getServizio() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.servizio.nome non definito");
        }
        if (idAccordoParteSpecifica.getSoggettoErogatore() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoErogatore non definito");
        }
        if (idAccordoParteSpecifica.getSoggettoErogatore().getTipo() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoErogatore.tipo non definito");
        }
        if (!"SPC".equals(idAccordoParteSpecifica.getSoggettoErogatore().getTipo())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo soggetto erogatore diverso da SPC non utilizzabile");
        }
        if (idAccordoParteSpecifica.getSoggettoErogatore().getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoErogatore.nome non definito");
        }
        return SICAtoOpenSPCoopUtilities.buildIDAccordoSica("ads", SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idAccordoParteSpecifica.getSoggettoErogatore().getNome(), false), idAccordoParteSpecifica.getServizio(), "1");
    }

    public static IDServizio idAccordoServizioParteSpecifica_sicaToOpenspcoop(String uriAccordoParteSpecifica) throws SICAToOpenSPCoopUtilitiesException {
        if (uriAccordoParteSpecifica == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordoParteSpecifica.split(":");
        if (values.length != 5) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordoParteSpecifica + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordoParteSpecifica + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String tipoAccordo = values[1];
        if (!"ads".equals(tipoAccordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo presente nell'uriAccordo (" + tipoAccordo + ") non corrisponde quello atteso (" + "ads" + ")");
        }
        String soggetto = values[2];
        if (soggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto non presente nell'uriAccordo (" + uriAccordoParteSpecifica + ")");
        }
        IDSoggetto idSoggetto = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(soggetto, false);
        String nome = values[3];
        if (nome == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome non presente nell'uriAccordo (" + uriAccordoParteSpecifica + ")");
        }
        String versione = values[4];
        if (versione == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non presente nell'uriAccordo (" + uriAccordoParteSpecifica + ")");
        }
        IDServizio idServizio = new IDServizio(idSoggetto, "SPC", nome);
        return idServizio;
    }

    private static String idAccordo_openspcoopToSica(IDAccordo idAccordo, String tipo) throws SICAToOpenSPCoopUtilitiesException {
        if (idAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo non definito");
        }
        if (idAccordo.getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.nome non definito");
        }
        if (idAccordo.getVersione() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.versione non definito");
        }
        if (idAccordo.getSoggettoReferente() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente non definito");
        }
        if (idAccordo.getSoggettoReferente().getTipo() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente.tipo non definito");
        }
        if (idAccordo.getSoggettoReferente().getNome() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("IDAccordo.soggettoReferente.nome non definito");
        }
        if (!"SPC".equals(idAccordo.getSoggettoReferente().getTipo())) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo soggetto referente diverso da SPC non utilizzabile");
        }
        return SICAtoOpenSPCoopUtilities.buildIDAccordoSica(tipo, SICAtoOpenSPCoopUtilities.buildIDSoggettoSica(idAccordo.getSoggettoReferente().getNome(), false), idAccordo.getNome(), idAccordo.getVersione());
    }

    public static IDAccordo idAccordo_sicaToOpenspcoop(String uriAccordo, String tipoAtteso) throws SICAToOpenSPCoopUtilitiesException {
        if (uriAccordo == null) {
            throw new SICAToOpenSPCoopUtilitiesException("uriAccordo non definito");
        }
        String[] values = uriAccordo.split(":");
        if (values.length != 5) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String urn = values[0];
        if (!"urn".equals(urn)) {
            throw new SICAToOpenSPCoopUtilitiesException("Formato uriAccordo (" + uriAccordo + ") non valido (urn:<tipo_accordo>:<soggetto_organizzativo>:<nome_accordo>:<versione>)");
        }
        String tipoAccordo = values[1];
        if (!tipoAtteso.equals(tipoAccordo)) {
            throw new SICAToOpenSPCoopUtilitiesException("Tipo presente nell'uriAccordo (" + tipoAccordo + ") non corrisponde quello atteso (" + tipoAtteso + ")");
        }
        String soggetto = values[2];
        if (soggetto == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDSoggetto idSoggetto = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(soggetto, false);
        String nome = values[3];
        if (nome == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Nome non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        String versione = values[4];
        if (versione == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Versione non presente nell'uriAccordo (" + uriAccordo + ")");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromValues(nome, idSoggetto, versione);
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo (" + uriAccordo + ") non riuscita: " + e.getMessage(), e);
        }
        return idAccordo;
    }

    public static String readConnettoreFromWsdlImplementativo(byte[] wsdlImplementativo) throws SICAToOpenSPCoopUtilitiesException {
        try {
            ByteArrayInputStream binLogico = new ByteArrayInputStream(wsdlImplementativo);
            Document documentLogico = XMLUtils.newDocument((InputStream)binLogico);
            binLogico.close();
            NodeList list = documentLogico.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listPort;
                        Node childDefinition = listDefinition.item(j);
                        if (!"service".equals(childDefinition.getLocalName()) || (listPort = childDefinition.getChildNodes()) == null) continue;
                        for (int z = 0; z < listPort.getLength(); ++z) {
                            NodeList addressList;
                            Node port = listPort.item(z);
                            if (!"port".equals(port.getLocalName()) || (addressList = port.getChildNodes()) == null) continue;
                            for (int m = 0; m < addressList.getLength(); ++m) {
                                Node address = addressList.item(m);
                                if (!"address".equals(address.getLocalName())) continue;
                                return address.getAttributes().getNamedItem("location").getNodeValue();
                            }
                        }
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("readWsdlImplementativo error: " + e.getMessage(), e);
        }
    }

    public static byte[] saveConnettoreIntoWsdlImplementativo(byte[] wsdlImplementativo, String url) throws SICAToOpenSPCoopUtilitiesException {
        try {
            ByteArrayInputStream binLogico = new ByteArrayInputStream(wsdlImplementativo);
            Document documentLogico = XMLUtils.newDocument((InputStream)binLogico);
            binLogico.close();
            NodeList list = documentLogico.getChildNodes();
            if (list != null) {
                for (int i = 0; i < list.getLength(); ++i) {
                    NodeList listDefinition;
                    Node child = list.item(i);
                    if (!"definitions".equals(child.getLocalName()) || (listDefinition = child.getChildNodes()) == null) continue;
                    for (int j = 0; j < listDefinition.getLength(); ++j) {
                        NodeList listPort;
                        Node childDefinition = listDefinition.item(j);
                        if (!"service".equals(childDefinition.getLocalName()) || (listPort = childDefinition.getChildNodes()) == null) continue;
                        for (int z = 0; z < listPort.getLength(); ++z) {
                            NodeList addressList;
                            Node port = listPort.item(z);
                            if (!"port".equals(port.getLocalName()) || (addressList = port.getChildNodes()) == null) continue;
                            for (int m = 0; m < addressList.getLength(); ++m) {
                                Node address = addressList.item(m);
                                if (!"address".equals(address.getLocalName())) continue;
                                address.getAttributes().getNamedItem("location").setNodeValue(url);
                            }
                        }
                    }
                }
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            XMLUtils.DocumentToStream((Document)documentLogico, (OutputStream)bout);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("readWsdlImplementativo error: " + e.getMessage(), e);
        }
    }

    public static AccordoCooperazione accordoCooperazione_sicaToOpenspcoop(it.gov.spcoop.sica.dao.AccordoCooperazione accordoCooperazioneSICA) throws SICAToOpenSPCoopUtilitiesException {
        ElencoServiziComposti serviziComposti;
        int j;
        it.gov.spcoop.sica.dao.Documento docSICA;
        String fileName;
        Documento docOpenspcoop;
        int i;
        AccordoCooperazione accCooperazioneOpenspcoop = new AccordoCooperazione();
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = accordoCooperazioneSICA.getManifesto();
        accCooperazioneOpenspcoop.setDescrizione(manifest.getDescrizione());
        accCooperazioneOpenspcoop.setNome(manifest.getNome());
        accCooperazioneOpenspcoop.setVersione(manifest.getVersione());
        accCooperazioneOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accCooperazioneOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        AccordoCooperazioneSoggettoReferente soggettoReferente = new AccordoCooperazioneSoggettoReferente();
        IDSoggetto soggettoCoordinatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(manifest.getCoordinatore());
        soggettoReferente.setNome(soggettoCoordinatore.getNome());
        soggettoReferente.setTipo(soggettoCoordinatore.getTipo());
        accCooperazioneOpenspcoop.setSoggettoReferente(soggettoReferente);
        for (i = 0; i < manifest.sizeAllegatiList(); ++i) {
            ElencoAllegati allegati = manifest.getAllegati(i);
            docOpenspcoop = new Documento();
            fileName = allegati.getGenericoDocumento();
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
            docSICA = null;
            for (j = 0; j < accordoCooperazioneSICA.sizeAllegati(); ++j) {
                if (!fileName.equals(accordoCooperazioneSICA.getAllegato(j).getNome())) continue;
                docSICA = accordoCooperazioneSICA.getAllegato(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
            }
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accCooperazioneOpenspcoop.addAllegato(docOpenspcoop);
        }
        for (i = 0; i < manifest.sizeSpecificaSemiformaleList(); ++i) {
            SpecificaSemiformale specificaSemiformale = manifest.getSpecificaSemiformale(i);
            docOpenspcoop = new Documento();
            fileName = specificaSemiformale.getDocumentoSemiformale().getBase();
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
            docSICA = null;
            for (j = 0; j < accordoCooperazioneSICA.sizeSpecificheSemiformali(); ++j) {
                if (!fileName.equals(accordoCooperazioneSICA.getSpecificaSemiformale(j).getNome())) continue;
                docSICA = accordoCooperazioneSICA.getSpecificaSemiformale(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
            }
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accCooperazioneOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
        }
        ElencoPartecipanti elencoPartecipantiSICA = manifest.getElencoPartecipanti();
        if (elencoPartecipantiSICA != null) {
            for (int i2 = 0; i2 < elencoPartecipantiSICA.sizePartecipanteList(); ++i2) {
                String partecipante = elencoPartecipantiSICA.getPartecipante(i2);
                AccordoCooperazioneElencoPartecipantiSoggetto soggetto = new AccordoCooperazioneElencoPartecipantiSoggetto();
                IDSoggetto soggettoPartecipante = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(partecipante);
                soggetto.setNome(soggettoPartecipante.getNome());
                soggetto.setTipo(soggettoPartecipante.getTipo());
                accCooperazioneOpenspcoop.addElencoPartecipanti(soggetto);
            }
        }
        if ((serviziComposti = manifest.getServiziComposti()) != null) {
            for (int i3 = 0; i3 < serviziComposti.sizeServizioCompostoList(); ++i3) {
                String servizioCompostio = serviziComposti.getServizioComposto(i3);
                IDAccordo idAccordo = SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_sicaToOpenspcoop(servizioCompostio);
                try {
                    accCooperazioneOpenspcoop.addUriServiziComposti(IDAccordo.getUriFromIDAccordo(idAccordo));
                    continue;
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("uri IDAccordo servizio composto [" + servizioCompostio + "] non costruibile: " + e.getMessage(), e);
                }
            }
        }
        if (manifest.getFirmato()) {
            accCooperazioneOpenspcoop.setByteFirma(accordoCooperazioneSICA.getFirma().getBytes());
        }
        return accCooperazioneOpenspcoop;
    }

    public static it.gov.spcoop.sica.dao.AccordoCooperazione accordoCooperazione_openspcoopToSica(AccordoCooperazione accordoCooperazioneOpenspcoop) throws SICAToOpenSPCoopUtilitiesException {
        Documento docOpenspcoop;
        int i;
        it.gov.spcoop.sica.dao.AccordoCooperazione accCooperazioneSICA = new it.gov.spcoop.sica.dao.AccordoCooperazione();
        it.gov.spcoop.sica.manifest.AccordoCooperazione manifest = new it.gov.spcoop.sica.manifest.AccordoCooperazione();
        manifest.setDescrizione(accordoCooperazioneOpenspcoop.getDescrizione());
        manifest.setNome(accordoCooperazioneOpenspcoop.getNome());
        manifest.setVersione(accordoCooperazioneOpenspcoop.getVersione());
        manifest.setDataCreazione(accordoCooperazioneOpenspcoop.getOraRegistrazione());
        manifest.setDataPubblicazione(accordoCooperazioneOpenspcoop.getDataPubblicazione());
        if (accordoCooperazioneOpenspcoop.getByteFirma() != null) {
            manifest.setFirmato(true);
        }
        if (accordoCooperazioneOpenspcoop.getSoggettoReferente() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
        }
        IDSoggetto soggettoCoordinatore = new IDSoggetto(accordoCooperazioneOpenspcoop.getSoggettoReferente().getTipo(), accordoCooperazioneOpenspcoop.getSoggettoReferente().getNome());
        String uriCoordinatore = SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoCoordinatore);
        manifest.setCoordinatore(uriCoordinatore);
        for (i = 0; i < accordoCooperazioneOpenspcoop.sizeAllegatoList(); ++i) {
            docOpenspcoop = accordoCooperazioneOpenspcoop.getAllegato(i);
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento(docOpenspcoop.getFile());
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accCooperazioneSICA.addAllegato(docSICA);
        }
        for (i = 0; i < accordoCooperazioneOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
            docOpenspcoop = accordoCooperazioneOpenspcoop.getSpecificaSemiformale(i);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(docOpenspcoop.getTipo());
            docSemiformale.setBase(docOpenspcoop.getFile());
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accCooperazioneSICA.addSpecificaSemiformale(docSICA);
        }
        ElencoPartecipanti partecipanti = null;
        for (int i2 = 0; i2 < accordoCooperazioneOpenspcoop.sizeElencoPartecipantiList(); ++i2) {
            AccordoCooperazioneElencoPartecipantiSoggetto soggetto = accordoCooperazioneOpenspcoop.getElencoPartecipanti(i2);
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (partecipanti == null) {
                partecipanti = new ElencoPartecipanti();
            }
            partecipanti.addPartecipante(SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(idSoggetto));
        }
        if (partecipanti != null) {
            manifest.setElencoPartecipanti(partecipanti);
        }
        ElencoServiziComposti sComposti = null;
        for (int i3 = 0; i3 < accordoCooperazioneOpenspcoop.sizeUriServiziCompostiList(); ++i3) {
            String uriServizioComposto = accordoCooperazioneOpenspcoop.getUriServiziComposti(i3);
            if (sComposti == null) {
                sComposti = new ElencoServiziComposti();
            }
            try {
                sComposti.addServizioComposto(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_openspcoopToSica(IDAccordo.getIDAccordoFromUri(uriServizioComposto)));
                continue;
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Costruzione IDAccordo servizio composto [" + uriServizioComposto + "] non riuscito: " + e.getMessage(), e);
            }
        }
        if (sComposti != null) {
            manifest.setServiziComposti(sComposti);
        }
        if (accordoCooperazioneOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accCooperazioneSICA.setFirma(firma);
        }
        accCooperazioneSICA.setManifesto(manifest);
        return accCooperazioneSICA;
    }

    public static AccordoServizio accordoServizioParteComune_sicaToOpenspcoop(it.gov.spcoop.sica.dao.AccordoServizioParteComune accordoServizioSICA) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento docSICA;
        String fileName;
        Documento docOpenspcoop;
        int i;
        AccordoServizio accServizioOpenspcoop = new AccordoServizio();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = accordoServizioSICA.getManifesto();
        accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
        accServizioOpenspcoop.setNome(manifest.getNome());
        accServizioOpenspcoop.setVersione(manifest.getVersione());
        accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        accServizioOpenspcoop.setProfiloCollaborazione("oneway");
        AccordoServizioParteComune parteComune = manifest.getParteComune();
        SpecificaInterfaccia specificaInterfaccia = parteComune.getSpecificaInterfaccia();
        if (accordoServizioSICA.getInterfacciaConcettuale() != null || accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null || accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
            if (specificaInterfaccia.getInterfacciaConcettuale() != null && accordoServizioSICA.getInterfacciaConcettuale() != null) {
                accServizioOpenspcoop.setByteWsdlConcettuale(accordoServizioSICA.getInterfacciaConcettuale().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoErogatore() != null && accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null) {
                accServizioOpenspcoop.setByteWsdlLogicoErogatore(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoFruitore() != null && accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
                accServizioOpenspcoop.setByteWsdlLogicoFruitore(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto());
            }
        }
        SpecificaConversazione specificaConversazione = parteComune.getSpecificaConversazione();
        if (accordoServizioSICA.getConversazioneConcettuale() != null || accordoServizioSICA.getConversazioneLogicaErogatore() != null || accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
            if (specificaConversazione.getConversazioneConcettuale() != null && accordoServizioSICA.getConversazioneConcettuale() != null) {
                accServizioOpenspcoop.setByteWsblConcettuale(accordoServizioSICA.getConversazioneConcettuale().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoErogatore() != null && accordoServizioSICA.getConversazioneLogicaErogatore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoErogatore(accordoServizioSICA.getConversazioneLogicaErogatore().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoFruitore() != null && accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoFruitore(accordoServizioSICA.getConversazioneLogicaFruitore().getContenuto());
            }
        }
        AccordoServizioSoggettoReferente soggettoReferente = new AccordoServizioSoggettoReferente();
        IDSoggetto soggettoPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(parteComune.getPubblicatore());
        soggettoReferente.setNome(soggettoPubblicatore.getNome());
        soggettoReferente.setTipo(soggettoPubblicatore.getTipo());
        accServizioOpenspcoop.setSoggettoReferente(soggettoReferente);
        for (i = 0; i < manifest.sizeAllegatiList(); ++i) {
            ElencoAllegati allegati = manifest.getAllegati(i);
            docOpenspcoop = new Documento();
            fileName = allegati.getGenericoDocumento();
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
            docSICA = null;
            for (int j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                docSICA = accordoServizioSICA.getAllegato(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
            }
            if ("InterfacciaDefinitoria.xsd".equals(fileName)) {
                accServizioOpenspcoop.setByteWsdlDefinitorio(docSICA.getContenuto());
                continue;
            }
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addAllegato(docOpenspcoop);
        }
        for (i = 0; i < manifest.sizeSpecificaSemiformaleList(); ++i) {
            SpecificaSemiformale specificaSemiformale = manifest.getSpecificaSemiformale(i);
            docOpenspcoop = new Documento();
            fileName = specificaSemiformale.getDocumentoSemiformale().getBase();
            docSICA = null;
            for (int j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
            }
            if ("ProfiloDiCollaborazione.xml".equals(fileName)) {
                EgovDecllElement egov = null;
                try {
                    egov = it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(docSICA.getContenuto());
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con informazione egov, nome[" + fileName + "], non leggibile: " + e.getMessage(), e);
                }
                Hashtable<String, PortType> servizi = new Hashtable<String, PortType>();
                OperationListType list = egov.getOperationList();
                for (int h = 0; h < list.sizeOperationList(); ++h) {
                    OperationType op = list.getOperation(h);
                    PortType pt = null;
                    if (servizi.containsKey(op.getServizio())) {
                        pt = (PortType)servizi.remove(op.getServizio());
                    } else {
                        pt = new PortType();
                        pt.setProfiloPT("ridefinito");
                        if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("oneway");
                        } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("sincrono");
                        } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("asincronoSimmetrico");
                        } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("asincronoAsimmetrico");
                        } else {
                            throw new SICAToOpenSPCoopUtilitiesException("Profilo di collaborazione non valido [" + op.getProfiloDiCollaborazione() + "]");
                        }
                        pt.setNome(op.getServizio());
                    }
                    Operation azione = new Operation();
                    azione.setNome(op.getOperazione());
                    azione.setProfAzione("ridefinito");
                    if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("oneway");
                    } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("sincrono");
                    } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("asincronoSimmetrico");
                    } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("asincronoAsimmetrico");
                    } else {
                        throw new SICAToOpenSPCoopUtilitiesException("Profilo di collaborazione non valido [" + op.getProfiloDiCollaborazione() + "]");
                    }
                    pt.addAzione(azione);
                    servizi.put(op.getServizio(), pt);
                    if (!TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione()) && !TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione()) || op.getOperazioneCorrelata() == null) continue;
                    String servizio = op.getServizioCorrelato();
                    if (servizio == null) {
                        servizio = op.getServizio();
                    }
                    if (op.getOperazioneCorrelata() == null) {
                        throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con informazione egov, nome[" + fileName + "], non leggibile: operazione correlata non presente per il servizio [" + servizio + "]");
                    }
                    PortType ptCorrelato = null;
                    if (servizi.containsKey(servizio)) {
                        ptCorrelato = (PortType)servizi.remove(servizio);
                    } else {
                        ptCorrelato = new PortType();
                        ptCorrelato.setProfiloPT("ridefinito");
                        if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            ptCorrelato.setProfiloCollaborazione("asincronoSimmetrico");
                        } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            ptCorrelato.setProfiloCollaborazione("asincronoAsimmetrico");
                        }
                        ptCorrelato.setNome(servizio);
                    }
                    Operation azioneCorrelata = new Operation();
                    azioneCorrelata.setNome(op.getOperazioneCorrelata());
                    azioneCorrelata.setProfAzione("ridefinito");
                    if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azioneCorrelata.setProfiloCollaborazione("asincronoSimmetrico");
                    } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azioneCorrelata.setProfiloCollaborazione("asincronoAsimmetrico");
                    }
                    if (op.getServizioCorrelato() != null) {
                        azioneCorrelata.setCorrelataServizio(op.getServizioCorrelato());
                    }
                    azioneCorrelata.setCorrelata(op.getOperazione());
                    ptCorrelato.addAzione(azioneCorrelata);
                    servizi.put(servizio, ptCorrelato);
                }
                Enumeration keys = servizi.keys();
                while (keys.hasMoreElements()) {
                    String pt = (String)keys.nextElement();
                    accServizioOpenspcoop.addPortType((PortType)servizi.get(pt));
                }
                continue;
            }
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
        }
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        return accServizioOpenspcoop;
    }

    public static it.gov.spcoop.sica.dao.AccordoServizioParteComune accordoServizioParteComune_openspcoopToSica(AccordoServizio accordoServizioOpenspcoop) throws SICAToOpenSPCoopUtilitiesException {
        Documento docOpenspcoop;
        int i;
        it.gov.spcoop.sica.dao.Documento doc;
        DocumentoConversazione docConversazione;
        it.gov.spcoop.sica.dao.Documento doc2;
        DocumentoInterfaccia docInterfaccia;
        it.gov.spcoop.sica.dao.AccordoServizioParteComune accServParteComuneSICA = new it.gov.spcoop.sica.dao.AccordoServizioParteComune();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = new it.gov.spcoop.sica.manifest.AccordoServizio();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getNome());
        manifest.setVersione(accordoServizioOpenspcoop.getVersione());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            manifest.setFirmato(true);
        }
        AccordoServizioParteComune parteComune = new AccordoServizioParteComune();
        SpecificaInterfaccia specificaInterfaccia = null;
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            specificaInterfaccia = new SpecificaInterfaccia();
        }
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaConcettuale.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaConcettuale(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaConcettuale.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlConcettuale());
            accServParteComuneSICA.setInterfacciaConcettuale(doc2);
        }
        if (accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaErogatore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoErogatore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaErogatore.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoErogatore());
            accServParteComuneSICA.setInterfacciaLogicaLatoErogatore(doc2);
        }
        if (accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaFruitore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoFruitore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaFruitore.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoFruitore());
            accServParteComuneSICA.setInterfacciaLogicaLatoFruitore(doc2);
        }
        if (specificaInterfaccia != null) {
            parteComune.setSpecificaInterfaccia(specificaInterfaccia);
        }
        SpecificaConversazione specificaConversazione = null;
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null || accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            specificaConversazione = new SpecificaConversazione();
        }
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneConcettuale.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneConcettuale(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneConcettuale.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblConcettuale());
            accServParteComuneSICA.setConversazioneConcettuale(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoErogatore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoErogatore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoErogatore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoErogatore());
            accServParteComuneSICA.setConversazioneLogicaErogatore(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoFruitore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoFruitore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoFruitore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoFruitore());
            accServParteComuneSICA.setConversazioneLogicaFruitore(doc);
        }
        if (specificaConversazione != null) {
            parteComune.setSpecificaConversazione(specificaConversazione);
        }
        if (accordoServizioOpenspcoop.getSoggettoReferente() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
        }
        IDSoggetto soggettoPubblicatore = new IDSoggetto(accordoServizioOpenspcoop.getSoggettoReferente().getTipo(), accordoServizioOpenspcoop.getSoggettoReferente().getNome());
        String uriPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoPubblicatore);
        parteComune.setPubblicatore(uriPubblicatore);
        for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento(docOpenspcoop.getFile());
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServParteComuneSICA.addAllegato(docSICA);
        }
        if (accordoServizioOpenspcoop.getByteWsdlDefinitorio() != null) {
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento("InterfacciaDefinitoria.xsd");
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo("XSD");
            docSICA.setNome("InterfacciaDefinitoria.xsd");
            docSICA.setContenuto(accordoServizioOpenspcoop.getByteWsdlDefinitorio());
            accServParteComuneSICA.addAllegato(docSICA);
        }
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0) {
            EgovDecllElement egov = new EgovDecllElement();
            egov.setEGovVersion("e-govV1.1");
            egov.setRifDefinizioneInterfaccia(accordoServizioOpenspcoop.getNome());
            OperationListType operations = new OperationListType();
            Vector<OperationType> operationsSICA_asincrone_nonAncoraInserite = new Vector<OperationType>();
            for (int i2 = 0; i2 < accordoServizioOpenspcoop.sizePortTypeList(); ++i2) {
                PortType portType = accordoServizioOpenspcoop.getPortType(i2);
                for (int j = 0; j < portType.sizeAzioneList(); ++j) {
                    OperationType opSICA;
                    Operation operation = portType.getAzione(j);
                    String profilo = null;
                    profilo = "ridefinito".equals(operation.getProfAzione()) ? operation.getProfiloCollaborazione() : portType.getProfiloCollaborazione();
                    if ("asincronoAsimmetrico".equals(profilo) || "asincronoSimmetrico".equals(profilo)) {
                        if (operation.getCorrelata() == null) {
                            opSICA = new OperationType();
                            opSICA.setOperazione(operation.getNome());
                            if ("asincronoAsimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                            } else if ("asincronoSimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                            }
                            opSICA.setServizio(portType.getNome());
                            operationsSICA_asincrone_nonAncoraInserite.add(opSICA);
                            continue;
                        }
                        opSICA = new OperationType();
                        opSICA.setOperazione(operation.getCorrelata());
                        opSICA.setOperazioneCorrelata(operation.getNome());
                        if ("asincronoAsimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                        } else if ("asincronoSimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                        }
                        if (operation.getCorrelataServizio() != null) {
                            opSICA.setServizio(operation.getCorrelataServizio());
                        } else {
                            opSICA.setServizio(portType.getNome());
                        }
                        opSICA.setServizioCorrelato(portType.getNome());
                        operations.addOperation(opSICA);
                        continue;
                    }
                    opSICA = new OperationType();
                    opSICA.setOperazione(operation.getNome());
                    if ("oneway".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.OneWay.name());
                    } else if ("sincrono".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.Sincrono.name());
                    }
                    opSICA.setServizio(portType.getNome());
                    operations.addOperation(opSICA);
                }
            }
            while (operationsSICA_asincrone_nonAncoraInserite.size() > 0) {
                OperationType opSICA = (OperationType)operationsSICA_asincrone_nonAncoraInserite.remove(0);
                boolean find = false;
                for (int i3 = 0; i3 < operations.sizeOperationList(); ++i3) {
                    if (!opSICA.getServizio().equals(operations.getOperation(i3).getServizio()) || !opSICA.getOperazione().equals(operations.getOperation(i3).getOperazione())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                operations.addOperation(opSICA);
            }
            egov.setOperationList(operations);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(TipiDocumentoSemiformale.XML.toString());
            docSemiformale.setBase("ProfiloDiCollaborazione.xml");
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(TipiDocumentoSemiformale.XML.toString());
            docSICA.setNome("ProfiloDiCollaborazione.xml");
            try {
                docSICA.setContenuto(it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov(egov));
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
            }
            accServParteComuneSICA.addSpecificaSemiformale(docSICA);
        }
        for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(docOpenspcoop.getTipo());
            docSemiformale.setBase(docOpenspcoop.getFile());
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            it.gov.spcoop.sica.dao.Documento docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServParteComuneSICA.addSpecificaSemiformale(docSICA);
        }
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServParteComuneSICA.setFirma(firma);
        }
        manifest.setParteComune(parteComune);
        accServParteComuneSICA.setManifesto(manifest);
        return accServParteComuneSICA;
    }

    public static ServizioSpcoop accordoServizioParteSpecifica_sicaToOpenspcoop(AccordoServizioParteSpecifica accordoServizioSICA) throws SICAToOpenSPCoopUtilitiesException {
        SpecificaLivelliServizio specificaLivelliServizio;
        int j;
        it.gov.spcoop.sica.dao.Documento docSICA;
        String fileName;
        Documento docOpenspcoop;
        int i;
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica;
        it.gov.spcoop.sica.manifest.AccordoServizio manifest;
        ServizioSpcoop accServizioOpenspcoop;
        block32: {
            accServizioOpenspcoop = new ServizioSpcoop();
            manifest = accordoServizioSICA.getManifesto();
            accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
            accServizioOpenspcoop.setNome(manifest.getNome());
            accServizioOpenspcoop.setPortType(manifest.getNome());
            accServizioOpenspcoop.setTipo("SPC");
            accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
            accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
            parteSpecifica = manifest.getParteSpecifica();
            try {
                String[] split = parteSpecifica.getRiferimentoParteComune().split(":");
                if (split.length < 2) {
                    throw new Exception("Riferimento parte comune non corretto (split non riuscito) [" + parteSpecifica.getRiferimentoParteComune() + "]");
                }
                if (split[1].equals("sc")) {
                    accServizioOpenspcoop.setAccordoServizio(IDAccordo.getUriFromIDAccordo(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_sicaToOpenspcoop(parteSpecifica.getRiferimentoParteComune())));
                    break block32;
                }
                if (split[1].equals("adsc")) {
                    accServizioOpenspcoop.setAccordoServizio(IDAccordo.getUriFromIDAccordo(SICAtoOpenSPCoopUtilities.idAccordoServizioParteComune_sicaToOpenspcoop(parteSpecifica.getRiferimentoParteComune())));
                    break block32;
                }
                throw new Exception("Tipo accordo [" + split[1] + "] non conosciuto");
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Trasformazione riferimento parte comune [" + parteSpecifica.getRiferimentoParteComune() + "] non riuscita: " + e.getMessage(), e);
            }
        }
        SpecificaPortiAccesso specificaInterfaccia = parteSpecifica.getSpecificaPortiAccesso();
        if (accordoServizioSICA.getPortiAccessoFruitore() != null || accordoServizioSICA.getPortiAccessoErogatore() != null) {
            if (specificaInterfaccia.getPortiAccessoErogatore() != null && accordoServizioSICA.getPortiAccessoErogatore() != null) {
                accServizioOpenspcoop.setByteWsdlImplementativoErogatore(accordoServizioSICA.getPortiAccessoErogatore().getContenuto());
                accServizioOpenspcoop.setServizioCorrelato(false);
            }
            if (specificaInterfaccia.getPortiAccessoFruitore() != null && accordoServizioSICA.getPortiAccessoFruitore() != null) {
                accServizioOpenspcoop.setByteWsdlImplementativoFruitore(accordoServizioSICA.getPortiAccessoFruitore().getContenuto());
                accServizioOpenspcoop.setServizioCorrelato(true);
            }
        }
        accServizioOpenspcoop.setTipoAdesione(parteSpecifica.getAdesione());
        IDSoggetto soggettoErogatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(parteSpecifica.getErogatore());
        accServizioOpenspcoop.setTipoSoggettoErogatore(soggettoErogatore.getTipo());
        accServizioOpenspcoop.setNomeSoggettoErogatore(soggettoErogatore.getNome());
        String url = null;
        if (accServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null) {
            try {
                url = SICAtoOpenSPCoopUtilities.readConnettoreFromWsdlImplementativo(accServizioOpenspcoop.getByteWsdlImplementativoErogatore());
            }
            catch (Exception e) {
                Logger.getLogger((String)"SicaToOpenspcoopUtilities").info((Object)("Lettura WsdlLocation non riuscita (ImplementativoErogatore): " + e.getMessage()), (Throwable)e);
            }
        } else if (accServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            try {
                url = SICAtoOpenSPCoopUtilities.readConnettoreFromWsdlImplementativo(accServizioOpenspcoop.getByteWsdlImplementativoFruitore());
            }
            catch (Exception e) {
                Logger.getLogger((String)"SicaToOpenspcoopUtilities").info((Object)("Lettura WsdlLocation non riuscita (ImplementativoFruitore): " + e.getMessage()), (Throwable)e);
            }
        }
        String nomeConn = "CNT_" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "_" + accServizioOpenspcoop.getTipo() + "/" + accServizioOpenspcoop.getNome();
        Connettore connettore = new Connettore();
        connettore.setNome(nomeConn);
        if (url != null) {
            connettore.setTipo("http");
            ConnettoreProperty prop = new ConnettoreProperty();
            prop.setNome("location");
            prop.setValore(url);
            connettore.addProperty(prop);
        } else {
            connettore.setTipo("disabilitato");
        }
        accServizioOpenspcoop.setConnettore(connettore);
        for (i = 0; i < manifest.sizeAllegatiList(); ++i) {
            ElencoAllegati allegati = manifest.getAllegati(i);
            docOpenspcoop = new Documento();
            fileName = allegati.getGenericoDocumento();
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
            docSICA = null;
            for (j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                docSICA = accordoServizioSICA.getAllegato(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
            }
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addAllegato(docOpenspcoop);
        }
        for (i = 0; i < manifest.sizeSpecificaSemiformaleList(); ++i) {
            SpecificaSemiformale specificaSemiformale = manifest.getSpecificaSemiformale(i);
            docOpenspcoop = new Documento();
            fileName = specificaSemiformale.getDocumentoSemiformale().getBase();
            docSICA = null;
            for (j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
            }
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
        }
        SpecificaSicurezza specificaSicurezza = parteSpecifica.getSpecificaSicurezza();
        if (specificaSicurezza != null) {
            for (int i2 = 0; i2 < specificaSicurezza.sizeDocumentoSicurezzaList(); ++i2) {
                DocumentoSicurezza docSicurezzaSICA = specificaSicurezza.getDocumentoSicurezza(i2);
                Documento docOpenspcoop2 = new Documento();
                String fileName2 = docSicurezzaSICA.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA2 = null;
                for (int j2 = 0; j2 < accordoServizioSICA.sizeSpecificheSicurezza(); ++j2) {
                    if (!fileName2.equals(accordoServizioSICA.getSpecificaSicurezza(j2).getNome())) continue;
                    docSICA2 = accordoServizioSICA.getSpecificaSicurezza(j2);
                }
                if (docSICA2 == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSicurezza con nome[" + fileName2 + "] non trovato");
                }
                docOpenspcoop2.setFile(fileName2);
                docOpenspcoop2.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                docOpenspcoop2.setTipo(docSICA2.getTipo());
                docOpenspcoop2.setByteContenuto(docSICA2.getContenuto());
                accServizioOpenspcoop.addSpecificaSicurezza(docOpenspcoop2);
            }
        }
        if ((specificaLivelliServizio = parteSpecifica.getSpecificaLivelliServizio()) != null) {
            for (int i3 = 0; i3 < specificaLivelliServizio.sizeDocumentoLivelloServizioList(); ++i3) {
                DocumentoLivelloServizio docLS = specificaLivelliServizio.getDocumentoLivelloServizio(i3);
                Documento docOpenspcoop3 = new Documento();
                String fileName3 = docLS.getBase();
                it.gov.spcoop.sica.dao.Documento docSICA3 = null;
                for (int j3 = 0; j3 < accordoServizioSICA.sizeSpecificheLivelliServizio(); ++j3) {
                    if (!fileName3.equals(accordoServizioSICA.getSpecificaLivelloServizio(j3).getNome())) continue;
                    docSICA3 = accordoServizioSICA.getSpecificaLivelloServizio(j3);
                }
                if (docSICA3 == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaLivelloServizio con nome[" + fileName3 + "] non trovato");
                }
                docOpenspcoop3.setFile(fileName3);
                docOpenspcoop3.setRuolo(RuoliDocumento.specificaLivelloServizio.toString());
                docOpenspcoop3.setTipo(docSICA3.getTipo());
                docOpenspcoop3.setByteContenuto(docSICA3.getContenuto());
                accServizioOpenspcoop.addSpecificaLivelloServizio(docOpenspcoop3);
            }
        }
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        return accServizioOpenspcoop;
    }

    public static AccordoServizioParteSpecifica accordoServizioParteSpecifica_openspcoopToSica(ServizioSpcoop accordoServizioOpenspcoop, boolean implementazioneAccordoServizioComposto) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento docSICA;
        Documento docOpenspcoop;
        int i;
        it.gov.spcoop.sica.dao.Documento doc;
        DocumentoInterfaccia docInterfaccia;
        AccordoServizioParteSpecifica accServParteSpecificaSICA = new AccordoServizioParteSpecifica();
        it.gov.spcoop.sica.manifest.AccordoServizio manifest = new it.gov.spcoop.sica.manifest.AccordoServizio();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getNome());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            manifest.setFirmato(true);
        }
        it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica parteSpecifica = new it.gov.spcoop.sica.manifest.AccordoServizioParteSpecifica();
        try {
            if (implementazioneAccordoServizioComposto) {
                parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.idAccordoServizioComposto_openspcoopToSica(IDAccordo.getIDAccordoFromUri(accordoServizioOpenspcoop.getAccordoServizio())));
            } else {
                parteSpecifica.setRiferimentoParteComune(SICAtoOpenSPCoopUtilities.idAccordoServizioParteComune_openspcoopToSica(IDAccordo.getIDAccordoFromUri(accordoServizioOpenspcoop.getAccordoServizio())));
            }
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione riferimento parte comune [" + accordoServizioOpenspcoop.getAccordoServizio() + "] non riuscita: " + e.getMessage(), e);
        }
        String urlConnettore = null;
        if (accordoServizioOpenspcoop.getConnettore() != null && "http".equals(accordoServizioOpenspcoop.getConnettore().getTipo()) && accordoServizioOpenspcoop.getConnettore().sizePropertyList() > 0) {
            for (int i2 = 0; i2 < accordoServizioOpenspcoop.getConnettore().sizePropertyList(); ++i2) {
                if (!"location".equals(accordoServizioOpenspcoop.getConnettore().getProperty(i2).getNome())) continue;
                urlConnettore = accordoServizioOpenspcoop.getConnettore().getProperty(i2).getValore();
            }
        }
        SpecificaPortiAccesso specificaPortiAccesso = null;
        if (accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            specificaPortiAccesso = new SpecificaPortiAccesso();
        }
        if (accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("PortiAccessoErogatore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaPortiAccesso.setPortiAccessoErogatore(docInterfaccia);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc.setNome("PortiAccessoErogatore.wsdl");
            if (urlConnettore == null) {
                doc.setContenuto(accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore());
            } else {
                try {
                    doc.setContenuto(SICAtoOpenSPCoopUtilities.saveConnettoreIntoWsdlImplementativo(accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore(), urlConnettore));
                }
                catch (Exception e) {
                    Logger.getLogger((String)"SicaToOpenspcoopUtilities").info((Object)("Impostazione WsdlLocation non riuscita (ImplementativoErogatore): " + e.getMessage()), (Throwable)e);
                    doc.setContenuto(accordoServizioOpenspcoop.getByteWsdlImplementativoErogatore());
                }
            }
            accServParteSpecificaSICA.setPortiAccessoErogatore(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("PortiAccessoFruitore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaPortiAccesso.setPortiAccessoFruitore(docInterfaccia);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc.setNome("PortiAccessoFruitore.wsdl");
            if (urlConnettore == null) {
                doc.setContenuto(accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore());
            } else {
                try {
                    doc.setContenuto(SICAtoOpenSPCoopUtilities.saveConnettoreIntoWsdlImplementativo(accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore(), urlConnettore));
                }
                catch (Exception e) {
                    Logger.getLogger((String)"SicaToOpenspcoopUtilities").info((Object)("Impostazione WsdlLocation non riuscita (ImplementativoFruitore): " + e.getMessage()), (Throwable)e);
                    doc.setContenuto(accordoServizioOpenspcoop.getByteWsdlImplementativoFruitore());
                }
            }
            accServParteSpecificaSICA.setPortiAccessoFruitore(doc);
        }
        if (specificaPortiAccesso != null) {
            parteSpecifica.setSpecificaPortiAccesso(specificaPortiAccesso);
        }
        parteSpecifica.setAdesione(accordoServizioOpenspcoop.getTipoAdesione());
        IDSoggetto soggettoErogatore = new IDSoggetto(accordoServizioOpenspcoop.getTipoSoggettoErogatore(), accordoServizioOpenspcoop.getNomeSoggettoErogatore());
        String uriErogatore = SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoErogatore);
        parteSpecifica.setErogatore(uriErogatore);
        for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento(docOpenspcoop.getFile());
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA2 = new it.gov.spcoop.sica.dao.Documento();
            docSICA2.setTipo(docOpenspcoop.getTipo());
            docSICA2.setNome(docOpenspcoop.getFile());
            docSICA2.setContenuto(docOpenspcoop.getByteContenuto());
            accServParteSpecificaSICA.addAllegato(docSICA2);
        }
        for (i = 0; i < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(docOpenspcoop.getTipo());
            docSemiformale.setBase(docOpenspcoop.getFile());
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServParteSpecificaSICA.addSpecificaSemiformale(docSICA);
        }
        SpecificaSicurezza specificaSicurezza = null;
        for (int i3 = 0; i3 < accordoServizioOpenspcoop.sizeSpecificaSicurezzaList(); ++i3) {
            Documento docOpenspcoop2 = accordoServizioOpenspcoop.getSpecificaSicurezza(i3);
            if (specificaSicurezza == null) {
                specificaSicurezza = new SpecificaSicurezza();
            }
            DocumentoSicurezza docSicurezza = new DocumentoSicurezza();
            docSicurezza.setTipo(docOpenspcoop2.getTipo());
            docSicurezza.setBase(docOpenspcoop2.getFile());
            specificaSicurezza.addDocumentoSicurezza(docSicurezza);
            docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop2.getTipo());
            docSICA.setNome(docOpenspcoop2.getFile());
            docSICA.setContenuto(docOpenspcoop2.getByteContenuto());
            accServParteSpecificaSICA.addSpecificaSicurezza(docSICA);
        }
        if (specificaSicurezza != null) {
            parteSpecifica.setSpecificaSicurezza(specificaSicurezza);
        }
        SpecificaLivelliServizio specificaLivelliServizio = null;
        for (int i4 = 0; i4 < accordoServizioOpenspcoop.sizeSpecificaLivelloServizioList(); ++i4) {
            Documento docOpenspcoop3 = accordoServizioOpenspcoop.getSpecificaLivelloServizio(i4);
            if (specificaLivelliServizio == null) {
                specificaLivelliServizio = new SpecificaLivelliServizio();
            }
            DocumentoLivelloServizio docLivelliServizio = new DocumentoLivelloServizio();
            docLivelliServizio.setTipo(docOpenspcoop3.getTipo());
            docLivelliServizio.setBase(docOpenspcoop3.getFile());
            specificaLivelliServizio.addDocumentoLivelloServizio(docLivelliServizio);
            it.gov.spcoop.sica.dao.Documento docSICA3 = new it.gov.spcoop.sica.dao.Documento();
            docSICA3.setTipo(docOpenspcoop3.getTipo());
            docSICA3.setNome(docOpenspcoop3.getFile());
            docSICA3.setContenuto(docOpenspcoop3.getByteContenuto());
            accServParteSpecificaSICA.addSpecificaLivelloServizio(docSICA3);
        }
        if (specificaLivelliServizio != null) {
            parteSpecifica.setSpecificaLivelliServizio(specificaLivelliServizio);
        }
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServParteSpecificaSICA.setFirma(firma);
        }
        manifest.setParteSpecifica(parteSpecifica);
        accServParteSpecificaSICA.setManifesto(manifest);
        return accServParteSpecificaSICA;
    }

    public static AccordoServizio accordoServizioComposto_sicaToOpenspcoop(AccordoServizioComposto accordoServizioSICA) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento docSICA;
        String fileName;
        Documento docOpenspcoop;
        int i;
        AccordoServizio accServizioOpenspcoop = new AccordoServizio();
        ServizioComposto manifest = accordoServizioSICA.getManifesto();
        accServizioOpenspcoop.setDescrizione(manifest.getDescrizione());
        accServizioOpenspcoop.setNome(manifest.getNome());
        accServizioOpenspcoop.setVersione(manifest.getVersione());
        accServizioOpenspcoop.setOraRegistrazione(manifest.getDataCreazione());
        accServizioOpenspcoop.setDataPubblicazione(manifest.getDataPubblicazione());
        accServizioOpenspcoop.setProfiloCollaborazione("oneway");
        SpecificaInterfaccia specificaInterfaccia = manifest.getSpecificaInterfaccia();
        if (accordoServizioSICA.getInterfacciaConcettuale() != null || accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null || accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
            if (specificaInterfaccia.getInterfacciaConcettuale() != null && accordoServizioSICA.getInterfacciaConcettuale() != null) {
                accServizioOpenspcoop.setByteWsdlConcettuale(accordoServizioSICA.getInterfacciaConcettuale().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoErogatore() != null && accordoServizioSICA.getInterfacciaLogicaLatoErogatore() != null) {
                accServizioOpenspcoop.setByteWsdlLogicoErogatore(accordoServizioSICA.getInterfacciaLogicaLatoErogatore().getContenuto());
            }
            if (specificaInterfaccia.getInterfacciaLogicaLatoFruitore() != null && accordoServizioSICA.getInterfacciaLogicaLatoFruitore() != null) {
                accServizioOpenspcoop.setByteWsdlLogicoFruitore(accordoServizioSICA.getInterfacciaLogicaLatoFruitore().getContenuto());
            }
        }
        SpecificaConversazione specificaConversazione = manifest.getSpecificaConversazione();
        if (accordoServizioSICA.getConversazioneConcettuale() != null || accordoServizioSICA.getConversazioneLogicaErogatore() != null || accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
            if (specificaConversazione.getConversazioneConcettuale() != null && accordoServizioSICA.getConversazioneConcettuale() != null) {
                accServizioOpenspcoop.setByteWsblConcettuale(accordoServizioSICA.getConversazioneConcettuale().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoErogatore() != null && accordoServizioSICA.getConversazioneLogicaErogatore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoErogatore(accordoServizioSICA.getConversazioneLogicaErogatore().getContenuto());
            }
            if (specificaConversazione.getConversazioneLogicaLatoFruitore() != null && accordoServizioSICA.getConversazioneLogicaFruitore() != null) {
                accServizioOpenspcoop.setByteWsblLogicoFruitore(accordoServizioSICA.getConversazioneLogicaFruitore().getContenuto());
            }
        }
        AccordoServizioSoggettoReferente soggettoReferente = new AccordoServizioSoggettoReferente();
        IDSoggetto soggettoPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_sicaToOpenspcoop(manifest.getPubblicatore());
        soggettoReferente.setNome(soggettoPubblicatore.getNome());
        soggettoReferente.setTipo(soggettoPubblicatore.getTipo());
        accServizioOpenspcoop.setSoggettoReferente(soggettoReferente);
        AccordoServizioServizioComposto servizioComposto = new AccordoServizioServizioComposto();
        IDAccordoCooperazione idAccordo = SICAtoOpenSPCoopUtilities.idAccordoCooperazione_sicaToOpenspcoop(manifest.getRiferimentoAccordoCooperazione());
        try {
            servizioComposto.setNomeAccordoCooperazione(IDAccordoCooperazione.getUriFromIDAccordo(idAccordo));
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di cooperazione [" + manifest.getRiferimentoAccordoCooperazione() + "] non riuscito: " + e.getMessage(), e);
        }
        if (manifest.getServiziComponenti() != null) {
            for (i = 0; i < manifest.getServiziComponenti().sizeServizioComponenteList(); ++i) {
                String servComponente = manifest.getServiziComponenti().getServizioComponente(i);
                IDServizio idServizioComponente = SICAtoOpenSPCoopUtilities.idAccordoServizioParteSpecifica_sicaToOpenspcoop(servComponente);
                AccordoServizioServizioCompostoServizioComponente servComponenteOpenspcoop = new AccordoServizioServizioCompostoServizioComponente();
                try {
                    servComponenteOpenspcoop.setTipo(idServizioComponente.getTipoServizio());
                    servComponenteOpenspcoop.setNome(idServizioComponente.getServizio());
                    servComponenteOpenspcoop.setTipoSoggetto(idServizioComponente.getSoggettoErogatore().getTipo());
                    servComponenteOpenspcoop.setNomeSoggetto(idServizioComponente.getSoggettoErogatore().getNome());
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di servizio composto [" + servComponente + "] non riuscito: " + e.getMessage(), e);
                }
                servizioComposto.addServizioComponente(servComponenteOpenspcoop);
            }
        }
        for (i = 0; i < manifest.sizeAllegatiList(); ++i) {
            ElencoAllegati allegati = manifest.getAllegati(i);
            docOpenspcoop = new Documento();
            fileName = allegati.getGenericoDocumento();
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.allegato.toString());
            docSICA = null;
            for (int j = 0; j < accordoServizioSICA.sizeAllegati(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getAllegato(j).getNome())) continue;
                docSICA = accordoServizioSICA.getAllegato(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("Allegato con nome[" + fileName + "] non trovato");
            }
            if ("InterfacciaDefinitoria.xsd".equals(fileName)) {
                accServizioOpenspcoop.setByteWsdlDefinitorio(docSICA.getContenuto());
                continue;
            }
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addAllegato(docOpenspcoop);
        }
        for (i = 0; i < manifest.sizeSpecificaSemiformaleList(); ++i) {
            SpecificaSemiformale specificaSemiformale = manifest.getSpecificaSemiformale(i);
            docOpenspcoop = new Documento();
            fileName = specificaSemiformale.getDocumentoSemiformale().getBase();
            docSICA = null;
            for (int j = 0; j < accordoServizioSICA.sizeSpecificheSemiformali(); ++j) {
                if (!fileName.equals(accordoServizioSICA.getSpecificaSemiformale(j).getNome())) continue;
                docSICA = accordoServizioSICA.getSpecificaSemiformale(j);
            }
            if (docSICA == null) {
                throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con nome[" + fileName + "] non trovato");
            }
            if ("ProfiloDiCollaborazione.xml".equals(fileName)) {
                EgovDecllElement egov = null;
                try {
                    egov = it.cnipa.collprofiles.driver.XMLUtils.getDichiarazioneEGov(docSICA.getContenuto());
                }
                catch (Exception e) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con informazione egov, nome[" + fileName + "], non leggibile: " + e.getMessage(), e);
                }
                Hashtable<String, PortType> servizi = new Hashtable<String, PortType>();
                OperationListType list = egov.getOperationList();
                for (int h = 0; h < list.sizeOperationList(); ++h) {
                    OperationType op = list.getOperation(h);
                    PortType pt = null;
                    if (servizi.containsKey(op.getServizio())) {
                        pt = (PortType)servizi.remove(op.getServizio());
                    } else {
                        pt = new PortType();
                        pt.setProfiloPT("ridefinito");
                        if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("oneway");
                        } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("sincrono");
                        } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("asincronoSimmetrico");
                        } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            pt.setProfiloCollaborazione("asincronoAsimmetrico");
                        } else {
                            throw new SICAToOpenSPCoopUtilitiesException("Profilo di collaborazione non valido [" + op.getProfiloDiCollaborazione() + "]");
                        }
                        pt.setNome(op.getServizio());
                    }
                    Operation azione = new Operation();
                    azione.setNome(op.getOperazione());
                    azione.setProfAzione("ridefinito");
                    if (TipiProfiliCollaborazione.OneWay.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("oneway");
                    } else if (TipiProfiliCollaborazione.Sincrono.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("sincrono");
                    } else if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("asincronoSimmetrico");
                    } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azione.setProfiloCollaborazione("asincronoAsimmetrico");
                    } else {
                        throw new SICAToOpenSPCoopUtilitiesException("Profilo di collaborazione non valido [" + op.getProfiloDiCollaborazione() + "]");
                    }
                    pt.addAzione(azione);
                    servizi.put(op.getServizio(), pt);
                    if (!TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione()) && !TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione()) || op.getOperazioneCorrelata() == null) continue;
                    String servizio = op.getServizioCorrelato();
                    if (servizio == null) {
                        servizio = op.getServizio();
                    }
                    if (op.getOperazioneCorrelata() == null) {
                        throw new SICAToOpenSPCoopUtilitiesException("SpecificaSemiformale con informazione egov, nome[" + fileName + "], non leggibile: operazione correlata non presente per il servizio [" + servizio + "]");
                    }
                    PortType ptCorrelato = null;
                    if (servizi.containsKey(servizio)) {
                        ptCorrelato = (PortType)servizi.remove(servizio);
                    } else {
                        ptCorrelato = new PortType();
                        ptCorrelato.setProfiloPT("ridefinito");
                        if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            ptCorrelato.setProfiloCollaborazione("asincronoSimmetrico");
                        } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                            ptCorrelato.setProfiloCollaborazione("asincronoAsimmetrico");
                        }
                        ptCorrelato.setNome(servizio);
                    }
                    Operation azioneCorrelata = new Operation();
                    azioneCorrelata.setNome(op.getOperazioneCorrelata());
                    azioneCorrelata.setProfAzione("ridefinito");
                    if (TipiProfiliCollaborazione.AsincronoSimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azioneCorrelata.setProfiloCollaborazione("asincronoSimmetrico");
                    } else if (TipiProfiliCollaborazione.AsincronoAsimmetrico.toString().equals(op.getProfiloDiCollaborazione())) {
                        azioneCorrelata.setProfiloCollaborazione("asincronoAsimmetrico");
                    }
                    if (op.getServizioCorrelato() != null) {
                        azioneCorrelata.setCorrelataServizio(op.getServizioCorrelato());
                    }
                    azioneCorrelata.setCorrelata(op.getOperazione());
                    ptCorrelato.addAzione(azioneCorrelata);
                    servizi.put(servizio, ptCorrelato);
                }
                Enumeration keys = servizi.keys();
                while (keys.hasMoreElements()) {
                    String pt = (String)keys.nextElement();
                    accServizioOpenspcoop.addPortType((PortType)servizi.get(pt));
                }
                continue;
            }
            docOpenspcoop.setFile(fileName);
            docOpenspcoop.setRuolo(RuoliDocumento.specificaSemiformale.toString());
            docOpenspcoop.setTipo(docSICA.getTipo());
            docOpenspcoop.setByteContenuto(docSICA.getContenuto());
            accServizioOpenspcoop.addSpecificaSemiformale(docOpenspcoop);
        }
        SpecificaCoordinamento specificaCoordinamento = manifest.getSpecificaCoordinamento();
        if (specificaCoordinamento != null) {
            for (int i2 = 0; i2 < specificaCoordinamento.sizeDocumentoCoordinamentoList(); ++i2) {
                DocumentoCoordinamento docCoordinamento = specificaCoordinamento.getDocumentoCoordinamento(i2);
                Documento docOpenspcoop2 = new Documento();
                String fileName2 = docCoordinamento.getBase();
                docOpenspcoop2.setFile(fileName2);
                docOpenspcoop2.setRuolo(RuoliDocumento.specificaCoordinamento.toString());
                it.gov.spcoop.sica.dao.Documento docSICA2 = null;
                for (int j = 0; j < accordoServizioSICA.sizeSpecificheCoordinamento(); ++j) {
                    if (!fileName2.equals(accordoServizioSICA.getSpecificaCoordinamento(j).getNome())) continue;
                    docSICA2 = accordoServizioSICA.getSpecificaCoordinamento(j);
                }
                if (docSICA2 == null) {
                    throw new SICAToOpenSPCoopUtilitiesException("SpecificaCoordinamento con nome[" + fileName2 + "] non trovato");
                }
                docOpenspcoop2.setTipo(docSICA2.getTipo());
                docOpenspcoop2.setByteContenuto(docSICA2.getContenuto());
                servizioComposto.addSpecificaCoordinamento(docOpenspcoop2);
            }
        }
        if (manifest.getFirmato()) {
            accServizioOpenspcoop.setByteFirma(accordoServizioSICA.getFirma().getBytes());
        }
        accServizioOpenspcoop.setServizioComposto(servizioComposto);
        return accServizioOpenspcoop;
    }

    public static AccordoServizioComposto accordoServizioComposto_openspcoopToSica(AccordoServizio accordoServizioOpenspcoop) throws SICAToOpenSPCoopUtilitiesException {
        it.gov.spcoop.sica.dao.Documento docSICA;
        Documento docOpenspcoop;
        int i;
        it.gov.spcoop.sica.dao.Documento doc;
        DocumentoConversazione docConversazione;
        it.gov.spcoop.sica.dao.Documento doc2;
        DocumentoInterfaccia docInterfaccia;
        AccordoServizioComposto accServCompostoSICA = new AccordoServizioComposto();
        ServizioComposto manifest = new ServizioComposto();
        manifest.setDescrizione(accordoServizioOpenspcoop.getDescrizione());
        manifest.setNome(accordoServizioOpenspcoop.getNome());
        manifest.setVersione(accordoServizioOpenspcoop.getVersione());
        manifest.setDataCreazione(accordoServizioOpenspcoop.getOraRegistrazione());
        manifest.setDataPubblicazione(accordoServizioOpenspcoop.getDataPubblicazione());
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            manifest.setFirmato(true);
        }
        SpecificaInterfaccia specificaInterfaccia = null;
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null || accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            specificaInterfaccia = new SpecificaInterfaccia();
        }
        if (accordoServizioOpenspcoop.getByteWsdlConcettuale() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaConcettuale.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaConcettuale(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaConcettuale.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlConcettuale());
            accServCompostoSICA.setInterfacciaConcettuale(doc2);
        }
        if (accordoServizioOpenspcoop.getByteWsdlLogicoErogatore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaErogatore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoErogatore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaErogatore.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoErogatore());
            accServCompostoSICA.setInterfacciaLogicaLatoErogatore(doc2);
        }
        if (accordoServizioOpenspcoop.getByteWsdlLogicoFruitore() != null) {
            docInterfaccia = new DocumentoInterfaccia();
            docInterfaccia.setBase("InterfacciaLogicaFruitore.wsdl");
            docInterfaccia.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            specificaInterfaccia.setInterfacciaLogicaLatoFruitore(docInterfaccia);
            doc2 = new it.gov.spcoop.sica.dao.Documento();
            doc2.setTipo(TipiDocumentoInterfaccia.WSDL.toString());
            doc2.setNome("InterfacciaLogicaFruitore.wsdl");
            doc2.setContenuto(accordoServizioOpenspcoop.getByteWsdlLogicoFruitore());
            accServCompostoSICA.setInterfacciaLogicaLatoFruitore(doc2);
        }
        if (specificaInterfaccia != null) {
            manifest.setSpecificaInterfaccia(specificaInterfaccia);
        }
        SpecificaConversazione specificaConversazione = null;
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null || accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null || accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            specificaConversazione = new SpecificaConversazione();
        }
        if (accordoServizioOpenspcoop.getByteWsblConcettuale() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneConcettuale.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneConcettuale(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneConcettuale.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblConcettuale());
            accServCompostoSICA.setConversazioneConcettuale(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoErogatore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoErogatore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoErogatore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoErogatore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoErogatore());
            accServCompostoSICA.setConversazioneLogicaErogatore(doc);
        }
        if (accordoServizioOpenspcoop.getByteWsblLogicoFruitore() != null) {
            docConversazione = new DocumentoConversazione();
            docConversazione.setBase("ConversazioneLogicaLatoFruitore.wsbl");
            docConversazione.setTipo(TipiDocumentoConversazione.WSBL.toString());
            specificaConversazione.setConversazioneLogicaLatoFruitore(docConversazione);
            doc = new it.gov.spcoop.sica.dao.Documento();
            doc.setTipo(TipiDocumentoConversazione.WSBL.toString());
            doc.setNome("ConversazioneLogicaLatoFruitore.wsbl");
            doc.setContenuto(accordoServizioOpenspcoop.getByteWsblLogicoFruitore());
            accServCompostoSICA.setConversazioneLogicaFruitore(doc);
        }
        if (specificaConversazione != null) {
            manifest.setSpecificaConversazione(specificaConversazione);
        }
        if (accordoServizioOpenspcoop.getSoggettoReferente() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("Soggetto referente non definito");
        }
        IDSoggetto soggettoPubblicatore = new IDSoggetto(accordoServizioOpenspcoop.getSoggettoReferente().getTipo(), accordoServizioOpenspcoop.getSoggettoReferente().getNome());
        String uriPubblicatore = SICAtoOpenSPCoopUtilities.idSoggetto_openspcoopToSica(soggettoPubblicatore);
        manifest.setPubblicatore(uriPubblicatore);
        String uriAccordoCooperazione = null;
        if (accordoServizioOpenspcoop.getServizioComposto() == null) {
            throw new SICAToOpenSPCoopUtilitiesException("ServizioComposto non definito");
        }
        try {
            uriAccordoCooperazione = SICAtoOpenSPCoopUtilities.idAccordoCooperazione_openspcoopToSica(IDAccordoCooperazione.getIDAccordoFromUri(accordoServizioOpenspcoop.getServizioComposto().getNomeAccordoCooperazione()));
        }
        catch (Exception e) {
            throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDAccordo di cooperazione [" + accordoServizioOpenspcoop.getServizioComposto().getNomeAccordoCooperazione() + "] non riuscito: " + e.getMessage(), e);
        }
        manifest.setRiferimentoAccordoCooperazione(uriAccordoCooperazione);
        ElencoServiziComponenti servComponentiSICA = null;
        for (i = 0; i < accordoServizioOpenspcoop.getServizioComposto().sizeServizioComponenteList(); ++i) {
            AccordoServizioServizioCompostoServizioComponente servComponente = accordoServizioOpenspcoop.getServizioComposto().getServizioComponente(i);
            if (servComponentiSICA == null) {
                servComponentiSICA = new ElencoServiziComponenti();
            }
            IDServizio idServ = new IDServizio(servComponente.getTipoSoggetto(), servComponente.getNomeSoggetto(), servComponente.getTipo(), servComponente.getNome());
            try {
                servComponentiSICA.addServizioComponente(SICAtoOpenSPCoopUtilities.idAccordoServizioParteSpecifica_openspcoopToSica(idServ));
                continue;
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Trasformazione IDServizio [" + idServ + "] non riuscito: " + e.getMessage(), e);
            }
        }
        if (servComponentiSICA != null) {
            manifest.setServiziComponenti(servComponentiSICA);
        }
        for (i = 0; i < accordoServizioOpenspcoop.sizeAllegatoList(); ++i) {
            docOpenspcoop = accordoServizioOpenspcoop.getAllegato(i);
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento(docOpenspcoop.getFile());
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA2 = new it.gov.spcoop.sica.dao.Documento();
            docSICA2.setTipo(docOpenspcoop.getTipo());
            docSICA2.setNome(docOpenspcoop.getFile());
            docSICA2.setContenuto(docOpenspcoop.getByteContenuto());
            accServCompostoSICA.addAllegato(docSICA2);
        }
        if (accordoServizioOpenspcoop.getByteWsdlDefinitorio() != null) {
            ElencoAllegati allegato = new ElencoAllegati();
            allegato.setGenericoDocumento("InterfacciaDefinitoria.xsd");
            manifest.addAllegati(allegato);
            it.gov.spcoop.sica.dao.Documento docSICA3 = new it.gov.spcoop.sica.dao.Documento();
            docSICA3.setTipo("XSD");
            docSICA3.setNome("InterfacciaDefinitoria.xsd");
            docSICA3.setContenuto(accordoServizioOpenspcoop.getByteWsdlDefinitorio());
            accServCompostoSICA.addAllegato(docSICA3);
        }
        if (accordoServizioOpenspcoop.sizePortTypeList() > 0) {
            EgovDecllElement egov = new EgovDecllElement();
            egov.setEGovVersion("e-govV1.1");
            egov.setRifDefinizioneInterfaccia(accordoServizioOpenspcoop.getNome());
            OperationListType operations = new OperationListType();
            Vector<OperationType> operationsSICA_asincrone_nonAncoraInserite = new Vector<OperationType>();
            for (int i2 = 0; i2 < accordoServizioOpenspcoop.sizePortTypeList(); ++i2) {
                PortType portType = accordoServizioOpenspcoop.getPortType(i2);
                for (int j = 0; j < portType.sizeAzioneList(); ++j) {
                    OperationType opSICA;
                    Operation operation = portType.getAzione(j);
                    String profilo = null;
                    profilo = "ridefinito".equals(operation.getProfAzione()) ? operation.getProfiloCollaborazione() : portType.getProfiloCollaborazione();
                    if ("asincronoAsimmetrico".equals(profilo) || "asincronoSimmetrico".equals(profilo)) {
                        if (operation.getCorrelata() == null) {
                            opSICA = new OperationType();
                            opSICA.setOperazione(operation.getNome());
                            if ("asincronoAsimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                            } else if ("asincronoSimmetrico".equals(profilo)) {
                                opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                            }
                            opSICA.setServizio(portType.getNome());
                            operationsSICA_asincrone_nonAncoraInserite.add(opSICA);
                            continue;
                        }
                        opSICA = new OperationType();
                        opSICA.setOperazione(operation.getCorrelata());
                        opSICA.setOperazioneCorrelata(operation.getNome());
                        if ("asincronoAsimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoAsimmetrico.name());
                        } else if ("asincronoSimmetrico".equals(profilo)) {
                            opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.AsincronoSimmetrico.name());
                        }
                        if (operation.getCorrelataServizio() != null) {
                            opSICA.setServizio(operation.getCorrelataServizio());
                        } else {
                            opSICA.setServizio(portType.getNome());
                        }
                        opSICA.setServizioCorrelato(portType.getNome());
                        operations.addOperation(opSICA);
                        continue;
                    }
                    opSICA = new OperationType();
                    opSICA.setOperazione(operation.getNome());
                    if ("oneway".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.OneWay.name());
                    } else if ("sincrono".equals(profilo)) {
                        opSICA.setProfiloDiCollaborazione(TipiProfiliCollaborazione.Sincrono.name());
                    }
                    opSICA.setServizio(portType.getNome());
                    operations.addOperation(opSICA);
                }
            }
            while (operationsSICA_asincrone_nonAncoraInserite.size() > 0) {
                OperationType opSICA = (OperationType)operationsSICA_asincrone_nonAncoraInserite.remove(0);
                boolean find = false;
                for (int i3 = 0; i3 < operations.sizeOperationList(); ++i3) {
                    if (!opSICA.getServizio().equals(operations.getOperation(i3).getServizio()) || !opSICA.getOperazione().equals(operations.getOperation(i3).getOperazione())) continue;
                    find = true;
                    break;
                }
                if (find) continue;
                operations.addOperation(opSICA);
            }
            egov.setOperationList(operations);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(TipiDocumentoSemiformale.XML.toString());
            docSemiformale.setBase("ProfiloDiCollaborazione.xml");
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            it.gov.spcoop.sica.dao.Documento docSICA4 = new it.gov.spcoop.sica.dao.Documento();
            docSICA4.setTipo(TipiDocumentoSemiformale.XML.toString());
            docSICA4.setNome("ProfiloDiCollaborazione.xml");
            try {
                docSICA4.setContenuto(it.cnipa.collprofiles.driver.XMLUtils.generateDichiarazioneEGov(egov));
            }
            catch (Exception e) {
                throw new SICAToOpenSPCoopUtilitiesException("Generazione dichiarazione eGov fallita: " + e.getMessage(), e);
            }
            accServCompostoSICA.addSpecificaSemiformale(docSICA4);
        }
        for (int i4 = 0; i4 < accordoServizioOpenspcoop.sizeSpecificaSemiformaleList(); ++i4) {
            docOpenspcoop = accordoServizioOpenspcoop.getSpecificaSemiformale(i4);
            SpecificaSemiformale specificaSemiformale = new SpecificaSemiformale();
            DocumentoSemiformale docSemiformale = new DocumentoSemiformale();
            docSemiformale.setTipo(docOpenspcoop.getTipo());
            docSemiformale.setBase(docOpenspcoop.getFile());
            specificaSemiformale.setDocumentoSemiformale(docSemiformale);
            manifest.addSpecificaSemiformale(specificaSemiformale);
            docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop.getTipo());
            docSICA.setNome(docOpenspcoop.getFile());
            docSICA.setContenuto(docOpenspcoop.getByteContenuto());
            accServCompostoSICA.addSpecificaSemiformale(docSICA);
        }
        SpecificaCoordinamento coordinamento = null;
        for (int i5 = 0; i5 < accordoServizioOpenspcoop.getServizioComposto().sizeSpecificaCoordinamentoList(); ++i5) {
            Documento docOpenspcoop2 = accordoServizioOpenspcoop.getServizioComposto().getSpecificaCoordinamento(i5);
            if (coordinamento == null) {
                coordinamento = new SpecificaCoordinamento();
            }
            DocumentoCoordinamento docCoordinamento = new DocumentoCoordinamento();
            docCoordinamento.setTipo(docOpenspcoop2.getTipo());
            docCoordinamento.setBase(docOpenspcoop2.getFile());
            coordinamento.addDocumentoCoordinamento(docCoordinamento);
            docSICA = new it.gov.spcoop.sica.dao.Documento();
            docSICA.setTipo(docOpenspcoop2.getTipo());
            docSICA.setNome(docOpenspcoop2.getFile());
            docSICA.setContenuto(docOpenspcoop2.getByteContenuto());
            accServCompostoSICA.addSpecificaCoordinamento(docSICA);
        }
        if (coordinamento != null) {
            manifest.setSpecificaCoordinamento(coordinamento);
        }
        if (accordoServizioOpenspcoop.getByteFirma() != null) {
            Firma firma = new Firma();
            accServCompostoSICA.setFirma(firma);
        }
        accServCompostoSICA.setManifesto(manifest);
        return accServCompostoSICA;
    }
}

