/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.Serializable;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;

public class IDServizio
implements Serializable {
    private static final long serialVersionUID = 1L;
    private IDSoggetto idSoggettoErogatore;
    private String servizio;
    private String tipoServizio;
    private String azione;
    private String uriAccordo;
    private boolean correlato;

    public IDServizio(IDSoggetto aIDSoggetto, String aTipoServizio, String aServizio, String aAzione) {
        this.idSoggettoErogatore = aIDSoggetto;
        this.tipoServizio = aTipoServizio;
        this.servizio = aServizio;
        this.azione = aAzione;
    }

    public IDServizio(IDSoggetto aIDSoggetto, String aTipoServizio, String aServizio) {
        this.idSoggettoErogatore = aIDSoggetto;
        this.tipoServizio = aTipoServizio;
        this.servizio = aServizio;
        this.azione = null;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto, String aTipoServizio, String aServizio, String aAzione) {
        this.idSoggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
        this.tipoServizio = aTipoServizio;
        this.servizio = aServizio;
        this.azione = aAzione;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto, String aTipoServizio, String aServizio) {
        this.idSoggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
        this.tipoServizio = aTipoServizio;
        this.servizio = aServizio;
        this.azione = null;
    }

    public IDServizio(IDSoggetto aIDSoggetto) {
        this.idSoggettoErogatore = aIDSoggetto;
    }

    public IDServizio(String aTipoSoggetto, String aSoggetto) {
        this.idSoggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
    }

    public IDServizio() {
    }

    public void setSoggettoErogatore(IDSoggetto aIDSoggetto) {
        this.idSoggettoErogatore = aIDSoggetto;
    }

    public void setSoggettoErogatore(String aTipoSoggetto, String aSoggetto) {
        this.idSoggettoErogatore = new IDSoggetto(aTipoSoggetto, aSoggetto);
    }

    public void setTipoServizio(String tipoServizio) {
        this.tipoServizio = tipoServizio;
    }

    public void setServizio(String servizio) {
        this.servizio = servizio;
    }

    public void setAzione(String azione) {
        this.azione = azione;
    }

    public IDSoggetto getSoggettoErogatore() {
        return this.idSoggettoErogatore;
    }

    public String getTipoServizio() {
        return this.tipoServizio;
    }

    public String getServizio() {
        return this.servizio;
    }

    public String getAzione() {
        return this.azione;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        if (this.idSoggettoErogatore != null) {
            bf.append(this.idSoggettoErogatore.getTipo());
            bf.append("/");
            bf.append(this.idSoggettoErogatore.getNome());
        }
        bf.append("_");
        bf.append(this.tipoServizio);
        bf.append("/");
        bf.append(this.servizio);
        if (this.azione != null) {
            bf.append("_");
            bf.append(this.azione);
        }
        return bf.toString();
    }

    public String getUriAccordo() {
        return this.uriAccordo;
    }

    public void setUriAccordo(String uriAccordo) {
        this.uriAccordo = uriAccordo;
    }

    public boolean isCorrelato() {
        return this.correlato;
    }

    public void setCorrelato(boolean correlato) {
        this.correlato = correlato;
    }

    public boolean equals(Object servizio) {
        if (servizio == null) {
            return false;
        }
        if (!servizio.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        IDServizio id = (IDServizio)servizio;
        if (this.getTipoServizio() == null ? id.getTipoServizio() != null : !this.getTipoServizio().equals(id.getTipoServizio())) {
            return false;
        }
        if (this.getServizio() == null ? id.getServizio() != null : !this.getServizio().equals(id.getServizio())) {
            return false;
        }
        if (this.getAzione() == null ? id.getAzione() != null : !this.getAzione().equals(id.getAzione())) {
            return false;
        }
        return !(this.getSoggettoErogatore() == null ? id.getSoggettoErogatore() != null : !this.getSoggettoErogatore().equals(id.getSoggettoErogatore()));
    }

    public Object clone() {
        IDServizio s = new IDServizio();
        s.setAzione(this.azione);
        s.setCorrelato(this.correlato);
        s.setServizio(this.servizio);
        s.setTipoServizio(this.tipoServizio);
        s.setUriAccordo(this.uriAccordo);
        if (this.idSoggettoErogatore != null) {
            IDSoggetto sogg = new IDSoggetto();
            sogg.setTipo(this.idSoggettoErogatore.getTipo());
            sogg.setNome(this.idSoggettoErogatore.getNome());
            sogg.setCodicePorta(this.idSoggettoErogatore.getCodicePorta());
            s.setSoggettoErogatore(sogg);
        }
        return s;
    }

    public static IDServizio getIDAccordoFromServizio(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        if (servizio == null) {
            throw new DriverRegistroServiziException("ServizioSpcoop non fornito");
        }
        IDServizio idServizio = new IDServizio(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore(), servizio.getTipo(), servizio.getNome());
        return idServizio;
    }
}

