/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.Serializable;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;

public class IDAccordoCooperazione
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nome;
    private String versione;

    public String getNome() {
        return this.nome;
    }

    public String getVersione() {
        return this.versione;
    }

    @Deprecated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Deprecated
    public void setVersione(String versione) {
        this.versione = versione;
    }

    private IDAccordoCooperazione build(String nome, String versione) {
        this.nome = nome;
        String v = null;
        if (versione != null && !"".equals(versione)) {
            v = versione;
        }
        this.versione = v;
        return this;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append(this.nome);
        if (this.versione != null) {
            bf.append("[" + this.versione + "]");
        }
        return bf.toString();
    }

    public boolean equals(Object idAS) {
        if (idAS == null) {
            return false;
        }
        if (!idAS.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        IDAccordoCooperazione id = (IDAccordoCooperazione)idAS;
        return this.toString().equals(id.toString());
    }

    public static String getUriFromIDAccordo(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("IDAccordo non fornito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("Nome accordo non fornito");
        }
        if (idAccordo.getVersione() != null) {
            return idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        return idAccordo.getNome();
    }

    public static String getUriFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
        idAccordo.build(accordo.getNome(), accordo.getVersione());
        return IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
    }

    public static String getUriFromValues(String nomeAS, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
        idAccordo.build(nomeAS, ver);
        return IDAccordoCooperazione.getUriFromIDAccordo(idAccordo);
    }

    public static IDAccordoCooperazione getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new Exception("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0 && (secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1)) > 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  nomeAccordo:versione");
            }
            if (primoMarcatore < 0) {
                IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
                idAccordo.build(uriAccordo, null);
                return idAccordo;
            }
            String tmp1 = uriAccordo.substring(0, primoMarcatore);
            String tmp2 = uriAccordo.substring(primoMarcatore + 1, uriAccordo.length());
            IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
            idAccordo.build(tmp1, tmp2);
            return idAccordo;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public static IDAccordoCooperazione getIDAccordoFromAccordo(AccordoCooperazione accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
        idAccordo.build(accordo.getNome(), accordo.getVersione());
        return idAccordo;
    }

    public static IDAccordoCooperazione getIDAccordoFromValues(String nomeAS, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordoCooperazione idAccordo = new IDAccordoCooperazione();
        idAccordo.build(nomeAS, ver);
        return idAccordo;
    }

    public static boolean versioneNonDefinita(String value) {
        return value == null || "".equals(value);
    }
}

