/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.Serializable;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;

public class IDAccordo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nome;
    private IDSoggetto soggettoReferente;
    private String versione;

    public String getNome() {
        return this.nome;
    }

    public IDSoggetto getSoggettoReferente() {
        return this.soggettoReferente;
    }

    public String getVersione() {
        return this.versione;
    }

    @Deprecated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Deprecated
    public void setSoggettoReferente(IDSoggetto soggettoReferente) {
        this.soggettoReferente = soggettoReferente;
    }

    @Deprecated
    public void setVersione(String versione) {
        this.versione = versione;
    }

    private IDAccordo build(String nome, IDSoggetto soggettoReferente, String versione) {
        this.nome = nome;
        this.soggettoReferente = soggettoReferente;
        String v = null;
        if (versione != null && !"".equals(versione)) {
            v = versione;
        }
        this.versione = v;
        return this;
    }

    public String toString() {
        StringBuffer bf = new StringBuffer();
        bf.append(this.nome);
        if (this.versione != null) {
            bf.append("[" + this.versione + "]");
        }
        if (this.soggettoReferente != null) {
            bf.append("[" + this.soggettoReferente.toString() + "]");
        }
        return bf.toString();
    }

    public boolean equals(Object idAS) {
        if (idAS == null) {
            return false;
        }
        if (!idAS.getClass().getName().equals(this.getClass().getName())) {
            return false;
        }
        IDAccordo id = (IDAccordo)idAS;
        return this.toString().equals(id.toString());
    }

    public static String getUriFromIDAccordo(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("IDAccordo non fornito");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("Nome accordo non fornito");
        }
        IDSoggetto soggettoReferente = idAccordo.getSoggettoReferente();
        if (soggettoReferente != null) {
            if (soggettoReferente.getTipo() == null) {
                throw new DriverRegistroServiziException("Tipo soggetto referente non fornito?");
            }
            if (soggettoReferente.getNome() == null) {
                throw new DriverRegistroServiziException("Nome soggetto referente non fornito?");
            }
        }
        if (soggettoReferente != null && idAccordo.getVersione() != null) {
            return soggettoReferente.toString() + ":" + idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        if (idAccordo.getVersione() != null) {
            return idAccordo.getNome() + ":" + idAccordo.getVersione();
        }
        if (soggettoReferente != null) {
            return soggettoReferente.toString() + ":" + idAccordo.getNome();
        }
        return idAccordo.getNome();
    }

    public static String getUriFromAccordo(AccordoServizio accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return IDAccordo.getUriFromIDAccordo(idAccordo);
    }

    public static String getUriFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.build(nomeAS, soggettoReferente, ver);
        return IDAccordo.getUriFromIDAccordo(idAccordo);
    }

    public static String getUriFromValues(String nomeAS, IDSoggetto soggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        if (soggettoReferente == null) {
            return IDAccordo.getUriFromValues(nomeAS, null, null, ver);
        }
        return IDAccordo.getUriFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public static IDAccordo getIDAccordoFromUri(String uriAccordo) throws DriverRegistroServiziException {
        try {
            if (uriAccordo == null) {
                throw new Exception("Uri accordo non fornita");
            }
            int primoMarcatore = uriAccordo.indexOf(":");
            int secondoMarcatore = -1;
            if (primoMarcatore >= 0) {
                secondoMarcatore = uriAccordo.indexOf(":", primoMarcatore + 1);
            }
            int terzoMarcatore = -1;
            if (secondoMarcatore > 0 && (terzoMarcatore = uriAccordo.indexOf(":", secondoMarcatore + 1)) > 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            if (primoMarcatore < 0) {
                IDAccordo idAccordo = new IDAccordo();
                idAccordo.build(uriAccordo, null, null);
                return idAccordo;
            }
            String tmp1 = null;
            String tmp2 = null;
            String tmp3 = null;
            if (primoMarcatore >= 0 && secondoMarcatore > 0) {
                tmp1 = uriAccordo.substring(0, primoMarcatore);
                tmp2 = uriAccordo.substring(primoMarcatore + 1, secondoMarcatore);
                tmp3 = uriAccordo.substring(secondoMarcatore + 1, uriAccordo.length());
                int divisorioSoggettoReferente = tmp1.indexOf("/");
                if (divisorioSoggettoReferente <= 0) {
                    throw new Exception("sintassi del soggetto referente non corretta, l'uri deve essere definita con la seguente forma: tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
                }
                String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
                String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
                IDAccordo idAccordo = new IDAccordo();
                idAccordo.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), tmp3);
                return idAccordo;
            }
            tmp1 = uriAccordo.substring(0, primoMarcatore);
            tmp2 = uriAccordo.substring(primoMarcatore + 1, uriAccordo.length());
            int divisorioSoggettoReferente = tmp1.indexOf("/");
            if (divisorioSoggettoReferente < 0) {
                IDAccordo idAccordo = new IDAccordo();
                idAccordo.build(tmp1, null, tmp2);
                return idAccordo;
            }
            if (divisorioSoggettoReferente == 0) {
                throw new Exception("sintassi non corretta, possibili usi: nomeAccordo  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo  nomeAccordo:versione  tipoSoggettoReferente/nomeSoggettoReferente:nomeAccordo:versione");
            }
            String tipoSoggettoReferente = tmp1.substring(0, divisorioSoggettoReferente);
            String nomeSoggettoReferente = tmp1.substring(divisorioSoggettoReferente + 1, tmp1.length());
            IDAccordo idAccordo = new IDAccordo();
            idAccordo.build(tmp2, new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente), null);
            return idAccordo;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Parsing uriAccordo[" + uriAccordo + "] non riusciuto: " + e.getMessage());
        }
    }

    public static IDAccordo getIDAccordoFromAccordo(AccordoServizio accordo) throws DriverRegistroServiziException {
        if (accordo == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.build(accordo.getNome(), BeanUtilities.getSoggettoReferenteID(accordo.getSoggettoReferente()), accordo.getVersione());
        return idAccordo;
    }

    public static IDAccordo getIDAccordoFromValues(String nomeAS, String tipoSoggettoReferente, String nomeSoggettoReferente, String ver) throws DriverRegistroServiziException {
        if (nomeAS == null) {
            throw new DriverRegistroServiziException("Accordo non fornito");
        }
        IDSoggetto soggettoReferente = null;
        if (tipoSoggettoReferente != null && nomeSoggettoReferente != null) {
            soggettoReferente = new IDSoggetto(tipoSoggettoReferente, nomeSoggettoReferente);
        }
        IDAccordo idAccordo = new IDAccordo();
        idAccordo.build(nomeAS, soggettoReferente, ver);
        return idAccordo;
    }

    public static IDAccordo getIDAccordoFromValues(String nomeAS, IDSoggetto soggettoReferente, String ver) throws DriverRegistroServiziException {
        if (soggettoReferente == null) {
            return IDAccordo.getIDAccordoFromValues(nomeAS, null, null, ver);
        }
        return IDAccordo.getIDAccordoFromValues(nomeAS, soggettoReferente.getTipo(), soggettoReferente.getNome(), ver);
    }

    public static boolean versioneNonDefinita(String value) {
        return value == null || "".equals(value);
    }
}

