/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.utils.ValidatoreXSD;
import org.openspcoop.utils.date.DateManager;

public class DriverRegistroServiziXML
extends BeanUtilities
implements IDriverRegistroServiziGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private IUnmarshallingContext uctx;
    private String registry_path;
    private RegistroServizi registro;
    private ValidatoreXSD validatoreRegistro = null;
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;

    public RegistroServizi getRegistroXML() {
        return this.registro;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parsingXMLRegistroServizi() throws DriverRegistroServiziException {
        block33: {
            FileInputStream fXML = null;
            try {
                try {
                    if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                        this.validatoreRegistro.valida(this.registry_path);
                    } else {
                        fXML = new FileInputStream(this.registry_path);
                        this.validatoreRegistro.valida(fXML);
                    }
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Riscontrato errore durante la validazione XSD del Registro dei Servizi XML di OpenSPCoop: " + e.getMessage());
                }
                Object var4_2 = null;
                if (fXML == null) break block33;
            }
            catch (Throwable throwable) {
                Object var4_3 = null;
                if (fXML == null) throw throwable;
                try {
                    fXML.close();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception e) {}
            fXML.close();
        }
        InputStreamReader iStream = null;
        HttpURLConnection httpConn = null;
        if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
            try {
                URL url = new URL(this.registry_path);
                URLConnection connection = url.openConnection();
                httpConn = (HttpURLConnection)connection;
                httpConn.setRequestMethod("GET");
                httpConn.setDoOutput(true);
                httpConn.setDoInput(true);
                iStream = new InputStreamReader(httpConn.getInputStream());
            }
            catch (Exception e) {
                try {
                    if (iStream != null) {
                        iStream.close();
                    }
                    if (httpConn == null) throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                    httpConn.disconnect();
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
                }
                catch (Exception ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (HTTP) : \n\n" + e.getMessage());
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                iStream = new InputStreamReader(new FileInputStream(this.registry_path));
            }
            catch (FileNotFoundException e) {
                try {
                    if (iStream == null) throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
                    iStream.close();
                    throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la creazione dell'inputStream del registro dei servizi (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.registry_path).lastModified();
            }
            catch (Exception e) {
                try {
                    if (iStream == null) throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del file dove e' allocato il registro dei servizi: " + e.getMessage());
                    iStream.close();
                    throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del file dove e' allocato il registro dei servizi: " + e.getMessage());
                }
                catch (IOException ef) {
                    // empty catch block
                }
                throw new DriverRegistroServiziException("Riscontrato errore durante la lettura del file dove e' allocato il registro dei servizi: " + e.getMessage());
            }
        }
        try {
            this.registro = (RegistroServizi)this.uctx.unmarshalDocument((Reader)iStream, null);
        }
        catch (JiBXException e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
                if (httpConn == null) throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
                httpConn.disconnect();
                throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
            }
            catch (Exception ef) {
                // empty catch block
            }
            throw new DriverRegistroServiziException("Riscontrato errore durante l'unmarshall del file di configurazione  : \n\n" + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
            if (httpConn == null) return;
            httpConn.disconnect();
            return;
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("Riscontrato errore durante la chiusura dell'Input Stream  : \n\n" + e.getMessage());
        }
    }

    public DriverRegistroServiziXML(String path, Logger alog) {
        this.log = alog == null ? Logger.getLogger((String)"Registro Servizi XML") : alog;
        if (path == null) {
            this.log.error((Object)"DriverRegistroServizi: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.registry_path = path;
        try {
            this.validatoreRegistro = new ValidatoreXSD(DriverRegistroServiziXML.class.getResourceAsStream("/registroServizi.xsd"));
        }
        catch (Exception e) {
            this.log.error((Object)("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage()));
            return;
        }
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            this.uctx = bfact.createUnmarshallingContext();
        }
        catch (JiBXException e) {
            this.log.error((Object)("DriverRegistroServizi: Riscontrato errore durante la creazione del contesto di unmarshall  : \n\n" + e.getMessage()));
            this.create = false;
            return;
        }
        try {
            this.parsingXMLRegistroServizi();
        }
        catch (Exception e) {
            this.log.error((Object)("DriverRegistroServizi: " + e.getMessage()));
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshConfigurazioneXML() throws DriverRegistroServiziException {
        this.refreshConfigurazioneXML(true);
    }

    private void refreshConfigurazioneXML() throws DriverRegistroServiziException {
        this.refreshConfigurazioneXML(false);
    }

    private synchronized void refreshConfigurazioneXML(boolean refreshForzato) throws DriverRegistroServiziException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.registry_path.startsWith("http://") || this.registry_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.registry_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLRegistroServizi();
            }
            catch (Exception e) {
                this.log.error((Object)("DriverRegistroServizi refreshError: " + e.getMessage()));
                throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: " + e.getMessage());
            }
            if (!this.registry_path.startsWith("http://") && !this.registry_path.startsWith("file://")) {
                this.log.warn((Object)"Reloaded registry context.");
            }
        }
        if (this.registro == null) {
            this.log.error((Object)"DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
            throw new DriverRegistroServiziException("DriverRegistroServizi refreshError: istanza del registro is null dopo il refresh");
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoCooperazione] Nome accordo non presente");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
            AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
            if (ac.getNome() == null || !ac.getNome().equals(idAccordo.getNome()) || (idAccordo.getVersione() == null ? ac.getVersione() != null : !idAccordo.getVersione().equals(ac.getVersione()))) continue;
            return ac;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoCooperazione] Accordo di Cooperazione non Trovato");
    }

    public IDAccordoCooperazione[] getAllIdAccordiCooperazione(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < this.registro.sizeAccordoCooperazioneList(); ++i) {
                AccordoCooperazione ac = this.registro.getAccordoCooperazione(i);
                String uriAC = IDAccordoCooperazione.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + uriAC + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordoCooperazione.getIDAccordoFromAccordo(ac));
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi di cooperazione non trovati");
            }
            IDAccordoCooperazione[] res = new IDAccordoCooperazione[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    public AccordoServizio getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Nome accordo non presente");
        }
        IDSoggetto soggettoReferenteCheck = idAccordo.getSoggettoReferente();
        if (soggettoReferenteCheck != null) {
            if (soggettoReferenteCheck.getTipo() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizio] Tipo soggetto referente non presente?");
            }
            if (soggettoReferenteCheck.getNome() == null) {
                throw new DriverRegistroServiziException("[getAccordoServizio] Nome soggetto referente non presente?");
            }
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.registro.sizeAccordoServizioList(); ++i) {
            AccordoServizio as = this.registro.getAccordoServizio(i);
            if (as.getNome() == null || !as.getNome().equals(idAccordo.getNome()) || (soggettoReferenteCheck != null ? as.getSoggettoReferente() == null || !soggettoReferenteCheck.getTipo().equals(as.getSoggettoReferente().getTipo()) || !soggettoReferenteCheck.getNome().equals(as.getSoggettoReferente().getNome()) : as.getSoggettoReferente() != null)) continue;
            if (idAccordo.getVersione() == null ? as.getVersione() != null : !idAccordo.getVersione().equals(as.getVersione())) continue;
            as.setNomiAzione(as.readNomiAzione());
            return as;
        }
        throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio non Trovato");
    }

    public IDAccordo[] getAllIdAccordiServizio(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < this.registro.sizeAccordoServizioList(); ++i) {
                AccordoServizio as = this.registro.getAccordoServizio(i);
                String uriAS = IDAccordo.getUriFromAccordo(as);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMinDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMaxDate) Accordo di servizio [" + uriAS + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !as.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !as.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (as.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !as.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordo.getIDAccordoFromAccordo(as));
            }
            if (idAccordi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Accordi non trovati");
            }
            IDAccordo[] res = new IDAccordo[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdAccordiServizio error", e);
        }
    }

    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
            PortaDominio pd = this.registro.getPortaDominio(i);
            if (pd.getNome() == null || !pd.getNome().equals(nomePdD)) continue;
            return pd;
        }
        throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di Dominio non trovata");
    }

    public String[] getAllIdPorteDominio(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<String> nomiPorteDiDominio = new Vector<String>();
            for (int i = 0; i < this.registro.sizePortaDominioList(); ++i) {
                PortaDominio pd = this.registro.getPortaDominio(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMinDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMaxDate) Porta di Dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPorteDiDominio.add(pd.getNome());
            }
            if (nomiPorteDiDominio.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Porte di Dominio non trovate");
            }
            String[] res = new String[1];
            return nomiPorteDiDominio.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    public SoggettoSpcoop getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipoSP = idSoggetto.getTipo();
        String codiceSP = idSoggetto.getNome();
        if (tipoSP == null || codiceSP == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.registro.sizeSoggettoSpcoopList(); ++i) {
            SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(i);
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoSP) || !ss.getNome().equals(codiceSP)) continue;
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non Trovato");
    }

    public IDSoggetto[] getAllIdSoggettiRegistro(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < this.registro.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(i);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome())) continue;
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Soggetti non trovati");
            }
            IDSoggetto[] res = new IDSoggetto[1];
            return idSoggetti.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    public ServizioSpcoop getServizio(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SoggettoSpcoop soggetto = this.getSoggettoRegistro(idService.getSoggettoErogatore());
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri Non Validi");
        }
        for (int i = 0; i < soggetto.sizeServizioList(); ++i) {
            ServizioSpcoop ss = soggetto.getServizio(i);
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoServizio) || !ss.getNome().equals(servizio)) continue;
            ss.setServizioCorrelato(false);
            ss.setTipoSoggettoErogatore(soggetto.getTipo());
            ss.setNomeSoggettoErogatore(soggetto.getNome());
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getServizio] Servizio non Trovato");
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SoggettoSpcoop soggetto = this.getSoggettoRegistro(idService.getSoggettoErogatore());
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri Non Validi");
        }
        for (int i = 0; i < soggetto.sizeServizioCorrelatoList(); ++i) {
            ServizioSpcoop ss = soggetto.getServizioCorrelato(i);
            if (ss.getTipo() == null || ss.getNome() == null || !ss.getTipo().equals(tipoServizio) || !ss.getNome().equals(servizio)) continue;
            ss.setServizioCorrelato(true);
            ss.setTipoSoggettoErogatore(soggetto.getTipo());
            ss.setNomeSoggettoErogatore(soggetto.getNome());
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non Trovato");
    }

    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        SoggettoSpcoop soggetto = this.getSoggettoRegistro(idSoggetto);
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String uriAccordo = IDAccordo.getUriFromIDAccordo(idAccordo);
        for (int i = 0; i < soggetto.sizeServizioCorrelatoList(); ++i) {
            ServizioSpcoop ss = soggetto.getServizioCorrelato(i);
            if (ss.getAccordoServizio() == null || !ss.getAccordoServizio().equals(uriAccordo)) continue;
            ss.setServizioCorrelato(true);
            ss.setTipoSoggettoErogatore(soggetto.getTipo());
            ss.setNomeSoggettoErogatore(soggetto.getNome());
            return ss;
        }
        throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non Trovato");
    }

    public IDServizio[] getAllIdServizi(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < this.registro.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(i);
                if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoErogatore() != null && !ss.getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !ss.getNome().equals(filtroRicerca.getNomeSoggettoErogatore()))) continue;
                IDSoggetto idSoggetto = new IDSoggetto(ss.getTipo(), ss.getNome());
                for (int j = 0; j < ss.sizeServizioList(); ++j) {
                    ServizioSpcoop serv = ss.getServizio(j);
                    if (filtroRicerca != null) {
                        if (filtroRicerca.getMinDate() != null) {
                            if (serv.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMinDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                        }
                        if (filtroRicerca.getMaxDate() != null) {
                            if (serv.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMaxDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                        }
                        if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome())) continue;
                        if (filtroRicerca.getIdAccordo() != null) {
                            String uriAccordo = IDAccordo.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                            if (!serv.getAccordoServizio().equals(uriAccordo)) continue;
                        }
                    }
                    IDServizio idServ = new IDServizio(idSoggetto, serv.getTipo(), serv.getNome());
                    idServ.setUriAccordo(serv.getAccordoServizio());
                    idServ.setCorrelato(false);
                    idServizi.add(idServ);
                }
            }
            if (idServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi non trovati");
            }
            IDServizio[] res = new IDServizio[1];
            return idServizi.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    public IDServizio[] getAllIdServiziCorrelati(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < this.registro.sizeSoggettoSpcoopList(); ++i) {
                SoggettoSpcoop ss = this.registro.getSoggettoSpcoop(i);
                if (filtroRicerca != null && (filtroRicerca.getTipoSoggettoErogatore() != null && !ss.getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !ss.getNome().equals(filtroRicerca.getNomeSoggettoErogatore()))) continue;
                IDSoggetto idSoggetto = new IDSoggetto(ss.getTipo(), ss.getNome());
                for (int j = 0; j < ss.sizeServizioCorrelatoList(); ++j) {
                    ServizioSpcoop serv = ss.getServizioCorrelato(j);
                    if (filtroRicerca != null) {
                        if (filtroRicerca.getMinDate() != null) {
                            if (serv.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMinDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                        }
                        if (filtroRicerca.getMaxDate() != null) {
                            if (serv.getOraRegistrazione() == null) {
                                this.log.debug((Object)("[getAllIdServizi](FiltroByMaxDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                                continue;
                            }
                            if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                        }
                        if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome())) continue;
                        if (filtroRicerca.getIdAccordo() != null) {
                            String uriAccordo = IDAccordo.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                            if (!serv.getAccordoServizio().equals(uriAccordo)) continue;
                        }
                    }
                    IDServizio idServ = new IDServizio(idSoggetto, serv.getTipo(), serv.getNome());
                    idServ.setUriAccordo(serv.getAccordoServizio());
                    idServ.setCorrelato(true);
                    idServizi.add(idServ);
                }
            }
            if (idServizi.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverRegistroServiziNotFound("Servizi Correlati non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverRegistroServiziNotFound("Servizi Correlati non trovati");
            }
            IDServizio[] res = new IDServizio[1];
            return idServizi.toArray(res);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("getAllIdServizi error", e);
        }
    }

    public void isAlive() throws DriverException {
        if (!this.create) {
            throw new DriverException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshConfigurazioneXML();
        }
        catch (Exception e) {
            throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }
}

