/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import javax.xml.rpc.Stub;
import org.apache.log4j.Logger;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.registry.ws.WSRegistryNotFound;
import org.openspcoop.registry.ws.WSRegistrySearch;
import org.openspcoop.registry.ws.WSRegistrySearchException;
import org.openspcoop.registry.ws.WSRegistrySearchServiceLocator;

public class DriverRegistroServiziWS
extends BeanUtilities
implements IDriverRegistroServiziGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private WSRegistrySearch registroWS = null;
    private Logger log = null;

    public DriverRegistroServiziWS(String location, Logger alog) {
        this(location, null, null, alog);
    }

    public DriverRegistroServiziWS(String location, String username, String password, Logger alog) {
        try {
            this.log = alog == null ? Logger.getLogger((String)"Registro Servizi WS") : alog;
            if (location == null) {
                throw new Exception("Location is null");
            }
            WSRegistrySearchServiceLocator locator = new WSRegistrySearchServiceLocator();
            locator.setSearchEndpointAddress(location);
            this.registroWS = locator.getSearch();
            if (username != null && password != null) {
                ((Stub)this.registroWS)._setProperty("javax.xml.rpc.security.auth.username", (Object)username);
                ((Stub)this.registroWS)._setProperty("javax.xml.rpc.security.auth.password", (Object)password);
            }
            this.create = true;
        }
        catch (Exception e) {
            this.log.error((Object)("Inizializzazione fallita: " + e.getMessage()));
            this.create = false;
        }
    }

    public AccordoServizio getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Nome accordo di servizio non presente");
        }
        AccordoServizio accRichiesto = null;
        try {
            accRichiesto = this.registroWS.getAccordoServizio(idAccordo);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio non trovato:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio non trovato.");
        }
        return accRichiesto;
    }

    public IDAccordo[] getAllIdAccordiServizio(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDAccordo[] id = null;
        try {
            id = this.registroWS.getAllIdAccordiServizio(filtroRicerca);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAllIdAccordiServizio] Id Accordi non trovati:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Errore durante la lettura degli id (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Errore durante la lettura degli id: " + e.getMessage(), e);
        }
        if (id == null) {
            throw new DriverRegistroServiziNotFound("[getAllIdAccordiServizio] accordi non trovati.");
        }
        return id;
    }

    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        PortaDominio pddRichiesta = null;
        try {
            pddRichiesta = this.registroWS.getPortaDominio(nomePdD);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio non trovata:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio non trovata.");
        }
        return pddRichiesta;
    }

    public String[] getAllIdPorteDominio(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String[] id = null;
        try {
            id = this.registroWS.getAllIdPorteDominio(filtroRicerca);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAllIdPorteDominio] Id porte di dominio non trovati:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAllIdPorteDominio] Errore durante la lettura degli id (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAllIdPorteDominio] Errore durante la lettura degli id: " + e.getMessage(), e);
        }
        if (id == null) {
            throw new DriverRegistroServiziNotFound("[getAllIdPorteDominio] Porte di dominio non trovate.");
        }
        return id;
    }

    public SoggettoSpcoop getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        String tipo = idSoggetto.getTipo();
        String nome = idSoggetto.getNome();
        if (tipo == null || nome == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametri Non Validi");
        }
        SoggettoSpcoop soggRichiesto = null;
        try {
            soggRichiesto = this.registroWS.getSoggettoSPCoop(idSoggetto);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto non trovato.");
        }
        return soggRichiesto;
    }

    public IDSoggetto[] getAllIdSoggettiRegistro(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDSoggetto[] id = null;
        try {
            id = this.registroWS.getAllIdSoggettiSPCoop(filtroRicerca);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAllIdSoggettiRegistro] Id Soggetti non trovati:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Errore durante la lettura degli id (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Errore durante la lettura degli id: " + e.getMessage(), e);
        }
        if (id == null) {
            throw new DriverRegistroServiziNotFound("[getAllIdSoggettiRegistro] soggetti non trovati.");
        }
        return id;
    }

    public ServizioSpcoop getServizio(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametri (Soggetto) Non Validi");
        }
        ServizioSpcoop servRichiesto = null;
        try {
            servRichiesto = this.registroWS.getServizioSPCoop(idService);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getServizio] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getServizio] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(false);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idService) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idService == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        String servizio = idService.getServizio();
        String tipoServizio = idService.getTipoServizio();
        if (servizio == null || tipoServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Servizio) Non Validi");
        }
        String tipoSogg = idService.getSoggettoErogatore().getTipo();
        String nomeSogg = idService.getSoggettoErogatore().getNome();
        if (tipoSogg == null || nomeSogg == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametri (Soggetto) Non Validi");
        }
        ServizioSpcoop servRichiesto = null;
        try {
            servRichiesto = this.registroWS.getServizioSPCoopCorrelato(idService);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non trovato:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(true);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametro Non Valido");
        }
        String nomeSoggetto = idSoggetto.getNome();
        String tipoSoggetto = idSoggetto.getTipo();
        if (nomeSoggetto == null || tipoSoggetto == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametri (Soggetto) Non Validi");
        }
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Parametri (Accordo) Non Valido");
        }
        ServizioSpcoop servRichiesto = null;
        try {
            servRichiesto = this.registroWS.getServizioSPCoopCorrelatoByAccordo(idSoggetto, idAccordo);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Servizio non trovato:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante la lettura dell'oggetto (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByAccordo] Errore durante la lettura dell'oggetto: " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByAccordo] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(true);
        return servRichiesto;
    }

    public IDServizio[] getAllIdServizi(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDServizio[] id = null;
        try {
            id = this.registroWS.getAllIdServiziSPCoop(filtroRicerca);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAllIdServizi] Id Servizi non trovati:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAllIdServizi] Errore durante la lettura degli id (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAllIdServizi] Errore durante la lettura degli id: " + e.getMessage(), e);
        }
        if (id == null) {
            throw new DriverRegistroServiziNotFound("[getAllIdServizi] servizi non trovati.");
        }
        return id;
    }

    public IDServizio[] getAllIdServiziCorrelati(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        IDServizio[] id = null;
        try {
            id = this.registroWS.getAllIdServiziSPCoopCorrelati(filtroRicerca);
        }
        catch (WSRegistryNotFound e) {
            throw new DriverRegistroServiziNotFound("[getAllIdServiziCorrelati] Id Servizi non trovati:" + e.getMessage());
        }
        catch (WSRegistrySearchException e) {
            throw new DriverRegistroServiziException("[getAllIdServiziCorrelati] Errore durante la lettura degli id (WSRegistrySearchException): " + e.getMessage(), e);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[getAllIdServiziCorrelati] Errore durante la lettura degli id: " + e.getMessage(), e);
        }
        if (id == null) {
            throw new DriverRegistroServiziNotFound("[getAllIdServiziCorrelati] servizi correlati non trovati.");
        }
        return id;
    }

    public void isAlive() throws DriverException {
        if (!this.create) {
            throw new DriverException("Driver non inizializzato");
        }
        try {
            this.registroWS.isAlive();
        }
        catch (Exception e) {
            throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return null;
    }

    public IDAccordoCooperazione[] getAllIdAccordiCooperazione(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return null;
    }
}

