/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop.dao.registry.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.openspcoop.dao.commons.DriverException;
import org.openspcoop.dao.commons.IDSoggetto;
import org.openspcoop.dao.commons.IDriverWS;
import org.openspcoop.dao.commons.IMonitoraggioRisorsa;
import org.openspcoop.dao.registry.AccordoCooperazione;
import org.openspcoop.dao.registry.AccordoServizio;
import org.openspcoop.dao.registry.Fruitore;
import org.openspcoop.dao.registry.PortaDominio;
import org.openspcoop.dao.registry.RegistroServizi;
import org.openspcoop.dao.registry.ServizioSpcoop;
import org.openspcoop.dao.registry.ServizioSpcoopAzione;
import org.openspcoop.dao.registry.ServizioSpcoopAzioneFruitore;
import org.openspcoop.dao.registry.SoggettoSpcoop;
import org.openspcoop.dao.registry.driver.BeanUtilities;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziException;
import org.openspcoop.dao.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop.dao.registry.driver.FiltroAccordiSPCoop;
import org.openspcoop.dao.registry.driver.FiltroSPCoop;
import org.openspcoop.dao.registry.driver.FiltroServiziSPCoop;
import org.openspcoop.dao.registry.driver.IDAccordo;
import org.openspcoop.dao.registry.driver.IDAccordoCooperazione;
import org.openspcoop.dao.registry.driver.IDServizio;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziCRUD;
import org.openspcoop.dao.registry.driver.IDriverRegistroServiziGet;
import org.openspcoop.dao.registry.driver.UDDILib;
import org.openspcoop.dao.registry.driver.XMLLib;
import org.openspcoop.utils.Utilities;
import org.openspcoop.utils.UtilsException;
import org.openspcoop.utils.ValidatoreXSD;

public class DriverRegistroServiziUDDI
extends BeanUtilities
implements IDriverRegistroServiziGet,
IDriverRegistroServiziCRUD,
IDriverWS,
IMonitoraggioRisorsa {
    public boolean create = false;
    private UDDILib uddiLib = null;
    private String urlPrefix;
    private XMLLib generatoreXML;
    private ValidatoreXSD validatoreRegistro = null;
    private Logger log = null;

    public DriverRegistroServiziUDDI(String inquiry, Logger alog) {
        this(inquiry, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String user, String password, Logger alog) {
        this(inquiry, null, user, password, null, null, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String urlPrefix, String pathPrefix, Logger alog) {
        this(inquiry, publish, null, null, urlPrefix, pathPrefix, alog);
    }

    public DriverRegistroServiziUDDI(String inquiry, String publish, String user, String password, String urlPrefix, String pathPrefix, Logger alog) {
        try {
            this.log = alog == null ? Logger.getLogger((String)"Registro Servizi UDDI") : alog;
            this.uddiLib = publish != null ? new UDDILib(inquiry, publish, user, password) : (user != null && password != null ? new UDDILib(inquiry, user, password) : new UDDILib(inquiry));
            try {
                this.validatoreRegistro = new ValidatoreXSD(DriverRegistroServiziUDDI.class.getResourceAsStream("/registroServizi.xsd"));
            }
            catch (Exception e) {
                throw new Exception("Riscontrato errore durante l'inizializzazione dello schema del Registro dei Servizi di OpenSPCoop: " + e.getMessage(), e);
            }
            if (urlPrefix != null && pathPrefix != null) {
                this.urlPrefix = !urlPrefix.endsWith("/") ? urlPrefix + "/" : urlPrefix;
                this.generatoreXML = new XMLLib(pathPrefix, urlPrefix);
            }
            this.create = this.uddiLib.create;
        }
        catch (Exception e) {
            this.log.error((Object)("Inizializzazione fallita: " + e.getMessage()), (Throwable)e);
            this.create = false;
        }
    }

    public AccordoCooperazione getAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoCooperazione accRichiesto = null;
        String urlXMLAccordoCooperazione = this.uddiLib.getUrlXmlAccordoCooperazione(idAccordo);
        if (urlXMLAccordoCooperazione == null) {
            throw new DriverRegistroServiziException("[AccordoCooperazione] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLAccordoCooperazione);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoCooperazione);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[AccordoCooperazione] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoCooperazioneList() > 0) {
                accRichiesto = rs.getAccordoCooperazione(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[AccordoCooperazione] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[AccordoCooperazione] Accordo di Cooperazione [" + idAccordo + "] non trovato.");
        }
        return accRichiesto;
    }

    public IDAccordoCooperazione[] getAllIdAccordiCooperazione(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.urlPrefix == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Implementazione non eseguibile se il driver non viene inizializzato con urlPrefix.");
            }
            IDAccordoCooperazione idAccordoFiltro = null;
            if (filtroRicerca != null) {
                idAccordoFiltro = IDAccordoCooperazione.getIDAccordoFromValues(filtroRicerca.getNomeAccordo(), filtroRicerca.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiCooperazione(idAccordoFiltro, this.urlPrefix);
            Vector<IDAccordoCooperazione> idAccordi = new Vector<IDAccordoCooperazione>();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoCooperazione ac = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = Utilities.requestHTTPFile(urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeAccordoCooperazioneList() > 0) {
                        ac = rs.getAccordoCooperazione(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (ac == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiCooperazione] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String acURI = IDAccordoCooperazione.getUriFromAccordo(ac);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMinDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ac.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiCooperazione](FiltroByMaxDate) Accordo di cooperazione [" + acURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ac.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !ac.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !ac.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (ac.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !ac.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !ac.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordoCooperazione.getIDAccordoFromValues(ac.getNome(), ac.getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDAccordoCooperazione[] res = new IDAccordoCooperazione[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiCooperazione error", e);
        }
    }

    public AccordoServizio getAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idAccordo == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Parametro Non Valido");
        }
        if (idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Nome accordo servizio non fornito");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getAccordoServizio] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo richiesto non esiste: " + idAccordo);
        }
        AccordoServizio accRichiesto = null;
        String urlXMLAccordoServizio = this.uddiLib.getUrlXmlAccordoServizio(idAccordo);
        if (urlXMLAccordoServizio == null) {
            throw new DriverRegistroServiziException("[getAccordoServizio] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLAccordoServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo richiesto non esiste nel repository http: " + idAccordo);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLAccordoServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getAccordoServizio] Riscontrato errore durante la validazione XSD Accordo(" + idAccordo + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeAccordoServizioList() > 0) {
                accRichiesto = rs.getAccordoServizio(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getAccordoServizio] Errore durante il parsing xml Accordo(" + idAccordo + "): " + e.getMessage(), e);
        }
        if (accRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getAccordoServizio] Accordo di Servizio [" + idAccordo + "] non trovato.");
        }
        accRichiesto.setNomiAzione(accRichiesto.readNomiAzione());
        return accRichiesto;
    }

    public IDAccordo[] getAllIdAccordiServizio(FiltroAccordiSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.urlPrefix == null) {
                throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Implementazione non eseguibile se il driver non viene inizializzato con urlPrefix.");
            }
            IDAccordo idAccordoFiltro = null;
            if (filtroRicerca != null) {
                IDSoggetto soggettoReferente = null;
                if (filtroRicerca.getTipoSoggettoReferente() != null && filtroRicerca.getNomeSoggettoReferente() != null) {
                    soggettoReferente = new IDSoggetto(filtroRicerca.getTipoSoggettoReferente(), filtroRicerca.getNomeSoggettoReferente());
                }
                idAccordoFiltro = IDAccordo.getIDAccordoFromValues(filtroRicerca.getNomeAccordo(), soggettoReferente, filtroRicerca.getVersione());
            }
            String[] urlXMLAccordi = this.uddiLib.getUrlXmlAccordiServizio(idAccordoFiltro, this.urlPrefix);
            Vector<IDAccordo> idAccordi = new Vector<IDAccordo>();
            for (int i = 0; i < urlXMLAccordi.length; ++i) {
                AccordoServizio as = null;
                try {
                    this.validatoreRegistro.valida(urlXMLAccordi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Riscontrato errore durante la validazione XSD (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = Utilities.requestHTTPFile(urlXMLAccordi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeAccordoServizioList() > 0) {
                        as = rs.getAccordoServizio(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizio] Errore durante il parsing xml (" + urlXMLAccordi[i] + "): " + e.getMessage(), e);
                }
                if (as == null) {
                    throw new DriverRegistroServiziException("[getAllIdAccordiServizio] accordo non definito per la url [" + urlXMLAccordi[i] + "]");
                }
                String asURI = IDAccordo.getUriFromAccordo(as);
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMinDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (as.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdAccordiServizio](FiltroByMaxDate) Accordo di servizio [" + asURI + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (as.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNomeAccordo() != null && !as.getNome().equals(filtroRicerca.getNomeAccordo()) || filtroRicerca.getVersione() != null && !as.getVersione().equals(filtroRicerca.getVersione()) || (filtroRicerca.getTipoSoggettoReferente() != null || filtroRicerca.getNomeSoggettoReferente() != null) && (as.getSoggettoReferente() == null || filtroRicerca.getTipoSoggettoReferente() != null && !as.getSoggettoReferente().getTipo().equals(filtroRicerca.getTipoSoggettoReferente()) || filtroRicerca.getNomeSoggettoReferente() != null && !as.getSoggettoReferente().getNome().equals(filtroRicerca.getNomeSoggettoReferente()))) continue;
                }
                idAccordi.add(IDAccordo.getIDAccordoFromValues(as.getNome(), BeanUtilities.getSoggettoReferenteID(as.getSoggettoReferente()), as.getVersione()));
            }
            if (idAccordi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Accordi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDAccordo[] res = new IDAccordo[1];
            return idAccordi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdAccordiServizio error", e);
        }
    }

    public PortaDominio getPortaDominio(String nomePdD) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (nomePdD == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getPortaDominio] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsPortaDominio(nomePdD)) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste: " + nomePdD);
        }
        PortaDominio pddRichiesta = null;
        String urlXMLPortaDominio = this.uddiLib.getUrlXmlPortaDominio(nomePdD);
        if (urlXMLPortaDominio == null) {
            throw new DriverRegistroServiziException("[getPortaDominio] definzione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLPortaDominio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio richiesta non esiste nel repository http: " + nomePdD);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLPortaDominio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getPortaDominio] Riscontrato errore durante la validazione XSD della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizePortaDominioList() > 0) {
                pddRichiesta = rs.getPortaDominio(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getPortaDominio] Errore durante il parsing xml della Porta di dominio(" + nomePdD + "): " + e.getMessage(), e);
        }
        if (pddRichiesta == null) {
            throw new DriverRegistroServiziNotFound("[getPortaDominio] Porta di dominio [" + nomePdD + "] non trovata.");
        }
        return pddRichiesta;
    }

    public String[] getAllIdPorteDominio(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            if (this.urlPrefix == null) {
                throw new DriverRegistroServiziException("[getAllIdPorteDominio] Implementazione non eseguibile se il driver non viene inizializzato con urlPrefix.");
            }
            String nomeFiltro = null;
            if (filtroRicerca != null) {
                nomeFiltro = filtroRicerca.getNome();
            }
            String[] urlXMLPdd = this.uddiLib.getUrlXmlPortaDominio(nomeFiltro, this.urlPrefix);
            Vector<String> nomiPdd = new Vector<String>();
            for (int i = 0; i < urlXMLPdd.length; ++i) {
                PortaDominio pd = null;
                try {
                    this.validatoreRegistro.valida(urlXMLPdd[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Riscontrato errore durante la validazione XSD (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = Utilities.requestHTTPFile(urlXMLPdd[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizePortaDominioList() > 0) {
                        pd = rs.getPortaDominio(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] Errore durante il parsing xml (" + urlXMLPdd[i] + "): " + e.getMessage(), e);
                }
                if (pd == null) {
                    throw new DriverRegistroServiziException("[getAllIdPorteDominio] porta di dominio non definita per la url [" + urlXMLPdd[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMinDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdPorteDominio](FiltroByMaxDate) Porta di dominio [" + pd.getNome() + "] non valorizzata nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (pd.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getNome() != null && !pd.getNome().equals(filtroRicerca.getNome())) continue;
                }
                nomiPdd.add(pd.getNome());
            }
            if (nomiPdd.size() == 0) {
                throw new DriverRegistroServiziNotFound("Porte di dominio non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            String[] res = new String[1];
            return nomiPdd.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdPorteDominio error", e);
        }
    }

    public SoggettoSpcoop getSoggettoRegistro(IDSoggetto idSoggetto) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getSoggetto] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Il soggetto [" + idSoggetto.getTipo() + "/" + idSoggetto.getNome() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        SoggettoSpcoop soggRichiesto = null;
        String urlXMLSoggetto = this.uddiLib.getUrlXmlSoggetto(idSoggetto);
        if (urlXMLSoggetto == null) {
            throw new DriverRegistroServiziException("[getSoggetto] Definizione xml non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLSoggetto);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto richiesto non esiste nel repository http: " + idSoggetto);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLSoggetto);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getSoggetto] Riscontrato errore durante la validazione XSD del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0) {
                soggRichiesto = rs.getSoggettoSpcoop(0);
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getSoggetto] Errore durante il parsing xml del soggetto(" + idSoggetto + "): " + e.getMessage(), e);
        }
        if (soggRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getSoggetto] Soggetto [" + idSoggetto + "] non trovato.");
        }
        return soggRichiesto;
    }

    public IDSoggetto[] getAllIdSoggettiRegistro(FiltroSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        try {
            String[] urlXMLSoggetti = this.uddiLib.getUrlXmlSoggetti();
            Vector<IDSoggetto> idSoggetti = new Vector<IDSoggetto>();
            for (int i = 0; i < urlXMLSoggetti.length; ++i) {
                SoggettoSpcoop ss = null;
                try {
                    this.validatoreRegistro.valida(urlXMLSoggetti[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Riscontrato errore durante la validazione XSD (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = Utilities.requestHTTPFile(urlXMLSoggetti[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeSoggettoSpcoopList() > 0) {
                        ss = rs.getSoggettoSpcoop(0);
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] Errore durante il parsing xml (" + urlXMLSoggetti[i] + "): " + e.getMessage(), e);
                }
                if (ss == null) {
                    throw new DriverRegistroServiziException("[getAllIdSoggettiRegistro] soggetto non definito per la url [" + urlXMLSoggetti[i] + "]");
                }
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMinDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (ss.getOraRegistrazione() == null) {
                            this.log.debug((Object)("[getAllIdSoggettiRegistro](FiltroByMaxDate) Soggetto [" + ss.getTipo() + "/" + ss.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                            continue;
                        }
                        if (ss.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipo() != null && !ss.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !ss.getNome().equals(filtroRicerca.getNome())) continue;
                }
                IDSoggetto idS = new IDSoggetto(ss.getTipo(), ss.getNome());
                idSoggetti.add(idS);
            }
            if (idSoggetti.size() == 0) {
                throw new DriverRegistroServiziNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDSoggetto[] res = new IDSoggetto[1];
            return idSoggetti.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("getAllIdSoggettiRegistro error", e);
        }
    }

    public ServizioSpcoop getServizio(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio == null || idServizio.getSoggettoErogatore() == null) {
            throw new DriverRegistroServiziException("[getServizio] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getServizio] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idServizio.getSoggettoErogatore())) {
            throw new DriverRegistroServiziNotFound("[getServizio] Il soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        if (!this.uddiLib.existsServizio(idServizio)) {
            throw new DriverRegistroServiziNotFound("[getServizio] Il servizio [" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + "] erogato dal soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
        }
        ServizioSpcoop servRichiesto = null;
        String urlXMLServizio = this.uddiLib.getUrlXmlServizio(idServizio);
        if (urlXMLServizio == null) {
            throw new DriverRegistroServiziException("[getServizio] Definizione XML non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizio] Servizio richiesto non esiste nel repository http: " + idServizio);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getServizio] Riscontrato errore durante la validazione XSD del servizio(" + idServizio + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioList() > 0) {
                servRichiesto = rs.getSoggettoSpcoop(0).getServizio(0);
                servRichiesto.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizio] Errore durante il parsing xml del servizio(" + idServizio + "): " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizio] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(false);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDServizio idServizio) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idServizio.getSoggettoErogatore())) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Il soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' inserito nel registro dei servizi.");
        }
        if (!this.uddiLib.existsServizio(idServizio)) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Il servizio [" + idServizio.getTipoServizio() + "/" + idServizio.getServizio() + "] erogato dal soggetto [" + idServizio.getSoggettoErogatore() + "] non risulta gia' registrato nel registro");
        }
        ServizioSpcoop servRichiesto = null;
        String urlXMLServizio = this.uddiLib.getUrlXmlServizio(idServizio);
        if (urlXMLServizio == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelato] Definizione xml non disponibile");
        }
        ByteArrayInputStream bin = null;
        InputStreamReader istr = null;
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            byte[] fileXML = null;
            try {
                fileXML = Utilities.requestHTTPFile(urlXMLServizio);
            }
            catch (UtilsException e) {
                if ("404".equals(e.getMessage())) {
                    throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio richiesto non esiste nel repository http: " + idServizio);
                }
                throw e;
            }
            try {
                this.validatoreRegistro.valida(urlXMLServizio);
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[getServizioCorrelato] Riscontrato errore durante la validazione XSD del servizio(" + idServizio + "): " + e.getMessage(), e);
            }
            bin = new ByteArrayInputStream(fileXML);
            istr = new InputStreamReader(bin);
            RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
            if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioCorrelatoList() > 0) {
                servRichiesto = rs.getSoggettoSpcoop(0).getServizioCorrelato(0);
                servRichiesto.setNomeSoggettoErogatore(idServizio.getSoggettoErogatore().getNome());
                servRichiesto.setTipoSoggettoErogatore(idServizio.getSoggettoErogatore().getTipo());
            }
            istr.close();
            bin.close();
        }
        catch (Exception e) {
            try {
                if (istr != null) {
                    istr.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception eis) {
                // empty catch block
            }
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException("[getServizioCorrelato] Errore durante il parsing xml del servizio(" + idServizio + "): " + e.getMessage(), e);
        }
        if (servRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelato] Servizio non trovato.");
        }
        servRichiesto.setServizioCorrelato(true);
        return servRichiesto;
    }

    public ServizioSpcoop getServizioCorrelato(IDSoggetto idSoggetto, IDAccordo idAccordo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        if (idSoggetto == null || idAccordo == null || idAccordo.getNome() == null) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByNomeAccordo] Parametro Non Valido");
        }
        if (!this.uddiLib.create) {
            throw new DriverRegistroServiziException("[getServizioCorrelatoByNomeAccordo] Inizializzazione dell'engine UDDI errata");
        }
        if (!this.uddiLib.existsSoggetto(idSoggetto)) {
            throw new DriverRegistroServiziNotFound("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
        }
        String[] url = this.uddiLib.getUrlXmlServizi(idSoggetto, idAccordo);
        if (url == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByNomeAccordo] Servizi correlati che rispettano il parametri di ricerca, non esistenti.");
        }
        ServizioSpcoop servCorrelatoRichiesto = null;
        for (int i = 0; i < url.length; ++i) {
            ByteArrayInputStream bin = null;
            InputStreamReader istr = null;
            try {
                IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                byte[] fileXML = null;
                try {
                    fileXML = Utilities.requestHTTPFile(url[i]);
                }
                catch (UtilsException e) {
                    if ("404".equals(e.getMessage())) {
                        throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByNomeAccordo] Servizio richiesto non esiste nel repository http, accordo:" + idAccordo + " e soggetto:" + idSoggetto);
                    }
                    throw e;
                }
                try {
                    this.validatoreRegistro.valida(url[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[getServizioCorrelatoByNomeAccordo] Riscontrato errore durante la validazione XSD del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
                }
                bin = new ByteArrayInputStream(fileXML);
                istr = new InputStreamReader(bin);
                RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioCorrelatoList() > 0) {
                    servCorrelatoRichiesto = rs.getSoggettoSpcoop(0).getServizioCorrelato(0);
                    servCorrelatoRichiesto.setNomeSoggettoErogatore(idSoggetto.getNome());
                    servCorrelatoRichiesto.setTipoSoggettoErogatore(idSoggetto.getTipo());
                }
                istr.close();
                bin.close();
                if (servCorrelatoRichiesto == null) continue;
                break;
            }
            catch (Exception e) {
                try {
                    if (istr != null) {
                        istr.close();
                    }
                }
                catch (Exception eis) {
                    // empty catch block
                }
                try {
                    if (bin != null) {
                        bin.close();
                    }
                }
                catch (Exception eis) {
                    // empty catch block
                }
                if (e instanceof DriverRegistroServiziNotFound) {
                    throw (DriverRegistroServiziNotFound)e;
                }
                throw new DriverRegistroServiziException("[getServizioCorrelatoByNomeAccordo] Errore durante il parsing xml del servizioUrl(" + url[i] + "): " + e.getMessage(), e);
            }
        }
        if (servCorrelatoRichiesto == null) {
            throw new DriverRegistroServiziNotFound("[getServizioCorrelatoByNomeAccordo] Servizio non trovato.");
        }
        servCorrelatoRichiesto.setServizioCorrelato(true);
        return servCorrelatoRichiesto;
    }

    public IDServizio[] getAllIdServizi(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(false, filtroRicerca);
    }

    public IDServizio[] getAllIdServiziCorrelati(FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        return this.getAllIdServizi(true, filtroRicerca);
    }

    private IDServizio[] getAllIdServizi(boolean serviziCorrelati, FiltroServiziSPCoop filtroRicerca) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        String operazione = null;
        operazione = serviziCorrelati ? "getAllIdServiziCorrelati" : "getAllIdServizi";
        try {
            IDAccordo idAccordo = null;
            IDSoggetto soggettoErogatore = null;
            String tipoServizio = null;
            String nomeServizio = null;
            if (filtroRicerca != null) {
                idAccordo = filtroRicerca.getIdAccordo();
                if (filtroRicerca.getTipoSoggettoErogatore() != null && filtroRicerca.getNomeSoggettoErogatore() != null) {
                    soggettoErogatore = new IDSoggetto(filtroRicerca.getTipoSoggettoErogatore(), filtroRicerca.getNomeSoggettoErogatore());
                }
                tipoServizio = filtroRicerca.getTipo();
                nomeServizio = filtroRicerca.getNome();
            }
            String[] urlXMLServizi = this.uddiLib.getUrlXMLServiziBySearch(idAccordo, soggettoErogatore, tipoServizio, nomeServizio);
            Vector<IDServizio> idServizi = new Vector<IDServizio>();
            for (int i = 0; i < urlXMLServizi.length; ++i) {
                ServizioSpcoop serv = null;
                try {
                    this.validatoreRegistro.valida(urlXMLServizi[i]);
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("[" + operazione + "] Riscontrato errore durante la validazione XSD URL(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                ByteArrayInputStream bin = null;
                InputStreamReader istr = null;
                try {
                    IBindingFactory bfact = BindingDirectory.getFactory(RegistroServizi.class);
                    IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
                    byte[] fileXML = Utilities.requestHTTPFile(urlXMLServizi[i]);
                    bin = new ByteArrayInputStream(fileXML);
                    istr = new InputStreamReader(bin);
                    RegistroServizi rs = (RegistroServizi)uctx.unmarshalDocument((Reader)istr, null);
                    if (rs.sizeSoggettoSpcoopList() > 0 && rs.getSoggettoSpcoop(0).sizeServizioList() > 0) {
                        SoggettoSpcoop s = rs.getSoggettoSpcoop(0);
                        if (serviziCorrelati) {
                            if (s.sizeServizioCorrelatoList() <= 0) continue;
                            serv = s.getServizioCorrelato(0);
                            serv.setNomeSoggettoErogatore(s.getNome());
                            serv.setTipoSoggettoErogatore(s.getTipo());
                        } else {
                            if (s.sizeServizioList() <= 0) continue;
                            serv = s.getServizio(0);
                            serv.setNomeSoggettoErogatore(s.getNome());
                            serv.setTipoSoggettoErogatore(s.getTipo());
                        }
                    }
                    istr.close();
                    bin.close();
                }
                catch (Exception e) {
                    try {
                        if (istr != null) {
                            istr.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    try {
                        if (bin != null) {
                            bin.close();
                        }
                    }
                    catch (Exception eis) {
                        // empty catch block
                    }
                    throw new DriverRegistroServiziException("[" + operazione + "] Errore durante il parsing xml del servizio(" + urlXMLServizi[i] + "): " + e.getMessage(), e);
                }
                if (serv == null) {
                    throw new DriverRegistroServiziException("[" + operazione + "] servizio non definito per la url [" + urlXMLServizi[i] + "]");
                }
                if (filtroRicerca == null || filtroRicerca.getTipoSoggettoErogatore() != null && !serv.getTipoSoggettoErogatore().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && !serv.getNomeSoggettoErogatore().equals(filtroRicerca.getNomeSoggettoErogatore())) continue;
                if (filtroRicerca.getMinDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug((Object)("[" + operazione + "](FiltroByMinDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + serv.getTipoSoggettoErogatore() + "/" + serv.getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (serv.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (serv.getOraRegistrazione() == null) {
                        this.log.debug((Object)("[" + operazione + "](FiltroByMaxDate) Servizio[" + serv.getTipo() + "/" + serv.getNome() + "] SoggettoErogatore[" + serv.getTipoSoggettoErogatore() + "/" + serv.getNomeSoggettoErogatore() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata."));
                        continue;
                    }
                    if (serv.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !serv.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !serv.getNome().equals(filtroRicerca.getNome())) continue;
                if (filtroRicerca.getIdAccordo() != null) {
                    String uriAccordo = IDAccordo.getUriFromIDAccordo(filtroRicerca.getIdAccordo());
                    if (!serv.getAccordoServizio().equals(uriAccordo)) continue;
                }
                IDServizio idServ = new IDServizio(serv.getTipoSoggettoErogatore(), serv.getNomeSoggettoErogatore(), serv.getTipo(), serv.getNome());
                idServ.setUriAccordo(serv.getAccordoServizio());
                idServ.setCorrelato(serviziCorrelati);
                idServizi.add(idServ);
            }
            if (idServizi.size() == 0) {
                throw new DriverRegistroServiziNotFound("Servizi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            IDServizio[] res = new IDServizio[1];
            return idServizi.toArray(res);
        }
        catch (Exception e) {
            if (e instanceof DriverRegistroServiziNotFound) {
                throw (DriverRegistroServiziNotFound)e;
            }
            throw new DriverRegistroServiziException(operazione + " error", e);
        }
    }

    public void createAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordo, accordoCooperazione);
            String urlXML = this.urlPrefix + "accordi_cooperazione" + "/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione)) + ".xml";
            this.uddiLib.createAccordoCooperazione(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoCooperazione] Errore generatosi durante la creazione di un nuovo accordo di cooperazione [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsAccordoCooperazione] Accordo non trovato: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void updateAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordoOLD = null;
        idAccordoOLD = accordoCooperazione.getOldIDAccordoForUpdate() != null ? accordoCooperazione.getOldIDAccordoForUpdate() : IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da modificare non definito");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordoCooperazione idAccordoNEW = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoCooperazione(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoCooperazione(idAccordoOLD, accordoCooperazione);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi_cooperazione" + "/" + this.generatoreXML.mappingIDAccordoCooperazioneToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoCooperazione(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoCooperazione] Errore generatosi durante la modifica dell'accordo di cooperazione [" + idAccordoOLD + "]: " + e);
        }
    }

    public void deleteAccordoCooperazione(AccordoCooperazione accordoCooperazione) throws DriverRegistroServiziException {
        if (accordoCooperazione == null) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Parametro Non Valido");
        }
        IDAccordoCooperazione idAccordo = null;
        try {
            idAccordo = IDAccordoCooperazione.getIDAccordoFromAccordo(accordoCooperazione);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoCooperazione.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo Cooperazione da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoCooperazione(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di cooperazione [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoCooperazione(idAccordo);
            this.uddiLib.deleteAccordoCooperazione(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoCooperazione] Errore generatosi durante l'eliminazione dell'accordo di cooperazione [" + IDAccordoCooperazione.getUriFromAccordo(accordoCooperazione) + "]: " + e.getMessage(), e);
        }
    }

    public void createAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[createAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop non completamente definito nei parametri obbligatori");
            }
            if (this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizio(idAccordo, accordoServizio);
            String urlXML = this.urlPrefix + "accordi" + "/" + this.generatoreXML.mappingIDAccordoToFileName(IDAccordo.getIDAccordoFromAccordo(accordoServizio)) + ".xml";
            this.uddiLib.createAccordoServizio(idAccordo, urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createAccordoServizio] Errore generatosi durante la creazione di un nuovo accordo di servizio [" + idAccordo + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsAccordoServizio(IDAccordo idAccordo) throws DriverRegistroServiziException {
        if (idAccordo == null) {
            return false;
        }
        if (idAccordo.getNome() == null) {
            return false;
        }
        try {
            return this.uddiLib.existsAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsAccordoServizio] Accordo non trovato: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void updateAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[updateAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordoOLD = null;
        idAccordoOLD = accordoServizio.getOldIDAccordoForUpdate() != null ? accordoServizio.getOldIDAccordoForUpdate() : IDAccordo.getIDAccordoFromAccordo(accordoServizio);
        try {
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop da modificare non definito");
            }
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (idAccordoOLD == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop da modificare non definito");
            }
            if (accordoServizio.getNome() == null || accordoServizio.getProfiloCollaborazione() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop modificato non completamente definito nei parametri obbligatori");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordoOLD)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoOLD + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDAccordo idAccordoNEW = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW) && this.uddiLib.existsAccordoServizio(idAccordoNEW)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordoNEW + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createAccordoServizio(idAccordoOLD, accordoServizio);
            if (!idAccordoOLD.equals(idAccordoNEW)) {
                String urlXML = this.urlPrefix + "accordi" + "/" + this.generatoreXML.mappingIDAccordoToFileName(idAccordoNEW) + ".xml";
                this.uddiLib.updateAccordoServizio(idAccordoOLD, idAccordoNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateAccordoServizio] Errore generatosi durante la modifica dell'accordo di servizio [" + idAccordoOLD + "]: " + e);
        }
    }

    public void deleteAccordoServizio(AccordoServizio accordoServizio) throws DriverRegistroServiziException {
        if (accordoServizio == null) {
            throw new DriverRegistroServiziException("[deleteAccordoServizio] Parametro Non Valido");
        }
        IDAccordo idAccordo = null;
        try {
            idAccordo = IDAccordo.getIDAccordoFromAccordo(accordoServizio);
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (accordoServizio.getNome() == null) {
                throw new DriverRegistroServiziException("Accordo SPCoop da eliminare non definito");
            }
            if (!this.uddiLib.existsAccordoServizio(idAccordo)) {
                throw new DriverRegistroServiziException("L'accordo di servizio [" + idAccordo + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteAccordoServizio(idAccordo);
            this.uddiLib.deleteAccordoServizio(idAccordo);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteAccordoServizio] Errore generatosi durante l'eliminazione dell'accordo di servizio [" + IDAccordo.getUriFromAccordo(accordoServizio) + "]: " + e.getMessage(), e);
        }
    }

    public void createPortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[createPortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio non completamente definita nei parametri obbligatori");
            }
            if (this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pdd.getNome(), pdd);
            String urlXML = this.urlPrefix + "porte_di_dominio" + "/" + pdd.getNome() + ".xml";
            this.uddiLib.createPortaDominio(pdd.getNome(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createPortaDominio] Errore generatosi durante la creazione di una nuova porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsPortaDominio(String nome) throws DriverRegistroServiziException {
        if (nome == null) {
            return false;
        }
        try {
            return this.uddiLib.existsPortaDominio(nome);
        }
        catch (Exception e) {
            this.log.error((Object)("[existsPortaDominio] Porta di dominio non trovata: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    public void updatePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Parametro Non Valido");
        }
        String pddOLD = null;
        if (pddOLD == null) {
            pddOLD = pdd.getNome();
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pddOLD == null) {
                throw new DriverRegistroServiziException("Porta di dominio da modificare non definito");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio modificata non completamente definita nei parametri obbligatori");
            }
            if (!this.uddiLib.existsPortaDominio(pddOLD)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddOLD + "] non risulta gia' inserita nel registro dei servizi.");
            }
            String pddNEW = pdd.getNome();
            if (!pddOLD.equals(pddNEW) && this.uddiLib.existsPortaDominio(pddNEW)) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pddNEW + "] risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.createPortaDominio(pddOLD, pdd);
            if (!pddOLD.equals(pddNEW)) {
                String urlXML = this.urlPrefix + "porte_di_dominio" + "/" + pddNEW + ".xml";
                this.uddiLib.updatePortaDominio(pddOLD, pddNEW, urlXML);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updatePortaDominio] Errore generatosi durante la modifica della porta di dominio [" + pddOLD + "]: " + e);
        }
    }

    public void deletePortaDominio(PortaDominio pdd) throws DriverRegistroServiziException {
        if (pdd == null) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (pdd.getNome() == null) {
                throw new DriverRegistroServiziException("Porta di dominio da eliminare non definito");
            }
            if (!this.uddiLib.existsPortaDominio(pdd.getNome())) {
                throw new DriverRegistroServiziException("La porta di dominio [" + pdd.getNome() + "] non risulta gia' inserita nel registro dei servizi.");
            }
            this.generatoreXML.deletePortaDominio(pdd.getNome());
            this.uddiLib.deletePortaDominio(pdd.getNome());
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deletePortaDominio] Errore generatosi durante l'eliminazione della porta di dominio [" + pdd.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public void createSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[createSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop non definito");
            }
            if (soggetto.getConnettore() != null && !"disabilitato".equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto SPCoop " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            String idSoggetto_string = soggetto.getTipo() + soggetto.getNome();
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] risulta gia' inserito nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggetto_string + "/" + idSoggetto_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggetto, soggetto);
            this.uddiLib.createSoggetto(idSoggetto, soggetto.getDescrizione(), urlXML);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[createSoggetto] Errore generatosi durante la creazione del nuovo Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public boolean existsSoggetto(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        if (idSoggetto == null) {
            return false;
        }
        try {
            return this.uddiLib.existsSoggetto(idSoggetto);
        }
        catch (Exception e) {
            return false;
        }
    }

    public void updateSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[updateSoggetto] Parametro Non Valido");
        }
        String tipoOLD = soggetto.getOldTipoForUpdate();
        String nomeOLD = soggetto.getOldNomeForUpdate();
        if (tipoOLD == null || nomeOLD == null) {
            tipoOLD = soggetto.getTipo();
            nomeOLD = soggetto.getNome();
        }
        String idSoggettoOLD_string = tipoOLD + nomeOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoOLD, nomeOLD);
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoOLD == null || nomeOLD == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da modificare non definito");
            }
            if (soggetto.getNome() == null || soggetto.getTipo() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop modificato non definito");
            }
            if (soggetto.getConnettore() != null && !"disabilitato".equals(soggetto.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (soggetto.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del soggetto non corretta");
                }
            }
            if (soggetto.getIdentificativoPorta() == null || "".equals(soggetto.getIdentificativoPorta())) {
                soggetto.setIdentificativoPorta(soggetto.getNome() + "SPCoopIT");
            }
            if (soggetto.getDescrizione() == null || "".equals(soggetto.getDescrizione())) {
                soggetto.setDescrizione("Soggetto SPCoop " + soggetto.getTipo() + "/" + soggetto.getNome());
            }
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = soggetto.getTipo() + soggetto.getNome();
            IDSoggetto idSoggettoNEW = new IDSoggetto(soggetto.getTipo(), soggetto.getNome());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("La nuova identita da associare al soggetto [" + idSoggettoNEW_string + "] risulta gia' utilizzata nel registro dei servizi.");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/" + idSoggettoNEW_string + ".xml";
            this.generatoreXML.createSoggetto(idSoggettoOLD, soggetto);
            this.uddiLib.updateIdentificativoPortaSoggetto(idSoggettoOLD, soggetto.getIdentificativoPorta());
            this.uddiLib.updateDescrizioneSoggetto(idSoggettoOLD, soggetto.getDescrizione());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.uddiLib.updateUrlXmlSoggetto(idSoggettoOLD, urlXML);
                this.uddiLib.updateIdSoggetto(idSoggettoOLD, idSoggettoNEW);
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[updateSoggetto] Errore generatosi durante la modifica del Soggetto [" + idSoggettoOLD + "]: " + e.getMessage(), e);
        }
    }

    public void deleteSoggetto(SoggettoSpcoop soggetto) throws DriverRegistroServiziException {
        if (soggetto == null) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Parametro Non Valido");
        }
        try {
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (soggetto.getTipo() == null || soggetto.getNome() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(soggetto.getTipo(), soggetto.getNome(), soggetto.getIdentificativoPorta());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto + "] non risulta gia' inserito nel registro dei servizi.");
            }
            this.generatoreXML.deleteSoggetto(idSoggetto);
            this.uddiLib.deleteSoggetto(idSoggetto);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[deleteSoggetto] Errore generatosi durante l'eliminazione del Soggetto [" + soggetto.getTipo() + soggetto.getNome() + "]: " + e.getMessage(), e);
        }
    }

    public void createServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.createServizio_engine(servizio);
    }

    public boolean existsServizioSpcoop(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.existsServizio_engine(idServizio, false);
    }

    public void updateServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.updateServizio_engine(servizio);
    }

    public void deleteServizioSpcoop(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        servizio.setServizioCorrelato(false);
        this.deleteServizio_engine(servizio);
    }

    public void createServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.createServizio_engine(servizioCorrelato);
    }

    public boolean existsServizioSpcoopCorrelato(IDServizio idServizio) throws DriverRegistroServiziException {
        return this.existsServizio_engine(idServizio, true);
    }

    public void updateServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.updateServizio_engine(servizioCorrelato);
    }

    public void deleteServizioSpcoopCorrelato(ServizioSpcoop servizioCorrelato) throws DriverRegistroServiziException {
        servizioCorrelato.setServizioCorrelato(true);
        this.deleteServizio_engine(servizioCorrelato);
    }

    private void createServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "createServizio";
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        if (servizio == null) {
            throw new DriverRegistroServiziException("[" + method + "] Parametro Non Valido");
        }
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (servizio.getNomeSoggettoErogatore() == null || servizio.getTipoSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop, erogatore del servizio, non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Servizio SPCoop, non definito");
            }
            if (servizio.getAccordoServizio() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !"disabilitato".equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore checkFr = servizio.getFruitore(i);
                if (checkFr.getNome() == null || checkFr.getTipo() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
                }
                String idSoggettoFruitore_string = checkFr.getTipo() + checkFr.getNome();
                IDSoggetto idSoggettoFruitore = new IDSoggetto(checkFr.getTipo(), checkFr.getNome());
                if (this.uddiLib.existsSoggetto(idSoggettoFruitore)) continue;
                throw new DriverRegistroServiziException("Il fruitore [" + idSoggettoFruitore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            for (i = 0; i < servizio.sizeAzioneList(); ++i) {
                ServizioSpcoopAzione checkAz = servizio.getAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un azione senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !"disabilitato".equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeFruitoreList(); ++j) {
                    ServizioSpcoopAzioneFruitore checkAzFr = checkAz.getFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getTipo() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || "disabilitato".equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            IDSoggetto idSoggettoErogatore = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            String idSoggettoErogatore_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            if (!this.uddiLib.existsSoggetto(idSoggettoErogatore)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoErogatore_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            String idServizio_string = servizio.getTipo() + servizio.getNome();
            IDServizio idServizio = new IDServizio(idSoggettoErogatore, servizio.getTipo(), servizio.getNome());
            if (this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggettoErogatore_string + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoErogatore_string + "/" + "servizi" + "/" + idServizio_string + ".xml";
            this.generatoreXML.createServizio(idServizio, servizio);
            this.uddiLib.createServizio(idServizio, urlXML, IDAccordo.getIDAccordoFromUri(servizio.getAccordoServizio()));
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante la creazione del nuovo Servizio [" + servizio.getTipo() + servizio.getNome() + "] erogato dal soggetto [" + servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore() + "]: " + e.getMessage(), e);
        }
    }

    private boolean existsServizio_engine(IDServizio idServizio, boolean isServizioCorrelato) {
        String method = "existsServizio";
        if (isServizioCorrelato) {
            method = method + "Correlato";
        }
        if (idServizio == null) {
            return false;
        }
        try {
            if (isServizioCorrelato) {
                this.getServizioCorrelato(idServizio);
            } else {
                this.getServizio(idServizio);
            }
            return true;
        }
        catch (DriverRegistroServiziNotFound de) {
            return false;
        }
        catch (Exception e) {
            this.log.error((Object)("[" + method + "] Servizio non trovato: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }

    private void updateServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "updateServizio";
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        if (servizio == null) {
            throw new DriverRegistroServiziException("[" + method + "] Parametro Non Valido");
        }
        String tipoServizioOLD = servizio.getOldTipoForUpdate();
        String nomeServizioOLD = servizio.getOldNomeForUpdate();
        if (tipoServizioOLD == null || nomeServizioOLD == null) {
            tipoServizioOLD = servizio.getTipo();
            nomeServizioOLD = servizio.getNome();
        }
        String tipoSoggettoOLD = servizio.getOldTipoSoggettoErogatoreForUpdate();
        String nomeSoggettoOLD = servizio.getOldNomeSoggettoErogatoreForUpdate();
        if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
            tipoSoggettoOLD = servizio.getTipoSoggettoErogatore();
            nomeSoggettoOLD = servizio.getNomeSoggettoErogatore();
        }
        String idSoggettoOLD_string = tipoSoggettoOLD + nomeSoggettoOLD;
        IDSoggetto idSoggettoOLD = new IDSoggetto(tipoSoggettoOLD, nomeSoggettoOLD);
        String idServizioOLD_string = tipoServizioOLD + nomeServizioOLD;
        IDServizio idServizioOLD = new IDServizio(idSoggettoOLD, tipoServizioOLD, nomeServizioOLD);
        try {
            int i;
            if (!this.uddiLib.create) {
                throw new DriverRegistroServiziException("Inizializzazione dell'engine UDDI errata");
            }
            if (tipoSoggettoOLD == null || nomeSoggettoOLD == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop da modificare, erogatore del servizio, non definito");
            }
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop, erogatore del servizio, non definito");
            }
            if (tipoServizioOLD == null || nomeServizioOLD == null) {
                throw new DriverRegistroServiziException("Servizio da modificare non definito");
            }
            if (servizio.getNome() == null || servizio.getTipo() == null) {
                throw new DriverRegistroServiziException("Dati del nuovo servizio SPCoop, non definiti");
            }
            if (servizio.getAccordoServizio() == null) {
                throw new DriverRegistroServiziException("Accordo di Servizio, da associare al servizio, non definito");
            }
            if (servizio.getConnettore() != null && !"disabilitato".equals(servizio.getConnettore().getTipo())) {
                boolean connettoreNonDefinito = false;
                if (servizio.getConnettore().getTipo() == null) {
                    connettoreNonDefinito = true;
                }
                if (connettoreNonDefinito) {
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del dominio del servizio non corretta");
                }
            }
            for (i = 0; i < servizio.sizeFruitoreList(); ++i) {
                Fruitore checkFr = servizio.getFruitore(i);
                if (checkFr.getNome() != null && checkFr.getTipo() != null) continue;
                throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o tipo");
            }
            for (i = 0; i < servizio.sizeAzioneList(); ++i) {
                ServizioSpcoopAzione checkAz = servizio.getAzione(i);
                if (checkAz.getNome() == null || checkAz.getConnettore() == null) {
                    throw new DriverRegistroServiziException("Definizione di un fruitore senza nome o connettore");
                }
                if (checkAz.getConnettore() != null && !"disabilitato".equals(checkAz.getConnettore().getTipo())) {
                    boolean connettoreNonDefinito = false;
                    if (checkAz.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (connettoreNonDefinito) {
                        throw new DriverRegistroServiziException("Definizione del punto di accesso dell'azione " + checkAz.getNome() + " del servizio non corretta");
                    }
                }
                for (int j = 0; j < checkAz.sizeFruitoreList(); ++j) {
                    ServizioSpcoopAzioneFruitore checkAzFr = checkAz.getFruitore(j);
                    if (checkAzFr.getNome() == null || checkAzFr.getNome() == null || checkAzFr.getConnettore() == null) {
                        throw new DriverRegistroServiziException("Definizione di un fruitore di una azione senza nome/tipo o connettore");
                    }
                    if (checkAzFr.getConnettore() == null || "disabilitato".equals(checkAzFr.getConnettore().getTipo())) continue;
                    boolean connettoreNonDefinito = false;
                    if (checkAzFr.getConnettore().getTipo() == null) {
                        connettoreNonDefinito = true;
                    }
                    if (!connettoreNonDefinito) continue;
                    throw new DriverRegistroServiziException("Definizione del punto di accesso del fruitore " + checkAzFr.getTipo() + checkAzFr.getNome() + " dell'azione " + checkAz.getNome() + " del servizio non corretta");
                }
            }
            if (!this.uddiLib.existsSoggetto(idSoggettoOLD)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoOLD_string + "] da modificare, non risulta gia' inserito nel registro dei servizi.");
            }
            String idSoggettoNEW_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
            IDSoggetto idSoggettoNEW = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!idSoggettoOLD_string.equals(idSoggettoNEW_string) && !this.uddiLib.existsSoggetto(idSoggettoNEW)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggettoNEW_string + "] a cui re-assegnare il servizio, non risulta gia' inserito nel registro dei servizi.");
            }
            if (!this.uddiLib.existsServizio(idServizioOLD)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "] non risulta gia' registrato nel registro");
            }
            IDServizio idServizioNEW = new IDServizio(idSoggettoNEW, servizio.getTipo(), servizio.getNome());
            String idServizioNEW_string = servizio.getTipo() + servizio.getNome();
            if (!idServizioOLD_string.equals(idServizioNEW_string) && this.uddiLib.existsServizio(idServizioNEW)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizioNEW_string + "] erogato dal soggetto [" + idSoggettoNEW_string + "] risulta gia' registrato nel registro");
            }
            String urlXML = this.urlPrefix + idSoggettoNEW_string + "/" + "servizi" + "/" + idServizioNEW_string + ".xml";
            if (idSoggettoOLD_string.equals(idSoggettoNEW_string)) {
                this.generatoreXML.createServizio(idServizioOLD, servizio);
                this.uddiLib.updateAccordoServizio(idServizioOLD, IDAccordo.getIDAccordoFromUri(servizio.getAccordoServizio()));
                this.uddiLib.updateUrlXmlServizio(idServizioOLD, urlXML);
                this.uddiLib.updateIdServizio(idServizioOLD, idServizioNEW);
            } else {
                this.generatoreXML.deleteServizio(idServizioOLD);
                this.uddiLib.deleteServizio(idServizioOLD);
                this.generatoreXML.createServizio(idServizioNEW, servizio);
                this.uddiLib.createServizio(idServizioNEW, urlXML, IDAccordo.getIDAccordoFromUri(servizio.getAccordoServizio()));
            }
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante la modifica del Servizio [" + idServizioOLD_string + "] erogato dal soggetto [" + idSoggettoOLD_string + "]: " + e.getMessage(), e);
        }
    }

    private void deleteServizio_engine(ServizioSpcoop servizio) throws DriverRegistroServiziException {
        String method = "deleteServizio";
        if (servizio.getServizioCorrelato()) {
            method = method + "Correlato";
        }
        if (servizio == null) {
            throw new DriverRegistroServiziException("[" + method + "] Parametro Non Valido");
        }
        String idSoggetto_string = servizio.getTipoSoggettoErogatore() + servizio.getNomeSoggettoErogatore();
        String idServizio_string = servizio.getTipo() + servizio.getNome();
        try {
            if (servizio.getTipoSoggettoErogatore() == null || servizio.getNomeSoggettoErogatore() == null) {
                throw new DriverRegistroServiziException("Soggetto SPCoop non definito");
            }
            if (servizio.getTipo() == null || servizio.getNome() == null) {
                throw new DriverRegistroServiziException("Servizio SPCoop da eliminare non definito");
            }
            IDSoggetto idSoggetto = new IDSoggetto(servizio.getTipoSoggettoErogatore(), servizio.getNomeSoggettoErogatore());
            if (!this.uddiLib.existsSoggetto(idSoggetto)) {
                throw new DriverRegistroServiziException("Il soggetto [" + idSoggetto_string + "] non risulta gia' inserito nel registro dei servizi.");
            }
            IDServizio idServizio = new IDServizio(idSoggetto, servizio.getTipo(), servizio.getNome());
            if (!this.uddiLib.existsServizio(idServizio)) {
                throw new DriverRegistroServiziException("Il servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "] non risulta gia' registrato nel registro");
            }
            this.generatoreXML.deleteServizio(idServizio);
            this.uddiLib.deleteServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverRegistroServiziException("[" + method + "] Errore generatosi durante l'eliminazione del Servizio [" + idServizio_string + "] erogato dal soggetto [" + idSoggetto_string + "]: " + e.getMessage(), e);
        }
    }

    public void reset() throws DriverRegistroServiziException {
        Serializable idS;
        ServizioSpcoop[] serviziRegistrati;
        Serializable idInEliminazione;
        int i;
        String inEliminazione = null;
        try {
            AccordoServizio[] accordiRegistrati = this.generatoreXML.getAccordiServizio();
            if (accordiRegistrati != null) {
                for (i = 0; i < accordiRegistrati.length; ++i) {
                    idInEliminazione = IDAccordo.getIDAccordoFromAccordo(accordiRegistrati[i]);
                    this.log.info((Object)("eliminazione accordo di servizio [" + idInEliminazione + "] in corso..."));
                    if (this.existsAccordoServizio((IDAccordo)idInEliminazione)) {
                        this.deleteAccordoServizio(accordiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoServizio((IDAccordo)idInEliminazione);
                    }
                    this.log.info((Object)("eliminazione accordo di servizio [" + idInEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            AccordoCooperazione[] accordiCooperazioneRegistrati = this.generatoreXML.getAccordiCooperazione();
            if (accordiCooperazioneRegistrati != null) {
                for (i = 0; i < accordiCooperazioneRegistrati.length; ++i) {
                    idInEliminazione = IDAccordoCooperazione.getIDAccordoFromAccordo(accordiCooperazioneRegistrati[i]);
                    this.log.info((Object)("eliminazione accordo di cooperazione [" + idInEliminazione + "] in corso..."));
                    if (this.existsAccordoCooperazione((IDAccordoCooperazione)idInEliminazione)) {
                        this.deleteAccordoCooperazione(accordiCooperazioneRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteAccordoCooperazione((IDAccordoCooperazione)idInEliminazione);
                    }
                    this.log.info((Object)("eliminazione accordo di cooperazione [" + idInEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione degli accordi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            serviziRegistrati = this.generatoreXML.getServizi(false);
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    inEliminazione = serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + " erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore();
                    this.log.info((Object)("eliminazione servizio [" + inEliminazione + "] in corso..."));
                    idS = new IDServizio(serviziRegistrati[i].getTipoSoggettoErogatore(), serviziRegistrati[i].getNomeSoggettoErogatore(), serviziRegistrati[i].getTipo(), serviziRegistrati[i].getNome());
                    if (this.existsServizioSpcoop((IDServizio)idS)) {
                        this.deleteServizioSpcoop(serviziRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteServizio((IDServizio)idS);
                    }
                    this.log.info((Object)("eliminazione servizio [" + inEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            serviziRegistrati = this.generatoreXML.getServizi(true);
            if (serviziRegistrati != null) {
                for (i = 0; i < serviziRegistrati.length; ++i) {
                    inEliminazione = serviziRegistrati[i].getTipo() + "/" + serviziRegistrati[i].getNome() + "] erogato da [" + serviziRegistrati[i].getTipoSoggettoErogatore() + "/" + serviziRegistrati[i].getNomeSoggettoErogatore();
                    this.log.info((Object)("eliminazione servizio correlato [" + inEliminazione + "] in corso..."));
                    idS = new IDServizio(serviziRegistrati[i].getTipoSoggettoErogatore(), serviziRegistrati[i].getNomeSoggettoErogatore(), serviziRegistrati[i].getTipo(), serviziRegistrati[i].getNome());
                    if (this.existsServizioSpcoopCorrelato((IDServizio)idS)) {
                        this.deleteServizioSpcoopCorrelato(serviziRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteServizio((IDServizio)idS);
                    }
                    this.log.info((Object)("eliminazione servizio correlato [" + inEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei servizi registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            SoggettoSpcoop[] soggettiRegistrati = this.generatoreXML.getSoggetti();
            if (soggettiRegistrati != null) {
                for (i = 0; i < soggettiRegistrati.length; ++i) {
                    inEliminazione = soggettiRegistrati[i].getTipo() + "/" + soggettiRegistrati[i].getNome();
                    this.log.info((Object)("eliminazione soggetto [" + inEliminazione + "] in corso..."));
                    idS = new IDSoggetto(soggettiRegistrati[i].getTipo(), soggettiRegistrati[i].getNome());
                    if (this.existsSoggetto((IDSoggetto)idS)) {
                        this.deleteSoggetto(soggettiRegistrati[i]);
                    } else {
                        this.generatoreXML.deleteSoggetto((IDSoggetto)idS);
                    }
                    this.log.info((Object)("eliminazione soggetto [" + inEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione dei soggetti registrati [" + inEliminazione + "]: " + e.getMessage(), e);
        }
        try {
            PortaDominio[] pddRegistrate = this.generatoreXML.getPorteDominio();
            if (pddRegistrate != null) {
                for (i = 0; i < pddRegistrate.length; ++i) {
                    inEliminazione = pddRegistrate[i].getNome();
                    this.log.info((Object)("eliminazione porta di dominio [" + inEliminazione + "] in corso..."));
                    if (this.existsPortaDominio(inEliminazione)) {
                        this.deletePortaDominio(pddRegistrate[i]);
                    } else {
                        this.generatoreXML.deletePortaDominio(inEliminazione);
                    }
                    this.log.info((Object)("eliminazione porta di dominio [" + inEliminazione + "] effettuata."));
                }
            }
        }
        catch (Exception e) {
            this.log.info((Object)("Errore durante l'eliminazione di [" + inEliminazione + "]: " + e.getMessage()), (Throwable)e);
            throw new DriverRegistroServiziException("Errore durante la cancellazione delle porte di dominio registrate [" + inEliminazione + "]: " + e.getMessage(), e);
        }
    }

    public void isAlive() throws DriverException {
        if (!this.create) {
            throw new DriverException("Driver non inizializzato");
        }
        try {
            if (this.uddiLib.getTModel("isAliveTest", "OpenSPCoop:SPCoopIdentifier") == null) {
                throw new Exception("TModel [OpenSPCoop:SPCoopIdentifier] non trovata");
            }
        }
        catch (Exception e) {
            throw new DriverException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }
}

